#!/usr/local/bin/perl
# index.cgi
# Display a list of all local filesystems, and allow editing of quotas
# on those which have quotas turned on. The actual turning on of quotas must
# be done in the mount module first.

require './quota-lib.pl';
&header($text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("quota", "man", "howto"));
print "<hr>\n";

$err = &quotas_init();
if ($err) {
	print "<p><b>$err</b><p>\n";
	print "<hr>\n";
	&footer("/", $text{'index_return'});
	exit;
	}

@list = &list_filesystems();
if (@list) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_fs'}</b></td> <td><b>$text{'index_type'}</b></td>\n";
	print "<td><b>$text{'index_mount'}</b></td> <td><b>$text{'index_status'}</b></td>\n";
	if ($access{'enable'}) {
		print "<td><b>$text{'index_action'}</b></td> </tr>\n";
		}
	else { print "</tr>\n"; }
	foreach $f (@list) {
		$qc = $f->[4];
		$qc = $qc&1 if ($access{'gmode'} == 3);
		next if (!$qc);
		next if (!&can_edit_filesys($f->[0]));
		$qn = $f->[5];
		if ($qc == 1) { $msg = $text{'index_quser'}; }
		elsif ($qc == 2) { $msg = $text{'index_qgroup'}; }
		elsif ($qc == 3) { $msg = $text{'index_qboth'}; }
		$canactivate = 1;
		if ($qn >= 4) {
			$chg = $text{'index_mountonly'};
			$qn -= 4;
			$canactivate = 0;
			if ($qn) {
				$msg .= " $text{'index_active'}";
				}
			else {
				$msg .= " $text{'index_inactive'}";
				}
			}
		elsif ($qn) {
			$msg .= " $text{'index_active'}";
			$chg = $text{'index_disable'};
			}
		else {
			$msg .= " $text{'index_inactive'}";
			$chg = $text{'index_enable'};
			}
		if ($qn%2 == 1) { $useractive++; }
		if ($qn > 1) { $groupactive++; }

		print "<tr $cb><td>\n";
		$dir = $f->[0];
		if (!$qn) { print $dir; }
		elsif ($qc == 1)
			{ print "<a href=\"list_users.cgi?$dir+$qc\">$dir</a>";}
		elsif ($qc == 2)
			{ print"<a href=\"list_groups.cgi?$dir+$qc\">$dir</a>";}
		elsif ($qc == 3) {
			print "<a href=\"list_users.cgi?$dir+$qc\">$dir (users)</a><br>";
			print "<a href=\"list_groups.cgi?$dir+$qc\">$dir (groups)</a>";
			}
		print "</td>\n";

		print "<td valign=top>",&foreign_call("mount", "fstype_name", $f->[2]),"</td>\n";
		print "<td valign=top>",&foreign_call("mount", "device_name", $f->[1]),"</td>\n";
		print "<td valign=top>$msg</td>\n";
		if ($access{'enable'}) {
			if ($canactivate) {
				print "<td valign=top><a href=\"activate.cgi?dir=$dir&active=$qn&mode=$qc\">$chg</a></td>\n";
				}
			else {
				print "<td valign=top>$chg</td>\n";
				}
			}

		print "</tr>\n";
		}
	print "</table>\n";
	}
else { print "<b>$text{'index_nosupport'}</b>.<br>\n"; }

print "<table width=100%><tr>\n";
if ($useractive) {
	print "<form action=user_filesys.cgi>\n";
	print "<td><input type=submit value=\"$text{'index_euser'}\">\n";
	print "<input name=user size=8> ",
	      &user_chooser_button("user", 0),"</td></form>\n";
	}
else { print "<td></td>\n"; }

if ($groupactive) {
	print "<form action=group_filesys.cgi>\n";
	print "<td align=right>\n";
	print "<input type=submit value=\"$text{'index_egroup'}\">\n";
	print "<input name=group size=8> ",
	      &group_chooser_button("group", 0, $useractive ? 1 : 0),
	      "</td></form>\n";
	}
else { print "<td></td>\n"; }
print "</tr></table>\n";

print "<hr>\n";
&footer("/", $text{'index_return'});

