/*-*- Mode: C; c-basic-offset: 8; indent-tabs-mode: nil -*-*/

/***
  This file is part of systemd.

  Copyright 2010 Lennart Poettering

  systemd is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  systemd is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with systemd; If not, see <http://www.gnu.org/licenses/>.
***/

#include <stdlib.h>
#include <stdbool.h>
#include <errno.h>
#include <string.h>

#include "util.h"
#include "virt.h"

int main(int argc, char *argv[]) {
        Virtualization r;
        const char *id;

        /* This is mostly intended to be used for scripts which want
         * to detect whether we are being run in a virtualized
         * environment or not */

        r = detect_virtualization(&id);
        if (r < 0) {
                log_error("Failed to check for virtualization: %s", strerror(-r));
                return EXIT_FAILURE;
        }

        if (r > 0)
                puts(id);

        return r > 0 ? EXIT_SUCCESS : EXIT_FAILURE;
}
