
/*
 * $Id: ConfigParser.cc,v 1.2 2006/04/25 12:00:29 robertc Exp $
 *
 *
 * SQUID Web Proxy Cache          http://www.squid-cache.org/
 * ----------------------------------------------------------
 *
 *  Squid is the result of efforts by numerous individuals from
 *  the Internet community; see the CONTRIBUTORS file for full
 *  details.   Many organizations have provided support for Squid's
 *  development; see the SPONSORS file for full details.  Squid is
 *  Copyrighted (C) 2001 by the Regents of the University of
 *  California; see the COPYRIGHT file for full details.  Squid
 *  incorporates software developed and/or copyrighted by other
 *  sources; see the CREDITS file for full details.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 *
 * Copyright (c) 2003, Robert Collins <robertc@squid-cache.org>
 */

#include "ConfigParser.h"
#include "globals.h"

void
ConfigParser::destruct()
{
    shutting_down = 1;
    fatalf("Bungled %s line %d: %s",
           cfg_filename, config_lineno, config_input_line);
}

char *
ConfigParser::strtokFile(void)
{
    static int fromFile = 0;
    static FILE *wordFile = NULL;

    char *t, *fn;
    LOCAL_ARRAY(char, buf, 256);

strtok_again:

    if (!fromFile) {
        t = (strtok(NULL, w_space));

        if (!t || *t == '#') {
            return NULL;
        } else if (*t == '\"' || *t == '\'') {
            /* quote found, start reading from file */
            fn = ++t;

            while (*t && *t != '\"' && *t != '\'')
                t++;

            *t = '\0';

            if ((wordFile = fopen(fn, "r")) == NULL) {
                debug(28, 0) ("strtokFile: %s not found\n", fn);
                return (NULL);
            }

#ifdef _SQUID_WIN32_
            setmode(fileno(wordFile), O_TEXT);

#endif

            fromFile = 1;
        } else {
            return t;
        }
    }

    /* fromFile */
    if (fgets(buf, 256, wordFile) == NULL) {
        /* stop reading from file */
        fclose(wordFile);
        wordFile = NULL;
        fromFile = 0;
        goto strtok_again;
    } else {
        char *t2, *t3;
        t = buf;
        /* skip leading and trailing white space */
        t += strspn(buf, w_space);
        t2 = t + strcspn(t, w_space);
        t3 = t2 + strspn(t2, w_space);

        while (*t3 && *t3 != '#') {
            t2 = t3 + strcspn(t3, w_space);
            t3 = t2 + strspn(t2, w_space);
        }

        *t2 = '\0';
        /* skip comments */

        if (*t == '#')
            goto strtok_again;

        /* skip blank lines */
        if (!*t)
            goto strtok_again;

        return t;
    }
}

