/* # skkinput (Simple Kana-Kanji Input)
 * skkkeymap.c --- key table -> action.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * ΥϡSkkInput.c ΰǤꡢSkkInputWidget ΰǤ
 * äơȤδؿϳϷ褷ƸƤӤʤ褦 static
 */
#include "skkkey.h"

/*
 * ץȥ ( ؿ )
 */

/*
 * ơ֥򻲾Ȥ̤Υե󥯥ֹ˽äƽ¹Ԥ
 * ٤¾δؿƽФԤؿ
 */
static int do_skkinputFunction
( Widget gw, struct SKKInputNode *node,	int func_no )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  int chara = w->skkinput.keybuf[ 0 ] ;

  /* ȡΥåХåե˽񤫤Ƥ *
   * Ͼä뤳ȤˤʤäƤ롩 */
  node->mtextbuffer[ 0 ] = '\0' ;

  /* 䴰ײλ뤫ɤ*/
  if( node->j_completion_mode ){
    if( func_no != FUNCNO_J_INSERT_PERIOD &&
	func_no != FUNCNO_J_INSERT_COMMA  &&
	func_no != FUNCNO_J_ABBREV_PERIOD &&
	func_no != FUNCNO_J_ABBREV_COMMA  ){
      XtCallCallbacks( gw, XtNjcompletioncloseNotify, node ) ;
    }
  }
  /* Ϳ줿̿ФԤ*/
  switch( func_no ){
  case FUNCNO_J_PREFIX_CHAR :
  case FUNCNO_J_SENDBACK_KEY :
    j_delete_kanaprefix( node ) ;
    /* ֢ΥХåեʤСC- Ȥɽ롣*/
    if( node == ( w->skkinput ).topbuffer ){
      strcpy( node->mtextbuffer,
	     charaToString( w->skkinput.keybuf[ 0 ] ) ) ;
      strcat( node->mtextbuffer, "-" ) ;
    }
    return SIW_PROCESSING ;
  case FUNCNO_SELF_INSERT_CHARACTER :
    j_insert_chara( node, node->cur_pos, chara ) ;
    break ;
  case FUNCNO_J_SELF_INSERT :
    j_self_insert( gw, node, chara ) ;
    break ;
  case FUNCNO_J_SELF_ZENKAKU_INSERT :
    j_insert_zenkaku( gw, node, node->cur_pos, chara ) ;
    break ;
  case FUNCNO_J_DISPLAY_CODE_FOR_CHAR_AT_POINT :
    j_display_code_for_char_at_point( node ) ;
    break ;
  case FUNCNO_J_SET_HENKAN_POINT :
    /* Ѵϰ֤ꤵ롣*/
    j_set_henkan_point( gw, node, chara ) ;
    break ;
  case FUNCNO_J_SET_HENKAN_POINT_SUBR :
    j_set_henkan_point_subr( gw, node, chara ) ; 
    break ;
    /* 첻ϡ*/
  case FUNCNO_J_INSERT_A :
    j_insert_a( gw, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_E :
    j_insert_e( gw, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_I :
    j_insert_i( gw, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_O :
    j_insert_o( gw, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_U :
    j_insert_u( gw, node, chara ) ;
    break ;
    /* ̾Ϥγϥ( ҲǤ )*/
  case FUNCNO_J_KANA_INPUT :
    j_kana_input( gw, node, chara ) ;
    break ;
  case FUNCNO_J_START_HENKAN :
    j_start_henkan( gw, node ) ;
    break ;
  case FUNCNO_J_INSERT_COMMA :
    j_insert_comma( gw, node ) ;
    break ;
  case FUNCNO_J_INSERT_PERIOD :
    j_insert_period( gw, node ) ;
    break ;
  case FUNCNO_J_PURGE_FROM_JISYO :
    j_purge_from_jisyo( gw, node ) ;
    break ;
  case FUNCNO_J_INPUT_BY_CODE_OR_MENU :
    j_input_by_code_or_menu_start( gw, node ) ;
    break ;
  case FUNCNO_J_MODE_OFF :
    j_mode_off( gw, node, chara ) ; /* Ϻƹͤ;Ϥꡣ˽롣*/
    break ;
  case FUNCNO_J_TOGGLE_KANA :
    /* ̾⡼ɤҲ̾⡼ɤڤؤ*/
    j_toggle_kana( gw, node, False, chara ) ;
    break ;
  case FUNCNO_J_PREVIOUS_CANDIDATE :
    j_previous_candidate( gw, node ) ;
    break ;
  case FUNCNO_J_KAKUTEI :
    if( j_kakutei_kana_mode( gw, node, chara ) )
      break ;
    j_kakutei( gw, node ) ;
    break ;
  case FUNCNO_J_ABBREV_INPUT :
    j_abbrev_input( gw, node, chara ) ;
    break ;
  case FUNCNO_J_ABBREV_PERIOD :
    j_abbrev_period( gw, node ) ;
    break ;
  case FUNCNO_J_ABBREV_COMMA :
    j_abbrev_comma( gw, node ) ;
    break ;
  case FUNCNO_J_ZENKAKU_EIJI :
    /* (Ѥܸ)ѻϥ⡼ɤˤ롣*/
    j_zenkaku_eiji( gw, node, chara ) ; 
    break ;
  case FUNCNO_J_ZENKAKU_HENKAN :
    j_zenkaku_henkan( gw, node ) ;
    break ;
  case FUNCNO_J_TODAY :
    /* դνϡ*/
    j_today( gw, node ) ;
    break ;
  case FUNCNO_J_KANAINPUT_MODE_ON :
    j_kanainput_mode_on( gw, node ) ;
    break ;
  case FUNCNO_J_SET_MARK_COMMAND :
    j_set_mark_command( node ) ;
    break ;
  case FUNCNO_J_NEWLINE :
    j_newline( gw, node ) ;
    break ;
  case FUNCNO_J_FORWARD_CHAR :
    j_forward_char( node ) ;
    break ;
  case FUNCNO_J_BACKWARD_CHAR :
    j_backward_char( node ) ;
    break ;
  case FUNCNO_J_DELETE_CHAR :
    j_delete_char( node ) ;
    break ;
  case FUNCNO_J_DELETE_BACKWARD_CHAR :
    j_backward_delete_char( gw, node ) ;
    break ;
  case FUNCNO_J_TRY_COMPLETION :
    j_try_completion( gw, node ) ;
    break ;
  case FUNCNO_J_END_OF_LINE :
    j_end_of_line( node ) ;
    break ;
  case FUNCNO_J_BEGINNING_OF_LINE :
    j_beginning_of_line( node ) ;
    break ;
  case FUNCNO_J_KILL_LINE :
    j_kill_line( gw, node ) ;
    break ;
  case FUNCNO_J_KILL_REGION :
    j_kill_region( gw, node ) ;
    break ;
  case FUNCNO_J_KILL_RING_SAVE :
    j_kill_ring_save( gw, node ) ;
    break ;
  case FUNCNO_J_EXCHANGE_POINT_AND_MARK :
    j_exchange_point_and_mark( node ) ;
    break ;
  case FUNCNO_J_YANK :
    j_yank( gw, node ) ;
    break ;
  case FUNCNO_J_PREVIOUS_LINE :
    j_previous_line( gw, node ) ;
    break ;
  case FUNCNO_J_NEXT_LINE :
    j_next_line( gw, node ) ;
    break ;
  case FUNCNO_J_TRANSPOSE_CHARS :
    j_transpose_chars( node ) ;
    break ;
  case FUNCNO_J_REDRAW :
    /* öե褹롣ʬǤϤʤơ*/
    skkinput_RedrawScreen( gw ) ;
#if 0
    /* minibuffer Υ顼ʸõ롣*/
    node->mtextbuffer[ 0 ] = '\0' ;
#endif
    break ;
  case FUNCNO_J_KEYBOARD_QUIT :
    j_keyboard_quit( gw, node ) ;
    break ;
  case FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO :
    j_delete_kanaprefix( node ) ;
    /* 񤬹Ƥ뤫ɤȽꤹ롣*/
    if( w->skkinput.jisyo_dirty ){
      strcpy( node->mtextbuffer, "Saving Jisyo..." ) ;
      skkinput_DrawScreen( gw ) ;
      XFlush( XtDisplay( gw ) ) ;
      /* ι򤹤륳ХåƽФ*/
      XtCallCallbacks( gw, XtNjsavejisyoNotify, NULL ) ;
      
      strcat( node->mtextbuffer, "done" ) ;
    } else {
      err_msg( node, "(No changes need to be saved)" ) ;
    }
    break ;
  case FUNCNO_CLOSE_SKKINPUT :
    w->skkinput.will_be_destroyed = True ;
    return SIW_DESTROYED ;
  case FUNCNO_VC_TOGGLE_CHATMODE :
    j_delete_kanaprefix( node ) ;
    w->skkinput.chat_adapter =
      ( w->skkinput.chat_adapter )? False : True ;
    break ;
  case FUNCNO_VC_TOGGLE_EGGNL :
    j_delete_kanaprefix( node ) ;
    w->skkinput.egg_like_newline =
      ( w->skkinput.egg_like_newline )? False : True ;
    break ;
  case FUNCNO_NOT_MODIFIED :
    j_delete_kanaprefix( node ) ;
    XtCallCallbacks( gw, XtNnotmodifiedNotify, NULL ) ;
    strcpy( node->mtextbuffer, "Modification-flag cleared" ) ;
    break ;
  case FUNCNO_J_FORWARD_WORD :
    j_forward_word( node ) ;
    break ;
  case FUNCNO_J_BACKWARD_WORD :
    j_backward_word( node ) ;
    break ;
  case FUNCNO_J_UPCASE_WORD :
    j_caseword( node, 'u' ) ;
    break ;
  case FUNCNO_J_DOWNCASE_WORD :
    j_caseword( node, 'd' ) ;
    break ;
  case FUNCNO_J_CAPITALIZE_WORD :
    j_caseword( node, 'c' ) ;
    break ;
  case FUNCNO_INVALID_CHAR :
  default :
#if 0
    XBell( XtDisplay( gw ), 5 ) ;
#endif
    break ;
  }
  w->skkinput.keybuf_use  = 0 ;
  w->skkinput.keybuf[ 0 ] = '\0' ;

  return SIW_PROCESSING ;
}

/*
 * ơ֥򻲾Ȥؿ
 */
static int lookup_at_keymap( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  int func_no ;

  /* ꤵ줿ϰʸǤʤСѲ롣*/
  if( w->skkinput.keybuf[ 0 ] & ~0x7F ){
    func_no = FUNCNO_INVALID_CHAR ;
  } else {
    /* ̾ϥ⡼ɤʤΤǤ礦 */
    if( !node->j_mode ){
      /* ̾ϥ⡼ɤʤǤ*/
      /* Ϥ줿Τϥȥ륳ɤǤ */
      if( w->skkinput.keybuf[ 0 ] < 0x20 || w->skkinput.keybuf[ 0 ] == 0x7F ){
	func_no = w->skkinput.skkmap[ w->skkinput.keybuf[ 0 ] ] ;
      } else {
	/* ȥ륳ɤǤϤޤǤ*/
	func_no = ( node->j_zenkaku )? FUNCNO_J_SELF_ZENKAKU_INSERT :
	  FUNCNO_SELF_INSERT_CHARACTER ;
      }
    } else if( node->j_abbrev && !node->j_henkan_on ){
      func_no = w->skkinput.abbrevmap[ w->skkinput.keybuf[ 0 ] ] ;
    } else {
      func_no = w->skkinput.skkmap[ w->skkinput.keybuf[ 0 ] ] ;
    }
  }
  return func_no ;
}

/*
 * ĤξνԤؿ
 */
static int do_function_by_onekey
( Widget gw, struct SKKInputNode *node )
{
#if 0
  SkkInputWidget w = ( SkkInputWidget )gw ;
#endif
  int func_no ;

  /* Ѵθ⡼ɤʤΤǤ */
  if( node->j_henkan_show_candidate_mode ){
    /* ɤʥäϤͤȤäɡĤޤΥ⡼*
     * ɤФäƤ뤫פʡ */
    do_Function_jhenkanShowCandidateMode( gw, node ) ;
    return SIW_PROCESSING ;
  } else if( node->j_input_by_code_or_menu_mode ){
    if( node->j_input_by_code_or_menu_mode == True ){
      do_function_j_input_by_code_or_menu_jump( gw, node ) ;
      return SIW_PROCESSING ; 
    } else {
      do_function_j_input_by_code_or_menu_1_jump( gw, node ) ;
      return SIW_PROCESSING ; 
    }
  }
  /* Ϥ줿ǽʸ򸫤ơĵǽʤǤäФ*/
  func_no = lookup_at_keymap( gw, node ) ;

  /* 
   * ¿ʬʳ skk-rom-kana-rule-list åʤȤ
   * ǤʤХȥ륳ɤǤ⤽줬ȤȤȤ
   * Ϥʤʤ顣
   */
  switch( func_no ){
  case FUNCNO_J_INSERT_A :
  case FUNCNO_J_INSERT_E :
  case FUNCNO_J_INSERT_I :
  case FUNCNO_J_INSERT_O :
  case FUNCNO_J_INSERT_U :
  case FUNCNO_J_KANA_INPUT :
  case FUNCNO_J_SET_HENKAN_POINT :
    break ;
  default :
    /* ̾Ϥäꤷˤϡ⤷   *
     * rom-kana-rule-list ˥ҥåȤꤹ뤫⤷ʤ*/
    if( node->j_kana_mode ){
      if( rom_kana_rule_list_check
	 ( gw, node, ( ( SkkInputWidget )gw )->skkinput.keybuf[ 0 ] ) ){
	if( node->j_henkan_mode && !node->j_henkan_on &&
	   node->j_okurigana_mode ){
	  j_set_okurigana( gw, node, node->j_okuri_chara ) ;
	}
	( ( SkkInputWidget )gw )->skkinput.keybuf_use  = 0 ;
	( ( SkkInputWidget )gw )->skkinput.keybuf[ 0 ] = '\0' ;
	return SIW_PROCESSING ;
      }
    }
    break ;
  }
  /* Ϳ줿ǽ¹פޤ*/
  return do_skkinputFunction( gw, node, func_no ) ;
}

/*
 * ĤξνԤؿ
 */
static int do_function_by_twokeys
( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  struct skkinputTwoKeys *key = w->skkinput.twokeymap ;

  /* ȡΥåХåե˽񤫤Ƥ *
   * Ͼä뤳ȤˤʤäƤ롩 */
  node->mtextbuffer[ 0 ] = '\0' ;

  /* Ϥ줿Ϥ⤷ơ */
  if( lookup_at_keymap( gw, node ) == FUNCNO_J_SENDBACK_KEY ){
    SKIW_SendbackKeyPress( gw ) ;
  } else {
    /* ơ֥ܤʣξϤʤ *
     * õʤƴŤȤޤ*/
    while( key->chara != NULL ){
      /* ƱΥƤ¸ߤнȴ롣*/
      if( key->chara[ 0 ] == w->skkinput.keybuf[ 0 ] &&
	  key->chara[ 1 ] == w->skkinput.keybuf[ 1 ] ){
	return do_skkinputFunction( gw, node, key->function_no ) ;
      }
      key ++ ;
    }
  }
  /* ʾʸФʤΤǡľ*/
  w->skkinput.keybuf[ 0 ] = '\0' ;
  w->skkinput.keybuf_use  = 0 ;
  return SIW_PROCESSING ;
}

/*
 * Ϥ줿ʸ󤫤餽б뵡ǽ¹Ԥؿ
 */
static int do_function_by_reading_character
( Widget gw, struct SKKInputNode *node )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;

  /* ߥä顢Ѳ롣*/
  if( w->skkinput.skkmap == NULL || w->skkinput.abbrevmap == NULL )
    return SIW_PROCESSING ;

#ifdef DEBUG
  fprintf( stderr, "j-prefix : %s\n", node->j_prefix ) ;
#endif

  switch( w->skkinput.keybuf_use ){
    /* ХϤФ*/
  case 1:
    return do_function_by_onekey( gw, node ) ;
    /* ʣХȤΥϤФ*/
  case 2:
    if( w->skkinput.twokeymap == NULL )
      break ;
    return do_function_by_twokeys( gw, node ) ;
    /* ꤨʤϤФ*/
  case 0 :
  default :
    w->skkinput.keybuf_use  = 0 ;
    w->skkinput.keybuf[ 0 ] = '\0' ;
    break ;
  }
  return SIW_PROCESSING ;
}
