# Summary

- [About this guide](./about-this-guide.md)
- [About the compiler team](./compiler-team.md)
- [How to build the compiler and run what you built](./how-to-build-and-run.md)
    - [Build and Install distribution artifacts](./build-install-distribution-artifacts.md)
    - [Documenting Compiler](./compiler-documenting.md)
- [Coding conventions](./conventions.md)
- [Walkthrough: a typical contribution](./walkthrough.md)
- [The compiler testing framework](./tests/intro.md)
    - [Running tests](./tests/running.md)
    - [Adding new tests](./tests/adding.md)
    - [Using `compiletest` + commands to control test
      execution](./compiletest.md)
- [Debugging the Compiler](./compiler-debugging.md)
- [Profiling the compiler](./profiling.md)
    - [with the linux perf tool](./profiling/with_perf.md)
- [High-level overview of the compiler source](./high-level-overview.md)
- [The Rustc Driver](./rustc-driver.md)
    - [Rustdoc](./rustdoc.md)
- [Queries: demand-driven compilation](./query.md)
    - [Incremental compilation](./incremental-compilation.md)
    - [Debugging and Testing](./incrcomp-debugging.md)
- [The parser](./the-parser.md)
- [`#[test]` Implementation](./test-implementation.md)
- [Macro expansion](./macro-expansion.md)
- [Name resolution](./name-resolution.md)
- [The HIR (High-level IR)](./hir.md)
    - [Lowering AST to HIR](./lowering.md)
- [The `ty` module: representing types](./ty.md)
- [Type inference](./type-inference.md)
- [Trait solving (old-style)](./traits/resolution.md)
    - [Higher-ranked trait bounds](./traits/hrtb.md)
    - [Caching subtleties](./traits/caching.md)
    - [Specialization](./traits/specialization.md)
- [Trait solving (new-style)](./traits/index.md)
    - [Lowering to logic](./traits/lowering-to-logic.md)
      - [Goals and clauses](./traits/goals-and-clauses.md)
      - [Equality and associated types](./traits/associated-types.md)
      - [Implied bounds](./traits/implied-bounds.md)
      - [Region constraints](./traits/regions.md)
      - [The lowering module in rustc](./traits/lowering-module.md)
      - [Lowering rules](./traits/lowering-rules.md)
      - [Well-formedness checking](./traits/wf.md)
    - [Canonical queries](./traits/canonical-queries.md)
      - [Canonicalization](./traits/canonicalization.md)
    - [The SLG solver](./traits/slg.md)
    - [An Overview of Chalk](./traits/chalk-overview.md)
    - [Bibliography](./traits/bibliography.md)
- [Type checking](./type-checking.md)
    - [Method Lookup](./method-lookup.md)
    - [Variance](./variance.md)
    - [Existential Types](./existential-types.md)
- [The MIR (Mid-level IR)](./mir/index.md)
    - [MIR construction](./mir/construction.md)
    - [MIR visitor and traversal](./mir/visitor.md)
    - [MIR passes: getting the MIR for a function](./mir/passes.md)
    - [MIR optimizations](./mir/optimizations.md)
- [The borrow checker](./borrow_check.md)
    - [Tracking moves and initialization](./borrow_check/moves_and_initialization.md)
      - [Move paths](./borrow_check/moves_and_initialization/move_paths.md)
    - [MIR type checker](./borrow_check/type_check.md)
    - [Region inference](./borrow_check/region_inference.md)
- [Constant evaluation](./const-eval.md)
    - [miri const evaluator](./miri.md)
- [Parameter Environments](./param_env.md)
- [Code Generation](./codegen.md)
- [Emitting Diagnostics](./diag.md)

---

- [Appendix A: Stupid Stats](./appendix/stupid-stats.md)
- [Appendix B: Background material](./appendix/background.md)
- [Appendix C: Glossary](./appendix/glossary.md)
- [Appendix D: Code Index](./appendix/code-index.md)
