# The Edition Guide

[Introduction](introduction.md)

## What are editions?

- [What are editions?](editions/index.md)
  - [Creating a new project](editions/creating-a-new-project.md)
  - [Transitioning an existing project to a new edition](editions/transitioning-an-existing-project-to-a-new-edition.md)

## Rust 2015

- [Rust 2015](rust-2015/index.md)

## Rust 2018

- [Rust 2018](rust-2018/index.md)
    - [Module system](rust-2018/module-system/index.md)
      - [Raw identifiers](rust-2018/module-system/raw-identifiers.md)
      - [Path clarity](rust-2018/module-system/path-clarity.md)
      - [More visibility modifiers](rust-2018/module-system/more-visibility-modifiers.md)
      - [Nested imports with `use`](rust-2018/module-system/nested-imports-with-use.md)
    - [Error handling and panics](rust-2018/error-handling-and-panics/index.md)
      - [The `?` operator for easier error handling](rust-2018/error-handling-and-panics/the-question-mark-operator-for-easier-error-handling.md)
      - [`?` in `main` and tests](rust-2018/error-handling-and-panics/question-mark-in-main-and-tests.md)
      - [Controlling panics with `std::panic`](rust-2018/error-handling-and-panics/controlling-panics-with-std-panic.md)
      - [Aborting on panic](rust-2018/error-handling-and-panics/aborting-on-panic.md)
    - [Control flow](rust-2018/control-flow/index.md)
      - [Loops can `break` with a value](rust-2018/control-flow/loops-can-break-with-a-value.md)
      - [`async`/`await` for easier concurrency](rust-2018/control-flow/async-await-for-easier-concurrency.md)
    - [Trait system](rust-2018/trait-system/index.md)
      - [`impl Trait` for returning complex types with ease](rust-2018/trait-system/impl-trait-for-returning-complex-types-with-ease.md)
      - [`dyn Trait` for trait objects](rust-2018/trait-system/dyn-trait-for-trait-objects.md)
      - [More container types support trait objects](rust-2018/trait-system/more-container-types-support-trait-objects.md)
      - [Associated constants](rust-2018/trait-system/associated-constants.md)
      - [No more anonymous parameters](rust-2018/trait-system/no-anon-params.md)
    - [Slice patterns](rust-2018/slice-patterns.md)
    - [Ownership and lifetimes](rust-2018/ownership-and-lifetimes/index.md)
      - [Non-lexical lifetimes](rust-2018/ownership-and-lifetimes/non-lexical-lifetimes.md)
      - [Default `match` bindings](rust-2018/ownership-and-lifetimes/default-match-bindings.md)
      - [`'_`, the anonymous lifetime](rust-2018/ownership-and-lifetimes/the-anonymous-lifetime.md)
      - [Lifetime elision in `impl`](rust-2018/ownership-and-lifetimes/lifetime-elision-in-impl.md)
      - [`T: 'a` inference in structs](rust-2018/ownership-and-lifetimes/inference-in-structs.md)
      - [Simpler lifetimes in `static` and `const`](rust-2018/ownership-and-lifetimes/simpler-lifetimes-in-static-and-const.md)
    - [Data types](rust-2018/data-types/index.md)
      - [Field init shorthand](rust-2018/data-types/field-init-shorthand.md)
      - [`..=` for inclusive ranges](rust-2018/data-types/inclusive-ranges.md)
      - [128 bit integers](rust-2018/data-types/128-bit-integers.md)
      - ["Operator-equals" are now implementable](rust-2018/data-types/operator-equals-are-now-implementable.md)
      - [`union` for an unsafe form of `enum`](rust-2018/data-types/union-for-an-unsafe-form-of-enum.md)
      - [Choosing alignment with the `repr` attribute](rust-2018/data-types/choosing-alignment-with-the-repr-attribute.md)
    - [SIMD for faster computing](rust-2018/simd-for-faster-computing.md)
    - [Macros](rust-2018/macros/index.md)
      - [Custom Derive](rust-2018/macros/custom-derive.md)
      - [Macro changes](rust-2018/macros/macro-changes.md)
      - [At most one repetition](rust-2018/macros/at-most-once.md)
    - [The compiler](rust-2018/the-compiler/index.md)
      - [Improved error messages](rust-2018/the-compiler/improved-error-messages.md)
      - [Incremental Compilation for faster compiles](rust-2018/the-compiler/incremental-compilation-for-faster-compiles.md)
      - [An attribute for deprecation](rust-2018/the-compiler/an-attribute-for-deprecation.md)
    - [Rustup for managing Rust versions](rust-2018/rustup-for-managing-rust-versions.md)
    - [Cargo and crates.io](rust-2018/cargo-and-crates-io/index.md)
      - [`cargo check` for faster checking](rust-2018/cargo-and-crates-io/cargo-check-for-faster-checking.md)
      - [`cargo install` for easy installation of tools](rust-2018/cargo-and-crates-io/cargo-install-for-easy-installation-of-tools.md)
      - [`cargo new` defaults to a binary project](rust-2018/cargo-and-crates-io/cargo-new-defaults-to-a-binary-project.md)
      - [`cargo rustc` for passing arbitrary flags to `rustc`](rust-2018/cargo-and-crates-io/cargo-rustc-for-passing-arbitrary-flags-to-rustc.md)
      - [Cargo workspaces for multi-package projects](rust-2018/cargo-and-crates-io/cargo-workspaces-for-multi-package-projects.md)
      - [Multi-file `examples`](rust-2018/cargo-and-crates-io/multi-file-examples.md)
      - [Replacing dependencies with `patch`](rust-2018/cargo-and-crates-io/replacing-dependencies-with-patch.md)
      - [Cargo can use a local registry replacement](rust-2018/cargo-and-crates-io/cargo-can-use-a-local-registry-replacement.md)
      - [Crates.io disallows wildcard dependencies](rust-2018/cargo-and-crates-io/crates-io-disallows-wildcard-dependencies.md)
    - [Documentation](rust-2018/documentation/index.md)
      - [New editions of the "the book"](rust-2018/documentation/new-editions-of-the-book.md)
      - [The Rust Bookshelf](rust-2018/documentation/the-rust-bookshelf.md)
      - [The Rustonomicon](rust-2018/documentation/the-rustonomicon.md)
      - [Full documentation for `std::os`](rust-2018/documentation/std-os-has-documentation-for-all-platforms.md)
    - [`rustdoc`](rust-2018/rustdoc/index.md)
      - [Documentation tests can now `compile-fail`](rust-2018/rustdoc/documentation-tests-can-now-compile-fail.md)
      - [Rustdoc uses CommonMark](rust-2018/rustdoc/rustdoc-uses-commonmark.md)
    - [Platform and target support](rust-2018/platform-and-target-support/index.md)
      - [`libcore` for low-level Rust](rust-2018/platform-and-target-support/libcore-for-low-level-rust.md)
      - [WebAssembly support](rust-2018/platform-and-target-support/webassembly-support.md)
      - [Global allocators](rust-2018/platform-and-target-support/global-allocators.md)
      - [MSVC toolchain support](rust-2018/platform-and-target-support/msvc-toolchain-support.md)
      - [MUSL support for fully static binaries](rust-2018/platform-and-target-support/musl-support-for-fully-static-binaries.md)
      - [`cdylib` crates for C interoperability](rust-2018/platform-and-target-support/cdylib-crates-for-c-interoperability.md)