#
#
#
#

bind Popup <ButtonPress> {
    set popup(button_press) 1
}

bind Popup <ButtonRelease> {
    if {!$popup(button_press)} {
	return
    }
    popup:activate @%x,%y
    popup:invoke
}

bind Popup <Motion> {
    set popup(button_press) 1
    popup:activate @%x,%y
}

bind Popup <Up> {
    popup:up_down -1 [$popup(menu) index last] 0
}

bind Popup <Down> {
    popup:up_down 1 0 [$popup(menu) index last]
}

bind Popup <Return> {
    popup:invoke
}

bind Popup <Escape> {
    popup:unpost
}

bind Popup <Key> {
    popup:traverse %A
}

proc popup:activate {index} {
    global popup
    $popup(menu) activate $index
}

proc popup:up_down {step floor ceil} {
    global popup

    set m $popup(menu)
    set a [$m index active]

    if {$a == "none" || $a == $ceil} {
	set a $floor
    } else {
	incr a $step
    }
    while {$a != $ceil} {
	set type [$m type $a]
	if {$type != "separator"} {
	    break
	}
	incr a $step
    }
    popup:activate $a
}

proc popup:unpost {} {
    global popup

    grab release $popup(menu)
    $popup(menu) unpost

    if {$popup(prev_focus) != ""} {
	focus $popup(prev_focus)
    }
    set popup(menu) {}
    set popup(button_press) 0
    set popup(prev_focus) {}
}

proc popup:invoke {} {
    global popup

    set menu $popup(menu)
    set index [$menu index active]

    event generate $menu <<MenuSelect>>
    popup:unpost
    $menu invoke $index
}

proc popup:traverse {char} {
    global popup

    set menu $popup(menu)
    set char [string tolower $char]
    set last [$menu index last]

    if {$last == "none"} {
	return
    }
    for {set i 0} {$i <= $last} {incr i} {
	if [catch {set c [string index [$menu entrycget $i -label] \
			      [$menu entrycget $i -underline]]}] {
	    return
	}
	if {$char == [string tolower $c]} {
	    popup:activate $i
	    popup:invoke
	    return
	}
    }
}

proc Popup:Post {menu x y} {
    global popup

    if {$menu == ""} {
	return
    }
    set popup(menu) $menu
    set popup(button_press) 0
    set popup(prev_focus) [focus]
    if {$popup(prev_focus) == ""} {
	set w [winfo toplevel [winfo parent $menu]]
	focus $w
	set popup(prev_focus) $w
    }
    $menu post $x $y
    focus $menu
    grab -global $menu
}

proc Popup {menu args} {
    eval menu $menu $args

    bindtags $menu [list $menu Popup all]
}
