#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <config.h>

#include <support.h>
#include <xcio.h>

/*
#define	DEBUG
*/

#ifdef	DEBUG
FILE *debugfp;
#undef	HTMLDIR
#define	HTMLDIR	"/home/work/PPXP/ppxp/console/inetd/html"
#endif

#define	NOT_YET	4096

static int ppxpNum=-1;
static char *remoteName;

int
HttpdFd()
{
    static int ppxpFd=NOT_YET;

    if (ppxpFd == NOT_YET) {
	struct xcio_s hello;
	uid_t uid;

	ppxpFd = PPxPLocalOpen(&ppxpNum);
	if (ppxpFd < 0) exit(-1);
	hello.type = XCIO_HELLO;
	sprintf(hello.buf, "http (%s)", remoteName);
	hello.len = strlen(hello.buf) + 1;
	uid = getuid();
	memcpy(hello.buf + hello.len, &uid, sizeof(uid));
	hello.len += sizeof(uid);
	write(ppxpFd, &hello, sizeof(hello));
	XcioOpen(ppxpFd);
    }
    return(ppxpFd);
}

static void
HttpdGet(char *path, bool_t quick)
{
    char buf[BUFSIZ], *p, *label;
    int n, fd=-1;
    FILE *fp;
    /*    struct stat sb;*/

    sprintf(buf, HTMLDIR"/%s", path);
    if (!*path || *(path + strlen(path) - 1) == '/') {
	if (quick) strcat(buf, "quick.html");
	else strcat(buf, "index.html");
    }
    if ((fp = fopen(buf, "r")) == NULL) {
	if (!strcmp(path, "quickmain")) QuickMain();
	else if (!strcmp(path, "quicktitle")) QuickTitle();
	else printf("buggy!!!(%s)\n", buf);
    } else {
	if (!strstr(path, ".htm")) {
	    do {
		n = fread(buf, 1, sizeof(buf), fp);
		fwrite(buf, 1, n, stdout);
	    } while (n > 0);
	} else {
	    while (fgets(buf, sizeof(buf), fp)) {
		if ((p = strstr(buf, "\"@")) != NULL) {
		    u_int8_t xid;

		    p ++;
		    *p = '\0';
		    printf(buf);
		    p ++;
		    label = p;
		    while (*p != '"') p ++;
		    *p = '\0';
		    if (fd < 0) fd = HttpdFd();
		    xid = PPxPEnvRequestv(fd, label, NULL);
		    printf("%s\"%s", PPxPEnvGet(fd, xid), p + 1);
		} else printf(buf);
	    }
	}
    }
    fflush(stdout);
    fclose(fp);
}

static void
HttpdPost(char *path, bool_t quick)
{
    int n;
    char buf[BUFSIZ], *p;

    while (fgets(buf, sizeof(buf), stdin)) {
	if ((p = strpbrk(buf, "\r\n")) != NULL) *p = '\0';
	if (!buf[0]) break;
    }
    fgets(buf, sizeof(buf), stdin);
    n = PostRead(buf);
    HttpdGet(path, quick);
}

static struct htmlcmd_s {
    const char *name;
    void (*run)();
} htmlCmd[]={
    {"GET", HttpdGet},
    {"POST", HttpdPost},
};

void
HttpdMain(char *name, char ch)
{
    int n, fd;
    unsigned i;
    bool_t quick;
    char buf[128], *p, *w, *path;

    buf[0] = ch;

    fgets(&buf[1], sizeof(buf) - 1, stdin);
    if ((p = strpbrk(buf, "\r\n")) != NULL) *p = '\0';
    if ((p = index(buf, ' ')) == NULL) return;
    *p = '\0'; p ++;
    if (*p != '/') return;
    p ++;

    remoteName = name;
    ppxpNum = -1;
    quick = FALSE;
    if ((w = strpbrk(p, "/ ")) != NULL) {
	if (*w == '/') {
	    *w = '\0'; w ++;
	} else *w = '\0';
	if (isdigit(*p))
	    ppxpNum = atoi(p);
	else
	    ppxpNum = GetIfNum(p);
    }
    if (ppxpNum < 0) {
	w = p;
	quick = TRUE;
    }

    for (i = 0; i < sizeof(htmlCmd)/sizeof(htmlCmd[0]); i ++) {
	if (!strcasecmp(buf, htmlCmd[i].name)) {
	    if ((p = index(w, ' ')) != NULL) *p = '\0';
	    path = Strdup(w);
	    htmlCmd[i].run(path, quick);
	    Free(path);
	    break;
	}
    }
    /*	hello.type = XCIO_HELLO;*/
}
