#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <config.h>
#include <support.h>
#include <osdep.h>

#include "log.h"
/*#include "command.h"*/
#include "ipsupport.h"
#include "ipap.h"
#include "ipcp.h"

int
FtpInput(tcp_hdr *tcphp)
{
    return(0);
}

int
FtpOutput(struct ipfilter_s *ctrl, ipv4_hdr *iphp, int len)
{
    tcp_hdr *tcphp=(tcp_hdr *)((u_char *)iphp + (iphp->ip_hl << 2));
    u_char *sp, *ep;

    sp = (u_char *)tcphp + (tcphp->th_off << 2);
    ep = (u_char *)iphp + len;
    if ((sp + 17) < ep && !strncmp(sp, "PORT ", 5)) {
	unsigned int h1, h2, h3, h4, p1, p2;
	u_int16_t port=ntohs(ProxyNboPort(TRUE));
	u_char addr[4], *bp;

	bp = sp + 5;
	sscanf(bp, "%d,%d,%d,%d,%d,%d", &h1, &h2, &h3, &h4, &p1, &p2);
	memcpy(addr, &(iphp->ip_src.s_addr), sizeof(u_int32_t));
	bp += SprintF(bp, "%d,%d,%d,%d,%d,%d\r\n",
		      addr[0], addr[1], addr[2], addr[3],
		      port >> 8, port & 0xFF);
	IpXFilterPairAdd(ctrl, htonl((h1<<24)|(h2<<16)|(h3<<8)|h4),
			 iphp->ip_dst.s_addr, iphp->ip_src.s_addr,
			 htons(p1 << 8 | p2),
			 htons(ntohs(tcphp->th_dport) - 1), htons(port),
			 IPPROTO_TCP, IPFF_AUTO);
	return(bp - ep);
    }
    return(0);
}
