<?php
/*=================================================
   charset=utf-8
   Project:	PhpGedView
   File:	lang.sk.php
   Author:	John Finlay
   Comments:	Slovak Language file for PhpGedView
   Translation:	Peter Moravčík
   Change Log:	See LANG_CHANGELOG.txt
===================================================*/
# $Id: lang.sk.php,v 1.1.2.4 2006/09/20 01:33:42 canajun2eh Exp $
if (preg_match("/lang\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "Nemáte priamy prístup k súboru so slovenčinou.";
	exit;
}

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]			= "?";
$pgv_lang["page_help"]			= "Nápoveda";
$pgv_lang["help_for_this_page"]		= "Nápoveda k tejto stránke";
$pgv_lang["help_contents"]		= "Obsah nápovedy";
$pgv_lang["show_context_help"]		= "Zobraziť kontextovú nápovedu";
$pgv_lang["hide_context_help"]		= "Skryť kontextovú nápovedu";
$pgv_lang["sorry"]			= "<b>Nápoveda k tejto stránke či položke ešte nebola dokončená</b>";
$pgv_lang["help_not_exist"]		= "<b>Nápoveda k tejto stránke či položke zatiaľ nie je k dispozícii</b>";
$pgv_lang["var_not_exist"]		= "<span style=font-weight: bold>Jazyková premenná neexistuje. Prosím ohláste to ako chybu programu.</span>";
$pgv_lang["resolution"]			= "Rozlíšenie obrazovky";
$pgv_lang["menu"]			= "Menu";
$pgv_lang["header"]			= "Záhlavie";
$pgv_lang["imageview"]			= "Prehliadač obrázkov";
$pgv_lang["login_head"]			= "Prihlásenie uživateľa PhpGedView";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "CHYBA: Nie je možné otvoriť súbor GEDCOM";
$pgv_lang["error_header"] 		= "Súbor GEDCOM, [#GEDCOM#], nie je na zadanom mieste.";
$pgv_lang["error_header_write"]		= "Do súboru GEDCOM [#GEDCOM#] sa nedá zapisovať. Skontrolujte vlastnosti a prístupové práva súboru.";
$pgv_lang["for_support"]		= "Pre technickú podporu a ďalšie informácie kontaktujte";
$pgv_lang["for_contact"]		= "S otázkami k rodokmeňu sa obracajte na";
$pgv_lang["for_all_contact"]		= "Pre technickú podporu alebo s otázkami k rodokmeňu prosím kontaktujte";
$pgv_lang["build_title"]		= "Vytvorenie Index súborov";
$pgv_lang["build_error"]		= "Súbor GEDCOM bol aktualizovaný.";
$pgv_lang["please_wait"]		= "Chvíľku strpenia. Prebieha prepisovanie indexových súborov.";
$pgv_lang["choose_gedcom"]		= "Vybrať GEDCOM databázu";
$pgv_lang["username"]			= "Uživateľské meno";
$pgv_lang["invalid_username"]		= "Uživateľské meno obsahuje neplatné znaky";
$pgv_lang["firstname"]			= "Meno";
$pgv_lang["lastname"]			= "Priezvisko";
$pgv_lang["password"]			= "Heslo";
$pgv_lang["confirm"]			= "Potvrdenie hesla";
$pgv_lang["user_contact_method"]	= "Uprednostňovaný spôsob kontaktu";
$pgv_lang["login"]			= "Prihlásiť sa";
$pgv_lang["login_aut"]			= "Upraviť uživateľa";
$pgv_lang["logout"]			= "Odhlásiť sa";
$pgv_lang["admin"]			= "Admin";
$pgv_lang["logged_in_as"]		= "Prihlásený ako";
$pgv_lang["my_pedigree"]		= "Môj vývod";
$pgv_lang["my_indi"]			= "Môj osobný záznam";
$pgv_lang["yes"]			= "Ano";
$pgv_lang["no"]				= "Nie";
$pgv_lang["add_gedcom"]			= "Pridať GEDCOM";
$pgv_lang["add_gedcom"]			= "Pridať další GEDCOM";
$pgv_lang["change_theme"]		= "Zmena motívu";
$pgv_lang["gedcom_downloadable"] 	= "Tento GEDCOM môže byť stiahnutý po internete!<br />Prosím prečítajte si odstavec o BEZPEČNOSTI v súbore <a href=\"readme.txt\">readme.txt</a> a zjednajte nápravu";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Vývod";
$pgv_lang["gen_ped_chart"]		= "#PEDIGREE_GENERATIONS# - generačná schéma";
$pgv_lang["generations"]		= "Počet generácií";
$pgv_lang["view"]			= "Zobraziť";
$pgv_lang["fam_spouse"]			= "Rodina s partnerom";
$pgv_lang["root_person"]		= "ID východiskovej osoby";
$pgv_lang["hide_details"]		= "Skryť podrobnosti";
$pgv_lang["show_details"]		= "Ukázať podrobnosti";
$pgv_lang["person_links"]		= "Odkazy na schémy, rodiny a blízkych príbuzných tejto osoby. Kliknite na túto ikonu pre zvolené zobrazenie rodokmeňa s touto osobou ako východiskovou.";
$pgv_lang["zoom_box"]			= "Zväčšenie/zmenšenie tohoto rámčeka";
$pgv_lang["orientation"]		= "Orientácia";
$pgv_lang["portrait"]			= "Na výšku";
$pgv_lang["landscape"]			= "Na šírku";
$pgv_lang["start_at_parents"]		= "Začať u rodičov";
$pgv_lang["charts"]			= "Schémy";
$pgv_lang["lists"]			= "Zoznamy";
$pgv_lang["welcome_page"]		= "Úvodná stránka";
$pgv_lang["max_generation"]		= "Maximálny počet generácií  je #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"]		= "Minimálny počet generácií je 3.";
$pgv_lang["box_width"] 			= "Šírka rámčeka";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Nie je možné nájsť rodinu s ID";
$pgv_lang["unable_to_find_indi"]	= "Nie je možné nájsť osobu s ID";
$pgv_lang["unable_to_find_record"]	= "Nie je možné nájsť záznam s ID";
$pgv_lang["unable_to_find_source"]	= "Nie je možné nájsť zdroj s ID";
$pgv_lang["unable_to_find_repo"]	= "Nie je možné nájsť prameň s ID";
$pgv_lang["repo_name"]			= "Názov prameňa:";
$pgv_lang["address"]			= "Adresa:";
$pgv_lang["phone"]			= "Telefón:";
$pgv_lang["source_name"]		= "Názov zdroja:";
$pgv_lang["title"]			= "Nadpis";
$pgv_lang["author"]			= "Autor:";
$pgv_lang["publication"]		= "Publikácia:";
$pgv_lang["call_number"]		= "Telefónne číslo:";
$pgv_lang["living"]			= "Žijúca osoba";
$pgv_lang["private"]			= "Súkromné";
$pgv_lang["birth"]			= "Narodenie:";
$pgv_lang["death"]			= "Úmrtie:";
$pgv_lang["descend_chart"]		= "Rozrod";
$pgv_lang["individual_list"]		= "Zoznam osôb";
$pgv_lang["family_list"]		= "Zoznam rodín";
$pgv_lang["source_list"]		= "Zoznam zdrojov";
$pgv_lang["place_list"]			= "Hierarchia miest";
$pgv_lang["place_list_aft"] 		= "Hierarchia miest podľa";
$pgv_lang["media_list"]			= "Zoznam multimédií";
$pgv_lang["search"]			= "Hľadať";
$pgv_lang["search_general"]		= "Všeobecné hľadanie";
$pgv_lang["search_soundex"]		= "SOUNDEX hľadanie";
$pgv_lang["search_inrecs"]		= "Hľadať";
$pgv_lang["search_fams"]		= "Rodiny";
$pgv_lang["search_indis"]		= "Osoby";
$pgv_lang["search_sources"]		= "Zdroje";
$pgv_lang["search_more_chars"]      	= "Prosím vložte viacej ako jeden znak";
$pgv_lang["search_soundextype"]		= "Soundex typ:";
$pgv_lang["search_russell"]		= "Russell";
$pgv_lang["search_DM"]			= "Daitch-Mokotoff";
$pgv_lang["search_prtnames"]		= "Mená<br />osôb ku zobrazeniu:";
$pgv_lang["search_prthit"]		= "Mená s prístupom";
$pgv_lang["search_prtall"]		= "Všetky mená";
$pgv_lang["search_tagfilter"]		= "Filter vylúčenia";
$pgv_lang["search_tagfon"]		= "Vylúčiť nejaké negenealogické údaje";
$pgv_lang["search_tagfoff"]		= "Zrušený";
$pgv_lang["associate"]			= "pridružený";
$pgv_lang["search_asso_label"]		= "Príbuzný";
$pgv_lang["search_asso_text"]		= "Zobraziť príbuzné osoby / rodiny";
$pgv_lang["results_per_page"]		= "Výsledky na stránke";
$pgv_lang["clippings_cart"]		= "Schránka výstrižkov";
$pgv_lang["print_preview"]		= "Tlačový režim";
$pgv_lang["cancel_preview"]		= "Späť do normálneho zobrazenia";
$pgv_lang["change_lang"]		= "Zmeniť jazyk";
$pgv_lang["print"]			= "Vytlačiť";
$pgv_lang["total_queries"]		= "Celkový počet dotazov na databázu: ";
$pgv_lang["total_privacy_checks"]	= "Úplných kontrol utajenia celkom:";
$pgv_lang["back"]			= "Späť";
$pgv_lang["privacy_list_indi_error"]	= "Kvôli nastaveniu utajenia je jedna či viac osôb skrytých.";
$pgv_lang["privacy_list_fam_error"]	= "Kvôli nastaveniu utajenia je jedna či viac rodín skrytých.";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]			= "alias";
$pgv_lang["male"]			= "Muž";
$pgv_lang["female"]			= "Žena";
$pgv_lang["temple"]			= "Chrám LDS (Temple)";
$pgv_lang["temple_code"]		= "Kód LDS Chrámu (Temple):";
$pgv_lang["status"]			= "Stav";
$pgv_lang["source"]			= "Zdroj";
$pgv_lang["citation"]			= "Citácia:";
$pgv_lang["text"]			= "Zdrojový text:";
$pgv_lang["note"]			= "Poznámka";
$pgv_lang["NN"]				= "(neznáme)";
$pgv_lang["PN"]				= "(neznáme)";
$pgv_lang["unrecognized_code"]		= "Nebol rozoznaný GEDCOM kód";
$pgv_lang["unrecognized_code_msg"]	= "Došlo k chybe. Radi by sme ju opravili. Prosím informujte nás o tomto probléme na ";
$pgv_lang["indi_info"]			= "Informácie o osobe";
$pgv_lang["pedigree_chart"]		= "Vývod";
$pgv_lang["individual"]			= "Osoba";
$pgv_lang["family"]			= "Rodina";
$pgv_lang["family_with"]		= "Rodina s";
$pgv_lang["as_spouse"]			= "Rodina s partnerom";
$pgv_lang["as_child"]			= "Rodina s rodičmi";
$pgv_lang["view_gedcom"]		= "Zobraziť GEDCOM záznam";
$pgv_lang["add_to_cart"]		= "Pridať do schránky výstrižkov";
$pgv_lang["still_living_error"]		= "Táto osoba ešte žije. Nie sú u nej zaznamenané dátumy narodenia a úmrtia. Všetky podrobnosti o žijúcich osobách sú skryté.<br />Pre ďalšie informácie kontaktujte";
$pgv_lang["privacy_error"]		= "Podrobnosti o tejto osobe sú neverejné.<br />";
$pgv_lang["more_information"]		= "Pre ďalšie informácie kontaktujte";
$pgv_lang["name"]			= "Meno";
$pgv_lang["given_name"]			= "Krstné meno:";
$pgv_lang["surname"]			= "Priezvisko:";
$pgv_lang["suffix"]			= "Suffix:";
$pgv_lang["object_note"]		= "Poznámka k objektu:";
$pgv_lang["sex"]			= "Pohlavie";
$pgv_lang["personal_facts"]		= "Osobné údaje a podrobnosti";
$pgv_lang["type"]			= "Typ";
$pgv_lang["date"]			= "Dátum";
$pgv_lang["place_description"]		= "Miesto / Popis";
$pgv_lang["parents"] 			= "Rodičia:";
$pgv_lang["siblings"] 			= "Súrodenci";
$pgv_lang["father"] 			= "Otec";
$pgv_lang["mother"] 			= "Matka";
$pgv_lang["parent"] 			= "Rodič";
$pgv_lang["relatives"]			= "Blízky príbuzný";
$pgv_lang["relatives_events"]		= "Udalosti blízkych príbuzných";
$pgv_lang["child"]			= "Dieťa";
$pgv_lang["spouse"]			= "Partner";
$pgv_lang["surnames"]			= "Priezvisko";
$pgv_lang["adopted"]			= "Adoptovaný(a)";
$pgv_lang["foster"]			= "Pestún";
///////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["sealing"]			= "LDS Sealing";
$pgv_lang["challenged"]			= "Nepotvrdené";
$pgv_lang["disproved"]			= "Vyvrátené";
$pgv_lang["infant"]			= "Maloletý";
$pgv_lang["stillborn"]			= "Mŕtvonarodený";
$pgv_lang["deceased"]			= "Zosnulý";
$pgv_lang["link_as_child"]		= "Pridať túto osobu k existujúcej rodine ako dieťa";
$pgv_lang["link_as_wife"]		= "Pridať túto osobu k existujúcej rodine ako manželku";
$pgv_lang["link_as_husband"]		= "Pridať túto osobu k existujúcej rodine ako manžela";
///////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["no_tab1"]			= "K tejto osobe nie sú dostupné žiadne údaje.";
$pgv_lang["no_tab2"]			= "K tejto osobe nie sú žiadne poznámky.";
$pgv_lang["no_tab3"]			= "K tejto osobe nie sú žiadne citácie zdrojov.";
$pgv_lang["no_tab4"]			= "K tejto osobe nie sú k dispozícii žiadne obrázky.";
$pgv_lang["no_tab5"]			= "K tejto osobe nie sú dostupný žiadny blízky príbuzný.";
$pgv_lang["no_tab6"]			= "K tejto osobe nie sú pripojené žiadne záznamy v bádateľskom záznamníku.";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Informácie o rodine";
$pgv_lang["family_group_info"]		= "Informácie o rodine (manželstvo)";
$pgv_lang["husband"]			= "Manžel";
$pgv_lang["wife"]			= "Manželka";
$pgv_lang["marriage"]			= "Sobáš:";
///////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["lds_sealing"]		= "LDS Sealing:";
///////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["marriage_license"]		= "Manželská zmluva:";
$pgv_lang["media_object"]		= "Multimediálny súbor:";
$pgv_lang["children"]			= "Deti";
$pgv_lang["no_children"]		= "Žiadne zaznamenané deti";
$pgv_lang["childless_family"]		= "Táto rodina zostala bezdetná";
$pgv_lang["number_children"]		= "Počet detí:";
$pgv_lang["parents_timeline"]		= "Ukázať pár na<br />časovej ose";

//-- CLIPPINGS FILE MESSAGES

$pgv_lang["clip_cart"]			= "Schránka výstrižkov";
$pgv_lang["clip_explaination"]		= "Schránka výstrižkov vám umožňuje urobiť z tohoto rodokmeňa &quot;výstrižky&quot; a uložiť ich do samostatného GEDCOM súboru ku stiahnutiu.<br /><br />";
$pgv_lang["item_with_id"]		= "Položka s ID";
$pgv_lang["error_already"]		= "je už medzi výstrižkami.";
$pgv_lang["which_links"]		= "Ktoré vzťahy z tejto rodiny by ste ešte radi pridali?";
$pgv_lang["just_family"]		= "Pridať len tento rodinný záznam.";
$pgv_lang["parents_and_family"]		= "Pridať rodičov s týmto rodinným záznamom.";
$pgv_lang["parents_and_child"]		= "Pridať záznamy rodičov a detí s týmto rodinným záznamom.";
$pgv_lang["parents_desc"]		= "Pridať všetky záznamy rodičov a všetkých potomkov s týmto rodinným záznamom.";
$pgv_lang["continue"]			= "Pokračovať v pridávaní";
$pgv_lang["which_p_links"]		= "Ktoré vzťahy tejto osoby by ste chceli tiež pridať?";
$pgv_lang["just_person"]		= "Pridať len túto osobu.";
$pgv_lang["person_parents_sibs"]	= "Pridať túto osobu, jej rodičov a súrodencov.";
$pgv_lang["person_ancestors"]		= "Pridať túto osobu a jej predkov v priamej línii.";
$pgv_lang["person_ancestor_fams"]	= "Pridať túto osobu, jej predkov v priamej línii a ich rodiny.";
$pgv_lang["person_spouse"]		= "Pridať túto osobu, jej partnera a deti.";
$pgv_lang["person_desc"]		= "Pridať záznam o tejto osobe, jej partnerovi a všetkých potomkoch.";
$pgv_lang["unable_to_open"]		= "Nebolo možné zložku s výstrižkami otvoriť pre zápis";
$pgv_lang["person_living"]		= "Toto je žijúca osoba. Osobné údaje nebudú zahrnuté.";
$pgv_lang["person_private"]		= "Podrobnosti o tejto osobe sú neverejné. Osobné údaje nebudú zahrnuté.";
$pgv_lang["family_private"]		= "Podrobnosti o tejto rodine sú neverejné. Rodinné údaje nebudú zahrnuté.";
$pgv_lang["download"]			= "Pre stiahnutie súborov kliknite pravým tlačítkom na odkazy dole a označte &quot;Uložiť cieľ ako&quot;.";
$pgv_lang["media_files"]		= "V tomto GEDCOM súbore sú referencie na súbory médií.";
$pgv_lang["cart_is_empty"]		= "Vaša Schránka výstrižkov je prázdna.";
$pgv_lang["id"]				= "ID";
$pgv_lang["name_description"]		= "Meno / Popis";
$pgv_lang["remove"]			= "Odstrániť";
$pgv_lang["empty_cart"]			= "Vyprázdniť schránku";
$pgv_lang["download_now"]		= "Stiahnuť";
$pgv_lang["indi_downloaded_from"]	= "Táto osoba bola stiahnutá z:";
$pgv_lang["family_downloaded_from"]	= "Táto rodina bola stiahnutá z:";
$pgv_lang["source_downloaded_from"]	= "Tento zdroj bol stiahnutý z:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "nájdených súvislostí v miestach";
$pgv_lang["top_level"]			= "Horná úroveň";
$pgv_lang["form"]			= "Miesta sú zapísané v tvare: ";
$pgv_lang["default_form"]		= "mesto, kraj, štát, zem";
$pgv_lang["default_form_info"]		= "(Default)";
$pgv_lang["gedcom_form_info"]		= "(GEDCOM)";
$pgv_lang["unknown"]			= "Neznámy(a)";
$pgv_lang["individuals"]		= "Osoby";
$pgv_lang["view_records_in_place"]	= "Zobraziť všetky záznamy spojené s týmto miestom";
$pgv_lang["place_list2"] 		= "Zoznam miest";
$pgv_lang["show_place_hierarchy"]	= "Zobraziť miesta hierarchicky";
$pgv_lang["show_place_list"]		= "Zobraziť všetky miesta zo zoznamu.";
$pgv_lang["total_unic_places"]		= "Unikátnych miest celkove";
$pgv_lang["external_objects"]		= "Externé objekty";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "Zoznam multimediálnych súborov";
$pgv_lang["media_found"]		= "nájdených mediálnych súborov.";
$pgv_lang["view_person"]		= "Zobraziť osobu";
$pgv_lang["view_family"]		= "Zobraziť rodinu";
$pgv_lang["view_source"]		= "Zobraziť zdroj";
$pgv_lang["view_object"]		= "Zobraziť objekt";
$pgv_lang["prev"]			= "< Predchádzajúci";
$pgv_lang["next"]			= "Nasledujúci >";
$pgv_lang["file_not_found"]		= "Súbor nebol nájdený.";
$pgv_lang["medialist_show"] 		= "Zobraziť";
$pgv_lang["per_page"]			= "mediálnych objektov na stránku";
$pgv_lang["delete_directory"]		= "Zmazať adresár";
$pgv_lang["remove_object"]		= "Odstrániť objekt";
$pgv_lang["confirm_remove_object"]	= "Ste si istý, že chcete odstrániť tento objekt z databázy?";
$pgv_lang["remove_links"]		= "Odstrániť spojenia";
$pgv_lang["confirm_remove_links"]	= "Ste si istý, že chcete odstrániť všetky spojenia pre tento objekt?";
$pgv_lang["delete_file"]		= "Zmazať súbor";
$pgv_lang["confirm_delete_file"]	= "Ste si istý, že chcete zmazať tento súbor?";
$pgv_lang["multiple_gedcoms"]		= "Tento súbor je spojený s inou genealogickou databázou na tomto servere. Nemôže byť zmazaný, presunutý alebo premenovaný skôr než budú tieto spojenia odstránené.";
$pgv_lang["external_file"]		= "Tento objekt édií neexistuje na serveri ako súbor. Nemôže byť preto zmazný, presunutý alebo premenovaný.";
$pgv_lang["directory_not_empty"]	= "Adresár nie je prázdny:";
$pgv_lang["directory_not_exist"]	= "Adresár neexistuje.";
$pgv_lang["media_not_deleted"]		= "Adresár medií nebol odstránený.";
$pgv_lang["media_deleted"]		= "Adresár médií bol úspešne odstránený.";
$pgv_lang["thumbs_not_deleted"]		= "Adresár náhľadov nebol odstránený.";
$pgv_lang["thumbs_deleted"]		= "Adresár náhľadov bol úspešne odstránený.";
$pgv_lang["delete_dir_success"]		= "Adresáre medií a náhľadov boli úspešne odstránené.";
$pgv_lang["current_dir"]		= "Aktuálny adresár";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "Hľadanie súborov GEDCOM";
$pgv_lang["enter_terms"]		= "Vložte výraz, ktorý sa má vyhľadať:";
$pgv_lang["soundex_search"]		= "- Alebo skúste zadať meno tak, ako si myslíte, že sa píše (metóda Soundex):";
$pgv_lang["sources"]			= "Zdroje";
$pgv_lang["firstname_search"]		= "Meno: ";
$pgv_lang["lastname_search"]		= "Priezvisko: ";
$pgv_lang["search_place"]		= "Miesto: ";
$pgv_lang["search_year"]		= "Rok: ";
$pgv_lang["no_results"]			= "Zodpovedajúci záznam nebol nájdený.";
$pgv_lang["invalid_search_input"] 	= "Prosím zadajte k roku ešte meno, priezvisko alebo miesto.";
$pgv_lang["search_options"]		= "Voľby hľadania";
$pgv_lang["search_geds"]		= "Hľadať GEDCOMy v";
$pgv_lang["search_type"]		= "Druh vyhľadávania";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]		= "Nájdené zdroje";
$pgv_lang["titles_found"]		= "Tituly";
$pgv_lang["find_source"]		= "Hľadať zdroje";
$pgv_lang["repo_list"]			= "Zoznam prameňov";
$pgv_lang["repos_found"]		= "Nájdené pramene";
$pgv_lang["find_repository"]		= "Hľadanie prameňov";
$pgv_lang["total_repositories"]		= "Pramene celkove";
$pgv_lang["repo_info"]			= "Informácie o prameni";
$pgv_lang["delete_repo"]		= "Zmazať prameň";
$pgv_lang["other_repo_records"]		= "Záznamy, ktoré sa odkazujú na tento prameň:";
$pgv_lang["create_repository"]		= "Založiť prameň";
$pgv_lang["new_repo_created"]		= "Nový prameň bol založený";
$pgv_lang["paste_rid_into_field"]	= "Vložte toto ID prameňa do políčok, z ktorých sa chcete odvolávať na tento prameň.";
$pgv_lang["confirm_delete_repo"]	= "Naozaj chcete zmazať tento prameň z databázy?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Informácie o zdroji";
$pgv_lang["other_records"]		= "Záznamy, ktoré sa odkazujú na tento zdroj:";
$pgv_lang["people"]			= "Ľudia";
$pgv_lang["families"]			= "Rodiny";
$pgv_lang["total_sources"]		= "Zdrojov celkove";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "Vytváranie indexu osôb a rodín";
$pgv_lang["building_index"]		= "Vytváranie zoznamov indexov";
$pgv_lang["invalid_gedformat"]		= "Neplatný formát (nezodpovedá štandardu GEDCOM 5.5)";
$pgv_lang["importing_records"]		= "Importovanie záznamov do databáze";
$pgv_lang["detected_change"]		= "PhpGedView zaznamenal zmenu v GEDCOM súbore #GEDCOM#. Súbory indexov sa teraz musia prepísať.";
$pgv_lang["please_be_patient"]		= "PROSÍM O STRPENIE";
$pgv_lang["reading_file"]		= "Načítanie súboru GEDCOM";
$pgv_lang["flushing"]			= "Obsah pamäte";
$pgv_lang["found_record"]		= "Nájdený záznam";
$pgv_lang["exec_time"]			= "Celkový čas:";
$pgv_lang["time_limit"]			= "Časový limit:";
$pgv_lang["unable_to_create_index"]	= "Nie je možné vytvoriť indexový súbor. Uistite sa, že máte právo zápisu do zložky PhpGedView. Aktuálne nastavenie práv môžete obnoviť po zapísaní súborov.";
$pgv_lang["indi_complete"]		= "Aktualizácia súboru s indexom osôb je hotová.";
$pgv_lang["family_complete"]		= "Aktualizácia súboru s indexom rodín je hotová.";
$pgv_lang["source_complete"]		= "Aktualizácia súboru s indexom zdrojov je hotová.";
$pgv_lang["tables_exist"]		= "Tabulky PhpGedView už v databáze existujú.";
$pgv_lang["you_may"]			= "Môžete:";
$pgv_lang["drop_tables"]		= "Zmazať aktuálne tabuľky";
$pgv_lang["import_multiple"]		= "Importovať a pracovať s viacerými GEDCOM súbormi";
$pgv_lang["explain_options"]		= "Ak zvolíte možnosť \"zmazať tabuľky\", všetky dáta budú nahradené dátami z tohoto GEDCOM súboru.<br />Ak zvolíte \"importovať a pracovať z GEDCOM súbormi\", PhpGedView zmaže všetky dáta, ktoré boli importované z rovnomenného GEDCOM súboru. Táto voľba vám umožňuje ukladať dáta z viacerých GEDCOM súborov v rovnakých tabuľkách a jednoducho medzi nimi prepínat.";
$pgv_lang["path_to_gedcom"]		= "Zadajte cestu k vašemu GEDCOM súboru:";
$pgv_lang["dataset_exists"]		= "GEDCOM súbor z týmto názvom už bol do databázy importovaný.";
$pgv_lang["changes_present"]		= "Tento GEDCOM má zmeny čakajúce na kontrolu. Ak budete pokračovať v importe, čakajúce zmeny budú okamžite zapísané do databázy. Môžete ich skontrolovať než dokončíte import.";
$pgv_lang["empty_dataset"]		= "Chcete vymazať staré dáta a nahradiť ich novými?";
$pgv_lang["empty_dataset"]		= "Chcete vyprázdniť databázu?";
$pgv_lang["index_complete"]		= "Index je hotový.";
$pgv_lang["click_here_to_go_to_pedigree_tree"]	= "Kliknite sem pre vstup do rodokmeňa.";
$pgv_lang["updating_is_dead"]		= "Doplnenie stavu k zomrelým osobám ";
$pgv_lang["import_complete"]		= "Importovanie je hotové";
$pgv_lang["updating_family_names"]	= "Aktualizácia priezvísk pre FAM ";
$pgv_lang["processed_for"]		= "Zpracovaný súbor pre ";
$pgv_lang["run_tools"]			= "Chcete spustiť jeden z následujúcich nástrojov ešte pred importovaním GEDCOM súboru:";
$pgv_lang["addmedia"]			= "Nástroj pridania médií";
$pgv_lang["dateconvert"]		= "Konverzia dát";
$pgv_lang["xreftorin"]			= "Zkonvertovať identifikátory XREF na čísla RIN";
$pgv_lang["tools_readme"]		= "Pre ďalšie informácie sa podívajte do časti \"tools\" v súbore #README.TXT#.";
$pgv_lang["sec"]			= "s";
$pgv_lang["bytes_read"]			= "Načítané bajty:";
$pgv_lang["created_remotelinks"]	= "Tabuľka <i>Remotelinks</i> úspešne vytvorená.";
$pgv_lang["created_remotelinks_fail"] 	= "Nie je možné vytvoriť tabuľku <i>Remotelinks</i>.";
$pgv_lang["created_indis"]		= "Tabuľka <i>Osoby</i> bola úspešne vytvorená.";
$pgv_lang["created_indis_fail"]		= "Nie je možné vytvoriť tabuľku <i>Osoby</i>.";
$pgv_lang["created_fams"]		= "Tabuľka <i>Rodiny</i> bola úspešne vytvorená.";
$pgv_lang["created_fams_fail"]		= "Nie je možné vytvoriť tabuľku <i>Rodiny</i>.";
$pgv_lang["created_sources"]		= "Tabuľka <i>Pramene</i> bola úspešne vytvorená.";
$pgv_lang["created_sources_fail"]	= "Nie je možné vytvoriť tabuľku <i>Pramene</i>.";
$pgv_lang["created_other"]		= "Tabuľka <i>Ostatné</i> bola úspešne vytvorená.";
$pgv_lang["created_other_fail"]		= "Nie je možné vytvoriť tabuľku <i>Ostatné</i>.";
$pgv_lang["created_places"]		= "Tabuľka <i>Miesta</i> bola úspešne vytvorená.";
$pgv_lang["created_places_fail"]	= "Nie je možné vytvoriť tabuľku <i>Miesta</i>.";
$pgv_lang["created_placelinks"] 	= "Tabuľka <i>Prepojené Miesta</i> bola úspešne vytvorená.";
$pgv_lang["created_placelinks_fail"]	= "Nie je možné vytvoriť tabuľku <i>Prepojené Miesta</i>.";
$pgv_lang["created_media_fail"]		= "Nie je možné vytvoriť tabuľku <i>Médiá</i>.";
$pgv_lang["created_media_mapping_fail"]	= "Nie je možné vytvoriť tabuľku <i>Zobrazenie médií</i>.";
$pgv_lang["import_progress"]		= "Priebeh nahrávania...";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Všetky rodiny";
$pgv_lang["total_indis"]		= "Všetky osoby";
$pgv_lang["starts_with"]		= "Začať s:";
$pgv_lang["person_list"]		= "Zoznam osôb:";
$pgv_lang["paste_person"]		= "Vloženie osoby";
$pgv_lang["notes_sources_media"]	= "Poznámky, pramene a média";
$pgv_lang["notes"]			= "Poznámky";
$pgv_lang["ssourcess"]			= "Pramene";
$pgv_lang["media"]			= "Média";
$pgv_lang["name_contains"]		= "Meno obsahuje:";
$pgv_lang["filter"]			= "Prehľadať";
$pgv_lang["find_individual"]		= "Nájsť ID osoby";
$pgv_lang["find_familyid"]		= "Nájsť ID rodiny";
$pgv_lang["find_sourceid"]		= "Nájsť ID zdroja";
$pgv_lang["find_specialchar"]		= "Nájsť špeciálne znaky";
$pgv_lang["magnify"]			= "Zväčšiť";
$pgv_lang["skip_surnames"]		= "Preskočiť zoznamy priezvísk";
$pgv_lang["show_surnames"]		= "Ukázať zoznamy priezvísk";
$pgv_lang["all"]			= "Všetky";
$pgv_lang["hidden"]			= "Skryté";
$pgv_lang["confidential"]		= "Dôverné";
$pgv_lang["alpha_index"]		= "Abecedný index";
$pgv_lang["name_list"] 			= "Zoznam mien";
$pgv_lang["firstname_alpha_index"] 	= "Abecedný index vlastných mien";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Vek";
$pgv_lang["days"]			= "dni";
$pgv_lang["months"]			= "mesiace";
$pgv_lang["years"]			= "roky";
$pgv_lang["day1"]			= "deň";
$pgv_lang["month1"]			= "mesiac";
$pgv_lang["year1"]			= "rok";
$pgv_lang["timeline_title"]		= "Časová osa PhpGedView";
$pgv_lang["timeline_chart"]		= "Časová osa";
$pgv_lang["remove_person"]		= "Odstrániť osobu";
$pgv_lang["show_age"]			= "Zobraziť ukazateľ veku";
$pgv_lang["add_another"]		= "Pridať na osu ďalšiu osobu:<br />ID osoby:";
$pgv_lang["find_id"]			= "Nájsť ID";
$pgv_lang["show"]			= "Ukázať";
$pgv_lang["year"]			= "Rok:";
$pgv_lang["timeline_instructions"]	= "Vo väčšine novších prehliadačov môžete klepnúť na meno v rámčeku a pretiahnuť ho na osu.";
$pgv_lang["zoom_in"]			= "Zväčšiť";
$pgv_lang["zoom_out"]			= "Zmenšiť";

//-- MONTH NAMES
$pgv_lang["jan"]			= "január";
$pgv_lang["feb"]			= "február";
$pgv_lang["mar"]			= "marec";
$pgv_lang["apr"]			= "apríl";
$pgv_lang["may"]			= "máj";
$pgv_lang["jun"]			= "jún";
$pgv_lang["jul"]			= "júl";
$pgv_lang["aug"]			= "august";
$pgv_lang["sep"]			= "september";
$pgv_lang["oct"]			= "október";
$pgv_lang["nov"]			= "november";
$pgv_lang["dec"]			= "december";
$pgv_lang["abt"]			= "okolo";
$pgv_lang["aft"]			= "po";
$pgv_lang["and"]			= "a";
$pgv_lang["bef"]			= "pred";
$pgv_lang["bet"]			= "medzi";
$pgv_lang["cal"]			= "odhadnuté";
$pgv_lang["est"]			= "približne";
$pgv_lang["from"]			= "od";
$pgv_lang["int"]			= "interpretované";
$pgv_lang["to"]				= "do";
$pgv_lang["cir"]			= "asi";
$pgv_lang["apx"]			= "pribl.";

//-- Admin File Messages
$pgv_lang["select_an_option"]		= "Vyberte jednu z možností:";
$pgv_lang["readme_documentation"]	= "README dokumentácia";
$pgv_lang["view_readme"]		= "Zobraziť súbor readme.txt";
$pgv_lang["configuration"]		= "Konfigurácia";
$pgv_lang["rebuild_indexes"]		= "Prepísať Indexy";
$pgv_lang["user_admin"]			= "Správa uživateľov";
$pgv_lang["user_created"]		= " Uživateľ bol úspešne vytvorený.";
$pgv_lang["user_create_error"]		= "Nie je možné pridať uživateľa. Prosím vráťte sa späť a skúste to znovu.";
$pgv_lang["password_mismatch"]		= "Heslá sa nezhodujú.";
$pgv_lang["enter_username"]		= "Musíte vložiť uživateľské meno.";
$pgv_lang["enter_fullname"]		= "Musíte vložiť celé meno.";
$pgv_lang["enter_password"]		= "Musíte vložiť heslo.";
$pgv_lang["confirm_password"]		= "Musíte potvrdiť heslo.";
$pgv_lang["update_user"]		= "Aktualizovať uživateľský účet";
$pgv_lang["update_myaccount"]		= "Aktualizovať môj účet";
$pgv_lang["save"]			= "Uložiť";
$pgv_lang["delete"]			= "Zmazať";
$pgv_lang["edit"]			= "Úpravy";
$pgv_lang["full_name"]			= "Celé meno";
$pgv_lang["visibleonline"]		= "Viditeľný pre iných uživateľov, keď je online";
$pgv_lang["comment"]			= "Poznámky admina k uživateľovi";
$pgv_lang["comment_exp"]		= "Varovania admina ku dňu";
$pgv_lang["editaccount"]		= "Umožniť tomuto uživateľovi upravovať informácie o svojom účte";
$pgv_lang["admin_gedcom"]		= "Spravovať GEDCOM";
$pgv_lang["confirm_user_delete"]	= "Ste si istý, že chcete zmazať uživateľa";
$pgv_lang["create_user"]		= "Vytvoriť uživateľa";
$pgv_lang["no_login"]			= "Nie je možné overiť uživateľa.";
$pgv_lang["basic_realm"]		= "Systém autorizácie PhpGedView";
$pgv_lang["basic_auth_failure"]		= "Musíte zadať platné prihlasovacie ID a heslo pre prístup k tomuto zdroji.";
$pgv_lang["basic_auth"]			= "Základná autorizácia";
$pgv_lang["digest_auth"]		= "Výberová autorizácia";
$pgv_lang["no_auth_needed"]		= "Žiadna autorizácia";
$pgv_lang["import_gedcom"]		= "Importovať tento GEDCOM súbor";
$pgv_lang["duplicate_username"]		= "Toto uživateľské meno už existuje. Prosím, vráťte sa späť a vyberte iné uživateľské meno.";
$pgv_lang["gedcomid"]			= "ID osoby";
$pgv_lang["enter_gedcomid"]		= "Musíte vložit ID GEDCOM souboru.";
$pgv_lang["user_info"]			= "Informácie o mojom uživateľovi";
$pgv_lang["rootid"]			= "Východisková osoba vývodu";
$pgv_lang["download_gedcom"]		= "Stiahnúť GEDCOM";
$pgv_lang["upload_gedcom"]		= "Nahrať GEDCOM";
$pgv_lang["add_new_gedcom"]		= "Vytvoriť nový GEDCOM";
$pgv_lang["gedcom_file"]		= "Súbor GEDCOM:";
$pgv_lang["enter_filename"]		= "Musíte vložiť názov GEDCOM súboru.";
$pgv_lang["file_not_exists"]		= "Súbor, ktorého názov ste zadali, neexistuje.";
$pgv_lang["file_not_present"]		= "Súbor neexistuje.";
$pgv_lang["file_exists"]		= "GEDCOM súbor s týmto názvom už je tu. Prosím vyberte iný názov súboru, alebo zmažte starý súbor.";
$pgv_lang["new_gedcom_title"]		= "Genealógia z [#GEDCOMFILE#]";
$pgv_lang["upload_error"]		= "V priebehu nahrávania vášho súboru sa objavila chyba.";
$pgv_lang["upload_media_help"]		= "~#pgv_lang[upload_media]#~<br /><br />Vyberte súbory na vašom lokálnom počítači pre načítanie na váš server. Všetky súbory budú načítané do adresára <b>#MEDIA_DIRECTORY#</b> alebo do niektorého z poddaresárov.<br /><br />Adresár, ktorého meno ste zadali, bude pridaný do #MEDIA_DIRECTORY#. Napríklad, #MEDIA_DIRECTORY#mojarodina. Ak adresár náhľadov neexistuje, bude založený automaticky.";
$pgv_lang["upload_gedcom_help"]		= "Vyberte GEDCOM alebo ZIP súbor na vašom lokálnom počítači pre načítanie na váš server. Súbor bude načítaný do adresára <b>#INDEX_DIRECTORY#</b>.<br /><br />Ak načítate ZIP súbor, tak môže odsahovať iba jeden GEDCOM a tento GEDCOM bude automaticky použitý v nasledujúcich krokoch.<br /><br />";
$pgv_lang["add_gedcom_instructions"]	= "Zadajte názov pre tento nový GEDCOM súbor. Tento súbor bude uložený do hlavného adresára: ";
$pgv_lang["file_success"]		= "Súbor bol úspešne nahraný";
$pgv_lang["file_too_big"]		= "Nahraný súbor presiahol povolenú veľkosť";
$pgv_lang["file_partial"]		= "Súbor bol nahraný iba čiastočne, prosím skúste to znovu";
$pgv_lang["file_missing"]		= "Žiadny súbor k načítaniu. Nahrajte ho znovu";
$pgv_lang["manage_gedcoms"]		= "Správa GEDCOM súborov a úprava utajenia";
$pgv_lang["research_assistant"]		= "Asistent bádateľa";
$pgv_lang["administration"]		= "Administrácia";
$pgv_lang["ansi_to_utf8"]		= "Previesť kódovanie v tomto GEDCOM súbore z ANSI (ISO-8859-1) na UTF-8?";
$pgv_lang["utf8_to_ansi"]		= "Chcete zmeniť kódovanie v tomto GEDCOM súbore z UTF-8 na ANSI (ISO-8859-1)?";
$pgv_lang["visitor"]			= "Návštevník";
$pgv_lang["user"]			= "Autorizovaný uživateľ";
$pgv_lang["gedadmin"]			= "Administrátor GEDCOMu";
$pgv_lang["siteadmin"]			= "Administrátor stránky";
$pgv_lang["apply_privacy"]		= "Použiť nastavenie utajenia?";
$pgv_lang["choose_priv"]		= "Vyberte úroveň utajenia:";
$pgv_lang["user_manual"]		= "Uživateľský manuál aplikácie PhpGedView";
$pgv_lang["upgrade"]			= "Aktualizovať PhpGedView";

///////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["view_logs"]			= "Zobraziť logfiles";
$pgv_lang["logfile_content"]		= "Obsah \"log\" súboru";
///////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["step1"]			= "Krok 1 z 4:";
$pgv_lang["step2"]			= "Krok 2 z 4:";
$pgv_lang["step3"]			= "Krok 3 z 4:";
$pgv_lang["step4"]			= "Krok 4 z 4:";
$pgv_lang["validate_gedcom"]		= "Potvrdiť platnosť GEDCOMu";
$pgv_lang["img_admin_settings"]		= "Upraviť nastavenie nakladania z obrázkami";
$pgv_lang["download_note"]		= "POZNÁMKA: Veľké GEDCOM súbory sa môžu sťahovať veľmi dlho. Ak PHP preruší proces ešte pred úplným stiahnutím súboru, stiahnutý GEDCOM nebude kompletný. Ak sa chcete uistiť, že je váš súbor celý, podívajte sa, či je na jeho konci riadok 0 TRLR. Stiahnutie súboru by malo trvať približne rovnako dlho ako jeho nahranie.";
$pgv_lang["pgv_registry"]		= "Zobraziť iné weby používajúce PhpGedView";
$pgv_lang["verify_upload_instructions"]	= "Ak zvolíte Pokračovať, bude starý GEDCOM súbor nahradený novým súborom, ktorý ste nahrali, a importovanie začne znovu. Ak zvolíte Zrušiť, zostane starý súbor zachovaný.";
$pgv_lang["cancel_upload"]		= "Ukončiť nahrávanie";
$pgv_lang["add_media_records"]		= "Pridať záznamy médií";
$pgv_lang["manage_media_files"]		= "Spravovať súbory médií";
$pgv_lang["link_media_records"]		= "Priradiť média osobám";


//-- Relationship chart messages
$pgv_lang["relationship_chart"]		= "Schéma vzťahov";
$pgv_lang["person1"]			= "Osoba 1";
$pgv_lang["person2"]			= "Osoba 2";
$pgv_lang["no_link_found"]		= "Medzi týmito dvomi osobami nebol nájdený žiadny (ďalší) vzťah.";
$pgv_lang["sibling"]			= "Súrodenec";
$pgv_lang["follow_spouse"]		= "Skontrolovať príbuzenstvo svadbou.";
$pgv_lang["timeout_error"]		= "Vykonávanie skriptu bolo ukončené pred dokončením vyhľadávania.";
$pgv_lang["son"]			= "Syn";
$pgv_lang["daughter"]			= "Dcéra";
$pgv_lang["son-in-law"]			= "Zať";
$pgv_lang["daughter-in-law"]		= "Nevesta";
$pgv_lang["grandchild"]			= "Vnúča";
$pgv_lang["grandson"]			= "Vnuk";
$pgv_lang["granddaughter"]		= "Vnučka";
$pgv_lang["brother"]			= "Brat";
$pgv_lang["sister"]			= "Sestra";
$pgv_lang["brother-in-law"]		= "Švagor";
$pgv_lang["sister-in-law"]		= "Švagriná";
$pgv_lang["aunt"]			= "Teta";
$pgv_lang["uncle"]			= "Strýko";
$pgv_lang["firstcousin"]		= "Bratranec";
$pgv_lang["femalecousin"]		= "Sestranica";
$pgv_lang["malecousin"]			= "Bratranec";
$pgv_lang["cousin-in-law"]		= "Nevlastný bratranec";
$pgv_lang["relationship_to_me"]		= "Vzťah ku mne";
$pgv_lang["rela_husb"]			= "Vzťah k manželovi";
$pgv_lang["rela_wife"]			= "Vzťah k manželke";
$pgv_lang["next_path"]			= "Nájsť ďalší vzťah";
$pgv_lang["show_path"]			= "Ukázať vzťah";
$pgv_lang["line_up_generations"]	= "Vyrovnať podľa generačnej úrovne";
$pgv_lang["oldest_top"]             	= "Zobraziť najstarších hore";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]		= "Ste si istý, že chcete zmazať tento údaj?";
$pgv_lang["access_denied"]		= "<b>Prístup bol odoprený</b><br />Nemáte prístup k tomuto zdroju.";
$pgv_lang["gedrec_deleted"]		= "Záznam bol úspešne zmazaný.";
$pgv_lang["gedcom_deleted"]		= "GEDCOM súbor [#GED#] bol úspešne zmazaný.";
$pgv_lang["changes_exist"]		= "V tomto GEDCOM súbore boly urobené zmeny.";
$pgv_lang["accept_changes"]		= "Prijať / Odmietnuť zmeny";
$pgv_lang["show_changes"]		= "Tento záznam bol aktualizovaný. Kliknite sem pre zobrazenie zmien.";
$pgv_lang["hide_changes"]		= "Ak chcete skryť zmeny, kliknite sem.";
$pgv_lang["review_changes"]		= "Revízia zmien v GEDCOM súboroch";
$pgv_lang["undo_successful"]		= "Návrat bol úspešný";
$pgv_lang["undo"]			= "Späť";
$pgv_lang["view_change_diff"]		= "Prehliadnúť si zmeny";
$pgv_lang["changes_occurred"]		= "U tejto osoby boly urobené nasledujúce zmeny:";
$pgv_lang["find_place"]			= "Nájsť miesto";
$pgv_lang["refresh"]			= "Obnoviť";
$pgv_lang["close_window"]		= "Zatvoriť okno";
$pgv_lang["close_window_without_refresh"] = "Zatvoriť okno bez opätovného načítania";
$pgv_lang["place_contains"]		= "Miesto obsahuje:";
$pgv_lang["accept_gedcom"]		= "U každej zmeny sa rozhodnite, či ju chcete prijať, alebo zamietnuť.<br />Ak chcete prijať všetky zmeny naraz, kliknite na \"Prijať všetky zmeny\" v políčku dolu.<br />Ak chcete viacej informácií k niektorej úprave, kliknite na \"Zobraziť rozdiely\" a uvidíte rozdiely medzi starou a novou verziou, <br /> alebo kliknite na \"Zobraziť priamo záznam GEDCOM\" a uvidíte novú verziu zapísanú priamo vo formáte GEDCOM.";
$pgv_lang["ged_import"]			= "Import";
$pgv_lang["now_import"]			= "Teraz by ste mali importovať záznamy do PhpGedView kliknutím na odkaz \"Importovať\".";
$pgv_lang["add_fact"]			= "Pridať nový údaj";
$pgv_lang["add"]			= "Pridať";
$pgv_lang["custom_event"]		= "Vlastná udalosť";
$pgv_lang["update_successful"]		= "Aktualizácia bola úspešná";
$pgv_lang["add_child"]			= "Pridať dieťa";
$pgv_lang["add_child_to_family"]	= "Pridať dieťa k tejto rodine";
$pgv_lang["add_sibling"]		= "Pridať brata alebo sestru";
$pgv_lang["add_son_daughter"]		= "Pridať syna alebo dcéru";
$pgv_lang["must_provide"]		= "Musíte poskytnúť";
$pgv_lang["delete_person"]		= "Zmazať túto osobu";
$pgv_lang["confirm_delete_person"]	= "Ste si istý, že chcete vymazať túto osobu z GEDCOM súboru?";
$pgv_lang["find_media"]			= "Nájsť média";
$pgv_lang["set_link"]			= "Nastaviť odkaz";
$pgv_lang["add_source_lbl"]		= "Pridať citáciu ku zdroju";
$pgv_lang["add_source"]			= "Pridať novú citáciu ku zdroju";
$pgv_lang["add_note_lbl"]		= "Pridať poznámku";
$pgv_lang["add_note"]			= "Pridať novú poznámku";
$pgv_lang["add_media_lbl"]		= "Pridať média";
$pgv_lang["add_media"]			= "Pridať do médií novú položku";
$pgv_lang["delete_source"]		= "Zmazať tento zdroj";
$pgv_lang["confirm_delete_source"]	= "Ste si istý, že chcete vymazať tento zdroj z GEDCOM súboru?";
$pgv_lang["add_husb"]			= "Pridať manžela";
$pgv_lang["add_husb_to_family"]		= "Pridať manžela k tejto rodine";
$pgv_lang["add_wife"]			= "Pridať manželku";
$pgv_lang["add_wife_to_family"]		= "Pridať manželku k tejto rodine";
$pgv_lang["find_family"]		= "Nájsť rodinu";
$pgv_lang["find_fam_list"]		= "Zostaviť zoznam rodín";
$pgv_lang["add_new_wife"]		= "Pridať novú manželku";
$pgv_lang["add_new_husb"]		= "Pridať nového manžela";
$pgv_lang["edit_name"]			= "Upraviť meno";
$pgv_lang["delete_name"]		= "Zmazať meno";
///////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["no_temple"]			= "No Temple - Living Ordinance";
///////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["replace"]			= "Nahradiť záznam";
$pgv_lang["append"]			= "Pripojiť záznam";
$pgv_lang["add_father"]			= "Pridať nového otca";
$pgv_lang["add_mother"]			= "Pridať novú matku";
$pgv_lang["add_obje"]			= "Pridať nový multimediálny súbor";
$pgv_lang["no_changes"]			= "Zatiaľ neboly urobené žiadne zmeny, ktoré by se maly preskúmať.";
$pgv_lang["accept"]				= "Prijať";
$pgv_lang["accept_all"]			= "Prijať všetky zmeny";
$pgv_lang["accept_successful"]	= "Zmeny boly prijaté a nové údaje zapísané do databáze";
$pgv_lang["edit_raw"]			= "Upraviť priamo záznam GEDCOM";
$pgv_lang["select_date"]		= "Vybrať dátum";
$pgv_lang["create_source"]		= "Vytvoriť nový zdroj";
$pgv_lang["new_source_created"]	= "Nový zdroj bol vytvorený.";
$pgv_lang["paste_id_into_field"]= "Vložte toto ID zdroja do políčok, z ktorých sa chcete odvolávať na tento zdroj.";
$pgv_lang["add_name"]				= "Pridať nové meno";
$pgv_lang["privacy_not_granted"]	= "Nemáte prístup k";
$pgv_lang["user_cannot_edit"]		= "Tento uživateľ nemôže upravovať tento GEDCOM.";
$pgv_lang["gedcom_editing_disabled"]	= "Upravovanie tohoto GEDCOMu bolo zakázané administrátorom systému.";
$pgv_lang["privacy_prevented_editing"]	= "Nastavenie utajenia vám neumožňuje upravovať tento záznam.";
$pgv_lang["add_asso"]				= "Pridať novú osobu";
$pgv_lang["edit_sex"]				= "Opraviť pohlavie";
$pgv_lang["ged_noshow"]				= "Této stránka bola zakázaná administrátorom stránky.";
$pgv_lang["bdm"]					= "Narodenia, úmrtia, sobáše";

//-- calendar.php messages
$pgv_lang["on_this_day"]		= "Tohoto dňa vo vašej histórii...";
$pgv_lang["in_this_month"]		= "V tomto mesiaci vo vašej histórii...";
$pgv_lang["in_this_year"]		= "Tohoto roku vo vašej histórii...";
$pgv_lang["year_anniversary"]		= "#year_var# výročie";
$pgv_lang["today"]			= "Dnes";
$pgv_lang["day"]			= "Deň:";
$pgv_lang["month"]			= "Mesiac:";
$pgv_lang["showcal"]			= "Udalosti k zobrazeniu:";
$pgv_lang["anniversary_calendar"]	= "Kalendár výročí";
$pgv_lang["sunday"]			= "nedeľa";
$pgv_lang["monday"]			= "pondelok";
$pgv_lang["tuesday"]			= "utorok";
$pgv_lang["wednesday"]			= "streda";
$pgv_lang["thursday"]			= "štvrtok";
$pgv_lang["friday"]			= "piatok";
$pgv_lang["saturday"]			= "sobota";
$pgv_lang["viewday"]			= "Zobraziť deň";
$pgv_lang["viewmonth"]			= "Zobraziť mesiac";
$pgv_lang["viewyear"]			= "Zobraziť rok";
$pgv_lang["all_people"]			= "Všetci ľudia";
$pgv_lang["living_only"]		= "Žijúci ľudia";
$pgv_lang["recent_events"]		= "Nedávne udalosti (< 100 rokov)";
$pgv_lang["day_not_set"]			= "Dátum nezadaný";
$pgv_lang["year_error"]			= "Dátumy pred rokom 1970 nie sú bohužiaľ podporované.";

//-- upload media messages
$pgv_lang["upload_media"]		= "Nahrať multimediálne súbory";
$pgv_lang["folder"]		 			= "Adresár na serveri";
$pgv_lang["media_file"]			= "Súbory médií";
$pgv_lang["thumbnail"]			= "Zmenšenina";
$pgv_lang["upload_successful"]		= "Nahranie bolo úspešné";
$pgv_lang["media_file_deleted"]		= "Súbor médií bol úspešne zmazaný.";
$pgv_lang["media_file_not_deleted"]	= "Súbor médií nemôže byť zmazaný.";
$pgv_lang["media_file_not_moved"]	= "Súbor médií nemôže byť presunutý.";
$pgv_lang["media_file_not_renamed"]	= "Súbor médií nemôže byť presunutý alebo premenovaný.";
$pgv_lang["thumbnail_deleted"]		= "Súbor náhľadu bol úspešne zmazaný.";
$pgv_lang["thumbnail_not_deleted"]	= "Súbor náhľadu nemôže byť zmazaný.";
$pgv_lang["media_record_deleted"]	= "Záznam médií #xref# a odkazy boli úspešne zmazané z databázi.";
$pgv_lang["media_record_not_deleted"]	= "Záznam médií #xref# a odkazy nemôžu byť zmazané z databázi.";
$pgv_lang["record_updated"]			= "Záznam #pid# bol úspešne aktualizovaný.";
$pgv_lang["record_not_updated"]		= "Záznam #pid# nemôže byť aktualizovaný.";
$pgv_lang["record_removed"]			= "Záznam #xref# bol úspešne odstránený z GEDCOMu.";
$pgv_lang["record_not_removed"]		= "Záznam #xref# nemôže byť odstránený z GEDCOMu.";
$pgv_lang["record_added"]			= "Záznam #xref# bol úspešne pridaný do GEDCOMu.";
$pgv_lang["record_not_added"]		= "Záznam #xref# nemôže byť pridaný do GEDCOMu.";
$pgv_lang["lost_password"]		= "Zabudli ste svoje heslo?";

//-- user self registration module
$pgv_lang["requestpassword"]		= "Zažiadať o nové heslo";
$pgv_lang["no_account_yet"]		= "Nemáte ešte svoj účet?";
$pgv_lang["requestaccount"]		= "Zažiadať o nový uživateľský účet";
$pgv_lang["emailadress"]		= "E-mailová adresa";
$pgv_lang["mandatory"] 			= "Polia označené * sú povinné.";

$pgv_lang["mail01_line01"]		= "Ahoj #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "Z adresy ( #SERVER_NAME# ) bol odoslaný požiadavok na prihlásenie pod vašou e-mailovou adresou ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "Boli použité nasledujúce údaje.";
$pgv_lang["mail01_line04"]		= "Prosím kliknite na odkaz dole a vyplňte požadované údaje pre overenie vášho účtu a vašej e-mailovej adresy.";
$pgv_lang["mail01_line05"]		= "Ak by ste tieto údaje nevyžadovali, môžete túto správu kľudne zmazať.";
$pgv_lang["mail01_line06"]		= "Žiadny ďalší e-mail z tohoto systému už nedostanete, pretože účet bude do siedmich dní bez overenia zmazaný.";

$pgv_lang["mail01_subject"]		= "Vaša registrácia na #SERVER_NAME#";

$pgv_lang["mail02_line01"]		= "Ahoj administrátor ...";
$pgv_lang["mail02_line02"]		= "Nový uživateľ sa zaregistroval na ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]		= "Uživateľ obdržal e-mail s údajmi nutnými k overeniu svojho účtu.";
$pgv_lang["mail02_line04"]		= "Keď si uživateľ dokončí toto overovanie, budete e-mailom informovaný, aby ste uživateľovi dali práva k prihláseniu na vaše stránky. Nový uživateľ sa bude môcť prihlásiť až potom čo mu zaktivujete účet.";
$pgv_lang["mail02_line04a"]			= "Keď si uživateľ dokončí toto overovanie, budete o tom informovaný e-mailom. Po verifikácii sa môže uživateľ prihlásiť bez akéhokoľvek vašeho zásahu.";

$pgv_lang["mail02_subject"]		= "Nová registrácia na #SERVER_NAME#";

$pgv_lang["hashcode"]			= "Overovací kód:";
$pgv_lang["thankyou"]			= "Ahoj #user_fullname# ...<br />Vďaka za registráciu.";
$pgv_lang["pls_note06"]			= "Teraz na e-mail ( #user_email# ) obdržíte potvrdenie. Tento e-mail použijte k aktivovaniu svojho účtu; ak se vám nepodarí aktivovat svoj účet do siedmich dní, bude vymazaný (potom sa môžete znovu pokúsiť zaregistrovať). Po vašej aktivácii vám ešte musí povoliť prístup administrátor. Abyste sa mohli prihlásiť na tieto stránky, budete potrebovať vedieť svoje prihlasovacie meno a heslo.";
$pgv_lang["pls_note06a"] 			= "Teraz na e-mail ( #user_email# ) obdržíte potvrdenie. Tento e-mail použijte k aktivovaniu svojho účtu; ak se vám nepodarí aktivovat svoj účet do siedmich dní, bude vymazaný (potom sa môžete znovu pokúsiť zaregistrovať). Po vašej aktivácii sa môžete okamžite prihlásiť do systému. Abyste sa mohli prihlásiť na tieto stránky, budete potrebovať vedieť svoje prihlasovacie meno a heslo.";

$pgv_lang["registernew"]		= "Potvrdenie nového účtu";
$pgv_lang["user_verify"]		= "Overenie uživateľa";
$pgv_lang["send"]			= "Odoslať";

$pgv_lang["pls_note07"]			= "Prosím vložte svoje uživateľské meno, heslo a overovací kód, ktorý ste obdržali z tohoto systému, pre overenie vašej žiadosti o účet.";
$pgv_lang["pls_note08"]			= "Údaje pre uživateľa #user_name# boli skontrolované.";

$pgv_lang["mail03_line01"]		= "Ahoj administrátor ...";
$pgv_lang["mail03_line02"]		= "Uživateľ #newuser[username]# ( #newuser[fullname]# ) skontroloval registračné údaje.";
$pgv_lang["mail03_line03"]		= "Pre prihlásenie a úpravu uživateľa a povolenie k prihláseniu na vaše stránky prosím kliknite na odkaz dolu.";
$pgv_lang["mail03_line03a"]			= "Nemusíte nič urobiť, uživateľ sa môže prihlásiť.";

$pgv_lang["mail03_subject"]		= "Nové overenie na #SERVER_NAME#";

$pgv_lang["pls_note09"]			= "Bol ste identifikovaný ako registrovaný uživateľ.";
$pgv_lang["pls_note10"]			= "Administrátor bol upozornený.<br />Keď Vám dá povolenie k prihláseniu, budete sa môcť prihlásiť zadaním svojho uživateľského mena a hesla.";
$pgv_lang["pls_note10a"]			= "Teraz sa môžete prihlásiť pod svojím uživateľom a heslom.";
$pgv_lang["data_incorrect"]		= "Údaje neboli správne!<br />Prosím skúste to znovu!";
$pgv_lang["user_not_found"]		= "Nebolo možné overiť údaje, ktoré ste vložili.  Prosím vráťte sa späť a skúste to znovu.";

$pgv_lang["lost_pw_reset"]		= "Zabudnuté heslo";

$pgv_lang["pls_note11"]			= "Ak chcete, aby vaše staré heslo bolo zmazané, pošlite nám uživatelské meno a e-mailovú adresu, ktorú ste zadal pri zakladaní svojho uživateľského účtu. <br /><br />Pošleme vám e-mailom odkaz na stránku, ktorá obsahuje zakódované heslo pre váš účet. Ak navštívite túto URL, budete mať možnosť zmeniť si heslo a prihlásiť sa do tohoto systému. Z bezpečnostných dôvodov by ste mali toto heslo uchovať v tajnosti (nemali by ho poznať ani administrátorovia týchto stránok; nebudeme sa naň pýtať).<br /><br />Ak budete požadovať pomoc administrátora, prosím kontaktujte administrátora stránok.";
$pgv_lang["enter_email"]		= "Musíte zadať e-mailovú adresu.";

$pgv_lang["mail04_line01"]		= "Ahoj #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Bolo zažiadané o nové heslo pre vaše uživateľské meno!";
$pgv_lang["mail04_line03"]		= "Doporučenie:";
$pgv_lang["mail04_line04"]		= "Teraz prosím kliknite na odkaz dole, prihláste sa novým heslom a ihneď si ho zmeňte, aby ste uchovali svoje údaje v tajnosti.";
$pgv_lang["mail04_line05"]			= "Po prihlásení vyberte link '#pgv_lang[myuserdata]#' v menu '#pgv_lang[mygedview]#' a vyplňte pole heslo, pre zmenu vášho hesla.";

$pgv_lang["mail04_subject"]		= "Dáta požadované na #SERVER_NAME#";

$pgv_lang["pwreqinfo"]			= "Ahoj...<br /><br />Na adresu (#user[email]#) bol zaslaný e-mail z novým heslom.<br /><br />Prosím skontrolujte svoju e-mailovú schránku, správu by ste mali obdržať v priebehu niekoľkých minút.<br /><br />Doporučenie:<br /><br />Potom, čo požiadate o e-mail, mali by ste sa na tieto stránky prihlásiť zo svojím novým heslom a zmeniť si ho, aby ste uchovali svoje údaje v tajnosti.";

$pgv_lang["editowndata"]		= "Môj účet";
$pgv_lang["savedata"]			= "Uložiť zmenené údaje";
$pgv_lang["datachanged"]		= "Uživateľské údaje boli zmenené!";
$pgv_lang["datachanged_name"]		= "Možno bude potrebné, aby ste sa prihlásili znovu (so svojím novým uživateľským menom).";
$pgv_lang["myuserdata"]			= "Môj účet";
$pgv_lang["verified"]			= "Uživateľ potvrdil registráciu";
$pgv_lang["verified_by_admin"]		= "Uživateľ bol adminom povolený";
$pgv_lang["user_theme"]			= "Môj motív";
$pgv_lang["mgv"]			= "MyGedView";
$pgv_lang["mygedview"]			= "Vstupná brána MyGedView";
$pgv_lang["passwordlength"]		= "Heslo musí obsahovať aspoň 6 znakov.";
$pgv_lang["admin_approved"]		= "Váš účet na #SERVER_NAME# bol povolený";
$pgv_lang["you_may_login"]		= " administrátorom stránok. Teraz sa môžete odkazom dolu prihlásiť do systému PhpGedView:";
$pgv_lang["welcome_text_auth_mode_1"]	=	"<center><b>VITAJTE NA TÝCHTO RODOPISNÝCH STRÁNKACH</b></center><br />Prístup na tieto stránky je povolený všetkým návštevníkom, ktorý tu majú zriadený účet. Ak tu už máte svoj účet, môžete sa na tejto stránke prihlásiť.<br /><br />Ak ešte účet nemáte, môžete požiadať o založenie kliknutím na príslušný odkaz na tejto stránke.<br />Po overení zadaných údajov vám administrátor účet zprístupní. Oznámenie o zprístupnení obdržíte e-mailom.";
$pgv_lang["welcome_text_auth_mode_2"]	=	"<center><b>VITAJTE NA TÝCHTO RODOPISNÝCH STRÁNKÁCH</b></center><br/>Prístup na tieto stránky je umožnený iba <b>prihláseným</b> užívateľom.<br />Ak tu už máte svoj účet, môžete sa na tejto stránke prihlásiť.<br /><br />Ak ešte účet nemáte, môžete požiadať o založenie kliknutím na príslušný odkaz na tejto stránke.<br />Po overení zadaných údajov administrátor vašu žiadosť buď prijme, alebo zamietne.<br />Oznámenie o prijatí vašej žiadosti obdržíte e-mailom.";
$pgv_lang["welcome_text_auth_mode_3"]	=	"<center><b>VITAJTE NA TÝCHTO RODOPISNÝCH STRÁNKACH</b></center><br />Prístup na tieto stránky je povolený iba <b>členom rodiny</b>.<br />Ak tu už máte svoj účet, môžete sa na tejto stránke prihlásiť.<br /><br />Ak ešte účet nemáte, môžete požiadať o založenie kliknutím na príslušný odkaz na tejto stránke.<br />Po overení zadaných údajov administrátor vašu žiadosť buď prijme, alebo odmietne.<br />Oznámenie o prijatí svojej žiadosti obdržíte e-mailom.";
$pgv_lang["welcome_text_cust_head"]		=	"<center><b>VITAJTE NA TÝCHTO RODOPISNÝCH STRÁNKACH</b></center><br />Prístup na tieto stránky je umožnený iba užívateľom, ktorý tu majú zriadený svoj uživateľský účet z heslom.<br />";


//-- mygedview page
$pgv_lang["welcome"]			= "Vitajte";
$pgv_lang["upcoming_events"]		= "Nadchádzajúce udalosti";
$pgv_lang["living_or_all"]			= "Zobraziť iba udalosti žijúcich osôb?";
$pgv_lang["basic_or_all"]			= "Zobraziť iba narodenia, úmrtia a sobáše?";
$pgv_lang["no_events_living"]		= "Neexistujú žiadne udalosti žijúcich osôb pre nasledujúcich #pgv_lang[global_num1]# dní.";
$pgv_lang["no_events_living1"]		= "Neexistujú žiadne udalosti žijúcich osôb pre zajtrajšok.";
$pgv_lang["no_events_all"]			= "Neexistujú žiadne udalosti pre nasledujúcich #pgv_lang[global_num1]# dní.";
$pgv_lang["no_events_all1"]			= "Neexistujú žiadne udalosti pre zajtrajšok.";
$pgv_lang["no_events_privacy"]		= "Existujú udalosti pre nasledujúcich #pgv_lang[global_num1]# dní, ale nastavenie utajenia neumožňuje zobraziť ich.";
$pgv_lang["no_events_privacy1"]		= "Existujú udalosti pre zajtrajšok, ale nastavenie utajenia znemožňuje zobraziť ich.";
$pgv_lang["more_events_privacy"]	= "<br />Existuje viacej udalostí pre nasledujúcich #pgv_lang[global_num1]# dní, ale nastavenie utajenia neumožňuje zobraziť ich.";
$pgv_lang["more_events_privacy1"]	= "<br />Existuje viacej udalostí pre zajtrajšok, ale nastavenie utajenia neumožňuje zobraziť ich.";
$pgv_lang["none_today_living"]		= "Neexistujú žiadne udalosti žijúcich osôb pre dnešok.";
$pgv_lang["none_today_all"]			= "Neexistujú žiadne udalosti pre dnešok.";
$pgv_lang["none_today_privacy"]		= "Existujú udalosti pre dnešok, ale nastavenie utajenia neumožňuje zobraziť ich.";
$pgv_lang["more_today_privacy"]		= "<br />Existuje viacej udalostí pre dnešok, ale nastavenie utajenia neumožňuje zobraziť ich.";
$pgv_lang["chat"]			= "Chat";
$pgv_lang["users_logged_in"]		= "Prihlásený uživatelia";
$pgv_lang["anon_user"]				= "1 anonymný prihlásený uživateľ";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# anonymný prihlásený uživatelia";
$pgv_lang["login_user"]				= "1 prihlásený uživateľ";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# prihlásený uživatelia";
$pgv_lang["no_login_users"]			= "Žiadny prihlásený a anonymný uživatelia";
$pgv_lang["message"]			= "Poslať správu";
$pgv_lang["my_messages"]		= "Moje správy";
$pgv_lang["date_created"]		= "Data boli poslané:";
$pgv_lang["message_from"]		= "E-mailová adresa";
$pgv_lang["message_from_name"]		= "Vaše meno:";
$pgv_lang["message_to"]			= "Adresát:";
$pgv_lang["message_subject"]		= "Predmet:";
$pgv_lang["message_body"]		= "Text:";
$pgv_lang["no_to_user"]			= "Nezadali ste príjemcu správy.  Nie je možné pokračovať.";
$pgv_lang["provide_email"]		= "Prosím zadajte svoju e-mailovú adresu, aby sme vás prípadne mohli kontaktovat. Ak nám neposkytnete svoju e-mailovú adresu, nebudeme vám môcť odpovedať. Vaša e-mailová adresa nebude použitá k žiadnym iným účelom než k odpovedi na vašu otázku.";
$pgv_lang["reply"]			= "Odpovedať";
$pgv_lang["message_deleted"]		= "Správa bola zmazaná";
$pgv_lang["message_sent"]		= "Správa bola odoslaná";
$pgv_lang["reset"]			= "Reset";
$pgv_lang["site_default"]		= "Domáca stránka";
$pgv_lang["mygedview_desc"]		= "Vaša stránka MyGedView vám umožňuje uchovávať záložky svojich priateľov, sledovať nadchádzajúce udalosti a spolupracovať z ostatnými uživateľmi PhpGedView.";
$pgv_lang["no_messages"]		= "Nemáte žiadne nové správy.";
$pgv_lang["clicking_ok"]		= "Ak kliknete na OK, otvorí sa ďalšie okno, kde budete môcť kontaktovať #user[fullname]#";
$pgv_lang["favorites"]			= "Obľúbené";
$pgv_lang["my_favorites"]		= "Moje obľúbené";
$pgv_lang["no_favorites"]		= "Nevybrali ste žiadne obľúbené. Ak chcete pridať nejakú osobu ku svojim obľúbeným, nájdite informácie o tejto osobe a potom kliknite na odkaz \"Pridať do mojich obľúbených\" alebo vyplňte políčko ID dole pre pridanie osoby pomocou ID čísla.";
$pgv_lang["add_to_my_favorites"]	= "Pridať do mojich obľúbených";
$pgv_lang["gedcom_favorites"]		= "Obľúbené u tohoto GEDCOMu";
$pgv_lang["no_gedcom_favorites"]	= "V tomto momente nie sú označené žiadne obľúbené. Admin môže nastaviť zobrazenie obľúbených pri štarte.";
$pgv_lang["confirm_fav_remove"]		= "Ste si istý, že chcete odstrániť túto položku z vašich obľúbených?";
$pgv_lang["invalid_email"]		= "Prosím zadajte platnú e-mailovú adresu.";
$pgv_lang["enter_subject"]		= "Prosím zadajte predmet správy.";
$pgv_lang["enter_body"]			= "Prosím zadajte text správy pred jej odoslaním.";
$pgv_lang["confirm_message_delete"]	= "Ste si istý, že chcete zmazať túto správu?  Nebude možné ju neskôr získať späť.";
$pgv_lang["message_email1"]		= "Táto správa bola zaslaná na váš PhpGedView uživateľský účet z ";
$pgv_lang["message_email2"]		= "Túto správu ste poslali na PhpGedView uživateľský účet:";
$pgv_lang["message_email3"]		= "Túto správu ste poslali administrátorovi PhpGedView:";
$pgv_lang["viewing_url"]		= "Táto správa bola poslaná v priebehu zobrazovania nasledujúcich URL: ";
$pgv_lang["messaging2_help"]		= "Ak ste odoslali túto správu, obdržíte jej kopiu na svoju e-mailovú adresu, ktorú ste uviedli pri registrácii.";
$pgv_lang["random_picture"]		= "Náhodný obrázok";
$pgv_lang["message_instructions"]	= "<b>Prosím pozor:</b> Súkromné informácie žijúcich osôb budú poskytnuté iba rodinným príbuzným a blízkym priateľom. Predtím, než obdržíte akékoľvek súkromné dáta, budete požiadaný o overenie vášho vzťahu. Niekedy môžu byť súkromnej povahy i dáta zomrelých osôb. Ak je to tento prípad, potom je to z toho dôvodu, že nie je dosť známych informácií o tejto osobe, aby bolo možné rozhodnúť, či žije alebo nie, a potom teda ani žiadne ďalšie informácie o tejto osobe nemáme.<br /><br />Pred vznesením dotazu na nejakú osobu, prosím skontrolujte u nej dáta, miesta a blízkych príbuzných, aby ste si boli istý, že sa pýtate na tu správnu osobu. Ak robíte zmeny v genealogických dátach, prosím uveďte pramene, z ktorých ste čerpali.<br /><br />";
$pgv_lang["sending_to"]			= "Tato správa bude odoslaná na #TO_USER#";
$pgv_lang["preferred_lang"]	 	= "Tento uživateľ uprednostňuje príjem správ cez #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "Tento GEDCOM bol vytvorený v programe <b>#SOFTWARE# #VERSION#</b>.";
$pgv_lang["gedcom_created_on"]		= "Tento GEDCOM bol vytvorený <b>#DATE#</b>.";
$pgv_lang["gedcom_created_on2"]		= "<b>#DATE#</b>";
$pgv_lang["gedcom_stats"]		= "Štatistika GEDCOMu";
$pgv_lang["stat_individuals"]		= "Celkove osôb";
$pgv_lang["stat_families"]		= "Celkove rodín";
$pgv_lang["stat_sources"]		= "Celkove prameňov";
$pgv_lang["stat_other"]			= "Ostatných záznamov";
$pgv_lang["stat_earliest_birth"] 	= "Najstarší rok narodenia";
$pgv_lang["stat_latest_birth"] 		= "Posledný rok narodenia";
$pgv_lang["stat_earliest_death"] 	= "Najstarší rok úmrtia";
$pgv_lang["stat_latest_death"] 		= "Posledný rok úmrtia";
$pgv_lang["customize_page"]		= "Upraviť vstupnú bránu MyGedView";
$pgv_lang["customize_gedcom_page"]	= "Upraviť úvodnú stránku tohoto GEDCOMu";
$pgv_lang["upcoming_events_block"]	= "Blok nadchádzajúcich udalostí";
$pgv_lang["upcoming_events_descr"]	= "V bloku nadchádzajúcich udalostí je zobrazený zoznam udalostí z momentálne zobrazeného GEDCOMu, ktorých výročie si pripomenieme v priebehu nasledujúcich 30 dní.  Cez uživateľskú stránku MyGedView sa v bloku zobrazia iba živí ľudia.  Cez vstupnú bránu GEDCOMu sa zobrazia všetci ľudia.";
$pgv_lang["todays_events_block"]	= "Blok pre dnešný deň";
$pgv_lang["todays_events_descr"]	= "Tohoto dňa vo vašej histórii... V bloku bude zobrazený zoznam udalostí z momentálne zobrazeného GEDCOMu, ktoré sa stali tohoto dňa. Ak nie sú nájdené žiadne udalosti, blok sa neukáže. Cez uživateľskú stránku MyGedView sa v bloku zobrazí iba zoznam žijúcich ľudí. Cez vstupnú bránu GEDCOMu sa zobrazia všetci ľudia.";
$pgv_lang["logged_in_users_block"]	= "Prihlásený uživatelia";
$pgv_lang["logged_in_users_descr"]	= "Kliknutím na tento odkaz zistíte, ktorý uživatelia sú práve teraz prihlásený.";
$pgv_lang["user_messages_block"]	= "Blok uživateľských správ";
$pgv_lang["user_messages_descr"]	= "V bloku správ je zobrazený zoznam správ, ktoré boli poslané aktívnemu uživateľovi.";
$pgv_lang["user_favorites_block"]	= "Blok uživateľských Obľúbených";
$pgv_lang["user_favorites_descr"]	= "V bloku uživateľských Obľúbených sa uživateľovi zobrazí zoznam obľúbených osôb v tomto systéme, takže sa k ním môže ľahšie dostať.";
$pgv_lang["welcome_block"]		= "Uvítací blok uživateľa";
$pgv_lang["welcome_descr"]		= "Uvítací blok uživateľa ukazuje uživateľovi súčasný dátum a čas, odkazy pre úpravu jeho účtu alebo pre zobrazenie vlastného vývodu a odkaz pre úpravu vstupnej brány.";
$pgv_lang["random_media_block"]		= "Blok náhodného média";
$pgv_lang["random_media_descr"]		= "Blok náhodného média náhodne vyberie obrázok alebo inú mediálnu položku v práve zobrazenom GEDCOMe a zobrazí ju uživateľovi.";
$pgv_lang["random_media_persons_or_all"]= "Zobraziť iba osoby a udalosti alebo všetko?";
$pgv_lang["random_media_persons"]	= "Osoby";
$pgv_lang["random_media_events"]	= "Udalosti";
$pgv_lang["gedcom_block"]		= "Uvítací blok GEDCOM";
$pgv_lang["gedcom_descr"]		= "Uvítací blok GEDCOM funguje rovnako ako uvítací blok uživateľa – vítá návštevníka stránok a zobrazuje nadpis práve zobrazeného GEDCOMu a aktuálny dátum a čas.";
$pgv_lang["gedcom_favorites_block"]	= "Blok Obľúbených GEDCOMu";
$pgv_lang["gedcom_favorites_descr"]	= "Blok Obľúbených GEDCOMu umožňuje administrátorovi stránok vybrať svoje obľúbené osoby, aby k nim mali návštevníci jednoduchší prístup. Je to možnosť, ako zvýrazniť osoby, ktoré sú v histórii vášho rodu dôležité.";
$pgv_lang["gedcom_stats_block"]		= "Blok štatistiky GEDCOMu";
$pgv_lang["gedcom_stats_descr"]		= "Blok štatistiky GEDCOMu ukazuje návštevníkovi základné informácie o GEDCOM súbore, ako napríklad čas vytvorenia alebo počet osôb v súbore.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Zobraziť najčastejšie priezviská?";
$pgv_lang["portal_config_intructions"]	= "Na tejto stránke si môžete upraviť stránku rozmiestnením blokov na stránke podľa vašej potreby. Stránka je rozdelená na dve časti: 'Hlavný' a 'Pravý' oddiel. Bloky 'Hlavného' oddielu sú väčšie a sú umiestnené pod titulkom stránky. 'Pravý' oddiel začíná napravo od titulku a pokračuje dole po pravej strane. Každý oddiel ná svoj vlastný zoznam blokov, ktoré sa zobrazia na stránke v poradí, v akom sú v zozname. Bloky môžete pridávať, odstraňovať a preskupovať podľa potreby.";
$pgv_lang["login_block"]		= "Prihlasovací blok";
$pgv_lang["login_descr"]		= "Prihlasovací blok zobrazuje uživateľom uživateľské meno a heslo k prihlásení.";
$pgv_lang["theme_select_block"] 	= "Blok pre výber motívu";
$pgv_lang["theme_select_descr"] 	= "Blok pre výber motívu sa zobrazuje, i keď nie je zmena motívu povolená.";
$pgv_lang["block_top10_title"]		= "Najčastejšie priezviská";
$pgv_lang["block_top10"]		= "Blok priezvísk Top-10";
$pgv_lang["block_top10_descr"]		= "V tomto bloku vidíte tabuľku 10 najpoužívanejších priezvísk v tejto databáze. Počet zobrazených priezvísk je možné nastaviť v konfigurácii GEDCOMu.";
$pgv_lang["gedcom_news_block"]		= "Blok noviniek GEDCOMu";
$pgv_lang["gedcom_news_descr"]		= "Blok noviniek GEDCOMu návštevníkom ukazuje správy a články pridané administrátorom. Tu je vhodné napríklad upozorňovať na aktualizované GEDCOM súbory, alebo oznamovať rodinné stretnutia a iné významné události.";
$pgv_lang["gedcom_news_limit"]		= "Obmedziť zobrazenie do:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Bez obmedzenia";
$pgv_lang["gedcom_news_limit_date"]	= "Vek položky";
$pgv_lang["gedcom_news_limit_count"]	= "Počet položiek";
$pgv_lang["gedcom_news_flag"]		= "Limit:";
$pgv_lang["gedcom_news_archive"] 	= "Zobraziť archív";
$pgv_lang["user_news_block"]		= "Uživateľský denník";
$pgv_lang["user_news_descr"]		= "Uživateľský denník umožňuje uživateľom uchovávať poznámky, alebo viesť denník online.";
$pgv_lang["my_journal"]			= "Môj denník";
$pgv_lang["no_journal"]			= "Nevytvorili ste v denníku žiadne položky.";
$pgv_lang["confirm_journal_delete"]	= "Naozaj chcete vymazať túto položku z denníku?";
$pgv_lang["add_journal"]		= "Pridať do denníku nový záznam";
$pgv_lang["gedcom_news"]		= "Novinky";
$pgv_lang["confirm_news_delete"]	= "Naozaj chcete z Noviniek vymazať túto položku?";
$pgv_lang["add_news"]			= "Pridať nový článok";
$pgv_lang["no_news"]			= "Žiadne články, novinky neboli pridané.";
$pgv_lang["edit_news"]			= "Pridať/Upraviť záznam v Denníku/Novinkách";
$pgv_lang["enter_title"]		= "Vložte prosím nadpis.";
$pgv_lang["enter_text"]			= "Vložte prosím text tohoto záznamu.";
$pgv_lang["news_saved"]			= "Príspevok do Noviniek/Denníku bol úspešne uložený.";
$pgv_lang["article_text"]		= "Vložte text:";
$pgv_lang["main_section"]		= "Bloky hlavného oddielu";
$pgv_lang["right_section"]		= "Bloky pravého oddielu";
$pgv_lang["available_blocks"]		= "Použiteľné bloky";
$pgv_lang["move_up"]			= "Posunúť nahoru";
$pgv_lang["move_down"]			= "Posunúť dolu";
$pgv_lang["move_right"]			= "Presunúť doprava";
$pgv_lang["move_left"]			= "Presunúť doľava";
$pgv_lang["broadcast_all"]		= "Rozoslať všetkým uživateľom";
$pgv_lang["hit_count"]			= "Počet prístupov:";
$pgv_lang["phpgedview_message"]		= "Správa PhpGedView";
$pgv_lang["common_surnames"]		= "Najčastejšie priezviská";
$pgv_lang["default_news_title"]		= "Vitajte vo svojom rodokmeni";
$pgv_lang["default_news_text"]		= "Výstup tohoto rodokmeňa je zpracovaný pomocou <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a>. Táto stránka ponúka úvod a prehľad k tomuto rodokmeňa. Pre vstup do rodokmeňa vyberte z menu jednu zo schém, zoznam osôb, alebo vyhľadávanie mena či miesta.<br /><br />V prípade problémov s používaním tohoto systému, kliknite na nápovedu a dozviete sa, ako pracovať zo stránkou, na ktorej sa práve nachádzate.<br /><br />Ďakujeme, že ste tieto stránky navštívili.";
$pgv_lang["reset_default_blocks"]	= "Obnoviť pôvodné bloky";
$pgv_lang["recent_changes"]		= "Posledné zmeny";
$pgv_lang["recent_changes_block"]	= "Blok posledných zmien";
$pgv_lang["recent_changes_descr"]	= "V Bloku posledných zmien sa zobrazia všetky zmeny, ktoré boli v GEDCOMeu urobené v priebehu posledného mesiaca. Tento blok vám pomôže sledovať tieto zmeny. Zmeny sa rozoznávajú podľa tagu CHAN, definovaného v štandarde GEDCOM.";
$pgv_lang["recent_changes_none"]	= "<b>Nie sú žiadne zmeny za posledných #pgv_lang[global_num1]# dní.</b><br />";
$pgv_lang["recent_changes_some"]	= "<b>Zmeny urobené za posledných #pgv_lang[global_num1]# dní.</b><br />";
$pgv_lang["show_empty_block"]		= "Ukryť tento blok keď je prázdny?";
$pgv_lang["hide_block_warn"]		= "Ak ukryjete prázdny blok, nebudete môcť meniť jeho nastavenie až do doby než nebude zobrazený.";
$pgv_lang["delete_selected_messages"]	= "Zmazať vybrané správy";
$pgv_lang["use_blocks_for_default"]	= "Použiť tieto bloky ako implicitné nastavenie blokov pre všetkých uživateľov?";
$pgv_lang["block_not_configure"]	=	"Tento blok nemôže byť konfigurovaný.";

//-- upgrade.php messages
$pgv_lang["options"]			= "Voľby:";
$pgv_lang["inc_languages"]		= " Jazyky";

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["config_update_ok"]		= "Konfiguračný súbor bol úspešne aktualizovaný.";
$pgv_lang["date_of_entry"]				= "Dátum záznamu v orginálnom zdroji";
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
$pgv_lang["folder_created"]		= "Vytvorená zložka";
$pgv_lang["folder_no_create"]		= "Vytvoriť adresár nie je možné";

//-- validate GEDCOM
$pgv_lang["performing_validation"]	= "Vykonávanie validácie (skontrolovanie) GEDCOMu, vyberte potrebné možnosti a kliknite na 'Pokračovať'";
////////////////////////////////////////////////////////////////////////////
$pgv_lang["changed_mac"]		= "Nájdené Macintoshove zakončenia riadkov. Tam, kde bol len návrat na koniec (riadku?), bol vložený návrat na koniec a riadek bol doplnený.";
////////////////////////////////////////////////////////////////////////////
$pgv_lang["changed_places"]		= "Rozoznané neplatné kódovanie miest. Záznamy o miestach boli vyčistené tak, aby vyhovovali štandardu GEDCOM 5.5. Ukážka z vášho GEDCOM:";
$pgv_lang["invalid_dates"]		= "Rozoznané nesprávné formáty dátumu, vyčistením budú tieto formáty zmenené do podoby DD MMM YYYY (napr. 1 JAN 2005).";
$pgv_lang["valid_gedcom"]		= "Validný GEDCOM. Žiadne opravy nebolo treba.";
$pgv_lang["optional_tools"]		= "Pred importovaním môžete zvoliť spustenie niektorého z ponúkaných nástrojov.";
$pgv_lang["optional"]			= "Voliteľné nástroje";
$pgv_lang["day_before_month"]		= "Deň pred mesiacom (DD MM YYYY)";
$pgv_lang["month_before_day"]		= "Mesiac pred dňom (MM DD YYYY)";
$pgv_lang["do_not_change"]		= "Nemeniť";
$pgv_lang["change_id"]			= "Zmeniť ID osôb na:";
$pgv_lang["example_place"]		= "Ukážka neplatného formátu miesta z vášho GEDCOMu:";
$pgv_lang["example_date"]		= "Ukážka neplatného dátového formátu z vášho GEDCOMu:";
$pgv_lang["add_media_tool"]		= "Nástroj pre pridanie médií";
$pgv_lang["launch_media_tool"]		= "Kliknite sem, ak chcete spustiť nástroj pre pridanie médií.";
$pgv_lang["add_media_descr"]		= "Tento nástroj pridá do GEDCOMu tagy OBJE. Po ukončení pridávania médií zatvorte toto okno.";
$pgv_lang["highlighted"]		= "Zvýraznený obrázok";
$pgv_lang["extension"]			= "Prípona";
$pgv_lang["order"]			= "Poradie";
$pgv_lang["inject_media_tool"]		= "Pridať média do GEDCOM súboru";
$pgv_lang["add_media_button"]		= "Pridať média";
$pgv_lang["media_linked"]		= "Tento objekt médií je spojený s nasledujúcim:";
$pgv_lang["media_not_linked"]		= "Tento objekt médií nie je spojený s žiadnym GEDCOM záznamom.";
$pgv_lang["phpinfo"]			= "PHPInfo";
$pgv_lang["admin_info"]			= "Informačný blok";
$pgv_lang["admin_site"]			= "Administrácia stránky";
$pgv_lang["admin_geds"]			= "Administrácia dát a GEDCOMU";
$pgv_lang["media_table_created"]	= "Tabuľka <i>Médiá</i> bola úspešne vytvorená.";
$pgv_lang["click_to_add_media"]		= "Kliknite sem pre pridanie médií (zo zoznamu hore) do GEDCOMu #GEDCOM#";
$pgv_lang["adds_completed"]		= "Média boli do GEDCOMu úspešne pridané.";
$pgv_lang["ansi_encoding_detected"]	= "Rozoznané kódovanie ANSI. PhpGedView pracuje najlepšie zo súbormi s kódovaním UTF-8.";
$pgv_lang["invalid_header"]		= "V GEDCOM súbore boli nájdené riadky pred hlavičkou GEDCOM <b>0&nbsp;HEAD</b>. Pri čistení súboru budú tieto riadky odstránené.";
$pgv_lang["macfile_detected"]		= "Bol nájdený súbor pre Macintosh. Pri čistení bude tento súbor prevedený na súbor pre DOS.";
$pgv_lang["place_cleanup_detected"]	= "Bolo rozoznané zlé kódovanie miest. Tieto chyby by mali byť opravené. Nasledujúci príklad ukazuje jedno z nesprávne zapísaných miest:";
$pgv_lang["cleanup_places"]		= "Vyčistenie miest";
$pgv_lang["empty_lines_detected"]	= "Vo vašom GEDCOM súbore boli nájdené prázdné riadky. Pri čistení budú tieto riadky odstránené.";
$pgv_lang["import_options"]		= "Voľby importu.";
$pgv_lang["import_options_help"] 	= "Môžete vybrať dodatočné voľby, ktoré budú použité pri importe GEDCOMu.";
$pgv_lang["verify_gedcom"]		= "Verifikácia GEDCOMu";
$pgv_lang["verify_gedcom_help"]		= "Tu môžete zvoliť ďalšie pokračovanie načítania a importu GEDCOM súboru, alebo zrušiť načítanie a import.";
$pgv_lang["import_statistics"]		= "Štatistika importu";

//-- hourglass chart
$pgv_lang["hourglass_chart"]			= "Schéma presýpacích hodín";
$pgv_lang["choose_report"]			= "Vybrať správu, ktorá sa má vytvoriť";
$pgv_lang["enter_report_values"]		= "Zadať kritéria pre správu";
$pgv_lang["selected_report"]			= "Vybraná správa";
$pgv_lang["run_report"]				= "Zobraziť správu";
$pgv_lang["select_report"]			= "Vybrať správu";
$pgv_lang["download_report"]			= "Stiahnuť správu";
$pgv_lang["reports"]				= "Správy";
$pgv_lang["pdf_reports"]			= "Správy v PDF";
$pgv_lang["html_reports"]			= "Správy v HTML";
$pgv_lang["family_group_report"]		= "Správa o rodine";
$pgv_lang["page"]				= "Strana";
$pgv_lang["of"] 				= "z";
$pgv_lang["enter_famid"]			= "Zadajte ID rodiny";
$pgv_lang["show_sources"]			= "Zobraziť zdroje?";
$pgv_lang["show_notes"] 			= "Zobraziť poznámky?";
$pgv_lang["show_basic"] 			= "Tlačiť základné údaje, i keď sú prázdne?";
$pgv_lang["show_photos"]			= "Zobraziť fotky?";
$pgv_lang["relatives_report_ext"]		= "Rozšírený zoznam príbuzných";
$pgv_lang["with"]				= "s";
$pgv_lang["on"]					= "na";
$pgv_lang["in"]					= "v";
$pgv_lang["individual_report"]			= "Správa o osobe";
$pgv_lang["enter_pid"]				= "Zadať ID osoby";
$pgv_lang["individual_list_report"]		= "Správa zo zoznamom osôb";
$pgv_lang["generated_by"]			= "Vytvorené v";
$pgv_lang["list_children"]			= "Zoradiť všetky deti podľa dátumu narodenia.";
$pgv_lang["birth_report"]			= "Správa o dátume a mieste narodenia";
$pgv_lang["birthplace"]				= "Miestom narodenia je";
$pgv_lang["birthdate1"]				= "Rozsah dátumu narodenia začína";
$pgv_lang["birthdate2"]				= "Rozsah dátumu narodenia končí";
$pgv_lang["death_report"]			= "Report miest a dátumov úmrtí";
$pgv_lang["deathplace"]				= "Miesto úmrtia obsahuje";
$pgv_lang["deathdate1"]				= "Rozsah dátumu úmrtia začína";
$pgv_lang["deathdate2"]				= "Rozsah dátumu úmrtia končí";
$pgv_lang["marr_report"]			= "Report miest a dátumov sobášov";
$pgv_lang["marrplace"]				= "Miesto sobáša obsahuje";
$pgv_lang["marrdate1"]				= "Rozsah dátumu sobášov začína";
$pgv_lang["marrdate2"]				= "Rozsah dátumu sobášov končí";
$pgv_lang["sort_by"]				= "Zoradené podľa";


$pgv_lang["cleanup"]				= "Opraviť";
$pgv_lang["skip_cleanup"]			= "Preskočiť opravovanie";
$pgv_lang["dynasty_list"]			= "Prehľad rodín";
$pgv_lang["patriarch_list"]			= "Zoznam praotcov";
$pgv_lang["statistics"]				= "Štatistika";
$pgv_lang["merge_records"]			= "Zlúčiť záznamy";
$pgv_lang["merge_same"] 			= "Záznamy nie sú rovnakého typu. Nie je možné zlúčit záznamy rôznych typov.";
$pgv_lang["merge_step1"]			= "Zlučovanie - krok 1 z 3";
$pgv_lang["merge_step2"]			= "Zlučovanie - krok 2 z 3";
$pgv_lang["merge_step3"]			= "Zlučovanie - krok 3 z 3";
$pgv_lang["select_gedcom_records"]		= "Označte 2 GEDCOM záznamy, ktoré sa majú zlúčiť. Záznamy musia byť rovnakého typu.";
$pgv_lang["merge_to"]				= "Zlúčiť do ID:";
$pgv_lang["merge_from"] 			= "Zlúčiť z ID:";
$pgv_lang["merge_facts_same"]			= "Nasledujúce údaje boli v oboch záznamoch úplne rovnaké, a budú teda automaticky zlúčené.";
$pgv_lang["no_matches_found"]			= "Nenájdené zodpovedajúce údaje";
$pgv_lang["unmatching_facts"]			= "Nasledujúce údaje si nezodpovedajú. Označte informáciu, ktorú chcete zachovať.";
$pgv_lang["record"] 				= "Záznam";
$pgv_lang["adding"] 				= "Pridanie";
$pgv_lang["updating_linked"]			= "Aktualizovanie pripojenej správy";
$pgv_lang["merge_more"] 			= "Zlúčiť viacej záznamov.";
$pgv_lang["same_ids"]				= "Zadali ste rovnaké ID čísla. Nemôžete zlúčiť údaje zo sebou samými.";
$pgv_lang["ancestry_chart"] 			= "Prehľad predkov";
$pgv_lang["gen_ancestry_chart"]			= "Prehľad predkov do #PEDIGREE_GENERATIONS# pokolení";
$pgv_lang["chart_style"]			= "Štýl schémy";
$pgv_lang["chart_list"]				= "Zoznam";
$pgv_lang["chart_booklet"]   			= "Zošit";
$pgv_lang["show_cousins"]			= "Zobraz synovcov / netere";
$pgv_lang["sosa_2"] 				= "Otec";
$pgv_lang["sosa_3"] 				= "Matka";
$pgv_lang["sosa_4"] 				= "Dedko";
$pgv_lang["sosa_5"] 				= "Babka";
$pgv_lang["sosa_6"] 				= "Dedko";
$pgv_lang["sosa_7"] 				= "Babka";
$pgv_lang["sosa_8"] 				= "Pradedko";
$pgv_lang["sosa_9"] 				= "Prababka";
$pgv_lang["sosa_10"]				= "Pradedko";
$pgv_lang["sosa_11"]				= "Prababka";
$pgv_lang["sosa_12"]				= "Pradedko";
$pgv_lang["sosa_13"]				= "Prababka";
$pgv_lang["sosa_14"]				= "Pradedko";
$pgv_lang["sosa_15"]				= "Prababka";
$pgv_lang["sosa_16"]				= "Prapradedko";
$pgv_lang["sosa_17"]				= "Praprababka";
$pgv_lang["sosa_18"]				= "Prapradedko";
$pgv_lang["sosa_19"]				= "Praprababka";
$pgv_lang["sosa_20"]				= "Prapradedko";
$pgv_lang["sosa_21"]				= "Praprababka";
$pgv_lang["sosa_22"]				= "Prapradedko";
$pgv_lang["sosa_23"]				= "Praprababka";
$pgv_lang["sosa_24"]				= "Prapradedko";
$pgv_lang["sosa_25"]				= "Praprababka";
$pgv_lang["sosa_26"]				= "Prapradedko";
$pgv_lang["sosa_27"]				= "Praprababka";
$pgv_lang["sosa_28"]				= "Prapradedko";
$pgv_lang["sosa_29"]				= "Praprababka";
$pgv_lang["sosa_30"]				= "Prapradedko";
$pgv_lang["sosa_31"]				= "Praprababka";
$pgv_lang["sosa_32"]			   	= "Praprapradedko";
$pgv_lang["sosa_33"]			   	= "Prapraprababka";
$pgv_lang["sosa_34"]			   	= "Praprapradedko";
$pgv_lang["sosa_35"]			   	= "Prapraprababka";
$pgv_lang["sosa_36"]			   	= "Praprapradedko";
$pgv_lang["sosa_37"]			   	= "Prapraprababka";
$pgv_lang["sosa_38"]			   	= "Praprapradedko";
$pgv_lang["sosa_39"]			   	= "Prapraprababka";
$pgv_lang["sosa_40"]			   	= "Praprapradedko";
$pgv_lang["sosa_41"]			   	= "Prapraprababka";
$pgv_lang["sosa_42"]			   	= "Praprapradedko";
$pgv_lang["sosa_43"]			   	= "Prapraprababka";
$pgv_lang["sosa_44"]			   	= "Praprapradedko";
$pgv_lang["sosa_45"]			   	= "Prapraprababka";
$pgv_lang["sosa_46"]			   	= "Praprapradedko";
$pgv_lang["sosa_47"]			   	= "Prapraprababka";
$pgv_lang["sosa_48"]			   	= "Praprapradedko";
$pgv_lang["sosa_49"]			   	= "Prapraprababka";
$pgv_lang["sosa_50"]			   	= "Praprapradedko";
$pgv_lang["sosa_51"]			   	= "Prapraprababka";
$pgv_lang["sosa_52"]			   	= "Praprapradedko";
$pgv_lang["sosa_53"]			   	= "Prapraprababka";
$pgv_lang["sosa_54"]			   	= "Praprapradedko";
$pgv_lang["sosa_55"]			   	= "Prapraprababka";
$pgv_lang["sosa_56"]			   	= "Praprapradedko";
$pgv_lang["sosa_57"]			   	= "Prapraprababka";
$pgv_lang["sosa_58"]			  	= "Praprapradedko";
$pgv_lang["sosa_59"]			   	= "Prapraprababka";
$pgv_lang["sosa_60"]			   	= "Praprapradedko";
$pgv_lang["sosa_61"]			   	= "Prapraprababka";
$pgv_lang["sosa_62"]			   	= "Praprapradedko";
$pgv_lang["sosa_63"]			   	= "Prapraprababka";
$pgv_lang["compact_chart"]			= "Kompaktná schéma";
$pgv_lang["fan_chart"]				= "Vejárová schéma";
$pgv_lang["gen_fan_chart"]  			= "#PEDIGREE_GENERATIONS# - generačná vejárová schéma";
$pgv_lang["fan_width"]				= "Šírka vejára";
$pgv_lang["gd_library"]				= "Zlá konfigurácia PHP serveru: pre prácu z obrázkami je potrebná knihovňa GD 2.x.";
$pgv_lang["gd_freetype"]			= "Zlá konfigurácia PHP serveru: pre prácu z TrueType fontami je potrebná knihovňa Freetype.";
$pgv_lang["gd_helplink"]			= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]			= "Súbor z týmto fontom nebol na PHP servere nájdený.";
$pgv_lang["fanchart_IE"]			= "Vejárová schéma nemôže byť vytlačená priamo vaším prehliadačom. Musíte ju najskôr uložiť ako obrázok a následne vytlačiť.";
$pgv_lang["rss_descr"]				= "Novinky a odkazy zo stránky #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]			= "Materiál vytvorilo PhpGedView";
$pgv_lang["rss_feeds"]				= "RSS novinky";
$pgv_lang["no_feed_title"]			= "RSS novinky nie su dostupné";
$pgv_lang["no_feed"]				= "RSS novinky pre túto stránku PhpGedView nie sú dostupné";
$pgv_lang["feed_login"]				= "Ak máte účet pre túto stránku PhpGedView môžete <a href=\"#AUTH_URL#\">sa prihlásiť</a> na server pomocou Základnej HTTP autorizácie pre zobrazenie súkromných informácií.";
$pgv_lang["attendant"] = "Sluha";
$pgv_lang["attending"] = "Služba";
$pgv_lang["best_man"] = "Družba";
$pgv_lang["bridesmaid"] = "Družička";
$pgv_lang["buyer"] = "Kupujúci";
$pgv_lang["circumciser"] = "Obriezkár";
$pgv_lang["civil_registrar"] = "Štátny matrikár";
$pgv_lang["friend"] = "Priateľ";
$pgv_lang["godfather"] = "Kmotor";
$pgv_lang["godmother"] = "Kmotra";
$pgv_lang["godparent"] = "Krstný rodič";
$pgv_lang["informant"] = "Informátor";
$pgv_lang["nurse"] = "Pestúnka";
$pgv_lang["lodger"] = "Podnájomník";
$pgv_lang["priest"] = "Kňaz";
$pgv_lang["rabbi"] = "Rabín";
$pgv_lang["registry_officer"] = "Matričný úradník";
$pgv_lang["seller"] = "Predávajúci";
$pgv_lang["servant"] = "Úradník";
$pgv_lang["twin"] = "Dvojča";
$pgv_lang["twin_brother"] = "Dvojča - brat";
$pgv_lang["twin_sister"] = "Dvojča - sestra";
$pgv_lang["witness"] = "Svedok";
$pgv_lang["statutci"]			= "Nie je možné vytvoriť index";
$pgv_lang["statnnames"]         	= "Počet osôb =";
$pgv_lang["statnfam"]           	= "Počet rodín =";
$pgv_lang["statnmale"]          	= "Počet mužov =";
$pgv_lang["statnfemale"]        	= "Počet žien =";
$pgv_lang["statvars"]			= "Vyberte nasledujúcu premennú pre graf";
$pgv_lang["statlxa"]			= "Po ose X (horizontálne)";
$pgv_lang["statlya"]			= "Po ose Y (vertikálne)";
$pgv_lang["statlza"]			= "Po ose Z";
$pgv_lang["stat_10_none"]		= "Nič";
$pgv_lang["stat_11_mb"]			= "Mesiac narodenia";
$pgv_lang["stat_13_mm"]			= "Mesiac svadby";
$pgv_lang["stat_14_mb1"]		= "Mesiac narodenia prvého dieťaťa vo vzťahu";
$pgv_lang["stat_15_mm1"]		= "Mesiac prvej svadby";
$pgv_lang["stat_16_mmb"]		= "Mesiace medzi svadbou a prvým dieťaťom.";
$pgv_lang["stat_17_arb"]		= "Vek vztiahnutý k roku narodenia.";
$pgv_lang["stat_18_ard"]		= "Vek vztiahnutý k roku úmrtia.";
$pgv_lang["stat_19_arm"]		= "Vek v roku svadby.";
$pgv_lang["stat_20_arm1"]		= "Vek v roku prvej svadby.";
$pgv_lang["stat_21_nok"]		= "Počet detí na rodinu.";
$pgv_lang["stat_gmx"]			= "označte hodnoty pre mesiac";
$pgv_lang["stat_gax"]			= "označte hodnoty pre vek";
$pgv_lang["stat_gnx"]			= "označte hodnoty pre čísla";
$pgv_lang["stat_200_none"]		= "Všetko (alebo nič)";
$pgv_lang["stat_201_num"]		= "Spočítať";
$pgv_lang["stat_202_perc"]		= "Percentá";
$pgv_lang["stat_301_mf"]		= "Muži / ženy";
$pgv_lang["stat_302_cgp"]		= "Obdobie. Skontrolujte hodnoty pre obdobie osy Z.";
$pgv_lang["statmess1"]			= "<b>Upravte nasledujúce riadky súvisiace s nastavením pre osu X alebo osu Z</b>";
$pgv_lang["statar_xgp"]			= "hodnoty pre periody (os X):";
$pgv_lang["statar_xgl"]			= "hodnoty pre vek (os X):";
$pgv_lang["statar_xgm"]			= "hodnoty pre mesiac (os X):";
$pgv_lang["statar_xga"]			= "hodnoty pre čísla (os X):";
$pgv_lang["statar_zgp"]			= "hodnoty pre periody (os Z):";
$pgv_lang["statreset"]			= "Reset";
$pgv_lang["statsubmit"]			= "Zobraziť graf";
$pgv_lang["statistiek_list"]	= "Štatistiský graf";
$pgv_lang["stpl"]			= "...";
$pgv_lang["stplGDno"]			= "Graphics Display Library nie je dostupná v PHP 4. Upozornite vašeho systémového administrátora";
$pgv_lang["stpljpgraphno"]		= "Modul JPgraph nie je v adresári <i>phpgedview/jpgraph/</i>. Prosím stiahnite ho z http://www.aditus.nu/jpgraph/jpdownload.php<br> <h3> a nainštalujte do adresára <i>PhpGedview/jpgraph/</i></h3><br>";
$pgv_lang["stplinfo"]			= "premenné pre osnovu:";
$pgv_lang["stpltype"]			= "Typ:";
$pgv_lang["stplnoim"]			= "Nie je implementované:";
$pgv_lang["stplmf"]			= "/ Muži-ženy";
$pgv_lang["stplipot"]			= "/ za jednotku času";
$pgv_lang["stplmonth"]			= "Mesiac";
$pgv_lang["stplnumbers"]		= "Počet";
$pgv_lang["stplage"]			= "Vek";
$pgv_lang["stplgzas"]			= "hranice osy Z:";
$pgv_lang["stplperc"]			= "Percentá";
$pgv_lang["stplnumof"]			= "Počet";
$pgv_lang["stplmarrbirth"]		= "Mesiace medzi sobášom a narodením prvého dieťaťa.";
$pgv_lang["stat_300_none"]		= "Nikto";
$pgv_lang["stat_12_md"]			= "Mesiac úmrtia";
$pgv_lang["alive_in_year"]		= "Žijúci v roku";
$pgv_lang["is_alive_in"]		= "Žijúci v #YEAR#";
$pgv_lang["alive"]			= "Živý";
$pgv_lang["dead"]			= "Zomrelý";
$pgv_lang["maybe"]			= "Možno";
$pgv_lang["show_thumbnail"]		= "Zobraz náhľad";
$pgv_lang["image_format"]		= "Formát obrázku";
$pgv_lang["media_format"]		= "Formát médií";
$pgv_lang["image_size"]			= "Rozmery obrázku -- ";
$pgv_lang["media_file_size"]		= "Veľkosť médií";
$pgv_lang["no_thumb_dir"]		= "adresár náhľadov neexistuje a nemohol byť založený.";
$pgv_lang["manage_media"]		= "Spravovať média";
$pgv_lang["gen_thumb"]			= "Vytvor náhľad";
$pgv_lang["add_directory"]		= "Pridaj adresár";
$pgv_lang["move_to"]			= "Presunúť do -->";
$pgv_lang["security_no_create"]		= "Bezpečnostné hlásenie: Súbor <b><i>index.php</i> neexistuje v";
$pgv_lang["security_not_exist"]		= "Bezpečnostné hlásenie: Súbor <b><i>index.php</i></b> nemohol byť vytvorený v";
$pgv_lang["illegal_chars"]		= "Neprípustné znaky v mene";
$pgv_lang["link_media"]			= "Priraď média";
$pgv_lang["to_person"]			= "ku osobe";
$pgv_lang["to_family"]			= "ku rodine";
$pgv_lang["to_source"]			= "ku zdroju";
$pgv_lang["media_id"]			= "ID média";
$pgv_lang["invalid_id"]			= "Žiadne také ID neexistuje v tomto GEDCOM súbore.";
$pgv_lang["media_exists"]			= "Súbor médií už existuje.";
$pgv_lang["media_thumb_exists"]		= "Náhľad médií už existuje.";
$pgv_lang["move_file_success"]		= "Súbory medií a náhľadov boli úspešne presunuté.";
$pgv_lang["media_folder_corrupt"]	= "Adresár médií je vadný.";
$pgv_lang["max_media_depth"]		= "Môžete ísť iba do #MEDIA_DIRECTORY_LEVELS# úrovne adresárov";
$pgv_lang["definitions"]		= "Definície";
$pgv_lang["description"]			= "Popis";
$pgv_lang["block_desc"]				= "Popis bloku";
$pgv_lang["click_here"]				= "Kliknúť sem pre pokračovanie";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />Kliknite na toto tlačítko na uloženie zmien, ktoré ste urobili.<br /><br />Vrátite sa na  stránku #pgv_lang[welcome]# alebo #pgv_lang[mygedview]#, ale zmeny nebudú zobrazené. Na zobrazenie uložených zmien môžete použiť funkciu vašeho prehliadača Aktualizovať.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Tu je krátký popis každého z blokov, ktorý môžete umiestniť na stránku #pgv_lang[welcome]# alebo #pgv_lang[mygedview]#.<br /><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br /><br />";
$pgv_lang["block_summary_table"]	= "&nbsp;";
$pgv_lang["total_places"]			= "Nájdené miesta";
$pgv_lang["media_contains"]			= "Médiá obsahujú:";
$pgv_lang["repo_contains"]			= "Pramene obsahujú:";
$pgv_lang["source_contains"]		= "Zdroje obsahujú:";
$pgv_lang["display_all"]			= "Zobraziť všetko";
$pgv_lang["accesskeys"]				= "Klávesové skratky";
$pgv_lang["accesskey_skip_to_content"]	= "C";
$pgv_lang["accesskey_search"]	= "S";
$pgv_lang["accesskey_skip_to_content_desc"]	= "Skok na obsah";
$pgv_lang["accesskey_viewing_advice"]	= "0";
$pgv_lang["accesskey_viewing_advice_desc"]	= "Zobraziť radu";
$pgv_lang["accesskey_home_page"]	= "1";
$pgv_lang["accesskey_help_content"]	= "2";
$pgv_lang["accesskey_help_current_page"]	= "3";
$pgv_lang["accesskey_contact"]	= "4";
$pgv_lang["accesskey_individual_details"]	= "I";
$pgv_lang["accesskey_individual_relatives"]	= "R";
$pgv_lang["accesskey_individual_notes"]	= "N";
$pgv_lang["accesskey_individual_sources"]	= "O";
$pgv_lang["accesskey_individual_media"]	= "A";
$pgv_lang["accesskey_individual_research_log"]	= "L";
$pgv_lang["accesskey_individual_pedigree"]	= "P";
$pgv_lang["accesskey_individual_descendancy"]	= "D";
$pgv_lang["accesskey_individual_timeline"]	= "T";
$pgv_lang["accesskey_individual_relation_to_me"]	= "M";
$pgv_lang["accesskey_individual_gedcom"]	= "G";
$pgv_lang["accesskey_family_parents_timeline"]	= "P";
$pgv_lang["accesskey_family_children_timeline"]	= "D";
$pgv_lang["accesskey_family_timeline"]	= "T";
$pgv_lang["accesskey_family_gedcom"]	= "G";
$pgv_lang["add_faq_header"] = "FAQ - hlavička";
$pgv_lang["add_faq_body"] = "FAQ - telo";
$pgv_lang["add_faq_order"] = "FAQ - pozícia";
$pgv_lang["no_faq_items"] = "FAQ zoznam je prázdny.";
$pgv_lang["position_item"] = "Pozícia položky";
$pgv_lang["faq_list"] = "FAQ zoznam";
$pgv_lang["confirm_faq_delete"] = "Ste si istý, že chcete zmazať položku FAQ?";
$pgv_lang["preview"] =  "Náhľad";
$pgv_lang["no_id"] = "Žiadne FAQ ID nebolo špecifikované!";
$pgv_lang["hs_title"] 			= "Prehľadať text nápovedy";
$pgv_lang["hs_search"] 			= "Hľadať";
$pgv_lang["hs_close"] 			= "Zatvoriť okno";
$pgv_lang["hs_results"] 		= "Nájdené výsledky:";
$pgv_lang["hs_keyword"] 		= "Pátrať po";
$pgv_lang["hs_searchin"]		= "Hľadať v";
$pgv_lang["hs_searchuser"]		= "Uživateľský help";
$pgv_lang["hs_searchconfig"]	= "Administrátorský help";
$pgv_lang["hs_searchhow"]		= "Druh vyhľadávania";
$pgv_lang["hs_searchall"]		= "Všetky slová";
$pgv_lang["hs_searchany"]		= "Ktorékoľvek slovo";
$pgv_lang["hs_searchsentence"]	= "Presne frázu";
$pgv_lang["hs_intruehelp"]		= "Iba text nápovedy";
$pgv_lang["hs_inallhelp"]		= "Všetok text";
$pgv_lang["media_import"] = "Importovať a konvertovať média";
$pgv_lang["confirm_folder_delete"] = "Ste si istý, že chcete zmazať tento adresár?";
$pgv_lang["choose"] = "Vyber:";
$pgv_lang["account_information"] = "Informácie o účte";
$pgv_lang["TYPE__audio"] = "Audio";
$pgv_lang["TYPE__book"] = "Kniha";
$pgv_lang["TYPE__card"] = "Karta";
$pgv_lang["TYPE__certificate"] = "Certifikát";
$pgv_lang["TYPE__document"] = "Dokument";
$pgv_lang["TYPE__electronic"] = "Elektronický";
$pgv_lang["TYPE__fiche"] = "Mikrofiš";
$pgv_lang["TYPE__film"] = "Mikrofilm";
$pgv_lang["TYPE__magazine"] = "Časopis";
$pgv_lang["TYPE__manuscript"] = "Rukopis";
$pgv_lang["TYPE__map"] = "Mapa";
$pgv_lang["TYPE__newspaper"] = "Noviny";
$pgv_lang["TYPE__photo"] = "Fotografia";
$pgv_lang["TYPE__tombstone"] = "Náhrobok";
$pgv_lang["TYPE__video"] = "Video";

$pgv_lang["quick_update_title"] = "Rýchla aktualizácia";
$pgv_lang["quick_update_instructions"] = "Táto stránka vám umožňuje rychle aktualizovať informácie o osobe. Musíte iba zadať informácie, ktoré sú nové, alebo ktoré sa zmenily (oproti aktuálnym v databáze). Vaše zmeny budú predložené ku schváleniu administrátorovi predtým, než budú prístupné všetkým.";
$pgv_lang["update_name"] = "Aktualizovať meno";
$pgv_lang["update_fact"] = "Aktualizovať udalosť";
$pgv_lang["update_fact_restricted"] = "Aktualizácia tejto udalosti je zakázaná:";
$pgv_lang["update_photo"] = "Aktualizovať foto";
$pgv_lang["photo_replace"] = "Chcete prepísať starú fotku touto novou?";
$pgv_lang["select_fact"] = "Vyber udalosť";
$pgv_lang["update_address"] = "Aktualizácia adresy";
$pgv_lang["add_new_chil"] = "Pridať nové dieťa";
$pgv_lang["top10_pageviews_descr"]	= "Tento blok ukáže 10 záznamov, ktoré boli najčastejšie zobrazené. Tento blok vyžaduje aby bolo povolené počitadlo prístupov v konfigurácii GEDCOMU.";
$pgv_lang["top10_pageviews"]		= "Najčastejšie zobrazované záznamy";
$pgv_lang["top10_pageviews_block"]		= "Blok najčastejšie zobrazovaných záznamov";
$pgv_lang["user_default_tab"]		= "Implicitné záložky k zobrazeniu na osobnej informačnej stránke";
$pgv_lang["stepfamily"]				= "Nevlastná rodina";
$pgv_lang["stepdad"]				= "Nevlastný otec";
$pgv_lang["stepmom"]				= "Nevlastná matka";
$pgv_lang["stepsister"]				= "Nevlastná sestra";
$pgv_lang["stepbrother"]			= "Nevlastný brat";
$pgv_lang["max_upload_size"]		= "Maximálna veľkosť uploadu:";
$pgv_lang["edit_fam"]				= "Upraviť rodinu";
$pgv_lang["fams_charts"]			= "Nastavenia pre rodinu";
$pgv_lang["sort_by_birth"]			= "Triediť podľa dátumu narodenia";
$pgv_lang["reorder_children"]		= "Znovu usporiadať deti";
$pgv_lang["add_from_clipboard"]		= "Pridať zo schránky:";
$pgv_lang["record_copied"]			= "Záznam bol skopírovaný do schránky";
$pgv_lang["copy"]					= "Kopíruj";
$pgv_lang["cut"]					= "Vystrihnúť";
$pgv_lang["indis_charts"]			= "Nastavenia pre osobu";
$pgv_lang["edit_indi"] 				= "Zmeniť osobu";
$pgv_lang["locked"]					= "Nemeniť";
$pgv_lang["privacy"]				= "Súkromné";
$pgv_lang["number_sign"]			= "#";
$pgv_lang["show_spouses"]		= "Zobrazenie manželov";
$pgv_lang["changelog"]				= "Zmeny verzie #VERSION#";
$pgv_lang["view_changelog"]			= "Zobraziť changelog.txt súbor";
$pgv_lang["html_block_descr"]		= "Toto je jednoduchý HTML blok, ktorý môžete pridať na svoju stránku pre zobrazenie ľubovolných správ.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Sem vložte váš názov</b></p><br /><p>Kliknite na tlačítko konfigurácia";
$pgv_lang["html_block_sample_part2"]	= "pre zmenu, ktorá je zobrazená tu.</p>";
$pgv_lang["html_block_name"]		= "HTML blok";
$pgv_lang["htmlplus_block_name"]	= "Pokročilé HTML";
$pgv_lang["htmlplus_block_descr"]	= "Toto je HTML blok, ktorý môžete umiestniť na vašu stránku a pridať do neho ktorýkoľvek druh správ, ktorý chcete. Do HTML textu môžete vložiť odkazy na informácie z vašeho GEDCOMu.";
$pgv_lang["htmlplus_block_templates"] = "Šablóny";
$pgv_lang["htmlplus_block_content"] = "Obsah";
$pgv_lang["htmlplus_block_narrative"] = "Epický štýl (iba Angličtina)";
$pgv_lang["num_to_show"]			= "Počet položiek k zobrazeniu";
$pgv_lang["days_to_show"]			= "Počet dní k zobrazeniu";
$pgv_lang["before_or_after"]		= "Umiestniť súčty pred alebo za mená?";
$pgv_lang["before"]					= "pred";
$pgv_lang["after"]					= "po";
$pgv_lang["config_block"]			= "Kofigurácia bloku";
$pgv_lang["pls_note12"]				= "Prosím použijte toto pole k popisu prečo chcete založiť účet na tejto stránke a aký je váš vzťah k rodokmeňu.";
$pgv_lang["enter_comments"]			= "Prosim napíšte svoj pribuzenský vzťah k dátam do poľa komentáre.";
$pgv_lang["comments"]				= "Poznámky";
$pgv_lang["none"]					= "Žiadny";
$pgv_lang["ahnentafel_report"]		= "Vývod (Ahnentafel).";
$pgv_lang["ahnentafel_header"]		= "Vývod (Ahnentafel) pre";
$pgv_lang["ahnentafel_generation"]	= "Generácia";
$pgv_lang["ahnentafel_pronoun_m"]	= "On";
$pgv_lang["ahnentafel_pronoun_f"]	= "Ona";
$pgv_lang["ahnentafel_born_m"]		= "narodený";
$pgv_lang["ahnentafel_born_f"]		= "narodená";
$pgv_lang["ahnentafel_christened_m"] = "pokrstený";
$pgv_lang["ahnentafel_christened_f"] = "pokrstená";
$pgv_lang["ahnentafel_married_m"]	= "ženatý";
$pgv_lang["ahnentafel_married_f"]	= "vydatá";
$pgv_lang["ahnentafel_died_m"]		= "zomrel";
$pgv_lang["ahnentafel_died_f"]		= "zomrela";
$pgv_lang["ahnentafel_buried_m"]	= "pochovaný";
$pgv_lang["ahnentafel_buried_f"]	= "pochovaná";
$pgv_lang["ahnentafel_place"]		= "v";
$pgv_lang["ahnentafel_no_details"]	= "ale detaily nie sú známe";
$pgv_lang["child-family"]			= "Rodičia a súrodenci";
$pgv_lang["spouse-family"]			= "Manžel(ka) a deti";
$pgv_lang["direct-ancestors"]		= "Predkovia v priamej línii";
$pgv_lang["ancestors"]				= "Predkovia v priamej línii a ich rodiny";
$pgv_lang["descendants"]			= "Potomkovia";
$pgv_lang["choose_relatives"]		= "Vyber príbuzných";
$pgv_lang["relatives_report"]		= "Správa o príbuzných";
$pgv_lang["total_living"]			= "Žijúci celkove";
$pgv_lang["total_dead"]				= "Zomrelý celkove";
$pgv_lang["total_not_born"]			= "Ešte nenarodený celkove";
$pgv_lang["remove_custom_tags"]		= "Odstrániť uživateľské PGV príznaky? (napr. _PGVU, _THUM)";
$pgv_lang["download_zipped"]		= "Export GEDCOMU ako ZIP súboru?";
$pgv_lang["cookie_login_help"]		= "Táto stránka si zapamätá vaše predchádzajúce prihlásenie. Tým umožníte prístup k vaším súkromným informáciám a ďalším uživateľským nastaveniam. Ak budete chcieť editovať, alebo administrovať tieto stránky, musíte sa  pre zvýšenie bezpečnosti znovu prihlásiť.";
$pgv_lang["remember_me"]			= "Uložiť v tomto počítači?";
$pgv_lang["add_unlinked_person"]	= "Pridať nezávislú osobu";
$pgv_lang["add_unlinked_source"]	= "Pridať nezávislý zdroj";
$pgv_lang["fams_with_surname"]		= "Rodina s priezviskom #surname#";
$pgv_lang["support_contact"]		= "Kontakt na technickú pomoc";
$pgv_lang["genealogy_contact"]		= "Kontakt genealogický";
$pgv_lang["continue_import"]		= "Pokračuj v importe miest";
$pgv_lang["importing_places"]		= "Import záznamov miest";
$pgv_lang["common_upload_errors"]	= "Táto chyba je pravdepodobne spôsobená tým, že súbor, ktorý ste skúšali načítať prekročil limit stanovený vaším hostiteľom. Implicitný limit v PHP je 2MB. Môžete kontaktovať vašu hostiteľskú podporu a dohodnúť zväčšenie limitu v php.ini súbore, alebo môžete načítať súbor pomocou FTP. Použijte < href=\"uploadgedcom.php?action=add_form\"><b>Add GEDCOM</b></a> stránku k pridaniu GEDCOM súboru pomocou FTP.";
$pgv_lang["total_memory_usage"]		= "Celkové využitie pamäte:";
$pgv_lang["mothers_family_with"]	= "Matkina rodina s";
$pgv_lang["fathers_family_with"]	= "Otcova rodina s";
$pgv_lang["halfbrother"]			= "Nevlastný brat";
$pgv_lang["halfsister"]				= "Nevlastná sestra";
$pgv_lang["halfsibling"]			= "Nevlastný súrodenec";
$pgv_lang["family_timeline"]		= "Ukáž rodinu na časovej ose";
$pgv_lang["children_timeline"]		= "Ukáž deti na časovej ose";
$pgv_lang["other"]					= "Ďalšie";
$pgv_lang["sort_by_marriage"]		= "Triedenie podľa dátumu svadby";
$pgv_lang["reorder_families"]		= "Pretriediť rodiny";
$pgv_lang["indis_with_surname"]		= "Osoby s priezviskom #surname#";
$pgv_lang["first_letter_fname"]		= "Vyber písmeno k zobrazeniu osôb, ktorých meno začíná týmto písmenom.";
$pgv_lang["import_marr_names"]		= "Import mien po sobáši";
$pgv_lang["marr_name_import_instr"]	= "Kliknite na tlačítko dole, ak chcete aby PhpGedView odhadol priezviská po sobáši pre ženy v tomto GEDCOMe. To vám umožní vyhľadávať a zobrazovať ženy podľa ich priezviska po sobáši.";
$pgv_lang["calc_marr_names"]		= "Odhadnúť mená po sobáši";
$pgv_lang["total_names"]			= "Mená celkove";
$pgv_lang["upload_file"]			= "Načítanie súboru z vašeho počítača";
$pgv_lang["thumb_genned"]			= "Náhľad bol automaticky generovaný";
$pgv_lang["thumbgen_error"]			= "Nie je možné vytvoriť náhľad pre";
$pgv_lang["generate_thumbnail"]		= "Vytvor náhľad automaticky z";
$pgv_lang["auto_thumbnail"]			= "Automatický náhľad";
$pgv_lang["no_upload"]				= "Nie je povolené načítať súbory médií, pretože nie sú povolené multimediálne položky v konfigurácii, alebo zložka Media je chránená proti zápisu.";
$pgv_lang["upload"]					= "Import";
$pgv_lang["top10_pageviews_nohits"]	= "Žiadne prístupy k zobrazeniu.";
$pgv_lang["top10_pageviews_msg"]	= "Pre správne fungovanie tohoto bloku musí byť povolené počitadlo v konfigurácii GEDCOMu.";
$pgv_lang["review_changes_descr"]	= "Blok \"Čakajúce zmeny\" ukazuje uživateľom s právom editovať, zoznam záznamov, ktoré boli zmenené v online režime a ktoré doteraz čakajú na kontrolu a akceptáciu. Tieto zmeny čakajú na potvrdenie, alebo zamietnutie. <br /><br />Ak je tento blok povolený, uživatelia s právom akceptácie dostanú raz denne e-mail, ktorý ich upozorní na potrebu kontroly týchto zmien.";
$pgv_lang["review_changes_block"]	= "Čakajúce zmeny";
$pgv_lang["review_changes_email"]	= "Odoslať pripomínacie e-maily?";
$pgv_lang["review_changes_email_freq"]	= "Frekvencia pripomínacích e-mailov (v dňoch)";
$pgv_lang["review_changes_subject"]	= "PhpGedView - prehľad zmien";
$pgv_lang["review_changes_body"]	= "Boli urobené online zmeny v genealogickej databáze. Tieto zmeny musia byť skontrolované a potvrdené predtým, než se zobrazia všetkým uživateľom. Prosím použite URL dole ku vstupu do PhpGedView stráky a prihláseniu do systému k revízii zmien.";

if (file_exists( "languages/lang.sk.extra.php")) require  "languages/lang.sk.extra.php";
$pgv_lang["server_file"]				= "Meno súboru na servere";
$pgv_lang["server_file_advice"]			= "Nemeňte uložené orginálne meno súboru.";
$pgv_lang["server_file_advice2"]		= "Musíte vložiť URL začínajúcu na &laquo;http://&raquo;.<br />";
$pgv_lang["server_folder"]				= "Meno adresára na servere";
$pgv_lang["add_linkid_advice"]			= "Vložte alebo vyhľadajte ID osoby, rodiny alebo zdroja, ku ktorému má byť tento súbor médií pripojený.";
$pgv_lang["use_browse_advice"]			= "Použite tlačítko &laquo;Prehľadať&raquo; na vyhľadanie vašeho lokálneho počítača pre žiadaný súbor.";
$pgv_lang["server_folder_advice"]		= "You can enter up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# folder names to follow the default &laquo;#GLOBALS[MEDIA_DIRECTORY]#&raquo;.<br />Do not enter the &laquo;#GLOBALS[MEDIA_DIRECTORY]#&raquo; part of the destination folder name.";
$pgv_lang["server_folder_advice2"]		= "Tento vstup je ignorovaný, ak ste zadali URL do poľa pre meno súboru.";
$pgv_lang["add_media_other_folder"]		= "Ďalší adresár... prosím zadajte";
$pgv_lang["add_media_file"]				= "Existujúci súbor médii na servere";
$pgv_lang["descend_report"]				= "Zoznam potomkov";
$pgv_lang["descendancy_header"]		= "Zoznam potomkov pre";
$pgv_lang["link_to_existing_media"]		= "Link na existujúcu položku médií";
$pgv_lang["page_size"]					= "Veľkosť stránky";
$pgv_lang["record_not_found"]			= "Požadovaný GEDCOM záznam nebol nájdený. To môže byť spôsobené linkom na neplatnú osobu, alebo poškodeným GEDCOM súborom.";
$pgv_lang["record_marked_deleted"]		= "Tento záznam je označený na zmazanie, po schválení administrátorom.";
$pgv_lang["result_page"]				= "Stránka výsledku";
$pgv_lang["edit_media"]					= "Upraviť položku médií";
$pgv_lang["wiki_main_page"]				= "Wiki - hlavná stránka";
$pgv_lang["wiki_users_guide"]			= "Wiki - príručka uživateľa";
$pgv_lang["wiki_admin_guide"]			= "Wiki - príručka administrátora";
$pgv_lang["no_search_for"]			= "Uistite sa, že máte vybrané kritéria pre vyhľadávanie.";
$pgv_lang["no_search_site"]			= "Uistite sa, že máte vybranú aspoň jednu vzdialenú stránku.";
$pgv_lang["other_searches"]			= "Ďalšie hľadania";
$pgv_lang["multi_site_search"] 		= "Multi stránkové hľadanie";
$pgv_lang["search_sites"] 			= "Stránky na hľadanie";
$pgv_lang["search_sites_discription"] = "Hľadať známe stránky";
$pgv_lang["search_asso_text_unavailable"] = "Spojenie <br /> ešte nie je dostupné s <br /> hľadaním stránky";
$pgv_lang["no_known_servers"]		= "Žiadny známy server <br /> Nebudú nájdené žiadne výsledoky";
$pgv_lang["basic_search_discription"] = "Základné hľadanie stránky";
$pgv_lang["advanced_search_discription"] = "Rozšírené hľadanie stránky";
$pgv_lang["basic_search"]			= "hľadanie";
$pgv_lang["advanced_search"]		= "Rozšírené hľadanie stránky";
$pgv_lang["name_search"]			= "Meno:";
$pgv_lang["birthdate_search"]		= "Dátum narodenia:";
$pgv_lang["birthplace_search"]		= "Miesto narodenia:";
$pgv_lang["deathdate_search"]		= "Dátum úmrtia:";
$pgv_lang["deathplace_search"]		= "Miesto úmrtia:";
$pgv_lang["gender_search"]			= "Pohlavie:";
$pgv_lang["site_list"]				= "Stránka:";
$pgv_lang["site_had"]				= "obsahuje nasledujúce";
$pgv_lang["invalid_search_multisite_input"] = "Prosím vložte niektorý z následujúcich údajov: meno, dátum narodenia, miesto narodenia, datum úmrtia, miesto úmrtia, pohlavie.";
$pgv_lang["invalid_search_multisite_input_gender"] = "Prosím hľadajte ešte raz z viac informáciami než iba pohlavím";
$pgv_lang["link_manage_servers"]    = "Správa stránok";
$pgv_lang["indi_is_remote"]			= "Informácie tejto osoby boli linkované zo vzdialanej stránky.";
$pgv_lang["link_remote"]            = "Pripojiť vzdialenú osobu";
$pgv_lang["label_gedcom_id"]        = "GEDCOM ID";
$pgv_lang["label_gedcom_id2"]       = "GEDCOM ID:";
$pgv_lang["label_add_remote_link"]  = "Pridať link";
$pgv_lang["error_remote"]           = "Máte vybranú vzdialenú stránku.";
$pgv_lang["error_same"]             = "Máte vybranú totožnú stránku.";
$pgv_lang["error_server_exists"]    = "Stránka ktorú skúšate vložiť už neexistuje, prosím vyberte ju zo zoznamu dole. Použiť nejakú existujúcu stránku?";
$pgv_lang["lbl_server_list"]        = "Použiť existujúcu stránku.";
$pgv_lang["lbl_type_server"]        = "Vložte novú stránku.";
$pgv_lang["link_success"]		= "Úspešne pridané pripojenie";
$pgv_lang["error_url_blank"]		= "Prosím nenechajte názov a URL vzdialenej stránky prázdny";
$pgv_lang["error_siteauth_failed"]	= "Neúspešná autorizácia na vzdialenej stránke";
$pgv_lang["label_ban_server"]		= "Postúpené";
$pgv_lang["label_add_search_server"]	= "Pridať IP";
$pgv_lang["remove_ip"] 			= "Odstrániť IP";
$pgv_lang["label_remove_ip"]		= "Zakázaná IP adresa (napr. 198.128.*.*):";
$pgv_lang["label_remove_search"]	= "Označte IP adresy ako Search Engine Spiders:";
$pgv_lang["change"]			= "Zmeniť";
$pgv_lang["change_family_instr"]	= "Použite túto stránku ku zmene, alebo zmazaniu členov rodiny.<br /><br />Pre každého člena rodiny môžete použiť link Zmena na výber inej osoby, ktorá plní túto rolu v rodine. Môžete tiež použiť link Odstrániť ku zmazaniu tejto osoby z rodiny.<br /><br />Keď skončíte zmeny členov rodiny, kliknite na tlačítko Uložiť, pre uloženie vykonaných zmien.<br />";
$pgv_lang["cancel"]			= "Zrušiť";
$pgv_lang["cookie_help"]		= "Táto stránka používa cookies na uloženie informácií o vašom prihlásení.<br /><br />Cookies nie sú povolené vo vašom prehliadači. Pred prihlásením musíte povoliť cookies. Môžete si pomôcť nápovedou vašeho prehliadača ak to neviete urobiť.";
$pgv_lang["change_family_members"]	= "Zmeniť členov rodiny";
$pgv_lang["delete_family_confirm"]	= "Zmazanie rodiny spôsobí zrušenie spojenia medzi osobami, ktoré sú členmi rodiny, ale nezruší ich záznamy. Ste si istý, že chcete zmazať túto rodinu?";
$pgv_lang["delete_family"]		= "Zmazať rodinu";
$pgv_lang["add_favorite"]		= "Pridať nové obľúbené";
$pgv_lang["url"]			= "URL";
$pgv_lang["add_fav_enter_note"]		= "Vložte ľubovolnú poznámku o tomto obľúbenom.";
$pgv_lang["add_fav_or_enter_url"]	= "Alebo<br />\nVložte URL a názov";
$pgv_lang["add_fav_enter_id"]		= "Zadajte ID osoby, rodiny alebo zdroja";
$pgv_lang["import_time_exceeded"]	= "Časový limit pre spracovanie bol prekročený. Kliknite na tlačítko Pokračovať pre zobrazenie rekapitulácie importu GEDCOM súboru.";
$pgv_lang["next_email_sent"]		= "Ďalšia upomienka e-mailom bude odoslaná po";
$pgv_lang["last_email_sent"]		= "Posledná upomienka e-mailo bola odoslaná";
$pgv_lang["confirm_remove"]		= "Ste si istý, že chcete odstrániť túto osobu z rodiny?";
$pgv_lang["remove_child"]		= "Odstrániť toto dieťa z rodiny";
$pgv_lang["link_new_husb"]		= "Pridať existujúcu osobu ako manžela";
$pgv_lang["link_new_wife"]		= "Pridať existujúcu osobu ako manželku";
$pgv_lang["address_labels"]		= "Adresné štítky";
$pgv_lang["filter_address"]		= "Zobraziť adresy, ktoré obsahujú:";
$pgv_lang["address_list"]		= "Zoznam adries";
$pgv_lang["autocomplete"]		= "Automatické dokončenie";
$pgv_lang["undo_all_confirm"]		= "Ste si istý, že chcete zrušiť všetky zmeny pre tento GEDCOM?";
$pgv_lang["undo_all"]			= "Zrušiť všetky zmeny";
$pgv_lang["index_edit_advice"]		= "Označte blok a potom kliknite na niektorú ikonu šípky k presunu označeného bloku v smere šípky.";
$pgv_lang["importing_dates"]		= "Import dátumových záznamov";
$pgv_lang["label_username_id"]		= "Uživateľské meno";
$pgv_lang["label_username_id2"]		= "Uživateľské meno:";
$pgv_lang["label_password_id"]		= "Heslo";
$pgv_lang["label_password_id2"]		= "Heslo:";
$pgv_lang["error_ban_server"]       = "Neplatná IP adresa.";
$pgv_lang["error_view_connections"] = "Musíte vybrať stránku na zobrazenie.";
$pgv_lang["error_delete_server"]    = "Musíte vybrať stránku na zmazanie.";
$pgv_lang["title_manage_servers"]   = "Spravovať stránky";
$pgv_lang["label_banned_servers"]   = "Zakázané stránky podle IP";
$pgv_lang["label_manual_search_engines"]   = "Manuálne určite Search Engines pomocou IP";
$pgv_lang["label_search_engine_detected"]  = "Search Engine Spider bol nájdený";
$pgv_lang["label_search_engine_spider"]    = "Search Engine Spider";
$pgv_lang["label_ban_view_links"]   = "Zobraziť odkazy na túto zakázanú stránku.";
$pgv_lang["label_delete"]           = "Zmazať";
$pgv_lang["label_new_server"]       = "Pridať novú stránku";
$pgv_lang["label_server_url"]       = "URL/IP stránky";
$pgv_lang["label_add_server"]       = "Pridať";
$pgv_lang["label_added_servers"]	= "Pridané vzdialené servery";
$pgv_lang["error_url"]              = "Stránka musí mať nejaké URL/IP.";
$pgv_lang["error_exists_server"]    = "Stránka už existuje";
$pgv_lang["error_view_info"]        = "Musíte vybrať osobu ktorej informácie chcete zobraziť.";
$pgv_lang["error_delete_person"]    = "Musíte vybrať osobu ktorej vzdialený link chcete zmazať.";
$pgv_lang["title_view_conns"]       = "Zobraziť spojenie.";
$pgv_lang["label_server_info"]      = "Všetci sú vzdialene pripojený cez stránku:";
$pgv_lang["label_view_local"]       = "Zobraziť lokálne informácie o osobe";
$pgv_lang["label_view_remote"]      = "Zobraziť vzdialené informácie o osobe";
$pgv_lang["label_individuals"]      = "Osoby";
$pgv_lang["label_families"]         = "Rodiny";
$pgv_lang["ex-spouse"] = "Ex-manželia";
$pgv_lang["ex-wife"] = "Ex-manželka";
$pgv_lang["ex-husband"] = "Ex-manžel";
$pgv_lang["noemail"] 				= "Adresy bez e-mailov";
$pgv_lang["onlyemail"] 				= "Iba adresy z e-mailami";
$pgv_lang["maxviews_exceeded"]		= "Počet otvorenia stránky bol prekročený, skúste to neskôr.";
$pgv_lang["broadcast_not_logged_6mo"]	= "Poslať správu uživateľom, ktorý neboli prihlásený v priebehu posledných 6 mesiacov.";
$pgv_lang["broadcast_never_logged_in"]	= "Poslať správu uživateľom, ktorý ešte nikdy neboli prihlásený";
$pgv_lang["stats_to_show"]			= "Vyberte štatistiky pre zobrazenie v tomto bloku";
$pgv_lang["stat_avg_age_at_death"]	= "Priemerný vek pri úmrtí";
$pgv_lang["stat_longest_life"]		= "Najdlhšie žijúca osoba";
$pgv_lang["stat_most_children"]		= "Rodina s najvyšším počtom detí";
$pgv_lang["stat_average_children"]	= "Priemerný počet detí na rodinu";
$pgv_lang["stat_events"]			= "Celkove udalostí";
$pgv_lang["stat_media"]				= "Média";
$pgv_lang["stat_surnames"]			= "Celkove priezvísk";
$pgv_lang["stat_users"]				= "Celkove uživateľov";
$pgv_lang["no_family_facts"]		= "Žiadne údaje pre túto rodinu.";
$pgv_lang["sunday_1st"]					= "Ne";
$pgv_lang["monday_1st"]					= "Po";
$pgv_lang["tuesday_1st"]				= "Ut";
$pgv_lang["wednesday_1st"]				= "St";
$pgv_lang["thursday_1st"]				= "Št";
$pgv_lang["friday_1st"]					= "Pi";
$pgv_lang["saturday_1st"]				= "So";
$pgv_lang["january_1st"]			= "Jan";
$pgv_lang["february_1st"]			= "Feb";
$pgv_lang["march_1st"]				= "Mar";
$pgv_lang["april_1st"]				= "April";
$pgv_lang["may_1st"]				= "Máj";
$pgv_lang["june_1st"]				= "Jún";
$pgv_lang["july_1st"]				= "Júl";
$pgv_lang["august_1st"]				= "Aug";
$pgv_lang["september_1st"]			= "Sept";
$pgv_lang["october_1st"]			= "Okt";
$pgv_lang["november_1st"]			= "Nov";
$pgv_lang["december_1st"]			= "Dec";
$pgv_lang["edit_source"]			= "Upraviť zdroj";
$pgv_lang["source_menu"]			= "Voľby pre zdroj";
$pgv_lang["familybook_chart"]		= "Schéma Rodinná kronika";
$pgv_lang["family_of"]				= "Rodina:&nbsp;";
$pgv_lang["descent_steps"]			= "Počet generácií potomkov";
$pgv_lang["user_auto_accept"]		= "Automaticky akceptovať zmeny urobené uživateľom";
$pgv_lang["current_person"]         = "Rovnaký ako aktuálny";
$pgv_lang["title_remote_link"]      = "Pridať vzdialené pripojenie";
$pgv_lang["title_search_link"]      = "Pridať lokálne pripojenie";
$pgv_lang["label_same_server"]      = "Tá istá stránka";
$pgv_lang["label_diff_server"]      = "Iná stránka";
$pgv_lang["label_accept_changes"]   = "Akceptovať všetky zmeny";
$pgv_lang["label_ask_first"]        = "Najskôr sa ma spýtať";
$pgv_lang["label_rel_to_current"]   = "Vzťah k aktuálnej osobe";
$pgv_lang["label_location"]         = "Umiestnenie";
$pgv_lang["label_site"]             = "Stránka";
$pgv_lang["label_site_url"]         = "URL stránky:";
$pgv_lang["label_site_url2"]        = "URL stránky";
$pgv_lang["label_remote_id"]        = "ID vzdialenej osoby";
$pgv_lang["label_local_id"]         = "ID osoby";
$pgv_lang["label_merge_options"]    = "Voľby spojenia";
$pgv_lang["main_media_ok1"]				= "Hlavný súbor medií <b>#GLOBALS[oldMediaName]#</b> bol úspešne premenovaný na <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["main_media_ok2"]				= "Hlavný súbor médií <b>#GLOBALS[oldMediaName]#</b> bol úspešne presunutý z <b>#GLOBALS[oldMediaFolder]#</b> do <b>#GLOBALS[newMediaFolder]#</b>.";
$pgv_lang["main_media_ok3"]				= "Hlavný súbor médií bol úspešne presunutý a premenovaný z <b>#GLOBALS[oldMediaFolder]##GLOBALS[oldMediaName]#</b> na <b>#GLOBALS[newMediaFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["main_media_fail0"]			= "Hlavný súbor médií <b>#GLOBALS[oldMediaFolder]##GLOBALS[oldMediaName]#</b> neexistuje.";
$pgv_lang["main_media_fail1"]			= "Hlavný súbor médií <b>#GLOBALS[oldMediaName]#</b> nemôže byť premenovaný na <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["main_media_fail2"]			= "Hlavný súbor médií <b>#GLOBALS[oldMediaName]#</b> nemôže byť presunutý z <b>#GLOBALS[oldMediaFolder]#</b> do <b>#GLOBALS[newMediaFolder]#.";
$pgv_lang["main_media_fail3"]			= "Hlavný súbor médií nemôže byť presunutý a premenovaný z <b>#GLOBALS[oldMediaFolder]##GLOBALS[oldMediaName]#</b> na <b>#GLOBALS[newMediaFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_ok1"]			= "Súbor náhľadu <b>#GLOBALS[oldMediaName]#</b> bol úspešne premenovaný na <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_ok2"]			= "Súbor náhľadu <b>#GLOBALS[oldMediaName]#</b> bol úspešne presunutý z <b>#GLOBALS[oldThumbFolder]#</b> do <b>#GLOBALS[newThumbFolder]#</b>.";
$pgv_lang["thumb_media_ok3"]			= "Súbor náhľadu bol úspešne presunutý a premenovaný z  <b>#GLOBALS[oldThumbFolder]##GLOBALS[oldMediaName]#</b> na <b>#GLOBALS[newThumbFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_fail0"]			= "Súbor náhľadu <b>#GLOBALS[oldThumbFolder]##GLOBALS[oldMediaName]#</b> neexistuje.";
$pgv_lang["thumb_media_fail1"]			= "Súbor náhľadu <b>#GLOBALS[oldMediaName]#</b> nemôže byť premenovaný na <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_fail2"]			= "Súbor náhľadu <b>#GLOBALS[oldMediaName]#</b> nemôže byť presunutý z <b>#GLOBALS[oldThumbFolder]#</b> do <b>#GLOBALS[newThumbFolder]#</b>.";
$pgv_lang["thumb_media_fail3"]			= "Súbor náhľadu nemôže byť presunutý a premenovaný z  <b>#GLOBALS[oldThumbFolder]##GLOBALS[oldMediaName]#</b> na <b>#GLOBALS[newThumbFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["hebrew_surn"]			= "Židovské priezvisko";
$pgv_lang["hebrew_givn"]			= "Židovské meno";
$pgv_lang["include"]				= "Zahrnúť:";
$pgv_lang["page_x_of_y"]			= "Stránka #GLOBALS[currentPage]# z #GLOBALS[lastPage]#";
$pgv_lang["roman_surn"]				= "Priezvisko latinkou";
$pgv_lang["roman_givn"]				= "Meno latinkou";
$pgv_lang["upload_replacement"]		  	="Zmena cesty načítania";

if (file_exists( "languages/lang.sk.extra.php")) require  "languages/lang.sk.extra.php";
?>
