<?php
/**
 * Swedish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Patrik Hansson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Patrik Hansson
 * @version $Id: configure_help.sv.php,v 1.78.2.47 2006/07/12 20:31:17 pathan Exp $
 */
if (preg_match("/configure_help\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]			= "Konfigurera PhpGedView";
$pgv_lang["standard_conf"]		= "Standardkonfigurationsval";
$pgv_lang["advanced_conf"]		= "Avanceradekonfigurationsval";
$pgv_lang["gedcom_conf"]		= "Grundläggande GEDCOM";
$pgv_lang["media_conf"]			= "Multimedia";
$pgv_lang["gedcom_title"]		= "#pgv_lang[ged_title]#";
$pgv_lang["accpriv_conf"]		= "Access och integritet";
$pgv_lang["displ_conf"]			= "Visning och layout";
$pgv_lang["displ_names_conf"]	= "Namn";
$pgv_lang["displ_comsurn_conf"] = "Vanliga efternamn";
$pgv_lang["displ_layout_conf"]	= "Layout";
$pgv_lang["displ_hide_conf"]	= "Visa och dölj";
$pgv_lang["editopt_conf"]		= "Redigereringsinställningar";
$pgv_lang["useropt_conf"]		= "Användarinställningar";
$pgv_lang["contact_conf"]		= "Kontakt information";
$pgv_lang["meta_conf"]			= "Websajt och META-tag inställningar";
$pgv_lang["configure_head"]		= "PhpGedView-konfiguration";
$pgv_lang["gedconf_head"]		= "GEDCOM-konfiguration";
$pgv_lang["default_user"]               = "Skapa standardadministratör.";
$pgv_lang["about_user"]                 = "Du måste först skapa en administratörsanvändare.  Denna användare kommer att ha rättigheter att uppdatera konfigurationsfilerna, inspektera privata data och skapa nya användare.";
$pgv_lang["can_admin"]                  = "Användare får administrera";
$pgv_lang["can_edit"]                   = "Accessnivå";
$pgv_lang["access"]						= "Access";
$pgv_lang["sync_gedcom"]		= "Synkronisera användarinställningar med GEDCOM-data";
$pgv_lang["user_relationship_priv"]	= "Begränsa tillgång till besläktade personer";
$pgv_lang["user_path_length"]	= "Max avstånd på släktförhållandeintegritet";
$pgv_lang["add_user"]                   = "Lägg till ny användare";
$pgv_lang["current_users"]              = "Nuvarande användarlista";
$pgv_lang["leave_blank"]				= "Lämna lösenordfältet tomt om du vill behålla det aktuella lösenordet.";
$pgv_lang["other_theme"]                = "Egen sökväg, skriv in här";
$pgv_lang["performing_update"]          = "Uppdatering pågår.";
$pgv_lang["config_file_read"]           = "Läst konfigurationsfil.";
$pgv_lang["does_not_exist"]             = "finns ej";
$pgv_lang["media_drive_letter"] 		= "Mediasökvägen bör inte innehålla en hårddiskbokstav, media kommer kanske inte att visas.";
$pgv_lang["pgv_config_write_error"]         = "Fel!!! Kan inte skriva till PhpGedView-konfigurationsfil. Kontrollera fil och mapp-rättigheter och försök igen.";
$pgv_lang["db_setup_bad"]               = "Din nuvarande databaskonfiguration är felaktig.  Kontrollera databasanslutningens inställningar och försök igen.";
$pgv_lang["bad_host_user_pass"]			= "PhpGedView kunde inte koppla sig till din databasvärd. Kontrollera att ditt värd, användarnamn och lösenord är korrekt. ";
$pgv_lang["bad_database_name"]			= "PhpGedView kunde koppla sig till din databasvärd, men kunde inte använda databasnamnet du angav. Kontrollera att databasen existerar och att användarnamnet du angav har tillräckliga rättigheter för databasen.";
$pgv_lang["click_here_to_continue"]     = "Klicka här för att fortsätta.";
$pgv_lang["config_help"]                = "Konfigurationshjälp";
$pgv_lang["mysql"]						= "MySQL";
$pgv_lang["db"]				= "Databas";
$pgv_lang["dbase"]			= "dBase";
$pgv_lang["fbsql"]			= "FrontBase";
$pgv_lang["ibase"]			= "InterBase";
$pgv_lang["ifx"]			= "Informix";
$pgv_lang["msql"]			= "Mini SQL";
$pgv_lang["mssql"]			= "Microsoft SQL Server";
$pgv_lang["mysqli"]			= "MYSQL 4.1+ och PHP 5";
$pgv_lang["oci8"]			= "Oracle 7+";
$pgv_lang["pgsql"]			= "PostgreSQL";
$pgv_lang["sqlite"]			= "SQLite";
$pgv_lang["sybase"]			= "Sybase";
$pgv_lang["admin_gedcoms"]				= "Klicka här för administrera GEDCOM-filer.";
$pgv_lang["current_gedcoms"]			= "Aktuell GEDCOM";
$pgv_lang["gedcom_adm_head"]			= "GEDCOM-administration";
$pgv_lang["ged_download"]				= "Ladda ner";
$pgv_lang["ged_gedcom"]					= "GEDCOM-fil";
$pgv_lang["ged_title"]					= "GEDCOM-titel";
$pgv_lang["ged_config"]					= "Konfigurationsfil";
$pgv_lang["ged_search"]					= "Sökningsloggfiler";
$pgv_lang["ged_change"]			= "Ändringslog-filer";
$pgv_lang["ged_privacy"]				= "Integritetsfil";
$pgv_lang["show_phpinfo"]				= "Visa PHPInfo-sida";
$pgv_lang["confirm_gedcom_delete"]		= "Är du säker på att du vill radera denna GEDCOM-fil";
$pgv_lang["gregorian"]					= "Gregoriansk";
$pgv_lang["julian"]						= "Juliansk";
$pgv_lang["config_french"]				= "Fransk";
$pgv_lang["jewish"]						= "Judisk";
$pgv_lang["config_hebrew"]				= "Hebreisk";
$pgv_lang["jewish_and_gregorian"]		= "Judisk och Gregoriansk";
$pgv_lang["hebrew_and_gregorian"]		= "Hebreisk och Gregoriansk";
$pgv_lang["hijri"]						= "Hijri";
$pgv_lang["arabic_cal"]					= "Arabisk";
$pgv_lang["disabled"]					= "Inaktiverad";
$pgv_lang["mousedown"]					= "Vid nedtryckt musknapp";
$pgv_lang["mouseover"]					= "Vid musfokus";
$pgv_lang["click"]						= "Vid musklick";
$pgv_lang["mailto"]						= "Meddelandelänk";
$pgv_lang["messaging"]					= "PhpGedViews interna meddelandehantering";
$pgv_lang["messaging3"]					= "PhpGedView skickar e-post utan att lagra dem";
$pgv_lang["messaging2"]					= "Interna meddelande med e-post";
$pgv_lang["no_messaging"]				= "Ingen kontaktmetod";
$pgv_lang["no_logs"]					= "Stäng av loggning";
$pgv_lang["daily"]						= "Daglig";
$pgv_lang["weekly"]						= "Veckovis";
$pgv_lang["monthly"]					= "Månatlig";
$pgv_lang["yearly"]						= "Årlig";
$pgv_lang["enter_db_pass"]				= "För att öka säkerheten måste du ange #pgv_lang[DBUSER]# och #pgv_lang[DBPASS]# före du kan ändra konfigurationsvärdena.";
$pgv_lang["config_still_writable"]		= "Din fil <i>config.php</i> är fortfarande skrivbar. För att öka säkerheten bör du sätta tillbaka rättighterna till endast läsbar när du är klar med konfigurationen av sajten.";
$pgv_lang["admin_verification_waiting"] = "Användarkonto(n) som väntar på verifiering av administratören";
$pgv_lang["admin_user_warnings"]		= "En eller flera användarkonto innehåller varningar";

$pgv_lang["DBTYPE"]						= "Databastyp";
$pgv_lang["DBTYPE_help"]				= "~#pgv_lang[DBTYPE]#~<br /><br />Typen av PEAR databaser som stöds för att anslutning till.<br /><br />PhpGedView stödjer MySQL, PostgreSQL och SQLite databaser, MySQL och PostgreSQL kräver båda bibliotek att installeras i PHP, SQLite är installerat som standard i PHP 5. Med SQlite behöver du inte sätta #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]# eller #pgv_lang[DBPASS]#, men du behöver sätta en filsökväg till din databas i #pgv_lang[DBNAME]#-fältet. Detta sätter \$DBTYPE variablen i <i>config.php</i>.<br />";
$pgv_lang["DBHOST"]                     = "Databasvärd";
$pgv_lang["DBHOST_help"]                = "~#pgv_lang[DBHOST]#~<br /><br />DNS eller IP adress till datorn med databasservern. Denna inställning ignoreras om du använder en SQLite databas. Detta ställer in \$DBHOST variabeln i <i>config.php</i>.<br />";
$pgv_lang["DBUSER"]                     = "Databasens användarnamn";
$pgv_lang["DBUSER_help"]                = "~#pgv_lang[DBUSER]#~<br /><br />Databasens användarnamn, som krävs för att logga in på databasen. Denna inställning ignoreras om du använder en SQLite databas. Detta ställer in variabeln \$DBUSER i <i>config.php</i>.<br />";
$pgv_lang["DBPASS"]                     = "Databasens lösenord";
$pgv_lang["DBPASS_help"]                = "~#pgv_lang[DBPASS]#~<br /><br />Databasens lösenord för den användare du angivit i #pgv_lang[DBUSER]#-fältet. Denna inställning ignoreras om du använder en SQLite databas. This sets the \$DBPASS variable in the <i>config.php</i>.<br />";
$pgv_lang["DBNAME"]                     = "Databasnamn";
$pgv_lang["DBNAME_help"]                = "~#pgv_lang[DBNAME]#~<br /><br />Databasen på servern du angivit att PhpGedView skall använda.  Användarnamnet du anger i #pgv_lang[DBUSER]#-fältet måste ha create, insert, update, delete, och select rättigheter på denna databas. I SQLite behöver du sätta detta fält till ett filnamn i en mapp som PHP har skrivrättigheter i som t.ex. indexmappen(index/phpgedview.db). Detta ställer in variabeln \$DBNAME i filen <i>config.php</i>.<br />";
$pgv_lang["TBLPREFIX"]                  = "Databasens tabellprefix";
$pgv_lang["TBLPREFIX_help"]             = "~#pgv_lang[TBLPREFIX]#~<br /><br />Ett prefix som läggs till tabeller skapade av PhpGedView. Genom att ändra detta värde kan du ställa in flera PhpGedView-sajter som använder samma databas men olika tabeller. T.ex. samma sajt kan innehålla en \"test\" och en \"produktions\" installation av PhpGedView med helt olika datatabeller. Detta ställer in variabeln \$TBLPREFIX i filen <i>config.php</i>.<br />";
$pgv_lang["DEFAULT_GEDCOM"]             = "Standard GEDCOM";
$pgv_lang["privileges"]					= "Privilegier";
$pgv_lang["date_registered"]			= "Datum för registrering";
$pgv_lang["last_login"]					= "Senase inloggad";
$pgv_lang["server_url_note"]			= "Detta ska vara URL till din PhpGedView-folder. Du bör endast ändra denna inställning om du vet vad du gör. PhpGedView har räknat ut att värdet bör vara <b>#GUESS_URL#</b>";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]        = "Tillåt besökare att ändra GEDCOM";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]   = "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Genom att sätta detta värde till <b>Ja</b> tillåter du besökare <b>och</b> användare på din sajt att byta mellan olika GEDCOM-filer om du har fler än en GEDCOM konfigurerad.<br /><br />Om satt till <b>Nej</b>, både besökare <b>och</b> inloggade användare, kommer inte att kunna byta GEDCOM-fil.<br /><br />Detta ställer in variabeln \$ALLOW_CHANGE_GEDCOM i filen <i>config.php</i>.<br />";
$pgv_lang["upload_path"]			= "Sökväg för uppladdningen";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Detta är sökvägen till GEDCOM-filen som du vill ladda upp kan hittas. För att välja säkvägen, klicka på <b>Browse<b> och navigera till din GEDCOM-fil och klicka på <b>Öppna<b>";
$pgv_lang["gedcom_path"]                = "GEDCOM-filens sökväg och namn";
$pgv_lang["gedcom_path_help"]           = "~#pgv_lang[gedcom_path]#~<br /><br />Det finns två sätt att importera din GEDCOM-fil i PhpGedView. De är:<ol><li>Ladda upp filen till servern med FTP</li><li>Ladda upp filen med hjälp av PhpGedView</li></ol>När din fil redan finns på servern, så använder du<i>#pgv_lang[add_gedcom]#</i> proceduren och fyller i sökvägen och filnamnet för din GEDCOM-fil presic som de heter på servern. Namnet kan var med eller utan filändelse. Om ingen filändelse anges, antas .ged. Sökvägen är valfri att fylla i. Om ingen sökväg anges kommer värdet av <i>#pgv_lang[INDEX_DIRECTORY]#</i>, som är satt i PhpGedViews sajtkonfiguration, att användas. Tänk på att i många fall spelar det roll om man skriver med små eller stora bokstäver.<br /><br />När du använder <i>#pgv_lang[upload_gedcom]#</i> proceduren som är inbyggd i PhpGedView, där kan du använda <b>Browse</b>-knappen för att hitta den önskade filen på din lokala dator. Detta kan var en vanlig GEDCOM eller en ZIP-fil som innehåler en GEDCOM-fil. PhpGedView kommer automatiskt packa upp och sedan använda filen som finns i ZIP-filen.<br /><br />När du laddar upp en fil finns det möjlighet att specificera en alternativ sökväg och/eller filnamn att spara den under på servern.<br /><br />Se <a href=\"readme.txt\">Readme.txt</a> för mer hjälp.<br />";
$pgv_lang["CHARACTER_SET"]              = "Teckentabell";
$pgv_lang["CHARACTER_SET_help"]         = "~#pgv_lang[CHARACTER_SET]#~<br /><br />Detta anger kodningen för den teckentabell din GEDCOM-fil använder.  UTF-8 är standard och borde fungera för nästan alla sidor.  Om du exporterade din GEDCOM-fil med IBM Windows kodning, bör du ange WINDOWS här.<br /><br />OBS: PHP stödjer INTE UNICODE (UTF-16) så testa det inte, klaga istället på skaparna av PHP :-)<br />";
$pgv_lang["LANGUAGE"]                   = "Språk";
$pgv_lang["LANGUAGE_help"]              = "~#pgv_lang[LANGUAGE]#~<br /><br />Ange standardspråk för din site.<br /><br />När <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> valet är satt kan användare ändra denna denna inställning genom webläsarens språkinställning, konfigurationsval på deras kontosida eller genom länkareller knappar på de flesta siorna i PhpGedView.<br />";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]      = "Tillåt användare att byta språk";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Sätt till <b>Ja</b> om du vill tillåta användare ändra sajtens standardspråk. De kan göra det via webläsaren föredragna språkinställning, konfigurationsval via deras kontosida eller via länkar eller knappar på de flesta PhpGedViews sidor.<br />";
$pgv_lang["LANGUAGE_DEFAULT"]			= "Du har inte konfigurerat de språk som sajten ska stödja.<br />PhpGedView kommer att använda sina standardmetoder.";
$pgv_lang["CALENDAR_FORMAT"]			= "Kalenderformat";
$pgv_lang["CALENDAR_FORMAT_help"]		= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Låter dig välja kalender typ som används med denna GEDCOM-fil.<br /><br />Hebreisk är samma som den Judiska fast med hebreiska tecken.<br /><br />Obs: Värdena för den Judiska/Hebreiska datumen räknas ut ifrån de Gregorianska/Julianska datumen. Eftersom den Judiska kalendern startar vid skymningen kommer alla händelser som utspelar sig från skymning till midnatt att visas en dag tidigare än det korrekta judiska datumet. Hebreiska kan vara problematiskt i äldre webläsare. Vissa gamla webläsare visar Hebreiska baklänges eller inte alls.<br />";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]	= "Visa hebreisk Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Visa dubbel och enkelcitationstecken när Hebreiska datum visas. Sätts denna inställning till Ja kommmer datumet February 8th 1969 att visas som <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; medans ett Nej gör så att det visas som <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Denna inställning har ingen inverkan på den judiska årsinställningen eftersom citationstecken inte används för att visa judiska datum med det latinska alfabetet.<br /><br />Detta ställer in \$DISPLAY_JEWISH_GERESHAYIM variabeln i <i><u>xxx</u>.GED_conf.php</i>.OBS: Denna inställing är liknar kalenderkonstanterna CAL_JEWISH_ADD_ALAFIM_GERESH och CAL_JEWISH_ADD_GERESHAYIM i php 5.0. Denna inställning påverka båda två.<br />";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Visa hebreiska tusental.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Visa Alafim i Hebreiska kalendrar. Sätts detta val i Ja kommer år 1969 visas som <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; medans nej leder till att året visas som <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Denna inställningen har ingen inverkan på den judiska årsinställningen. Året kommer visas som 5729 oavsätt hur denna inställning sätts.<br /><br />Denna inställning ställer in \$DISPLAY_JEWISH_THOUSANDS variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br /><br />OBS: Denna inställning är lik kalenderkonstanten CAL_JEWISH_ADD_ALAFIM i php 5.0.<br />";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Judisk Ashkenaz uttal";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Använd judiskt Ashkenaziutal.<br />Om satt till <b>Ja</b> kommer månaderna Cheshvan and Teves att stavas med Ashkenaziutal. Satt till <b>Nej</b> kommer månaderna stavas som Hesvan and Tevet. <br />Detta ställer bara in de judiska inställningarna. Den hebreiska inställningen använder det hebreiska alfabetet.<br />Detta ställer in \$JEWISH_ASHKENAZ_PRONUNCIATION variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["USE_RTL_FUNCTIONS"]			= "Använd RTL Data processning";
$pgv_lang["USE_RTL_FUNCTIONS_help"]		= "~#pgv_lang[USE_RTL_FUNCTIONS]#~<br /><br />Använd processning för att korrekt visa GEDCOM-data i RTL språk.<br />Om satt till <b>Ja</b> kommer GEDCOM-filen att processa under körning för att försäkra att visningen av korrekt RTL data. Denna inställning kan försämra prestandan.<br />Detta sätter \$USE_RTL_FUNCTIONS variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]   = "Antal generationer i antavlan";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]  = "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Ställer in det antal generationer som kommer att visas i antavlan som standard.<br />";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Max antal generationer i antavla";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Ange maximalt antal generationer som skall visas för antavlor.<br />";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Max antal generationer i stamtavla";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Ange maximalt antal generationer som skall visas i trädet över ättlingar.<br />";
$pgv_lang["USE_RIN"]					= "Använd RIN# istället för GEDCOM-ID";
$pgv_lang["USE_RIN_help"]				= "~#pgv_lang[USE_RIN]#~<br /><br />Sätt till <b>Ja</b> om du använder RIN-nummer instället för GEDCOM-ID när ID för personer efterfrågas i konfigurationsfiler, användarinställningar och tavlor. Detta är användbart för genealogiprogram som inte exporterar GEDCOM-filer med samma ID tilldelat till varje person men alltid använder samma RIN.<br />";
$pgv_lang["GENERATE_GUID"]		= "Skapa globalt unika Ids automatiskt";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> i detta sammanhang är en förkortning för «Globalt Unikt ID».<br /><br />GUIDs är tänktaatt hjälpa till att identifera varje person på ett som är återupprepningsbart, så att centrala organisationer som släktforskningscenter för Jesu Kristi Kyrka av Sista Dagars Heliga eller kompatibla program som körs på din egen server kan avgöra om det är samma person oavsett var GEDCOM-filen kommer ifrån. Målet för släktforskningscenteret är att ett centralt arkiv för genealogisk data och göra det tillgängligt via webservicear. Detta kommer att göra det möjligt för alla program att accessa datat och uppdatera deras data som finns där.<br /><br />Om du inte tänker dela med dig av denna GEDCOM till någon annan, behöver du inte låta PhpGedView skapa desssa GUIDs men att göra det gör ingen skada förutom att filen blir större.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"]           = "Standardperson som startpunkt i släktträden";
$pgv_lang["PEDIGREE_ROOT_ID_help"]  	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Anger ID för den person som skall vara utgångspunkt för alla släktträd som standard.<br />";
$pgv_lang["GEDCOM_ID_PREFIX"]			= "GEDCOM-ID Prefix";
$pgv_lang["GEDCOM_ID_PREFIX_help"]		= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />På släkträd och andra tavlor där användare efterfrågas att mata in ett ID kommer detta prefix användas om inget annat anges.<br />";
$pgv_lang["SOURCE_ID_PREFIX"]			= "Käll-ID prefix";
$pgv_lang["SOURCE_ID_PREFIX_help"]		= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Ifall ett nytt källpost läggs till online i PhpGedView, ett nytt ID för källan automatiskt att skapas. Käll-IDt kommer att få detta prefix.<br />";
$pgv_lang["REPO_ID_PREFIX"]				= "Arkiv-ID prefix";
$pgv_lang["REPO_ID_PREFIX_help"]		= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Ifall ett nytt arkiv läggs till online i PhpGedView, kommer ett nytt ID automatiskt att genereras. Arkiv-ID kommer att få detta prefix.<br />";
$pgv_lang["PEDIGREE_FULL_DETAILS"]      = "Visa detaljer om födelse och död i släktträden";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Anger om detaljer för födelse och död skall visas eller ej för en person som standard.<br />";
$pgv_lang["PEDIGREE_LAYOUT"]			= "Standard anträdslayout";
$pgv_lang["PEDIGREE_LAYOUT_help"]		= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Denna inställning bestämmer om anträdet ska skapas i stående eller liggande format.<br />";
$pgv_lang["SHOW_EMPTY_BOXES"]			= "Visa tomma rutor i antavla.";
$pgv_lang["SHOW_EMPTY_BOXES_help"]		= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Anger om tomma rutor skall visas i antavlan.<br />";
$pgv_lang["ZOOM_BOXES"]					= "Zoomrutor i tavlor";
$pgv_lang["ZOOM_BOXES_help"]			= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Tillåter en användare att zooma på tavlor för att få mer information. Sätt till <b>#pgv_lang[disabled]#</b> för att avaktivera denna funktion. Sätt till <b>#pgv_lang[mouseover]#</b> för att zooma rutor när musmarkören befinner sig ovanför rutans ikon. Sätt till <b>#pgv_lang[click]#</b> för att zooma när användaren klickar på rutans ikon.<br />";
$pgv_lang["LINK_ICONS"]					= "PopUp-länkar på tavlor";
$pgv_lang["LINK_ICONS_help"]			= "~#pgv_lang[LINK_ICONS]#~<br /><br />Tillåter användaren att välja länkar till andra tavlor och nära släktingar till personen. Sätt till <b>#pgv_lang[disabled]#</b> för att inte använda denna funktion. Sätt till <b>#pgv_lang[mouseover]#</b> för att popup-länkarna skall visas när musmarkören befinner sig ovanför rutans ikon. Sätt till <b>#pgv_lang[click]#</b> för att popup-länkarna skall visas när användaren klickar på rutans ikon.<br />";
$pgv_lang["ABBREVIATE_CHART_LABELS"]	= "Förkorta tavelbeteckningar";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Om du vska förkorta beteckningar som födelse om tavlor med endast den första bokstaven som 'F'.<br />";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Visa ålder för föräldrar intill barnets födelsedatum";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Visa ålder för föräldrar intill barnets födelsedatum i tavlor<br />";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Visa födelse och död för släktingar på personsidan";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Födslar, vigslar och dödsfall av släktingar är viktiga händelser i våra liv. Detta val kontrollerar om du vill visa dessa händelser på <i>Personliga fakta och detaljer</i>-fliken på ansidan.<br /><br />Händelser som påverkas av detta val är: <ul><li>Död av ingift</li><li>Födelse och död för barn</li><li>Föräldrars död</li><li>Syskons födelse och död</li><li>Far/morföräldrars död</li><li>Födelse och död för föräldrars syskon</li></ul><br />";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Expandera händelselistan automatiskt";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Detta val kontrollerar om listan <i>Händelser för nära släktingar</i> ska expanderas automatiskt.<br />";
$pgv_lang["EXPAND_SOURCES"]      = "Expandera källor automatiskt";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Detta val komtrollerar om man automatiskt ska visa innehållet i en <i>källa</i> på ansedelsidan.";
$pgv_lang["HIDE_LIVE_PEOPLE"]           = "Sätt igång integritetsinställnignar";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]      = "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Detta val talar om ifall PhpGedView skall dölja detaljer för personer som fortfarande lever.  Levande personer är definierade som en person som inte har några händelser yngre än \$MAX_ALIVE_AGE. Av denna anledning betraktas födelse av barn som ett sådan händelse också.<br />";
$pgv_lang["REQUIRE_AUTHENTICATION"]		= "Kräver besökarens autenticiering";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Sätta på denna val tvingar all besökare att logga in innan de se någon data på denna sajten.<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]		= "Välkomsttext för inloggningssidan i Autenticieringsmod";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Här kan du välja texten som kommer att visas på inloggningssidan när autenticieringsmod är satt till <b>Ja</b>. Testa vilken fördefinierad text dom passar bäst.<br />Du kan också välja att skriva in en egen välkomsttext, men denna kommer inte att översättas till andra språk.<br /><br />De fördefinierade texterna är:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Fördefinierad text som anger att alla användare kan ansöka om ett användarkonto.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Fördefinierad text som anger att administratören bestämmer om man får ett användarkonto.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Fördefinierad text som anger att endast familjemedlemmar kan ansöka om ett användarkonto.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Välj användardefinierad välkomsttext inskriven nedan";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Egendefinierad välkomsttext för autenticieringsmod";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Om du valt ett egendefinierad välkomsttext i valet ovan, kan du skriva texten här.<br />Texten kommer INTE att översättas till besökarens språk, utan kommer att visas exakt som du skrivit det.<br />Om du vill, kan du använda HTML-taggar i texten.<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standardrubrik för skräddarsydd välkomsttext";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Välj för att visa standardrubrik för din skräddarsydda välkomsttext. När din användare byter språk kommer denna rubrik att ändra språk.<br /><br />Om satt till <b>Ja</b>, kommer rubriken att se ut så här:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]          = "Kontrollera datum hos barn";
$pgv_lang["CHECK_CHILD_DATES_help"]     = "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Kontrollerar datumen för händelser hos barn för att kunna kontrollera om personen kan tänkas vara i livet eller ej.  På äldre system och stora GEDCOM-filer kan denna kontroll leda till en dålig och långsammare responstid för din sajt.<br />";
$pgv_lang["MAX_ALIVE_AGE"]              = "Åldersgräns då person antas vara död";
$pgv_lang["MAX_ALIVE_AGE_help"]         = "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Om denna person har någon händelse förutom död, begravning eller kremering senare än detta år, betraktas han som \"levande\". Barnens födelsedatum betraktas som ett sådan händelse för detta ändamål.<br />";
$pgv_lang["SHOW_GEDCOM_RECORD"]         = "Tillåt användare att se rådata i GEDCOM-poster";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]    = "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Genom att sätta detta val till <b>Ja</b> kommer en länk placeras på alla sidor för personer, källor och familjer som tillåter användaren att läsa rådata från GEDCOM-filen om personen eller källan i fråga i ett separat fönster.<br />";
$pgv_lang["ALLOW_EDIT_GEDCOM"]			= "Tillåt online-redigering";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]		= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Tillåter online-redigeringsmöjligheten för denna databas så att användare med redigeringsprivilegium kan uppdatera data online.<br />";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Automatstängning av redigeringsfönster";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Detta val kontrollerar om redigeringsfönstret ska stängas automatiskt efter lyckad uppdatering.<br />";
$pgv_lang["INDEX_DIRECTORY"]            = "Katalog för indexfiler";
$pgv_lang["INDEX_DIRECTORY_help"]       = "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Sökvägen till den katalog med läs och skrivrättigheter som PhpGedView skall använda för att lagra indexfiler (inkludera avslutande \"/\")<br />Detta ställer in variabeln \$INDEX_DIRECTORY i filen <i>config.php</i>.<br />";
$pgv_lang["POSTAL_CODE"]  = "Position för postnummer";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Olika länder använder olika sätt att skriva adresser. Detta val låter dig placera postnummret antingen före eller efter stadsnamnet.<br />";
$pgv_lang["ALPHA_INDEX_LISTS"]          = "Dela upp långa listor baserat på första bokstaven i namnet";
$pgv_lang["ALPHA_INDEX_LISTS_help"]     = "~#pgv_lang[ALPHA_INDEX_LISTS]#~<br /><br />Om du har väldigt långa listor med personer och familjer, sätt detta värde till <b>Ja</b> för att dela upp listorna i flera sidor baserade på första bokstaven i efternamnet.<br />";
$pgv_lang["NAME_FROM_GEDCOM"]			= "Hämta titelnamn ifrån GEDCOM-filen";
$pgv_lang["NAME_FROM_GEDCOM_help"]		= "~#pgv_lang[NAME_FROM_GEDCOM]#~<br /><br />Som standard använder PhpGedView namnet som finns lagrat i indexen för att få tag på en persons namn. Med vissa GEDCOM-format och språk visas inte sorterade namn på ett korrekt sätt och det bästa sättet är då att hämta det korrekta namnet direkt från GEDCOM-filen istället. Spanska namn är ett utmärkt exempel på detta. Ett spanskt namn kan ha formen Förnamn Faderns Efternamn Moderns Efternamn. Används indexen för att sortera och visa detta namn skulle det felaktigt visas som Förnamn Moderns Efternamn Faderns Efternamn. Används istället namnet lagrat i GEDCOM-filen visas däremot namnen korrekt. En nackdel med denna metod är dock att programmets prestanda försämras.<br /><br />Detta ställer in variabeln \$NAME_FROM_GEDCOM i filen <i>config.php</i>.<br />";
$pgv_lang["SHOW_ID_NUMBERS"]			= "Visa ID-nummer bredvid namnet";
$pgv_lang["SHOW_ID_NUMBERS_help"]		= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Visa ID-nummer i en parantes efter personnamnet i tavlorna.<br />";
$pgv_lang["SHOW_FAM_ID_NUMBERS"]		= "Visa ID-nummer intill familjenamn";
$pgv_lang["SHOW_FAM_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_FAM_ID_NUMBERS]#~<br /><br />Visa familjeid inom parantes efter familjenamnen i tavlor och på ansedelsidan.<br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"]		= "Orter detaljnivå";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Denna sätter nivån av ortsinformation som visas i en personruta i tavlorna. Värdet 9 motsvarar all ortsinformation medans 0 kommer att dölja all ortsinformation. Värdet 1 visar första nivån av ortsinformationen, Värdet 2 visar dom första 2 nivåerna, osv.<br />";
$pgv_lang["MULTI_MEDIA"]                = "Använd multimediafunktioner";
$pgv_lang["MULTI_MEDIA_help"]           = "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1-formatet tillåter dig att länka in bilder, filmer och andra multimediaobjekt i GEDCOM-filen. Om du inte inkluderar multimediaobjekt i dina GEDCOM-filer kan du stänga av denna funktion genom att sätta detta värde till <b>no</b>.<br /><br />Se sektionen om multimedia i <a href=\"readme.txt\">readme.txt</a> filen för mer information om att inkludera mediafiler i din sajt.<br />";
$pgv_lang["MEDIA_EXTERNAL"]				= "Behålla länkar";
$pgv_lang["MEDIA_EXTERNAL_help"]		= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />När en multimedialänk hittas som startar med t.ex http://, ftp://, mms:// kommer den inte att ändras om satt till <b>Ja</b>. T.ex. http://www.myfamily.com/photo/dad.jpg kommar att bli kvar som http://www.myfamily.com/photo/dad.jpg. När inställningen är satt till <b>Nej</b> kommer länken att behandlas som en standardreferens och mediadjupet kommer att användas. T.ex. http://www.myfamily.com/photo/dad.jpg kommer att ändras till ./media/dad.jpg<br />";
$pgv_lang["MEDIA_DIRECTORY"]            = "MultiMediakatalog";
$pgv_lang["MEDIA_DIRECTORY_help"]       = "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Sökvägen till den katalog där PhpGedView skall leta efter lokala multimediafiler (inkludera avslutande \"/\").";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]     = "Antal katalognivåer för MultiMedia som används";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Genom att sätta detta värde till 0 kommer alla kataloger i mediafilens sökväg i GEDCOM-filen att ignoreras. Sätts värdet till 1 kommer den första katalogen i sökvägen att användas.  Ett högre värde innebär fler inkluderade kataloger i den mediafilens sökväg.<br /><br />Till exempel: Om du har en länk till en bild i din GEDCOM-fil med en sökväg liknande <b>C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg</b> kommer ett värdet 0 översättas till en denna sökväg <b>./media/grandpa.jpg</b>.  Värdet 1 kommer översättas till <b>./media/Surname Line/grandpa.jpg</b>, etc.  För de allra flesta kommer värdet 0 fungera bra, men har man flera filer med samma namn i olika kataloger kan ett högre värde vara bra för att förhindra att filerna skrivs över varandra. Denna inställning tillåter dig därför att organisera din mediafiler i olika kataloger för att förenkla administration och förhindrande av namndubletter.<br />";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]      = "Visa bild i personrutor";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Om du använder multimediafiler kan du med detta val tala om för PhpGedView att den skall visa en liten bild bredvid en persons namn i tavlor och rutor.<br /><br />För tillfället använder PhpGedView det först angivna bildobjektet i GEDCOM-posten för detta ändamål. För personer med flera bilder bör du arrangera bilderna så att den bild du vill använda hamnar först i listan, före andra bilder.<br />Se sektionen om multimedia i <a href=\"readme.txt\">readme.txt</a> filen för mer information om att inkludera bilder på din sajt.<br />";
$pgv_lang["USE_THUMBS_MAIN"]			= "Använd minibilder för huvudbilden på ansedeln";
$pgv_lang["USE_THUMBS_MAIN_help"]		= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Beroende på hur du vill spara dina bilder kan det vara bättre för dig att använda miniatyrbilder för bilder intill namnet på ansedelsidan. Om dina huvudbilder är väldigt stora kan det ta väldigt lång tid att ladda ner och om dina miniatyrbilder är av tillräckligt hög kvalitet kan de användas istället för den fulla bilden. Sätt denna inställning till <b>Ja</b> för att använda miniatyrbilder eller lämnat den på <b>Nej</b> för att använda den fulla bilden.<br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"]      = "Tillåt urklippskorgen";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Urklippskorgen tillåter besökare på din site att lägga till personer i en urklippskorg. Urklippskorgen kan sedan besökaren ladda ner i form av en GEDCOM-fil som de sedan kan importera i sina egna släktforskningsprogram.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]         = "Göm GEDCOM-fel";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]    = "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Sätt detta värde till <b>Ja</b> om du vill att gömma alla felmeddelanden som PhpGedView producerar, om programmet inte förstår ett attribut i din GEDCOM-fil. PhpGedView försöker hela tiden att följa standarden för GEDCOM 5.5.1, men vissa genealogiska program inkluderar sina egna ickestandardiserade taggar. Se <a href=\"readme.txt\">readme.txt</a> filen för mer information.<br />";
$pgv_lang["WORD_WRAPPED_NOTES"]         = "Lägg till tomrum där anteckningar blir wrappade";
$pgv_lang["WORD_WRAPPED_NOTES_help"]    = "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Vissa genealogiska program bryter rader vid ordgränserna medan andra bryter mitt i orden.  Detta fenomen kan få PhpGedView att skriva ihop två ord.  Genom att sätta detta värde till <b>Ja</b> kommer ett mellanslag att läggas till där meningar radbryts i GEDCOM-filen.<br />";
$pgv_lang["SHOW_CONTEXT_HELP"]			= "Visa <b>?</b> hjälplänkar på sidorna";
$pgv_lang["SHOW_CONTEXT_HELP_help"]		= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Detta val kommer att sätta på frågeteckenhjälplänkarna på sidorna intill valmöjligheterna så att besökare kan få hjälptexter om valen på sidorna.<br />";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]			= "Kommande händelseområdets gräns för antal dagar";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Skriv in det maximala antal dagar(max 30) att visa i kommande händelser området. Om du skriver in ett större värde än 30 så kommer 30 att användas.<br /><br />Värdet du skriver in bestämmer hur långt fram PhpGedView kollar när programmet söker efter kommande händelser. Resultat av sökningen, som görs en gång om dagen, kopieras till en temporär fil.<br /><br />Inget kommande händelser området på Index eller Portal sidorna kan räkna längre en detta värde. Desto större värde, desto längre tid kommer det att beräkna de dagliga uppdateringarna och desto längre tid kommer det att ta att visa områdena, även om du begär att använda ett lägre nummer en denna inställningar.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]		= "Minsta antal efternamn innan namnet kommer med i Vanliga efternamnslistan";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Detta är antalet gånger ett efternamn måste förekomma innan det visas i Vanliga efternamnlistan på välkomstsidan.<br />";
$pgv_lang["COMMON_NAMES_ADD"]			= "Namn att lägga till Vanliga efternamnslistan (kommaseparerad)";
$pgv_lang["COMMON_NAMES_ADD_help"]		= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Om antalet gånger ett efternamn förekommer är mindre än tröskeln, så kommer det inte med i listan. Det kan här läggas till manuellt. Om mer än ett efternamn skrivs in, måste de vara separerad med kommatecken. Efternamn är känsliga för stora och små bokstäver.<br />";
$pgv_lang["COMMON_NAMES_REMOVE"]		= "Namn att ta bort från vanliga efternamnslistan (kommaseparerad)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Om du vill ta bort ett efternamn från vanliga efternamnslistan utan att öka på tröskelvärdet, kan du lägga till det här. Om mer än ett efternamn måste de vara separerad av kommatecken, Efternamnen är känsliga för stora och små bokstäver. Efternamn som skrivs in här kommer också att tas bort från tio i topp listan på välkomstsidan.<br />";
$pgv_lang["HOME_SITE_URL"]              = "Huvudsidans URL";
$pgv_lang["HOME_SITE_URL_help"]         = "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Varje PhpGedView-sida inkludera en länk till din huvudhemsida. Utseendet på denna länk kontrolleras av det tema som används. Du skriver in URL till din hemsida här.<br />";
$pgv_lang["HOME_SITE_TEXT"]             = "Huvudsidans text";
$pgv_lang["HOME_SITE_TEXT_help"]        = "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />Den text som kommer att användas som titel för länken till din huvudsida.<br />";
$pgv_lang["CONTACT_EMAIL"]              = "Släktforskningskontakt";
$pgv_lang["CONTACT_EMAIL_help"]         = "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />E-post-adress som besökare kan använda för att kontakta dig om frågor gällande dina genealogiska data på din sida.<br />";
$pgv_lang["CONTACT_METHOD"]				= "Kontaktmetod";
$pgv_lang["CONTACT_METHOD_help"]		= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Metoden som besökare kommer att använda för att kontakta #pgv_lang[CONTACT_EMAIL]# om släktforskningsfrågor.<ul><li> <b>#pgv_lang[mailto]#</b>-alternativet kommer att lägga till en E-post till länk som besökare kan klicka på för att sända e-post via deras e-postklient.</li><br /><li> <b>#pgv_lang[messaging]#</b>-alternativet använder PhpGedViews inbyggda meddelandesystem vilket medför att ingen e-post kommer att skickas.</li><br /><li> Alternativet <b>#pgv_lang[messaging2]#</b> är standardalternativet och medför att man använder PhpGedViews meddelandesystem, men att det även skickas en kopia av meddelandet via e-post.</li><br /><li><b>#pgv_lang[messaging3]#</b>-alternativet låter PhpGedView att hantera meddelande och gör att e-post kommer att skicas men kopier kommer inte att sparas internt. Detta valet är liknade <b>#pgv_lang[mailto]#</b> förutom att meddelande kommer att skickas av PhpGedView istället för ifrån den lokala datorn.</li><br /><li>Om man väljer alternativ <b>#pgv_lang[no_messaging]#</b> finns det ingen möjlighet för besökare att kontakta dig.</li></ul>";
$pgv_lang["WEBMASTER_EMAIL"]            = "Support kontakt";
$pgv_lang["WEBMASTER_EMAIL_help"]       = "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />E-mail-adress besökare kan använda för att kontakta dig angående tekniska frågor eller fel på din site.<br />";
$pgv_lang["SUPPORT_METHOD"]				= "Supportmetod";
$pgv_lang["SUPPORT_METHOD_help"]		= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Metoden som besökare kommer att använda för att kontakta #pgv_lang[WEBMATER_EMAIL]# om tekniska frågor.<ul><li> <b>#pgv_lang[mailto]#</b>-alternativet kommer att lägga till en E-post till länk som besökare kan klicka på för att sända e-post via deras e-postklient.</li><br /><li> <b>#pgv_lang[messaging]#</b>-alternativet använder PhpGedViews inbyggda meddelandesystem vilket medför att ingen e-post kommer att skickas.</li><br /><li> Alternativet <b>#pgv_lang[messaging2]#</b> är standardalternativet och medför att man använder PhpGedViews meddelandesystem, men att det även skickas en kopia av meddelandet via e-post.</li><br /><li><b>#pgv_lang[messaging3]#</b>-alternativet låter PhpGedView att hantera meddelande och gör att e-post kommer att skicas men kopier kommer inte att sparas internt. Detta valet är liknade <b>#pgv_lang[mailto]#</b> förutom att meddelande kommer att skickas av PhpGedView istället för ifrån den lokala datorn.</li><br /><li>Om man väljer alternativ <b>#pgv_lang[no_messaging]#</b> finns det ingen möjlighet för besökare att kontakta dig.</li></ul>";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Visa faktaikoner";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Sett detta vat till <b>#pgv_lang[yes]#</b> för att visa ikoner nära faktanamn på #pgv_lang[personal_facts]#-sidan. Faktaikoner kommer att visas endast om de finns i <i>images/facts</i> mappen i det nuvarande temat.<br />";
$pgv_lang["FAVICON"]                    = "Favoritikon";
$pgv_lang["FAVICON_help"]               = "~#pgv_lang[FAVICON]#~<br /><br />Ändra denna sökväg så att den pekar på den ikon du vill skall visas i besökares favoriter när lagt till din sida bland sina bokmärken.<br />";
$pgv_lang["THEME_DIR"]                  = "Temakatalog";
$pgv_lang["THEME_DIR_help"]             = "~#pgv_lang[THEME_DIR]#~<br /><br />Katalogen där dina PhpGedView-teman är lagrade. Du kan ändra vilken som helst av medföljande tema för att sätta din egna unika prägel på din PhpGedView-sajt.  Se sektionen om att skräddarsy teman i filen <a href=\"readme.txt\">readme.txt</a>, för mer information.<br />";
$pgv_lang["TIME_LIMIT"]                 = "PHP-tidsgräns";
$pgv_lang["TIME_LIMIT_help"]            = "~#pgv_lang[TIME_LIMIT]#~<br /><br />Den maximala tid i sekunder som PhpGedView är tillåtet att köra vid ett anrop.<br /><br />Standardvärdet är en minut (60s). Beroende på storleken på din GEDCOM-fil kan du behöva öka tidsgränsen när du behöver uppdatera och genera index mm för din GEDCOM-fil. Sätt detta värde till 0 för att tillåta PHP att köra under obegränsad tid.<br />VARNING: Att sätta värdet till 0, eller för högt kan leda till att din sida i vissa operativsystem slutar svara ända tills det att skriptet avslutas.  Att sätta värdet till 0 innebära att phpskriptet i vissa situtationer aldrig kommer avslutas förrän serveradminstratören dödar processen eller startar om servern.  Ett stort släktträd kan ta rätt lång tid på sig att köra, varför ett lågt värde kan hjälpa till att förhindra att en illvillig person krashar din servern genom att fråga efter ett släktträd på tusentals generationer.<br />";
$pgv_lang["PGV_SESSION_SAVE_PATH"]		= "Sparsökväg för session";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Sökvägen för att spara PhpGedView sessionsfiler. Vissa webbhotell har inte configurerat PHP på ett korrekt sätt varför sessioner inte behålls mellan sidförflyttingar. Detta val gör det möjligt för administratörer att åtgärda detta genom att spara sessionsfilerna i en lokal katalog. ./index/ katalogen är ett bra val om du behöver ändra detta. Som standard lämnas fältet tomt vilket innebär att standardsäkvägen angiven i <i>php.ini</i> kommer användas.<br /><br />Detta ställer in variabeln \$PGV_SESSION_SAVE_PATH i filen <i>config.php</i>.<br />";
$pgv_lang["SERVER_URL"]					= "PhpGedView URL";
$pgv_lang["SERVER_URL_help"]			= "~#pgv_lang[SERVER_URL]#~<br /><br />Om du använder https eller en annan port än HTTP standardport, behöver du ange en URL för att få åtkomst till din server.<br /><br />Detta sätter variablen \$SERVER_URL i filen <i>config.php</i>.<br />";
$pgv_lang["LOGIN_URL"]					= "InloggningsURL";
$pgv_lang["LOGIN_URL_help"]				= "~#pgv_lang[LOGIN_URL]#~<br /><br />Du behöver bara skriva in en inloggningsURL om du vill skicka vidare besökare till en annan address eller plats när de loggar in. Detta är väldigt användbart för att t.ex. om du vill ändra från http https när en användare loggar in. Inkludera hela URLn till login.php-filen (t.ex. https://www.dinserver.com/phpgedview/login.php).<br /><br />Detta sätter \$LOGIN_URL i <i>config.php</i>.<br />";
$pgv_lang["PGV_SESSION_TIME"]			= "Sessions timeout";
$pgv_lang["PGV_SESSION_TIME_help"]		= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Tiden i sekunder en session i PhpGedView varar innan en ny inloggning krävs. Standardtiden är 120 minuter.<br /><br />Detta sätter variabeln \$PGV_SESSION_TIME i filen <i>config.php</i>.<br />";
$pgv_lang["SHOW_COUNTER_help"] 			= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Visa träffräknare i portalen och på enskilda sidor.<br />";
$pgv_lang["SHOW_COUNTER"]  				= "Visa träffräknare";
$pgv_lang["SHOW_STATS"]					= "Visa processstatistik";
$pgv_lang["SHOW_STATS_help"]			= "~#pgv_lang[SHOW_STATS]#~<br /><br />Visa körtid och antalet databasfrågor längst ner på varje sida.<br />";
$pgv_lang["USE_REGISTRATION_MODULE"]	= "Tillåt användare att begära kontoregistrering";
$pgv_lang["USE_REGISTRATION_MODULE_help"] = "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Ger användare möjligheten att registrera sig själva för ett konto på sajten.<br /><br />Användaren kommer att få ett e-post meddelande med en kod för att verifiera sin ansökan.<br />Efter verifiering, kommer administratören behöver godkänna registreringen innan den blir aktiv.<br /><br />Detta sätter variabeln \$USE_REGISTRATION_MODULE i filen <i>config.php</i>.<br />";
$pgv_lang["ALLOW_USER_THEMES"]			= "Tillåt användaren att välja sitt eget tema.";
$pgv_lang["ALLOW_USER_THEMES_help"]		= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Ger användaren möjligheten att välja sitt eget tema.<br /><br />Detta sätter variabeln \$ALLOW_USER_THEMES i filen <i>config.php</i>.<br />";
$pgv_lang["PGV_SIMPLE_MAIL"] 			= "Använd enkelt mailhuvud i externa e-post";
$pgv_lang["PGV_SIMPLE_MAIL_help"]		= "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />I normala e-posthuvud för externa e-post, e-postadress likväl som namn används. Vissa e-postsystem acceptera inte detta. Satt till <b>Ja</b>, endast e-postadressen kommer att användas.<br /><br />Detta sätter variabeln \$PGV_SIMPLE_MAIL i filen <i>config.php</i>.<br />";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Avgör om meddelanden som sänds genom PhpGedView ska sparas i databasen. Om man sätter inställningen till <b>Jab/b>, kan man läsa meddelanden när du loggar in i PhpGedView. Om man sätter inställnigen till <b>Nej</b>, kommer meddelande endast att skickas via e-post. Denna inställning sätter variabeln \$PGV_STORE_MESSAGES i filen <i>config.php</i>.<br />";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Visa temaväljare för att ändra tema";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Ger användaren valet att välja sitt eget tema från en meny<br />.<br />Även med detta val satt behöver det nuvarande temat inte ha någon sadan meny. Kräver <b>#pgv_lang[ALLOW_USER_THEMES]#</b> att vara satt dessutom.<br />Detta sätter variabeln \$ALLOW_THEME_DROPDOWN i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["MAX_VIEW_RATE"]		= "Maximum sidvisningstakt";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Detta val begränsar takten som en besökare kan se sidorna i.<br /><br />Om denna takt överskrids kommer PhpGedView att anta att ett försök att hacka sidan pågår och sessionen kommer att avslutas med ett passande felmeddelande. Dessa två värden bör sätta en lämplig begränsning på hur stor bandbredd och antal nerladdade bytes från servern. Dessa inställning kan stängas av genom att sätta tidsintervallet till 0.<br /><br />Detta sätter \$MAX_VIEWS och \$MAX_VIEW_TIME i <i>Config.php</i>.<br />";
$pgv_lang["page_views"]			= "&nbsp;&nbsp;Sidvisningar per&nbsp;&nbsp;";
$pgv_lang["seconds"]			= "&nbsp;&nbsp;sekund";
$pgv_lang["META_AUTHOR"]			= "Författare META tag";
$pgv_lang["META_AUTHOR_help"]		= "~#pgv_lang[META_AUTHOR]#~<br /><br />Värdet som ska användas i författar-metatagen i HTML sidans rubrik. Lämna detta fält tomt för att använda #pgv_lang[CONTACT_EMAIL]fulla namn för detta värde.<br /><br />Detta sätter \$META_AUTHOR variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_AUTHOR_descr"]		= "Lämna detta fält tomt för att använda #pgv_lang[CONTACT_EMAIL]# fulla namn för detta värde.";
$pgv_lang["META_PUBLISHER"]			= "Utgivare META tag";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Värdet som ska användas i förläggarmetatag i HTML sidans rubrik. Lämna detta fält tomt för att använda #pgv_lang[CONTACT_EMAIL]# fulla namn för detta värde.<br /><br />Detta sätter \$META_PUBLISHER variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PUBLISHER_descr"]	= "Lämna detta fält tomt för att använda #pgv_lang[CONTACT_EMAIL]# fulla namn för detta värde.";
$pgv_lang["META_COPYRIGHT"]			= "Copyright META tag";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Värdet som ska användas i upphövsrätts-metatagen i HTML sidans rubrik. Lämna detta fält tomt för att använda #pgv_lang[CONTACT_EMAIL]# fulla namn för detta värde.<br /><br />Detta sätter \$META_COPYRIGHT variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_COPYRIGHT_descr"]	= "Lämna detta fält tomt för att använda #pgv_lang[CONTACT_EMAIL]# fulla namn för detta värde.";
$pgv_lang["META_DESCRIPTION"]		= "Beskrivning META tag";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Värdet som ska användas i beskrivningsmetatagen i HTML sidans rubrik. Lämna detta fält tomt för att använda aktiva GEDCOM-titlen för detta värde.<br /><br />Detta sätter \$META_DESCRIPTION variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_DESCRIPTION_descr"]	= "Lämna detta fält tomt för att använda den för närvarande aktiva databasens title för detta värde.";
$pgv_lang["META_PAGE_TOPIC"]		= "Sidämne META tag";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Värdet som ska användas i sidämnes-metatagen i HTML sidans rubrik. Lämna detta fält tomt för att använda den aktiva databasen title för detta värde.<br />Detta sätter \$META_PAGE_TOPIC variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Lämna detta fält tomt för att använda den för närvarande aktiva databasens titel för detta värde.";
$pgv_lang["META_AUDIENCE"]			= "Publik META tag";
$pgv_lang["META_AUDIENCE_help"]		= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Värdet som ska användas i publik-metatagen i HTML sidans rubrik.<br />Detta sätter \$META_AUDIENCE variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PAGE_TYPE"]			= "Sidtyp META tag";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Värdet som ska användas i sidtyp-metatagen i HTML sidans rubrik.<br /><br />Detta sätter \$META_PAGE_TYPE variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_ROBOTS"]			= "Robot META tag";
$pgv_lang["META_ROBOTS_help"]		= "~#pgv_lang[META_ROBOTS]#~<br /><br />Värdet som ska användas i Robots-metatagen i HTML sidans rubrik. Många robotar eller webkravlare bryr sig inte om detta värde.<br /><br />Detta sätter \$META_ROBOTS variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_REVISIT"]			= "Hur ofta ska robotscript återbesöka META tagen";
$pgv_lang["META_REVISIT_help"]		= "~#pgv_lang[META_REVISIT]#~<br /><br />Värdet som ska användas i återbesöks-metatagen i HTML sidans rubrik. Många webkravlare bryr sig inte om detta värde.<br /><br />Detta sätter \$META_AUDIENCE variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_KEYWORDS"]			= "Nyckelord META tag";
$pgv_lang["META_KEYWORDS_help"]		= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Värdet som ska användas i nyckelord-metatagen i HTML sidans rubrik. Många sökmotorer använder denna metatag som hjälp vid indexering av sidan. DE #pgv_lang[common_surnames]# som återfinns i #pgv_lang[gedcom_stats]# på välkomstsidan kommer att läggas till slutet på det du skriver i detta fält.<br />Detta sätter \$META_KEYWORDS variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_TITLE"]					= "Lägg till till TITLE-rubriktaggen";
$pgv_lang["META_TITLE_help"]			=	"~#pgv_lang[META_TITLE]#~<br /><br />Det som skrivs på denna rad kommer att läggas till titel-tagen i HTML sidhuvud efter den vanliga sidtiteln och före PhpGedView omnämnandet.<br /><br />Detta sätter \$META_TITLE variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["ENABLE_RSS"]				= "Aktivera RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Detta val låter dig avaktivera RSS möjligheten.<br /><br />RSS låter användare att övervaka din sajt för ändringar på indexsidan utan att komma till din sidan periodiskt. Om för många användare använder denna finess eller om uppdateringsfrekvensen är för tät då kan RSS använda för mycket bandbredd eller serverkapacitet.<br />";
$pgv_lang["RSS_FORMAT"]				= "RSS-format";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Formatet för RSS som ska användas som standard RSS-matningsformat för denna sajt. Det numeriska suffixet <u>visar inte</u> version utan identifierar formatet. T.ex. RSS 2.0 är inte nyare än RSS 1.0 utan ett annat format. RSS-matningsläsare bör kunna läsa alla format. där är för tillfället ingen skilnad mellan ATOM och ATOM 0.3. Båda använder ATOM 0.3 utkast till specifikation.<br />";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Kontrollera om det finns en nerladdningsbar GEDCOM-fil";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Av säkerhetsorsaker bör inte GEDCOM-filen finnas på ett ställe där den är direkt nerladdningsbar, och därigenom undvika alla integritetskontroller. Denna kontroll kan orsaka prestandaproblem på vissa servrar.<br /><br />Om du vet att GEDCOM-filen inte finns i en mapp som är direktåtkomlig från internet, då kan du avaktivera denna kontroll.<br />";
$pgv_lang["PGV_STORE_MESSAGES"]			= "Tillåt att meddelande sparas online";
$pgv_lang["PGV_MEMORY_LIMIT_help"]		= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />Det maximala mängden minne som kan användas av PhpGedViewskripten. Standardinställningen är 32M. Många webhotell stänger av denna inställning i sin php-konfiguration, så ändringen av detta värde har ibland ingen effekt.<br /><br />Denna inställning sätter variabeln \$PGV_MEMORY_LIMIT i filen <i>config.php</i>.<br />";
$pgv_lang["PGV_MEMORY_LIMIT"]			= "Minnesgräns";
$pgv_lang["gedcom_title_help"]			= "~#pgv_lang[gedcom_title]#~<br /><br />Skriv in en beskrivande titel som kommer att visas när besökare väljer mellan olika GEDCOM-filer på din sajt.<br />";
$pgv_lang["LOGFILE_CREATE"]				= "Arkivera loggfiler";
$pgv_lang["LOGFILE_CREATE_help"]		= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Hur ofta ska programmet arkivera logfiler.<br /><br />Detta sätter variabeln \$LOGFILE_CREATE i filen <i>config.php</i>.<br />";

$pgv_lang["welcome_new"]                = "Välkommen till din nya PhpGedView-websida.<br /><br />Eftersom du kan se denna sida har du framgångsrikt installerat PhpGedView på din webserver. Du är nu redo att börja konfigurera PhpGedView, så som du vill ha det.<br /><br />";
$pgv_lang["welcome_new2"]			= "<br /><br />Eftersom du ser denna sida så har du lyckats installera PhpGedView på din server och är redo att börja konfigurera det efter dina önskemål.<br /><br />";
$pgv_lang["welcome_new_help"]			= "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]#Detta hjälpfönster vill guida dig igenom konfigurationsprocessen. När du flyttar dig mellan olika fält kommer detta fönster att visa hjälpinformation om fältet du är i. Du kan stänga fönstret och om du vill öppna det igen så tryck på '?' intill fältetiketten.<br />";
$pgv_lang["review_readme"]              = "Du bör först läsa igenom filen <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> innan du fortsätter med att konfigurera PhpGedView.<br /><br />";
$pgv_lang["return_editconfig"]			= "Du kan återvända till denna konfiguration när du vill genom att skriva in sidadressen <i>editconfig.php</i> i nätbläddraren, eller genom att klicka på länken <b>Konfiguration</b> på <b>#pgv_lang[gedcom_adm_head]#</b>-sidan.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "Du kan återvända till denna konfiguration när du vill genom att klicka på länken: <b>Redigera</b> i <b>#pgv_lang[current_gedcoms]#</b>-tabellen, i <b>#pgv_lang[gedcom_adm_head]#</b> eller genom att skriva in sidan för filen <i>editconfig_gedcom.php</i>.<br />";
$pgv_lang["save_config"]                = "Spara konfigurationen";
$pgv_lang["download_here"]				= "Klicka här för att ladda ner filen.";
$pgv_lang["download_gedconf"]			= "Ladda ner GEDCOM-inställningarna.";
$pgv_lang["not_writable"]				= "Din inställningsfil är inte skrivbar. Du kan använda <b>#pgv_lang[download_file]#</b>-knappen för att spara dina inställningar så att du kan ladda upp dom manuellt.";
$pgv_lang["download_file"]				= "Ladda ner fil";
$pgv_lang["upload_to_index"]			= "Ladda upp filen till indexkatalogen: ";
$pgv_lang["import_sql"]					= "SQLfiler hittades i din indexmapp. De kan komma ifrån användarmigreringsverktyget, du har möjlighet att importera informationen till databasen. All existerande användarinformation(användare, nyheter, favoriter, Områdeslayout och meddelande) i din databas kommer att förloras.<br /><br />Om du väljer att fortsätta, kommer PhpGedView att försöka att importera datan. Om detta inte lyckas kommer du att bli tillfrågad att skapa det första administratörskontot iallafall.<br /><br />";
$pgv_lang["date_format"]				= "Datumformat:";

//-- edit privacy messages
$pgv_lang["edit_privacy"]				= "Ändra integritetsinställningar";
$pgv_lang["edit_privacy_title"]			= "Editera GEDCOM-integritetsinställningar";
$pgv_lang["PRIV_PUBLIC"]				= "Visa för allmänheten";
$pgv_lang["PRIV_USER"]					= "Visa endast för registrerade användare";
$pgv_lang["PRIV_NONE"]					= "Visa endast för administratörer";
$pgv_lang["PRIV_HIDE"]					= "Dölj till och med för administratörer";
$pgv_lang["save_changed_settings"]		= "Spara ändringar";
$pgv_lang["add_new_pp_setting"]			= "Lägg till ny inställningar för personintegritet";
$pgv_lang["add_new_up_setting"]			= "Lägg till ny inställning för användarintegritet";
$pgv_lang["add_new_gf_setting"]			= "Lägg till ny inställning för globalfaktaintegritet";
$pgv_lang["add_new_pf_setting"]			= "Lägg till ny inställning för personfaktaintegritet";
$pgv_lang["file_read_error"]			= "FEL!!! kunde inte läsa integritetsfilen!";
$pgv_lang["general_privacy"]			= "Allmäna integritetsinställningar";
$pgv_lang["person_privacy"]				= "Personintegritetsinställningar";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Ändra existerande inställningar för personintegritet";
$pgv_lang["user_privacy"]				= "Användarintegritetsinställningar";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Ändra existerande användarintegritetsinställningar";
$pgv_lang["global_facts"]				= "Globala faktaintegritetsinställningar";
$pgv_lang["edit_exist_global_facts_settings"]	= "Ändra existerande globala faktaintegritetsinställningar";
$pgv_lang["person_facts"]				= "Personfaktaintegritetsinställningar";
$pgv_lang["edit_exist_person_facts_settings"]	= "Ändra existerande inställningar för personfaktaintegritet";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Du kan ha olika integritetsinställningar för varje GEDCOM på din PhpGedView-sajt. Kontrollera under sidtiteln för att kontrollera att du editerar rätt GEDCOM-fil.<br />Detta betyder också att för varje GEDCOM-fil(om du har fler än en) kan du ha olika inställningar.<br />Du kan ändra dessa allmäna inställningar genom att använda den andra integritetsformuläret på #pgv_lang[edit_privacy_title]#sidan.<br />#pgv_lang[more_config_help]#";
$pgv_lang["accessible_by"]				= "Visa för?";
$pgv_lang["hide"]						= "Göm";
$pgv_lang["show_question"]				= "Visa?";
$pgv_lang["user_name"]					= "Användarnamn";
$pgv_lang["name_of_fact"]				= "Namn på fakta";
$pgv_lang["choice"]						= "Val";
$pgv_lang["fact_show"]					= "Visa fakta";
$pgv_lang["fact_details"]				= "Visa faktadetaljer";
$pgv_lang["privacy_header"]				= "Ändra integritetsinställningar inuti";
$pgv_lang["unable_to_find_privacy_indi"]= "Kan inte hitta personen med id";
$pgv_lang["save_and_import"]			= "Efter du har sparat denna GEDCOM-konfiguration behöver du importera GEDCOM-filen genom att klicka <b>Importera GEDCOM</b>-knappen eller genom att gå till <b>Admin->Administrera GEDCOM-filer->Importera</b>";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Visa de levandes namn";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]	= "Använd relationsintegritet";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]	= "Max. relationsväglängd";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]	= "Kontrollera vigselrelation";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Visa döda personer";
$pgv_lang["help_info"]					= "Du kan få hjälp för varje sak genom att trycka på '?' vid etiketten för varje fält.";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Skall levande personers namn visas för allmänheten?<br /><br />Detta sätter variabeln \$SHOW_LIVING_NAMES i <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Visa forskningsassistenten";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Vilken typ av amvändare kan se forskningsassistentmodulen om den är installerad?<br />Detta sätter \$SHOW_RESEARCH_ASSISTANT i <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br />Ett <b>Nej'</b>innebär att registrerade användare kan se detaljerna på alla levande personer.<br /><br />Ett <b>Ja</b> betyder att användare bara kan se den privata informationen för levande personer de är släkt med.<br /><br />Detta sätter variablen \$USE_RELATIONSHIP_PRIVACY i <i><u>xxx</u>.GED_priv.php</i>.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Om #pgv_lang[USE_RELATIONSHIP_PRIVACY]# är påsatt, inloggade användare kommer endast kunna se och redigera personer inom detta antal släktsteg.<br /><br />Detta sätter variablen \$MAX_RELATION_PATH_LENGTH i <i><u>xxx</u>.GED_priv.php</i>.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Kontrollera släktförhållande genom vigselrelationer.<br /><br />Detta sätter variabeln \$CHECK_MARRIAGE_RELATIONS i <i><u>xxx</u>.GED_priv.php</i>.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Sätt integritetsaccessnivå för alla döda personer.<br />";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Dessa inställningarna ger administratören möjlighet att åsidosätta standardinställningarna för en specifik person i GEDCOM-filen. Till exempel för ett barn som dött tidigt. Normalt skulle detta barns data visas för alla och man vill kanske inte ta bort dödposten för barnet men ändå gömma detaljerna för icke registrerade användare. Om barnet har ID l100 kan man skriva in följande inställningar:<br /><br />ID:l100<br />Visa för: 'Visa endast för registrerade användare'<br /><br />Detta fungerar på andra hållet också. Om man vill visa detaljerna för någon(ID l101) som man vet är död men som man inte har något dödsdatum för kan man lägga till följande:<br /><br />ID: l101<br />Visa för: 'Visa för alla'<br /><br />Detta sätter variabeln \$person_privacy i <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Dessa inställningarna ger administratören möjlighet att åsidosätta standardinställningarna för en specifik person i GEDCOM-filen baserat på användarnamn.<br />Till exempel om man inte vill att användarnamnet <b>John</b> ska kunna se några detaljer för ID 100 i GEDCOM-filen kan man konfigurera det så här:<br /><br />Användarnamn: John<br />ID: 100<br />Show?: 'Hide'<br />och detaljerna kommer inte att synas för användarnamnet 'John'.<br /><br />För att visa detaljerna för ID 101 (Vilket normalt inte skulle synas) för användarnamnet 'John':<br /><br />Användarnamn: John<br />ID:101<br />Show?: 'Show'<br />och detljerna kommer att synas endast för användarnamnet 'John'.<br /><br />Detta sätter variabeln \$user_privacy i <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Dessa inställningar definierar på en global nivå vilka data som ska var dolda för alla personer i en GEDCOM.<br /><ul><li><b>#pgv_lang[name_of_fact]#</b>-lement bestämmer vilka fakta som ska vara dolda.</li><li><b>#pgv_lang[choice]#</b>-elementet väljer antingen hela faktan eller releaterade detaljer.</li><li><b>#pgv_lang[accessible_by]#</b>-elementet bestämmer på vilken åtkomstnivå faktan visas.</li></ul><br />Denna funktion är tänkt att dölja vissa fakta för alla personer, levande eller döda, via GEDCOM-tag. SSN taggen är dold för alla användare från början. Detta är för att hindra stöld av personnummer för att byta identitet med dina döda släktingar, detta problem är troligen mest relevant för USA.<br /><br />Om man vill dölja alla vigselfakta för den allmänna användaren i min GEDCOM-filen kan man  sätta:<br /><br />><b>#pgv_lang[name_of_fact]#</b> (MARR) - Vigsel<br />><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_show]#\"<br /><b>#pgv_lang[accessible_by]#</b>\"#pgv_lang[PRIV_USER]#\"<br /><br /><b>#pgv_lang[name_of_fact]#</b> (MARR) - Vigsel<br /><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_details]#\"<br /><b>#pgv_lang[accessible_by]#</b> \"#pgv_lang[PRIV_USER]#\"<br /><br />Dessa inställningar kommer att dölja vigslar(och dess detaljer) för alla som inte är administratör.<br /><br />Till skillnad från andra inställningar i <b>#pgv_lang[global_facts_settings]#</b> kab du dölja fakta till och med för administratörsanvändare. Icke önskvärda fakta kan döljas helt.<br /><br />Detta sätter variablen \$global_facts i <i><u>xxx</u>.GED_priv.php</i>.";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Dessa inställningar definierar vilka fakta som är dolda för en specifik person i en GEDCOM-fil och på vilken nivå de är dolda.<br /><br />Det första elementet är ID för personen, det andra elementet är faktan.<br /><b>#pgv_lang[choice]#</b> elementet väljer antingen hela faktan eller releaterade detaljer. <b>#pgv_lang[accessible_by]#</b> elementet bestämmer på vilken åtkomstnivå faktan visas.<br /><br />\$person_facts vektorn fungerar på samma sätt som \$global_facts vektorn förutom att du dessutom anger GEDCOM-ID för person som du vill dölja fakta för. På så vis kan man dölja t ex vigselfaktan för en specifik person.<br /><br />Detta sätter variablen \$person_facts i <i><u>xxx</u>.GED_priv.php</i>.";
$pgv_lang["select_privacyfile_button"]	= "Välj integritetsfil";
$pgv_lang["PRIVACY_BY_YEAR"]			= "Begränsa integritet via ålder för händelse";
$pgv_lang["PRIVACY_BY_YEAR_help"]		= "<b>#pgv_lang[PRIVACY_BY_YEAR]#</b>-inställningen kommer att dölja detlajerna för personer baserad på hur gammla de var vid ett specifik händelse oavsett om de lever eller är döda.<br /><br />Använd denna inställning tillsammans med <b>#pgv_lang[MAX_ALIVE_AGE]#</b>-inställningen. T.ex. om du sätter åldersinställning till 100 och sätter denna inställning till <b>Ja</b>, då kommer alla personer, levande eller döda, födda för mindre än 100 år sedan att sättas som privata. Personer som var gifta för mindre än 85 år sedan, och personer som dög för mindre än 75 år sedan kommer också att markeras som privata. Observera att om du använder detta val kommer att prestanda att försämras något.<br /><br />Detta sätter \$PRIVACY_BY_YEAR variabeln i <i><u>xxx</u>.GED_priv.php</i>.";
$pgv_lang["enable_disable_lang"]		= "Konfigurera stödda språk";
$pgv_lang["translator_tools"]			= "Översättningsverktyg";

//-- language edit utility
$pgv_lang["edit_langdiff"]				= "Redigera och konfigurera språkfiler";
$pgv_lang["bom_check"]					= "Byte Order Mark (BOM) kontroll";
$pgv_lang["bom_check_help"]				= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#<br />";
$pgv_lang["bom_check_desc"]		= "Denna kontroll kommer att analysera språkfilerna efter BOM-tecken (Byte Order Mark). Om de hittas kommer de att tas bort. Dessa specialkoder kan orsaka problem i vissa delar av PhpGedView.";
$pgv_lang["lang_debug"]					= "Hjälptext debugval";
$pgv_lang["lang_debug_help"]			= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
$pgv_lang["lang_debug_desc"]	= "När du sätter på detta val kommer språkvariabeln som används i hjälptexten kommer att skrivas i hjälptextfönstret. Detta hjälper översättare att bestämma variabelnamn när texter behöver justeras.<br /><br />Denna inställning är endast giltig under din nuvarande PhpgedView-Sessionen.";
$pgv_lang["lang_debug_use"]				= "Använd hjälptext debugvalet";
$pgv_lang["bom_not_found"]				= "Inga BOM tecken hittades.";
$pgv_lang["bom_found"]					= "BOM har hittats i";
$pgv_lang["edit_lang_utility"]			= "Redigerare för översättningsfiler";
$pgv_lang["edit_lang_utility_warning"]	= "OBS!<br /><br />Om du besämmer dig för att använda knappen  <b>#pgv_lang[close_window_without_refresh]#</b> du bör veta att du inte kommer att se ändringar direkt på skärmen i språkredigeraren tills du gör en manual siduppdatering. Om du ändrar ett nytt meddelande som inte varit i språkfil eller ett meddelande som precis blivit redigera kan du förstöra den.<br /><br />Så om du inte är säker på vad du gör så använd inte knappen <b>#pgv_lang[close_window_without_refresh]#</b>.";
$pgv_lang["edit_lang_utility_help"]		= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#<br />";
$pgv_lang["edit_lang_utility_desc"]	= "Du kan använda detta verktyg att redigera innehållet i en språkfil genom att använda innehållet i den engelska filen.<br /><br />Du kommer att se innehållet i den engelska språkfilen och innehållet i den egna språkfilen av samma typ(det finns fyra typer). Du klickar på den engelska meddelandetexten som visas under den engelska versionen. Detta öppnar ett nytt fönster där du kan modifiera texten. Du kan spara ändringarna eller avbryta.";
$pgv_lang["language_to_edit"]			= "Välj språk";
$pgv_lang["file_to_edit"]				= "Välj översättningsfil";
$pgv_lang["check"]						= "Kontrollera";
$pgv_lang["lang_save"]					= "Spara";
$pgv_lang["contents"]					= "Innehåll";
$pgv_lang["listing"]					= "Visar";
$pgv_lang["no_content"]					= "Inget innehåll";
$pgv_lang["editlang"]					= "Redigera";
$pgv_lang["cancel"]						= "Avbryt";
$pgv_lang["savelang"]					= "Spara";
$pgv_lang["editlang_help"]				= "~#pgv_lang[editlang]#~<br /><br />Ändra på översättning.<br />";
$pgv_lang["savelang_help"]				= "~#pgv_lang[savelang]#~<br /><br />Spara redigerat meddelande till språkfil.<br />";
$pgv_lang["original_message"]			= "Orginaltext";
$pgv_lang["message_to_edit"]			= "Meddelande att redigera";
$pgv_lang["changed_message"]			= "Ändrat innehåll";
$pgv_lang["message_empty_warning"]		= "-> Varning!!! Detta meddelande är tomt i #LANGUAGE_FILE#<-";
$pgv_lang["language_to_export"]			= "Språk att exportera";
$pgv_lang["export_lang_utility"]		= "Exportverktyg för språkfiler";
$pgv_lang["export"]						= "Exportera";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#<br />";
$pgv_lang["export_lang_utility_desc"]	= "Du kan skapa dokumentation för administratörer.<br /><br />Detta verktyg kommer att producera en HTML-version av konfigurationshjälpfiler i det valda språket. Du kan använda din webläsare för att titta på dessa filer, vilka är formaterade för utskrift.";
$pgv_lang["export_ok"]					= "Hjälpmeddelandena är exporterade.";
$pgv_lang["compare_lang_utility"]		= "Jämförelseverktyg för språkfiler";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#<br />";
$pgv_lang["compare_lang_utility_desc"]	= "Detta verktyg jämför två olika språkfiler för att visa tillagda och borttagna meddelande mellan dem.<br /><br />Läs också filen <a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a> för att få reda på ändringar i den engelska versionen. Den engelska filen bör användas som referens efter vilka de andra filerna skapas.";
$pgv_lang["new_language"]				= "Nytt språk";
$pgv_lang["old_language"]				= "Gammalt språk";
$pgv_lang["compare"]					= "Jämför";
$pgv_lang["comparing"]					= "Språkfiler som jämförs";
$pgv_lang["additions"]					= "Tillägg";
$pgv_lang["no_additions"]				= "Inga Tillägg";
$pgv_lang["subtractions"]				= "Borttagna";
$pgv_lang["no_subtractions"]			= "Inget borttaget";
$pgv_lang["config_lang_utility"]		= "Konfiguration av stödda språk";
$pgv_lang["config_lang_utility_help"]	= "Detta verktyg hjälper dig att editera de språkspecifika inställningar som används inuti PhpGedView.<br /><br />Observera att om du ändrar ursrpunginställningarna för ett språk i PhpGedView kommer en ny fil <b>lang_settings.php</b> att skapas i #INDEX_DIRECTORY#-katalogen.<br />Alla framtida ändringar kommer att göras i denna fil och PhpGedView kommer endast att använda <u>denna</u> fil.<br />Du kan återgå till standardinställningar genom att radera denna fil.<br /><br />Så om du har problem med språkinställningarna var snäll och rapportera att du har denna nya fil eller inte.";
$pgv_lang["active"]						= "Aktiverad";
$pgv_lang["active_help"]				= "~#pgv_lang[active]#~<br /><br />Tillåt användare att välja detta språk om <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> är påslaget.";
$pgv_lang["edit_settings"]				= "Ändra inställningar";
$pgv_lang["lang_edit"]					= "Ändra";
$pgv_lang["lang_language"]				= "Språk";
$pgv_lang["export_filename"]			= "Namn på filen som innehåller den exporterade datan:";
$pgv_lang["lang_back"]					= "Tillbaka till huvudmenyn för editering och konfigurering av språkfiler";
$pgv_lang["lang_back_admin"]			= "Tillbaka till administratörsmenyn";
$pgv_lang["lang_back_manage_gedcoms"]	= "Tillbaka till GEDCOM-administrationsmenyn";
$pgv_lang["lang_name_czech"]			= "Tjeckiska";
$pgv_lang["lang_name_chinese"]			= "Kinesiska";
$pgv_lang["lang_name_danish"]			= "Danska";
$pgv_lang["lang_name_dutch"]			= "Holländska";
$pgv_lang["lang_name_english"]			= "Engelska";
$pgv_lang["lang_name_finnish"]			= "Finska";
$pgv_lang["lang_name_french"]			= "Franska";
$pgv_lang["lang_name_german"]			= "Tyska";
$pgv_lang["lang_name_hebrew"]			= "Hebreiska";
$pgv_lang["lang_name_hungarian"]		= "Ungerska";
$pgv_lang["lang_name_italian"]			= "Italienska";
$pgv_lang["lang_name_norwegian"]		= "Norska";
$pgv_lang["lang_name_polish"]			= "Polska";
$pgv_lang["lang_name_portuguese"]		= "Portugisiska";
$pgv_lang["lang_name_portuguese-br"]	= "Portugisiska (Brasilien)";
$pgv_lang["lang_name_russian"]			= "Ryska";
$pgv_lang["lang_name_spanish"]			= "Spanska";
$pgv_lang["lang_name_spanish-ar"]		= "Spanska (Latinamerika)";
$pgv_lang["lang_name_swedish"]			= "Svenska";
$pgv_lang["lang_name_turkish"]			= "Turkiska";
$pgv_lang["lang_name_greek"]			= "Grekiska";
$pgv_lang["lang_name_arabic"]			= "Arabiska";
$pgv_lang["lang_name_lithuanian"]	= "Litauiska";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamesiska";
$pgv_lang["lang_name_slovak"]		= "Slovakiska";
$pgv_lang["lang_new_language"]			= "Nytt språk";
$pgv_lang["original_lang_name"]			= "Ursprungligt namn på språket i #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "Vad kallas språket på sitt eget språk?<br /><br />Engelska kallas på Engelska: <b>English</b>; Tyska kallas på Tyska: <b>Deutsch</b>; Holländska kallas på Holländska: <b>Nederlands</b>; Tjeckien kallas på tjekiska <b>Ceština</b> osv.";
$pgv_lang["lang_shortcut"]				= "Genväg för språkfiler";
$pgv_lang["lang_shortcut_help"]			= "Denna kod definierar en förkortning för språkets namn. Förkortningen utgör en del av varje språkfils namn i PhpGedView. T.ex. förkortningen för franka är <b>fr</b>, alltså är filnamnen för franska <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i> och <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]				= "Språkigenkänningskoder";
$pgv_lang["lang_langcode_help"]			= "Dessa koder gör att PhpGedView kan känna igen språkinställningen i webläsaren som användaren använder för att se på dina PhpGedView sidor. Listans värde måste vara separerade med \";\"";
$pgv_lang["lang_filenames"]				= "Språkfiler";
$pgv_lang["lang_filenames_help"]		= "PhpGedView har implementerat support för många olika språk. Det har möjliggjorts av att alla synlig text har sparats separat från huvudprogrammet. Det finns fem filer för varje stött språk och de olika texterna har delats upp efter dess funktion. När en text inte finns översatt än kommer PhpGedView att använda den engelska texten.<br /><br />Filerna i varje språk är:<br /><ul><li><b><i>configure_help.xx.php</i></b> Denna fil innehåller termer, vanliga uttryck och hjälptexter som används för konfiguration av PhpGedView. Hjälptexten är inte tänkt att visas för vanliga användare.</li><br /><li><b><i>countries.xx.php</i></b> Detta är en lista av länder tagen från websidan för statistik, FNs organ för ekonomi och sociala frågor. Detta är den relevanta <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=_blank><b>länken</b></a> till denna engelska listan. Listan finns tillgänglig på engelska och franska. </li><br /><li><b><i>facts.xx.php</i></b> Denna fil innehåller texten för GEDCOM-taggarna enligt GEDCOM 5.5.1 standarden. Den innehåller också extra taggar som inte finns i standarden men som används av olika släktforskningsprogram.En engelsk kopia av <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank><b>GEDCOM 5.5.1 standarden</b></a> kan laddas ner som pdf. </li><br /><li><b><i>help_text.xx.php</i></b> Denna fil inehåller hjälptexten för den vanliga användaren. Vissa hjälptexter riktar sig till administratörer och är dolda från användare som inte har administratörsrättighter.</li><br /><li><b><i>lang.xx.php</i></b> Många termer och vanliga uttryck finns i denna fil.</li></ul>";
$pgv_lang["flagsfile"]					= "Flaggfilens namn";
$pgv_lang["flagsfile_help"]				= "Namn och sökväg till den nationella flaggan för det valda språket.";
$pgv_lang["text_direction"]				= "Textorientering";
$pgv_lang["text_direction_help"]		= "Definierar från vilket håll texten skrivs i det valda språket. Normalt så skrivs alla västerländska språk från vänster till höger om de läser eller skriver text.<br />Men det finns språk som arabiska och hebreiska som använder höger till vänster istället för vänster till höger.";
$pgv_lang["date_format_help"]			= "Detta fält definierar datumformatet som normalt används i släktforskningsarbete på det valda språket.<ul><li><b>Standardformat</b><br />Variabler som du kan använda är:<br /><b>D</b> för dag<br /><b>M</b> för månad<br /><b>Y</b> för år<br /><br />Du kan ändra ordningen för dessa variabler och också lägga till avskiljar tecken.<br /><br />Standardinställningen för denna variabel är 'D M Y' som betyder att datumet som ser ut som <b>DATE 20 NOV 1965</b> visas inuti PhpGedView som <b>20 november 1965</b>.<br /><br />Tex. i Tyskland sr fältet ut så här <b>D. M Y</b> Vilket betyder att datumet ovan visas på tyska <b>20. November 1965</b>.<br /><br />Ett annat exempel är det Ungerska språket som definierar språket som <b>Y. M D.</b> och datumet ovan visas som <b>1965. November 20.</b> inuti PhpGedView (om namnet på den 11 månaden varit November på Ungerska).<br />Ytterligare ett exempel är finska vars datumformat ser ut som <b>D. M#ta# Y</b>. Detta innebär att alla datumangivelser i GEDCOM-filen med både dag och maånad kommer att visas som '20. Novemberta 1965' på finska (om namnet på den 11 månaden varit November på finska).</li><br /><li><b>2. Alternativa sätt att visa veckodag</b><br />För att visa dag i veckan även för riktigt gamla datum, använd:<br /><b>d</b> - Dag i månaden, två siffor med inledande nollor, t.ex. <b>01</b> till <b>31</b><br /><b>D</b> - Dag i vecka, text, 3 bokstäver t.ex. <b>Fre</b><br /><b>F</b> - Månad, text, långt format t.ex <b>Januari</b><br /><b>j</b> - Dag i månad utan inledande nollor, t.ex <b>1</b> till <b>31</b><br /><b>l</b>(litet L) - veckodag, text, lång t.ex. <b>Fredag</b><br /><b>M</b> - Månad, text, 3 bokstäver t.ex. <b>Jan</b><br /><b>Y</b> - År, 4 siffor t.ex. <b>1999</b><br /><b>y</b> - År, 2 siffor t.ex. <b>99</b><br /><b>DjFY</b> skulle ge resultatet <b>Tor 9 Januari 1806</b>medan koden <b>idMY</b> skulle ge <b>Torsdag 09 Jan 1806</b></li></ul>";
$pgv_lang["time_format"]				= "Tidsformat";
$pgv_lang["time_format_help"]			= "Detta fält definierar tidsformatet i det valda språket.<br /><br />Variabler du kan använda är:<br /><b>a</b> - Små bokstäver <b>am</b> och <b>pm</b><br /><b>A</b> - Stora bokstäver <b>AM</b> och <b>PM</b><br /><b>B</b> - Swatch internettid 000 till 999<br /><b>c</b> - ISO 8601 datum(tillagd i php5) <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - Dag i månad 2 siffror med inledande nollor <b>01</b> till <b>31</b><br /><b>D</b> - En textrepresentation av en dag, tre bokstäver <b>Mån</b> till <b>Sön</b><br /><b>F</b> - En full textrepresentation av en månad, som <b>januari</b><br /><b>g</b> - 12 timmarsformat av timmar utan inledande nollor <b>1</b> till <b>12</b><br /><b>G</b> - 24 timmarsformat av timmar utan inledande nollor, <b>0</b> till <b>23</b><br /><b>h</b> - 12 timmarsformat av timmar med inledande nollor <b>01</b> till <b>12</b><br /><b>H</b> - 24 timmarsformat av timmar med inledande nollor, <b>00</b> till <b>23</b><br /><b>i</b> - Minuter med inledande nollor, <b>00</b> till <b>59</b><br /><b>I</b> - (stort i) <b>1</b> om sommartid används, <b>0</b> annars.<br /><b>j</b> - Dag i månad utan inledande nollor, <b>1</b> till <b>31</b><br /><b>l</b> - (litet 'L')En full textrepresentation av veckodag, <b>söndag</b> till <b>lördag</b><br /><b>L</b> - Om det är skottår, <b>1</b> det är <b>0</b> annars.<br /><b>m</b> - Numerisk representation av månad, med inledande nollor <b>01</b> till <b>12</b><br /><b>M</b> - En kort textrepresentation av månad, tre bokstäver <b>Jan</b> till <b>dec</b><br /><b>n</b> - Numerisk representation av månad utan inledande nollor <b>1</b> till <b>12</b><br /><b>O</b> - Skillnad mot Greenwitch tid(GMT) i timmar t.ex. <b>+0200</b><br /><b>r</b> - RFC 2822 formaterat datum t.ex. <b>Tor, 21 dec 2000 16:01:07 +0200</b><br /><b>s</b> - sekunder med inledande nollor <b>00</b> till <b>59</b><br /><b>S</b> - Engelsk ändelse för dag i månad, 2 bokstäver <b>st, nd, rd eller th</b>. Fungerar bra med <b>j</b><br /><b>t</b> - antal dagar i en månad <b>28</b> till <b>31</b><br /><b>T</b> - Tidszon inställning för denna maskin. t.ex. <b>CEST</b>, <b>EST</b>, <b>MDT</b> ...<br /><b>U</b> - Sekunder sedan Unix epoken (Januari 1 1970 00:00:00 GMT)<br /><b>w</b> - Numersik reprenstation av veckodag <b>0</b>(för söndad) till <b>6</b>(för lördag)<br /><b>W</b> - ISO-8601 Veckonummer för året, veckor startar med <b>måndag</b>(tillagd i php 4.1.0) T.ex. <b>42</b> (42 andra veckan på året)<br /><b>Y</b> - En full numerisk representation av år, 4 siffror: t.ex. <b>1999</b> eller <b>2003</b><br /><b>y</b> - En två siffrors reprenstation av år t.ex: <b>99</b> eller <b>03</b><br /><b>z</b> - Dag på året(startar med 0)<b>0</b> till <b>365</b><br /><b>Z</b> - Tidszonoffset i sekunder. Offset för tidszon väster om UTC är alltid negativ och för de öster om UTC är alltid positiv. <b>-43200</b> till <b>43200</b><br /><br />Du kan ändra ordningen för dessa variabler och också lägga till avgränsningstecken imellan.<br />Tillexempel i Tyskland har detta fält innehållet <b>H:i:s</b> vilker ger ett resultatet: <b>09:01:25</b>.<br />I England är standarddefinitionen för fältet <b>g:i:sa</b> vilket ger <b>9:01:25am</b>.<br /><br />I ett 24 timmarssystem är midnatt 00:00. I ett 12 timmarssystem är midnatt 12:00 am och middag är 12:00pm.";
$pgv_lang["week_start"]					= "Veckan startar på";
$pgv_lang["week_start_help"]			= "Veckodagen som veckan startar på i detta språk. I Sverige räknar vi vanligen måndag som första veckodagen.";
$pgv_lang["name_reverse"]				= "Efternamn först";
$pgv_lang["name_reverse_help"]			= "På några språk skall efternamnet visas först istället för standardinställningen att visa det sist. Om du aktiverar detta val kommer efternamnet att visas först.";
$pgv_lang["ltr"]						= "Från vänster till höger";
$pgv_lang["rtl"]						= "Från höger till vänster";
$pgv_lang["file_does_not_exist"]		= "Fel! Filen finns inte...";
$pgv_lang["alphabet_upper"]				= "Stora bokstäver";
$pgv_lang["alphabet_upper_help"]		= "Stora bokstäver i detta språk. Detta alfabet används för sortering av namn med stora bokstäver i namnlistorna.";
$pgv_lang["alphabet_lower"]				= "Små bokstäver";
$pgv_lang["alphabet_lower_help"]		= "Små bokstäver i detta språk. Detta alfabet används för sortering av små bokstäver i namnlistorna.";
$pgv_lang["multi_letter_alphabet"]		= "Mångbokstavsalfabet";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Mångbokstavskombinationer som ska behandlas som en distinkt bokstav vid sortering av namn och titellistor i detta språk.<br /><br />Vissa språk som ungerska och slovakiska t.ex. hanterar vissa bokstavskombinationer som en enskilda bokstav. Ordningen som du specificerar dessa boksavskombinationer bestämmer ordningen som de får i det normala alfabetet vid sortering. Detta är viktigt när flera mångbokstavskombinationer har samma första bokstav. Förutom <b>ch</b>, kommer dessa kombinationer att sättas in i det normala alfabetet efter den dess förstabokstav. <b>ch</b> sätts alltid in efter <b>h</b>.<br />";
$pgv_lang["dictionary_sort"]		= "Använd uppslagsverksregler för sortering";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Detta val kontrollerar hur bokstäver med diakritiskt tecken hanteras vis sortering av namn och titellistor.<br /><br />När det är satt till <b>#pgv_lang[yes]#</b>, behandlas alla diakritiska tecken som om de inte hade några markeringar. De tas bara hänsyn till diakritiska tecken om två ord för övrigt är helt identiska. När valet är satt till <b>#pgv_lang[no]#</b>, behandlas alla tecken som distinkta tecken oavsett om de har några diakritiska tecken eller inte.<br />";
$pgv_lang["lang_config_write_error"]	= "Fel vid skrivning av inställningar i språkfilen <b>lang_settings.php</b>. Kontrollera skrivrättighter och försök igen.";
$pgv_lang["translation_forum"]			= "Länk till PhpGedViews översättningsforum på SourceForge";
$pgv_lang["translation_forum_help"]		= "Denna <a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=_blank><b>länk</b></a> öppnar en ny webläsare. Du kommer att vidarbefodras till översättningsforumet för PhpGedView, där kan du diskutera översättningsspecifika problem.";
$pgv_lang["translation_forum_desc"]		= "Denna <a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=_blank><b>länk</b></a> öppnar ett nytt webläsarfönster. Du kommer att flyttas till översättarforumet för PhpGedView, där kan du diskutera översättningsämne.";
$pgv_lang["system_time"]				= "Nuvarande systemtid:";
$pgv_lang["gedcom_not_imported"]		= "Denna GEDCOM har inte blivit importerad ännu.";
$pgv_lang["lang_set_file_read_error"]	= "Fel! Kan inte läsa <b>language_settings.php</b>!";
$pgv_lang["add_new_language"]			= "Lägg till filer och inställningar för ett nytt språk";
$pgv_lang["add_new_language_help"]		= "Du kan använda detta verktys för att lägga till ett nytt språk som inte redan stöds av PhpGedView.<br /><br />Var vänlig och fyll i alla fält i nästa fönster. Efter att du skapat de nya filerna kommer du att kunna ändra meddelandena för det nya språket.";
$pgv_lang["add_new_language_desc"]	= "Denna funktion låter dig lägga till ett nytt, ej tidigare tillgängligt språk till PhpGedView.<br /><br />Du kan ställa in standardinställningarna för det nya språket. Dessa inkluderar språkigenkänningskoder, skrivriktining, veckodag veckan startar på i detta språk, tidsinställningar, alfabet, etc.<br /><br />Du kommer att få mer hjälp för inställningarna som stöds av PhpGedView efter att du valt språk och klickat på  <b>#pgv_lang[add_new_lang_button]#</b>-knappen.<br /><br />Mer hjälp finns tillgänglig på konfigurationssidan för språket.<br />";
$pgv_lang["add_new_lang_button"]		= "Lägg till nytt språk";
$pgv_lang["hide_translated"]			= "Göm översatta texter";
$pgv_lang["lang_file_write_error"]	= "FEL !!!<br /><br />Kan inte skriva till den valda språkfilen!<br />Kontrollera skrivrättigheter för <b>#lang_filename#</b>";
$pgv_lang["no_open"]				= "FEL !!!<br /><br />Kan inte öppna filen #lang_filename#";
$pgv_lang["never"]					= "Aldrig";
$pgv_lang["users_total"]			= "Totalt antal användare";
$pgv_lang["users_admin"]			= "Sajtadministratörer";
$pgv_lang["users_unver"]			= "Overifierad av användaren";
$pgv_lang["users_unver_admin"]		= "Overifierad av administratören";
$pgv_lang["users_langs"]			= "Användarnas språk";
$pgv_lang["warn_users"]				= "Användare med varningar";
$pgv_lang["users_gedadmin"]			= "GEDCOM-administratörer";
$pgv_lang["cleanup_users"]			= "Rensa bland användare";
$pgv_lang["usr_no_cleanup"]			= "Inget hittades som behövdes rensas bort";
$pgv_lang["back_useradmin"]			= "Tillbaka till användaradministration";
$pgv_lang["del_proceed"]			= "Fortsätt";
$pgv_lang["del_unveru"]				= "Användaren verifierade inte sig själv inom 7 dagar.";
$pgv_lang["del_unvera"]				= "Användaren är inte verifierad av administratören.";
$pgv_lang["del_gedrights"]			= "GEDCOM är inte längre aktiv, tabort användarreferenser.";
$pgv_lang["usr_idle"]				= "Antal månader sedan den senaste inloggningen för att användarkonto ska räknas som inaktivt: ";
$pgv_lang["usr_idle_toolong"]		= "Användarkonto som varit inaktivt för länge: ";
$pgv_lang["usr_unset_rights"]		= "Lösgör GEDCOM-rättigheter för ";
$pgv_lang["usr_unset_rootid"]		= "Lösgör root-id för ";
$pgv_lang["usr_unset_gedcomid"]		= "Lösgör GEDCOM-Id för ";
$pgv_lang["usr_deleted"]			= "Radera användare: ";
$pgv_lang["configured_languages"]	= "Språk som används";
$pgv_lang["message_to_all"]			= "Skicka meddelande till alla användare";
$pgv_lang["ip_address"]				= "IP-adress";
$pgv_lang["date_time"]				= "Datum och tid";
$pgv_lang["message"]				= "Meddelande";
$pgv_lang["searchtype"]				= "Sökningstyp";
$pgv_lang["type"]					= "Typ";
$pgv_lang["query"]					= "Fråga";
$pgv_lang["um_header"] 				= "Migreringsverktyg för användarinformationen";
$pgv_lang["um_proceed"] 			= "Välj ett val eller klicka på länken nedan för att återvända till adminstrationsmenyn<br /><br />";
$pgv_lang["um_creating"] 			= "Skapa";
$pgv_lang["um_sql_index"] 			= "Detta verktyg kommer att skapa en <i>authenticate.php</i> och flera <i>.dat</i>-filer i din indexmapp.<br /><br />Efter en lyckad skapning av filerna kan du byta till indexmod med alla nuvarande användare och deras meddelande, favoriter, nyheter och min Gedview layouten tillgänglig.<br /><br />Obs: Efter byte till indexmod måste du importera dina GEDCOM-filer igen.<br /><br />";
$pgv_lang["um_file_create_fail1"] 	= "Skapandet av en ny fil misslyckades, en fil med det namnet finns redan:";
$pgv_lang["um_file_create_fail2"] 	= "Kan inte skapa en fil";
$pgv_lang["um_file_create_fail3"] 	= "Kontrollera accessrättigheter för mappen.";
$pgv_lang["um_file_create_succ1"] 	= "Skapandet av den nya filen lyckades:";
$pgv_lang["um_file_not_created"] 	= "Filen skapades inte.";
$pgv_lang["um_nomsg"] 			= "Det finns inga meddelande i systemet.";
$pgv_lang["um_nofav"] 			= "Det finns inga favoriter i systemet.";
$pgv_lang["um_nonews"] 			= "Det finns inga nyheter i systemet.";
$pgv_lang["um_noblocks"] 		= "Det finns inga områden i systemet.";
$pgv_lang["um_index_sql"] 		= "Detta verktyg kommer att importera <i>authenticate.php</i> och andra <i>.dat</i>-filer ifrån indexmappen till din databas.<br />";
$pgv_lang["um_noaction"] 		= "Ingen åtgärd behövs för att migrera användarinformation till SQLmod.<br /><br />När du har bytat till SQLmod behöver du starta om användarmigrerings verktyget för att importera all data till SQLdatabasen. PhpGedView kommer att använda existerande filer från indexmod.<br /><br /><b>Ta <u>inte</u> bort <i>authenticate.php</i> och <i>.dat</i> filerna från indexmappen när du byter.</b><br />";
$pgv_lang["um_import"] 			= "Importera";
$pgv_lang["um_export"] 			= "Exportera";
$pgv_lang["um_explain"] 		= "Detta verktyg kommer antingen exportera användardata ifrån SQL till indexmod eller importera användardata från indexfiler till SQLtabeller.<br /><br />Användardata, favoriter, blockdefinitioner, meddelande och nyhter kommer att vara tillgängliga efter migrering.<br /><br /><b>VARNING</b><br />Du kan inte använda detta verktyg att migrera användardata mellan olika verioner av PhpGedView.<br /><br /><b>VIKTIGT</b><br />Om du väljer att importera användardata ifrån indexmod, all användardata som redan finns i databasens tabeller kommer att <u>skrivas över</u>. Detta verktyg slår <u>inte</u> ihop informationen. När du kört importen finns det inget sätt att få tillbaka den gamla informationen via PhpGedView.<br /><br /><b>EXPORT</b><br />Om du exporterar användarinformationen ifrån SQLdatabasen till indexmodfiler kommer verktyget att skapa <i>authenticate.php</i> och flera <i>.dat</i>-filer i din indexmapp. Identiska filer som redan finns kommer <b>inte</b> skrivas över. De <u>måste</u> tas bort manuellt. Efter bytet till indexmod kommer all information att vara tillgänglig direkt.<br /><br /><b>Obs</b> Efter du bytat till indexmod måste du importera dina GEDCOM-filer igen.<br /><br />";
$pgv_lang["um_tool_help"] 		= "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] 	= "~Migrera användare från SQL till Index-mod~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] 	= "~Migrera användare från Index till SQL-mod~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] 		= "Importera användare";
$pgv_lang["um_imp_blocks"] 		= "Importera områden";
$pgv_lang["um_imp_favorites"] 	= "Importera favoriter";
$pgv_lang["um_imp_messages"] 	= "Importera meddelanden";
$pgv_lang["um_imp_news"] 		= "Importera nyheter";
$pgv_lang["um_nousers"] 		= "Filen <i>authenticate.php</i> hittades inte i indexmappen. Migrationen avbröts.";
$pgv_lang["um_imp_succ"] 		= "Import lyckades";
$pgv_lang["um_imp_fail"] 		= "Import misslyckades";
$pgv_lang["um_backup"] 			= "Backup";
$pgv_lang["um_zip_succ"] 		= "ZIP-filen spades korrekt.";
$pgv_lang["um_zip_dl"] 			= "Ladda ner ZIPad Backupfil ";
$pgv_lang["um_bu_explain"] 		= "Detta verktyg kan skapa backup för flera typer av data från PhpGedView.<br /><br />Datan du väljer att göra backup av kommer att samlas i en ZIP-fil, som du kan ladda ner genom att klicka på länken längst ner på sidan efter bakupen har lyckats.<br /><br />ZIP-filen kommer att bli kvar i indexmappen till den tas bort manuellt.";
$pgv_lang["um_bu_help"] 		= "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] 		= "PhpGedView konfigurationsfil";
$pgv_lang["um_bu_gedcoms"] 		= "GEDCOM-filer";
$pgv_lang["um_bu_gedsets"] 		= "GEDCOM-inställningar, konfiguration och integritetsfiler";
$pgv_lang["um_bu_logs"]			= "GEDCOM-räknare, sökloggar och PhpGedView-logfiler";
$pgv_lang["um_bu_usinfo"] 		= "Användardefinitioner, områdesinställning, favoriter, meddelande, nyheter";
$pgv_lang["um_mk_bu"] 			= "Gör backup";
$pgv_lang["um_nofiles"] 		= "Inga filer hittades för att göra backup";
$pgv_lang["um_files_exist"] 	= "En eller flera filer finns redan. Vill du skriva över dem?";
$pgv_lang["um_results"]		= "Resultat";
$pgv_lang["preview_faq_item"] = "Förhadsgranska alla FAQ-poster";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br />Detta val låter en administratör attse FAQ-sidan utan alla edeteringsval och länkar.<br /><br />Förutom en <b>Redigera</b>-länk ovanför den första FAQ-posten, utseendet kommer att vara identiskt som en vanlig användare ser. Den speciella <b>Redigera</b>-länken kommer att återställa full redigeringsfunktionallitet till FAQ-sidan.<br />";
$pgv_lang["restore_faq_edits"] = "Återställ FAQ redigeringsfunktionallitet";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br />Detta val återställer FAQ-sidan till vad en administratör vanligen ser, så att individuella FAQ-poster kan redigeras.<br />";
$pgv_lang["add_faq_item"] = "Lägg till FAQ-post";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br />Detta val låter dig lägga till en post till FAQ-sidan.<br />";
$pgv_lang["edit_faq_item"] = "Redigera FAQ-post";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br />Detta val låter dig redigera en post på FAQ-sida.<br />";
$pgv_lang["delete_faq_item"] = "Radera FAQ-post";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br />Detta val låter dig radera en post från FAQ-sidan.<br />";
$pgv_lang["moveup_faq_item"] = "Flytta FAQ-post uppåt";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br />Detta val låter dig flytta upp en post på FAQ-sidan.<br /><br />Varje gång du använder detta val kommer FAQ-positionsnummret att minskas med ett. Du kan uppnå samma resultat genom att editera posten manuellt och ändra FAQ-positionsfältet. När mer än en FAQ-post har samma positionsnummer kommer bara en av posterna att vara synlig.<br />";
$pgv_lang["movedown_faq_item"] = "Flytta FAQ-post nedåt";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br />Detta val låter dig flytta ner en post på FAQ-sidan.<br /><br />Varje gång du använder detta val kommer FAQ-positionsnummret att ökas med ett. Du kan uppnå samma resultat genom att editera posten manuellt och ändra FAQ-positionsfältet. När mer än en FAQ-post har samma positionsnummer kommer bara en av posterna att vara synlig.<br />";
$pgv_lang["add_faq_header_help"] = "~FAQ Rubrik~<br />Detta är rubriken eller ämnet för FAQ-posten.<br /><br />Det som skrivs in här kan formateras, HTML-taggar som <b> och <br> är tillåtna tillsammans med &amp; och &nbsp;. Det finns ingen möjlighet att skriva in HTML-taggar så att de tolkas som text.<br />";
$pgv_lang["add_faq_body_help"] = "~FAQ Text~<br />Texten för FAQ-texten skrivs in här.<br /><br />Texten kan formateras, HTML-taggar som <b> och <br> är tillåtna, även HTML enheter som &amp; och &nbsp;. Det finns inget sätt att skriva HTML-taggar så att de tolkas som text.<br />";
$pgv_lang["add_faq_order_help"] = "~FAQ Position~<br />Detta fält bestämmer vilken ordning FAQ-poster visar.<br /><br />Du behöver inte fylla in nummrena i ordning. Om du lämnar hål i nummersekvensen kan du lägga in nya poster senare. T.ex om du använder siffrorna 1, 6, 11, 16 kan du senare lägga in poster med de saknade sifforna. Negativa siffror och noll är tillåtna och kan användas för att sätta in psoter före den första posten.<br /><br />När mer en post har samma nummer kommer bara en post att vara synlig.<br />";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Den maximala tiden importering är tillåten att köra för att processa GEDCOM-filen.";
$pgv_lang["media_import_help"] = "~#pgv_lang[media_import]#~<br />Denna import kommer att konvertera dina multimedialänkar till i din GEDCOM-fil till multimediaobjekt. T.ex. följande mediapost kommer att ändras från:<blockquote><code>1 OBJE<br />2 FORM jpg<br />2 FILE media/farmor.jpg<br />2 TITL bild av farmor</code></blockquote>till:<blockquote><code>0 @M1@ OBJE<br />1 FORM jpg<br />1 FILE media/farmor.jpg<br />1 TITL bild av farmor</code></blockquote>Den nya multimediaposten kommer att sparas separat i i databasen. Länkar till externa multimediafiler kommer att ändras till refernser till den nya multimediaposten som i sin tur kommer att innehålla en referens till den externa filen. T.ex. kommer följande GEDCOM-post att ändras från:<blockquote><code>0 @I1@ INDI<br />1 NAME Ditt/Namn/<br />1 OBJE<br />2 FORM jpg<br />2 FILE media/farmor.jpg<br />2 TITL Bild av farmor</code></blockquote>till:<blockquote><code>0 @I1@ INDI<br />1 NAME Ditt/Namn/<br />1 OBJE @M1@<br /></code></blockquote>Fördelen med att använda multimediaposter är att du kan lätt administrera dina mediafiler. När du ändrar titel på en multimediapost så kommer titeln att ändras för alla GEDCOM.poster som länkar till multimediaposten. Flera personer, familjer eller källor kan länkas till samma multimediapost.";


$pgv_lang["CHART_BOX_TAGS"]				= "Andra fakta att visa i tavlorna";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Detta skall vara en komma eller mellanslags-separerad lista av fakta förutom födelse och död som du vill ska visas i tavelboxaren i t.ex. antavlan. Denna lista kräver att du använder faktataggar från GEDCOM 5.5.1 standarden. T.ex. om du vill att yrke ska visas i boxen så ska du lägga till \"OCCU\" till detta fält. Detta sätter \$CHART_BOX_TAGS variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_SURNAME_KEYWORDS"]		= "Lägg till de vanligaste efternamnen till nyckelorden i META-fältet";
$pgv_lang["META_SURNAME_KEYWORDS_help"]	= "~#pgv_lang[META_SURNAME_KEYWORDS]#~<br /><br />När detta val är satt till <b>Ja</b> kommer efternamnen från de #pgv_lang[common_surnames]# att läggas till till meta nyckelordsfältet. Detta kan hjälpa sökmotorer att lättare hitta din sida.<br /><br />Detta sätter \$META_SURNAME_KEYWORDS variablen i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SHOW_QUICK_RESN"]			= "Visa integritetsfälten i #pgv_lang[quick_update_title]#-formen";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Detta låter dig sätta på eller stänga av intgritetsfältet i #pgv_lang[quick_update_title]#-formuläret. Integritetsfälten tillåter användare som lägger till information via formuläret för att ändra på standard-integritets för fakta som skrivs in. Detta sätter \$SHOW_QUICK_RESN variabler i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["USE_QUICK_UPDATE"]			= "Använd #pgv_lang[quick_update_title]#-formuläret";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Detta låter inloggade användare skriva in ändringar genom #pgv_lang[quick_update_title]#-formuläret. Detta sätter \$USE_QUICK_UPDATE variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SEARCHLOG_CREATE"]			= "Arkivera sökningsloggfiler";
$pgv_lang["SEARCHLOG_CREATE_help"]		= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Hur ofta ska programmet arkivera sökningloggfilerna.<br /><br />Detta sätter \$SEARCHLOG_CREATE variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["CHANGELOG_CREATE"]		= "Arkivera ändringslogfiler";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Hur ofta ska programmet arkivera ändringslogfilerna.<br /><br />Detta sätter \$CHANGELOG_CREATE i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Standardflik att visa på ansedelsidan";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Detta val tillåter dig att välja vilken flik på ansedelsidan som ska visas när en besökare för första gåmgen kommer till sidan. Detta sätter \$GEDCOM_DEFAULT_TAB variablen i filen config_gedcom.php<br />";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Visa vigselnamn i personlistan";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Detta val visar vigselnamn för kvinnor i personlistan. Detta val kräver att du beräknar vigselnamn när du importerar GEDCOM-filen. Detta sätter \$SHOW_MARRIED_NAMES variabeln i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Understryk namn omgivna av citattecken";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Många program placerar tilltalsnamnet inom citattecken i GEDCOM-filen. Språkkonventioner för detta är att understryka det använda förnamnet. Om du sätter på detta val kommer alla namn omgivna av citattecken till <span> med css-klassen \"starredname\".<br /><br />T.ex. om namnet i GEDCOM-filen är 1 NAME Gustave \"Jean Paul\" Charles /Wilson/ om man sätter på detta valet så skrivs namnet ut som Gustave <span class=\"starredname\">Jean Paul</span> Charles Wilson.<br /><br />Detta sätter \$UNDERLINE_NAME_QUOTES variablen i <i><u>xxx</u>.GED>conf.php</i>.<br />";
$pgv_lang["PRIVACY_BY_RESN"]			= "Använd GEDCOM (RESN) integritetsrestriktioner";
$pgv_lang["PRIVACY_BY_RESN_help"]		= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />GEDCOM 5.5 specifikationen inkluderar valet att använda RESN taggar för att sätta integritetsval för personer och fakta i GEDCOM-filen. Sätta på detta val berättar för programmet att det ska titta efter nivå 1 RESN taggar i GEDCOM-posterna. Nivå 2+ RESN taggar läggs automatiskt till och berörs inte av denna inställning. Tänk på att denna inställning kan försämra hastigheten för vissa funktioner i PGV som t.ex. personlistan.<br /><br />Detta sätter \$PRIVACY_BY_RESN variabeln i <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Visa LDS förordningskoder i tavelboxarna";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Sätta detta val till <b>Ja</b> kommer att visa koderna för LDS förordningarna i tavleboxerna.<ul><li><b>B</b> - Dop</li><li><b>E</b> - Donation</li><li><b>S</b> - Försegling till make/a</li><li><b>P</b> Försegling med föräldrar</li></ul>Så en person som har fullgjort alla förordningar kommer att ha <b>BESP</b> utskrivet efter sitt namn. Om någon av förordningarna fattas kommer koderna att se ut så här <b>BE__</b> med ett _ för den missade förordningen.<br /><br />Detta sätter variabeln \$SHOW_LDS_AT_GLANCE i<i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"]		= "Kräver att en administratör godkänner nya användarregistreringar ";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Om valet att <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> är satt, då bestämmer denna inställning om administratören måste godkänna registreringar. Om du sätter denna inställning till <b>Ja</b> måste administratören godkänna alla nya registreringar efter att användaren verifierat sig innan de kan logga in. Satt till <b>Nej</b>, kommer <b>#pgv_lang[verified_by_admin]#</b>-rutan att automatiskt sättas när de verifierat sitt konto, vilket gör att användaren kan logga in direkt efter att de verifierat sig utan administratörens inblandning.<br /><br />Detta sätter \$REQUIRE_ADMIN_AUTH_REGISTRATION variabeln i <i>config.php-filen</i>.<br />";
$pgv_lang["SPLIT_PLACES"]				= "Dela upp ortnamn i redigeringsmod";
$pgv_lang["SPLIT_PLACES_help"]			= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Om du sätter den till <b>Ja</b> kommer du att splittra upp ortnamnen med komma till underfält för lättare redigering. Exempel:<br /><ol><li>Standardmod<br /><u>Ort</u>: Half moon Bay, San Mateo, California, USA<br /><li>Delatmod<br /><u>Land</u>:USA<br /><u>Stat</u>:Kalifornien<br /><u>Län</u>:San Mateo<br /><u>Stad</u>:Half Moon Bay</ol>";
$pgv_lang["ALLOW_REMEMBER_ME"]			= "Visa <b>Kom ihåg mej</b> val på inloggningssidan";
$pgv_lang["ALLOW_REMEMBER_ME_help"]		= "~#pgv_lang[ALLOW_REMEMBER_ME]#~<br /><br />Många sajter tillåter användare att bli ihågkommna ifrån samma dator nästa gång de besöker denna sajt. Om du sätter på detta val kommer det att finnas en <b>Kom ihåg mig</b>-ruta\" på inloggningssidan. Klicka i denna ruta kommer att spara en cookie i användarens webläsare så att de blir ihåg kommna.<br /><br />Detta sätter \$ALLOW_REMEMBER_ME variablen i filen <i>config.php</i>.<br />";
$pgv_lang["SHOW_SOURCES"]				= "Visa källor";
$pgv_lang["SHOW_SOURCES_help"]			= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Sätt integritetsaccessnivå för alla källor. Om användaren inte har access till källor, käll-listorna kommer att tas bort ifrån listmenyn och källfliken kommer inte att visas på ansedelsidan.<br />";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Denna sida ger uttömande information om servern på vilken phpGedView körs. Många konfigurationsdetaljer om serverns mjukvara, som berör PHP och phpGedView kan kontrolleras.<br />";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Denna sida samlar ihop alla huvudämnena för konfigurationshjälp på samma ställe. Du kan se informationen på din skärm eller skriva ut den för att använda senare.<br />";
$pgv_lang["more_config_hjaelp"]			= "<br /><b>Mer hjälp</b><br />Mer hjälp är tillgänglig genom att klicka på <b>?</b> intill artiklarna på sidorna.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Bredden på de genererade miniatyrbilderna";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Detta är bredden (i pixlar) som programmet kommer att använda vid automatisk generering av miniatyrbilderna. Standardinställningen är 100.<br />";

$pgv_lang["new_language_help"]			="#pgv_lang[new_language]#<br /><br />Här kan du välja det språk som du vill ha som källa för att jämföra mot ett annat språk.<br /><br />Alla ändringar görs normalt först i den <b>engelska</b> filen, så du ska normalt välja den engelska här.<br />";
$pgv_lang["old_language_help"]			="#pgv_lang[old_language]#<br /><br />Från denna rullgardinsmeny kan du välja det språk som du vill jämföra mot språket du valde i det <b>Källfils</b> rullgardinsmenyn.<br /><br />Efter att du gjort dina val, klicka på <b>Jämför</b> knappen, du kommer då att få en lista på alla tillagda och borttagna meddelande.<br /><br />För att vara säker:<br /><b>Tillägg</b> betyder: Meddelandet finns i Källfilen men <b>inte</b> i jamförelsefilen.<br /><br /><b>Bortaget</b> betyder: Meddelandet finns <b>inte</b> källfilen, men <b>finns</b> (fortfarande) i jämförelsefilen.";
$pgv_lang["hide_translated_help"]		="#pgv_lang[hide_translated]#<br /><br />Om du sätter inställningen till <b>Ja</b> kommer du endast se de meddelande som inte redan är översatta för det valda språket, vilket betyder meddelanden som <u>inte</u> redan finns i den valda språkfilen.<br /><br />Efter att du lagt till en ny översättning för ett meddelande så kommer inte det meddelandet häller visas mer i listan.<br /><br />";
$pgv_lang["lang_edit_help"]				= "~#pgv_lang[translator_tools]#~<br /><br />På denna sida administreras du dina språkfiler.<br />Du kan översätta, jämföra och exportera språkfiler.<br />Dessutom kan du konfigurera språken som stöds av programmet.<br /><br />Du kan använda följande val och verktyg:";
$pgv_lang["language_to_edit_help"]		="#pgv_lang[language_to_edit]#<br /><br />Från denna rullgardinsmeny kan du välja språket som du vill <b>Redigera</b> meddelandet för.<br /><br />";

$pgv_lang["file_to_edit_help"]			="#pgv_lang[file_to_edit]#<br /><br />PhpGedView har implemeneterat stöd för många olika språk. Detta hat uppnåts genom att ha alla texter som användaren ser i filen helt skillt från huvudprogrammet. Det finns fem filer för varje stött språk och de olika texterna är insorterade i en av dem beroende på språk. Om en text inte är översatt så används den engelska.<br /><br />Filerna i varje språk är:<br />><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Denna fil innehåller termer, vanliga uttryck och hjälptexter som används under konfigurationen. Hjälptexten är inte tänkt att visas för vanliga användare..</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp; Denna fil innehåller en lista av landsnamn tagna från websidan för statestik på ekonmiska och sociala rådet hos FN. Detta är den relevanta <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=_blank><b>länken</b></a> till den engelska listan. Listan är tillgänglig på engelska och franska.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Denna fil innehåller textversionen av faktakoderna i GEDCOM 5.5.1 standarden. Den innehåller också en del specialkoder som inte finns i standarden men som används av olika släktforskarprogramm.<br /><br />En engelsk kopia av <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank><b>GEDCOM 5.5.1 standarden</b></a> kan laddas ner i pdf-format.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp; Denna fil innehåller hjälptexten för vanliga användare. Vissa hjälptexter i denna fil är för administratörer, de är dolda för användare som inte har administratörsrättigheter..</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Många termer och vanliga uttryck finns i denna fil.</li></ul>";
$pgv_lang["language_to_export_help"]	="#pgv_lang[language_to_export]#<br /><br />Från denna rullgardinsmeny kan du välja det språk, från vilket du vill <b>exportera</b> meddelande. Rutinen exporterar bara innehållet i <i>configure_help_text.php</i> filen. Resultat är ett HTML-fil som du kan skriva ut från din webläsare.<br /><br />";

$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Fakta för familjer som alltid ska visas på snabbformuläret";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Detta är ett kommaseparerad lista av GEDCOM-faktataggar som alltid visas på familjefliken på snabbformuläret oavsett om de redan finns eller inte i personposten. T.ex. om MARR är i listan kommer fältet för vigseldatum och vigselplats att alltid visas på formuläret.<br />";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Fakta om familjer att visa på snabbformuläret";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Detta är en kommaseparerad lista av GEDCOM-faktataggar som kommer att visas på familjefliken på snabbformulär. Endast faktan i listan kommer att visas på formuläret eller göras tillgängliga i området där du lägger till nya fakta i formuläret.<br />";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Fakta som alltid visas på snabbformuläret";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Detta är en kommaseparerad lista av GEDCOM-faktataggar som alltid visas på snabbformuläret oavsett om de redan finns i personens post eller inte. T.ex. om BIRT finns i listan kommer fälten för födelsedatum och födelseort kommer att visas på fomruläret.<br />";
$pgv_lang["QUICK_ADD_FACTS"]			= "Fakta att visa på snabbformuläret";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Detta är en kommaseparerad lista av GEDCOM-faktataggar som kommer att visas på snabbformuläret. Endast fakta i listan kommer att visas på formuläret eller göras tillgänglig i området där nya fakta läggs till.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatisk generering av miniatyrbilder";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Ska systemet generera miniatyrbilder automatiskt för bilder som inte har några. Din PHP-installation stöder kanske inte denna funktionalitet.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Media-ID prefix";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />När en ny mediapost läggs till online i PhpGedView, kommer ett nytt id för det mediet att genereras automatiskt, Media-ID kommer att få detta prefix.<br />";
$pgv_lang["FAM_ID_PREFIX"]		= "Familje-ID prefix";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />När en ny familjepost läggs till online i PhpGedView, kommer ett nytt ID för familjen att genereras automatiskt. Familje-IDt kommer att få detta prefix.<br /> ";
$pgv_lang["LANG_SELECTION"] 			= "Stödda språk";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Du kan ändra listan av stödda språk i PhpGedViewsajten genom att lägga till eller tabort kryss efter önskemål. Detta ändrar språkvalen som är tillgängliga för användaren.<br /><br />Du kan åstadkomma samma sak genom  <b>#pgv_lang[enable_disable_lang]#</b>-länken på #pgv_lang[admin]# meny, där kan du också ändra saker som flagikonerna, datumformatet eller om efternamnet alltid ska skrivas först.<br />";
$pgv_lang["DBPERSIST"]					= "Använd fast databaskoppling";
$pgv_lang["DBPERSIST_help"]				= "Bestämmer om PhpGedView ska använda fast databaskoppling när du arbetar med databasen.<br /><br />När du satt den till <b>Ja</b> kan PhpGedView återanvända databaskopplingen därigenom snabba upp kopplingen till databasen. Men, detta kan skapa fel om din server har ett för lågt antal maximala antal kopplingar satt. Om du är osäker på din servers support för fasta kopplingar ska du sätta detta värde till <b>Nej</b>.<br /><br />";
$pgv_lang["INDI_FACTS_ADD"] 			= "Person lägg till fakta";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Detta är en lista av GEDCOM fakta som dina användare kan lägga till till en person. Du kan modifiera denna lista genom att tabort eller lägga till fakta namn, även egna, efter behov. Fakta namn som visas i denna lista får inte också finnas i <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>-listan.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Unika personfakta";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Detta är listan över GEDCOM-fakta som dina användare enbart kan lägga till <u>en gång</u> för personen. T.ex. är Födelse är i denna lista kommer användare enbart att kunna lägga till en födelsepost till personen. Fakta namn som förekommer i denna lista får inte också förekomma i <i>#pgv_lang[INDI_FACTS_ADD]#</i>-listan.<br />";
$pgv_lang["FAM_FACTS_ADD"] 			= "Familj lägg till fakta";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Detta är en lista av GEDCOM fakta som dina användare kan lägga till för en familj. Du kan modifiera denna lista genom att tabort eller lägga till fakta namn, även egna, efter behov. Fakta namn som visas i denna lista får inte också finnas i <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>-listan.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Unika familjefakta";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Detta är en lista av GEDCOM fakta som dina användare kan lägga till endast <u>en gång</u> till en familj. Du kan modifiera denna lista genom att tabort eller lägga till fakta namn, även egna, efter behov. Fakta namn som visas i denna lista får inte också finnas i <i>#pgv_lang[FAM_FACTS_ADD]#</i>-listan.<br />";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Källa lägg till fakta";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Detta är en lista av GEDCOM fakta som dina användare kan lägga till till en källa. Du kan modifiera denna lista genom att tabort eller lägga till fakta namn, även egna, efter behov. Fakta namn som visas i denna lista får inte också finnas i <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>-listan.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Unika källfakta";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Detta är en lista av GEDCOM fakta som dina användare kan lägga till endast <u>en gång</u> till en källa. Du kan modifiera denna lista genom att tabort eller lägga till fakta namn, även egna, efter behov. Fakta namn som visas i denna lista får inte också finnas i <i>#pgv_lang[SOUR_FACTS_ADD]#</i>-listan.<br />";
$pgv_lang["REPO_FACTS_ADD"] 			= "Arkiv lägg till fakta";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Detta är en lista av GEDCOM fakta som dina användare kan lägga till till ett arkiv. Du kan modifiera denna lista genom att tabort eller lägga till fakta namn, även egna, efter behov. Fakta namn som visas i denna lista får inte också finnas i <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>-listan.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Unika arkivfakta";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Detta är en lista av GEDCOM fakta som dina användare kan lägga till endast <u>en gång</u> till ett arkiv. Du kan modifiera denna lista genom att tabort eller lägga till fakta namn, även egna, efter behov. Fakta namn som visas i denna lista får inte också finnas i <i>#pgv_lang[REPO_FACTS_ADD]#</i>-listan.<br />";
$pgv_lang["COMMIT_COMMAND"] 			= "Versionskontroll incheckningskommando";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Multi-sajtsökning tillåter användare att söka genom flera PhpGedView-sajter som du har satt upp i hantera sajter administration område eller som vi har länkat till. Detta val kontrollerar om Multi-sajt sökning ska vara på för alla eller endast för inloggade användare.<br />";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Visa multi-sajt sökning";
$pgv_lang["COMMIT_COMMAND_help"] 			= "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />Om du vill använda ett versionskontroll system som CVS att arkivera ändringar för din GEDCOM-fil och dina konfigurations och integritetsinställningar, skriv in kommandot här. Lämna rutan tom om du inte vill använda något versionkontrollsystem. Godkända val är <b>cvs</b> och <b>svn</b>.";

?>