<?php
/**
 * French Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2006  Christophe Bx, Julien Damon
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Christophe Bx
 * @author Julien Damon
 * @version $Id: configure_help.fr.php,v 1.26.2.21 2006/07/07 21:36:50 opus27 Exp $
 */
if (preg_match("/configure_help\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
	print "You cannot access a language file directly.";
	exit;
}

#pgv_lang["COMMIT_COMMAND_help"]        = "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />If you wish to use a version control system such as CVS to archive changes to your GEDCOM file and your configuration or privacy settings, enter the command here.  Leave the box blank if you do not wish to use a version control system.  Valid options are <b>cvs</b> and <b>svn</b>.<br />";
#pgv_lang["COMMIT_COMMAND"]             = "Version Control Commit Command";
#pgv_lang["SHOW_MULTISITE_SEARCH_help"] = "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Multi-site search allows users to search across multiple PhpGedView websites which you have setup in the Manage Sites administration area or remotely linked to.  This option controls whether the Multi-site Search feature is available to everyone or only to authenticated users.<br />";
#pgv_lang["SHOW_MULTISITE_SEARCH"]      = "Show Multi-Site Search";
#pgv_lang["DBPERSIST"]                  = "Use persistent database connections";
#pgv_lang["DBPERSIST_help"]             = "Controls whether PhpGedView should use persistent database connections when dealing with the database.<br /><br />When set to <b>Yes</b>, PhpGedView can re-use database connections thereby speeding up the establishing of database accesses.  However, this could cause errors if your host configuration has the maximum connections value set too low.  If you are unsure of your host's support of persistent connections, you should set this value to <b>No</b>.<br />";
$pgv_lang["INDI_FACTS_ADD"]             = "Evènements ajoutables pour un individu";
$pgv_lang["INDI_FACTS_ADD_help"]        = "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Liste des codes GEDCOM pour les évènements qu'il sera possible d'ajouter à une fiche individu.  Vous pouvez librement ajouter ou supprimer des codes à cette liste, à l'exception de ceux figurant dans la liste <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"]          = "Evènements uniques pour un individu";
#pgv_lang["INDI_FACTS_UNIQUE_help"]     = "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to individuals.  For example, if BIRT is in this list, users will not be able to add more than one BIRT record to an individual.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[INDI_FACTS_ADD]#</i> list.<br />";
$pgv_lang["FAM_FACTS_ADD"]              = "Evènements ajoutables pour une famille";
#pgv_lang["FAM_FACTS_ADD_help"]         = "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to families.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"]           = "Evènements uniques pour une famille";
#pgv_lang["FAM_FACTS_UNIQUE_help"]      = "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to families.  For example, if MARR is in this list, users will not be able to add more than one MARR record to a family.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[FAM_FACTS_ADD]#</i> list.<br />";
$pgv_lang["SOUR_FACTS_ADD"]             = "Evènements ajoutables pour une source";
#pgv_lang["SOUR_FACTS_ADD_help"]        = "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to sources.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"]          = "Evènements uniques pour une source";
#pgv_lang["SOUR_FACTS_UNIQUE_help"]     = "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to sources.  For example, if TITL is in this list, users will not be able to add more than one TITL record to a source.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[SOUR_FACTS_ADD]#</i> list.<br />";
$pgv_lang["REPO_FACTS_ADD"]             = "Evènements ajoutables pour un dépôt d'archives";
#pgv_lang["REPO_FACTS_ADD_help"]        = "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to repositories.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"]          = "Evènements uniques pour un dépôt d'archives";
#pgv_lang["REPO_FACTS_UNIQUE_help"]     = "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to repositories.  For example, if NAME is in this list, users will not be able to add more than one NAME record to a repository.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[REPO_FACTS_ADD]#</i> list.<br />";
$pgv_lang["LANG_SELECTION"]             = "Langues supportées";
#pgv_lang["LANG_SELECTION_help"]        = "~#pgv_lang[LANG_SELECTION]#~<br /><br />You can change the list of languages supported by your PhpGedView site by adding or removing checkmarks as appropriate.  This changes the language choices available to your users.<br /><br />You can achieve the same thing through the <b>#pgv_lang[enable_disable_lang]#</b> link on the #pgv_lang[admin]# menu, where you can also change things such as the language's flag icon, the date format, or whether the surname should always be printed first.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]            = "Préfixe MultiMedia";
#pgv_lang["MEDIA_ID_PREFIX_help"]       = "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />When a new media record is added online in PhpGedView, a new ID for that media will be generated automatically. The media ID will have this prefix.<br />";
$pgv_lang["FAM_ID_PREFIX"]              = "Préfixe Famille";
#pgv_lang["FAM_ID_PREFIX_help"]         = "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />When a new family record is added online in PhpGedView, a new ID for that family will be generated automatically. The family ID will have this prefix.<br />";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]    = "Evènements Famille à toujours afficher en mode <i>Quick Update</i>";
#pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will always be shown on the Family tabs of the Quick Update form whether or not they already exist in the individual's record.  For example, if MARR is in the list, then fields for marriage date and marriage place will always be shown on the form.<br />";
$pgv_lang["QUICK_ADD_FAMFACTS"]         = "Evènements Famille à ajouter en mode <i>Quick Update</i>";
#pgv_lang["QUICK_ADD_FAMFACTS_help"]    = "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will be shown on the Family tabs of the Quick Update form.  Only the facts in this list will be shown on the form or made available for selection in the area where you add new facts on the form.<br />";
$pgv_lang["QUICK_REQUIRED_FACTS"]       = "Evènements à toujours afficher en mode <i>Quick Update</i>";
#pgv_lang["QUICK_REQUIRED_FACTS_help"]  = "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will always be shown on the Quick Update form whether or not they already exist in the individual's record.  For example, if BIRT is in the list, fields for birth date and birth place will always be shown on the form.<br />";
$pgv_lang["QUICK_ADD_FACTS"]            = "Evènements à ajouter en mode <i>Quick Update</i>";
#pgv_lang["QUICK_ADD_FACTS_help"]       = "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will be shown on the Quick Update form.  Only the facts in this list will be shown on the form or made available for selection in the area where you add new facts on the form.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]       = "Créer automatiquement les vignettes";
#pgv_lang["AUTO_GENERATE_THUMBS_help"]  = "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Should the system automatically generate thumbnails for images that do not have them.  Your PHP installation might not support this functionality.<br />";
#pgv_lang["phpinfo_help"]               = "~#pgv_lang[phpinfo]#~<br /><br />This page provides extensive information about the server on which PhpGedView is being hosted.  Many configuration details about the server's software, as it relates to PHP and PhpGedView, can be viewed.<br />";
#pgv_lang["config_help_help"]           = "~#pgv_lang[config_help]#~<br /><br />This page collects all of the major topics of Configuration Help into one place.  You can view the information on your screen, or you can print it for later use.<br />";
#pgv_lang["more_config_hjaelp"]         = "<br /><b>More help</b><br />More help is available by clicking the <b>?</b> next to items on the page.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]            = "Largeur des vignettes";
#pgv_lang["THUMBNAIL_WIDTH_help"]       = "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />This is the width (in pixels) that the program will use when automatically generating thumbnails.  The default setting is 100.<br />";
$pgv_lang["show_sources"]               = "Montrer les sources ?";
$pgv_lang["SHOW_SOURCES_help"]          = "Option pour masquer les liens vers les sources sur toutes les pages si  l'utilisateur n'a pas les droits suffisants.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"]= "Un administrateur devra valider toute nouvelle demande de compte.";
#pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />If the option <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> is enabled this setting controls whether the admin must approve the registration.<br /><br />Setting this to <b>Yes</b> will require that all new users first verify themselves and then be approved by an admin before they can login.  With this setting on <b>No</b>, the <b>#pgv_lang[verified_by_admin]#</b> checkbox will be checked automatically when users verify their account, thus allowing an immediate login afterwards without admin intervention.<br /><br />This sets \$REQUIRE_ADMIN_AUTH_REGISTRATION in <i>config.php</i>.<br />";
$pgv_lang["SPLIT_PLACES"]               = "Découper les lieux";
$pgv_lang["SPLIT_PLACES_help"]          = "Option pour découper chaque lieu en mode saisie/modification, offrant ainsi une meilleure lisibilité. Exemple :<br /><ol><li>Mode par défaut<br /><u>Lieu</u>: Caen, Calvados (14), Basse-Normandie, FRA<br /><li>Mode découpe<br /><u>Pays</u>: FRA<br /><u>Région</u>: Basse-Normandie<br/><u>Département</u>: Calvados (14)<br/><u>Ville</u>: Caen</ol>";
$pgv_lang["ALLOW_REMEMBER_ME"]          = "Autoriser l'option \"Rester connecté\"";
#pgv_lang["ALLOW_REMEMBER_ME_help"]     = "~#pgv_lang[ALLOW_REMEMBER_ME]#~<br /><br />Many sites allow users to choose whether they want to be remembered from the same computer the next time they visit the site.  Enabling this option will put a <b>Remember Me</b> checkbox on the Login page.  When this checkbox is checked, PhpGedView has permission to store a cookie in the user's computer.  This cookie will allow PhpGedView to remember the user between visits from the same remote computer.<br /><br />This sets \$ALLOW_REMEMBER_ME in <i>config.php</i>.<br />";
$pgv_lang["UNDERLINE_NAME_QUOTES"]      = "Souligner les noms entre quotes";
#pgv_lang["UNDERLINE_NAME_QUOTES_help"] = "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Many programs will place the preferred given name in \"quotes\" in the GEDCOM.  The usual convention for this is to underline the preferred given name.  Enabling this option will convert any names surrounded by quotes to &lt;span&gt; with a CSS class of \"starredname\".<br /><br />For example, if the name in the GEDCOM were 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ enabling this option would change the part of the name enclosed in quotes to &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; for printing purposes.  Depending on other settings, the browser would then display that name as <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> or <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u> Charles</b><br /><br />This sets \$UNDERLINE_NAME_QUOTES in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["PRIVACY_BY_RESN"]            = "Utiliser le mode Restriction d'accès (RESN) de GEDCOM";
$pgv_lang["PRIVACY_BY_RESN_help"]       = "GEDCOM 5.5 permet de gérer les restrictions d'accès au moyen du marqueur RESN. En activant cette fonction, un contrôle sera effectué au niveau 1 pour chaque enregistrement de votre fichier GEDCOM. Le contrôle aux niveaux 2 et + est systématiquement réalisé et n'est pas affecté par cette valeur. Ce choix risque de ralentir certaines fonctions de PGV comme la liste des individus.<br /><br />Variable \$PRIVACY_BY_RESN du fichier des restrictions d'accès.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]         = "Montrer les codes LDS sur les diagrammes";
#pgv_lang["SHOW_LDS_AT_GLANCE_help"]    = "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Setting this option to <b>Yes</b> will show status codes for LDS ordinances in chart boxes.<ul><li><b>B</b> - Baptism</li><li><b>E</b> - Endowed</li><li><b>S</b> - Sealed to spouse</li><li><b>P</b> - Sealed to parents</li></ul>A person who has all of the ordinances done will have <b>BESP</b> printed after their name.  Missing ordinances are indicated by <b>_</b> in place of the corresponding letter code.  For example, <b>BE__</b> indicates missing <b>S</b> and <b>P</b> ordinances.<br /><br />This sets \$SHOW_LDS_AT_GLANCE in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["GEDCOM_DEFAULT_TAB"]         = "Onglet par défaut sur la fiche individuelle";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]    = "Option permettant de pré-sélectionner un onglet à l'affichage de la page Individu<br /><br />Variable \$GEDCOM_DEFAULT_TAB du fichier xxx.GED_conf.php";
$pgv_lang["SHOW_MARRIED_NAMES"]         = "Montrer le nom des femmes mariées dans les listes";
#pgv_lang["SHOW_MARRIED_NAMES_help"]    = "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />This option will show the married names of females on the Individual list.  This option requires that you calculate the married names when you import the GEDCOM file.<br /><br />This sets \$SHOW_MARRIED_NAMES in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SHOW_QUICK_RESN"]            = "Restrictions d'accès en mode <i>Quick Update</i>";
$pgv_lang["SHOW_QUICK_RESN_help"]       = "Option pour ajouter les champs de restrictions d'accès dans le formulaire <i>Quick Update</i>.<br /><br />Variable \$SHOW_QUICK_RESN du fichier xxx.GED_conf.php.";
$pgv_lang["USE_QUICK_UPDATE"]           = "Autoriser le mode <i>Quick Update</i>";
$pgv_lang["USE_QUICK_UPDATE_help"]      = "Option pour autoriser les utilisateurs connectés à soumettre des modifications à l'aide du formulaire de mise à jour rapide <i>Quick Update</i>.<br /><br />Variable \$USE_QUICK_UPDATE du fichier xxx.GED_conf.php.";
$pgv_lang["SEARCHLOG_CREATE"]           = "Archivage journal des recherches";
$pgv_lang["SEARCHLOG_CREATE_help"]      = "Fréquence d'archivage des journaux.<br /><br />Variable \$SEARCHLOG_CREATE du fichier xxx.GED_conf.php";
$pgv_lang["CHANGELOG_CREATE"]           = "Archivage journal des modifications";
#pgv_lang["CHANGELOG_CREATE_help"]      = "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />How often should the program archive Changelog files.<br /><br />This sets \$CHANGELOG_CREATE in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["CHART_BOX_TAGS"]             = "Autres évènements à afficher dans les tableaux";
$pgv_lang["CHART_BOX_TAGS_help"]        = "Liste de codes GEDCOM, séparés par une virgule ou un espace, pour forcer l'affichage de certains évènements dans les tableaux (ascendance, descendance...).<br />Exemple : pour afficher systématiquement la profession, ajouter le code \"OCCU\" dans cette zone.<br /><br />Variable \$CHART_BOX_TAGS du fichier xxx.GED_conf.php.";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]                  = "Configurer PhpGedView";
$pgv_lang["standard_conf"]              = "Options de Configuration Standard";
$pgv_lang["advanced_conf"]              = "Options de Configuration Avancée";
$pgv_lang["gedcom_conf"]                = "Configuration GEDCOM";
$pgv_lang["media_conf"]                 = "Objets Multimedia";
$pgv_lang["accpriv_conf"]               = "Restrictions d'accès";
$pgv_lang["displ_conf"]                 = "Options d'affichage";
$pgv_lang["displ_names_conf"]           = "Affichage des noms";
$pgv_lang["displ_comsurn_conf"]         = "Affichage des noms fréquents";
$pgv_lang["displ_layout_conf"]          = "Affichage";
$pgv_lang["displ_hide_conf"]            = "Cacher/Montrer";
$pgv_lang["editopt_conf"]               = "Options d'édition";
$pgv_lang["useropt_conf"]               = "Options de l'utilisateur";
$pgv_lang["contact_conf"]               = "Contact";
$pgv_lang["meta_conf"]                  = "Options de configuration des balises META";
$pgv_lang["configure_head"]             = "Configuration PhpGedView";
$pgv_lang["gedconf_head"]               = "Configuration GEDCOM";
$pgv_lang["default_user"]               = "Création de l'administrateur par défaut.";
$pgv_lang["about_user"]                 = "Vous devez d'abord créer un <b>administrateur principal</b>. Cet utilisateur pourra mettre à jour les fichiers de configuration, consulter les données privées et accorder des droits à d'autres utilisateurs.";
$pgv_lang["can_admin"]                  = "Droits pour Administrer";
$pgv_lang["can_edit"]                   = "Droits pour Modifier";
$pgv_lang["access"]                     = "Droits pour Consulter";
$pgv_lang["sync_gedcom"]                = "Synchroniser avec les données GEDCOM";
$pgv_lang["user_relationship_priv"]     = "Limiter l'accès aux proches";
$pgv_lang["user_path_length"]           = "Degré de parenté max";
$pgv_lang["add_user"]                   = "Ajouter un nouvel utilisateur";
$pgv_lang["current_users"]              = "Liste des utilisateurs";
$pgv_lang["leave_blank"]                = "Laisser le champ vide pour conserver le mot de passe existant.";
$pgv_lang["other_theme"]                = "ou entrer une autre valeur";
$pgv_lang["performing_update"]          = "Mise à jour en cours.";
$pgv_lang["config_file_read"]           = "Fichier de configuration lu.";
$pgv_lang["does_not_exist"]             = "n'existe pas";
$pgv_lang["media_drive_letter"]         = "NE PAS indiquer de lettre de lecteur (C:) dans le chemin Media. Les objets ne pourront pas être affichés.";
$pgv_lang["pgv_config_write_error"]     = "Impossible d'écrire dans le fichier de configuration PhpGedView. Vérifier les droits d'accès et réessayer.";
$pgv_lang["db_setup_bad"]               = "Mauvais fichier de configuration.  Veuillez vérifier vos paramètres de connexion à la base de données et recommencer la configuration.";
$pgv_lang["bad_host_user_pass"]         = "Echec de connexion à la base de données. Vérifier le nom du serveur, du compte utilisateur et le mot de passe.";
$pgv_lang["bad_database_name"]          = "La base de données a été trouvée, mais impossible d'y accéder. Vérifier les droits de l'utilisateur.";
$pgv_lang["click_here_to_continue"]     = "Continuer.";
$pgv_lang["config_help"]                = "Aide à la configuration";
$pgv_lang["mysql"]                      = "MySQL";
$pgv_lang["db"]                         = "Database";
$pgv_lang["dbase"]                      = "dBase";
$pgv_lang["fbsql"]                      = "FrontBase";
$pgv_lang["ibase"]                      = "InterBase";
$pgv_lang["ifx"]                        = "Informix";
$pgv_lang["msql"]                       = "Mini SQL";
$pgv_lang["mssql"]                      = "Microsoft SQL Server";
$pgv_lang["mysqli"]                     = "MySQL 4.1+ et PHP 5";
$pgv_lang["oci8"]                       = "Oracle 7+";
$pgv_lang["pgsql"]                      = "PostgreSQL";
$pgv_lang["sqlite"]                     = "SQLite";
$pgv_lang["sybase"]                     = "Sybase";
$pgv_lang["admin_gedcoms"]              = "Gérer les fichiers GEDCOM.";
$pgv_lang["current_gedcoms"]            = "Liste des fichiers GEDCOM chargés";
$pgv_lang["gedcom_adm_head"]            = "Administration GEDCOM";
$pgv_lang["ged_download"]               = "Télécharger (<i>Download</i>)";
$pgv_lang["ged_gedcom"]                 = "Fichier GEDCOM";
$pgv_lang["ged_title"]                  = "Titre du fichier GEDCOM";
$pgv_lang["ged_config"]                 = "Fichier de configuration";
$pgv_lang["ged_search"]                 = "Journal des recherches";
$pgv_lang["ged_change"]                 = "Journal des modifications";
$pgv_lang["ged_privacy"]                = "Fichier des restrictions d'accès";
$pgv_lang["show_phpinfo"]               = "Voir la page PHPInfo ";
$pgv_lang["confirm_gedcom_delete"]      = "Confirmez-vous la suppression de ce fichier GEDCOM ?";
$pgv_lang["gregorian"]                  = "Grégorien";
$pgv_lang["julian"]                     = "Julien";
$pgv_lang["config_french"]              = "Français";
$pgv_lang["jewish"]                     = "Israélite";
$pgv_lang["config_hebrew"]              = "Hébreu";
$pgv_lang["jewish_and_gregorian"]       = "Israélite et grégorien";
$pgv_lang["hebrew_and_gregorian"]       = "Hébreu et grégorien";
$pgv_lang["hijri"]                      = "Hijri";
$pgv_lang["arabic_cal"]                 = "Arabe";
$pgv_lang["disabled"]                   = "Désactivé";
$pgv_lang["mouseover"]                  = "Passage de souris";
$pgv_lang["mousedown"]                  = "Souris maintenue appuyée";
$pgv_lang["click"]                      = "Clic de souris";
$pgv_lang["mailto"]                     = "Lien Courriel [mailto:]";
$pgv_lang["messaging"]                  = "Messagerie interne PhpGedView";
$pgv_lang["messaging2"]                 = "Messagerie interne par courriel";
$pgv_lang["messaging3"]                 = "PhpGedView ne conserve pas les courriels envoyés";
$pgv_lang["no_messaging"]               = "Messagerie désactivée";
$pgv_lang["no_logs"]                    = "Journal désactivé";
$pgv_lang["daily"]                      = "Quotidien";
$pgv_lang["weekly"]                     = "Hebdo";
$pgv_lang["monthly"]                    = "Mensuel";
$pgv_lang["yearly"]                     = "Annuel";
$pgv_lang["enter_db_pass"]              = "Par sécurité, vous devez saisir votre <b>identificateur</b> et votre <b>mot de passe</b> avant toute modification.";
$pgv_lang["config_still_writable"]      = "Votre fichier <b>config.php</b> est accessible en écriture. Par sécurité il faut le remettre en <b>lecture-seule</b> après toute modification.";
$pgv_lang["admin_verification_waiting"] = "Compte(s) en attente de vérification par l'administrateur";
$pgv_lang["admin_user_warnings"]        = "Un ou plusieurs comptes ont un avertissement";
$pgv_lang["DEFAULT_GEDCOM"]             = "Fichier GEDCOM par défaut";
$pgv_lang["privileges"]                 = "Droits";
$pgv_lang["date_registered"]            = "Déclaration";
$pgv_lang["last_login"]                 = "Dernière visite";
$pgv_lang["server_url_note"]            = "Chemin du répertoire PhpGedView. Ne modifier qu'avec précaution. Valeur par défaut pour votre installation : <tt>#GUESS_URL#</tt>";

$pgv_lang["DBTYPE"]                     = "Type de la base de données";
$pgv_lang["DBTYPE_help"]                = "Type PEAR (PHP Extension and Application Repository) pour connexion à la base de données. A choisir parmi : MySQL, PostgreSQL, Oracle, SQLite... <br /><br />Variable \$DBTYPE du fichier config.php.";
$pgv_lang["DBHOST"]                     = "Serveur de la base de données";
$pgv_lang["DBHOST_help"]                = "Adresse DNS ou IP du système qui héberge le serveur de votre base de données.<br /><br />Variable \$DBHOST du fichier config.php.";
$pgv_lang["DBUSER"]                     = "Identificateur de connexion à la base de données";
$pgv_lang["DBUSER_help"]                = "Identificateur défini pour la connexion à la base de données.<br /><br />Variable \$DBUSER du fichier config.php.";
$pgv_lang["DBPASS"]                     = "Mot de passe de la base de données";
$pgv_lang["DBPASS_help"]                = "Mot de passe d'accès à la base de données pour l'identificateur défini.<br /><br />Variable \$DBPASS du fichier config.php.";
$pgv_lang["DBNAME"]                     = "Nom de la base de données";
$pgv_lang["DBNAME_help"]                = "Base de données du serveur qui sera utilisée par PhpGedView.  L'identificateur de connexion utilisé doit avoir les droits de création, d'insertion, de mise à jour, de suppression et de sélection sur cette base de données.<br /><br />Variable \$DBNAME du fichier config.php.";
$pgv_lang["TBLPREFIX"]                  = "Préfixe des noms de tables";
$pgv_lang["TBLPREFIX_help"]             = "Préfixe ajouté au nom des tables créées par PhpGedView.  En changeant cette valeur vous pouvez gérer plusieurs sites PhpGedView qui utilisent la même base de données mais avec des tables différentes.<br /><br />Variable \$TBLPREFIX du fichier config.php.";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]        = "Autoriser le choix du fichier GEDCOM";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]   = "Permet aux visiteurs et aux utilisateurs de changer de fichier GEDCOM quand il en existe plusieurs sur le serveur.<br /><br />Variable \$ALLOW_CHANGE_GEDCOM du fichier config.php.";
$pgv_lang["upload_path"]                = "Chemin du fichier";
#pgv_lang["upload_path_help"]           = "~#pgv_lang[upload_path]#~<br /><br />This is the path where the GEDCOM file you wish to upload can be found. To select the path, click on <b>Browse</b> and navigate to your GEDCOM file and then click <b>Open</b>.";
$pgv_lang["gedcom_path"]                = "Chemin et nom du fichier GEDCOM";
$pgv_lang["gedcom_path_help"]           = "Téléchargez d'abord votre fichier GEDCOM dans un répertoire accessible par php sur le serveur. Entrez ensuite ici le chemin d'accès et le nom complet du fichier.<br />Exemple : ./index/name.ged.<br /><br />Voir le fichier <a href=readme.txt>Readme.txt</a> pour d'autres détails.";
$pgv_lang["CHARACTER_SET"]              = "Code du jeu de caractères";
$pgv_lang["CHARACTER_SET_help"]         = "Jeu de caractères utilisé dans votre fichier GEDCOM.  Le jeu de caractères UTF-8 est le jeu par défaut qui devrait fonctionner pratiquement pour tous les sites.  Si vous exportez vos données GEDCOM en utilisant le code IBM de Windows, codez ici la valeur WINDOWS.<br /><br />NOTE: PHP n'accepte pas le code UNICODE (UTF-16).";
$pgv_lang["LANGUAGE"]                   = "Langue";
$pgv_lang["LANGUAGE_help"]              = "Langue par défaut pour le site. Les utilisateurs peuvent modifier cette valeur en changeant les préférences de leur navigateur ou en utilisant le formulaire proposé en bas de page si vous avez autorisé le changement de langue.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]      = "Autoriser le changement de langue";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "Permet aux utilisateurs de sélectionner une autre langue et de choisir par défaut la langue qu'ils ont définie dans les options de leur navigateur.";
$pgv_lang["LANGUAGE_DEFAULT"]           = "Vous n'avez pas configuré les options de langues.<br />PhpGedView va utiliser les valeurs par défaut.";
$pgv_lang["CALENDAR_FORMAT"]            = "Format du calendrier";
$pgv_lang["CALENDAR_FORMAT_help"]       = "Permet d'indiquer le <b>type de calendrier</b> que vous souhaitez utiliser avec ce fichier GEDCOM.  Le calendrier hébreu est le même que le calendrier israélite mais avec des caractères hébraïques.  Note: les dates du calendrier israélite/hébreu sont calculées à partir des dates du calendrier grégorien ou julien. Comme le jour israélite commence le soir, chaque évènement qui a eu lieu entre le crépuscule et minuit sera noté avec un jour d'avance sur la date correcte. L'affichage des caractères hébraïques peut poser problème avec les anciens navigateurs. Certains navigateurs afficheront les caractères dans le mauvais sens ou ne les afficheront pas du tout.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]   = "Affichage des milliers des années hébraïques";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]= "Affichage Alafim dans le calendrier hébreu. En codant 'oui' l'année 1969 sera affichée : <span lang='he-IL' dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;\"&#1496;</span>&lrm; alors qu'en codant 'non' elle sera affichée : <span lang='he-IL' dir='rtl'>&#1514;&#1513;&#1499;\"&#1496;</span>&lrm;. Cette valeur n'a pas d'impact sur le calcul de l'année. L'année sera 5729 quelle que soit la valeur de cette variable.<br /><br />Variable \$DISPLAY_JEWISH_THOUSANDS du fichier config.php.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]  = "Affichage Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]= "Afficher les simple et double quotes pour les dates hébraïques. En codant 'oui' le 8 février 1969 sera affiché  <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;\"&#1496;</span>&lrm; alors qu'en codant 'non' il sera affiché <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Sans impact sur la valeur de l'année juive car les quotes ne sont pas utilisées dans les dates avec les caractères Latin.<br />Note: ce paramétre est similaire aux constantes Php 5.0 CAL_JEWISH_ADD_ALAFIM_GERESH et CAL_JEWISH_ADD_GERESHAYIM. Il affecte les deux valeurs.<br /><br />Variable \$DISPLAY_JEWISH_GERESHAYIM du fichier config.php.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]= "Prononciation Ashkénaze";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]= "Utiliser la prononciation Ashkénaze.<br />En codant 'oui' les mois de Cheshvan et de Teves seront codés selon la prononciation Ashkénaze. En codant 'non' ils seront codés Hesvan et Tevet. <br />Ceci n'affecte que le calendrier israélite. Avec le calendrier hébreu c'est l'alphabet hébreu qui sera utilisé.<br /><br />Variable \$JEWISH_ASHKENAZ_PRONUNCIATION du fichier config.php.";
$pgv_lang["USE_RTL_FUNCTIONS"]          = "Utiliser l'affichage RTL (de droite à gauche)";
#pgv_lang["USE_RTL_FUNCTIONS_help"]     = "~#pgv_lang[USE_RTL_FUNCTIONS]#~<br /><br />Use processing to properly display GEDCOM data in RTL languages.  If set to <b>Yes</b> the database will be processed at runtime to ensure proper display of RTL data; this setting can slow down performance.<br /><br />This sets \$USE_RTL_FUNCTIONS in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]= "Nombre de générations de l'arbre d'<b>ascendance</b>";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]= "Indique le nombre de générations à afficher par défaut sur les arbres d'<b>ascendance</b>.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]   = "Nombre maximum de générations de l'arbre d'<b>ascendance</b>";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]= "Fixe le nombre maximum de générations à afficher pour les arbres d'<b>ascendance</b>.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]= "Nombre maximum de générations de l'arbre de <b>descendance</b>";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]= " Fixe le nombre maximun de générations à afficher pour les arbres de <b>descendance</b>.";
$pgv_lang["USE_RIN"]                    = "Utiliser le numéro RIN au lieu de la clé GEDCOM";
$pgv_lang["USE_RIN_help"]               = "Option pour utiliser le numéro RIN au lieu de l'identifiant GEDCOM comme code des individus dans les fichiers de configuration, dans les fichiers de préférences et les arbres. Ceci est utile avec les programmes de généalogie qui exportent les données GEDCOM en utilisant le RIN.";
#pgv_lang["GENERATE_GUID"]              = "Automatically create globally unique IDs";
#pgv_lang["GENERATE_GUID_help"]         = "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> in this context is an acronym for «Globally Unique ID».<br /><br />GUIDs are intended to help identify each individual in a manner that is repeatable, so that central organizations such as the Family History Center of the LDS Church in Salt Lake City, or even compatible programs running on your own server, can determine whether they are dealing with the same person no matter where the GEDCOM originates.  The goal of the Family History Center is to have a central repository of genealogical data and expose it through web services. This will enable any program to access the data and update their data within it.<br /><br />If you do not intend to share this GEDCOM with anyone else, you do not need to let PhpGedView create these GUIDs; however, doing so will do no harm other than increasing the size of your GEDCOM.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"]           = "Individu par défaut pour les arbres d'ascendance et de descendance";
$pgv_lang["PEDIGREE_ROOT_ID_help"]      = "Indique l'identificateur de la personne à afficher par défaut pour les arbres d'ascendance et de descendance.";
$pgv_lang["GEDCOM_ID_PREFIX"]           = "Préfixe Individu";
$pgv_lang["GEDCOM_ID_PREFIX_help"]      = "Préfixe ajouté par défaut à l'identifiant GEDCOM d'un individu (INDI) quand l'utilisateur ne l'indique pas.";
$pgv_lang["SOURCE_ID_PREFIX"]           = "Préfixe Source";
$pgv_lang["SOURCE_ID_PREFIX_help"]      = "Préfixe ajouté par défaut à l'identifiant GEDCOM d'une source (SOUR) quand l'utilisateur ne l'indique pas.";
$pgv_lang["REPO_ID_PREFIX"]             = "Préfixe Dépôt d'archives";
$pgv_lang["REPO_ID_PREFIX_help"]        = "Préfixe ajouté par défaut à l'identifiant GEDCOM d'un dépôt d'archives (REPO) quand l'utilisateur ne l'indique pas.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]      = "Afficher les détails de la naissance et du décès sur les arbres";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "Option pour afficher par défaut les détails de la naissance et du décès d'un individu sur les arbres d'ascendance et de descendance.";
$pgv_lang["PEDIGREE_LAYOUT"]            = "Orientation par défaut des arbres";
$pgv_lang["PEDIGREE_LAYOUT_help"]       = "Indique le sens d'orientation des arbres sur la page :<br /><ul><li>Portrait = <img src=\"images/darrow.gif\" align=\"middle\" /> vertical<li>Paysage = <img src=\"images/rarrow.gif\" align=\"middle\" /> horizontal</ul>";
$pgv_lang["SHOW_EMPTY_BOXES"]           = "Afficher les cases vides sur les arbres d'ascendance";
$pgv_lang["SHOW_EMPTY_BOXES_help"]      = "Indique si les cases sans informations doivent être affichées ou non sur les arbres d'ascendance.";
$pgv_lang["ZOOM_BOXES"]                 = "Zoom sur les cases des tableaux";
$pgv_lang["ZOOM_BOXES_help"]            = "Méthode de zoom sur les cases d'un tableau pour obtenir davantage d'informations.";
$pgv_lang["LINK_ICONS"]                 = "Liens entre tableaux";
$pgv_lang["LINK_ICONS_help"]            = "Méthode d'activation des liens entre les tableaux.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]    = "Abréger les intitulés dans les tableaux";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]= "Option pour abréger ou non les intitulés comme 'Naissance' par la première lettre 'N'.";
$pgv_lang["SHOW_PARENTS_AGE"]           = "Afficher l'âge des parents à la naissance de l'enfant";
$pgv_lang["SHOW_PARENTS_AGE_help"]      = "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Option pour afficher l'âge du père et de la mère dans les tableaux à côté de la date de naissance de l'enfant.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Afficher naissance, mariage et décès des proches sur la fiche individuelle";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />La naissance, le mariage ou le décès d'un proche sont des évènements importants dans la vie de chacun. Cette option permet de les ajouter sur l'onglet &laquo;Faits et détails personnels&raquo; de la fiche individuelle.";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]    = "Ouvrir automatiquement la liste d'évènements";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"]= "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Option pour ouvrir par défaut la liste <i>#pgv_lang[SHOW_RELATIVES_EVENTS]#</i>.<br />";
$pgv_lang["EXPAND_SOURCES"]             = "Ouvrir automatiquement les sources";
$pgv_lang["EXPAND_SOURCES_help"]        = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Option pour afficher par défaut le contenu des <i>Sources</i> sur la page individuelle.<br />";
$pgv_lang["HIDE_LIVE_PEOPLE"]           = "Masquer les personnes vivantes";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]      = "Cette option indique à PhpGedView qu'il faut cacher les détails qui concernent les personnes qui sont encore en vie.  Les personnes vivantes sont celles dont l'âge n'a pas dépassé la valeur \$MAX_ALIVE_AGE, et qui n'ont pas d'enfant dont l'âge est inférieur à \$MAX_ALIVE_AGE.";
$pgv_lang["REQUIRE_AUTHENTICATION"]     = "Authentification obligatoire";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]= "Oblige les visiteurs à se connecter avant toute opération.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]     = "Texte de bienvenue sur la page de connexion";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]= "Choix du texte qui s'affichera sur l'écran de connexion, si le mode Authentification est actif. Choisir SVP le texte le plus approprié.<br />Vous pouvez également saisir votre propre texte de bienvenue, mais il ne s'affichera pas dans la langue du visiteur.<br /><br />Liste des textes prédéfinis :<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_1]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_2]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_3]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]= "Texte indiquant que tous les visiteurs peuvent demander un compte";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]= "Texte indiquant que l'administrateur décidera si besoin d'un compte";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]= "Texte indiquant que seuls les membres de la famille peuvent demander un compte";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]= "Choisir un texte de bienvenue";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]= "Texte de bienvenue personnalisé";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]= "Si vous avez fait le choix d'un texte de bienvenue personnalisé, vous pouvez le saisir ici.<br />Ce texte ne sera PAS traduit dans la langue des visiteurs, il s'affichera exactement comme vous l'aurez tapé.<br />Les marqueurs HTML sont autorisés.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"]= "En-tête standard pour le texte de bienvenue personnalisé";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"]= "Affichage d'un en-tête standard multi-langues pour votre texte de bienvenue personnalisé.<br /><br />Il se présentera comme ceci :<br /><br />#pgv_lang[welcome_text_cust_head]#";
$pgv_lang["CHECK_CHILD_DATES"]          = "Contrôler les dates des enfants";
$pgv_lang["CHECK_CHILD_DATES_help"]     = "Vérification des dates des enfants pour déterminer si une personne est décédée.  Sur des systèmes anciens et avec de gros fichiers GEDCOM cette option peut dégrader les temps de réponse.";
$pgv_lang["MAX_ALIVE_AGE"]              = "Age maxi d'une personne";
$pgv_lang["MAX_ALIVE_AGE_help"]         = "L'âge maximal auquel on peut trouver un évènement enregistré pour une personne ou l'âge maximal de ses enfants pour déterminer si elle est vivante ou non.";
$pgv_lang["SHOW_GEDCOM_RECORD"]         = "Autoriser la <b>consultation</b> des enregistrements GEDCOM";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]    = "Option permettant de placer des liens sur les individus, les sources et les familles pour autoriser les utilisateurs à ouvrir une fenêtre qui contiendra le code GEDCOM extrait du fichier.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]          = "Autoriser la <b>modification</b> des données GEDCOM du serveur";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]     = "Autorise les fonctions d'édition des donnéees GEDCOM pour que les utilisateurs autorisés puissent mettre à jour ce fichier directement.";
$pgv_lang["EDIT_AUTOCLOSE"]             = "Fermer automatiquement la fenêtre d'édition";
$pgv_lang["EDIT_AUTOCLOSE_help"]        = "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Option pour fermer automatiquement la fenêtre d'édition après une mise à jour réussie, sans avoir besoin de cliquer sur le bouton 'Fermer'.<br />";
$pgv_lang["INDEX_DIRECTORY"]            = "Répertoire des fichiers d'index";
$pgv_lang["INDEX_DIRECTORY_help"]       = "Le chemin vers un répertoire accessible en lecture et en écriture où PhpGedView doit stocker les fichiers d'index (avec le '/' final)<br />Variable \$INDEX_DIRECTORY du fichier config.php.";
$pgv_lang["POSTAL_CODE"]                = "Position du code postal";
$pgv_lang["POSTAL_CODE_help"]           = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Option pour afficher le code postal devant ou derrière le nom de la ville, selon le pays.<br />";
$pgv_lang["ALPHA_INDEX_LISTS"]          = "Découper les longues listes de noms";
$pgv_lang["ALPHA_INDEX_LISTS_help"]     = "Les très longues listes de familles et d'individus seront découpées selon la lettre initiale du nom de famille.";
$pgv_lang["NAME_FROM_GEDCOM"]           = "Afficher le nom à partir du fichier GEDCOM";
$pgv_lang["NAME_FROM_GEDCOM_help"]      = "Par défaut PhpGedView affiche le nom d'individu qui est stocké dans ses fichiers d'index.  Dans certains formats GEDCOM et avec certaines langues le nom stocké dans les fichiers d'index ne s'affiche pas correctement et la solution alternative est de le prendre dans le fichier GEDCOM.  Les noms espagnols sont un bon exemple de ce problème. Un nom de famille espagnol peut avoir le format 'Prénoms Nom de famille du père Nom de famille de la mère'. En utilisant les index pour le tri et l'affichage, ce nom serait affiché ainsi 'Prénoms Nom de famille de la mère Nom de famille du père'. En prenant le nom inscrit dans le fichier GEDCOM on retrouvera le nom correct. Cependant, la récupération du nom dans le fichier GEDCOM ralentira le programme.";
$pgv_lang["SHOW_ID_NUMBERS"]            = "Afficher les identificateurs des personnes";
$pgv_lang["SHOW_ID_NUMBERS_help"]       = "Option pour afficher l'identifiant des individus entre parenthèses sur les arbres et les listes.";
$pgv_lang["SHOW_FAM_ID_NUMBERS"]        = "Afficher les identificateurs de familles";
$pgv_lang["SHOW_FAM_ID_NUMBERS_help"]   = "Option pour afficher l'identifiant des familles entre parenthèses sur les arbres et les listes.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]       = "Niveau de détail pour l'affichage des lieux";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]  = "Indique le nombre de niveaux à afficher pour les lieux sur les arbres d'ascendance et de descendance. Valeur entre 0 (=ne rien afficher) et 9 (=afficher tout).";
$pgv_lang["MULTI_MEDIA"]                = "Autoriser les fonctions MultiMedia";
$pgv_lang["MULTI_MEDIA_help"]           = "GEDCOM 5.5 permet d'associer des images, des vidéos et autres objets MultiMedia. Si vous n'avez pas inclus d'objets MultiMedia dans votre fichier GEDCOM vous pouvez désactiver cette option.<br />Voir le chapitre MultiMedia du fichier <a href=readme.txt>readme.txt</a> pour plus d'informations sur l'insertion de fichiers MultiMedia sur votre site.";
$pgv_lang["MEDIA_EXTERNAL"]             = "Conserver les liens";
$pgv_lang["MEDIA_EXTERNAL_help"]        = "Option pour les liens Multimedia au format <tt>http://</tt>, <tt>ftp://</tt>, <tt>mms://</tt><br />Choix <i>Oui</i> : les liens ne sont pas modifiés. Par exemple: <u>http://www.myfamily.com/photo/dad.jpg</u> restera <u>http://www.myfamily.com/photo/dad.jpg</u>.<br />Choix <i>Non</i> : ces liens suivent la règle des objets Multimedia. Par example: <u>http://www.myfamily.com/photo/dad.jpg</u> deviendra <u>./media/dad.jpg</u>";
$pgv_lang["MEDIA_DIRECTORY"]            = "Répertoire MultiMedia";
$pgv_lang["MEDIA_DIRECTORY_help"]       = "Chemin d'accès à un répertoire accessible en lecture où PhpGedView doit trouver les fichiers MultiMedia (coder le '/' final).";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]     = "Niveaux de sous-répertoires MultiMedia";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]= "Une valeur de 0 permettra d'ignorer tous les sous-répertoires du chemin d'accès aux objets MultiMedia.<br />Une valeur de 1 permettra d'accèder au sous-répertoire qui contient l'objet.<br />En augmentant cette valeur on augmentera le nombre des sous-répertoires parents à inclure dans ce chemin d'accès.<br />Par exemple : si le lien vers une image de votre fichier GEDCOM est libellé ainsi C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg, alors une valeur de 0 traduira ce chemin en ./media/grandpa.jpg. Une valeur de 1 le traduira en ./media/Surname Line/grandpa.jpg, etc. Vous n'aurez le plus souvent qu'à utiliser la valeur de 0. Mais il est possible que certains objets MultiMedia aient des noms identiques et se substituent de ce fait l'un à l'autre. Ce paramètre vous permet de conserver l'organisation de vos sous-répertoires en évitant les conflits de noms.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]      = "Afficher les miniatures des individus";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "Si vous avez activé les fonctions MultiMedia sur votre site, vous pouvez faire afficher une image miniature à côté du nom de la personne dans les cases des arbres. PhpGedView utilise comme image le premier objet MultiMedia cité dans l'enregistrement GEDCOM. Pour les personnes qui ont plusieurs images, vous devrez organiser vos données GEDCOM de manière à mettre en première position l'image souhaitée.<br />Voir le chapitre multimedia du fichier <a href=readme.txt>readme.txt</a> pour des informations complémentaires.";
$pgv_lang["USE_THUMBS_MAIN"]            = "Afficher les vignettes à la place des images";
$pgv_lang["USE_THUMBS_MAIN_help"]       = "A l'écran, il est souvent préférable d'afficher uniquement les vignettes (thumbnails), plus rapides à charger que les images d'origine. Cela dépend surtout de votre façon d'organiser les images, de leur poids, et de la qualité des vignettes.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]      = "Autoriser la copie de données";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "La copie de données (<I>clipping</I>) permet aux visiteurs de votre site d'extraire des informations dans un fichier qu'ils pourront télécharger au format GEDCOM et importer dans leur logiciel de généalogie.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]         = "Masquer les erreurs GEDCOM";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]    = "Option pour masquer les messages d'erreur produits par PhpGedView lorsqu'il ne reconnaît pas une balise GEDCOM de votre fichier. PhpGedView s'efforce de respecter le standard GEDCOM 5.5, mais beaucoup de logiciels de généalogie utilisent leurs propres balises.<br />Voir le fichier <a href=readme.txt>readme.txt</a> pour plus d'informations.";
$pgv_lang["WORD_WRAPPED_NOTES"]         = "Ajouter des espaces en fin de ligne dans les notes";
$pgv_lang["WORD_WRAPPED_NOTES_help"]    = "Certains programmes génèrent des fins de ligne dans les notes sans couper les mots alors que d'autres programmes les génèrent à n'importe quel endroit.  Ceci peut provoquer l'accolade de deux mots sans espace de séparation par PhpGedView. En codant 'oui' pour cette option, un espace sera inséré entre les mots quand ils ont été coupés dans le fichier GEDCOM.";
$pgv_lang["show_context_help"]          = "Afficher l'aide contextuelle";
$pgv_lang["SHOW_CONTEXT_HELP_help"]     = "Option d'affichage du lien d'aide contextuelle derrière les champs.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]         = "Limite des prochains évènements (jours)";
#pgv_lang["DAYS_TO_SHOW_LIMIT_help"]    = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Enter the maximum number of days to show in Upcoming Events blocks.  This number cannot be greater than 30. If you enter a larger value, 30 will be used.<br /><br />The value you enter here determines how far ahead PhpGedView looks when searching for upcoming events.  The results of this search, done once daily, are copied into a temporary file.<br /><br />No Upcoming Events blocks on Index or Portal pages can request more days than this value.  The larger you make this, the longer it will take to build the daily database extract, and the longer it will take to display the block, even when you request to display a number of days less than this setting.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]     = "Fréquence mini pour figurer dans la liste des principaux noms de familles";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]= "Nombre à partir duquel un nom de famille sera affiché dans la liste des principaux noms de familles sur la page d'accueil.";
$pgv_lang["COMMON_NAMES_ADD"]           = "Noms à <b>ajouter</b> dans la liste des principaux noms de familles";
$pgv_lang["COMMON_NAMES_ADD_help"]      = "Si un nom de famille n'atteint pas le seuil pour être affiché dans la liste, il peut être ajouté manuellement ici. Pour ajouter plusieurs noms, les séparer par une virgule. Le système distingue majuscules et minuscules.";
$pgv_lang["COMMON_NAMES_REMOVE"]        = "Noms à <b>retirer</b> de la liste des principaux noms de familles";
$pgv_lang["COMMON_NAMES_REMOVE_help"]   = "Pour ne pas afficher un nom dans la liste des principaux noms de famille sans modifier le seuil, il suffit de l'ajouter à ici manuellement ici. Pour ajouter plusieurs noms, les séparer par une virgule. Le système distingue majuscules et minuscules.";
$pgv_lang["HOME_SITE_URL"]              = "URL du site web";
$pgv_lang["HOME_SITE_URL_help"]         = "URL qui est utilisée dans le '<I>header</I>' des thèmes fournis pour générer un lien vers votre site web.";
$pgv_lang["HOME_SITE_TEXT"]             = "Description du site web";
$pgv_lang["HOME_SITE_TEXT_help"]        = "Texte utilisé pour la génération du lien vers votre site web.";
$pgv_lang["CONTACT_EMAIL"]              = "Adresse courriel du contact Généalogie";
$pgv_lang["CONTACT_EMAIL_help"]         = "L'adresse que les visiteurs doivent utiliser pour contacter la personne responsable des données généalogiques de ce site.";
$pgv_lang["CONTACT_METHOD"]             = "Préférence du contact Généalogie";
$pgv_lang["CONTACT_METHOD_help"]        = "Méthode à utiliser sur le lien contact Généalogie.";
$pgv_lang["WEBMASTER_EMAIL"]            = "Adresse courriel de l'administrateur";
$pgv_lang["WEBMASTER_EMAIL_help"]       = "L'adresse que les visiteurs doivent utiliser pour les questions techniques ou les erreurs qu'ils peuvent rencontrer sur votre site.";
$pgv_lang["SUPPORT_METHOD"]             = "Préférence de l'administrateur";
$pgv_lang["SUPPORT_METHOD_help"]        = "Méthode à utiliser sur le lien contact Administrateur.";
$pgv_lang["SHOW_FACT_ICONS"]            = "Montrer les icones des évènements";
#pgv_lang["SHOW_FACT_ICONS_help"]       = "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Set this to <b>#pgv_lang[yes]#</b> to display icons near Fact names on the #pgv_lang[personal_facts]# page.  Fact icons will be displayed only if they exist in the <i>images/facts</i> directory of the current theme.<br />";
$pgv_lang["FAVICON"]                    = "Icône des favoris";
$pgv_lang["FAVICON_help"]               = "Changez cette valeur pour pointer vers l'icône que vous souhaitez afficher dans le menu des favoris quand on enregistre un pointeur vers votre site.";
$pgv_lang["THEME_DIR"]                  = "Répertoire des thèmes";
$pgv_lang["THEME_DIR_help"]             = "Le répertoire dans lequel les fichiers des thèmes PhpGedView sont conservés. Vous pouvez personnaliser les thèmes qui sont livrés avec PhpGedView afin d'obtenir une présentation originale et unique de votre site.  Voir le chapitre personnalisation des thèmes du fichier <a href=readme.txt>readme.txt</a> pour plus d'informations.";
$pgv_lang["time_limit"]                 = "Durée max.";
$pgv_lang["TIME_LIMIT_help"]            = "Temps maximal en secondes que PhpGedView est autorisé à consommer. La valeur par défaut est d'une minute.  Selon la taille de votre fichier GEDCOM, il peut être nécessaire d'augmenter cette valeur.  En codant une valeur de 0, vous supprimez la limite de temps d'exécution de PHP.<br />ATTENTION: En codant 0 ou en codant une valeur trop élevée vous pourrez causer le blocage de votre site sur certains systèmes d'exploitation jusqu'à la fin de l'exécution du script.  La valeur de 0 signifie qu'il pourrait ne jamais se terminer jusqu'à ce qu'un administrateur du serveur arrête le processus ou redémarre le serveur. La construction d'un grand arbre généalogique peut prendre un très long temps, et en laissant cette valeur aussi basse que possible vous serez certain que personne ne pourra bloquer le serveur de votre site en demandant la construction d'un arbre de 1000 générations.";
$pgv_lang["PGV_SESSION_SAVE_PATH"]      = "Répertoire des sauvegardes de sessions";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "Indique le chemin à utiliser pour stocker les fichiers des sessions PhpGedView. Certains serveurs n'ont pas une configuration correcte de PHP et les sessions ne sont pas maintenues en passant d'une page à une autre. Cette variable permet aux administrateurs de régler le problème en sauvegardant les fichiers dans un répertoire local. Le répertoire ./index/ est un bon choix si vous devez choisir un répertoire. Par défaut ce champ est laissé vide, ce qui permet d'utiliser le chemin configuré dans le fichier php.ini.<br /><br />Variable \$PGV_SESSION_SAVE_PATH du fichier config.php.";
$pgv_lang["SERVER_URL"]                 = "URL du serveur";
$pgv_lang["SERVER_URL_help"]            = "Si vous utilisez le protocole <tt>https</tt>, ou un port autre que celui par défaut, entrez ici le chemin d'accès au serveur.<br /><br />Variable \$SERVER_URL variable du fichier config.php.";
$pgv_lang["LOGIN_URL"]                  = "URL de connexion (login)";
$pgv_lang["LOGIN_URL_help"]             = "A utiliser uniquement dans le cas où vous souhaitez rediriger la connexion vers un autre site, ou pour basculer du mode <tt>http</tt> au mode <tt>https</tt>.<br /><br />Entrer ici l'URL complète du fichier login.php, par exemple :<br /><tt>https://www.yourserver.com/phpgedview/login.php</tt>.";
$pgv_lang["PGV_SESSION_TIME"]           = "Limite de durée d'une session";
$pgv_lang["PGV_SESSION_TIME_help"]      = "Durée, en secondes, pendant laquelle une session PhpGedView reste active avant de nécessiter une nouvelle connexion.  La valeur par défaut est de 30 minutes.<br /><br />Variable \$PGV_SESSION_TIME du fichier config.php.";
$pgv_lang["SHOW_STATS"]                 = "Afficher les statistiques";
$pgv_lang["SHOW_STATS_help"]            = "Affichage des statistiques d'exécution du programme et des requêtes faites sur la base de données au bas de chaque page.";
$pgv_lang["SHOW_COUNTER"]               = "Afficher le compteur de visites";
$pgv_lang["SHOW_COUNTER_help"]          = "Compteur du nombre d'accès aux pages du site.";
$pgv_lang["USE_REGISTRATION_MODULE"]    = "Permettre aux utilisateurs de demander l'enregistrement de leur compte";
$pgv_lang["USE_REGISTRATION_MODULE_help"]= "Autoriser les utilisateurs à demander l'ouverture d'un compte sur ce site. Les administrateurs devront approuver l'inscription pour que le compte devienne actif.<br /><br />Variable \$USE_REGISTRATION_MODULE du fichier config.php.";
$pgv_lang["ALLOW_USER_THEMES"]          = "Permettre aux utilisateurs de choisir leur propre thème";
$pgv_lang["ALLOW_USER_THEMES_help"]     = "Autoriser les utilisateurs à choisir leur propre thème.<br /><br />Variable \$ALLOW_USER_THEMES du fichier config.php.";
$pgv_lang["PGV_SIMPLE_MAIL"]            = "Utiliser un en-tête simple pour les courriels";
$pgv_lang["PGV_SIMPLE_MAIL_help"]       = "L'en-tête normal de courriel comporte l'adresse mél et le nom du destinataire. Certains systèmes de messagerie ne l'acceptent pas. En choisissant cette option, seule l'adresse mél sera utilisée.<br /><br />Variable \$PGV_SIMPLE_MAIL du fichier config.php.";
$pgv_lang["gedcom_title"]               = "Titre descriptif des données de ce fichier GEDCOM";
$pgv_lang["gedcom_title_help"]          = "Entrer une courte description de ce fichier GEDCOM pour le présenter aux visiteurs.";
$pgv_lang["LOGFILE_CREATE"]             = "Archivage des journaux";
$pgv_lang["LOGFILE_CREATE_help"]        = "Fréquence d'archivage des journaux.<br /><br />Variable \$LOGFILE_CREATE du fichier config.php.";
$pgv_lang["PGV_MEMORY_LIMIT"]           = "Limite de Mémoire";
$pgv_lang["PGV_MEMORY_LIMIT_help"]      = "Quantité de mémoire allouée au programme. Défaut : 16M. La plupart des serveurs interdisent cette modification.<br /><br />Variable \$PGV_MEMORY_LIMIT du fichier config.php.";
$pgv_lang["PGV_STORE_MESSAGES"]         = "Autoriser le stockage des messages sur le serveur";
$pgv_lang["PGV_STORE_MESSAGES_help"]    = "Option de stockage des messages sur le serveur. 'Oui' permettra aux utilisateurs de retrouver leurs messages quand ils se reconnectent. 'Non' enverra les messages par courriel.<br /><br />Variable \$PGV_STORE_MESSAGES du fichier config.php.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]       = "Affichage d'une liste de choix pour changer le thème";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]  = "Permet aux utilisateurs de choisir leur propre thème à partir d'une liste (si la configuration l'autorise).<br /><br />Variable \$ALLOW_THEME_DROPDOWN du fichier config.php.";
$pgv_lang["MAX_VIEW_RATE"]              = "Taux max de visite des pages";
#pgv_lang["MAX_VIEW_RATE_help"]         = "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />This option limits the rate at which a user can view pages.<br /><br />If that rate is exceeded, PhpGedView treats the session as a hacking attempt;  the session will be terminated with a suitable message.  These two values should place a reasonable limit on the amount of bandwith and downloaded bytes from the server.  This feature can be switched off by setting the time interval to 0.<br /><br />This sets \$MAX_VIEWS and \$MAX_VIEW_TIME in <i>config.php</i>.<br />";
$pgv_lang["page_views"]                 = "&nbsp;&nbsp;visites en &nbsp;&nbsp;";
$pgv_lang["seconds"]                    = "&nbsp;&nbsp;secondes";
$pgv_lang["META_AUTHOR"]                = "META Author";
$pgv_lang["META_AUTHOR_help"]           = "Contenu du champ 'Author' (Auteur du site) de la balise META à insérer dans l'entête de chaque page HTML.<br />Variable \$META_AUTHOR du fichier config.php.";
$pgv_lang["META_AUTHOR_descr"]          = "Si vide, le nom complet de l'administrateur GEDCOM sera utilisé.";
$pgv_lang["META_PUBLISHER"]             = "META Publisher";
$pgv_lang["META_PUBLISHER_help"]        = "Contenu du champ 'Publisher' (Editeur du site) de la balise META à insérer dans l'entête de chaque page HTML.<br />Variable \$META_PUBLISHER du fichier config.php.";
$pgv_lang["META_PUBLISHER_descr"]       = "Si vide, le nom complet de l'administrateur GEDCOM sera utilisé.";
$pgv_lang["META_COPYRIGHT"]             = "META Copyright";
$pgv_lang["META_COPYRIGHT_help"]        = "Contenu du champ 'Copyright' de la balise META à insérer dans l'entête de chaque page HTML.<br />Variable \$META_COPYRIGHT du fichier config.php.";
$pgv_lang["META_COPYRIGHT_descr"]       = "Si vide, le nom complet de l'administrateur GEDCOM sera utilisé.";
$pgv_lang["META_DESCRIPTION"]           = "META Description";
$pgv_lang["META_DESCRIPTION_help"]      = "Contenu du champ 'Description' de la balise META à insérer dans l'entête de chaque page HTML.<br />Variable \$META_DESCRIPTION du fichier config.php.";
$pgv_lang["META_DESCRIPTION_descr"]     = "Si vide, le titre de la base GEDCOM sera utilisé.";
$pgv_lang["META_PAGE_TOPIC"]            = "META Page-Topic";
$pgv_lang["META_PAGE_TOPIC_help"]       = "Contenu du champ 'Page-Topic' (sujet du site) de la balise META à insérer dans l'entête de chaque page HTML.<br />Variable \$META_PAGE_TOPIC du fichier config.php.";
$pgv_lang["META_PAGE_TOPIC_descr"]      = "Si vide, le titre de la base GEDCOM sera utilisé.";
$pgv_lang["META_AUDIENCE"]              = "META Audience";
$pgv_lang["META_AUDIENCE_help"]         = "Contenu du champ 'Audience' (public visé par le site) de la balise META à insérer dans l'entête de chaque page HTML.<br />Variable \$META_AUDIENCE du fichier config.php.";
$pgv_lang["META_PAGE_TYPE"]             = "META Page-Type";
$pgv_lang["META_PAGE_TYPE_help"]        = "Contenu du champ 'Page-Type' (type de page) de la balise META à insérer dans l'entête de chaque page HTML.<br />Variable \$META_PAGE_TYPE du fichier config.php.";
$pgv_lang["META_ROBOTS"]                = "META Robots";
$pgv_lang["META_ROBOTS_help"]           = "Contenu du champ 'Robots' (instructions pour les robots) de la balise META à insérer dans l'entête de chaque page HTML.<br />Certains robots ne tiennent pas compte de cette balise.<br />Variable \$META_ROBOTS du fichier config.php.";
$pgv_lang["META_REVISIT"]               = "META Revisit";
$pgv_lang["META_REVISIT_help"]          = "Contenu du champ 'Revisit' (fréquence de revisite de la page) de la balise META à insérer dans l'entête de chaque page HTML.<br />Certains navigateurs ne tiennent pas compte de cette balise.<br />Variable \$META_REVISIT du fichier config.php.";
$pgv_lang["META_KEYWORDS"]              = "META Keywords";
$pgv_lang["META_KEYWORDS_help"]         = "Contenu du champ 'Keywords' (liste de mots clés) de la balise META à insérer dans l'entête de chaque page HTML.<br />La plupart des moteurs de recherche utilisent ces valeurs pour classer les pages.<br />Variable \$META_KEYWORDS du fichier config.php.";
$pgv_lang["META_SURNAME_KEYWORDS"]      = "Principaux noms de familles en mots-clés";
$pgv_lang["META_SURNAME_KEYWORDS_help"] = "Option pour ajouter les principaux noms de familles dans la balise HTML des mots-clés (META Keywords) pour une meilleure indexation par les moteurs de recherche.<br /><br />Variable \$META_SURNAME_KEYWORDS du fichier xxx.GED_conf.php.";
$pgv_lang["META_TITLE"]                 = "Complément balise TITLE";
$pgv_lang["META_TITLE_help"]            =	"Texte à ajouter au titre de chaque page HTML.<br />Variable \$META_TITLE du fichier config.php.";

#pgv_lang["ENABLE_RSS"]                 = "Enable RSS";
#pgv_lang["ENABLE_RSS_help"]            = "~#pgv_lang[ENABLE_RSS]#~<br /><br />This option lets you disable the RSS feature.<br /><br />RSS lets users monitor your site for changes to the Index page without actually visiting your site periodically.  If too many users make use of this feature or if the refresh frequency set by these users is too high, RSS can use up too much bandwidth or server capacity.<br />";
$pgv_lang["RSS_FORMAT"]                 = "Format RSS";
#pgv_lang["RSS_FORMAT_help"]            = "~#pgv_lang[RSS_FORMAT]#~<br /><br />The format of RSS to be used as the default RSS feed format for the site. The numeric suffixes <u>do not</u> indicate version, they identify formats.  For example, RSS 2.0 is not newer than RSS 1.0, but a different format. Feed readers should be able to read any format. There is currently no difference between ATOM and ATOM 0.3. Both use the ATOM 0.3 draft specification.<br />";
#pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"]= "Check for downloadable GEDCOM file";
#pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />For security reasons, the GEDCOM file should not be in a location where it can be directly downloaded, thus bypassing privacy checks. This check can cause performance problems on some servers.<br /><br />If you know that the GEDCOM file is in a server directory that is not directly accessible from the Internet, you can safely disable this check.<br />";

$pgv_lang["welcome_new"]                = "Bienvenue sur votre site PhpGedView. L'affichage de cette page signifie que PhpGedView a été correctement installé sur votre serveur. Vous pouvez lancer la configuration.<br />";
#pgv_lang["welcome_new2"]               = "<br /><br />Since you are seeing this page, you have successfully installed PhpGedView on your server and are ready to begin configuring it to your requirements.<br /><br />";
$pgv_lang["welcome_new_help"]           = "Cette fenêtre d'aide vous guidera pendant la configuration. Une aide vous sera fournie pour chaque champ. Vous pouvez fermer cette fenêtre, et la réouvrir à tout moment en cliquant sur le bouton d'aide derrière chaque champ.";
$pgv_lang["review_readme"]              = "Il est conseillé de consulter d'abord le fichier <a href=readme.txt target=_blank>readme.txt</a> avant de poursuivre la configuration de PhpGedView.<br /><br />";
$pgv_lang["return_editconfig"]          = "Vous pourrez revenir à cette configuration à tout moment en faisant pointer votre navigateur sur editconfig.php, ou par le lien <b>Configuration</b> du menu <b>Administration</b>.<br />";
$pgv_lang["return_editconfig_gedcom"]   = "Vous pourrez revenir à cette configuration à tout moment en faisant pointer votre navigateur sur editconfig_gedcom.php, ou par le lien <b>GEDCOM</b> du menu <b>Administration</b>.<br />";
$pgv_lang["save_config"]                = "Sauvegarder la configuration";
$pgv_lang["download_here"]              = "Charger le fichier sur votre système (<i>Download</i>).";
$pgv_lang["download_gedconf"]           = "Télécharger le fichier de configuration GEDCOM sur votre système (<i>Download</i>).";
$pgv_lang["not_writable"]               = "Votre fichier de configuration est protégé contre l'écriture pour PHP. Vous pouvez utiliser le bouton de téléchargement pour sauvegarder vos données dans un fichier que vous transfèrerez manuellement.";
$pgv_lang["download_file"]              = "Télécharger le fichier sur votre système (<i>Download</i>)";
$pgv_lang["upload_to_index"]            = "Télécharger le fichier sur le serveur (<i>Upload</i>) dans le répertoire : ";
#pgv_lang["import_sql"]                 = "SQL files have been found in your index directory. Since they may have originated from the User Migration tool, you have the option to import the information into your database. Do you wish to attempt importing these files into your database now? All existing user-related information (users, news, favorites, block layouts, and messages) in your database will be lost.<br /><br />If you choose to proceed, PhpGedView will attempt to import the data. If this is not successful, you will be asked to make the first administrator account anyway.<br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"]               = "Règles de confidentialité";
$pgv_lang["edit_privacy_title"]         = "Modifier les règles de confidentialité";
$pgv_lang["PRIV_PUBLIC"]                = "Montrer à tout le monde";
$pgv_lang["PRIV_USER"]                  = "Montrer uniquement aux utilisateurs authentifiés";
$pgv_lang["PRIV_NONE"]                  = "Montrer uniquement à l'administrateur";
$pgv_lang["PRIV_HIDE"]                  = "Ne montrer à personne";
$pgv_lang["save_changed_settings"]      = "Enregistrer les modifications";
$pgv_lang["add_new_pp_setting"]         = "Ajouter une nouvelle règle";
$pgv_lang["add_new_up_setting"]         = "Ajouter une nouvelle règle";
$pgv_lang["add_new_gf_setting"]         = "Ajouter une nouvelle règle";
$pgv_lang["add_new_pf_setting"]         = "Ajouter une nouvelle règle";
$pgv_lang["file_read_error"]            = "Impossible de lire le fichier de confidentialité!";
$pgv_lang["edit_exist_person_privacy_settings"]= "Modifier les paramètres";
$pgv_lang["edit_exist_user_privacy_settings"]= "Modifier les paramètres";
$pgv_lang["edit_exist_global_facts_settings"]= "Modifier les règles sur les évènements";
$pgv_lang["edit_exist_person_facts_settings"]= "Modifier les paramètres";
$pgv_lang["general_privacy"]            = "Restrictions d'accès";
$pgv_lang["general_privacy_help"]       = "<b>#pgv_lang[general_settings]#.</b><br />Paramètre par défaut pour ce fichier GEDCOM.<br /><br />Si vous avez chargé plusieurs fichiers GEDCOM sur votre site, chacun peut avoir ses propres paramètres.<br /><br />Certains paramètres sont modifiables sur la page #pgv_lang[edit_privacy_title]#.<br />#pgv_lang[more_config_help]#";
$pgv_lang["person_privacy"]             = "Restriction d'accès selon l'individu";
$pgv_lang["person_privacy_help"]        = "<b>#pgv_lang[person_privacy_settings]#.</b><br />Permet à l'administrateur de forcer une règle de confidentialité pour un <b>individu</b> particulier. Pour un enfant mort par exemple. Par défaut, les détails le concernant sont visibles par tous, puisqu'il s'agit d'une personne décédée. Pour masquer ces informations sans supprimer l'enregistrement du décès, il suffit d'ajouter une règle.<br /><br />Variable \$person_privacy du fichier de confidentialité.";
$pgv_lang["user_privacy"]               = "Restriction d'accès selon l'utilisateur";
$pgv_lang["user_privacy_help"]          = "<b>#pgv_lang[user_privacy_settings]#.</b><br />Permet à l'administrateur de forcer une règle de confidentialité pour un <b>utilisateur</b> particulier.<br /><br />Variable \$user_privacy du fichier de confidentialité.";
$pgv_lang["global_facts"]               = "Restriction d'accès selon l'évènement";
$pgv_lang["global_facts_help"]          = "<b>#pgv_lang[global_facts_settings]#.</b><br />Permet à l'administrateur de forcer une règle de confidentialité pour un <b>évènement</b> particulier.<br /><br />Variable \$global_facts du fichier de confidentialité.";
$pgv_lang["person_facts"]               = "Restriction d'accès selon l'évènement et l'individu";
$pgv_lang["person_facts_help"]          = "<b>#pgv_lang[person_facts_settings]#.</b><br />Permet à l'administrateur de forcer une règle de confidentialité pour un <b>évènement et un individu</b> particuliers.<br /><br />Variable \$person_facts du fichier de confidentialité.";
$pgv_lang["accessible_by"]              = "Montrer à qui ?";
$pgv_lang["hide"]                       = "Cacher";
$pgv_lang["show_question"]              = "Montrer ?";
$pgv_lang["user_name"]                  = "Nom de l'utilisateur";
$pgv_lang["name_of_fact"]               = "Code de l'évènement";
$pgv_lang["choice"]                     = "Montrer quoi ?";
$pgv_lang["fact_show"]                  = "Montrer l'évènement";
$pgv_lang["fact_details"]               = "Montrer les détails de l'évènement";
$pgv_lang["privacy_header"]             = "Modifier les paramètres";
$pgv_lang["unable_to_find_privacy_indi"]= "Aucun résultat pour l'id";
$pgv_lang["save_and_import"]            = "Après la sauvegarde de cette configuration, il vous reste à faire l'<b>import</b> du fichier GEDCOM.";
$pgv_lang["help_info"]                  = "Pour obtenir de l'aide sur un champ, cliquer sur le '?' juste derrière ce champ.";
$pgv_lang["SHOW_LIVING_NAMES"]          = "Montrer les noms des personnes en vie";
$pgv_lang["SHOW_LIVING_NAMES_help"]     = "#pgv_lang[SHOW_LIVING_NAMES]#<br /><br />Variable \$SHOW_LIVING_NAMES du fichier de confidentialité.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]    = "Montrer l'assistant de recherche";
#pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />What type of user can view the research assistant module if it is installed?<br /><br />This sets \$SHOW_RESEARCH_ASSISTANT in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]   = "Autoriser l'accès aux détails privés des proches";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]= "#pgv_lang[USE_RELATIONSHIP_PRIVACY]#<br /><br />Option désactivée : les utilisateurs authentifiés peuvent voir les détails de toutes les personnes vivantes.<br />Option activée : accès aux détails privés des proches uniquement.<br /><br />Variable \$USE_RELATIONSHIP_PRIVACY du fichier de confidentialité.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]   = "Degré de parenté pour l'accès aux détails privés";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]= "#pgv_lang[MAX_RELATION_PATH_LENGTH]#<br /><br />Variable \$MAX_RELATION_PATH_LENGTH du fichier de confidentialité.<br /><br />Si l'option #pgv_lang[USE_RELATIONSHIP_PRIVACY]# est activée, les utilisateurs authentifiés auront accès aux détails des individus dans la limite de ce degré de parenté.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]   = "Vérifier les liens par mariage";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]= "Accès aux détails privés des proches par alliance.<br /><br />Variable \$CHECK_MARRIAGE_RELATIONS du fichier de confidentialité.";
$pgv_lang["SHOW_DEAD_PEOPLE"]           = "Montrer les personnes décédées";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]      = "Niveau de confidentialité pour toutes les personnes décédées";
$pgv_lang["select_privacyfile_button"]  = "Choix d'un fichier de Confidentialité";
$pgv_lang["PRIVACY_BY_YEAR"]            = "Restriction par ancienneté d'évènement";
$pgv_lang["PRIVACY_BY_YEAR_help"]       = "L'option #pgv_lang[PRIVACY_BY_YEAR]# permet de masquer les détails pour les individus selon l'âge qu'ils avaient à un évènement donné, qu'ils soient décédés depuis ou pas.<br /><br />Si l'âge maximum est défini à 100 ans, on peut ainsi masquer toutes les personnes, vivantes ou non, nées depuis moins de 100 ans, mariées depuis moins de 85 ans, ou décédées depuis moins de 75 ans.<br /><br />Avertissement : cette option peut ralentir fortement les temps de réponse.<br /><br />Variable \$PRIVACY_BY_YEAR du fichier de confidentialité.";

//-- language edit utility
$pgv_lang["enable_disable_lang"]        = "Configurer les langues";
$pgv_lang["translator_tools"]           = "Outils de traduction";
#pgv_lang["lang_edit_help"]             = "~#pgv_lang[translator_tools]#~<br /><br />This page is intended to be used by translators.  You can translate, compare, and export language files.  There is also an option to help translators determine the origin of text that is output by PhpGedView.<br /><br />You can use the following options and utilities:<br />";
$pgv_lang["edit_langdiff"]              = "Editer le contenu des fichiers de traduction";
$pgv_lang["bom_check"]                  = "Utilitaire de suppression du BOM";
$pgv_lang["bom_check_help"]             = "Cet outil effectue la suppression du BOM* dans les fichiers de langues.<br />*BOM = Byte Order Mark : 3 octets ajoutés au tout début d'un fichier par certains éditeurs de texte. Ce marqueur sert à mémoriser le format du fichier (ANSI, UTF-8...). La présence du BOM provoque une erreur d'affichage PHP, il est donc nécessaire de le supprimer.";
#pgv_lang["bom_check_desc"]             = "This check will analyze all the language files for the BOM (Byte Order Mark). If found, it will remove the BOM from the affected file. These special codes can cause malfunctions in some parts of PhpGedView.";
#pgv_lang["lang_debug"]                 = "Help Text Debug Option";
#pgv_lang["lang_debug_help"]            = "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
#pgv_lang["lang_debug_desc"]            = "When you enable this option, the names of the language variables used in help text will print in the help text popup window.  This will help translators determine the variable name when text needs to be adjusted.<br /><br />This setting will only be valid during your current PhpGedView session.";
#pgv_lang["lang_debug_use"]             = "Use Help Text Debug Option";
$pgv_lang["bom_not_found"]              = "Aucun BOM trouvé.";
$pgv_lang["bom_found"]                  = "BOM supprimé du fichier ";
$pgv_lang["edit_lang_utility"]          = "Utilitaire d'édition des fichiers de traduction";
$pgv_lang["edit_lang_utility_help"]     = "Utilitaire pour modifier le contenu d'un fichier de traduction en vous appuyant sur le contenu de la version anglaise.<br />Le programme vous listera le contenu du fichier de la version anglaise originale et celui de la version à traduire <br />Après avoir cliqué sur le message que vous voulez traduire une nouvelle fenêtre qui s'ouvrira vous permettra de modifier et de sauvegarder votre traduction du message dans la langue choisie.";
#pgv_lang["edit_lang_utility_desc"]     = "You can use this utility to edit the contents of a language file by using the contents of the English one.<br /><br />You will see the contents of the original English language file and the contents of the same file type (there are four of these) in your chosen language.  You click on the message text shown below the English version.  This opens a new window where you can modify the text.  You can save the changes or abandon them.";
$pgv_lang["edit_lang_utility_warning"]  = "ATTENTION!<br />Le bouton <i>#pgv_lang[close_window_without_refresh]#</i> oblige à recharger la page pour afficher les modifications.<br />N'utilisez ce bouton qu'avec précaution.";
$pgv_lang["language_to_edit"]           = "Traduction en";
#pgv_lang["language_to_edit_help"]      = "~#pgv_lang[language_to_edit]#~<br /><br />In this list box you select the language whose messages you want to edit.<br />";
$pgv_lang["file_to_edit"]               = "Type de fichier à traduire";
#pgv_lang["file_to_edit_help"]          = "~#pgv_lang[file_to_edit]#~<br /><br />PhpGedView has implemented support for many different languages.  This has been achieved by keeping all text that is visible to users in files completely separate from the main program.  There is a set of five files for each supported language, and the various texts have been separated into one of these files according to function.  When a given text is not yet available in translated form, PhpGedView will use the English version.<br /><br />The files in each language set are:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;This file contains terms, common expressions, and Help text for use during configuration of PhpGedView.  The Help text is not intended to be viewed by ordinary users.</li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;This is a list of country names, taken from the Web site of the Statistics Division, United Nations Department of Economic and Social Affairs.  This is the relevant <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> to the English list.  The list is available in either English or French.</li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;This file contains the textual equivalents of the GEDCOM Fact codes found in the GEDCOM 5.5.1 Standard.  It also contains additional Fact codes not found in the Standard but used by various genealogy programs.<br /><br />An English copy of the <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> can be downloaded in PDF (Portable Document Format).</li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;This file contains Help text for ordinary users.  Some Help topics in this file address the needs of administrators, and are hidden from users who do not have Admin rights.</li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Many terms and common expressions are found in this file.</li></ul>";
$pgv_lang["check"]                      = "Vérifier";
$pgv_lang["lang_save"]                  = "Sauvegarder";
$pgv_lang["contents"]                   = "Contenu";
$pgv_lang["listing"]                    = "Liste";
$pgv_lang["no_content"]                 = "Vide";
$pgv_lang["editlang"]                   = "Modifier";
$pgv_lang["editlang_help"]              = "Editer un message du fichier";
$pgv_lang["cancel"]                     = "Annuler";
$pgv_lang["savelang"]                   = "Enregistrer";
$pgv_lang["savelang_help"]              = "Sauvegarder le message";
$pgv_lang["original_message"]           = "Message original";
$pgv_lang["message_to_edit"]            = "Message à éditer";
$pgv_lang["changed_message"]            = "Valeur modifiée";
$pgv_lang["message_empty_warning"]      = "-> Avertissement!!! Message vide dans le fichier [#LANGUAGE_FILE#] <-";
$pgv_lang["language_to_export"]         = "Langage à exporter";
#pgv_lang["language_to_export_help"]    = "~#pgv_lang[language_to_export]#~<br /><br />From this list box you can select the language whose messages you want to export.<br /><br />The routine currently only exports the contents of the <i>configure_help_text.php</i> file.  The output is an HTML file that you can print from your browser.<br />";
$pgv_lang["export_lang_utility"]        = "Utilitaire d'export du fichier langue";
$pgv_lang["export"]                     = "Exporter";
$pgv_lang["export_lang_utility_help"]   = "Ce module permet de choisir une langue et d'exporter le contenu du fichier d'aide pour obtenir une documentation.";
#pgv_lang["export_lang_utility_desc"]   = "You can create documentation for administrators.<br /><br />This utility will produce an HTML version of the Configuration Help file in the selected language.  You can use your browser to look at this file, which is formatted for printing.";
$pgv_lang["export_ok"]                  = "Les messages d'aide ont été exportés";
$pgv_lang["compare_lang_utility"]       = "Utilitaire de comparaison de fichiers de langues";
$pgv_lang["compare_lang_utility_help"]  = "Ce module affiche les écarts entre deux fichiers de langues.<br />Voir également le fichier [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>].";
#pgv_lang["compare_lang_utility_desc"]  = "This utility will compare two sets of language files to produce a list of the additions and subtractions between them.<br /><br />Read also the file <a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a> for changes to the English version.  The English files should be used as the reference from which all others are produced.";
$pgv_lang["new_language"]               = "Langue 1";
#pgv_lang["new_language_help"]          = "~#pgv_lang[new_language]#~<br /><br />From this list box you can select the language whose messages you want to compare with those of another language.<br /><br />All changes and additions to language files are first made to the <b>English</b> language files, so you would normally select English as one of the languages to compare.<br />";
$pgv_lang["old_language"]               = "Langue 2";
#pgv_lang["old_language_help"]          = "~#pgv_lang[old_language]#~<br /><br />From this list box you can select the language which you want to compare with the language selected in the <b>Source</b> list box.<br /><br />After you have made your choice, click the <b>Compare</b> button to get a list of all additions and subtractions in all four files of both languages.<br /><br />To refresh your memory:<br /><b>Addition</b> means: It is <u>in</u> the Source file, but <u>not</u> in the Secondary file.<br /><br /><b>Subtraction</b> means: It is <u>not</u> in the Source file, but it <u>is</u> in the Secondary file.  This might happen when a given message is no longer used and therefore was removed from the English files.  You can safely remove the corresponding message from the secondary language files.<br />";
$pgv_lang["compare"]                    = "Comparaison";
$pgv_lang["comparing"]                  = "Fichiers comparés ";
$pgv_lang["additions"]                  = "Ajouts";
$pgv_lang["no_additions"]               = "Aucun ajout";
$pgv_lang["subtractions"]               = "Suppressions";
$pgv_lang["no_subtractions"]            = "Aucune suppression";
$pgv_lang["config_lang_utility"]        = "Configuration des langues supportées";
$pgv_lang["config_lang_utility_help"]   = "Ce module vous aide à configurer les langues utilisables avec PhpGedView.<br />Attention : au premier changement, PhpGedView va créer un nouveau fichier <tt>lang_settings.php</tt> dans le répertoire <tt>#INDEX_DIRECTORY#</tt>.<br />Ensuite PhpGedView utilisera uniquement ce fichier.<br />Par conséquent, pour tout problème relatif à une langue, merci de préciser que vous utilisez un fichier modifié de votre répertoire <tt>#INDEX_DIRECTORY#</tt>.";
$pgv_lang["active"]                     = "Actif";
$pgv_lang["active_help"]                = "Permet de choisir une autre langue, si l'administrateur l'autorise.";
$pgv_lang["edit_settings"]              = "Editer les préférences";
$pgv_lang["lang_edit"]                  = "Editer";
$pgv_lang["lang_language"]              = "Langue";
$pgv_lang["export_filename"]            = "Nom du fichier d'export";
$pgv_lang["lang_back"]                  = "Retour au menu des langues";
$pgv_lang["lang_back_admin"]            = "Retour au menu Administrateur";
$pgv_lang["lang_back_manage_gedcoms"]   = "Retour au menu administration GEDCOM";
$pgv_lang["lang_name_czech"]            = "Tchèque";
$pgv_lang["lang_name_chinese"]          = "Chinois";
$pgv_lang["lang_name_danish"]           = "Danois";
$pgv_lang["lang_name_dutch"]            = "Hollandais";
$pgv_lang["lang_name_english"]          = "Anglais";
$pgv_lang["lang_name_finnish"]          = "Finnois";
$pgv_lang["lang_name_french"]           = "Français";
$pgv_lang["lang_name_german"]           = "Allemand";
$pgv_lang["lang_name_hebrew"]           = "Hébreu";
$pgv_lang["lang_name_hungarian"]        = "Hongrois";
$pgv_lang["lang_name_italian"]          = "Italien";
$pgv_lang["lang_name_norwegian"]        = "Norvégien";
$pgv_lang["lang_name_polish"]           = "Polonais";
$pgv_lang["lang_name_portuguese"]       = "Portugais";
$pgv_lang["lang_name_portuguese-br"]    = "Portugais Brésilien";
$pgv_lang["lang_name_russian"]          = "Russe";
$pgv_lang["lang_name_spanish"]          = "Espagnol";
$pgv_lang["lang_name_spanish-ar"]       = "Espagnol Sud Américain";
$pgv_lang["lang_name_swedish"]          = "Suédois";
$pgv_lang["lang_name_turkish"]          = "Turc";
$pgv_lang["lang_name_greek"]            = "Grec";
$pgv_lang["lang_name_arabic"]           = "Arabe";
$pgv_lang["lang_name_lithuanian"]       = "Lituanien";
$pgv_lang["lang_name_vietnamese"]       = "Vietnamien";
$pgv_lang["lang_name_slovak"]           = "Slovaque";
$pgv_lang["lang_new_language"]          = "Nouvelle Langue";
$pgv_lang["original_lang_name"]         = "Nom d'origine de la langue en #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]    = "Comment se nomme cette langue dans cette langue ?<br /><br />En anglais, l'anglais se nomme : English<br />En allemand, l'allemand se nomme : Deutsch<br />etc.";
$pgv_lang["lang_shortcut"]              = "Raccourci pour les fichiers de langues";
$pgv_lang["lang_shortcut_help"]         = "Raccourci du code langue dans PhpGedView.<br />Habituellement il s'agit du premier code dans le fichier des 'Codes de Langues' à définir dans le champ suivant.";
$pgv_lang["lang_langcode"]              = "Codes de langue";
$pgv_lang["lang_langcode_help"]         = "Ces codes permettent à PhpGedView de détecter la langue par défaut du navigateur. Séparateur : ';'";
$pgv_lang["lang_filenames"]             = "Fichiers de langues";
$pgv_lang["lang_filenames_help"]        = "PhpGedView a été prévu pour fonctionner avec différentes langues. Les textes sont issus de fichiers indépendants du programme lui-même. Chacune des langues comporte 5 fichiers. Si l'un d'eux est manquant c'est le fichier en anglais qui est utilisé.<br /><br />Liste des fichiers :<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Termes et expressions utilisés pour la configuration de PhpGedView.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Liste des codes et noms de pays.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Traduction des codes GEDCOM.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Textes d'aide.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Autres termes et expressions.</li></ul>|";
$pgv_lang["flagsfile"]                  = "Fichier image du drapeau";
$pgv_lang["flagsfile_help"]             = "Nom et chemin d'accès au fichier image du drapeau pour cette langue.";
$pgv_lang["text_direction"]             = "Sens du texte";
$pgv_lang["text_direction_help"]        = "Sens de l'écriture dans la langue choisie.<br /><br />Habituellement les langues occidentales s'écrivent de gauche à droite (LTR).<br />D'autres langues, comme l'hébreu, s'écrivent de droite à gauche (RTL).";
$pgv_lang["date_format"]                = "Format de date";
$pgv_lang["date_format_help"]           = "Format de date pour la langue choisie.<br /><br /><b>1. Format Standard</b><br />Valeurs possibles :<br />D pour le jour (Day)<br />M pour le mois (Month)<br />Y pour l'année (Year).<br /><br />Vous pouvez changer l'ordre des champs et ajouter des séparateurs.<br /><br />La valeur standard est 'D M Y', qui signifie qu'une date d'un enregistrement GEDCOM comme 'DATE 20 Nov 1965' s'affichera dans PhpGedView '20 Novembre 1965'.<br /><br />Les Allemands préfèrent 'D. M Y' qui affichera '20. November 1965'.<br /><br />Les Hongrois 'Y M D' qui affichera '1965 November 20'.<br /><br /><b>2. Format pour l'affichage du jour de la semaine</b><br />Pour afficher le jour de la semaine, même pour des dates très anciennes, utiliser :<br /><br />d - jour du mois, sur 2 chiffres avec les zéros : 01 à 31<br />D - jour de la semaine, sur 3 lettres : Lun, Mar...<br />F - mois, en toutes lettres : Janvier, Février...<br />j - jour du mois, sans les zéros : 1 à 31<br />l (L minuscule) - jour de la semaine, en toutes lettres : Lundi, Mardi...<br />M - mois, sur 3 lettres : Jan, Fév...<br />Y - année, sur 4 chiffres : 1999, 2000...<br />y - année, sur 2 chiffres : 99, 00...<br />R - ajout de la date au format du calendrier révolutionnaire<br />entre le 22 SEP 1792 et le 31 DEC 1805<br /><br />D j F Y affichera : Jeu 9 Janvier 1806<br />l d M Y affichera : Jeudi 09 Jan 1806<br />D j F Y R affichera : Ven 14 Décembre 1798 <u>24 Frimaire An 7</u>";
$pgv_lang["time_format"]                = "Format de l'heure";
$pgv_lang["time_format_help"]           = "Format d'affichage de l'heure dans la langue sélectionnée.<br /><br />Valeurs possibles :<br />a - Matin (Ante meridiem) ou Après-midi (Post meridiem) en minuscules - 'am' ou 'pm'<br />A - Matin (Ante meridiem) ou Après-midi (Post meridiem) en majuscules - 'AM' ou 'PM'<br />B - Heure 'Swatch Internet' de 000 à 999<br />c - Format ISO 8601 (ajouté en PHP 5) 2004-02-12T15:19:21+00:00<br />d - Jour du mois sur 2 chiffres de 01 à 31<br />D - Jour de la semaine sur 3 lettres de LUN à DIM<br />F - Nom complet du mois de Janvier à Décembre<br />g - Format 12-heures de 1 à 12<br />G - Format 24-heures de 0 à 23<br />h - Format 12-heures sur 2 chiffres de 01 à 12<br />H - Format 24-heures sur 2 chiffres de 00 à 23<br />i - Minutes sur 2 chiffres de 00 à 59<br />I - (i majuscule) Option de passage à l'heure d'été 1=oui 0=non.<br />j - Jour du mois de 1 à 31<br />l - (L minuscule) Nom du jour de la semaine de Dimanche à Samedi<br />L - Option année bissextile 1=oui 0=non.<br />m - Numéro du mois sur 2 chiffres de 01 à 12<br />M - Mois sur 3 lettres de JAN à DEC<br />n - Numéro du mois de 1 à 12<br />O - Ecart en heures avec Greenwich (GMT) Exemple: +0200<br />r - Format RFC 2822 Exemple: Thu, 21 Dec 2000 16:01:07 +0200<br />s - Secondes sur 2 chiffres de 00 à 59<br />S - Suffixe des premiers jours du mois sur 2 caractéres 1st, 2nd, 3rd or 4th. Fonctionne bien avec j<br />t - Nombre de jours du mois de 28 à 31<br />T - Fuseau horaire du serveur (Timezone) Exemples: CEST, EST, MDT ...<br />U - Secondes depuis l'heure zéro Unix (January 1 1970 00:00:00 GMT)<br />w - Indice du jour de la semaine de 0=Dimanche à 6=Samedi<br />W - Format ISO-8601 numéro de semaine de l'année, la semaine démarrant un Lundi (ajouté en PHP 4.1.0) Exemple: 42 (42ème semaine de l'année)<br />Y - Année sur 4 chiffres Exemples: 1999 ou 2003<br />y - Année sur 2 chiffres Exemples: 99 ou 03<br />z - Numéro du jour de l'année (premier jour :  0) de 0 à 365<br />Z - Décalage horaire en secondes. Valeur négative pour les zones Ouest UTC, positive pour les zones Est UTC. De -43200 à 43200<br /><br />Vous pouvez changer l'ordres de ces variables et y ajouter d'autres caractères.<br />Par exemple en Allemagne on écrira : 'H:i:s' qui donne quelque chose comme ceci : '09:01:25'.<br />Le standard en anglais est : 'g:i:sa' qui affiche : '9:01:25am'.";
$pgv_lang["week_start"]                 = "Premier jour de la semaine";
$pgv_lang["week_start_help"]            = "Jour de la semaine qui commence une nouvelle semaine dans cette langue. La plupart commencent par le Dimanche, certaines par le Lundi ou un autre jour.";
$pgv_lang["name_reverse"]               = "Surnom d'abord";
$pgv_lang["name_reverse_help"]          = "Option pour afficher le surnom en premier comme cela se fait dans certaines langues. Valeur par défaut : afficher le surnom en dernier";
$pgv_lang["ltr"]                        = "De gauche à droite (LTR)";
$pgv_lang["rtl"]                        = "De droite à gauche (RTL)";
$pgv_lang["file_does_not_exist"]        = "Le fichier n'existe pas...";
$pgv_lang["alphabet_upper"]             = "Alphabet des majuscules";
$pgv_lang["alphabet_upper_help"]        = "Alphabet des majuscules dans cette langue. Utilisé pour le tri des noms en majuscules.";
$pgv_lang["alphabet_lower"]             = "Alphabet des minuscules";
$pgv_lang["alphabet_lower_help"]        = "Alphabet des minuscules dans cette langue. Utilisé pour le tri des noms en minuscules.";
#pgv_lang["multi_letter_alphabet"]      = "Multi-letter alphabet";
#pgv_lang["multi_letter_alphabet_help"] = "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Multi-letter combinations that are to be treated as a single distinct letter when sorting lists of names and titles in this language.<br /><br />Some languages, Hungarian and Slovak for example, consider certain combinations of letters to be distinct letters in their own right.  The order in which you specify these letter combinations determines the order in which they are inserted into the normal alphabet during sorting.  This is important when several multi-letter combinations have the same first letter.  Except for <b>ch</b>, these letter combinations are inserted into the normal alphabet according to their first letter.  <b>ch</b> is always inserted after <b>h</b>.<br />";
#pgv_lang["dictionary_sort"]            = "Use dictionary rules while sorting";
#pgv_lang["dictionary_sort_help"]       = "~#pgv_lang[dictionary_sort]#~<br /><br />This option controls how characters with diacritic marks are handled when sorting lists of names and titles.<br /><br />When set to <b>#pgv_lang[yes]#</b>, all characters with diacritic marks are treated as if they did not have any marks.  Diacritic marks are considered only when the two words being considered are otherwise identical.  When set to <b>#pgv_lang[no]#</b>, all letters are distinct, regardless of the presence or absence of diacritic marks.<br />";
$pgv_lang["lang_config_write_error"]    = "Erreur d'écriture du fichier [language_settings.php]. Vérifier les droits d'accès et réessayer.";
$pgv_lang["translation_forum"]          = "Forum traduction";
$pgv_lang["translation_forum_help"]     = "Lien direct au forum des traductions de PhpGedView sur le serveur SourceForge où vous pourrez parler des problèmes spécifiques de traduction <tt>http://sourceforge.net/forum/forum.php?forum_id=294245</tt>";
#pgv_lang["translation_forum_desc"]     = "This <a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=\"_blank\"><b>link</b></a> opens a new browser window.  You will be redirected to the Translations forum of PhpGedView, where you can discuss translation topics.";
$pgv_lang["system_time"]                = "Heure du serveur";
$pgv_lang["gedcom_not_imported"]        = "Ce fichier GEDCOM n'a pas encore été chargé.";
$pgv_lang["lang_set_file_read_error"]   = "Erreur de lecture du fichier [language_settings.php]!";
$pgv_lang["add_new_language"]           = "Ajouter fichiers et paramètres pour une nouvelle langue";
$pgv_lang["add_new_language_help"]      = "Utilitaire pour ajouter une nouvelle langue à PhpGedView.<br />Merci de remplir tous les champs nécessaires dans la fenêtre suivante.<br />Après la création des fichiers, vous serez en mesure de modifier les messages pour cette nouvelle langue.";
#pgv_lang["add_new_language_desc"]      = "This routine lets you add a new, previously unavailable and completely unsupported language to PhpGedView.<br /><br />You can set up the standard settings of the new language.  These include language detection code, language direction, start of the week for this language, time settings, alphabet, etc.<br /><br />You will get more help on the settings of languages supported by PhpGedView after selecting the language and clicking the <b>#pgv_lang[add_new_lang_button]#</b> button.<br /><br />More help is available on the Configuration page for the language.<br />";
$pgv_lang["add_new_lang_button"]        = "Ajouter une nouvelle langue";
$pgv_lang["hide_translated"]            = "Cacher les traductions";
#pgv_lang["hide_translated_help"]       = "~#pgv_lang[hide_translated]#~<br /><br />If set to <b>Yes</b> you will only see those messages of your selected language file which have not been translated.  This means the new message does <u>not</u> appear in the target language file.<br /><br />Some language files contain English text for various untranslated messages.  This routine cannot identify these untranslated items, since they already are present in the target file.  The assumption is, \"If the message is present in the target file, it must have been translated.\"<br />";
$pgv_lang["lang_file_write_error"]      = "ERREUR !!!<br /><br />Impossible d'écrire dans le ficher de la langue!<br />Vérifier les droits d'accès du fichier (#lang_filename#)";
$pgv_lang["no_open"]                    = "E R R E U R !!!<br /><br />Impossible d'ouvrir le fichier #lang_filename#";
$pgv_lang["never"]                      = "Jamais";
$pgv_lang["users_total"]                = "Nombre total d'utilisateurs";
$pgv_lang["users_admin"]                = "Administrateurs du site";
$pgv_lang["users_unver"]                = "Non vérifié par l'utilisateur";
$pgv_lang["users_unver_admin"]          = "Non vérifié par l'administrateur";
$pgv_lang["users_langs"]                = "Langues des utilisateurs";
$pgv_lang["warn_users"]                 = "Utilisateurs en anomalie";
$pgv_lang["users_gedadmin"]             = "Administrateurs GEDCOM";
$pgv_lang["cleanup_users"]              = "Suppression des utilisateurs";
$pgv_lang["usr_no_cleanup"]             = "Rien à supprimer";
$pgv_lang["back_useradmin"]             = "Retour au menu Administration";
$pgv_lang["del_proceed"]                = "Continuer";
#pgv_lang["del_unveru"]                 = "User didn't verify within 7 days.";
#pgv_lang["del_unvera"]                 = "User not verified by administrator.";
#pgv_lang["del_gedrights"]              = "GEDCOM no longer active, remove user references.";
#pgv_lang["usr_idle"]                   = "Number of months since the last login for a user's account to be considered inactive: ";
#pgv_lang["usr_idle_toolong"]           = "User's account has been inactive too long: ";
#pgv_lang["usr_unset_rights"]           = "Unset GEDCOM rights for ";
#pgv_lang["usr_unset_rootid"]           = "Unset root ID for ";
#pgv_lang["usr_unset_gedcomid"]         = "Unset GEDCOM ID for ";
$pgv_lang["usr_deleted"]                = "Utilisateur supprimé: ";
$pgv_lang["configured_languages"]       = "Langues activées";
$pgv_lang["message_to_all"]             = "Envoi d'un message à tous les utilisateurs";
$pgv_lang["ip_address"]                 = "Adresse IP";
$pgv_lang["date_time"]                  = "Date et heure";
$pgv_lang["message"]                    = "Envoi de message";
$pgv_lang["searchtype"]                 = "Type de recherche";
$pgv_lang["type"]                       = "Type";
$pgv_lang["query"]                      = "Requête";


//-- User Migration Tool messages
$pgv_lang["um_header"]                  = "Exporter les comptes utilisateurs pour passage mode Index <-> mode SQL";
$pgv_lang["um_proceed"]                 = "Lancer l'export des comptes utilisateurs ?<br /><br />";
$pgv_lang["um_creating"]                = "Création";
#pgv_lang["um_sql_index"]               = "This tool will create <i>authenticate.php</i> and several <i>.dat</i> files in your index directory.<br /><br />After successful creation, you can switch to Index mode with all current users and their messages, favorites, news, and MyGedview layout available.<br /><br />Note: After switching to Index mode, you will need to import your GEDCOM files again.<br />";
$pgv_lang["um_file_create_fail1"]       = "Un fichier portant le même nom existe déjà :";
$pgv_lang["um_file_create_fail2"]       = "Création impossible";
$pgv_lang["um_file_create_fail3"]       = "Vérifier les droits d'écriture du répertoire.";
$pgv_lang["um_file_create_succ1"]       = "Création réussie :";
$pgv_lang["um_file_not_created"]        = "Echec à la création du fichier";
$pgv_lang["um_nomsg"]                   = "Aucun message trouvé.";
$pgv_lang["um_nofav"]                   = "Aucun favori trouvé.";
$pgv_lang["um_nonews"]                  = "Aucune nouvelle trouvée.";
$pgv_lang["um_noblocks"]                = "Aucun bloc trouvé.";
#pgv_lang["um_index_sql"]               = "This tool will import <i>authenticate.php</i> and other <i>.dat</i> files from your index directory into your database.<br />";
#pgv_lang["um_noaction"]                = "No action is required to migrate user information to SQL mode.<br /><br />Once switched to SQL mode, you need to restart the User Migration tool to import all data into the SQL database.  PhpGedView will use existing files from Index mode.<br /><br /><b>Do <u>not</u> remove <i>authenticate.php</i> and <i>.dat</i> files from your index directory while switching.</b><br />";
$pgv_lang["um_import"]                  = "Import";
$pgv_lang["um_export"]                  = "Export";
#pgv_lang["um_explain"]                 = "This tool will either export user data from SQL to Index mode, or import user data from Index files into SQL tables.<br /><br />User data, favorites, block definitions, messages, and news will be available again after migration.<br /><br /><b>CAUTION</b><br />You cannot use this tool to migrate user data between different versions of PhpGedView. Be sure that the data originates from, or is imported into the same PhpGedView version.<br /><br /><b>IMPORT</b><br />If you choose to import the user data files from Index mode, all user data present in the database tables will be <u>overwritten</u>. This tool does <u>not</u> merge the information. Once you have run the Import, there is no way to retrieve the old information using PhpGedView.<br /><br /><b>EXPORT</b><br />If you export the user information from your SQL database to Index Mode files, this tool will create <i>authenticate.php</i> and several <i>.dat</i> files in your index directory. If identically named files are already present, you will be prompted if they must be overwritten. After switching to Index mode, all information will be available directly.<br /><br /><b>Note:</b> After switching to Index mode, you will need to import your GEDCOM files again.<br />";
#pgv_lang["um_tool_help"]               = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
#pgv_lang["um_sql_index_help"]          = "~Migrate users from SQL to Index mode~<br /><br />#pgv_lang[um_sql_index]#";
#pgv_lang["um_index_sql_help"]          = "~Migrate users from Index to SQL mode~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"]               = "Import des utilisateurs";
$pgv_lang["um_imp_blocks"]              = "Import des blocs";
$pgv_lang["um_imp_favorites"]           = "Import des favoris";
$pgv_lang["um_imp_messages"]            = "Import des messages";
$pgv_lang["um_imp_news"]                = "Import des news";
$pgv_lang["um_nousers"]                 = "Fichier <i>authenticate.php</i> non trouvé. Opération annulée.";
$pgv_lang["um_imp_succ"]                = "Import réussi";
$pgv_lang["um_imp_fail"]                = "Echec de l'import !!!";
$pgv_lang["um_backup"]                  = "Sauvegarde";
$pgv_lang["um_zip_succ"]                = "Fichier ZIP créé.";
$pgv_lang["um_zip_dl"]                  = "Télécharger le fichier de sauvegarde ZIP ";
$pgv_lang["um_bu_explain"]              = "Avec cet outil, sauvegardez vos données PhpGedView dans un fichier ZIP que vous pourrez ensuite télécharger.";
#pgv_lang["um_bu_help"]                 = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"]               = "Fichier de configuration PhpGedView";
$pgv_lang["um_bu_gedcoms"]              = "Fichiers GEDCOM";
$pgv_lang["um_bu_gedsets"]              = "Fichiers de configuration";
$pgv_lang["um_bu_logs"]                 = "Journaux et compteurs";
$pgv_lang["um_bu_usinfo"]               = "Blocs, favoris, messages";
$pgv_lang["um_mk_bu"]                   = "Lancer la sauvegarde";
$pgv_lang["um_nofiles"]                 = "Aucun fichier à sauvegarder.";
$pgv_lang["um_files_exist"]             = "Un fichier existe déjà. Voulez-vous l'écraser ?";
$pgv_lang["um_results"]                 = "Resultats";
$pgv_lang["preview_faq_item"]           = "Prévisualiser FAQ";
#pgv_lang["preview_faq_item_help"]      = "~#pgv_lang[preview_faq_item]#~<br />This option lets an admin user view the FAQ page without all the editing options and links.<br /><br /> Except for a single <b>Edit</b> link above the first FAQ item, the appearance of the FAQ page will be identical to what an ordinary user would see. This special <b>Edit</b> link will restore full Edit functionality to the FAQ page.<br />";
#pgv_lang["restore_faq_edits"]          = "Restore FAQ edit functionality";
#pgv_lang["restore_faq_edits_help"]     = "~#pgv_lang[restore_faq_edits]#~<br />This option restores the FAQ page to what an admin user normally sees, so that individual FAQ items may be edited.<br />";
$pgv_lang["add_faq_item"]               = "Ajouter FAQ";
#pgv_lang["add_faq_item_help"]          = "~#pgv_lang[add_faq_item]#~<br />This option will let you add an item to the FAQ page.<br />";
$pgv_lang["edit_faq_item"]              = "Editer FAQ";
#pgv_lang["edit_faq_item_help"]         = "~#pgv_lang[edit_faq_item]#~<br />This option will let you edit an item on the FAQ page.<br />";
$pgv_lang["delete_faq_item"]            = "Supprimer FAQ";
#pgv_lang["delete_faq_item_help"]       = "~#pgv_lang[delete_faq_item]#~<br />This option will let you delete an item from the FAQ page<br />";
$pgv_lang["moveup_faq_item"]            = "Déplacer FAQ vers le haut";
#pgv_lang["moveup_faq_item_help"]       = "~#pgv_lang[moveup_faq_item]#~<br />This option will let you move an item upwards on the FAQ page.<br /><br />Each time you use this option, the FAQ Position number of this item is reduced by one.  You can achieve the same effect by editing the item in question and changing the FAQ Position field.  When more than one FAQ item has the same position number, only one of these items will be visible.<br />";
$pgv_lang["movedown_faq_item"]          = "Déplacer FAQ vers le bas";
#pgv_lang["movedown_faq_item_help"]     = "~#pgv_lang[movedown_faq_item]#~<br />This option will let you move an item downwards on the FAQ page.<br /><br />Each time you use this option, the FAQ Position number of this item is increased by one.  You can achieve the same effect by editing the item in question and changing the FAQ Position field.  When more than one FAQ item has the same position number, only one of these items will be visible.<br />";
#pgv_lang["add_faq_header_help"]        = "~FAQ Header~<br />This is the title or subject of the FAQ item.<br /><br />What you enter here can be formatted; HTML tags such as &lt;b&gt; and &lt;br&gt; are allowed, as are HTML entities such as &amp;amp; and &amp;nbsp;.  There is no way to enter HTML tags so that they will be interpreted as text.<br />";
#pgv_lang["add_faq_body_help"]          = "~FAQ Body~<br />The text of the FAQ item is entered here.<br /><br />The text can be formatted; HTML tags such as &lt;b&gt; and &lt;br&gt; are allowed, as are HTML entities such as &amp;amp; and &amp;nbsp;.  There is no way to enter HTML tags so that they will be interpreted as text.<br />";
#pgv_lang["add_faq_order_help"]         = "~FAQ Position~<br />This field controls the order in which the FAQ items are displayed.<br /><br />You do not have to enter the numbers sequentially.  If you leave holes in the numbering scheme, you can insert other items later.  For example, if you use the numbers 1, 6, 11, 16, you can later insert items with the missing sequence numbers.  Negative numbers and zero are allowed, and can be used to insert items in front of the first one.<br /><br />When more than one FAQ item has the same position number, only one of these items will be visible.<br />";
$pgv_lang["TIME_LIMIT_help"]            = "Temps maximal en secondes que PhpGedView est autorisé à consommer. La valeur par défaut est d'une minute.  Selon la taille de votre fichier GEDCOM, il peut être nécessaire d'augmenter cette valeur.  En codant une valeur de 0, vous supprimez la limite de temps d'exécution de PHP.<br />ATTENTION: En codant 0 ou en codant une valeur trop élevée vous pourrez causer le blocage de votre site sur certains systèmes d'exploitation jusqu'à la fin de l'exécution du script.  La valeur de 0 signifie qu'il pourrait ne jamais se terminer jusqu'à ce qu'un administrateur du serveur arrête le processus ou redémarre le serveur. La construction d'un grand arbre généalogique peut prendre un très long temps, et en laissant cette valeur aussi basse que possible vous serez certain que personne ne pourra bloquer le serveur de votre site en demandant la construction d'un arbre de 1000 générations.";

// Media items
#pgv_lang["media_import_help"]          = "~#pgv_lang[media_import]#~<br />This import will convert the multimedia links in your GEDCOM file to multimedia records. For example, the following media entry will be changed from:<blockquote><code>1 OBJE<br />2 FORM jpg<br />2 FILE media/grandma.jpg<br />2 TITL Picture of grandma</code></blockquote>to:<blockquote><code>0 @M1@ OBJE<br />1 FORM jpg<br />1 FILE media/grandma.jpg<br />1 TITL Picture of grandma</code></blockquote>The new multimedia record will be stored separately in the database. Links to external multimedia files will be changed to references to the new multimedia record, which will in turn contain a reference to the external file. For example, the following GEDCOM record will be changed from:<blockquote><code>0 @I1@ INDI<br />1 NAME Your/Name/<br />1 OBJE<br />2 FORM jpg<br />2 FILE media/grandma.jpg<br />2 TITL Picture of grandma</code></blockquote>to:<blockquote><code>0 @I1@ INDI<br />1 NAME Your/Name/<br />1 OBJE @M1@<br /></code></blockquote>The advantage of using multimedia records is that you can easily administer your media. When you change the title of a multimedia record, it is changed for all GEDCOM records that link to this multimedia record. Several people,families, or sources can be linked to the same multimedia record.";

?>
