/*  VER 028  TAB P   $Id: title.c,v 1.8 1998/09/09 07:32:15 src Exp $
 *
 *  set program title
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: title.c,v $
 *  Revision 1.8  1998/09/09 07:32:15  src
 *  Version 1.1
 *
 *  Revision 1.7  1998/09/03 02:49:31  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.6  1998/09/02 06:50:31  src
 *  newsx version 1.0
 *
 *  Revision 1.5  1998/08/24 06:17:15  src
 */

#include "common.h"
#include "tune.h"
#include "options.h"
#include "proto.h"

#ifdef PS_STATUS
static char      ttl_buf[512];          /* program name */
static char     *ttl_arg = 0;           /* status */
static char    **ttl_argv = 0;          /* pointer to argument vector */
static char     *ttl_lastargv = 0;      /* end of argv */
#endif

/*
 *  call this to use proctitle()
 *  does not destroy the argument list (yet)
 *  but they ARE destroyed when progtitle is called
 */
void 
begintitle(int argc, char **argv, char **envp)
{
#ifdef PS_STATUS
    /*
     *  set start and extent of argv for setproctitle
     *  does not use environment list 
     */
    ttl_argv = argv;
    ttl_lastargv = argv[argc - 1] + strlen(argv[argc - 1]);
#endif
}

/*
 *  set the program title 
 */
void 
settitle(char *name)
{
#ifdef PS_STATUS
    int n = strlen(name);
    if (n > sizeof(ttl_buf)-1) n = sizeof(ttl_buf) - 2;
    memcpy(ttl_buf,name,n);
    ttl_buf[n++] = ' ';
    ttl_buf[n] = '\0';
    ttl_arg = ttl_buf+n;
#endif
}

/*
 *  set the program title
 */
void 
progtitle2(char *what,char *more)
{
#ifdef PS_STATUS
     char *p;
     int i;

     if (!ttl_argv || !ttl_arg || no_ps) return;

     /* make heading */
     strcpy(ttl_arg,what);
     if (more) strcat(ttl_arg,more);

     i = strlen(ttl_buf);

     if (i > ttl_lastargv-ttl_argv[0]-2) {
	 i = ttl_lastargv-ttl_argv[0]-2;
	 ttl_buf[i] = '\0';
     }
     strcpy(ttl_argv[0], ttl_buf);
     /* pad remainder */
     p = &ttl_argv[0][i];
     while (p < ttl_lastargv)
	 *p++ = '\0';
#endif
     if (debug_opt >= 4) {
	  log_msg(L_INFO, "state: %s%s", what, more?more:"");
     }
}

/*
 *  set the program title
 */
void 
progtitle(char *what)
{
    progtitle2(what,"");
}

