#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <qdatetime.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qsettings.h>
#include <qdir.h>
#include <qmessagebox.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <math.h>
#include <qgrid.h>
#include <qbuttongroup.h>
#include <qdatetime.h>

#include "../dissipate2/sdp.h"
#include "../dissipate2/sipmessage.h"
#include "../dissipate2/mimecontenttype.h"
#include "../dissipate2/sipuser.h"
#include "../dissipate2/sipcall.h"
#include "../dissipate2/siptransaction.h"
#include "ksipauthentication.h"
#include "callaudio.h"
#include "kphone.h"
#include "kphoneview.h"
#include "kcallwidget.h"

KCallTransfer::KCallTransfer( QWidget *parent, const char *name )
	: QDialog( parent, name, true )
{
	QVBox *vbox = new QVBox( this );
	vbox->setMargin( 3 );
	vbox->setSpacing( 3 );
	QVBoxLayout *vboxl = new QVBoxLayout( this, 5 );
	vboxl->addWidget( vbox );

	(void) new QLabel( tr("Transfer to URI:"), vbox );
	touri = new QLineEdit( vbox );
	touri->setMinimumWidth( fontMetrics().maxWidth() * 20 );

	QHBoxLayout *buttonBox;
	buttonBox = new QHBoxLayout( vboxl, 6 );
	helpPushButton = new QPushButton( this, tr("help button") );
	helpPushButton->setText( tr("&help...") );
	helpPushButton->setEnabled( FALSE );
	buttonBox->addWidget( helpPushButton );
	QSpacerItem *spacer = new QSpacerItem(
		0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
	buttonBox->addItem( spacer );
	okPushButton = new QPushButton( this, tr("ok button") );
	okPushButton->setText( tr("OK") );
	okPushButton->setDefault( TRUE );
	buttonBox->addWidget( okPushButton );
	cancelPushButton = new QPushButton( this, tr("cancel button") );
	cancelPushButton->setText( tr("Cancel") );
	cancelPushButton->setAccel( Key_Escape );
	buttonBox->addWidget( cancelPushButton );
	connect( okPushButton, SIGNAL( clicked() ),
		this, SLOT( slotOk() ) );
	connect( cancelPushButton, SIGNAL( clicked() ),
		this, SLOT( slotCancel() ) );
}

KCallTransfer::~KCallTransfer( void )
{
}

void KCallTransfer::slotOk( void )
{
	if( touri->text().stripWhiteSpace() != QString::null ) {
		pleaseTransfer( touri->text() );
	}
	touri->clear();
	QDialog::accept();
}

void KCallTransfer::slotCancel( void )
{
	touri->clear();
	QDialog::reject();
}

KCallWidget::KCallWidget( KSipAuthentication *auth, CallAudio *callaudio, SipCall *initcall,
		QWidget *parent, const char *name )
	: QDialog( parent, name, FALSE, WStyle_DialogBorder ), call( initcall )
{
	sipauthentication = auth;
	missedCalls.setAutoDelete( true );
	receivedCalls.setAutoDelete( true );
	hided = false;
	phoneBook = 0;
	curstate = PreDial;
	member = 0;
	transfer = 0;

	createKeypad();

	audio = callaudio;
	connect( audio, SIGNAL( outputDead() ),
		this, SLOT( audioOutputDead() ) );
	connect( audio, SIGNAL( statusUpdated() ),
		this, SLOT( updateAudioStatus() ) );

	ringCount = 0;
	ringTimer = new QTimer();
	connect( ringTimer, SIGNAL( timeout() ),
		this, SLOT( ringTimeout() ) );
	acceptCallTimer = new QTimer();
	connect( acceptCallTimer, SIGNAL( timeout() ),
		this, SLOT( acceptCallTimeout() ) );

	QVBoxLayout *vbox = new QVBoxLayout( this );
	vbox->setMargin( 3 );
	vbox->setSpacing( 3 );

	QGridLayout *headergrid = new QGridLayout( 2, 3 );
	headergrid->setSpacing( 3 );

	vbox->insertLayout( 0, headergrid );

	// Remote (person we're calling)
	QLabel *remotelabel = new QLabel( tr("Remote: "), this );
	remotelabel->setFixedWidth(
		remotelabel->fontMetrics().width( tr("  Remote:  ")  ) );
	headergrid->addWidget( remotelabel, 0, 0 );
	remote = new QComboBox( true, this );
	remote->setAutoCompletion( true );

	headergrid->addWidget( remote, 0, 1 );

	// Remember to give remote completion
	int count = 0;
	QString s;
	QString remoteuri;
	QSettings settings;
	QString p = "/kphone/" + getUserPrefix() + "/Call register";
	QString label = p + "/Dialled" + s.setNum( count );
	remoteuri = settings.readEntry( label, "" );
	while( !remoteuri.isEmpty() && count < 20 ) {
		remote->insertItem( remoteuri );
		label = p + "/Dialled" + s.setNum( ++count );
		remoteuri = settings.readEntry( label, "" );
	}
	QPushButton *loadUri = new QPushButton( "", this );
	QIconSet icon;
	icon.setPixmap(SHARE_DIR "/icons/phonebook.png", QIconSet::Automatic );
	loadUri->setIconSet( icon );
	loadUri->setFixedWidth( loadUri->fontMetrics().maxWidth() * 2 );
	connect( loadUri, SIGNAL( clicked() ), this, SLOT( getUri() ) );
	headergrid->addWidget( loadUri, 0, 2 );
	QHBox *statline = new QHBox( this );
	statline->setSpacing( 5 );
	vbox->insertWidget( 1, statline );
	QLabel *statlabel = new QLabel( tr("Status: "), statline );
	statlabel->setFixedWidth( remotelabel->width() );
	curstat = new QLabel( statline );
	QLabel *astatlabel = new QLabel( tr("Audio: "), statline );
	astatlabel->setFixedWidth( remotelabel->width() );
	curaudiostat = new QLabel( statline );
	QGrid *buttonbox = new QGrid(2, this );
	buttonbox->setSpacing( 5 );
	vbox->insertWidget( 2, buttonbox );
	dial = new QPushButton( tr("Dial"), buttonbox );
	QIconSet icon1;
	icon1.setPixmap(SHARE_DIR "/icons/dial.png", QIconSet::Automatic );
	dial->setIconSet( icon1 );
	connect( dial, SIGNAL( clicked() ), this, SLOT( dialClicked() ) );
	dial->setEnabled( true );
	dial->setFocus();
	hangup = new QPushButton( tr("Hangup"), buttonbox );
	QIconSet icon2;
	icon2.setPixmap(SHARE_DIR "/icons/hangup.png", QIconSet::Automatic );
	hangup->setIconSet( icon2 );
	connect( hangup, SIGNAL( clicked() ), this, SLOT( hangupCall() ) );
	hangup->setEnabled( false );
	holdbutton = new QPushButton( tr("Hold"), buttonbox );
	connect( holdbutton, SIGNAL( clicked() ), this, SLOT( holdCall() ) );
	transferbutton = new QPushButton( tr("Transfer"), buttonbox );
	connect( transferbutton, SIGNAL( clicked() ),
		this, SLOT( showTransferDialog() ) );
	morebutton = new QPushButton( tr("DTMF"), buttonbox );
	morebutton->setToggleButton(true);
	morebutton->setOn( false );
	connect( morebutton, SIGNAL( toggled(bool) ),
		this, SLOT( showExtension(bool)));
	hidebutton = new QPushButton( tr("Hide"), buttonbox );
	connect( hidebutton, SIGNAL( clicked() ), this, SLOT( hideCall() ) );
	QDateTime dt;
	int year,month,day,hour,min,sec;
	count = 0;
	p = "/kphone/" + getUserPrefix() + "/Call register";
	label.setNum( count );
	label = p + "/Received" + label;
	s = settings.readEntry( label, "" );
	while( !s.isEmpty() ) {
		year = s.left( s.find( '.' ) ).toInt();
		s = s.mid( s.find( '.' ) + 1 );
		month = s.left( s.find( '.' ) ).toInt();
		s = s.mid( s.find( '.' ) + 1 );
		day = s.left( s.find( '-' ) ).toInt();
		s = s.mid( s.find( '-' ) + 1 );
		hour = s.left( s.find( ':' ) ).toInt();
		s = s.mid( s.find( ':' ) + 1 );
		min = s.left( s.find( ':' ) ).toInt();
		s = s.mid( s.find( ':' ) + 1 );
		sec = s.left( s.find( '[' ) ).toInt();
		dt.setDate( QDate( year, month, day ) );
		dt.setTime( QTime( hour, min, sec ) );
		s = s.left( s.find( ']' ) );
		s = s.mid( s.find( '[' ) + 1 );
		incomingCall = new IncomingCall( s, dt );
		receivedCalls.append( incomingCall );
		label.setNum( ++count );
		label = p + "/Received" + label;
		s = settings.readEntry( label, "" );
	}
	count = 0;
	label.setNum( count );
	label = p + "/Missed" + label;
	s = settings.readEntry( label, "" );
	while( !s.isEmpty() ) {
		year = s.left( s.find( '.' ) ).toInt();
		s = s.mid( s.find( '.' ) + 1 );
		month = s.left( s.find( '.' ) ).toInt();
		s = s.mid( s.find( '.' ) + 1 );
		day = s.left( s.find( '-' ) ).toInt();
		s = s.mid( s.find( '-' ) + 1 );
		hour = s.left( s.find( ':' ) ).toInt();
		s = s.mid( s.find( ':' ) + 1 );
		min = s.left( s.find( ':' ) ).toInt();
		s = s.mid( s.find( ':' ) + 1 );
		sec = s.left( s.find( '[' ) ).toInt();
		dt.setDate( QDate( year, month, day ) );
		dt.setTime( QTime( hour, min, sec ) );
		s = s.left( s.find( ']' ) );
		s = s.mid( s.find( '[' ) + 1 );
		incomingCall = new IncomingCall( s, dt );
		missedCalls.append( incomingCall );
		label.setNum( ++count );
		label = p + "/Missed" + label;
		s = settings.readEntry( label, "" );
	}
	switchCall( initcall );
}

KCallWidget::~KCallWidget( void )
{
	delete ringTimer;
	delete acceptCallTimer;
	missedCalls.clear();
	receivedCalls.clear();
	if( call ) {
		delete call;
	}
	if( transfer ) {
		delete transfer;
	}
	if( phoneBook ) {
		delete phoneBook;
	}
	if (keypad) {
		delete keypad;
	}
}

void KCallWidget::createKeypad(void)
{
	QGrid* grid;
	setOrientation(Qt::Vertical);
	grid = new QGrid(3);
	grid->setMargin(30);
	keypad = new QButtonGroup();
	keypad->insert(new QPushButton("1\n ", grid));
	keypad->insert(new QPushButton("2\nABC", grid));
	keypad->insert(new QPushButton("3\nDEF", grid));
	keypad->insert(new QPushButton("4\nGHI", grid));
	keypad->insert(new QPushButton("5\nJKL", grid));
	keypad->insert(new QPushButton("6\nMNO", grid));
	keypad->insert(new QPushButton("7\nPQRS", grid));
	keypad->insert(new QPushButton("8\nTUV", grid));
	keypad->insert(new QPushButton("9\nWXYZ", grid));
	keypad->insert(new QPushButton("*\n ", grid));
	keypad->insert(new QPushButton("0\n ", grid));
	keypad->insert(new QPushButton("#\n ", grid));
	connect(keypad, SIGNAL( pressed(int) ), this, SLOT( keypadPressed(int) ));
	connect(keypad, SIGNAL( released(int) ), this, SLOT( keypadReleased(int) ));
	setExtension(grid);
}

void KCallWidget::keypadPressed( int id )
{
	char code = 0;
	switch(id) {
		case 0: code = '1'; break;
		case 1: code = '2'; break;
		case 2: code = '3'; break;
		case 3: code = '4'; break;
		case 4: code = '5'; break;
		case 5: code = '6'; break;
		case 6: code = '7'; break;
		case 7: code = '8'; break;
		case 8: code = '9'; break;
		case 9: code = '*'; break;
		case 10: code = '0'; break;
		case 11: code = '#'; break;
	}
	audio->startDTMF(code);
}

void KCallWidget::keypadReleased( int id )
{
	audio->stopDTMF();
}

void KCallWidget::setRemote( QString newremote )
{
	remote->setEditText( newremote );
}

SipCall *KCallWidget::getCall()
{
	return call;
}

void KCallWidget::switchCall( SipCall *newcall )
{
	ringTimer->stop();
	printf( "KCallWidget: Switching calls...\n" );
	call = newcall;
	audio->setBodyMask( call->getSdpMessageMask() );
	dial->setText( tr("Dial") );
	hangup->setText( tr("Hangup") );
	if( member ) disconnect( member, 0, this, 0 );
	member = call->getMemberList().toFirst();
	if( member ) {
		if( member->getState() == SipCallMember::state_Disconnected ) {
			forceDisconnect();
			return;
		}
		if( member->getState() == SipCallMember::state_Redirected ) {
			handleRedirect();
			return;
		}
		curstat->setText( member->getLocalStatusDescription() );
		connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
			this, SLOT( callMemberStatusUpdated() ) );
		setCaption( getUserPrefix() + QString( tr("Call: ") ) + call->getCallId() );
		if( call->getSubject() == tr("Incoming call") ) {
			if( call->getCallType() == SipCall::videoCall ) {
				setCaption( getUserPrefix() +
					QString( tr("Incoming Video Call: ") ) + call->getCallId() );
				holdbutton->setEnabled( false );
				transferbutton->setEnabled( false );
			} else {
				setCaption( getUserPrefix() +
					QString( tr("Incoming Call: ") ) + call->getCallId() );
				holdbutton->setEnabled( true );
				transferbutton->setEnabled( true );
			}
			QString ss = member->getUri().uri();
			QDateTime t = QDateTime::currentDateTime();
			incomingCall = new IncomingCall( ss, t );
			missedCalls.append( incomingCall );
			updateCallRegister();

			// Ringing tone
			QSettings settings;
			QString p = "/kphone/General/";
			isRingingTone = ( settings.readEntry(
				p + "/ringingtone", "No" ).upper() == "YES" );

			ringCount = 0;
			ringTimer->start( ringTime_1, TRUE );
		}
		remote->setEditText( member->getUri().uri() );
		subject = call->getSubject();
		hangup->setEnabled( true );
		hangup->setFocus();
		if( member->getState() == SipCallMember::state_InviteRequested ) {
			hidebutton->setEnabled( false );
			dial->setEnabled( false );
			hangup->setEnabled( true );
			curstate = Calling;
		} else if( member->getState() == SipCallMember::state_RequestingInvite ) {
			dial->setText( tr("Accept") );
			hangup->setText( tr("Reject") );
			hidebutton->setEnabled( false );
			dial->setEnabled( true );
			hangup->setEnabled( true );
			curstate = Called;
		} else {
			hidebutton->setEnabled( false );
			dial->setEnabled( false );
			hangup->setEnabled( true );
			curstate = Connected;
		}
	} else {
		curstat->setText( QString::null );
		if( call->getCallType() == SipCall::videoCall ) {
			setCaption( getUserPrefix() +
				QString( tr("Outgoing Video Call: ") ) + call->getCallId() );
			holdbutton->setEnabled( false );
			transferbutton->setEnabled( false );
		} else {
			setCaption( getUserPrefix() +
				QString( tr("Outgoing Call: ") ) + call->getCallId() );
			holdbutton->setEnabled( true );
			transferbutton->setEnabled( true );
		}
		subject = call->getSubject();
		remote->setEditText( QString::null );
		hidebutton->setEnabled( true );
		dial->setEnabled( true );
		dial->setFocus();
		hangup->setEnabled( false );
		curstate = PreDial;
	}
	updateAudioStatus();
}

void KCallWidget::dialClicked( void )
{
	// Multi-purpose buttons hack
	if( curstate == Called ) {
		missedCalls.setAutoDelete( false );
		missedCalls.remove( incomingCall );
		missedCalls.setAutoDelete( true );
		receivedCalls.append( incomingCall );
		updateCallRegister();
		acceptCall();
		return;
	}
	if( remote->currentText().length() == 0 ) {
		QMessageBox::critical( this, tr("Error: No Destination"),
			tr("You must specify someone to call.") );
		return;
	}
/* #ALSA
	if( !audio->isAudioOn() ) {
		audio_fd = ::open( audio->getOSSFilename(), O_WRONLY | O_NONBLOCK );
		if( audio_fd == -1 ) {
			QMessageBox::information( this, tr("Dial"),
				tr("Close any program which might be using soundcard \nand then retry dial.") );
			return;
		} else {
			::close( audio_fd );
		}
	}
*/
	QString strRemoteUri;
	QString s = remote->currentText();
	if( s.contains( '[' ) && s.contains( ']' ) ) {
		strRemoteUri = s.mid( s.find( '[' ) + 1, s.find( ']' ) - s.find( '[' ) - 1 );
	} else {
		if( s.left( 4 ).lower() != "tel:" ) {
			if( s.left( 4 ).lower() != "sip:" ) {
				s = "sip:" + s;
			}
			if( !s.contains( '@' ) ) {
				s = s + "@" + call->getHostname();
			}
		}
		strRemoteUri = s;
	}
	for( int i = 0; i < remote->count(); i++ ) {
		if( remote->text( i ).compare( s ) == 0 ) {
			remote->removeItem( i );
		}
	}
	remote->insertItem( s, 0 );
	remote->setCurrentItem( 0 );
	QSettings settings;
	QString p = "/kphone/" + getUserPrefix() + "/Call register/";
	QString str;
	QString label;
	for( int i = 0; i < remote->count(); i++ ) {
		label = p + "/Dialled" + str.setNum( i );
		settings.writeEntry( label, remote->text(i).latin1() );
	}
	label = p + "/Dialled" + str.setNum( remote->count() );
	settings.writeEntry( label, "" );
	SipUri remoteuri( strRemoteUri );
	audio->setRtpCodec( codecUnknown );
	audio->setVideoRtpCodec( codecUnknown );
	member = new SipCallMember( call, remoteuri );
	connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
		this, SLOT( callMemberStatusUpdated() ) );
	connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
		sipauthentication, SLOT( authRequest( SipCallMember * ) ) );
	audio->setCurrentCall( call );
	member->requestInvite(
		audio->audioOut().message( audio->getRtpCodec(), audio->getVideoRtpCodec(), audio->getBodyMask() ),
		MimeContentType( "application/sdp" ) );
	connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
		this, SLOT( callMemberStatusUpdated( ) ) );
	audio->attachToCallMember( member );
	hidebutton->setEnabled( false );
	dial->setEnabled( false );
	hangup->setEnabled( true );
	curstate = Calling;
	curstat->setText( member->getLocalStatusDescription() );
}

void KCallWidget::callMemberStatusUpdated( void )
{
	SdpMessage sdpm;
	SdpMessage rsdp;
	if( member->getState() == SipCallMember::state_Disconnected ) {
		if( member->getLocalStatusDescription().left( 2 ) == "!!" ) {
			curstat->setText( tr("Call Failed") );
			QMessageBox::critical( this, "KPhone",
				member->getLocalStatusDescription().remove(0,2) );
			setHide();
		} else {
			curstat->setText( member->getLocalStatusDescription() );
		}
		forceDisconnect();
	} else if( member->getState() == SipCallMember::state_Redirected ) {
		curstat->setText( member->getLocalStatusDescription() );
		handleRedirect();
	} else if( member->getState() == SipCallMember::state_Refer ) {
		curstat->setText( member->getLocalStatusDescription() );
		member->setState( SipCallMember::state_Refer_handling );
		handleRefer();
	} else if( member->getState() == SipCallMember::state_Connected ) {
		curstat->setText( member->getLocalStatusDescription() );
		hidebutton->setEnabled( false );
		dial->setEnabled( false );
		hangup->setEnabled( true );
		curstate = Connected;
	} else {
		curstat->setText( member->getLocalStatusDescription() );
	}
}

void KCallWidget::audioOutputDead( void )
{
	printf( "KCallAudio: Broken output pipe, disconnecting unpolitely\n" );
	forceDisconnect();
}

void KCallWidget::hangupCall( void )
{
	if( !hangup->isEnabled() ) {
		return;
	}
	ringTimer->stop();

	// Reject call if that's our current state
	if( curstate == Called ) {
		member->declineInvite();
		setHide();
		return;
	}
	if( call->getCallStatus() != SipCall::callDead ) {
		hangup->setEnabled( false );
		if( member->getState() == SipCallMember::state_Connected ) {
			member->requestDisconnect();
		} else {
			member->cancelTransaction();
			if( audio->getCurrentCall() == call ) {
				audio->detachFromCall();
			}
		}
		setHide();
		return;
	}
}

void KCallWidget::acceptCall( void )
{
	ringTimer->stop();
	acceptCallTimer->start( acceptTime, true );
}

void KCallWidget::holdCall( void )
{
	if( audio->getCurrentCall() == call ) {
		audio->toggleOnHold();
		holdbutton->setText( tr("Unhold") );
	} else if( member ) {
		audio->setCurrentCall( call );
		audio->attachToCallMember( member );
		audio->toggleOnHold();
		holdbutton->setText( tr("Hold") );
	}
}

void KCallWidget::handleRedirect( void )
{
	printf( "KCallWidget: Handling redirect...\n" );
	QValueList<SipUri>::Iterator it;
	SipUriList urilist = member->getRedirectList();
	while ( urilist.getListLength() > 0 ) {
		SipUri redirto = urilist.getPriorContact();
		QMessageBox mb( tr("Redirect"),
			tr("Call redirected to: ") + "\n" + redirto.reqUri() + "\n\n" +
			tr("Do you want to proceed ? "),
			QMessageBox::Information,
			QMessageBox::Yes | QMessageBox::Default,
			QMessageBox::No,
			QMessageBox::Cancel | QMessageBox::Escape );
		switch( mb.exec() ) {
		case QMessageBox::No:
			continue;
		case QMessageBox::Cancel:
			forceDisconnect();
			return;
		}
		if( audio->getCurrentCall() == call ) {
			audio->detachFromCall();
		}
		if( member ) disconnect( member, 0, this, 0 );
		member = 0;
		if( call ) delete call;
		call = 0;
		redirectCall( redirto, subject );
		setHide();
		return;
	}
	forceDisconnect();
}

void KCallWidget::handleRefer( void )
{
	printf( "KCallWidget: Handling redirect...\n" );
	SipUri redirto = member->getRedirectList().getHead();
	if( audio->getCurrentCall() == call ) {
		audio->detachFromCall();
	}
	QMessageBox mb( tr("Redirect"),
		tr("Call redirected to: ") + "\n" + redirto.reqUri() + "\n\n" +
		tr("Do you want to proceed ? "),
		QMessageBox::Information,
		QMessageBox::Yes | QMessageBox::Default,
		QMessageBox::No,
		0 );
	if( mb.exec() == QMessageBox::Yes ) {
		redirectCall( redirto, subject );
		setHide();
	} else {
		forceDisconnect();
	}
}

void KCallWidget::forceDisconnect( void )
{
	printf( "KCallWidget: Starting force disconnect...\n" );
	if( audio->getCurrentCall() == call ) {
		audio->detachFromCall();
	}
	if( member ) disconnect( member, 0, this, 0 );
	member = 0;
	if( call ) delete call;
	call = 0;
	callDeleted();
	ringTimer->stop();
	setHide();
}

void KCallWidget::updateAudioStatus( void )
{
	if( audio->getCurrentCall() == call ) {
		if( audio->isRemoteHold() )
			curaudiostat->setText( tr("Attached [holding]") );
		else
			curaudiostat->setText( tr("Attached [active]") );
	} else {
		curaudiostat->setText( tr("Unattached") );
	}
}

void KCallWidget::clickDial()
{
	dialClicked();
}

void KCallWidget::clickHangup()
{
	hangupCall();
}

void KCallWidget::pleaseDial( const SipUri &dialuri )
{
	remote->setEditText( dialuri.reqUri() );
	dialClicked();
}

void KCallWidget::showTransferDialog( void )
{
	if( !transfer ) {
		transfer = new KCallTransfer;
		connect( transfer, SIGNAL( pleaseTransfer( const QString & ) ),
			this, SLOT( pleaseTransfer( const QString & ) ) );
	}
	transfer->show();
}

void KCallWidget::pleaseTransfer( const QString &transferto )
{
	// Ignore this button if there is no call setup yet.
	if( curstate != Connected ) return;
	if( call->getCallStatus() != SipCall::callDead ) {
		hangup->setEnabled( false );
		hidebutton->setEnabled( true );
		QString s = transferto;
		if( s.left( 4 ).lower() != "tel:" ) {
			if( s.left( 4 ).lower() != "sip:" ) {
				s = "sip:" + s;
			}
			if( !s.contains( '@' ) ) {
				s = s + "@" +  member->getUri().getHostname();  //call->getHostname();
			}
		}
		member->requestTransfer( SipUri( s ) );
		return;
	}
}

void KCallWidget::getUri( void )
{
	QSettings settings;
	QString p = "/kphone/" + getUserPrefix() + "/Local";
	QString xmlFile = settings.readEntry( p + "/PhoneBook", "" );
	if( xmlFile.isEmpty() ) {
		if( getUserPrefix().isEmpty() ) {
			xmlFile = QDir::homeDirPath() + "/.kphone-phonebook.xml";
		} else {
			xmlFile = QDir::homeDirPath() +
				"/.kphone" + getUserPrefix() + "phonebook.xml";
		}
	}
	QStringList r;
	if( !phoneBook ) {
		phoneBook = new PhoneBook(xmlFile, this, getUserPrefix() + "Phone Book", receivedCalls, missedCalls, r );
	}
	phoneBook->exec();
	remote->setEditText( phoneBook->getUri() );
	((KPhoneView *)parentWidget())->updateContacts( xmlFile );
}

void KCallWidget::updateCallRegister( void )
{
	QString s, ss, s1, s2, s3;
	QTime t;
	QDate d;
	QString label;
	IncomingCall *c;
	IncomingCall *first;
	int count = 0;

	QSettings settings;
	QString p = "/kphone/" + getUserPrefix() + "/Call register/";

	label.setNum( count );
	label = p + "/Missed" + label;
	s = settings.readEntry( label, "" );
	while( !s.isEmpty() ) {
		settings.writeEntry( label, "");
		label.setNum( ++count );
		label = p + "/Missed" + label;
		s = settings.readEntry( label, "" );
	}
	count = 0;
	label.setNum( count );
	label = p + "/Received" + label;
	s = settings.readEntry( label, "" );
	while( !s.isEmpty() ) {
		settings.writeEntry( label, "");
		label.setNum( ++count );
		label = p + "/Received" + label;
		s = settings.readEntry( label, "" );
	}

	int i = 0;
	int last = receivedCalls.count();
	if ( last > 30 ) {
		first = receivedCalls.at( last - 30 );
	} else {
		first = receivedCalls.first();
	}
	for ( c = first; c != 0; c = receivedCalls.next() ) {
		label.setNum( i++ );
		label =  p + "/Received" + label;
		t = c->getDateTime().time();
		d = c->getDateTime().date();
		ss = s1.setNum( d.year() ) + "." + s2.setNum( d.month() ) +	"." + s3.setNum( d.day() ) + "-" + t.toString();
		settings.writeEntry( label, ss + " [" + c->getContact() + "]");
	}
	i = 0;
	last = missedCalls.count();
	if ( last > 30 ) {
		first = missedCalls.at( last - 30 );
	} else {
		first = missedCalls.first();
	}
	for ( c = first; c != 0; c = missedCalls.next() ) {
		label.setNum( i++ );
		label = p + "/Missed" + label;
		t = c->getDateTime().time();
		d = c->getDateTime().date();
		ss = s1.setNum( d.year() ) + "." + s2.setNum( d.month() ) +
			"." + s3.setNum( d.day() ) + "-" + t.toString();
		settings.writeEntry( label, ss + "[" + c->getContact() + "]");
	}
}


void KCallWidget::ringTimeout( void )
{
	if( isRingingTone ) {
		if( ringCount < 5 ) {
			ringCount++;
			audio_fd = ::open( audio->getOSSFilename(), O_WRONLY | O_NONBLOCK );
			if( audio_fd == -1 ) {
				printf( "ERROR: %s\n", "Open Failed" );
				return;
			}
			int flags = fcntl( audio_fd, F_GETFL );
			flags &= ~O_NONBLOCK;
			fcntl( audio_fd, F_SETFL, flags );
			int format = AFMT_S16_LE;
			if( ioctl( audio_fd, SNDCTL_DSP_SETFMT, &format ) == -1 ) {
				return;
			}
			if( format != AFMT_S16_LE ) {
				return;
			}
			int channels = 1;
			if( ioctl( audio_fd, SNDCTL_DSP_CHANNELS, &channels ) == -1 ) {
				return;
			}
			if( channels != 1 ) {
				return;
			}
			int rate = 8000;
			if( ioctl( audio_fd, SNDCTL_DSP_SPEED, &rate ) == -1 ) {
				return;
			}
			if( rate != 8000) {
				return;
			}
			int size = 4096;
			int samp = size/2;
			int ampl = 16384;
			unsigned char devbuf[size];
			int buf[samp];
			int i, p=0;
			double arg1, arg2;
			arg1 = (double)2 * (double)M_PI * (double)941 / (double)samp;
			arg2 = (double)2 * (double)M_PI * (double)1336 / (double)samp;
			for(int i = 0; i < samp; i++) {
				buf[i] = (short)((double)(ampl) * sin(arg1 * i) +
					(double)(ampl) * sin(arg2 * i));
			};
			for (i=0; i<samp; i+=2) {
				devbuf[p++] = (unsigned char)(buf[i] & 0xff);
				devbuf[p++] = (unsigned char)((buf[i] >> 8) & 0xff);
			}
			for(;;) {
				if( write( audio_fd, devbuf, samp ) != -1 ) {
					break;
				}
			}
			::close( audio_fd );
			ringTimer->start( ringTime_1, TRUE );
		} else {
			ringCount = 0;
			printf( "Ringing tone\n" );
			ringTimer->start( ringTime_2, TRUE );
		}
	}
}

void KCallWidget::acceptCallTimeout( void )
{
	if( !audio->isAudioOn() ) {
		if( isRingingTone ) {
		}
		audio_fd = ::open( audio->getOSSFilename(), O_WRONLY | O_NONBLOCK );
		if( audio_fd == -1 ) {
			QMessageBox::information( this, tr("Accept Call"),
				tr("Close any program which might be using soundcard \nand then retry accepting call.") );
			return;
		} else {
			::close( audio_fd );
		}
	}


	if( audio->checkCodec( member ) ) {
		audio->setCurrentCall( call );
		audio->attachToCallMember( member );
		member->acceptInvite(
			audio->audioOut().message( audio->getRtpCodec(),
				audio->getVideoRtpCodec(), audio->getBodyMask() ),
			MimeContentType( "application/sdp" ) );
		dial->setText( tr("Dial") );
		hangup->setText( tr("Hangup") );
		hidebutton->setEnabled( false );
		dial->setEnabled( false );
		hangup->setEnabled( true );
	} else {
		member->notAcceptableHere();
		QMessageBox::information( this, tr("Accept Call"),
			tr("Accepted codec not found.") );
	}
}

void KCallWidget::hideCall( void )
{
	if( curstate == PreDial ) {
		delete call;
		call = 0;
	}
	setHide();
}

QString KCallWidget::getUserPrefix( void )
{
	return ((KPhone *)parentWidget()->parentWidget())->getUserPrefix();
}

void KCallWidget::setHide( void )
{
	hided = true;
	hide();
}

KInstantMessageWidget::KInstantMessageWidget( KSipAuthentication *auth,
		SipCall *initcall, QWidget *parent, const char *name )
	: QDialog( parent, name ), imcall( initcall )
{
	sipauthentication = auth;
	phoneBook = 0;
	setCaption( getUserPrefix() + tr(" Message - KPhone") );
	QVBoxLayout *vbox = new QVBoxLayout( this );
	vbox->setMargin( 3 );
	vbox->setSpacing( 3 );
	QGridLayout *headergrid = new QGridLayout( 6, 3 );
	headergrid->setSpacing( 3 );
	vbox->insertLayout( 0, headergrid );
	QLabel *remotelabel = new QLabel( tr("Remote: "), this );
	remotelabel->setFixedWidth( remotelabel->fontMetrics().width( tr("  Remote:  ")  ) );
	headergrid->addWidget( remotelabel, 0, 0 );
	remote = new QComboBox( true, this );
	remote->setAutoCompletion( true );
	remote->setEditText( "" );
	headergrid->addWidget( remote, 0, 1 );
	QPushButton *loadUri = new QPushButton( "", this );
	QIconSet icon;
	icon.setPixmap(SHARE_DIR "/icons/phonebook.png", QIconSet::Automatic );
	loadUri->setIconSet( icon );
	loadUri->setFixedWidth( loadUri->fontMetrics().maxWidth() * 2 );
	connect( loadUri, SIGNAL( clicked() ), this, SLOT( getUri() ) );
	headergrid->addWidget( loadUri, 0, 2 );
	QLabel *slabel = new QLabel( tr("Status: "), this );
	vbox->insertWidget( 1, slabel );
	status = new QTextEdit( this );
	status->setReadOnly( true );
	vbox->insertWidget( 2, status );
	QLabel *mlabel = new QLabel( tr("Message: "), this );
	vbox->insertWidget( 3, mlabel );
	QGridLayout *mgrid = new QGridLayout( 1, 3 );
	mgrid->setSpacing( 3 );
	vbox->insertLayout( 4, mgrid );
	mEdit = new QTextEdit( this );
	mgrid->addWidget( mEdit, 0,0 );
	mEdit->setFocus();
	mbutton = new QPushButton( tr("Send"), this );
	mbutton->setFixedWidth( mbutton->fontMetrics().maxWidth() * 4 );
	connect( mbutton, SIGNAL( clicked() ), this, SLOT( mClicked() ) );
	mgrid->addWidget( mbutton, 0, 2 );
	QGrid *buttonbox = new QGrid(2, this );
	buttonbox->setSpacing( 5 );
	vbox->insertWidget( 5, buttonbox );
	(void) new QWidget( buttonbox );
	hidebutton = new QPushButton( tr("Hide"), buttonbox );
	connect( hidebutton, SIGNAL( clicked() ), this, SLOT( hide() ) );
	resize( 400, 200 );
}

KInstantMessageWidget::~KInstantMessageWidget( void )
{
	if( phoneBook ) {
		delete phoneBook;
	}
}

void KInstantMessageWidget::instantMessage( SipMessage *message )
{
	QString s = message->getHeaderData( SipHeader::From );
	SipUri u = SipUri( s );
	remote->setEditText( u.getUsername() + "@" + u.getHostname() );
	QString m = message->messageBody();
	status->setText( status->text() + "\n" + tr("Message received from ") + remote->currentText() );
	status->setText( status->text() + " (" + QTime::currentTime().toString().latin1() + ")" );
	status->setText( status->text() + "\n > " + m );
	status->scrollToBottom();
}

SipCall *KInstantMessageWidget::getCall()
{
	return imcall;
}

QString KInstantMessageWidget::getRemote()
{
	return remote->currentText();
}

void KInstantMessageWidget::setRemote( QString newremote )
{
	remote->setEditText( newremote );
}

void KInstantMessageWidget::mClicked( void )
{
	if( remote->currentText().length() == 0 ) {
		QMessageBox::critical( this, tr("Error: No Destination"),
			tr("You must specify someone to send message.") );
		return;
	}
	QString strRemoteUri;
	QString s = remote->currentText();
	if( s.contains( '[' ) && s.contains( ']' ) ) {
		strRemoteUri = s.mid( s.find( '[' ) + 1, s.find( ']' ) - s.find( '[' ) - 1 );
	} else {
		if( s.left( 4 ).lower() != "tel:" ) {
			if( s.left( 4 ).lower() != "sip:" ) {
				s = "sip:" + s;
			}
			if( !s.contains( '@' ) ) {
				s = s + "@" + imcall->getHostname();
			}
		}
		strRemoteUri = s;
	}
	for( int i = 0; i < remote->count(); i++ ) {
		if( remote->text( i ).compare( s ) == 0 ) {
			remote->removeItem( i );
		}
	}
	remote->insertItem( s, 0 );
	remote->setCurrentItem( 0 );
	SipUri remoteuri( strRemoteUri );
	member = new SipCallMember( imcall, remoteuri );
	connect( member, SIGNAL( statusUpdated( SipCallMember * ) ),
		sipauthentication, SLOT( authRequest( SipCallMember * ) ) );
	status->setText( status->text() + "\n" + tr("Message sent to ") + remote->currentText() );
	status->setText( status->text() + " (" + QTime::currentTime().toString().latin1() + ")" );
	status->setText( status->text() + "\n > " + mEdit->text() );
	status->scrollToBottom();

	member->requestMessage( mEdit->text(),
		MimeContentType( "text/plain; charset=UTF-8" ) );
	mEdit->clear();
}

void KInstantMessageWidget::getUri( void )
{
	QSettings settings;
	QString p = "/kphone/" + getUserPrefix() + "/local";
	QString xmlFile = settings.readEntry( p + "/PhoneBook", "" );
	if( xmlFile.isEmpty() ) {
		if( getUserPrefix().isEmpty() ) {
			xmlFile = QDir::homeDirPath() +
				"/.kphone-phonebook.xml";
		} else {
			xmlFile = QDir::homeDirPath() +
				"/.kphone" + getUserPrefix() + "phonebook.xml";
		}
	}
	QStringList r;
	if( !phoneBook ) {
		phoneBook = new PhoneBook( xmlFile, this,
			getUserPrefix() + "Phone Book",
			receivedCalls, missedCalls, r );
	}
	phoneBook->exec();
	remote->setEditText( phoneBook->getUri() );
	((KPhoneView *)parentWidget())->updateContacts( xmlFile );
}


QString KInstantMessageWidget::getUserPrefix( void )
{
	return ((KPhone *)parentWidget()->parentWidget())->getUserPrefix();
}
