/*
    KAppfinder, the KDE application finder

    Copyright (c) 2002-2003 Tobias Koenig <tokoe@kde.org>

    Based on code written by Matthias Hoelzer-Kluepfel <hoelzer@kde.org>

    This program is free software; you can redistribute it and/or
    modify it under the terms of version 2 of the GNU General Public
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <kcmdlineargs.h>
#include <kglobal.h>
#include <kinstance.h>
#include <klocale.h>
#include <kstandarddirs.h>

#include <qstringlist.h>

#include <stdio.h>

#include "common.h"


int main( int argc, char *argv[] )
{
  KInstance instance( "kappfinder_install" );
  int added = 0;

  if ( argc != 2 ) {
    fprintf( stderr, "Usage: kappfinder_install $directory\n" );
    return -1;
  }

  QStringList templates = KGlobal::dirs()->findAllResources( "data", "kappfinder/apps/*.desktop", true );

  QString dir = QString( argv[ 1 ] ) + "/";

  QPtrList<AppLnkCache> appCache;
  appCache.setAutoDelete( true );

  QStringList::Iterator it;
  for ( it = templates.begin(); it != templates.end(); ++it )
    scanDesktopFile( appCache, *it, dir );

  createDesktopFiles( appCache, added );
  decorateDirs( dir );

  appCache.clear();

  printf( "%i application(s) added\n", added );

  return 0;
}
