/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                                   *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 /*
  * Last modified: $Date: 2005/02/02 10:08:19 $ by $Author: juergenk $
  */
 
#include "startwindow.h"

#include <kiconview.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qhbox.h>

#include "startwindow.moc"

StartWindow::StartWindow(QWidget* parent, const char* name)
 : QWidget(parent, name), m_discIconsEnabled(true)
{
  QVBoxLayout* mainLayout = new QVBoxLayout(this);
  mainLayout->setAutoAdd(true);

  QHBox* hbox = new QHBox(this);
  QLabel* label1 = new QLabel(hbox);
  label1->setPaletteBackgroundColor(QColor(0,0,0));
  label1->setPixmap(KGlobal::iconLoader()->loadIcon("kaffeine", KIcon::Desktop, 48));
  label1->setFixedSize(QSize(70, 80));
  label1->setMargin(10);
  QLabel* label2 = new QLabel(hbox);
  label2->setPaletteBackgroundColor(QColor(0,0,0));
  label2->setText(QString("<font color=\"White\"><h1>Kaffeine Player ") + VERSION + "</h1></font>");
  
  KIconView* iconView = new KIconView(this);
  iconView->setArrangement(QIconView::TopToBottom);
  iconView->setMargin(5);
  iconView->setSpacing(10);
  iconView->setItemsMovable(false);
  iconView->setResizeMode(QIconView::Adjust);
  KIconViewItem* item = NULL;
  item = new KIconViewItem(iconView, i18n("Play Playlist"), KGlobal::iconLoader()->loadIcon("player_play", KIcon::Desktop));
  item->setKey("1");
  item = new KIconViewItem(iconView, i18n("Open Files"), KGlobal::iconLoader()->loadIcon("fileopen", KIcon::Desktop));
  item->setKey("2");
  item = new KIconViewItem(iconView, i18n("Open URL"), KGlobal::iconLoader()->loadIcon("www", KIcon::Desktop));
  item->setKey("3");
  item = new KIconViewItem(iconView, i18n("Open Directory"), KGlobal::iconLoader()->loadIcon("folder_video", KIcon::Desktop));
  item->setKey("4");
  item = new KIconViewItem(iconView, i18n("Open DVD"), KGlobal::iconLoader()->loadIcon("dvd_unmount", KIcon::Desktop));
  item->setKey("5");
  item = new KIconViewItem(iconView, i18n("Open VCD"), KGlobal::iconLoader()->loadIcon("cdrom_unmount", KIcon::Desktop));
  item->setKey("6");
  item = new KIconViewItem(iconView, i18n("Open Audio-CD"), KGlobal::iconLoader()->loadIcon("cdaudio_unmount", KIcon::Desktop));
  item->setKey("7");
  connect(iconView, SIGNAL(executed(QIconViewItem*)), this, SLOT(slotItemExecuted(QIconViewItem*)));
}


StartWindow::~StartWindow()
{
}

void StartWindow::enableDiscIcons(bool enable)
{
  m_discIconsEnabled = enable;
}  

void StartWindow::slotItemExecuted(QIconViewItem* item)
{
  uint key = item->key().toUInt();
  
  if ((!m_discIconsEnabled) && (key > 4))
    return;
  
  switch (key)
  {
    case 1: emit signalPlaylistPlay(); break;
    case 2: emit signalOpenFile(); break;
    case 3: emit signalOpenURL(); break;
    case 4: emit signalOpenDirectory(); break;
    case 5: emit signalOpenDVD(); break;
    case 6: emit signalOpenVCD(); break;
    case 7: emit signalOpenAudioCD(); break;
    default: return;
  }  
}



