/**
 * Provides the javascript for the contacts.php script
 *
 * $Horde: imp/js/src/contacts.js,v 1.6.2.4 2008/05/20 16:33:02 slusarz Exp $
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

// The following variables are defined in contacts.php:
//   display, formname, to_only

function changeDisplay()
{
    var d = $('display')

    if ($F(d) != display) {
        display = $F(d);

        $('search_results', 'selected_addresses').invoke('childElements').flatten().each(function(e) {
            var temp = e.value;
            if (!temp) {
                return;
            }

            e.value = encodeURIComponent(e.text);
            e.update(decodeURIComponent(temp));
        });
    }
}

function passAddresses()
{
    var sa = '';

    $('selected_addresses').childElements().each(function(s) {
        if (!s.value) {
            return;
        }
        sa += s.value + '|' + s.text + '|';
    });

    $('sa').setValue(sa);
}

function sameOption(f, item, itemj)
{
    var t = f + ": " + item.text,
        tj = itemj.text,
        v = f + ": " + item.value,
        vj = itemj.value;

    return Try.these(
        function() {
            return ((t == tj) || (decodeURIComponent(t) == decodeURIComponent(tj))) &&
                ((v == vj) || (decodeURIComponent(v) == decodeURIComponent(vj)));
        },
        // Catch exception with NS 7.1
        function() {
            return (t == tj && v == vj);
        }
    );
}

function addAddress(f)
{
    var s = $('search_results');

    if (!$F(s).size()) {
        alert(IMP.text.contacts_select);
        return false;
    } else {
        var d = $('selected_addresses'), l = $A(d).length;
        s.childElements().each(function(i) {
            if (i.value && i.selected) {
                if (!$A(d).any(function(j) {
                    return sameOption(f, i, j);
                })) {
                    d[l++] = new Option(f + ': ' + i.text, f + ': ' + i.value);
                }
            }
        });
    }

    return true;
}

function updateMessage()
{
    if (parent.opener.closed) {
        alert(IMP.text.contacts_closed);
        this.close();
        return;
    }

    if (!parent.opener.document[formname]) {
        alert(IMP.text.contacts_called);
        this.close();
        return;
    }

    $('selected_addresses').childElements().each(function(s) {
        var address, f, fullname, field = null, pos, v;
        if (display == "name") {
            address = decodeURIComponent(s.value);
            fullname = s.text;
        } else {
            address = s.text;
            fullname = decodeURIComponent(s.value);
        }
        pos = address.indexOf(':');
        f = address.substring(0, pos);

        if (f == 'to') {
            field = parent.opener.document[formname].to;
        } else if (!to_only && f == 'cc') {
            field = parent.opener.document[formname].cc;
        } else if (!to_only && f == 'bcc') {
            field = parent.opener.document[formname].bcc;
        } else {
            return;
        }

        fullname = fullname.substring(pos + 2, fullname.length).replace(/\\/g, '\\\\').replace(/"/g, '\\"');

        if (address.substring(pos + 2, address.length).indexOf(',') > 0) {
            address = fullname + ': ' + address.substring(pos + 2, address.length) + ';';
        } else {
            address = '"' + fullname + '" <' + address.substring(pos + 2, address.length) + '>';
        }

        // Always delimit with commas.
        if (field.value.length) {
            v = field.value.replace(/, +/g, ',').split(',').findAll(function(s) { return s; });
            v.push(address);
            field.value = v.join(', ');
        } else {
            field.value = address;
        }
        if (address.lastIndexOf(';') != address.length - 1) {
            field.value += ', ';
        }
    });

    this.close();
}

function removeAddress()
{
    $('selected_addresses').childElements().each(function(o) {
        if (o.selected) {
            o.remove();
        }
    });
}
