#ifndef __PROTO_H_
#define __PROTO_H_ 1

#include "hypermail.h"

/*
** Date functions - date.c
*/

long convtoyearsecs(char *date);
char *getlocaltime(void);
void gettimezone(void);
void getthisyear(void);
char *getdatestr(long yearsecs);
char *secs_to_iso(time_t t);
time_t iso_to_secs(char *s);

/*
** domains.c
*/
int valid_root_domain(char *eaddr);


/*
** file.c functions
*/

int isfile(char *path);
void check1dir(char *dir);
void checkdir(char *dir);
char *getfilecontents(char *filename);
char *add_char(char *ptr, char member_char);
char *add_string(char *ptr, char *member_str);
char *dirpath(char *frmptr);

void dump_config(char *mbox, char *label, char *dir, 
                 char *archives, char *about, int overwrite, 
                 int increment, char *defaultindex, int);
void readconfigs(char *path, int);


/*
** hypermail.c functions
*/
void version(void);
void progerr(char *);
void cmderr(char *errorstr);
void usage(void);

/*
** lang.c function
*/
char **valid_language(char *lg);

/*
** lock.c functions
*/
void lock_archive(char *dir);
void unlock_archive(void);

/*
** mem.c function
*/
void *emalloc(int);

/*
** string.c functions
*/
char *PushByte(struct Push *push, char byte);
char *PushString(struct Push *push, char *append);
char *PushNString(struct Push *push, char *append, int size);

char *strsav(char *s);
char *strreplace(char *present, char *replace);
void strcpymax(char *dest, char *src, int n);
char *strcasestr(char *haystack, char *needle);
char *stripzone(char *date);
int  numstrchr(char *s, char c);
char *getvalue(char *line);
char *getconfvalue(char *line, char *var, char *value);
char *unre(char *subject);
char *oneunre(char *subject);
char *rmcr(char *line);
int  isquote(char *line);
char *replace(char *string, char *oldpiece, char *newpiece);
char *replacechar(char *string, char old, char *replace);
char *convchars(char *line);
char *unconvchars(char *line);
char *makemailcommand(char *mailcommand, char *email, char *id, char *subject);
char *parseemail(char *input, char *mid, char *msubject);
char *parseurl(char *input);


#ifdef lint
int isspace();
int isalpha();
int isalnum();
int isxdigit();
#endif

#endif

