/*
 *	HT Editor
 *	ia64opc.cc
 *
 *	Copyright (C) 1999-2002 Sebastian Biallas (sb@web-productions.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "global.h"
#include "ia64opc.h"

IA64Template IA64Templates[] = {
	{0, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}},
	{3, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}},
	{2, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}}, // ?
	{2, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}},

	{0, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_L_UNIT|IA64_INST_ROLE_LONG, IA64_SLOT_X_UNIT|IA64_INST_ROLE_LONG}},
	{3, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_L_UNIT|IA64_INST_ROLE_LONG, IA64_SLOT_X_UNIT|IA64_INST_ROLE_LONG}},

	{0, {IA64_SLOT_INVALID}},
	{0, {IA64_SLOT_INVALID}},

	{0, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}},
	{3, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}},

	{1, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}},
	{1, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}}, // ?

	{0, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_F_UNIT|IA64_INST_ROLE_FP, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}},
	{3, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_F_UNIT|IA64_INST_ROLE_FP, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT}},
	
	{0, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_F_UNIT|IA64_INST_ROLE_FP}},
	{3, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_F_UNIT|IA64_INST_ROLE_FP}},

	{0, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR}},
	{3, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_I_UNIT|IA64_INST_ROLE_INT, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR}},
	
	{0, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR}},
	{3, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR}},

	{0, {IA64_SLOT_INVALID}},
	{0, {IA64_SLOT_INVALID}},

	{0, {IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR}},
	{3, {IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR}},

	{0, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_B_UNIT}},
	{3, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_B_UNIT}},

	{0, {IA64_SLOT_INVALID}},
	{0, {IA64_SLOT_INVALID}},

	{0, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_F_UNIT|IA64_INST_ROLE_FP, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR}},
	{3, {IA64_SLOT_M_UNIT|IA64_INST_ROLE_MEM, IA64_SLOT_F_UNIT|IA64_INST_ROLE_FP, IA64_SLOT_B_UNIT|IA64_INST_ROLE_BR}},

	{0, {IA64_SLOT_INVALID}},
	{0, {IA64_SLOT_INVALID}},
};

/***********************************************************************/
/*** This file is automaticaly generated by tree_builder               */
/***********************************************************************/

IA64DecisionTreeEntry IA64DecisionTree[] = {
/*00000*/     {80, 33, 3},
/*00001*/     {424, 33, 3},
/*00002*/     {476, 33, 1},
/*00003*/     {594, 27, 6},
/*00004*/     {850, 27, 9},
/*00005*/     {0, -1, -1},
/*00006*/     {1362, 33, 3},
/*00007*/     {1434, 33, 1},
/*00008*/     {1572, 32, 4},
/*00009*/     {0, -1, -1},
/*00010*/     {0, -1, -1},
/*00011*/     {0, -1, -1},
/*00012*/     {0, -1, -1},
/*00013*/     {1620, 27, 6},
/*00014*/     {0, -1, -1},
/*00015*/     {0, -1, -1},
/*00016*/     {0, -1, -1},
/*00017*/     {0, -1, -1},
/*00018*/     {1, -1, -1},
/*00019*/     {0, -1, -1},
/*00020*/     {173, -1, -1},
/*00021*/     {1828, 30, 7},
/*00022*/     {2628, 33, 4},
/*00023*/     {2676, 33, 3},
/*00024*/     {0, -1, -1},
/*00025*/     {2844, 33, 3},
/*00026*/     {2880, 28, 8},
/*00027*/     {3136, 12, 1},
/*00028*/     {3138, 33, 3},
/*00029*/     {0, -1, -1},
/*00030*/     {0, -1, -1},
/*00031*/     {3162, 30, 7},
/*00032*/     {0, -1, -1},
/*00033*/     {1, -1, -1},
/*00034*/     {3802, 20, 1},
/*00035*/     {3804, 32, 5},
/*00036*/     {4008, 28, 8},
/*00037*/     {0, -1, -1},
/*00038*/     {4264, 0, 6},
/*00039*/     {0, -1, -1},
/*00040*/     {4336, 33, 3},
/*00041*/     {4540, 33, 3},
/*00042*/     {4744, 34, 3},
/*00043*/     {0, -1, -1},
/*00044*/     {0, -1, -1},
/*00045*/     {20, -1, -1},
/*00046*/     {20, -1, -1},
/*00047*/     {4752, 34, 3},
/*00048*/     {0, -1, -1},
/*00049*/     {0, -1, -1},
/*00050*/     {0, -1, -1},
/*00051*/     {0, -1, -1},
/*00052*/     {4760, 34, 3},
/*00053*/     {0, -1, -1},
/*00054*/     {0, -1, -1},
/*00055*/     {0, -1, -1},
/*00056*/     {0, -1, -1},
/*00057*/     {4768, 34, 3},
/*00058*/     {0, -1, -1},
/*00059*/     {0, -1, -1},
/*00060*/     {4776, 33, 3},
/*00061*/     {4816, 33, 3},
/*00062*/     {4856, 34, 3},
/*00063*/     {0, -1, -1},
/*00064*/     {4864, 33, 3},
/*00065*/     {4952, 33, 3},
/*00066*/     {4992, 33, 3},
/*00067*/     {5032, 34, 3},
/*00068*/     {0, -1, -1},
/*00069*/     {5040, 33, 3},
/*00070*/     {5064, 33, 3},
/*00071*/     {5104, 33, 3},
/*00072*/     {5144, 36, 1},
/*00073*/     {0, -1, -1},
/*00074*/     {0, -1, -1},
/*00075*/     {0, -1, -1},
/*00076*/     {0, -1, -1},
/*00077*/     {0, -1, -1},
/*00078*/     {0, -1, -1},
/*00079*/     {0, -1, -1},
/*00080*/     {88, 27, 6},
/*00081*/     {192, -1, -1},
/*00082*/     {207, -1, -1},
/*00083*/     {206, -1, -1},
/*00084*/     {0, -1, -1},
/*00085*/     {0, -1, -1},
/*00086*/     {0, -1, -1},
/*00087*/     {152, 20, 4},
/*00088*/     {190, -1, -1},
/*00089*/     {191, -1, -1},
/*00090*/     {0, -1, -1},
/*00091*/     {0, -1, -1},
/*00092*/     {0, -1, -1},
/*00093*/     {0, -1, -1},
/*00094*/     {0, -1, -1},
/*00095*/     {0, -1, -1},
/*00096*/     {0, -1, -1},
/*00097*/     {0, -1, -1},
/*00098*/     {211, -1, -1},
/*00099*/     {0, -1, -1},
/*00100*/     {0, -1, -1},
/*00101*/     {0, -1, -1},
/*00102*/     {0, -1, -1},
/*00103*/     {0, -1, -1},
/*00104*/     {213, -1, -1},
/*00105*/     {214, -1, -1},
/*00106*/     {215, -1, -1},
/*00107*/     {0, -1, -1},
/*00108*/     {216, -1, -1},
/*00109*/     {217, -1, -1},
/*00110*/     {218, -1, -1},
/*00111*/     {0, -1, -1},
/*00112*/     {219, -1, -1},
/*00113*/     {220, -1, -1},
/*00114*/     {0, -1, -1},
/*00115*/     {0, -1, -1},
/*00116*/     {221, -1, -1},
/*00117*/     {222, -1, -1},
/*00118*/     {0, -1, -1},
/*00119*/     {0, -1, -1},
/*00120*/     {0, -1, -1},
/*00121*/     {0, -1, -1},
/*00122*/     {0, -1, -1},
/*00123*/     {0, -1, -1},
/*00124*/     {0, -1, -1},
/*00125*/     {0, -1, -1},
/*00126*/     {0, -1, -1},
/*00127*/     {0, -1, -1},
/*00128*/     {0, -1, -1},
/*00129*/     {0, -1, -1},
/*00130*/     {210, -1, -1},
/*00131*/     {0, -1, -1},
/*00132*/     {0, -1, -1},
/*00133*/     {0, -1, -1},
/*00134*/     {0, -1, -1},
/*00135*/     {0, -1, -1},
/*00136*/     {208, -1, -1},
/*00137*/     {205, -1, -1},
/*00138*/     {212, -1, -1},
/*00139*/     {209, -1, -1},
/*00140*/     {0, -1, -1},
/*00141*/     {0, -1, -1},
/*00142*/     {0, -1, -1},
/*00143*/     {0, -1, -1},
/*00144*/     {0, -1, -1},
/*00145*/     {0, -1, -1},
/*00146*/     {0, -1, -1},
/*00147*/     {0, -1, -1},
/*00148*/     {0, -1, -1},
/*00149*/     {0, -1, -1},
/*00150*/     {0, -1, -1},
/*00151*/     {0, -1, -1},
/*00152*/     {168, 9, 4},
/*00153*/     {184, 9, 4},
/*00154*/     {200, 9, 4},
/*00155*/     {216, 9, 4},
/*00156*/     {232, 9, 4},
/*00157*/     {248, 9, 4},
/*00158*/     {264, 9, 4},
/*00159*/     {280, 9, 4},
/*00160*/     {296, 9, 4},
/*00161*/     {312, 9, 4},
/*00162*/     {328, 9, 4},
/*00163*/     {344, 9, 4},
/*00164*/     {360, 9, 4},
/*00165*/     {376, 9, 4},
/*00166*/     {392, 9, 4},
/*00167*/     {408, 9, 4},
/*00168*/     {193, -1, -1},
/*00169*/     {0, -1, -1},
/*00170*/     {0, -1, -1},
/*00171*/     {0, -1, -1},
/*00172*/     {0, -1, -1},
/*00173*/     {0, -1, -1},
/*00174*/     {0, -1, -1},
/*00175*/     {0, -1, -1},
/*00176*/     {0, -1, -1},
/*00177*/     {0, -1, -1},
/*00178*/     {0, -1, -1},
/*00179*/     {0, -1, -1},
/*00180*/     {0, -1, -1},
/*00181*/     {0, -1, -1},
/*00182*/     {0, -1, -1},
/*00183*/     {0, -1, -1},
/*00184*/     {195, -1, -1},
/*00185*/     {0, -1, -1},
/*00186*/     {0, -1, -1},
/*00187*/     {0, -1, -1},
/*00188*/     {0, -1, -1},
/*00189*/     {0, -1, -1},
/*00190*/     {0, -1, -1},
/*00191*/     {0, -1, -1},
/*00192*/     {0, -1, -1},
/*00193*/     {0, -1, -1},
/*00194*/     {0, -1, -1},
/*00195*/     {0, -1, -1},
/*00196*/     {0, -1, -1},
/*00197*/     {0, -1, -1},
/*00198*/     {0, -1, -1},
/*00199*/     {0, -1, -1},
/*00200*/     {197, -1, -1},
/*00201*/     {0, -1, -1},
/*00202*/     {0, -1, -1},
/*00203*/     {0, -1, -1},
/*00204*/     {0, -1, -1},
/*00205*/     {0, -1, -1},
/*00206*/     {0, -1, -1},
/*00207*/     {0, -1, -1},
/*00208*/     {0, -1, -1},
/*00209*/     {0, -1, -1},
/*00210*/     {0, -1, -1},
/*00211*/     {0, -1, -1},
/*00212*/     {0, -1, -1},
/*00213*/     {0, -1, -1},
/*00214*/     {0, -1, -1},
/*00215*/     {0, -1, -1},
/*00216*/     {195, -1, -1},
/*00217*/     {0, -1, -1},
/*00218*/     {0, -1, -1},
/*00219*/     {0, -1, -1},
/*00220*/     {0, -1, -1},
/*00221*/     {0, -1, -1},
/*00222*/     {0, -1, -1},
/*00223*/     {0, -1, -1},
/*00224*/     {0, -1, -1},
/*00225*/     {0, -1, -1},
/*00226*/     {0, -1, -1},
/*00227*/     {0, -1, -1},
/*00228*/     {0, -1, -1},
/*00229*/     {0, -1, -1},
/*00230*/     {0, -1, -1},
/*00231*/     {0, -1, -1},
/*00232*/     {199, -1, -1},
/*00233*/     {0, -1, -1},
/*00234*/     {0, -1, -1},
/*00235*/     {0, -1, -1},
/*00236*/     {0, -1, -1},
/*00237*/     {0, -1, -1},
/*00238*/     {0, -1, -1},
/*00239*/     {0, -1, -1},
/*00240*/     {0, -1, -1},
/*00241*/     {0, -1, -1},
/*00242*/     {0, -1, -1},
/*00243*/     {0, -1, -1},
/*00244*/     {0, -1, -1},
/*00245*/     {0, -1, -1},
/*00246*/     {0, -1, -1},
/*00247*/     {0, -1, -1},
/*00248*/     {201, -1, -1},
/*00249*/     {0, -1, -1},
/*00250*/     {0, -1, -1},
/*00251*/     {0, -1, -1},
/*00252*/     {0, -1, -1},
/*00253*/     {0, -1, -1},
/*00254*/     {0, -1, -1},
/*00255*/     {0, -1, -1},
/*00256*/     {0, -1, -1},
/*00257*/     {0, -1, -1},
/*00258*/     {0, -1, -1},
/*00259*/     {0, -1, -1},
/*00260*/     {0, -1, -1},
/*00261*/     {0, -1, -1},
/*00262*/     {0, -1, -1},
/*00263*/     {0, -1, -1},
/*00264*/     {203, -1, -1},
/*00265*/     {0, -1, -1},
/*00266*/     {0, -1, -1},
/*00267*/     {0, -1, -1},
/*00268*/     {0, -1, -1},
/*00269*/     {0, -1, -1},
/*00270*/     {0, -1, -1},
/*00271*/     {0, -1, -1},
/*00272*/     {0, -1, -1},
/*00273*/     {0, -1, -1},
/*00274*/     {0, -1, -1},
/*00275*/     {0, -1, -1},
/*00276*/     {0, -1, -1},
/*00277*/     {0, -1, -1},
/*00278*/     {0, -1, -1},
/*00279*/     {0, -1, -1},
/*00280*/     {201, -1, -1},
/*00281*/     {0, -1, -1},
/*00282*/     {0, -1, -1},
/*00283*/     {0, -1, -1},
/*00284*/     {0, -1, -1},
/*00285*/     {0, -1, -1},
/*00286*/     {0, -1, -1},
/*00287*/     {0, -1, -1},
/*00288*/     {0, -1, -1},
/*00289*/     {0, -1, -1},
/*00290*/     {0, -1, -1},
/*00291*/     {0, -1, -1},
/*00292*/     {0, -1, -1},
/*00293*/     {0, -1, -1},
/*00294*/     {0, -1, -1},
/*00295*/     {0, -1, -1},
/*00296*/     {194, -1, -1},
/*00297*/     {0, -1, -1},
/*00298*/     {0, -1, -1},
/*00299*/     {0, -1, -1},
/*00300*/     {0, -1, -1},
/*00301*/     {0, -1, -1},
/*00302*/     {0, -1, -1},
/*00303*/     {0, -1, -1},
/*00304*/     {0, -1, -1},
/*00305*/     {0, -1, -1},
/*00306*/     {0, -1, -1},
/*00307*/     {0, -1, -1},
/*00308*/     {0, -1, -1},
/*00309*/     {0, -1, -1},
/*00310*/     {0, -1, -1},
/*00311*/     {0, -1, -1},
/*00312*/     {196, -1, -1},
/*00313*/     {0, -1, -1},
/*00314*/     {0, -1, -1},
/*00315*/     {0, -1, -1},
/*00316*/     {0, -1, -1},
/*00317*/     {0, -1, -1},
/*00318*/     {0, -1, -1},
/*00319*/     {0, -1, -1},
/*00320*/     {0, -1, -1},
/*00321*/     {0, -1, -1},
/*00322*/     {0, -1, -1},
/*00323*/     {0, -1, -1},
/*00324*/     {0, -1, -1},
/*00325*/     {0, -1, -1},
/*00326*/     {0, -1, -1},
/*00327*/     {0, -1, -1},
/*00328*/     {198, -1, -1},
/*00329*/     {0, -1, -1},
/*00330*/     {0, -1, -1},
/*00331*/     {0, -1, -1},
/*00332*/     {0, -1, -1},
/*00333*/     {0, -1, -1},
/*00334*/     {0, -1, -1},
/*00335*/     {0, -1, -1},
/*00336*/     {0, -1, -1},
/*00337*/     {0, -1, -1},
/*00338*/     {0, -1, -1},
/*00339*/     {0, -1, -1},
/*00340*/     {0, -1, -1},
/*00341*/     {0, -1, -1},
/*00342*/     {0, -1, -1},
/*00343*/     {0, -1, -1},
/*00344*/     {196, -1, -1},
/*00345*/     {0, -1, -1},
/*00346*/     {0, -1, -1},
/*00347*/     {0, -1, -1},
/*00348*/     {0, -1, -1},
/*00349*/     {0, -1, -1},
/*00350*/     {0, -1, -1},
/*00351*/     {0, -1, -1},
/*00352*/     {0, -1, -1},
/*00353*/     {0, -1, -1},
/*00354*/     {0, -1, -1},
/*00355*/     {0, -1, -1},
/*00356*/     {0, -1, -1},
/*00357*/     {0, -1, -1},
/*00358*/     {0, -1, -1},
/*00359*/     {0, -1, -1},
/*00360*/     {200, -1, -1},
/*00361*/     {0, -1, -1},
/*00362*/     {0, -1, -1},
/*00363*/     {0, -1, -1},
/*00364*/     {0, -1, -1},
/*00365*/     {0, -1, -1},
/*00366*/     {0, -1, -1},
/*00367*/     {0, -1, -1},
/*00368*/     {0, -1, -1},
/*00369*/     {0, -1, -1},
/*00370*/     {0, -1, -1},
/*00371*/     {0, -1, -1},
/*00372*/     {0, -1, -1},
/*00373*/     {0, -1, -1},
/*00374*/     {0, -1, -1},
/*00375*/     {0, -1, -1},
/*00376*/     {202, -1, -1},
/*00377*/     {0, -1, -1},
/*00378*/     {0, -1, -1},
/*00379*/     {0, -1, -1},
/*00380*/     {0, -1, -1},
/*00381*/     {0, -1, -1},
/*00382*/     {0, -1, -1},
/*00383*/     {0, -1, -1},
/*00384*/     {0, -1, -1},
/*00385*/     {0, -1, -1},
/*00386*/     {0, -1, -1},
/*00387*/     {0, -1, -1},
/*00388*/     {0, -1, -1},
/*00389*/     {0, -1, -1},
/*00390*/     {0, -1, -1},
/*00391*/     {0, -1, -1},
/*00392*/     {204, -1, -1},
/*00393*/     {0, -1, -1},
/*00394*/     {0, -1, -1},
/*00395*/     {0, -1, -1},
/*00396*/     {0, -1, -1},
/*00397*/     {0, -1, -1},
/*00398*/     {0, -1, -1},
/*00399*/     {0, -1, -1},
/*00400*/     {0, -1, -1},
/*00401*/     {0, -1, -1},
/*00402*/     {0, -1, -1},
/*00403*/     {0, -1, -1},
/*00404*/     {0, -1, -1},
/*00405*/     {0, -1, -1},
/*00406*/     {0, -1, -1},
/*00407*/     {0, -1, -1},
/*00408*/     {202, -1, -1},
/*00409*/     {0, -1, -1},
/*00410*/     {0, -1, -1},
/*00411*/     {0, -1, -1},
/*00412*/     {0, -1, -1},
/*00413*/     {0, -1, -1},
/*00414*/     {0, -1, -1},
/*00415*/     {0, -1, -1},
/*00416*/     {0, -1, -1},
/*00417*/     {0, -1, -1},
/*00418*/     {0, -1, -1},
/*00419*/     {0, -1, -1},
/*00420*/     {0, -1, -1},
/*00421*/     {0, -1, -1},
/*00422*/     {0, -1, -1},
/*00423*/     {0, -1, -1},
/*00424*/     {432, 27, 4},
/*00425*/     {0, -1, -1},
/*00426*/     {0, -1, -1},
/*00427*/     {0, -1, -1},
/*00428*/     {1051, -1, -1},
/*00429*/     {1052, -1, -1},
/*00430*/     {1053, -1, -1},
/*00431*/     {1054, -1, -1},
/*00432*/     {448, 31, 2},
/*00433*/     {452, 31, 2},
/*00434*/     {456, 31, 2},
/*00435*/     {460, 31, 2},
/*00436*/     {1106, -1, -1},
/*00437*/     {1107, -1, -1},
/*00438*/     {1108, -1, -1},
/*00439*/     {1109, -1, -1},
/*00440*/     {464, 31, 2},
/*00441*/     {0, -1, -1},
/*00442*/     {468, 31, 2},
/*00443*/     {0, -1, -1},
/*00444*/     {472, 31, 2},
/*00445*/     {0, -1, -1},
/*00446*/     {0, -1, -1},
/*00447*/     {0, -1, -1},
/*00448*/     {1078, -1, -1},
/*00449*/     {1055, -1, -1},
/*00450*/     {1056, -1, -1},
/*00451*/     {1059, -1, -1},
/*00452*/     {1079, -1, -1},
/*00453*/     {0, -1, -1},
/*00454*/     {0, -1, -1},
/*00455*/     {1060, -1, -1},
/*00456*/     {0, -1, -1},
/*00457*/     {1064, -1, -1},
/*00458*/     {1057, -1, -1},
/*00459*/     {0, -1, -1},
/*00460*/     {0, -1, -1},
/*00461*/     {1065, -1, -1},
/*00462*/     {1058, -1, -1},
/*00463*/     {1061, -1, -1},
/*00464*/     {0, -1, -1},
/*00465*/     {0, -1, -1},
/*00466*/     {1069, -1, -1},
/*00467*/     {0, -1, -1},
/*00468*/     {1063, -1, -1},
/*00469*/     {0, -1, -1},
/*00470*/     {0, -1, -1},
/*00471*/     {0, -1, -1},
/*00472*/     {1062, -1, -1},
/*00473*/     {0, -1, -1},
/*00474*/     {0, -1, -1},
/*00475*/     {0, -1, -1},
/*00476*/     {478, 27, 6},
/*00477*/     {586, 34, 3},
/*00478*/     {1552, -1, -1},
/*00479*/     {1553, -1, -1},
/*00480*/     {0, -1, -1},
/*00481*/     {0, -1, -1},
/*00482*/     {542, 34, 2},
/*00483*/     {546, 34, 2},
/*00484*/     {0, -1, -1},
/*00485*/     {0, -1, -1},
/*00486*/     {550, 34, 2},
/*00487*/     {0, -1, -1},
/*00488*/     {0, -1, -1},
/*00489*/     {0, -1, -1},
/*00490*/     {0, -1, -1},
/*00491*/     {0, -1, -1},
/*00492*/     {0, -1, -1},
/*00493*/     {0, -1, -1},
/*00494*/     {1488, -1, -1},
/*00495*/     {1489, -1, -1},
/*00496*/     {1490, -1, -1},
/*00497*/     {0, -1, -1},
/*00498*/     {554, 34, 2},
/*00499*/     {558, 34, 2},
/*00500*/     {562, 34, 2},
/*00501*/     {566, 34, 2},
/*00502*/     {570, 34, 2},
/*00503*/     {574, 34, 2},
/*00504*/     {578, 34, 2},
/*00505*/     {582, 34, 2},
/*00506*/     {1539, -1, -1},
/*00507*/     {0, -1, -1},
/*00508*/     {0, -1, -1},
/*00509*/     {0, -1, -1},
/*00510*/     {0, -1, -1},
/*00511*/     {0, -1, -1},
/*00512*/     {0, -1, -1},
/*00513*/     {0, -1, -1},
/*00514*/     {0, -1, -1},
/*00515*/     {0, -1, -1},
/*00516*/     {0, -1, -1},
/*00517*/     {0, -1, -1},
/*00518*/     {1496, -1, -1},
/*00519*/     {0, -1, -1},
/*00520*/     {0, -1, -1},
/*00521*/     {0, -1, -1},
/*00522*/     {1500, -1, -1},
/*00523*/     {1501, -1, -1},
/*00524*/     {1502, -1, -1},
/*00525*/     {1503, -1, -1},
/*00526*/     {0, -1, -1},
/*00527*/     {0, -1, -1},
/*00528*/     {0, -1, -1},
/*00529*/     {0, -1, -1},
/*00530*/     {1497, -1, -1},
/*00531*/     {1498, -1, -1},
/*00532*/     {1499, -1, -1},
/*00533*/     {0, -1, -1},
/*00534*/     {0, -1, -1},
/*00535*/     {1491, -1, -1},
/*00536*/     {1492, -1, -1},
/*00537*/     {1493, -1, -1},
/*00538*/     {1494, -1, -1},
/*00539*/     {1495, -1, -1},
/*00540*/     {0, -1, -1},
/*00541*/     {0, -1, -1},
/*00542*/     {1540, -1, -1},
/*00543*/     {1541, -1, -1},
/*00544*/     {1542, -1, -1},
/*00545*/     {1543, -1, -1},
/*00546*/     {1544, -1, -1},
/*00547*/     {1545, -1, -1},
/*00548*/     {1546, -1, -1},
/*00549*/     {1547, -1, -1},
/*00550*/     {1548, -1, -1},
/*00551*/     {1549, -1, -1},
/*00552*/     {1550, -1, -1},
/*00553*/     {1551, -1, -1},
/*00554*/     {1424, -1, -1},
/*00555*/     {1425, -1, -1},
/*00556*/     {1426, -1, -1},
/*00557*/     {1427, -1, -1},
/*00558*/     {1428, -1, -1},
/*00559*/     {1429, -1, -1},
/*00560*/     {1430, -1, -1},
/*00561*/     {1431, -1, -1},
/*00562*/     {1432, -1, -1},
/*00563*/     {1433, -1, -1},
/*00564*/     {1434, -1, -1},
/*00565*/     {1435, -1, -1},
/*00566*/     {1436, -1, -1},
/*00567*/     {1437, -1, -1},
/*00568*/     {1438, -1, -1},
/*00569*/     {1439, -1, -1},
/*00570*/     {1507, -1, -1},
/*00571*/     {1508, -1, -1},
/*00572*/     {1509, -1, -1},
/*00573*/     {1510, -1, -1},
/*00574*/     {1511, -1, -1},
/*00575*/     {1512, -1, -1},
/*00576*/     {1513, -1, -1},
/*00577*/     {1514, -1, -1},
/*00578*/     {1515, -1, -1},
/*00579*/     {1516, -1, -1},
/*00580*/     {1517, -1, -1},
/*00581*/     {1518, -1, -1},
/*00582*/     {1519, -1, -1},
/*00583*/     {1520, -1, -1},
/*00584*/     {1521, -1, -1},
/*00585*/     {1522, -1, -1},
/*00586*/     {1408, -1, -1},
/*00587*/     {1409, -1, -1},
/*00588*/     {1410, -1, -1},
/*00589*/     {1411, -1, -1},
/*00590*/     {1416, -1, -1},
/*00591*/     {1417, -1, -1},
/*00592*/     {1418, -1, -1},
/*00593*/     {1419, -1, -1},
/*00594*/     {1320, -1, -1},
/*00595*/     {0, -1, -1},
/*00596*/     {1312, -1, -1},
/*00597*/     {0, -1, -1},
/*00598*/     {1313, -1, -1},
/*00599*/     {1314, -1, -1},
/*00600*/     {0, -1, -1},
/*00601*/     {0, -1, -1},
/*00602*/     {1315, -1, -1},
/*00603*/     {1316, -1, -1},
/*00604*/     {0, -1, -1},
/*00605*/     {0, -1, -1},
/*00606*/     {1317, -1, -1},
/*00607*/     {1318, -1, -1},
/*00608*/     {0, -1, -1},
/*00609*/     {0, -1, -1},
/*00610*/     {1319, -1, -1},
/*00611*/     {0, -1, -1},
/*00612*/     {0, -1, -1},
/*00613*/     {0, -1, -1},
/*00614*/     {0, -1, -1},
/*00615*/     {0, -1, -1},
/*00616*/     {0, -1, -1},
/*00617*/     {0, -1, -1},
/*00618*/     {0, -1, -1},
/*00619*/     {0, -1, -1},
/*00620*/     {0, -1, -1},
/*00621*/     {0, -1, -1},
/*00622*/     {0, -1, -1},
/*00623*/     {0, -1, -1},
/*00624*/     {0, -1, -1},
/*00625*/     {0, -1, -1},
/*00626*/     {658, 33, 3},
/*00627*/     {762, 33, 3},
/*00628*/     {0, -1, -1},
/*00629*/     {0, -1, -1},
/*00630*/     {0, -1, -1},
/*00631*/     {0, -1, -1},
/*00632*/     {0, -1, -1},
/*00633*/     {0, -1, -1},
/*00634*/     {0, -1, -1},
/*00635*/     {0, -1, -1},
/*00636*/     {0, -1, -1},
/*00637*/     {0, -1, -1},
/*00638*/     {0, -1, -1},
/*00639*/     {0, -1, -1},
/*00640*/     {0, -1, -1},
/*00641*/     {0, -1, -1},
/*00642*/     {0, -1, -1},
/*00643*/     {0, -1, -1},
/*00644*/     {0, -1, -1},
/*00645*/     {0, -1, -1},
/*00646*/     {0, -1, -1},
/*00647*/     {0, -1, -1},
/*00648*/     {0, -1, -1},
/*00649*/     {0, -1, -1},
/*00650*/     {0, -1, -1},
/*00651*/     {0, -1, -1},
/*00652*/     {0, -1, -1},
/*00653*/     {0, -1, -1},
/*00654*/     {0, -1, -1},
/*00655*/     {0, -1, -1},
/*00656*/     {0, -1, -1},
/*00657*/     {0, -1, -1},
/*00658*/     {666, 6, 3},
/*00659*/     {678, 6, 3},
/*00660*/     {690, 6, 3},
/*00661*/     {702, 6, 3},
/*00662*/     {714, 6, 3},
/*00663*/     {726, 6, 3},
/*00664*/     {738, 6, 3},
/*00665*/     {750, 6, 3},
/*00666*/     {674, 12, 1},
/*00667*/     {676, 12, 1},
/*00668*/     {0, -1, -1},
/*00669*/     {0, -1, -1},
/*00670*/     {0, -1, -1},
/*00671*/     {0, -1, -1},
/*00672*/     {0, -1, -1},
/*00673*/     {0, -1, -1},
/*00674*/     {1232, -1, -1},
/*00675*/     {1233, -1, -1},
/*00676*/     {1248, -1, -1},
/*00677*/     {1249, -1, -1},
/*00678*/     {686, 12, 1},
/*00679*/     {688, 12, 1},
/*00680*/     {0, -1, -1},
/*00681*/     {0, -1, -1},
/*00682*/     {0, -1, -1},
/*00683*/     {0, -1, -1},
/*00684*/     {0, -1, -1},
/*00685*/     {0, -1, -1},
/*00686*/     {1234, -1, -1},
/*00687*/     {1235, -1, -1},
/*00688*/     {1250, -1, -1},
/*00689*/     {1251, -1, -1},
/*00690*/     {698, 12, 1},
/*00691*/     {700, 12, 1},
/*00692*/     {0, -1, -1},
/*00693*/     {0, -1, -1},
/*00694*/     {0, -1, -1},
/*00695*/     {0, -1, -1},
/*00696*/     {0, -1, -1},
/*00697*/     {0, -1, -1},
/*00698*/     {1236, -1, -1},
/*00699*/     {1237, -1, -1},
/*00700*/     {1252, -1, -1},
/*00701*/     {1253, -1, -1},
/*00702*/     {710, 12, 1},
/*00703*/     {712, 12, 1},
/*00704*/     {0, -1, -1},
/*00705*/     {0, -1, -1},
/*00706*/     {0, -1, -1},
/*00707*/     {0, -1, -1},
/*00708*/     {0, -1, -1},
/*00709*/     {0, -1, -1},
/*00710*/     {1238, -1, -1},
/*00711*/     {1239, -1, -1},
/*00712*/     {1254, -1, -1},
/*00713*/     {1255, -1, -1},
/*00714*/     {722, 12, 1},
/*00715*/     {724, 12, 1},
/*00716*/     {0, -1, -1},
/*00717*/     {0, -1, -1},
/*00718*/     {0, -1, -1},
/*00719*/     {0, -1, -1},
/*00720*/     {0, -1, -1},
/*00721*/     {0, -1, -1},
/*00722*/     {1240, -1, -1},
/*00723*/     {1241, -1, -1},
/*00724*/     {1256, -1, -1},
/*00725*/     {1257, -1, -1},
/*00726*/     {734, 12, 1},
/*00727*/     {736, 12, 1},
/*00728*/     {0, -1, -1},
/*00729*/     {0, -1, -1},
/*00730*/     {0, -1, -1},
/*00731*/     {0, -1, -1},
/*00732*/     {0, -1, -1},
/*00733*/     {0, -1, -1},
/*00734*/     {1242, -1, -1},
/*00735*/     {1243, -1, -1},
/*00736*/     {1258, -1, -1},
/*00737*/     {1259, -1, -1},
/*00738*/     {746, 12, 1},
/*00739*/     {748, 12, 1},
/*00740*/     {0, -1, -1},
/*00741*/     {0, -1, -1},
/*00742*/     {0, -1, -1},
/*00743*/     {0, -1, -1},
/*00744*/     {0, -1, -1},
/*00745*/     {0, -1, -1},
/*00746*/     {1244, -1, -1},
/*00747*/     {1245, -1, -1},
/*00748*/     {1260, -1, -1},
/*00749*/     {1261, -1, -1},
/*00750*/     {758, 12, 1},
/*00751*/     {760, 12, 1},
/*00752*/     {0, -1, -1},
/*00753*/     {0, -1, -1},
/*00754*/     {0, -1, -1},
/*00755*/     {0, -1, -1},
/*00756*/     {0, -1, -1},
/*00757*/     {0, -1, -1},
/*00758*/     {1246, -1, -1},
/*00759*/     {1247, -1, -1},
/*00760*/     {1262, -1, -1},
/*00761*/     {1263, -1, -1},
/*00762*/     {770, 6, 3},
/*00763*/     {780, 6, 3},
/*00764*/     {790, 6, 3},
/*00765*/     {800, 6, 3},
/*00766*/     {810, 6, 3},
/*00767*/     {820, 6, 3},
/*00768*/     {830, 6, 3},
/*00769*/     {840, 6, 3},
/*00770*/     {0, -1, -1},
/*00771*/     {0, -1, -1},
/*00772*/     {0, -1, -1},
/*00773*/     {0, -1, -1},
/*00774*/     {778, 12, 1},
/*00775*/     {0, -1, -1},
/*00776*/     {0, -1, -1},
/*00777*/     {0, -1, -1},
/*00778*/     {1264, -1, -1},
/*00779*/     {1265, -1, -1},
/*00780*/     {0, -1, -1},
/*00781*/     {0, -1, -1},
/*00782*/     {0, -1, -1},
/*00783*/     {0, -1, -1},
/*00784*/     {788, 12, 1},
/*00785*/     {0, -1, -1},
/*00786*/     {0, -1, -1},
/*00787*/     {0, -1, -1},
/*00788*/     {1266, -1, -1},
/*00789*/     {1267, -1, -1},
/*00790*/     {0, -1, -1},
/*00791*/     {0, -1, -1},
/*00792*/     {0, -1, -1},
/*00793*/     {0, -1, -1},
/*00794*/     {798, 12, 1},
/*00795*/     {0, -1, -1},
/*00796*/     {0, -1, -1},
/*00797*/     {0, -1, -1},
/*00798*/     {1268, -1, -1},
/*00799*/     {1269, -1, -1},
/*00800*/     {0, -1, -1},
/*00801*/     {0, -1, -1},
/*00802*/     {0, -1, -1},
/*00803*/     {0, -1, -1},
/*00804*/     {808, 12, 1},
/*00805*/     {0, -1, -1},
/*00806*/     {0, -1, -1},
/*00807*/     {0, -1, -1},
/*00808*/     {1270, -1, -1},
/*00809*/     {1271, -1, -1},
/*00810*/     {0, -1, -1},
/*00811*/     {0, -1, -1},
/*00812*/     {0, -1, -1},
/*00813*/     {0, -1, -1},
/*00814*/     {818, 12, 1},
/*00815*/     {0, -1, -1},
/*00816*/     {0, -1, -1},
/*00817*/     {0, -1, -1},
/*00818*/     {1272, -1, -1},
/*00819*/     {1273, -1, -1},
/*00820*/     {0, -1, -1},
/*00821*/     {0, -1, -1},
/*00822*/     {0, -1, -1},
/*00823*/     {0, -1, -1},
/*00824*/     {828, 12, 1},
/*00825*/     {0, -1, -1},
/*00826*/     {0, -1, -1},
/*00827*/     {0, -1, -1},
/*00828*/     {1274, -1, -1},
/*00829*/     {1275, -1, -1},
/*00830*/     {0, -1, -1},
/*00831*/     {0, -1, -1},
/*00832*/     {0, -1, -1},
/*00833*/     {0, -1, -1},
/*00834*/     {838, 12, 1},
/*00835*/     {0, -1, -1},
/*00836*/     {0, -1, -1},
/*00837*/     {0, -1, -1},
/*00838*/     {1276, -1, -1},
/*00839*/     {1277, -1, -1},
/*00840*/     {0, -1, -1},
/*00841*/     {0, -1, -1},
/*00842*/     {0, -1, -1},
/*00843*/     {0, -1, -1},
/*00844*/     {848, 12, 1},
/*00845*/     {0, -1, -1},
/*00846*/     {0, -1, -1},
/*00847*/     {0, -1, -1},
/*00848*/     {1278, -1, -1},
/*00849*/     {1279, -1, -1},
/*00850*/     {1554, -1, -1},
/*00851*/     {1555, -1, -1},
/*00852*/     {0, -1, -1},
/*00853*/     {0, -1, -1},
/*00854*/     {0, -1, -1},
/*00855*/     {0, -1, -1},
/*00856*/     {0, -1, -1},
/*00857*/     {0, -1, -1},
/*00858*/     {0, -1, -1},
/*00859*/     {0, -1, -1},
/*00860*/     {0, -1, -1},
/*00861*/     {0, -1, -1},
/*00862*/     {0, -1, -1},
/*00863*/     {0, -1, -1},
/*00864*/     {0, -1, -1},
/*00865*/     {0, -1, -1},
/*00866*/     {0, -1, -1},
/*00867*/     {0, -1, -1},
/*00868*/     {0, -1, -1},
/*00869*/     {0, -1, -1},
/*00870*/     {0, -1, -1},
/*00871*/     {0, -1, -1},
/*00872*/     {0, -1, -1},
/*00873*/     {0, -1, -1},
/*00874*/     {0, -1, -1},
/*00875*/     {0, -1, -1},
/*00876*/     {0, -1, -1},
/*00877*/     {0, -1, -1},
/*00878*/     {0, -1, -1},
/*00879*/     {0, -1, -1},
/*00880*/     {0, -1, -1},
/*00881*/     {0, -1, -1},
/*00882*/     {0, -1, -1},
/*00883*/     {0, -1, -1},
/*00884*/     {0, -1, -1},
/*00885*/     {0, -1, -1},
/*00886*/     {0, -1, -1},
/*00887*/     {0, -1, -1},
/*00888*/     {0, -1, -1},
/*00889*/     {0, -1, -1},
/*00890*/     {0, -1, -1},
/*00891*/     {0, -1, -1},
/*00892*/     {0, -1, -1},
/*00893*/     {0, -1, -1},
/*00894*/     {0, -1, -1},
/*00895*/     {0, -1, -1},
/*00896*/     {0, -1, -1},
/*00897*/     {0, -1, -1},
/*00898*/     {0, -1, -1},
/*00899*/     {0, -1, -1},
/*00900*/     {0, -1, -1},
/*00901*/     {0, -1, -1},
/*00902*/     {0, -1, -1},
/*00903*/     {0, -1, -1},
/*00904*/     {0, -1, -1},
/*00905*/     {0, -1, -1},
/*00906*/     {0, -1, -1},
/*00907*/     {0, -1, -1},
/*00908*/     {0, -1, -1},
/*00909*/     {0, -1, -1},
/*00910*/     {0, -1, -1},
/*00911*/     {0, -1, -1},
/*00912*/     {0, -1, -1},
/*00913*/     {0, -1, -1},
/*00914*/     {0, -1, -1},
/*00915*/     {0, -1, -1},
/*00916*/     {0, -1, -1},
/*00917*/     {0, -1, -1},
/*00918*/     {0, -1, -1},
/*00919*/     {0, -1, -1},
/*00920*/     {0, -1, -1},
/*00921*/     {0, -1, -1},
/*00922*/     {0, -1, -1},
/*00923*/     {0, -1, -1},
/*00924*/     {0, -1, -1},
/*00925*/     {0, -1, -1},
/*00926*/     {0, -1, -1},
/*00927*/     {0, -1, -1},
/*00928*/     {0, -1, -1},
/*00929*/     {0, -1, -1},
/*00930*/     {0, -1, -1},
/*00931*/     {0, -1, -1},
/*00932*/     {0, -1, -1},
/*00933*/     {0, -1, -1},
/*00934*/     {0, -1, -1},
/*00935*/     {0, -1, -1},
/*00936*/     {0, -1, -1},
/*00937*/     {0, -1, -1},
/*00938*/     {0, -1, -1},
/*00939*/     {0, -1, -1},
/*00940*/     {0, -1, -1},
/*00941*/     {0, -1, -1},
/*00942*/     {0, -1, -1},
/*00943*/     {0, -1, -1},
/*00944*/     {0, -1, -1},
/*00945*/     {0, -1, -1},
/*00946*/     {0, -1, -1},
/*00947*/     {0, -1, -1},
/*00948*/     {0, -1, -1},
/*00949*/     {0, -1, -1},
/*00950*/     {0, -1, -1},
/*00951*/     {0, -1, -1},
/*00952*/     {0, -1, -1},
/*00953*/     {0, -1, -1},
/*00954*/     {0, -1, -1},
/*00955*/     {0, -1, -1},
/*00956*/     {0, -1, -1},
/*00957*/     {0, -1, -1},
/*00958*/     {0, -1, -1},
/*00959*/     {0, -1, -1},
/*00960*/     {0, -1, -1},
/*00961*/     {0, -1, -1},
/*00962*/     {0, -1, -1},
/*00963*/     {0, -1, -1},
/*00964*/     {0, -1, -1},
/*00965*/     {0, -1, -1},
/*00966*/     {0, -1, -1},
/*00967*/     {0, -1, -1},
/*00968*/     {0, -1, -1},
/*00969*/     {0, -1, -1},
/*00970*/     {0, -1, -1},
/*00971*/     {0, -1, -1},
/*00972*/     {0, -1, -1},
/*00973*/     {0, -1, -1},
/*00974*/     {0, -1, -1},
/*00975*/     {0, -1, -1},
/*00976*/     {0, -1, -1},
/*00977*/     {0, -1, -1},
/*00978*/     {0, -1, -1},
/*00979*/     {0, -1, -1},
/*00980*/     {0, -1, -1},
/*00981*/     {0, -1, -1},
/*00982*/     {0, -1, -1},
/*00983*/     {0, -1, -1},
/*00984*/     {0, -1, -1},
/*00985*/     {0, -1, -1},
/*00986*/     {0, -1, -1},
/*00987*/     {0, -1, -1},
/*00988*/     {0, -1, -1},
/*00989*/     {0, -1, -1},
/*00990*/     {0, -1, -1},
/*00991*/     {0, -1, -1},
/*00992*/     {0, -1, -1},
/*00993*/     {0, -1, -1},
/*00994*/     {0, -1, -1},
/*00995*/     {0, -1, -1},
/*00996*/     {0, -1, -1},
/*00997*/     {0, -1, -1},
/*00998*/     {0, -1, -1},
/*00999*/     {0, -1, -1},
/*01000*/     {0, -1, -1},
/*01001*/     {0, -1, -1},
/*01002*/     {0, -1, -1},
/*01003*/     {0, -1, -1},
/*01004*/     {0, -1, -1},
/*01005*/     {0, -1, -1},
/*01006*/     {0, -1, -1},
/*01007*/     {0, -1, -1},
/*01008*/     {0, -1, -1},
/*01009*/     {0, -1, -1},
/*01010*/     {0, -1, -1},
/*01011*/     {0, -1, -1},
/*01012*/     {0, -1, -1},
/*01013*/     {0, -1, -1},
/*01014*/     {0, -1, -1},
/*01015*/     {0, -1, -1},
/*01016*/     {0, -1, -1},
/*01017*/     {0, -1, -1},
/*01018*/     {0, -1, -1},
/*01019*/     {0, -1, -1},
/*01020*/     {0, -1, -1},
/*01021*/     {0, -1, -1},
/*01022*/     {0, -1, -1},
/*01023*/     {0, -1, -1},
/*01024*/     {0, -1, -1},
/*01025*/     {0, -1, -1},
/*01026*/     {0, -1, -1},
/*01027*/     {0, -1, -1},
/*01028*/     {0, -1, -1},
/*01029*/     {0, -1, -1},
/*01030*/     {0, -1, -1},
/*01031*/     {0, -1, -1},
/*01032*/     {0, -1, -1},
/*01033*/     {0, -1, -1},
/*01034*/     {0, -1, -1},
/*01035*/     {0, -1, -1},
/*01036*/     {0, -1, -1},
/*01037*/     {0, -1, -1},
/*01038*/     {0, -1, -1},
/*01039*/     {0, -1, -1},
/*01040*/     {0, -1, -1},
/*01041*/     {0, -1, -1},
/*01042*/     {0, -1, -1},
/*01043*/     {0, -1, -1},
/*01044*/     {0, -1, -1},
/*01045*/     {0, -1, -1},
/*01046*/     {0, -1, -1},
/*01047*/     {0, -1, -1},
/*01048*/     {0, -1, -1},
/*01049*/     {0, -1, -1},
/*01050*/     {0, -1, -1},
/*01051*/     {0, -1, -1},
/*01052*/     {0, -1, -1},
/*01053*/     {0, -1, -1},
/*01054*/     {0, -1, -1},
/*01055*/     {0, -1, -1},
/*01056*/     {0, -1, -1},
/*01057*/     {0, -1, -1},
/*01058*/     {0, -1, -1},
/*01059*/     {0, -1, -1},
/*01060*/     {0, -1, -1},
/*01061*/     {0, -1, -1},
/*01062*/     {0, -1, -1},
/*01063*/     {0, -1, -1},
/*01064*/     {0, -1, -1},
/*01065*/     {0, -1, -1},
/*01066*/     {0, -1, -1},
/*01067*/     {0, -1, -1},
/*01068*/     {0, -1, -1},
/*01069*/     {0, -1, -1},
/*01070*/     {0, -1, -1},
/*01071*/     {0, -1, -1},
/*01072*/     {0, -1, -1},
/*01073*/     {0, -1, -1},
/*01074*/     {0, -1, -1},
/*01075*/     {0, -1, -1},
/*01076*/     {0, -1, -1},
/*01077*/     {0, -1, -1},
/*01078*/     {0, -1, -1},
/*01079*/     {0, -1, -1},
/*01080*/     {0, -1, -1},
/*01081*/     {0, -1, -1},
/*01082*/     {0, -1, -1},
/*01083*/     {0, -1, -1},
/*01084*/     {0, -1, -1},
/*01085*/     {0, -1, -1},
/*01086*/     {0, -1, -1},
/*01087*/     {0, -1, -1},
/*01088*/     {0, -1, -1},
/*01089*/     {0, -1, -1},
/*01090*/     {0, -1, -1},
/*01091*/     {0, -1, -1},
/*01092*/     {0, -1, -1},
/*01093*/     {0, -1, -1},
/*01094*/     {0, -1, -1},
/*01095*/     {0, -1, -1},
/*01096*/     {0, -1, -1},
/*01097*/     {0, -1, -1},
/*01098*/     {0, -1, -1},
/*01099*/     {0, -1, -1},
/*01100*/     {0, -1, -1},
/*01101*/     {0, -1, -1},
/*01102*/     {0, -1, -1},
/*01103*/     {0, -1, -1},
/*01104*/     {0, -1, -1},
/*01105*/     {0, -1, -1},
/*01106*/     {0, -1, -1},
/*01107*/     {0, -1, -1},
/*01108*/     {0, -1, -1},
/*01109*/     {0, -1, -1},
/*01110*/     {0, -1, -1},
/*01111*/     {0, -1, -1},
/*01112*/     {0, -1, -1},
/*01113*/     {0, -1, -1},
/*01114*/     {0, -1, -1},
/*01115*/     {0, -1, -1},
/*01116*/     {0, -1, -1},
/*01117*/     {0, -1, -1},
/*01118*/     {0, -1, -1},
/*01119*/     {0, -1, -1},
/*01120*/     {0, -1, -1},
/*01121*/     {0, -1, -1},
/*01122*/     {0, -1, -1},
/*01123*/     {0, -1, -1},
/*01124*/     {0, -1, -1},
/*01125*/     {0, -1, -1},
/*01126*/     {0, -1, -1},
/*01127*/     {0, -1, -1},
/*01128*/     {0, -1, -1},
/*01129*/     {0, -1, -1},
/*01130*/     {0, -1, -1},
/*01131*/     {0, -1, -1},
/*01132*/     {0, -1, -1},
/*01133*/     {0, -1, -1},
/*01134*/     {0, -1, -1},
/*01135*/     {0, -1, -1},
/*01136*/     {0, -1, -1},
/*01137*/     {0, -1, -1},
/*01138*/     {0, -1, -1},
/*01139*/     {0, -1, -1},
/*01140*/     {0, -1, -1},
/*01141*/     {0, -1, -1},
/*01142*/     {0, -1, -1},
/*01143*/     {0, -1, -1},
/*01144*/     {0, -1, -1},
/*01145*/     {0, -1, -1},
/*01146*/     {0, -1, -1},
/*01147*/     {0, -1, -1},
/*01148*/     {0, -1, -1},
/*01149*/     {0, -1, -1},
/*01150*/     {0, -1, -1},
/*01151*/     {0, -1, -1},
/*01152*/     {0, -1, -1},
/*01153*/     {0, -1, -1},
/*01154*/     {0, -1, -1},
/*01155*/     {0, -1, -1},
/*01156*/     {0, -1, -1},
/*01157*/     {0, -1, -1},
/*01158*/     {0, -1, -1},
/*01159*/     {0, -1, -1},
/*01160*/     {0, -1, -1},
/*01161*/     {0, -1, -1},
/*01162*/     {0, -1, -1},
/*01163*/     {0, -1, -1},
/*01164*/     {0, -1, -1},
/*01165*/     {0, -1, -1},
/*01166*/     {0, -1, -1},
/*01167*/     {0, -1, -1},
/*01168*/     {0, -1, -1},
/*01169*/     {0, -1, -1},
/*01170*/     {0, -1, -1},
/*01171*/     {0, -1, -1},
/*01172*/     {0, -1, -1},
/*01173*/     {0, -1, -1},
/*01174*/     {0, -1, -1},
/*01175*/     {0, -1, -1},
/*01176*/     {0, -1, -1},
/*01177*/     {0, -1, -1},
/*01178*/     {0, -1, -1},
/*01179*/     {0, -1, -1},
/*01180*/     {0, -1, -1},
/*01181*/     {0, -1, -1},
/*01182*/     {0, -1, -1},
/*01183*/     {0, -1, -1},
/*01184*/     {0, -1, -1},
/*01185*/     {0, -1, -1},
/*01186*/     {0, -1, -1},
/*01187*/     {0, -1, -1},
/*01188*/     {0, -1, -1},
/*01189*/     {0, -1, -1},
/*01190*/     {0, -1, -1},
/*01191*/     {0, -1, -1},
/*01192*/     {0, -1, -1},
/*01193*/     {0, -1, -1},
/*01194*/     {0, -1, -1},
/*01195*/     {0, -1, -1},
/*01196*/     {0, -1, -1},
/*01197*/     {0, -1, -1},
/*01198*/     {0, -1, -1},
/*01199*/     {0, -1, -1},
/*01200*/     {0, -1, -1},
/*01201*/     {0, -1, -1},
/*01202*/     {0, -1, -1},
/*01203*/     {0, -1, -1},
/*01204*/     {0, -1, -1},
/*01205*/     {0, -1, -1},
/*01206*/     {0, -1, -1},
/*01207*/     {0, -1, -1},
/*01208*/     {0, -1, -1},
/*01209*/     {0, -1, -1},
/*01210*/     {0, -1, -1},
/*01211*/     {0, -1, -1},
/*01212*/     {0, -1, -1},
/*01213*/     {0, -1, -1},
/*01214*/     {0, -1, -1},
/*01215*/     {0, -1, -1},
/*01216*/     {0, -1, -1},
/*01217*/     {0, -1, -1},
/*01218*/     {0, -1, -1},
/*01219*/     {0, -1, -1},
/*01220*/     {0, -1, -1},
/*01221*/     {0, -1, -1},
/*01222*/     {0, -1, -1},
/*01223*/     {0, -1, -1},
/*01224*/     {0, -1, -1},
/*01225*/     {0, -1, -1},
/*01226*/     {0, -1, -1},
/*01227*/     {0, -1, -1},
/*01228*/     {0, -1, -1},
/*01229*/     {0, -1, -1},
/*01230*/     {0, -1, -1},
/*01231*/     {0, -1, -1},
/*01232*/     {0, -1, -1},
/*01233*/     {0, -1, -1},
/*01234*/     {0, -1, -1},
/*01235*/     {0, -1, -1},
/*01236*/     {0, -1, -1},
/*01237*/     {0, -1, -1},
/*01238*/     {0, -1, -1},
/*01239*/     {0, -1, -1},
/*01240*/     {0, -1, -1},
/*01241*/     {0, -1, -1},
/*01242*/     {0, -1, -1},
/*01243*/     {0, -1, -1},
/*01244*/     {0, -1, -1},
/*01245*/     {0, -1, -1},
/*01246*/     {0, -1, -1},
/*01247*/     {0, -1, -1},
/*01248*/     {0, -1, -1},
/*01249*/     {0, -1, -1},
/*01250*/     {0, -1, -1},
/*01251*/     {0, -1, -1},
/*01252*/     {0, -1, -1},
/*01253*/     {0, -1, -1},
/*01254*/     {0, -1, -1},
/*01255*/     {0, -1, -1},
/*01256*/     {0, -1, -1},
/*01257*/     {0, -1, -1},
/*01258*/     {0, -1, -1},
/*01259*/     {0, -1, -1},
/*01260*/     {0, -1, -1},
/*01261*/     {0, -1, -1},
/*01262*/     {0, -1, -1},
/*01263*/     {0, -1, -1},
/*01264*/     {0, -1, -1},
/*01265*/     {0, -1, -1},
/*01266*/     {0, -1, -1},
/*01267*/     {0, -1, -1},
/*01268*/     {0, -1, -1},
/*01269*/     {0, -1, -1},
/*01270*/     {0, -1, -1},
/*01271*/     {0, -1, -1},
/*01272*/     {0, -1, -1},
/*01273*/     {0, -1, -1},
/*01274*/     {0, -1, -1},
/*01275*/     {0, -1, -1},
/*01276*/     {0, -1, -1},
/*01277*/     {0, -1, -1},
/*01278*/     {0, -1, -1},
/*01279*/     {0, -1, -1},
/*01280*/     {0, -1, -1},
/*01281*/     {0, -1, -1},
/*01282*/     {0, -1, -1},
/*01283*/     {0, -1, -1},
/*01284*/     {0, -1, -1},
/*01285*/     {0, -1, -1},
/*01286*/     {0, -1, -1},
/*01287*/     {0, -1, -1},
/*01288*/     {0, -1, -1},
/*01289*/     {0, -1, -1},
/*01290*/     {0, -1, -1},
/*01291*/     {0, -1, -1},
/*01292*/     {0, -1, -1},
/*01293*/     {0, -1, -1},
/*01294*/     {0, -1, -1},
/*01295*/     {0, -1, -1},
/*01296*/     {0, -1, -1},
/*01297*/     {0, -1, -1},
/*01298*/     {0, -1, -1},
/*01299*/     {0, -1, -1},
/*01300*/     {0, -1, -1},
/*01301*/     {0, -1, -1},
/*01302*/     {0, -1, -1},
/*01303*/     {0, -1, -1},
/*01304*/     {0, -1, -1},
/*01305*/     {0, -1, -1},
/*01306*/     {0, -1, -1},
/*01307*/     {0, -1, -1},
/*01308*/     {0, -1, -1},
/*01309*/     {0, -1, -1},
/*01310*/     {0, -1, -1},
/*01311*/     {0, -1, -1},
/*01312*/     {0, -1, -1},
/*01313*/     {0, -1, -1},
/*01314*/     {0, -1, -1},
/*01315*/     {0, -1, -1},
/*01316*/     {0, -1, -1},
/*01317*/     {0, -1, -1},
/*01318*/     {0, -1, -1},
/*01319*/     {0, -1, -1},
/*01320*/     {0, -1, -1},
/*01321*/     {0, -1, -1},
/*01322*/     {0, -1, -1},
/*01323*/     {0, -1, -1},
/*01324*/     {0, -1, -1},
/*01325*/     {0, -1, -1},
/*01326*/     {0, -1, -1},
/*01327*/     {0, -1, -1},
/*01328*/     {0, -1, -1},
/*01329*/     {0, -1, -1},
/*01330*/     {0, -1, -1},
/*01331*/     {0, -1, -1},
/*01332*/     {0, -1, -1},
/*01333*/     {0, -1, -1},
/*01334*/     {0, -1, -1},
/*01335*/     {0, -1, -1},
/*01336*/     {0, -1, -1},
/*01337*/     {0, -1, -1},
/*01338*/     {0, -1, -1},
/*01339*/     {0, -1, -1},
/*01340*/     {0, -1, -1},
/*01341*/     {0, -1, -1},
/*01342*/     {0, -1, -1},
/*01343*/     {0, -1, -1},
/*01344*/     {0, -1, -1},
/*01345*/     {0, -1, -1},
/*01346*/     {0, -1, -1},
/*01347*/     {0, -1, -1},
/*01348*/     {0, -1, -1},
/*01349*/     {0, -1, -1},
/*01350*/     {0, -1, -1},
/*01351*/     {0, -1, -1},
/*01352*/     {0, -1, -1},
/*01353*/     {0, -1, -1},
/*01354*/     {0, -1, -1},
/*01355*/     {0, -1, -1},
/*01356*/     {0, -1, -1},
/*01357*/     {0, -1, -1},
/*01358*/     {0, -1, -1},
/*01359*/     {0, -1, -1},
/*01360*/     {0, -1, -1},
/*01361*/     {0, -1, -1},
/*01362*/     {1370, 27, 6},
/*01363*/     {1049, -1, -1},
/*01364*/     {0, -1, -1},
/*01365*/     {1050, -1, -1},
/*01366*/     {0, -1, -1},
/*01367*/     {0, -1, -1},
/*01368*/     {1073, -1, -1},
/*01369*/     {0, -1, -1},
/*01370*/     {1089, -1, -1},
/*01371*/     {1090, -1, -1},
/*01372*/     {1091, -1, -1},
/*01373*/     {1092, -1, -1},
/*01374*/     {1093, -1, -1},
/*01375*/     {1094, -1, -1},
/*01376*/     {1095, -1, -1},
/*01377*/     {0, -1, -1},
/*01378*/     {0, -1, -1},
/*01379*/     {1110, -1, -1},
/*01380*/     {1111, -1, -1},
/*01381*/     {1112, -1, -1},
/*01382*/     {1113, -1, -1},
/*01383*/     {1114, -1, -1},
/*01384*/     {1096, -1, -1},
/*01385*/     {1097, -1, -1},
/*01386*/     {1098, -1, -1},
/*01387*/     {1099, -1, -1},
/*01388*/     {1100, -1, -1},
/*01389*/     {1101, -1, -1},
/*01390*/     {1102, -1, -1},
/*01391*/     {1104, -1, -1},
/*01392*/     {1103, -1, -1},
/*01393*/     {1105, -1, -1},
/*01394*/     {1082, -1, -1},
/*01395*/     {1083, -1, -1},
/*01396*/     {1115, -1, -1},
/*01397*/     {1116, -1, -1},
/*01398*/     {0, -1, -1},
/*01399*/     {0, -1, -1},
/*01400*/     {1117, -1, -1},
/*01401*/     {1118, -1, -1},
/*01402*/     {0, -1, -1},
/*01403*/     {1077, -1, -1},
/*01404*/     {1070, -1, -1},
/*01405*/     {0, -1, -1},
/*01406*/     {1072, -1, -1},
/*01407*/     {1076, -1, -1},
/*01408*/     {0, -1, -1},
/*01409*/     {0, -1, -1},
/*01410*/     {0, -1, -1},
/*01411*/     {1075, -1, -1},
/*01412*/     {1068, -1, -1},
/*01413*/     {0, -1, -1},
/*01414*/     {1071, -1, -1},
/*01415*/     {1074, -1, -1},
/*01416*/     {1087, -1, -1},
/*01417*/     {1088, -1, -1},
/*01418*/     {1066, -1, -1},
/*01419*/     {1084, -1, -1},
/*01420*/     {1085, -1, -1},
/*01421*/     {1086, -1, -1},
/*01422*/     {1067, -1, -1},
/*01423*/     {0, -1, -1},
/*01424*/     {0, -1, -1},
/*01425*/     {0, -1, -1},
/*01426*/     {1080, -1, -1},
/*01427*/     {1081, -1, -1},
/*01428*/     {0, -1, -1},
/*01429*/     {0, -1, -1},
/*01430*/     {1119, -1, -1},
/*01431*/     {0, -1, -1},
/*01432*/     {0, -1, -1},
/*01433*/     {0, -1, -1},
/*01434*/     {1436, 27, 6},
/*01435*/     {1564, 34, 3},
/*01436*/     {0, -1, -1},
/*01437*/     {0, -1, -1},
/*01438*/     {0, -1, -1},
/*01439*/     {0, -1, -1},
/*01440*/     {0, -1, -1},
/*01441*/     {0, -1, -1},
/*01442*/     {0, -1, -1},
/*01443*/     {0, -1, -1},
/*01444*/     {0, -1, -1},
/*01445*/     {0, -1, -1},
/*01446*/     {0, -1, -1},
/*01447*/     {0, -1, -1},
/*01448*/     {0, -1, -1},
/*01449*/     {0, -1, -1},
/*01450*/     {0, -1, -1},
/*01451*/     {0, -1, -1},
/*01452*/     {1504, -1, -1},
/*01453*/     {1505, -1, -1},
/*01454*/     {1506, -1, -1},
/*01455*/     {0, -1, -1},
/*01456*/     {1500, 34, 2},
/*01457*/     {1504, 34, 2},
/*01458*/     {1508, 34, 2},
/*01459*/     {1512, 34, 2},
/*01460*/     {1516, 34, 2},
/*01461*/     {1520, 34, 2},
/*01462*/     {1524, 34, 2},
/*01463*/     {1528, 34, 2},
/*01464*/     {0, -1, -1},
/*01465*/     {0, -1, -1},
/*01466*/     {0, -1, -1},
/*01467*/     {0, -1, -1},
/*01468*/     {0, -1, -1},
/*01469*/     {0, -1, -1},
/*01470*/     {0, -1, -1},
/*01471*/     {0, -1, -1},
/*01472*/     {0, -1, -1},
/*01473*/     {0, -1, -1},
/*01474*/     {0, -1, -1},
/*01475*/     {0, -1, -1},
/*01476*/     {0, -1, -1},
/*01477*/     {0, -1, -1},
/*01478*/     {0, -1, -1},
/*01479*/     {0, -1, -1},
/*01480*/     {0, -1, -1},
/*01481*/     {0, -1, -1},
/*01482*/     {0, -1, -1},
/*01483*/     {0, -1, -1},
/*01484*/     {1532, 34, 2},
/*01485*/     {1536, 34, 2},
/*01486*/     {1540, 34, 2},
/*01487*/     {1544, 34, 2},
/*01488*/     {1548, 34, 2},
/*01489*/     {1552, 34, 2},
/*01490*/     {1556, 34, 2},
/*01491*/     {1560, 34, 2},
/*01492*/     {0, -1, -1},
/*01493*/     {0, -1, -1},
/*01494*/     {0, -1, -1},
/*01495*/     {0, -1, -1},
/*01496*/     {0, -1, -1},
/*01497*/     {0, -1, -1},
/*01498*/     {0, -1, -1},
/*01499*/     {0, -1, -1},
/*01500*/     {1440, -1, -1},
/*01501*/     {1441, -1, -1},
/*01502*/     {1442, -1, -1},
/*01503*/     {1443, -1, -1},
/*01504*/     {1444, -1, -1},
/*01505*/     {1445, -1, -1},
/*01506*/     {1446, -1, -1},
/*01507*/     {1447, -1, -1},
/*01508*/     {1448, -1, -1},
/*01509*/     {1449, -1, -1},
/*01510*/     {1450, -1, -1},
/*01511*/     {1451, -1, -1},
/*01512*/     {1452, -1, -1},
/*01513*/     {1453, -1, -1},
/*01514*/     {1454, -1, -1},
/*01515*/     {1455, -1, -1},
/*01516*/     {1523, -1, -1},
/*01517*/     {1524, -1, -1},
/*01518*/     {1525, -1, -1},
/*01519*/     {1526, -1, -1},
/*01520*/     {1527, -1, -1},
/*01521*/     {1528, -1, -1},
/*01522*/     {1529, -1, -1},
/*01523*/     {1530, -1, -1},
/*01524*/     {1531, -1, -1},
/*01525*/     {1532, -1, -1},
/*01526*/     {1533, -1, -1},
/*01527*/     {1534, -1, -1},
/*01528*/     {1535, -1, -1},
/*01529*/     {1536, -1, -1},
/*01530*/     {1537, -1, -1},
/*01531*/     {1538, -1, -1},
/*01532*/     {1456, -1, -1},
/*01533*/     {1457, -1, -1},
/*01534*/     {1458, -1, -1},
/*01535*/     {1459, -1, -1},
/*01536*/     {1460, -1, -1},
/*01537*/     {1461, -1, -1},
/*01538*/     {1462, -1, -1},
/*01539*/     {1463, -1, -1},
/*01540*/     {1464, -1, -1},
/*01541*/     {1465, -1, -1},
/*01542*/     {1466, -1, -1},
/*01543*/     {1467, -1, -1},
/*01544*/     {1468, -1, -1},
/*01545*/     {1469, -1, -1},
/*01546*/     {1470, -1, -1},
/*01547*/     {1471, -1, -1},
/*01548*/     {1472, -1, -1},
/*01549*/     {1473, -1, -1},
/*01550*/     {1474, -1, -1},
/*01551*/     {1475, -1, -1},
/*01552*/     {1476, -1, -1},
/*01553*/     {1477, -1, -1},
/*01554*/     {1478, -1, -1},
/*01555*/     {1479, -1, -1},
/*01556*/     {1480, -1, -1},
/*01557*/     {1481, -1, -1},
/*01558*/     {1482, -1, -1},
/*01559*/     {1483, -1, -1},
/*01560*/     {1484, -1, -1},
/*01561*/     {1485, -1, -1},
/*01562*/     {1486, -1, -1},
/*01563*/     {1487, -1, -1},
/*01564*/     {1412, -1, -1},
/*01565*/     {1413, -1, -1},
/*01566*/     {1414, -1, -1},
/*01567*/     {1415, -1, -1},
/*01568*/     {1420, -1, -1},
/*01569*/     {1421, -1, -1},
/*01570*/     {1422, -1, -1},
/*01571*/     {1423, -1, -1},
/*01572*/     {1588, 12, 1},
/*01573*/     {1590, 12, 1},
/*01574*/     {1592, 12, 1},
/*01575*/     {1594, 12, 1},
/*01576*/     {1596, 12, 1},
/*01577*/     {1598, 12, 1},
/*01578*/     {1600, 12, 1},
/*01579*/     {1602, 12, 1},
/*01580*/     {1604, 12, 1},
/*01581*/     {1606, 12, 1},
/*01582*/     {1608, 12, 1},
/*01583*/     {1610, 12, 1},
/*01584*/     {1612, 12, 1},
/*01585*/     {1614, 12, 1},
/*01586*/     {1616, 12, 1},
/*01587*/     {1618, 12, 1},
/*01588*/     {1280, -1, -1},
/*01589*/     {1281, -1, -1},
/*01590*/     {1280, -1, -1},
/*01591*/     {1281, -1, -1},
/*01592*/     {1280, -1, -1},
/*01593*/     {1281, -1, -1},
/*01594*/     {1282, -1, -1},
/*01595*/     {1283, -1, -1},
/*01596*/     {1280, -1, -1},
/*01597*/     {1281, -1, -1},
/*01598*/     {1284, -1, -1},
/*01599*/     {1285, -1, -1},
/*01600*/     {1280, -1, -1},
/*01601*/     {1281, -1, -1},
/*01602*/     {1286, -1, -1},
/*01603*/     {1287, -1, -1},
/*01604*/     {1288, -1, -1},
/*01605*/     {1289, -1, -1},
/*01606*/     {1288, -1, -1},
/*01607*/     {1289, -1, -1},
/*01608*/     {1288, -1, -1},
/*01609*/     {1289, -1, -1},
/*01610*/     {1290, -1, -1},
/*01611*/     {1291, -1, -1},
/*01612*/     {1288, -1, -1},
/*01613*/     {1289, -1, -1},
/*01614*/     {1292, -1, -1},
/*01615*/     {1293, -1, -1},
/*01616*/     {1288, -1, -1},
/*01617*/     {1289, -1, -1},
/*01618*/     {1294, -1, -1},
/*01619*/     {1295, -1, -1},
/*01620*/     {1321, -1, -1},
/*01621*/     {0, -1, -1},
/*01622*/     {0, -1, -1},
/*01623*/     {0, -1, -1},
/*01624*/     {0, -1, -1},
/*01625*/     {0, -1, -1},
/*01626*/     {0, -1, -1},
/*01627*/     {0, -1, -1},
/*01628*/     {0, -1, -1},
/*01629*/     {0, -1, -1},
/*01630*/     {0, -1, -1},
/*01631*/     {0, -1, -1},
/*01632*/     {0, -1, -1},
/*01633*/     {0, -1, -1},
/*01634*/     {0, -1, -1},
/*01635*/     {0, -1, -1},
/*01636*/     {1684, 0, 6},
/*01637*/     {1756, 0, 6},
/*01638*/     {0, -1, -1},
/*01639*/     {0, -1, -1},
/*01640*/     {0, -1, -1},
/*01641*/     {0, -1, -1},
/*01642*/     {0, -1, -1},
/*01643*/     {0, -1, -1},
/*01644*/     {0, -1, -1},
/*01645*/     {0, -1, -1},
/*01646*/     {0, -1, -1},
/*01647*/     {0, -1, -1},
/*01648*/     {0, -1, -1},
/*01649*/     {0, -1, -1},
/*01650*/     {0, -1, -1},
/*01651*/     {0, -1, -1},
/*01652*/     {0, -1, -1},
/*01653*/     {0, -1, -1},
/*01654*/     {0, -1, -1},
/*01655*/     {0, -1, -1},
/*01656*/     {0, -1, -1},
/*01657*/     {0, -1, -1},
/*01658*/     {0, -1, -1},
/*01659*/     {0, -1, -1},
/*01660*/     {0, -1, -1},
/*01661*/     {0, -1, -1},
/*01662*/     {0, -1, -1},
/*01663*/     {0, -1, -1},
/*01664*/     {0, -1, -1},
/*01665*/     {0, -1, -1},
/*01666*/     {0, -1, -1},
/*01667*/     {0, -1, -1},
/*01668*/     {0, -1, -1},
/*01669*/     {0, -1, -1},
/*01670*/     {0, -1, -1},
/*01671*/     {0, -1, -1},
/*01672*/     {0, -1, -1},
/*01673*/     {0, -1, -1},
/*01674*/     {0, -1, -1},
/*01675*/     {0, -1, -1},
/*01676*/     {0, -1, -1},
/*01677*/     {0, -1, -1},
/*01678*/     {0, -1, -1},
/*01679*/     {0, -1, -1},
/*01680*/     {0, -1, -1},
/*01681*/     {0, -1, -1},
/*01682*/     {0, -1, -1},
/*01683*/     {0, -1, -1},
/*01684*/     {1748, 35, 1},
/*01685*/     {0, -1, -1},
/*01686*/     {0, -1, -1},
/*01687*/     {0, -1, -1},
/*01688*/     {0, -1, -1},
/*01689*/     {0, -1, -1},
/*01690*/     {0, -1, -1},
/*01691*/     {0, -1, -1},
/*01692*/     {1750, 35, 1},
/*01693*/     {0, -1, -1},
/*01694*/     {0, -1, -1},
/*01695*/     {0, -1, -1},
/*01696*/     {0, -1, -1},
/*01697*/     {0, -1, -1},
/*01698*/     {0, -1, -1},
/*01699*/     {0, -1, -1},
/*01700*/     {1752, 35, 1},
/*01701*/     {0, -1, -1},
/*01702*/     {0, -1, -1},
/*01703*/     {0, -1, -1},
/*01704*/     {0, -1, -1},
/*01705*/     {0, -1, -1},
/*01706*/     {0, -1, -1},
/*01707*/     {0, -1, -1},
/*01708*/     {1754, 35, 1},
/*01709*/     {0, -1, -1},
/*01710*/     {0, -1, -1},
/*01711*/     {0, -1, -1},
/*01712*/     {0, -1, -1},
/*01713*/     {0, -1, -1},
/*01714*/     {0, -1, -1},
/*01715*/     {0, -1, -1},
/*01716*/     {0, -1, -1},
/*01717*/     {0, -1, -1},
/*01718*/     {0, -1, -1},
/*01719*/     {0, -1, -1},
/*01720*/     {0, -1, -1},
/*01721*/     {0, -1, -1},
/*01722*/     {0, -1, -1},
/*01723*/     {0, -1, -1},
/*01724*/     {0, -1, -1},
/*01725*/     {0, -1, -1},
/*01726*/     {0, -1, -1},
/*01727*/     {0, -1, -1},
/*01728*/     {0, -1, -1},
/*01729*/     {0, -1, -1},
/*01730*/     {0, -1, -1},
/*01731*/     {0, -1, -1},
/*01732*/     {0, -1, -1},
/*01733*/     {0, -1, -1},
/*01734*/     {0, -1, -1},
/*01735*/     {0, -1, -1},
/*01736*/     {0, -1, -1},
/*01737*/     {0, -1, -1},
/*01738*/     {0, -1, -1},
/*01739*/     {0, -1, -1},
/*01740*/     {0, -1, -1},
/*01741*/     {0, -1, -1},
/*01742*/     {0, -1, -1},
/*01743*/     {0, -1, -1},
/*01744*/     {0, -1, -1},
/*01745*/     {0, -1, -1},
/*01746*/     {0, -1, -1},
/*01747*/     {0, -1, -1},
/*01748*/     {1304, -1, -1},
/*01749*/     {1305, -1, -1},
/*01750*/     {1304, -1, -1},
/*01751*/     {1305, -1, -1},
/*01752*/     {1306, -1, -1},
/*01753*/     {1307, -1, -1},
/*01754*/     {1304, -1, -1},
/*01755*/     {1305, -1, -1},
/*01756*/     {1820, 35, 1},
/*01757*/     {0, -1, -1},
/*01758*/     {0, -1, -1},
/*01759*/     {0, -1, -1},
/*01760*/     {0, -1, -1},
/*01761*/     {0, -1, -1},
/*01762*/     {0, -1, -1},
/*01763*/     {0, -1, -1},
/*01764*/     {1822, 35, 1},
/*01765*/     {0, -1, -1},
/*01766*/     {0, -1, -1},
/*01767*/     {0, -1, -1},
/*01768*/     {0, -1, -1},
/*01769*/     {0, -1, -1},
/*01770*/     {0, -1, -1},
/*01771*/     {0, -1, -1},
/*01772*/     {1824, 35, 1},
/*01773*/     {0, -1, -1},
/*01774*/     {0, -1, -1},
/*01775*/     {0, -1, -1},
/*01776*/     {0, -1, -1},
/*01777*/     {0, -1, -1},
/*01778*/     {0, -1, -1},
/*01779*/     {0, -1, -1},
/*01780*/     {1826, 35, 1},
/*01781*/     {0, -1, -1},
/*01782*/     {0, -1, -1},
/*01783*/     {0, -1, -1},
/*01784*/     {0, -1, -1},
/*01785*/     {0, -1, -1},
/*01786*/     {0, -1, -1},
/*01787*/     {0, -1, -1},
/*01788*/     {0, -1, -1},
/*01789*/     {0, -1, -1},
/*01790*/     {0, -1, -1},
/*01791*/     {0, -1, -1},
/*01792*/     {0, -1, -1},
/*01793*/     {0, -1, -1},
/*01794*/     {0, -1, -1},
/*01795*/     {0, -1, -1},
/*01796*/     {0, -1, -1},
/*01797*/     {0, -1, -1},
/*01798*/     {0, -1, -1},
/*01799*/     {0, -1, -1},
/*01800*/     {0, -1, -1},
/*01801*/     {0, -1, -1},
/*01802*/     {0, -1, -1},
/*01803*/     {0, -1, -1},
/*01804*/     {0, -1, -1},
/*01805*/     {0, -1, -1},
/*01806*/     {0, -1, -1},
/*01807*/     {0, -1, -1},
/*01808*/     {0, -1, -1},
/*01809*/     {0, -1, -1},
/*01810*/     {0, -1, -1},
/*01811*/     {0, -1, -1},
/*01812*/     {0, -1, -1},
/*01813*/     {0, -1, -1},
/*01814*/     {0, -1, -1},
/*01815*/     {0, -1, -1},
/*01816*/     {0, -1, -1},
/*01817*/     {0, -1, -1},
/*01818*/     {0, -1, -1},
/*01819*/     {0, -1, -1},
/*01820*/     {1308, -1, -1},
/*01821*/     {1309, -1, -1},
/*01822*/     {1308, -1, -1},
/*01823*/     {1309, -1, -1},
/*01824*/     {1310, -1, -1},
/*01825*/     {1311, -1, -1},
/*01826*/     {1308, -1, -1},
/*01827*/     {1309, -1, -1},
/*01828*/     {1956, 27, 3},
/*01829*/     {1964, 27, 3},
/*01830*/     {1972, 27, 3},
/*01831*/     {1980, 27, 3},
/*01832*/     {1988, 27, 3},
/*01833*/     {1996, 27, 3},
/*01834*/     {2004, 27, 3},
/*01835*/     {2012, 27, 3},
/*01836*/     {2020, 27, 3},
/*01837*/     {2028, 27, 3},
/*01838*/     {2036, 27, 3},
/*01839*/     {2044, 27, 3},
/*01840*/     {2052, 27, 3},
/*01841*/     {2060, 27, 3},
/*01842*/     {2068, 27, 3},
/*01843*/     {2076, 27, 3},
/*01844*/     {2084, 27, 3},
/*01845*/     {2092, 27, 3},
/*01846*/     {2100, 27, 3},
/*01847*/     {2108, 27, 3},
/*01848*/     {2116, 27, 3},
/*01849*/     {2124, 27, 3},
/*01850*/     {2132, 27, 3},
/*01851*/     {2140, 27, 3},
/*01852*/     {0, -1, -1},
/*01853*/     {0, -1, -1},
/*01854*/     {0, -1, -1},
/*01855*/     {2148, 27, 3},
/*01856*/     {2156, 27, 1},
/*01857*/     {2158, 27, 1},
/*01858*/     {2160, 27, 1},
/*01859*/     {2162, 27, 1},
/*01860*/     {2164, 27, 3},
/*01861*/     {2172, 27, 3},
/*01862*/     {2180, 27, 3},
/*01863*/     {2188, 27, 3},
/*01864*/     {2196, 27, 3},
/*01865*/     {2204, 27, 3},
/*01866*/     {2212, 27, 3},
/*01867*/     {2220, 27, 3},
/*01868*/     {2228, 27, 3},
/*01869*/     {2236, 27, 3},
/*01870*/     {2244, 27, 3},
/*01871*/     {2252, 27, 3},
/*01872*/     {0, -1, -1},
/*01873*/     {0, -1, -1},
/*01874*/     {0, -1, -1},
/*01875*/     {0, -1, -1},
/*01876*/     {2260, 27, 3},
/*01877*/     {2268, 27, 3},
/*01878*/     {2276, 27, 3},
/*01879*/     {2284, 27, 3},
/*01880*/     {2292, 27, 3},
/*01881*/     {2300, 27, 3},
/*01882*/     {2308, 27, 3},
/*01883*/     {2316, 27, 3},
/*01884*/     {0, -1, -1},
/*01885*/     {0, -1, -1},
/*01886*/     {0, -1, -1},
/*01887*/     {2324, 27, 3},
/*01888*/     {0, -1, -1},
/*01889*/     {0, -1, -1},
/*01890*/     {0, -1, -1},
/*01891*/     {0, -1, -1},
/*01892*/     {2332, 27, 3},
/*01893*/     {2340, 27, 3},
/*01894*/     {2348, 27, 3},
/*01895*/     {2356, 27, 3},
/*01896*/     {2364, 27, 3},
/*01897*/     {2372, 27, 3},
/*01898*/     {2380, 27, 3},
/*01899*/     {2388, 27, 3},
/*01900*/     {2396, 27, 3},
/*01901*/     {2404, 27, 3},
/*01902*/     {2412, 27, 3},
/*01903*/     {2420, 27, 3},
/*01904*/     {2428, 27, 3},
/*01905*/     {2436, 27, 3},
/*01906*/     {2444, 27, 3},
/*01907*/     {2452, 27, 3},
/*01908*/     {2460, 27, 3},
/*01909*/     {2468, 27, 3},
/*01910*/     {2476, 27, 3},
/*01911*/     {2484, 27, 3},
/*01912*/     {2492, 27, 3},
/*01913*/     {2500, 27, 3},
/*01914*/     {2508, 27, 3},
/*01915*/     {2516, 27, 3},
/*01916*/     {0, -1, -1},
/*01917*/     {0, -1, -1},
/*01918*/     {0, -1, -1},
/*01919*/     {2524, 27, 3},
/*01920*/     {0, -1, -1},
/*01921*/     {0, -1, -1},
/*01922*/     {0, -1, -1},
/*01923*/     {0, -1, -1},
/*01924*/     {2532, 27, 3},
/*01925*/     {2540, 27, 3},
/*01926*/     {2548, 27, 3},
/*01927*/     {2556, 27, 3},
/*01928*/     {2564, 27, 3},
/*01929*/     {2572, 27, 3},
/*01930*/     {2580, 27, 3},
/*01931*/     {2588, 27, 3},
/*01932*/     {2596, 27, 3},
/*01933*/     {2604, 27, 3},
/*01934*/     {2612, 27, 3},
/*01935*/     {2620, 27, 3},
/*01936*/     {0, -1, -1},
/*01937*/     {0, -1, -1},
/*01938*/     {0, -1, -1},
/*01939*/     {0, -1, -1},
/*01940*/     {0, -1, -1},
/*01941*/     {0, -1, -1},
/*01942*/     {0, -1, -1},
/*01943*/     {0, -1, -1},
/*01944*/     {0, -1, -1},
/*01945*/     {0, -1, -1},
/*01946*/     {0, -1, -1},
/*01947*/     {0, -1, -1},
/*01948*/     {0, -1, -1},
/*01949*/     {0, -1, -1},
/*01950*/     {0, -1, -1},
/*01951*/     {0, -1, -1},
/*01952*/     {0, -1, -1},
/*01953*/     {0, -1, -1},
/*01954*/     {0, -1, -1},
/*01955*/     {0, -1, -1},
/*01956*/     {223, -1, -1},
/*01957*/     {993, -1, -1},
/*01958*/     {224, -1, -1},
/*01959*/     {994, -1, -1},
/*01960*/     {223, -1, -1},
/*01961*/     {993, -1, -1},
/*01962*/     {225, -1, -1},
/*01963*/     {995, -1, -1},
/*01964*/     {226, -1, -1},
/*01965*/     {996, -1, -1},
/*01966*/     {227, -1, -1},
/*01967*/     {997, -1, -1},
/*01968*/     {226, -1, -1},
/*01969*/     {996, -1, -1},
/*01970*/     {228, -1, -1},
/*01971*/     {998, -1, -1},
/*01972*/     {229, -1, -1},
/*01973*/     {999, -1, -1},
/*01974*/     {230, -1, -1},
/*01975*/     {1000, -1, -1},
/*01976*/     {229, -1, -1},
/*01977*/     {999, -1, -1},
/*01978*/     {231, -1, -1},
/*01979*/     {1001, -1, -1},
/*01980*/     {232, -1, -1},
/*01981*/     {1002, -1, -1},
/*01982*/     {233, -1, -1},
/*01983*/     {1003, -1, -1},
/*01984*/     {232, -1, -1},
/*01985*/     {1002, -1, -1},
/*01986*/     {234, -1, -1},
/*01987*/     {1004, -1, -1},
/*01988*/     {235, -1, -1},
/*01989*/     {1005, -1, -1},
/*01990*/     {236, -1, -1},
/*01991*/     {1006, -1, -1},
/*01992*/     {235, -1, -1},
/*01993*/     {1005, -1, -1},
/*01994*/     {237, -1, -1},
/*01995*/     {1007, -1, -1},
/*01996*/     {238, -1, -1},
/*01997*/     {1008, -1, -1},
/*01998*/     {239, -1, -1},
/*01999*/     {1009, -1, -1},
/*02000*/     {238, -1, -1},
/*02001*/     {1008, -1, -1},
/*02002*/     {240, -1, -1},
/*02003*/     {1010, -1, -1},
/*02004*/     {241, -1, -1},
/*02005*/     {1011, -1, -1},
/*02006*/     {242, -1, -1},
/*02007*/     {1012, -1, -1},
/*02008*/     {241, -1, -1},
/*02009*/     {1011, -1, -1},
/*02010*/     {243, -1, -1},
/*02011*/     {1013, -1, -1},
/*02012*/     {244, -1, -1},
/*02013*/     {1014, -1, -1},
/*02014*/     {245, -1, -1},
/*02015*/     {1015, -1, -1},
/*02016*/     {244, -1, -1},
/*02017*/     {1014, -1, -1},
/*02018*/     {246, -1, -1},
/*02019*/     {1016, -1, -1},
/*02020*/     {247, -1, -1},
/*02021*/     {1017, -1, -1},
/*02022*/     {248, -1, -1},
/*02023*/     {1018, -1, -1},
/*02024*/     {247, -1, -1},
/*02025*/     {1017, -1, -1},
/*02026*/     {249, -1, -1},
/*02027*/     {1019, -1, -1},
/*02028*/     {250, -1, -1},
/*02029*/     {1020, -1, -1},
/*02030*/     {251, -1, -1},
/*02031*/     {1021, -1, -1},
/*02032*/     {250, -1, -1},
/*02033*/     {1020, -1, -1},
/*02034*/     {252, -1, -1},
/*02035*/     {1022, -1, -1},
/*02036*/     {253, -1, -1},
/*02037*/     {1023, -1, -1},
/*02038*/     {254, -1, -1},
/*02039*/     {1024, -1, -1},
/*02040*/     {253, -1, -1},
/*02041*/     {1023, -1, -1},
/*02042*/     {255, -1, -1},
/*02043*/     {1025, -1, -1},
/*02044*/     {256, -1, -1},
/*02045*/     {1026, -1, -1},
/*02046*/     {257, -1, -1},
/*02047*/     {1027, -1, -1},
/*02048*/     {256, -1, -1},
/*02049*/     {1026, -1, -1},
/*02050*/     {258, -1, -1},
/*02051*/     {1028, -1, -1},
/*02052*/     {259, -1, -1},
/*02053*/     {0, -1, -1},
/*02054*/     {260, -1, -1},
/*02055*/     {0, -1, -1},
/*02056*/     {259, -1, -1},
/*02057*/     {0, -1, -1},
/*02058*/     {261, -1, -1},
/*02059*/     {0, -1, -1},
/*02060*/     {262, -1, -1},
/*02061*/     {0, -1, -1},
/*02062*/     {263, -1, -1},
/*02063*/     {0, -1, -1},
/*02064*/     {262, -1, -1},
/*02065*/     {0, -1, -1},
/*02066*/     {264, -1, -1},
/*02067*/     {0, -1, -1},
/*02068*/     {265, -1, -1},
/*02069*/     {0, -1, -1},
/*02070*/     {266, -1, -1},
/*02071*/     {0, -1, -1},
/*02072*/     {265, -1, -1},
/*02073*/     {0, -1, -1},
/*02074*/     {267, -1, -1},
/*02075*/     {0, -1, -1},
/*02076*/     {268, -1, -1},
/*02077*/     {0, -1, -1},
/*02078*/     {269, -1, -1},
/*02079*/     {0, -1, -1},
/*02080*/     {268, -1, -1},
/*02081*/     {0, -1, -1},
/*02082*/     {270, -1, -1},
/*02083*/     {0, -1, -1},
/*02084*/     {271, -1, -1},
/*02085*/     {0, -1, -1},
/*02086*/     {272, -1, -1},
/*02087*/     {0, -1, -1},
/*02088*/     {271, -1, -1},
/*02089*/     {0, -1, -1},
/*02090*/     {273, -1, -1},
/*02091*/     {0, -1, -1},
/*02092*/     {274, -1, -1},
/*02093*/     {0, -1, -1},
/*02094*/     {275, -1, -1},
/*02095*/     {0, -1, -1},
/*02096*/     {274, -1, -1},
/*02097*/     {0, -1, -1},
/*02098*/     {276, -1, -1},
/*02099*/     {0, -1, -1},
/*02100*/     {277, -1, -1},
/*02101*/     {1029, -1, -1},
/*02102*/     {278, -1, -1},
/*02103*/     {1030, -1, -1},
/*02104*/     {277, -1, -1},
/*02105*/     {1029, -1, -1},
/*02106*/     {279, -1, -1},
/*02107*/     {1031, -1, -1},
/*02108*/     {280, -1, -1},
/*02109*/     {1032, -1, -1},
/*02110*/     {281, -1, -1},
/*02111*/     {1033, -1, -1},
/*02112*/     {280, -1, -1},
/*02113*/     {1032, -1, -1},
/*02114*/     {282, -1, -1},
/*02115*/     {1034, -1, -1},
/*02116*/     {283, -1, -1},
/*02117*/     {0, -1, -1},
/*02118*/     {284, -1, -1},
/*02119*/     {0, -1, -1},
/*02120*/     {283, -1, -1},
/*02121*/     {0, -1, -1},
/*02122*/     {285, -1, -1},
/*02123*/     {0, -1, -1},
/*02124*/     {286, -1, -1},
/*02125*/     {0, -1, -1},
/*02126*/     {287, -1, -1},
/*02127*/     {0, -1, -1},
/*02128*/     {286, -1, -1},
/*02129*/     {0, -1, -1},
/*02130*/     {288, -1, -1},
/*02131*/     {0, -1, -1},
/*02132*/     {289, -1, -1},
/*02133*/     {1035, -1, -1},
/*02134*/     {290, -1, -1},
/*02135*/     {1036, -1, -1},
/*02136*/     {289, -1, -1},
/*02137*/     {1035, -1, -1},
/*02138*/     {291, -1, -1},
/*02139*/     {1037, -1, -1},
/*02140*/     {292, -1, -1},
/*02141*/     {1038, -1, -1},
/*02142*/     {293, -1, -1},
/*02143*/     {1039, -1, -1},
/*02144*/     {292, -1, -1},
/*02145*/     {1038, -1, -1},
/*02146*/     {294, -1, -1},
/*02147*/     {1040, -1, -1},
/*02148*/     {295, -1, -1},
/*02149*/     {0, -1, -1},
/*02150*/     {296, -1, -1},
/*02151*/     {0, -1, -1},
/*02152*/     {295, -1, -1},
/*02153*/     {0, -1, -1},
/*02154*/     {297, -1, -1},
/*02155*/     {0, -1, -1},
/*02156*/     {0, -1, -1},
/*02157*/     {1045, -1, -1},
/*02158*/     {0, -1, -1},
/*02159*/     {1046, -1, -1},
/*02160*/     {0, -1, -1},
/*02161*/     {1047, -1, -1},
/*02162*/     {0, -1, -1},
/*02163*/     {1048, -1, -1},
/*02164*/     {298, -1, -1},
/*02165*/     {0, -1, -1},
/*02166*/     {299, -1, -1},
/*02167*/     {0, -1, -1},
/*02168*/     {298, -1, -1},
/*02169*/     {0, -1, -1},
/*02170*/     {300, -1, -1},
/*02171*/     {0, -1, -1},
/*02172*/     {301, -1, -1},
/*02173*/     {0, -1, -1},
/*02174*/     {302, -1, -1},
/*02175*/     {0, -1, -1},
/*02176*/     {301, -1, -1},
/*02177*/     {0, -1, -1},
/*02178*/     {303, -1, -1},
/*02179*/     {0, -1, -1},
/*02180*/     {304, -1, -1},
/*02181*/     {0, -1, -1},
/*02182*/     {305, -1, -1},
/*02183*/     {0, -1, -1},
/*02184*/     {304, -1, -1},
/*02185*/     {0, -1, -1},
/*02186*/     {306, -1, -1},
/*02187*/     {0, -1, -1},
/*02188*/     {307, -1, -1},
/*02189*/     {0, -1, -1},
/*02190*/     {308, -1, -1},
/*02191*/     {0, -1, -1},
/*02192*/     {307, -1, -1},
/*02193*/     {0, -1, -1},
/*02194*/     {309, -1, -1},
/*02195*/     {0, -1, -1},
/*02196*/     {310, -1, -1},
/*02197*/     {0, -1, -1},
/*02198*/     {311, -1, -1},
/*02199*/     {0, -1, -1},
/*02200*/     {310, -1, -1},
/*02201*/     {0, -1, -1},
/*02202*/     {312, -1, -1},
/*02203*/     {0, -1, -1},
/*02204*/     {313, -1, -1},
/*02205*/     {0, -1, -1},
/*02206*/     {314, -1, -1},
/*02207*/     {0, -1, -1},
/*02208*/     {313, -1, -1},
/*02209*/     {0, -1, -1},
/*02210*/     {315, -1, -1},
/*02211*/     {0, -1, -1},
/*02212*/     {316, -1, -1},
/*02213*/     {0, -1, -1},
/*02214*/     {317, -1, -1},
/*02215*/     {0, -1, -1},
/*02216*/     {316, -1, -1},
/*02217*/     {0, -1, -1},
/*02218*/     {318, -1, -1},
/*02219*/     {0, -1, -1},
/*02220*/     {319, -1, -1},
/*02221*/     {0, -1, -1},
/*02222*/     {320, -1, -1},
/*02223*/     {0, -1, -1},
/*02224*/     {319, -1, -1},
/*02225*/     {0, -1, -1},
/*02226*/     {321, -1, -1},
/*02227*/     {0, -1, -1},
/*02228*/     {322, -1, -1},
/*02229*/     {0, -1, -1},
/*02230*/     {323, -1, -1},
/*02231*/     {0, -1, -1},
/*02232*/     {322, -1, -1},
/*02233*/     {0, -1, -1},
/*02234*/     {324, -1, -1},
/*02235*/     {0, -1, -1},
/*02236*/     {325, -1, -1},
/*02237*/     {0, -1, -1},
/*02238*/     {326, -1, -1},
/*02239*/     {0, -1, -1},
/*02240*/     {325, -1, -1},
/*02241*/     {0, -1, -1},
/*02242*/     {327, -1, -1},
/*02243*/     {0, -1, -1},
/*02244*/     {328, -1, -1},
/*02245*/     {0, -1, -1},
/*02246*/     {329, -1, -1},
/*02247*/     {0, -1, -1},
/*02248*/     {328, -1, -1},
/*02249*/     {0, -1, -1},
/*02250*/     {330, -1, -1},
/*02251*/     {0, -1, -1},
/*02252*/     {331, -1, -1},
/*02253*/     {0, -1, -1},
/*02254*/     {332, -1, -1},
/*02255*/     {0, -1, -1},
/*02256*/     {331, -1, -1},
/*02257*/     {0, -1, -1},
/*02258*/     {333, -1, -1},
/*02259*/     {0, -1, -1},
/*02260*/     {556, -1, -1},
/*02261*/     {0, -1, -1},
/*02262*/     {556, -1, -1},
/*02263*/     {0, -1, -1},
/*02264*/     {556, -1, -1},
/*02265*/     {0, -1, -1},
/*02266*/     {557, -1, -1},
/*02267*/     {0, -1, -1},
/*02268*/     {558, -1, -1},
/*02269*/     {0, -1, -1},
/*02270*/     {558, -1, -1},
/*02271*/     {0, -1, -1},
/*02272*/     {558, -1, -1},
/*02273*/     {0, -1, -1},
/*02274*/     {559, -1, -1},
/*02275*/     {0, -1, -1},
/*02276*/     {560, -1, -1},
/*02277*/     {0, -1, -1},
/*02278*/     {560, -1, -1},
/*02279*/     {0, -1, -1},
/*02280*/     {560, -1, -1},
/*02281*/     {0, -1, -1},
/*02282*/     {561, -1, -1},
/*02283*/     {0, -1, -1},
/*02284*/     {562, -1, -1},
/*02285*/     {0, -1, -1},
/*02286*/     {562, -1, -1},
/*02287*/     {0, -1, -1},
/*02288*/     {562, -1, -1},
/*02289*/     {0, -1, -1},
/*02290*/     {563, -1, -1},
/*02291*/     {0, -1, -1},
/*02292*/     {564, -1, -1},
/*02293*/     {0, -1, -1},
/*02294*/     {564, -1, -1},
/*02295*/     {0, -1, -1},
/*02296*/     {564, -1, -1},
/*02297*/     {0, -1, -1},
/*02298*/     {565, -1, -1},
/*02299*/     {0, -1, -1},
/*02300*/     {566, -1, -1},
/*02301*/     {0, -1, -1},
/*02302*/     {566, -1, -1},
/*02303*/     {0, -1, -1},
/*02304*/     {566, -1, -1},
/*02305*/     {0, -1, -1},
/*02306*/     {567, -1, -1},
/*02307*/     {0, -1, -1},
/*02308*/     {568, -1, -1},
/*02309*/     {0, -1, -1},
/*02310*/     {568, -1, -1},
/*02311*/     {0, -1, -1},
/*02312*/     {568, -1, -1},
/*02313*/     {0, -1, -1},
/*02314*/     {569, -1, -1},
/*02315*/     {0, -1, -1},
/*02316*/     {570, -1, -1},
/*02317*/     {0, -1, -1},
/*02318*/     {570, -1, -1},
/*02319*/     {0, -1, -1},
/*02320*/     {570, -1, -1},
/*02321*/     {0, -1, -1},
/*02322*/     {571, -1, -1},
/*02323*/     {0, -1, -1},
/*02324*/     {572, -1, -1},
/*02325*/     {0, -1, -1},
/*02326*/     {572, -1, -1},
/*02327*/     {0, -1, -1},
/*02328*/     {572, -1, -1},
/*02329*/     {0, -1, -1},
/*02330*/     {573, -1, -1},
/*02331*/     {0, -1, -1},
/*02332*/     {334, -1, -1},
/*02333*/     {0, -1, -1},
/*02334*/     {335, -1, -1},
/*02335*/     {0, -1, -1},
/*02336*/     {334, -1, -1},
/*02337*/     {0, -1, -1},
/*02338*/     {336, -1, -1},
/*02339*/     {0, -1, -1},
/*02340*/     {337, -1, -1},
/*02341*/     {0, -1, -1},
/*02342*/     {338, -1, -1},
/*02343*/     {0, -1, -1},
/*02344*/     {337, -1, -1},
/*02345*/     {0, -1, -1},
/*02346*/     {339, -1, -1},
/*02347*/     {0, -1, -1},
/*02348*/     {340, -1, -1},
/*02349*/     {0, -1, -1},
/*02350*/     {341, -1, -1},
/*02351*/     {0, -1, -1},
/*02352*/     {340, -1, -1},
/*02353*/     {0, -1, -1},
/*02354*/     {342, -1, -1},
/*02355*/     {0, -1, -1},
/*02356*/     {343, -1, -1},
/*02357*/     {0, -1, -1},
/*02358*/     {344, -1, -1},
/*02359*/     {0, -1, -1},
/*02360*/     {343, -1, -1},
/*02361*/     {0, -1, -1},
/*02362*/     {345, -1, -1},
/*02363*/     {0, -1, -1},
/*02364*/     {346, -1, -1},
/*02365*/     {0, -1, -1},
/*02366*/     {347, -1, -1},
/*02367*/     {0, -1, -1},
/*02368*/     {346, -1, -1},
/*02369*/     {0, -1, -1},
/*02370*/     {348, -1, -1},
/*02371*/     {0, -1, -1},
/*02372*/     {349, -1, -1},
/*02373*/     {0, -1, -1},
/*02374*/     {350, -1, -1},
/*02375*/     {0, -1, -1},
/*02376*/     {349, -1, -1},
/*02377*/     {0, -1, -1},
/*02378*/     {351, -1, -1},
/*02379*/     {0, -1, -1},
/*02380*/     {352, -1, -1},
/*02381*/     {0, -1, -1},
/*02382*/     {353, -1, -1},
/*02383*/     {0, -1, -1},
/*02384*/     {352, -1, -1},
/*02385*/     {0, -1, -1},
/*02386*/     {354, -1, -1},
/*02387*/     {0, -1, -1},
/*02388*/     {355, -1, -1},
/*02389*/     {0, -1, -1},
/*02390*/     {356, -1, -1},
/*02391*/     {0, -1, -1},
/*02392*/     {355, -1, -1},
/*02393*/     {0, -1, -1},
/*02394*/     {357, -1, -1},
/*02395*/     {0, -1, -1},
/*02396*/     {358, -1, -1},
/*02397*/     {0, -1, -1},
/*02398*/     {359, -1, -1},
/*02399*/     {0, -1, -1},
/*02400*/     {358, -1, -1},
/*02401*/     {0, -1, -1},
/*02402*/     {360, -1, -1},
/*02403*/     {0, -1, -1},
/*02404*/     {361, -1, -1},
/*02405*/     {0, -1, -1},
/*02406*/     {362, -1, -1},
/*02407*/     {0, -1, -1},
/*02408*/     {361, -1, -1},
/*02409*/     {0, -1, -1},
/*02410*/     {363, -1, -1},
/*02411*/     {0, -1, -1},
/*02412*/     {364, -1, -1},
/*02413*/     {0, -1, -1},
/*02414*/     {365, -1, -1},
/*02415*/     {0, -1, -1},
/*02416*/     {364, -1, -1},
/*02417*/     {0, -1, -1},
/*02418*/     {366, -1, -1},
/*02419*/     {0, -1, -1},
/*02420*/     {367, -1, -1},
/*02421*/     {0, -1, -1},
/*02422*/     {368, -1, -1},
/*02423*/     {0, -1, -1},
/*02424*/     {367, -1, -1},
/*02425*/     {0, -1, -1},
/*02426*/     {369, -1, -1},
/*02427*/     {0, -1, -1},
/*02428*/     {370, -1, -1},
/*02429*/     {0, -1, -1},
/*02430*/     {371, -1, -1},
/*02431*/     {0, -1, -1},
/*02432*/     {370, -1, -1},
/*02433*/     {0, -1, -1},
/*02434*/     {372, -1, -1},
/*02435*/     {0, -1, -1},
/*02436*/     {373, -1, -1},
/*02437*/     {0, -1, -1},
/*02438*/     {374, -1, -1},
/*02439*/     {0, -1, -1},
/*02440*/     {373, -1, -1},
/*02441*/     {0, -1, -1},
/*02442*/     {375, -1, -1},
/*02443*/     {0, -1, -1},
/*02444*/     {376, -1, -1},
/*02445*/     {0, -1, -1},
/*02446*/     {377, -1, -1},
/*02447*/     {0, -1, -1},
/*02448*/     {376, -1, -1},
/*02449*/     {0, -1, -1},
/*02450*/     {378, -1, -1},
/*02451*/     {0, -1, -1},
/*02452*/     {379, -1, -1},
/*02453*/     {0, -1, -1},
/*02454*/     {380, -1, -1},
/*02455*/     {0, -1, -1},
/*02456*/     {379, -1, -1},
/*02457*/     {0, -1, -1},
/*02458*/     {381, -1, -1},
/*02459*/     {0, -1, -1},
/*02460*/     {382, -1, -1},
/*02461*/     {0, -1, -1},
/*02462*/     {383, -1, -1},
/*02463*/     {0, -1, -1},
/*02464*/     {382, -1, -1},
/*02465*/     {0, -1, -1},
/*02466*/     {384, -1, -1},
/*02467*/     {0, -1, -1},
/*02468*/     {385, -1, -1},
/*02469*/     {0, -1, -1},
/*02470*/     {386, -1, -1},
/*02471*/     {0, -1, -1},
/*02472*/     {385, -1, -1},
/*02473*/     {0, -1, -1},
/*02474*/     {387, -1, -1},
/*02475*/     {0, -1, -1},
/*02476*/     {388, -1, -1},
/*02477*/     {0, -1, -1},
/*02478*/     {389, -1, -1},
/*02479*/     {0, -1, -1},
/*02480*/     {388, -1, -1},
/*02481*/     {0, -1, -1},
/*02482*/     {390, -1, -1},
/*02483*/     {0, -1, -1},
/*02484*/     {391, -1, -1},
/*02485*/     {0, -1, -1},
/*02486*/     {392, -1, -1},
/*02487*/     {0, -1, -1},
/*02488*/     {391, -1, -1},
/*02489*/     {0, -1, -1},
/*02490*/     {393, -1, -1},
/*02491*/     {0, -1, -1},
/*02492*/     {394, -1, -1},
/*02493*/     {0, -1, -1},
/*02494*/     {395, -1, -1},
/*02495*/     {0, -1, -1},
/*02496*/     {394, -1, -1},
/*02497*/     {0, -1, -1},
/*02498*/     {396, -1, -1},
/*02499*/     {0, -1, -1},
/*02500*/     {397, -1, -1},
/*02501*/     {0, -1, -1},
/*02502*/     {398, -1, -1},
/*02503*/     {0, -1, -1},
/*02504*/     {397, -1, -1},
/*02505*/     {0, -1, -1},
/*02506*/     {399, -1, -1},
/*02507*/     {0, -1, -1},
/*02508*/     {400, -1, -1},
/*02509*/     {0, -1, -1},
/*02510*/     {401, -1, -1},
/*02511*/     {0, -1, -1},
/*02512*/     {400, -1, -1},
/*02513*/     {0, -1, -1},
/*02514*/     {402, -1, -1},
/*02515*/     {0, -1, -1},
/*02516*/     {403, -1, -1},
/*02517*/     {0, -1, -1},
/*02518*/     {404, -1, -1},
/*02519*/     {0, -1, -1},
/*02520*/     {403, -1, -1},
/*02521*/     {0, -1, -1},
/*02522*/     {405, -1, -1},
/*02523*/     {0, -1, -1},
/*02524*/     {406, -1, -1},
/*02525*/     {0, -1, -1},
/*02526*/     {407, -1, -1},
/*02527*/     {0, -1, -1},
/*02528*/     {406, -1, -1},
/*02529*/     {0, -1, -1},
/*02530*/     {408, -1, -1},
/*02531*/     {0, -1, -1},
/*02532*/     {409, -1, -1},
/*02533*/     {0, -1, -1},
/*02534*/     {410, -1, -1},
/*02535*/     {0, -1, -1},
/*02536*/     {409, -1, -1},
/*02537*/     {0, -1, -1},
/*02538*/     {411, -1, -1},
/*02539*/     {0, -1, -1},
/*02540*/     {412, -1, -1},
/*02541*/     {0, -1, -1},
/*02542*/     {413, -1, -1},
/*02543*/     {0, -1, -1},
/*02544*/     {412, -1, -1},
/*02545*/     {0, -1, -1},
/*02546*/     {414, -1, -1},
/*02547*/     {0, -1, -1},
/*02548*/     {415, -1, -1},
/*02549*/     {0, -1, -1},
/*02550*/     {416, -1, -1},
/*02551*/     {0, -1, -1},
/*02552*/     {415, -1, -1},
/*02553*/     {0, -1, -1},
/*02554*/     {417, -1, -1},
/*02555*/     {0, -1, -1},
/*02556*/     {418, -1, -1},
/*02557*/     {0, -1, -1},
/*02558*/     {419, -1, -1},
/*02559*/     {0, -1, -1},
/*02560*/     {418, -1, -1},
/*02561*/     {0, -1, -1},
/*02562*/     {420, -1, -1},
/*02563*/     {0, -1, -1},
/*02564*/     {421, -1, -1},
/*02565*/     {0, -1, -1},
/*02566*/     {422, -1, -1},
/*02567*/     {0, -1, -1},
/*02568*/     {421, -1, -1},
/*02569*/     {0, -1, -1},
/*02570*/     {423, -1, -1},
/*02571*/     {0, -1, -1},
/*02572*/     {424, -1, -1},
/*02573*/     {0, -1, -1},
/*02574*/     {425, -1, -1},
/*02575*/     {0, -1, -1},
/*02576*/     {424, -1, -1},
/*02577*/     {0, -1, -1},
/*02578*/     {426, -1, -1},
/*02579*/     {0, -1, -1},
/*02580*/     {427, -1, -1},
/*02581*/     {0, -1, -1},
/*02582*/     {428, -1, -1},
/*02583*/     {0, -1, -1},
/*02584*/     {427, -1, -1},
/*02585*/     {0, -1, -1},
/*02586*/     {429, -1, -1},
/*02587*/     {0, -1, -1},
/*02588*/     {430, -1, -1},
/*02589*/     {0, -1, -1},
/*02590*/     {431, -1, -1},
/*02591*/     {0, -1, -1},
/*02592*/     {430, -1, -1},
/*02593*/     {0, -1, -1},
/*02594*/     {432, -1, -1},
/*02595*/     {0, -1, -1},
/*02596*/     {433, -1, -1},
/*02597*/     {0, -1, -1},
/*02598*/     {434, -1, -1},
/*02599*/     {0, -1, -1},
/*02600*/     {433, -1, -1},
/*02601*/     {0, -1, -1},
/*02602*/     {435, -1, -1},
/*02603*/     {0, -1, -1},
/*02604*/     {436, -1, -1},
/*02605*/     {0, -1, -1},
/*02606*/     {437, -1, -1},
/*02607*/     {0, -1, -1},
/*02608*/     {436, -1, -1},
/*02609*/     {0, -1, -1},
/*02610*/     {438, -1, -1},
/*02611*/     {0, -1, -1},
/*02612*/     {439, -1, -1},
/*02613*/     {0, -1, -1},
/*02614*/     {440, -1, -1},
/*02615*/     {0, -1, -1},
/*02616*/     {439, -1, -1},
/*02617*/     {0, -1, -1},
/*02618*/     {441, -1, -1},
/*02619*/     {0, -1, -1},
/*02620*/     {442, -1, -1},
/*02621*/     {0, -1, -1},
/*02622*/     {443, -1, -1},
/*02623*/     {0, -1, -1},
/*02624*/     {442, -1, -1},
/*02625*/     {0, -1, -1},
/*02626*/     {444, -1, -1},
/*02627*/     {0, -1, -1},
/*02628*/     {2644, 12, 1},
/*02629*/     {2646, 12, 1},
/*02630*/     {2648, 12, 1},
/*02631*/     {2650, 12, 1},
/*02632*/     {2652, 12, 1},
/*02633*/     {2654, 12, 1},
/*02634*/     {2656, 12, 1},
/*02635*/     {2658, 12, 1},
/*02636*/     {2660, 12, 1},
/*02637*/     {2662, 12, 1},
/*02638*/     {2664, 12, 1},
/*02639*/     {2666, 12, 1},
/*02640*/     {2668, 12, 1},
/*02641*/     {2670, 12, 1},
/*02642*/     {2672, 12, 1},
/*02643*/     {2674, 12, 1},
/*02644*/     {1374, -1, -1},
/*02645*/     {1390, -1, -1},
/*02646*/     {1382, -1, -1},
/*02647*/     {1398, -1, -1},
/*02648*/     {1375, -1, -1},
/*02649*/     {1391, -1, -1},
/*02650*/     {1383, -1, -1},
/*02651*/     {1399, -1, -1},
/*02652*/     {1376, -1, -1},
/*02653*/     {1392, -1, -1},
/*02654*/     {1384, -1, -1},
/*02655*/     {1400, -1, -1},
/*02656*/     {1377, -1, -1},
/*02657*/     {1393, -1, -1},
/*02658*/     {1385, -1, -1},
/*02659*/     {1401, -1, -1},
/*02660*/     {1378, -1, -1},
/*02661*/     {1394, -1, -1},
/*02662*/     {1386, -1, -1},
/*02663*/     {1402, -1, -1},
/*02664*/     {1379, -1, -1},
/*02665*/     {1395, -1, -1},
/*02666*/     {1387, -1, -1},
/*02667*/     {1403, -1, -1},
/*02668*/     {1380, -1, -1},
/*02669*/     {1396, -1, -1},
/*02670*/     {1388, -1, -1},
/*02671*/     {1404, -1, -1},
/*02672*/     {1381, -1, -1},
/*02673*/     {1397, -1, -1},
/*02674*/     {1389, -1, -1},
/*02675*/     {1405, -1, -1},
/*02676*/     {2684, 6, 3},
/*02677*/     {2704, 6, 3},
/*02678*/     {2724, 6, 3},
/*02679*/     {2744, 6, 3},
/*02680*/     {2764, 6, 3},
/*02681*/     {2784, 6, 3},
/*02682*/     {2804, 6, 3},
/*02683*/     {2824, 6, 3},
/*02684*/     {2692, 12, 1},
/*02685*/     {0, -1, -1},
/*02686*/     {2694, 12, 1},
/*02687*/     {2696, 12, 1},
/*02688*/     {0, -1, -1},
/*02689*/     {2698, 12, 1},
/*02690*/     {2700, 12, 1},
/*02691*/     {2702, 12, 1},
/*02692*/     {1120, -1, -1},
/*02693*/     {1121, -1, -1},
/*02694*/     {1136, -1, -1},
/*02695*/     {1137, -1, -1},
/*02696*/     {1152, -1, -1},
/*02697*/     {1153, -1, -1},
/*02698*/     {1168, -1, -1},
/*02699*/     {1169, -1, -1},
/*02700*/     {1184, -1, -1},
/*02701*/     {1185, -1, -1},
/*02702*/     {1200, -1, -1},
/*02703*/     {1201, -1, -1},
/*02704*/     {2712, 12, 1},
/*02705*/     {0, -1, -1},
/*02706*/     {2714, 12, 1},
/*02707*/     {2716, 12, 1},
/*02708*/     {0, -1, -1},
/*02709*/     {2718, 12, 1},
/*02710*/     {2720, 12, 1},
/*02711*/     {2722, 12, 1},
/*02712*/     {1122, -1, -1},
/*02713*/     {1123, -1, -1},
/*02714*/     {1138, -1, -1},
/*02715*/     {1139, -1, -1},
/*02716*/     {1154, -1, -1},
/*02717*/     {1155, -1, -1},
/*02718*/     {1170, -1, -1},
/*02719*/     {1171, -1, -1},
/*02720*/     {1186, -1, -1},
/*02721*/     {1187, -1, -1},
/*02722*/     {1202, -1, -1},
/*02723*/     {1203, -1, -1},
/*02724*/     {2732, 12, 1},
/*02725*/     {0, -1, -1},
/*02726*/     {2734, 12, 1},
/*02727*/     {2736, 12, 1},
/*02728*/     {0, -1, -1},
/*02729*/     {2738, 12, 1},
/*02730*/     {2740, 12, 1},
/*02731*/     {2742, 12, 1},
/*02732*/     {1124, -1, -1},
/*02733*/     {1125, -1, -1},
/*02734*/     {1140, -1, -1},
/*02735*/     {1141, -1, -1},
/*02736*/     {1156, -1, -1},
/*02737*/     {1157, -1, -1},
/*02738*/     {1172, -1, -1},
/*02739*/     {1173, -1, -1},
/*02740*/     {1188, -1, -1},
/*02741*/     {1189, -1, -1},
/*02742*/     {1204, -1, -1},
/*02743*/     {1205, -1, -1},
/*02744*/     {2752, 12, 1},
/*02745*/     {0, -1, -1},
/*02746*/     {2754, 12, 1},
/*02747*/     {2756, 12, 1},
/*02748*/     {0, -1, -1},
/*02749*/     {2758, 12, 1},
/*02750*/     {2760, 12, 1},
/*02751*/     {2762, 12, 1},
/*02752*/     {1126, -1, -1},
/*02753*/     {1127, -1, -1},
/*02754*/     {1142, -1, -1},
/*02755*/     {1143, -1, -1},
/*02756*/     {1158, -1, -1},
/*02757*/     {1159, -1, -1},
/*02758*/     {1174, -1, -1},
/*02759*/     {1175, -1, -1},
/*02760*/     {1190, -1, -1},
/*02761*/     {1191, -1, -1},
/*02762*/     {1206, -1, -1},
/*02763*/     {1207, -1, -1},
/*02764*/     {2772, 12, 1},
/*02765*/     {0, -1, -1},
/*02766*/     {2774, 12, 1},
/*02767*/     {2776, 12, 1},
/*02768*/     {0, -1, -1},
/*02769*/     {2778, 12, 1},
/*02770*/     {2780, 12, 1},
/*02771*/     {2782, 12, 1},
/*02772*/     {1128, -1, -1},
/*02773*/     {1129, -1, -1},
/*02774*/     {1144, -1, -1},
/*02775*/     {1145, -1, -1},
/*02776*/     {1160, -1, -1},
/*02777*/     {1161, -1, -1},
/*02778*/     {1176, -1, -1},
/*02779*/     {1177, -1, -1},
/*02780*/     {1192, -1, -1},
/*02781*/     {1193, -1, -1},
/*02782*/     {1208, -1, -1},
/*02783*/     {1209, -1, -1},
/*02784*/     {2792, 12, 1},
/*02785*/     {0, -1, -1},
/*02786*/     {2794, 12, 1},
/*02787*/     {2796, 12, 1},
/*02788*/     {0, -1, -1},
/*02789*/     {2798, 12, 1},
/*02790*/     {2800, 12, 1},
/*02791*/     {2802, 12, 1},
/*02792*/     {1130, -1, -1},
/*02793*/     {1131, -1, -1},
/*02794*/     {1146, -1, -1},
/*02795*/     {1147, -1, -1},
/*02796*/     {1162, -1, -1},
/*02797*/     {1163, -1, -1},
/*02798*/     {1178, -1, -1},
/*02799*/     {1179, -1, -1},
/*02800*/     {1194, -1, -1},
/*02801*/     {1195, -1, -1},
/*02802*/     {1210, -1, -1},
/*02803*/     {1211, -1, -1},
/*02804*/     {2812, 12, 1},
/*02805*/     {0, -1, -1},
/*02806*/     {2814, 12, 1},
/*02807*/     {2816, 12, 1},
/*02808*/     {0, -1, -1},
/*02809*/     {2818, 12, 1},
/*02810*/     {2820, 12, 1},
/*02811*/     {2822, 12, 1},
/*02812*/     {1132, -1, -1},
/*02813*/     {1133, -1, -1},
/*02814*/     {1148, -1, -1},
/*02815*/     {1149, -1, -1},
/*02816*/     {1164, -1, -1},
/*02817*/     {1165, -1, -1},
/*02818*/     {1180, -1, -1},
/*02819*/     {1181, -1, -1},
/*02820*/     {1196, -1, -1},
/*02821*/     {1197, -1, -1},
/*02822*/     {1212, -1, -1},
/*02823*/     {1213, -1, -1},
/*02824*/     {2832, 12, 1},
/*02825*/     {0, -1, -1},
/*02826*/     {2834, 12, 1},
/*02827*/     {2836, 12, 1},
/*02828*/     {0, -1, -1},
/*02829*/     {2838, 12, 1},
/*02830*/     {2840, 12, 1},
/*02831*/     {2842, 12, 1},
/*02832*/     {1134, -1, -1},
/*02833*/     {1135, -1, -1},
/*02834*/     {1150, -1, -1},
/*02835*/     {1151, -1, -1},
/*02836*/     {1166, -1, -1},
/*02837*/     {1167, -1, -1},
/*02838*/     {1182, -1, -1},
/*02839*/     {1183, -1, -1},
/*02840*/     {1198, -1, -1},
/*02841*/     {1199, -1, -1},
/*02842*/     {1214, -1, -1},
/*02843*/     {1215, -1, -1},
/*02844*/     {2852, 12, 2},
/*02845*/     {2864, 12, 2},
/*02846*/     {2876, 13, 1},
/*02847*/     {2878, 26, 1},
/*02848*/     {0, -1, -1},
/*02849*/     {0, -1, -1},
/*02850*/     {167, -1, -1},
/*02851*/     {172, -1, -1},
/*02852*/     {2856, 36, 1},
/*02853*/     {2858, 36, 1},
/*02854*/     {2860, 36, 1},
/*02855*/     {2862, 36, 1},
/*02856*/     {174, -1, -1},
/*02857*/     {176, -1, -1},
/*02858*/     {175, -1, -1},
/*02859*/     {177, -1, -1},
/*02860*/     {182, -1, -1},
/*02861*/     {184, -1, -1},
/*02862*/     {183, -1, -1},
/*02863*/     {185, -1, -1},
/*02864*/     {2868, 36, 1},
/*02865*/     {2870, 36, 1},
/*02866*/     {2872, 36, 1},
/*02867*/     {2874, 36, 1},
/*02868*/     {178, -1, -1},
/*02869*/     {180, -1, -1},
/*02870*/     {179, -1, -1},
/*02871*/     {181, -1, -1},
/*02872*/     {186, -1, -1},
/*02873*/     {188, -1, -1},
/*02874*/     {187, -1, -1},
/*02875*/     {189, -1, -1},
/*02876*/     {168, -1, -1},
/*02877*/     {169, -1, -1},
/*02878*/     {170, -1, -1},
/*02879*/     {171, -1, -1},
/*02880*/     {445, -1, -1},
/*02881*/     {446, -1, -1},
/*02882*/     {445, -1, -1},
/*02883*/     {447, -1, -1},
/*02884*/     {448, -1, -1},
/*02885*/     {449, -1, -1},
/*02886*/     {448, -1, -1},
/*02887*/     {450, -1, -1},
/*02888*/     {451, -1, -1},
/*02889*/     {452, -1, -1},
/*02890*/     {451, -1, -1},
/*02891*/     {453, -1, -1},
/*02892*/     {454, -1, -1},
/*02893*/     {455, -1, -1},
/*02894*/     {454, -1, -1},
/*02895*/     {456, -1, -1},
/*02896*/     {457, -1, -1},
/*02897*/     {458, -1, -1},
/*02898*/     {457, -1, -1},
/*02899*/     {459, -1, -1},
/*02900*/     {460, -1, -1},
/*02901*/     {461, -1, -1},
/*02902*/     {460, -1, -1},
/*02903*/     {462, -1, -1},
/*02904*/     {463, -1, -1},
/*02905*/     {464, -1, -1},
/*02906*/     {463, -1, -1},
/*02907*/     {465, -1, -1},
/*02908*/     {466, -1, -1},
/*02909*/     {467, -1, -1},
/*02910*/     {466, -1, -1},
/*02911*/     {468, -1, -1},
/*02912*/     {469, -1, -1},
/*02913*/     {470, -1, -1},
/*02914*/     {469, -1, -1},
/*02915*/     {471, -1, -1},
/*02916*/     {472, -1, -1},
/*02917*/     {473, -1, -1},
/*02918*/     {472, -1, -1},
/*02919*/     {474, -1, -1},
/*02920*/     {475, -1, -1},
/*02921*/     {476, -1, -1},
/*02922*/     {475, -1, -1},
/*02923*/     {477, -1, -1},
/*02924*/     {478, -1, -1},
/*02925*/     {479, -1, -1},
/*02926*/     {478, -1, -1},
/*02927*/     {480, -1, -1},
/*02928*/     {481, -1, -1},
/*02929*/     {482, -1, -1},
/*02930*/     {481, -1, -1},
/*02931*/     {483, -1, -1},
/*02932*/     {484, -1, -1},
/*02933*/     {485, -1, -1},
/*02934*/     {484, -1, -1},
/*02935*/     {486, -1, -1},
/*02936*/     {487, -1, -1},
/*02937*/     {488, -1, -1},
/*02938*/     {487, -1, -1},
/*02939*/     {489, -1, -1},
/*02940*/     {490, -1, -1},
/*02941*/     {491, -1, -1},
/*02942*/     {490, -1, -1},
/*02943*/     {492, -1, -1},
/*02944*/     {493, -1, -1},
/*02945*/     {494, -1, -1},
/*02946*/     {493, -1, -1},
/*02947*/     {495, -1, -1},
/*02948*/     {496, -1, -1},
/*02949*/     {497, -1, -1},
/*02950*/     {496, -1, -1},
/*02951*/     {498, -1, -1},
/*02952*/     {499, -1, -1},
/*02953*/     {500, -1, -1},
/*02954*/     {499, -1, -1},
/*02955*/     {501, -1, -1},
/*02956*/     {502, -1, -1},
/*02957*/     {503, -1, -1},
/*02958*/     {502, -1, -1},
/*02959*/     {504, -1, -1},
/*02960*/     {505, -1, -1},
/*02961*/     {506, -1, -1},
/*02962*/     {505, -1, -1},
/*02963*/     {507, -1, -1},
/*02964*/     {508, -1, -1},
/*02965*/     {509, -1, -1},
/*02966*/     {508, -1, -1},
/*02967*/     {510, -1, -1},
/*02968*/     {511, -1, -1},
/*02969*/     {512, -1, -1},
/*02970*/     {511, -1, -1},
/*02971*/     {513, -1, -1},
/*02972*/     {514, -1, -1},
/*02973*/     {515, -1, -1},
/*02974*/     {514, -1, -1},
/*02975*/     {516, -1, -1},
/*02976*/     {0, -1, -1},
/*02977*/     {0, -1, -1},
/*02978*/     {0, -1, -1},
/*02979*/     {0, -1, -1},
/*02980*/     {0, -1, -1},
/*02981*/     {0, -1, -1},
/*02982*/     {0, -1, -1},
/*02983*/     {0, -1, -1},
/*02984*/     {0, -1, -1},
/*02985*/     {0, -1, -1},
/*02986*/     {0, -1, -1},
/*02987*/     {0, -1, -1},
/*02988*/     {517, -1, -1},
/*02989*/     {518, -1, -1},
/*02990*/     {517, -1, -1},
/*02991*/     {519, -1, -1},
/*02992*/     {0, -1, -1},
/*02993*/     {0, -1, -1},
/*02994*/     {0, -1, -1},
/*02995*/     {0, -1, -1},
/*02996*/     {0, -1, -1},
/*02997*/     {0, -1, -1},
/*02998*/     {0, -1, -1},
/*02999*/     {0, -1, -1},
/*03000*/     {0, -1, -1},
/*03001*/     {0, -1, -1},
/*03002*/     {0, -1, -1},
/*03003*/     {0, -1, -1},
/*03004*/     {0, -1, -1},
/*03005*/     {0, -1, -1},
/*03006*/     {0, -1, -1},
/*03007*/     {0, -1, -1},
/*03008*/     {520, -1, -1},
/*03009*/     {521, -1, -1},
/*03010*/     {520, -1, -1},
/*03011*/     {522, -1, -1},
/*03012*/     {523, -1, -1},
/*03013*/     {524, -1, -1},
/*03014*/     {523, -1, -1},
/*03015*/     {525, -1, -1},
/*03016*/     {526, -1, -1},
/*03017*/     {527, -1, -1},
/*03018*/     {526, -1, -1},
/*03019*/     {528, -1, -1},
/*03020*/     {529, -1, -1},
/*03021*/     {530, -1, -1},
/*03022*/     {529, -1, -1},
/*03023*/     {531, -1, -1},
/*03024*/     {532, -1, -1},
/*03025*/     {533, -1, -1},
/*03026*/     {532, -1, -1},
/*03027*/     {534, -1, -1},
/*03028*/     {535, -1, -1},
/*03029*/     {536, -1, -1},
/*03030*/     {535, -1, -1},
/*03031*/     {537, -1, -1},
/*03032*/     {538, -1, -1},
/*03033*/     {539, -1, -1},
/*03034*/     {538, -1, -1},
/*03035*/     {540, -1, -1},
/*03036*/     {541, -1, -1},
/*03037*/     {542, -1, -1},
/*03038*/     {541, -1, -1},
/*03039*/     {543, -1, -1},
/*03040*/     {544, -1, -1},
/*03041*/     {545, -1, -1},
/*03042*/     {544, -1, -1},
/*03043*/     {546, -1, -1},
/*03044*/     {547, -1, -1},
/*03045*/     {548, -1, -1},
/*03046*/     {547, -1, -1},
/*03047*/     {549, -1, -1},
/*03048*/     {550, -1, -1},
/*03049*/     {551, -1, -1},
/*03050*/     {550, -1, -1},
/*03051*/     {552, -1, -1},
/*03052*/     {553, -1, -1},
/*03053*/     {554, -1, -1},
/*03054*/     {553, -1, -1},
/*03055*/     {555, -1, -1},
/*03056*/     {0, -1, -1},
/*03057*/     {0, -1, -1},
/*03058*/     {0, -1, -1},
/*03059*/     {0, -1, -1},
/*03060*/     {0, -1, -1},
/*03061*/     {0, -1, -1},
/*03062*/     {0, -1, -1},
/*03063*/     {0, -1, -1},
/*03064*/     {0, -1, -1},
/*03065*/     {0, -1, -1},
/*03066*/     {0, -1, -1},
/*03067*/     {0, -1, -1},
/*03068*/     {0, -1, -1},
/*03069*/     {0, -1, -1},
/*03070*/     {0, -1, -1},
/*03071*/     {0, -1, -1},
/*03072*/     {574, -1, -1},
/*03073*/     {574, -1, -1},
/*03074*/     {574, -1, -1},
/*03075*/     {575, -1, -1},
/*03076*/     {576, -1, -1},
/*03077*/     {576, -1, -1},
/*03078*/     {576, -1, -1},
/*03079*/     {577, -1, -1},
/*03080*/     {578, -1, -1},
/*03081*/     {578, -1, -1},
/*03082*/     {578, -1, -1},
/*03083*/     {579, -1, -1},
/*03084*/     {580, -1, -1},
/*03085*/     {580, -1, -1},
/*03086*/     {580, -1, -1},
/*03087*/     {581, -1, -1},
/*03088*/     {582, -1, -1},
/*03089*/     {582, -1, -1},
/*03090*/     {582, -1, -1},
/*03091*/     {583, -1, -1},
/*03092*/     {584, -1, -1},
/*03093*/     {584, -1, -1},
/*03094*/     {584, -1, -1},
/*03095*/     {585, -1, -1},
/*03096*/     {586, -1, -1},
/*03097*/     {586, -1, -1},
/*03098*/     {586, -1, -1},
/*03099*/     {587, -1, -1},
/*03100*/     {588, -1, -1},
/*03101*/     {588, -1, -1},
/*03102*/     {588, -1, -1},
/*03103*/     {589, -1, -1},
/*03104*/     {0, -1, -1},
/*03105*/     {0, -1, -1},
/*03106*/     {0, -1, -1},
/*03107*/     {0, -1, -1},
/*03108*/     {0, -1, -1},
/*03109*/     {0, -1, -1},
/*03110*/     {0, -1, -1},
/*03111*/     {0, -1, -1},
/*03112*/     {0, -1, -1},
/*03113*/     {0, -1, -1},
/*03114*/     {0, -1, -1},
/*03115*/     {0, -1, -1},
/*03116*/     {590, -1, -1},
/*03117*/     {590, -1, -1},
/*03118*/     {590, -1, -1},
/*03119*/     {591, -1, -1},
/*03120*/     {0, -1, -1},
/*03121*/     {0, -1, -1},
/*03122*/     {0, -1, -1},
/*03123*/     {0, -1, -1},
/*03124*/     {0, -1, -1},
/*03125*/     {0, -1, -1},
/*03126*/     {0, -1, -1},
/*03127*/     {0, -1, -1},
/*03128*/     {0, -1, -1},
/*03129*/     {0, -1, -1},
/*03130*/     {0, -1, -1},
/*03131*/     {0, -1, -1},
/*03132*/     {0, -1, -1},
/*03133*/     {0, -1, -1},
/*03134*/     {0, -1, -1},
/*03135*/     {0, -1, -1},
/*03136*/     {1406, -1, -1},
/*03137*/     {1407, -1, -1},
/*03138*/     {3146, 12, 1},
/*03139*/     {3148, 12, 1},
/*03140*/     {3150, 12, 1},
/*03141*/     {3152, 12, 1},
/*03142*/     {3154, 12, 1},
/*03143*/     {3156, 12, 1},
/*03144*/     {3158, 12, 1},
/*03145*/     {3160, 12, 1},
/*03146*/     {1216, -1, -1},
/*03147*/     {1217, -1, -1},
/*03148*/     {1218, -1, -1},
/*03149*/     {1219, -1, -1},
/*03150*/     {1220, -1, -1},
/*03151*/     {1221, -1, -1},
/*03152*/     {1222, -1, -1},
/*03153*/     {1223, -1, -1},
/*03154*/     {1224, -1, -1},
/*03155*/     {1225, -1, -1},
/*03156*/     {1226, -1, -1},
/*03157*/     {1227, -1, -1},
/*03158*/     {1228, -1, -1},
/*03159*/     {1229, -1, -1},
/*03160*/     {1230, -1, -1},
/*03161*/     {1231, -1, -1},
/*03162*/     {3290, 27, 3},
/*03163*/     {3298, 27, 3},
/*03164*/     {3306, 27, 3},
/*03165*/     {3314, 27, 3},
/*03166*/     {3322, 27, 3},
/*03167*/     {3330, 27, 3},
/*03168*/     {3338, 27, 3},
/*03169*/     {3346, 27, 3},
/*03170*/     {3354, 27, 3},
/*03171*/     {3362, 27, 3},
/*03172*/     {3370, 27, 3},
/*03173*/     {3378, 27, 3},
/*03174*/     {3386, 27, 3},
/*03175*/     {3394, 27, 3},
/*03176*/     {3402, 27, 3},
/*03177*/     {3410, 27, 3},
/*03178*/     {0, -1, -1},
/*03179*/     {0, -1, -1},
/*03180*/     {0, -1, -1},
/*03181*/     {0, -1, -1},
/*03182*/     {0, -1, -1},
/*03183*/     {0, -1, -1},
/*03184*/     {0, -1, -1},
/*03185*/     {0, -1, -1},
/*03186*/     {0, -1, -1},
/*03187*/     {0, -1, -1},
/*03188*/     {0, -1, -1},
/*03189*/     {3418, 27, 3},
/*03190*/     {3426, 27, 1},
/*03191*/     {3428, 27, 1},
/*03192*/     {3430, 27, 1},
/*03193*/     {3432, 27, 1},
/*03194*/     {3434, 27, 3},
/*03195*/     {3442, 27, 3},
/*03196*/     {3450, 27, 3},
/*03197*/     {3458, 27, 3},
/*03198*/     {3466, 27, 3},
/*03199*/     {3474, 27, 3},
/*03200*/     {3482, 27, 3},
/*03201*/     {3490, 27, 3},
/*03202*/     {0, -1, -1},
/*03203*/     {0, -1, -1},
/*03204*/     {0, -1, -1},
/*03205*/     {0, -1, -1},
/*03206*/     {3498, 27, 3},
/*03207*/     {3506, 27, 3},
/*03208*/     {3514, 27, 3},
/*03209*/     {3522, 27, 3},
/*03210*/     {3530, 27, 3},
/*03211*/     {3538, 27, 3},
/*03212*/     {3546, 27, 3},
/*03213*/     {3554, 27, 3},
/*03214*/     {0, -1, -1},
/*03215*/     {0, -1, -1},
/*03216*/     {0, -1, -1},
/*03217*/     {0, -1, -1},
/*03218*/     {0, -1, -1},
/*03219*/     {0, -1, -1},
/*03220*/     {0, -1, -1},
/*03221*/     {3562, 27, 3},
/*03222*/     {0, -1, -1},
/*03223*/     {0, -1, -1},
/*03224*/     {0, -1, -1},
/*03225*/     {0, -1, -1},
/*03226*/     {3570, 27, 3},
/*03227*/     {3578, 27, 3},
/*03228*/     {3586, 27, 3},
/*03229*/     {3594, 27, 3},
/*03230*/     {3602, 27, 3},
/*03231*/     {3610, 27, 3},
/*03232*/     {3618, 27, 3},
/*03233*/     {3626, 27, 3},
/*03234*/     {3634, 27, 3},
/*03235*/     {3642, 27, 3},
/*03236*/     {3650, 27, 3},
/*03237*/     {3658, 27, 3},
/*03238*/     {3666, 27, 3},
/*03239*/     {3674, 27, 3},
/*03240*/     {3682, 27, 3},
/*03241*/     {3690, 27, 3},
/*03242*/     {0, -1, -1},
/*03243*/     {0, -1, -1},
/*03244*/     {0, -1, -1},
/*03245*/     {0, -1, -1},
/*03246*/     {0, -1, -1},
/*03247*/     {0, -1, -1},
/*03248*/     {0, -1, -1},
/*03249*/     {0, -1, -1},
/*03250*/     {0, -1, -1},
/*03251*/     {0, -1, -1},
/*03252*/     {0, -1, -1},
/*03253*/     {3698, 27, 3},
/*03254*/     {0, -1, -1},
/*03255*/     {0, -1, -1},
/*03256*/     {0, -1, -1},
/*03257*/     {0, -1, -1},
/*03258*/     {3706, 27, 3},
/*03259*/     {3714, 27, 3},
/*03260*/     {3722, 27, 3},
/*03261*/     {3730, 27, 3},
/*03262*/     {3738, 27, 3},
/*03263*/     {3746, 27, 3},
/*03264*/     {3754, 27, 3},
/*03265*/     {3762, 27, 3},
/*03266*/     {0, -1, -1},
/*03267*/     {0, -1, -1},
/*03268*/     {0, -1, -1},
/*03269*/     {0, -1, -1},
/*03270*/     {3770, 27, 3},
/*03271*/     {3778, 27, 3},
/*03272*/     {3786, 27, 3},
/*03273*/     {3794, 27, 3},
/*03274*/     {0, -1, -1},
/*03275*/     {0, -1, -1},
/*03276*/     {0, -1, -1},
/*03277*/     {0, -1, -1},
/*03278*/     {0, -1, -1},
/*03279*/     {0, -1, -1},
/*03280*/     {0, -1, -1},
/*03281*/     {0, -1, -1},
/*03282*/     {0, -1, -1},
/*03283*/     {0, -1, -1},
/*03284*/     {0, -1, -1},
/*03285*/     {0, -1, -1},
/*03286*/     {0, -1, -1},
/*03287*/     {0, -1, -1},
/*03288*/     {0, -1, -1},
/*03289*/     {0, -1, -1},
/*03290*/     {601, -1, -1},
/*03291*/     {0, -1, -1},
/*03292*/     {602, -1, -1},
/*03293*/     {0, -1, -1},
/*03294*/     {601, -1, -1},
/*03295*/     {0, -1, -1},
/*03296*/     {603, -1, -1},
/*03297*/     {0, -1, -1},
/*03298*/     {598, -1, -1},
/*03299*/     {843, -1, -1},
/*03300*/     {599, -1, -1},
/*03301*/     {844, -1, -1},
/*03302*/     {598, -1, -1},
/*03303*/     {843, -1, -1},
/*03304*/     {600, -1, -1},
/*03305*/     {845, -1, -1},
/*03306*/     {592, -1, -1},
/*03307*/     {837, -1, -1},
/*03308*/     {593, -1, -1},
/*03309*/     {838, -1, -1},
/*03310*/     {592, -1, -1},
/*03311*/     {837, -1, -1},
/*03312*/     {594, -1, -1},
/*03313*/     {839, -1, -1},
/*03314*/     {595, -1, -1},
/*03315*/     {840, -1, -1},
/*03316*/     {596, -1, -1},
/*03317*/     {841, -1, -1},
/*03318*/     {595, -1, -1},
/*03319*/     {840, -1, -1},
/*03320*/     {597, -1, -1},
/*03321*/     {842, -1, -1},
/*03322*/     {613, -1, -1},
/*03323*/     {0, -1, -1},
/*03324*/     {614, -1, -1},
/*03325*/     {0, -1, -1},
/*03326*/     {613, -1, -1},
/*03327*/     {0, -1, -1},
/*03328*/     {615, -1, -1},
/*03329*/     {0, -1, -1},
/*03330*/     {610, -1, -1},
/*03331*/     {852, -1, -1},
/*03332*/     {611, -1, -1},
/*03333*/     {853, -1, -1},
/*03334*/     {610, -1, -1},
/*03335*/     {852, -1, -1},
/*03336*/     {612, -1, -1},
/*03337*/     {854, -1, -1},
/*03338*/     {604, -1, -1},
/*03339*/     {846, -1, -1},
/*03340*/     {605, -1, -1},
/*03341*/     {847, -1, -1},
/*03342*/     {604, -1, -1},
/*03343*/     {846, -1, -1},
/*03344*/     {606, -1, -1},
/*03345*/     {848, -1, -1},
/*03346*/     {607, -1, -1},
/*03347*/     {849, -1, -1},
/*03348*/     {608, -1, -1},
/*03349*/     {850, -1, -1},
/*03350*/     {607, -1, -1},
/*03351*/     {849, -1, -1},
/*03352*/     {609, -1, -1},
/*03353*/     {851, -1, -1},
/*03354*/     {625, -1, -1},
/*03355*/     {0, -1, -1},
/*03356*/     {626, -1, -1},
/*03357*/     {0, -1, -1},
/*03358*/     {625, -1, -1},
/*03359*/     {0, -1, -1},
/*03360*/     {627, -1, -1},
/*03361*/     {0, -1, -1},
/*03362*/     {622, -1, -1},
/*03363*/     {861, -1, -1},
/*03364*/     {623, -1, -1},
/*03365*/     {862, -1, -1},
/*03366*/     {622, -1, -1},
/*03367*/     {861, -1, -1},
/*03368*/     {624, -1, -1},
/*03369*/     {863, -1, -1},
/*03370*/     {616, -1, -1},
/*03371*/     {855, -1, -1},
/*03372*/     {617, -1, -1},
/*03373*/     {856, -1, -1},
/*03374*/     {616, -1, -1},
/*03375*/     {855, -1, -1},
/*03376*/     {618, -1, -1},
/*03377*/     {857, -1, -1},
/*03378*/     {619, -1, -1},
/*03379*/     {858, -1, -1},
/*03380*/     {620, -1, -1},
/*03381*/     {859, -1, -1},
/*03382*/     {619, -1, -1},
/*03383*/     {858, -1, -1},
/*03384*/     {621, -1, -1},
/*03385*/     {860, -1, -1},
/*03386*/     {637, -1, -1},
/*03387*/     {0, -1, -1},
/*03388*/     {638, -1, -1},
/*03389*/     {0, -1, -1},
/*03390*/     {637, -1, -1},
/*03391*/     {0, -1, -1},
/*03392*/     {639, -1, -1},
/*03393*/     {0, -1, -1},
/*03394*/     {634, -1, -1},
/*03395*/     {870, -1, -1},
/*03396*/     {635, -1, -1},
/*03397*/     {871, -1, -1},
/*03398*/     {634, -1, -1},
/*03399*/     {870, -1, -1},
/*03400*/     {636, -1, -1},
/*03401*/     {872, -1, -1},
/*03402*/     {628, -1, -1},
/*03403*/     {864, -1, -1},
/*03404*/     {629, -1, -1},
/*03405*/     {865, -1, -1},
/*03406*/     {628, -1, -1},
/*03407*/     {864, -1, -1},
/*03408*/     {630, -1, -1},
/*03409*/     {866, -1, -1},
/*03410*/     {631, -1, -1},
/*03411*/     {867, -1, -1},
/*03412*/     {632, -1, -1},
/*03413*/     {868, -1, -1},
/*03414*/     {631, -1, -1},
/*03415*/     {867, -1, -1},
/*03416*/     {633, -1, -1},
/*03417*/     {869, -1, -1},
/*03418*/     {640, -1, -1},
/*03419*/     {0, -1, -1},
/*03420*/     {641, -1, -1},
/*03421*/     {0, -1, -1},
/*03422*/     {640, -1, -1},
/*03423*/     {0, -1, -1},
/*03424*/     {642, -1, -1},
/*03425*/     {0, -1, -1},
/*03426*/     {0, -1, -1},
/*03427*/     {1041, -1, -1},
/*03428*/     {0, -1, -1},
/*03429*/     {1042, -1, -1},
/*03430*/     {0, -1, -1},
/*03431*/     {1043, -1, -1},
/*03432*/     {0, -1, -1},
/*03433*/     {1044, -1, -1},
/*03434*/     {652, -1, -1},
/*03435*/     {0, -1, -1},
/*03436*/     {653, -1, -1},
/*03437*/     {0, -1, -1},
/*03438*/     {652, -1, -1},
/*03439*/     {0, -1, -1},
/*03440*/     {654, -1, -1},
/*03441*/     {0, -1, -1},
/*03442*/     {649, -1, -1},
/*03443*/     {879, -1, -1},
/*03444*/     {650, -1, -1},
/*03445*/     {880, -1, -1},
/*03446*/     {649, -1, -1},
/*03447*/     {879, -1, -1},
/*03448*/     {651, -1, -1},
/*03449*/     {881, -1, -1},
/*03450*/     {643, -1, -1},
/*03451*/     {873, -1, -1},
/*03452*/     {644, -1, -1},
/*03453*/     {874, -1, -1},
/*03454*/     {643, -1, -1},
/*03455*/     {873, -1, -1},
/*03456*/     {645, -1, -1},
/*03457*/     {875, -1, -1},
/*03458*/     {646, -1, -1},
/*03459*/     {876, -1, -1},
/*03460*/     {647, -1, -1},
/*03461*/     {877, -1, -1},
/*03462*/     {646, -1, -1},
/*03463*/     {876, -1, -1},
/*03464*/     {648, -1, -1},
/*03465*/     {878, -1, -1},
/*03466*/     {664, -1, -1},
/*03467*/     {0, -1, -1},
/*03468*/     {665, -1, -1},
/*03469*/     {0, -1, -1},
/*03470*/     {664, -1, -1},
/*03471*/     {0, -1, -1},
/*03472*/     {666, -1, -1},
/*03473*/     {0, -1, -1},
/*03474*/     {661, -1, -1},
/*03475*/     {888, -1, -1},
/*03476*/     {662, -1, -1},
/*03477*/     {889, -1, -1},
/*03478*/     {661, -1, -1},
/*03479*/     {888, -1, -1},
/*03480*/     {663, -1, -1},
/*03481*/     {890, -1, -1},
/*03482*/     {655, -1, -1},
/*03483*/     {882, -1, -1},
/*03484*/     {656, -1, -1},
/*03485*/     {883, -1, -1},
/*03486*/     {655, -1, -1},
/*03487*/     {882, -1, -1},
/*03488*/     {657, -1, -1},
/*03489*/     {884, -1, -1},
/*03490*/     {658, -1, -1},
/*03491*/     {885, -1, -1},
/*03492*/     {659, -1, -1},
/*03493*/     {886, -1, -1},
/*03494*/     {658, -1, -1},
/*03495*/     {885, -1, -1},
/*03496*/     {660, -1, -1},
/*03497*/     {887, -1, -1},
/*03498*/     {945, -1, -1},
/*03499*/     {0, -1, -1},
/*03500*/     {946, -1, -1},
/*03501*/     {0, -1, -1},
/*03502*/     {947, -1, -1},
/*03503*/     {0, -1, -1},
/*03504*/     {948, -1, -1},
/*03505*/     {0, -1, -1},
/*03506*/     {949, -1, -1},
/*03507*/     {0, -1, -1},
/*03508*/     {950, -1, -1},
/*03509*/     {0, -1, -1},
/*03510*/     {951, -1, -1},
/*03511*/     {0, -1, -1},
/*03512*/     {952, -1, -1},
/*03513*/     {0, -1, -1},
/*03514*/     {953, -1, -1},
/*03515*/     {0, -1, -1},
/*03516*/     {954, -1, -1},
/*03517*/     {0, -1, -1},
/*03518*/     {955, -1, -1},
/*03519*/     {0, -1, -1},
/*03520*/     {956, -1, -1},
/*03521*/     {0, -1, -1},
/*03522*/     {957, -1, -1},
/*03523*/     {0, -1, -1},
/*03524*/     {958, -1, -1},
/*03525*/     {0, -1, -1},
/*03526*/     {959, -1, -1},
/*03527*/     {0, -1, -1},
/*03528*/     {960, -1, -1},
/*03529*/     {0, -1, -1},
/*03530*/     {823, -1, -1},
/*03531*/     {0, -1, -1},
/*03532*/     {823, -1, -1},
/*03533*/     {0, -1, -1},
/*03534*/     {823, -1, -1},
/*03535*/     {0, -1, -1},
/*03536*/     {824, -1, -1},
/*03537*/     {0, -1, -1},
/*03538*/     {821, -1, -1},
/*03539*/     {0, -1, -1},
/*03540*/     {821, -1, -1},
/*03541*/     {0, -1, -1},
/*03542*/     {821, -1, -1},
/*03543*/     {0, -1, -1},
/*03544*/     {822, -1, -1},
/*03545*/     {0, -1, -1},
/*03546*/     {817, -1, -1},
/*03547*/     {0, -1, -1},
/*03548*/     {817, -1, -1},
/*03549*/     {0, -1, -1},
/*03550*/     {817, -1, -1},
/*03551*/     {0, -1, -1},
/*03552*/     {818, -1, -1},
/*03553*/     {0, -1, -1},
/*03554*/     {819, -1, -1},
/*03555*/     {0, -1, -1},
/*03556*/     {819, -1, -1},
/*03557*/     {0, -1, -1},
/*03558*/     {819, -1, -1},
/*03559*/     {0, -1, -1},
/*03560*/     {820, -1, -1},
/*03561*/     {0, -1, -1},
/*03562*/     {825, -1, -1},
/*03563*/     {0, -1, -1},
/*03564*/     {825, -1, -1},
/*03565*/     {0, -1, -1},
/*03566*/     {825, -1, -1},
/*03567*/     {0, -1, -1},
/*03568*/     {826, -1, -1},
/*03569*/     {0, -1, -1},
/*03570*/     {676, -1, -1},
/*03571*/     {0, -1, -1},
/*03572*/     {677, -1, -1},
/*03573*/     {0, -1, -1},
/*03574*/     {676, -1, -1},
/*03575*/     {0, -1, -1},
/*03576*/     {678, -1, -1},
/*03577*/     {0, -1, -1},
/*03578*/     {673, -1, -1},
/*03579*/     {897, -1, -1},
/*03580*/     {674, -1, -1},
/*03581*/     {898, -1, -1},
/*03582*/     {673, -1, -1},
/*03583*/     {897, -1, -1},
/*03584*/     {675, -1, -1},
/*03585*/     {899, -1, -1},
/*03586*/     {667, -1, -1},
/*03587*/     {891, -1, -1},
/*03588*/     {668, -1, -1},
/*03589*/     {892, -1, -1},
/*03590*/     {667, -1, -1},
/*03591*/     {891, -1, -1},
/*03592*/     {669, -1, -1},
/*03593*/     {893, -1, -1},
/*03594*/     {670, -1, -1},
/*03595*/     {894, -1, -1},
/*03596*/     {671, -1, -1},
/*03597*/     {895, -1, -1},
/*03598*/     {670, -1, -1},
/*03599*/     {894, -1, -1},
/*03600*/     {672, -1, -1},
/*03601*/     {896, -1, -1},
/*03602*/     {688, -1, -1},
/*03603*/     {0, -1, -1},
/*03604*/     {689, -1, -1},
/*03605*/     {0, -1, -1},
/*03606*/     {688, -1, -1},
/*03607*/     {0, -1, -1},
/*03608*/     {690, -1, -1},
/*03609*/     {0, -1, -1},
/*03610*/     {685, -1, -1},
/*03611*/     {906, -1, -1},
/*03612*/     {686, -1, -1},
/*03613*/     {907, -1, -1},
/*03614*/     {685, -1, -1},
/*03615*/     {906, -1, -1},
/*03616*/     {687, -1, -1},
/*03617*/     {908, -1, -1},
/*03618*/     {679, -1, -1},
/*03619*/     {900, -1, -1},
/*03620*/     {680, -1, -1},
/*03621*/     {901, -1, -1},
/*03622*/     {679, -1, -1},
/*03623*/     {900, -1, -1},
/*03624*/     {681, -1, -1},
/*03625*/     {902, -1, -1},
/*03626*/     {682, -1, -1},
/*03627*/     {903, -1, -1},
/*03628*/     {683, -1, -1},
/*03629*/     {904, -1, -1},
/*03630*/     {682, -1, -1},
/*03631*/     {903, -1, -1},
/*03632*/     {684, -1, -1},
/*03633*/     {905, -1, -1},
/*03634*/     {700, -1, -1},
/*03635*/     {0, -1, -1},
/*03636*/     {701, -1, -1},
/*03637*/     {0, -1, -1},
/*03638*/     {700, -1, -1},
/*03639*/     {0, -1, -1},
/*03640*/     {702, -1, -1},
/*03641*/     {0, -1, -1},
/*03642*/     {697, -1, -1},
/*03643*/     {915, -1, -1},
/*03644*/     {698, -1, -1},
/*03645*/     {916, -1, -1},
/*03646*/     {697, -1, -1},
/*03647*/     {915, -1, -1},
/*03648*/     {699, -1, -1},
/*03649*/     {917, -1, -1},
/*03650*/     {691, -1, -1},
/*03651*/     {909, -1, -1},
/*03652*/     {692, -1, -1},
/*03653*/     {910, -1, -1},
/*03654*/     {691, -1, -1},
/*03655*/     {909, -1, -1},
/*03656*/     {693, -1, -1},
/*03657*/     {911, -1, -1},
/*03658*/     {694, -1, -1},
/*03659*/     {912, -1, -1},
/*03660*/     {695, -1, -1},
/*03661*/     {913, -1, -1},
/*03662*/     {694, -1, -1},
/*03663*/     {912, -1, -1},
/*03664*/     {696, -1, -1},
/*03665*/     {914, -1, -1},
/*03666*/     {712, -1, -1},
/*03667*/     {0, -1, -1},
/*03668*/     {713, -1, -1},
/*03669*/     {0, -1, -1},
/*03670*/     {712, -1, -1},
/*03671*/     {0, -1, -1},
/*03672*/     {714, -1, -1},
/*03673*/     {0, -1, -1},
/*03674*/     {709, -1, -1},
/*03675*/     {924, -1, -1},
/*03676*/     {710, -1, -1},
/*03677*/     {925, -1, -1},
/*03678*/     {709, -1, -1},
/*03679*/     {924, -1, -1},
/*03680*/     {711, -1, -1},
/*03681*/     {926, -1, -1},
/*03682*/     {703, -1, -1},
/*03683*/     {918, -1, -1},
/*03684*/     {704, -1, -1},
/*03685*/     {919, -1, -1},
/*03686*/     {703, -1, -1},
/*03687*/     {918, -1, -1},
/*03688*/     {705, -1, -1},
/*03689*/     {920, -1, -1},
/*03690*/     {706, -1, -1},
/*03691*/     {921, -1, -1},
/*03692*/     {707, -1, -1},
/*03693*/     {922, -1, -1},
/*03694*/     {706, -1, -1},
/*03695*/     {921, -1, -1},
/*03696*/     {708, -1, -1},
/*03697*/     {923, -1, -1},
/*03698*/     {715, -1, -1},
/*03699*/     {0, -1, -1},
/*03700*/     {716, -1, -1},
/*03701*/     {0, -1, -1},
/*03702*/     {715, -1, -1},
/*03703*/     {0, -1, -1},
/*03704*/     {717, -1, -1},
/*03705*/     {0, -1, -1},
/*03706*/     {727, -1, -1},
/*03707*/     {0, -1, -1},
/*03708*/     {728, -1, -1},
/*03709*/     {0, -1, -1},
/*03710*/     {727, -1, -1},
/*03711*/     {0, -1, -1},
/*03712*/     {729, -1, -1},
/*03713*/     {0, -1, -1},
/*03714*/     {724, -1, -1},
/*03715*/     {933, -1, -1},
/*03716*/     {725, -1, -1},
/*03717*/     {934, -1, -1},
/*03718*/     {724, -1, -1},
/*03719*/     {933, -1, -1},
/*03720*/     {726, -1, -1},
/*03721*/     {935, -1, -1},
/*03722*/     {718, -1, -1},
/*03723*/     {927, -1, -1},
/*03724*/     {719, -1, -1},
/*03725*/     {928, -1, -1},
/*03726*/     {718, -1, -1},
/*03727*/     {927, -1, -1},
/*03728*/     {720, -1, -1},
/*03729*/     {929, -1, -1},
/*03730*/     {721, -1, -1},
/*03731*/     {930, -1, -1},
/*03732*/     {722, -1, -1},
/*03733*/     {931, -1, -1},
/*03734*/     {721, -1, -1},
/*03735*/     {930, -1, -1},
/*03736*/     {723, -1, -1},
/*03737*/     {932, -1, -1},
/*03738*/     {739, -1, -1},
/*03739*/     {0, -1, -1},
/*03740*/     {740, -1, -1},
/*03741*/     {0, -1, -1},
/*03742*/     {739, -1, -1},
/*03743*/     {0, -1, -1},
/*03744*/     {741, -1, -1},
/*03745*/     {0, -1, -1},
/*03746*/     {736, -1, -1},
/*03747*/     {942, -1, -1},
/*03748*/     {737, -1, -1},
/*03749*/     {943, -1, -1},
/*03750*/     {736, -1, -1},
/*03751*/     {942, -1, -1},
/*03752*/     {738, -1, -1},
/*03753*/     {944, -1, -1},
/*03754*/     {730, -1, -1},
/*03755*/     {936, -1, -1},
/*03756*/     {731, -1, -1},
/*03757*/     {937, -1, -1},
/*03758*/     {730, -1, -1},
/*03759*/     {936, -1, -1},
/*03760*/     {732, -1, -1},
/*03761*/     {938, -1, -1},
/*03762*/     {733, -1, -1},
/*03763*/     {939, -1, -1},
/*03764*/     {734, -1, -1},
/*03765*/     {940, -1, -1},
/*03766*/     {733, -1, -1},
/*03767*/     {939, -1, -1},
/*03768*/     {735, -1, -1},
/*03769*/     {941, -1, -1},
/*03770*/     {961, -1, -1},
/*03771*/     {0, -1, -1},
/*03772*/     {962, -1, -1},
/*03773*/     {0, -1, -1},
/*03774*/     {963, -1, -1},
/*03775*/     {0, -1, -1},
/*03776*/     {964, -1, -1},
/*03777*/     {0, -1, -1},
/*03778*/     {965, -1, -1},
/*03779*/     {0, -1, -1},
/*03780*/     {966, -1, -1},
/*03781*/     {0, -1, -1},
/*03782*/     {967, -1, -1},
/*03783*/     {0, -1, -1},
/*03784*/     {968, -1, -1},
/*03785*/     {0, -1, -1},
/*03786*/     {969, -1, -1},
/*03787*/     {0, -1, -1},
/*03788*/     {970, -1, -1},
/*03789*/     {0, -1, -1},
/*03790*/     {971, -1, -1},
/*03791*/     {0, -1, -1},
/*03792*/     {972, -1, -1},
/*03793*/     {0, -1, -1},
/*03794*/     {973, -1, -1},
/*03795*/     {0, -1, -1},
/*03796*/     {974, -1, -1},
/*03797*/     {0, -1, -1},
/*03798*/     {975, -1, -1},
/*03799*/     {0, -1, -1},
/*03800*/     {976, -1, -1},
/*03801*/     {0, -1, -1},
/*03802*/     {1556, -1, -1},
/*03803*/     {0, -1, -1},
/*03804*/     {0, -1, -1},
/*03805*/     {0, -1, -1},
/*03806*/     {3836, 28, 2},
/*03807*/     {0, -1, -1},
/*03808*/     {0, -1, -1},
/*03809*/     {0, -1, -1},
/*03810*/     {3848, 28, 4},
/*03811*/     {0, -1, -1},
/*03812*/     {3864, 28, 4},
/*03813*/     {0, -1, -1},
/*03814*/     {3880, 28, 4},
/*03815*/     {0, -1, -1},
/*03816*/     {3896, 28, 4},
/*03817*/     {0, -1, -1},
/*03818*/     {3912, 28, 4},
/*03819*/     {0, -1, -1},
/*03820*/     {3928, 28, 4},
/*03821*/     {0, -1, -1},
/*03822*/     {3944, 28, 4},
/*03823*/     {0, -1, -1},
/*03824*/     {3960, 28, 4},
/*03825*/     {0, -1, -1},
/*03826*/     {0, -1, -1},
/*03827*/     {0, -1, -1},
/*03828*/     {3976, 28, 4},
/*03829*/     {0, -1, -1},
/*03830*/     {0, -1, -1},
/*03831*/     {0, -1, -1},
/*03832*/     {3992, 28, 4},
/*03833*/     {0, -1, -1},
/*03834*/     {0, -1, -1},
/*03835*/     {0, -1, -1},
/*03836*/     {3840, 30, 2},
/*03837*/     {126, -1, -1},
/*03838*/     {3844, 30, 2},
/*03839*/     {125, -1, -1},
/*03840*/     {154, -1, -1},
/*03841*/     {161, -1, -1},
/*03842*/     {0, -1, -1},
/*03843*/     {0, -1, -1},
/*03844*/     {151, -1, -1},
/*03845*/     {0, -1, -1},
/*03846*/     {0, -1, -1},
/*03847*/     {0, -1, -1},
/*03848*/     {0, -1, -1},
/*03849*/     {159, -1, -1},
/*03850*/     {0, -1, -1},
/*03851*/     {157, -1, -1},
/*03852*/     {0, -1, -1},
/*03853*/     {0, -1, -1},
/*03854*/     {0, -1, -1},
/*03855*/     {0, -1, -1},
/*03856*/     {0, -1, -1},
/*03857*/     {166, -1, -1},
/*03858*/     {0, -1, -1},
/*03859*/     {0, -1, -1},
/*03860*/     {0, -1, -1},
/*03861*/     {0, -1, -1},
/*03862*/     {0, -1, -1},
/*03863*/     {0, -1, -1},
/*03864*/     {0, -1, -1},
/*03865*/     {144, -1, -1},
/*03866*/     {0, -1, -1},
/*03867*/     {0, -1, -1},
/*03868*/     {138, -1, -1},
/*03869*/     {145, -1, -1},
/*03870*/     {141, -1, -1},
/*03871*/     {0, -1, -1},
/*03872*/     {129, -1, -1},
/*03873*/     {0, -1, -1},
/*03874*/     {132, -1, -1},
/*03875*/     {148, -1, -1},
/*03876*/     {0, -1, -1},
/*03877*/     {0, -1, -1},
/*03878*/     {0, -1, -1},
/*03879*/     {0, -1, -1},
/*03880*/     {135, -1, -1},
/*03881*/     {0, -1, -1},
/*03882*/     {136, -1, -1},
/*03883*/     {146, -1, -1},
/*03884*/     {139, -1, -1},
/*03885*/     {0, -1, -1},
/*03886*/     {142, -1, -1},
/*03887*/     {147, -1, -1},
/*03888*/     {130, -1, -1},
/*03889*/     {0, -1, -1},
/*03890*/     {133, -1, -1},
/*03891*/     {0, -1, -1},
/*03892*/     {0, -1, -1},
/*03893*/     {127, -1, -1},
/*03894*/     {0, -1, -1},
/*03895*/     {128, -1, -1},
/*03896*/     {0, -1, -1},
/*03897*/     {0, -1, -1},
/*03898*/     {0, -1, -1},
/*03899*/     {0, -1, -1},
/*03900*/     {0, -1, -1},
/*03901*/     {0, -1, -1},
/*03902*/     {0, -1, -1},
/*03903*/     {0, -1, -1},
/*03904*/     {0, -1, -1},
/*03905*/     {0, -1, -1},
/*03906*/     {149, -1, -1},
/*03907*/     {0, -1, -1},
/*03908*/     {0, -1, -1},
/*03909*/     {0, -1, -1},
/*03910*/     {0, -1, -1},
/*03911*/     {0, -1, -1},
/*03912*/     {0, -1, -1},
/*03913*/     {0, -1, -1},
/*03914*/     {0, -1, -1},
/*03915*/     {0, -1, -1},
/*03916*/     {0, -1, -1},
/*03917*/     {164, -1, -1},
/*03918*/     {0, -1, -1},
/*03919*/     {0, -1, -1},
/*03920*/     {0, -1, -1},
/*03921*/     {0, -1, -1},
/*03922*/     {150, -1, -1},
/*03923*/     {0, -1, -1},
/*03924*/     {0, -1, -1},
/*03925*/     {0, -1, -1},
/*03926*/     {0, -1, -1},
/*03927*/     {0, -1, -1},
/*03928*/     {155, -1, -1},
/*03929*/     {0, -1, -1},
/*03930*/     {152, -1, -1},
/*03931*/     {0, -1, -1},
/*03932*/     {162, -1, -1},
/*03933*/     {0, -1, -1},
/*03934*/     {0, -1, -1},
/*03935*/     {0, -1, -1},
/*03936*/     {0, -1, -1},
/*03937*/     {0, -1, -1},
/*03938*/     {0, -1, -1},
/*03939*/     {0, -1, -1},
/*03940*/     {0, -1, -1},
/*03941*/     {0, -1, -1},
/*03942*/     {0, -1, -1},
/*03943*/     {0, -1, -1},
/*03944*/     {156, -1, -1},
/*03945*/     {0, -1, -1},
/*03946*/     {153, -1, -1},
/*03947*/     {0, -1, -1},
/*03948*/     {163, -1, -1},
/*03949*/     {0, -1, -1},
/*03950*/     {0, -1, -1},
/*03951*/     {0, -1, -1},
/*03952*/     {0, -1, -1},
/*03953*/     {0, -1, -1},
/*03954*/     {0, -1, -1},
/*03955*/     {0, -1, -1},
/*03956*/     {0, -1, -1},
/*03957*/     {0, -1, -1},
/*03958*/     {0, -1, -1},
/*03959*/     {0, -1, -1},
/*03960*/     {0, -1, -1},
/*03961*/     {160, -1, -1},
/*03962*/     {0, -1, -1},
/*03963*/     {158, -1, -1},
/*03964*/     {0, -1, -1},
/*03965*/     {0, -1, -1},
/*03966*/     {0, -1, -1},
/*03967*/     {0, -1, -1},
/*03968*/     {0, -1, -1},
/*03969*/     {0, -1, -1},
/*03970*/     {0, -1, -1},
/*03971*/     {0, -1, -1},
/*03972*/     {0, -1, -1},
/*03973*/     {0, -1, -1},
/*03974*/     {0, -1, -1},
/*03975*/     {0, -1, -1},
/*03976*/     {0, -1, -1},
/*03977*/     {0, -1, -1},
/*03978*/     {137, -1, -1},
/*03979*/     {0, -1, -1},
/*03980*/     {140, -1, -1},
/*03981*/     {0, -1, -1},
/*03982*/     {143, -1, -1},
/*03983*/     {0, -1, -1},
/*03984*/     {131, -1, -1},
/*03985*/     {0, -1, -1},
/*03986*/     {134, -1, -1},
/*03987*/     {0, -1, -1},
/*03988*/     {0, -1, -1},
/*03989*/     {0, -1, -1},
/*03990*/     {0, -1, -1},
/*03991*/     {0, -1, -1},
/*03992*/     {0, -1, -1},
/*03993*/     {0, -1, -1},
/*03994*/     {0, -1, -1},
/*03995*/     {0, -1, -1},
/*03996*/     {0, -1, -1},
/*03997*/     {165, -1, -1},
/*03998*/     {0, -1, -1},
/*03999*/     {0, -1, -1},
/*04000*/     {0, -1, -1},
/*04001*/     {0, -1, -1},
/*04002*/     {0, -1, -1},
/*04003*/     {0, -1, -1},
/*04004*/     {0, -1, -1},
/*04005*/     {0, -1, -1},
/*04006*/     {0, -1, -1},
/*04007*/     {0, -1, -1},
/*04008*/     {751, -1, -1},
/*04009*/     {752, -1, -1},
/*04010*/     {751, -1, -1},
/*04011*/     {753, -1, -1},
/*04012*/     {748, -1, -1},
/*04013*/     {749, -1, -1},
/*04014*/     {748, -1, -1},
/*04015*/     {750, -1, -1},
/*04016*/     {742, -1, -1},
/*04017*/     {743, -1, -1},
/*04018*/     {742, -1, -1},
/*04019*/     {744, -1, -1},
/*04020*/     {745, -1, -1},
/*04021*/     {746, -1, -1},
/*04022*/     {745, -1, -1},
/*04023*/     {747, -1, -1},
/*04024*/     {763, -1, -1},
/*04025*/     {764, -1, -1},
/*04026*/     {763, -1, -1},
/*04027*/     {765, -1, -1},
/*04028*/     {760, -1, -1},
/*04029*/     {761, -1, -1},
/*04030*/     {760, -1, -1},
/*04031*/     {762, -1, -1},
/*04032*/     {754, -1, -1},
/*04033*/     {755, -1, -1},
/*04034*/     {754, -1, -1},
/*04035*/     {756, -1, -1},
/*04036*/     {757, -1, -1},
/*04037*/     {758, -1, -1},
/*04038*/     {757, -1, -1},
/*04039*/     {759, -1, -1},
/*04040*/     {775, -1, -1},
/*04041*/     {776, -1, -1},
/*04042*/     {775, -1, -1},
/*04043*/     {777, -1, -1},
/*04044*/     {772, -1, -1},
/*04045*/     {773, -1, -1},
/*04046*/     {772, -1, -1},
/*04047*/     {774, -1, -1},
/*04048*/     {766, -1, -1},
/*04049*/     {767, -1, -1},
/*04050*/     {766, -1, -1},
/*04051*/     {768, -1, -1},
/*04052*/     {769, -1, -1},
/*04053*/     {770, -1, -1},
/*04054*/     {769, -1, -1},
/*04055*/     {771, -1, -1},
/*04056*/     {787, -1, -1},
/*04057*/     {788, -1, -1},
/*04058*/     {787, -1, -1},
/*04059*/     {789, -1, -1},
/*04060*/     {784, -1, -1},
/*04061*/     {785, -1, -1},
/*04062*/     {784, -1, -1},
/*04063*/     {786, -1, -1},
/*04064*/     {778, -1, -1},
/*04065*/     {779, -1, -1},
/*04066*/     {778, -1, -1},
/*04067*/     {780, -1, -1},
/*04068*/     {781, -1, -1},
/*04069*/     {782, -1, -1},
/*04070*/     {781, -1, -1},
/*04071*/     {783, -1, -1},
/*04072*/     {0, -1, -1},
/*04073*/     {0, -1, -1},
/*04074*/     {0, -1, -1},
/*04075*/     {0, -1, -1},
/*04076*/     {0, -1, -1},
/*04077*/     {0, -1, -1},
/*04078*/     {0, -1, -1},
/*04079*/     {0, -1, -1},
/*04080*/     {0, -1, -1},
/*04081*/     {0, -1, -1},
/*04082*/     {0, -1, -1},
/*04083*/     {0, -1, -1},
/*04084*/     {0, -1, -1},
/*04085*/     {0, -1, -1},
/*04086*/     {0, -1, -1},
/*04087*/     {0, -1, -1},
/*04088*/     {0, -1, -1},
/*04089*/     {0, -1, -1},
/*04090*/     {0, -1, -1},
/*04091*/     {0, -1, -1},
/*04092*/     {0, -1, -1},
/*04093*/     {0, -1, -1},
/*04094*/     {0, -1, -1},
/*04095*/     {0, -1, -1},
/*04096*/     {0, -1, -1},
/*04097*/     {0, -1, -1},
/*04098*/     {0, -1, -1},
/*04099*/     {0, -1, -1},
/*04100*/     {0, -1, -1},
/*04101*/     {0, -1, -1},
/*04102*/     {0, -1, -1},
/*04103*/     {0, -1, -1},
/*04104*/     {0, -1, -1},
/*04105*/     {0, -1, -1},
/*04106*/     {0, -1, -1},
/*04107*/     {0, -1, -1},
/*04108*/     {0, -1, -1},
/*04109*/     {0, -1, -1},
/*04110*/     {0, -1, -1},
/*04111*/     {0, -1, -1},
/*04112*/     {0, -1, -1},
/*04113*/     {0, -1, -1},
/*04114*/     {0, -1, -1},
/*04115*/     {0, -1, -1},
/*04116*/     {790, -1, -1},
/*04117*/     {791, -1, -1},
/*04118*/     {790, -1, -1},
/*04119*/     {792, -1, -1},
/*04120*/     {0, -1, -1},
/*04121*/     {0, -1, -1},
/*04122*/     {0, -1, -1},
/*04123*/     {0, -1, -1},
/*04124*/     {0, -1, -1},
/*04125*/     {0, -1, -1},
/*04126*/     {0, -1, -1},
/*04127*/     {0, -1, -1},
/*04128*/     {0, -1, -1},
/*04129*/     {0, -1, -1},
/*04130*/     {0, -1, -1},
/*04131*/     {0, -1, -1},
/*04132*/     {0, -1, -1},
/*04133*/     {0, -1, -1},
/*04134*/     {0, -1, -1},
/*04135*/     {0, -1, -1},
/*04136*/     {802, -1, -1},
/*04137*/     {803, -1, -1},
/*04138*/     {802, -1, -1},
/*04139*/     {804, -1, -1},
/*04140*/     {799, -1, -1},
/*04141*/     {800, -1, -1},
/*04142*/     {799, -1, -1},
/*04143*/     {801, -1, -1},
/*04144*/     {793, -1, -1},
/*04145*/     {794, -1, -1},
/*04146*/     {793, -1, -1},
/*04147*/     {795, -1, -1},
/*04148*/     {796, -1, -1},
/*04149*/     {797, -1, -1},
/*04150*/     {796, -1, -1},
/*04151*/     {798, -1, -1},
/*04152*/     {814, -1, -1},
/*04153*/     {815, -1, -1},
/*04154*/     {814, -1, -1},
/*04155*/     {816, -1, -1},
/*04156*/     {811, -1, -1},
/*04157*/     {812, -1, -1},
/*04158*/     {811, -1, -1},
/*04159*/     {813, -1, -1},
/*04160*/     {805, -1, -1},
/*04161*/     {806, -1, -1},
/*04162*/     {805, -1, -1},
/*04163*/     {807, -1, -1},
/*04164*/     {808, -1, -1},
/*04165*/     {809, -1, -1},
/*04166*/     {808, -1, -1},
/*04167*/     {810, -1, -1},
/*04168*/     {0, -1, -1},
/*04169*/     {0, -1, -1},
/*04170*/     {0, -1, -1},
/*04171*/     {0, -1, -1},
/*04172*/     {0, -1, -1},
/*04173*/     {0, -1, -1},
/*04174*/     {0, -1, -1},
/*04175*/     {0, -1, -1},
/*04176*/     {0, -1, -1},
/*04177*/     {0, -1, -1},
/*04178*/     {0, -1, -1},
/*04179*/     {0, -1, -1},
/*04180*/     {0, -1, -1},
/*04181*/     {0, -1, -1},
/*04182*/     {0, -1, -1},
/*04183*/     {0, -1, -1},
/*04184*/     {977, -1, -1},
/*04185*/     {978, -1, -1},
/*04186*/     {979, -1, -1},
/*04187*/     {980, -1, -1},
/*04188*/     {981, -1, -1},
/*04189*/     {982, -1, -1},
/*04190*/     {983, -1, -1},
/*04191*/     {984, -1, -1},
/*04192*/     {985, -1, -1},
/*04193*/     {986, -1, -1},
/*04194*/     {987, -1, -1},
/*04195*/     {988, -1, -1},
/*04196*/     {989, -1, -1},
/*04197*/     {990, -1, -1},
/*04198*/     {991, -1, -1},
/*04199*/     {992, -1, -1},
/*04200*/     {833, -1, -1},
/*04201*/     {833, -1, -1},
/*04202*/     {833, -1, -1},
/*04203*/     {834, -1, -1},
/*04204*/     {831, -1, -1},
/*04205*/     {831, -1, -1},
/*04206*/     {831, -1, -1},
/*04207*/     {832, -1, -1},
/*04208*/     {827, -1, -1},
/*04209*/     {827, -1, -1},
/*04210*/     {827, -1, -1},
/*04211*/     {828, -1, -1},
/*04212*/     {829, -1, -1},
/*04213*/     {829, -1, -1},
/*04214*/     {829, -1, -1},
/*04215*/     {830, -1, -1},
/*04216*/     {0, -1, -1},
/*04217*/     {0, -1, -1},
/*04218*/     {0, -1, -1},
/*04219*/     {0, -1, -1},
/*04220*/     {0, -1, -1},
/*04221*/     {0, -1, -1},
/*04222*/     {0, -1, -1},
/*04223*/     {0, -1, -1},
/*04224*/     {0, -1, -1},
/*04225*/     {0, -1, -1},
/*04226*/     {0, -1, -1},
/*04227*/     {0, -1, -1},
/*04228*/     {0, -1, -1},
/*04229*/     {0, -1, -1},
/*04230*/     {0, -1, -1},
/*04231*/     {0, -1, -1},
/*04232*/     {0, -1, -1},
/*04233*/     {0, -1, -1},
/*04234*/     {0, -1, -1},
/*04235*/     {0, -1, -1},
/*04236*/     {0, -1, -1},
/*04237*/     {0, -1, -1},
/*04238*/     {0, -1, -1},
/*04239*/     {0, -1, -1},
/*04240*/     {0, -1, -1},
/*04241*/     {0, -1, -1},
/*04242*/     {0, -1, -1},
/*04243*/     {0, -1, -1},
/*04244*/     {835, -1, -1},
/*04245*/     {835, -1, -1},
/*04246*/     {835, -1, -1},
/*04247*/     {836, -1, -1},
/*04248*/     {0, -1, -1},
/*04249*/     {0, -1, -1},
/*04250*/     {0, -1, -1},
/*04251*/     {0, -1, -1},
/*04252*/     {0, -1, -1},
/*04253*/     {0, -1, -1},
/*04254*/     {0, -1, -1},
/*04255*/     {0, -1, -1},
/*04256*/     {0, -1, -1},
/*04257*/     {0, -1, -1},
/*04258*/     {0, -1, -1},
/*04259*/     {0, -1, -1},
/*04260*/     {0, -1, -1},
/*04261*/     {0, -1, -1},
/*04262*/     {0, -1, -1},
/*04263*/     {0, -1, -1},
/*04264*/     {4328, 35, 1},
/*04265*/     {0, -1, -1},
/*04266*/     {0, -1, -1},
/*04267*/     {0, -1, -1},
/*04268*/     {0, -1, -1},
/*04269*/     {0, -1, -1},
/*04270*/     {0, -1, -1},
/*04271*/     {0, -1, -1},
/*04272*/     {4330, 35, 1},
/*04273*/     {0, -1, -1},
/*04274*/     {0, -1, -1},
/*04275*/     {0, -1, -1},
/*04276*/     {0, -1, -1},
/*04277*/     {0, -1, -1},
/*04278*/     {0, -1, -1},
/*04279*/     {0, -1, -1},
/*04280*/     {4332, 35, 1},
/*04281*/     {0, -1, -1},
/*04282*/     {0, -1, -1},
/*04283*/     {0, -1, -1},
/*04284*/     {0, -1, -1},
/*04285*/     {0, -1, -1},
/*04286*/     {0, -1, -1},
/*04287*/     {0, -1, -1},
/*04288*/     {4334, 35, 1},
/*04289*/     {0, -1, -1},
/*04290*/     {0, -1, -1},
/*04291*/     {0, -1, -1},
/*04292*/     {0, -1, -1},
/*04293*/     {0, -1, -1},
/*04294*/     {0, -1, -1},
/*04295*/     {0, -1, -1},
/*04296*/     {0, -1, -1},
/*04297*/     {0, -1, -1},
/*04298*/     {0, -1, -1},
/*04299*/     {0, -1, -1},
/*04300*/     {0, -1, -1},
/*04301*/     {0, -1, -1},
/*04302*/     {0, -1, -1},
/*04303*/     {0, -1, -1},
/*04304*/     {0, -1, -1},
/*04305*/     {0, -1, -1},
/*04306*/     {0, -1, -1},
/*04307*/     {0, -1, -1},
/*04308*/     {0, -1, -1},
/*04309*/     {0, -1, -1},
/*04310*/     {0, -1, -1},
/*04311*/     {0, -1, -1},
/*04312*/     {0, -1, -1},
/*04313*/     {0, -1, -1},
/*04314*/     {0, -1, -1},
/*04315*/     {0, -1, -1},
/*04316*/     {0, -1, -1},
/*04317*/     {0, -1, -1},
/*04318*/     {0, -1, -1},
/*04319*/     {0, -1, -1},
/*04320*/     {0, -1, -1},
/*04321*/     {0, -1, -1},
/*04322*/     {0, -1, -1},
/*04323*/     {0, -1, -1},
/*04324*/     {0, -1, -1},
/*04325*/     {0, -1, -1},
/*04326*/     {0, -1, -1},
/*04327*/     {0, -1, -1},
/*04328*/     {1296, -1, -1},
/*04329*/     {1297, -1, -1},
/*04330*/     {1298, -1, -1},
/*04331*/     {1299, -1, -1},
/*04332*/     {1300, -1, -1},
/*04333*/     {1301, -1, -1},
/*04334*/     {1302, -1, -1},
/*04335*/     {1303, -1, -1},
/*04336*/     {4344, 29, 4},
/*04337*/     {0, -1, -1},
/*04338*/     {4384, 27, 6},
/*04339*/     {4474, 29, 4},
/*04340*/     {18, -1, -1},
/*04341*/     {0, -1, -1},
/*04342*/     {19, -1, -1},
/*04343*/     {0, -1, -1},
/*04344*/     {4360, 27, 2},
/*04345*/     {4364, 27, 2},
/*04346*/     {4368, 27, 2},
/*04347*/     {4372, 27, 2},
/*04348*/     {11, -1, -1},
/*04349*/     {0, -1, -1},
/*04350*/     {12, -1, -1},
/*04351*/     {0, -1, -1},
/*04352*/     {0, -1, -1},
/*04353*/     {4376, 27, 2},
/*04354*/     {0, -1, -1},
/*04355*/     {4380, 27, 2},
/*04356*/     {0, -1, -1},
/*04357*/     {0, -1, -1},
/*04358*/     {0, -1, -1},
/*04359*/     {0, -1, -1},
/*04360*/     {2, -1, -1},
/*04361*/     {3, -1, -1},
/*04362*/     {0, -1, -1},
/*04363*/     {0, -1, -1},
/*04364*/     {5, -1, -1},
/*04365*/     {4, -1, -1},
/*04366*/     {0, -1, -1},
/*04367*/     {0, -1, -1},
/*04368*/     {6, -1, -1},
/*04369*/     {0, -1, -1},
/*04370*/     {0, -1, -1},
/*04371*/     {0, -1, -1},
/*04372*/     {7, -1, -1},
/*04373*/     {8, -1, -1},
/*04374*/     {9, -1, -1},
/*04375*/     {10, -1, -1},
/*04376*/     {0, -1, -1},
/*04377*/     {13, -1, -1},
/*04378*/     {0, -1, -1},
/*04379*/     {0, -1, -1},
/*04380*/     {14, -1, -1},
/*04381*/     {15, -1, -1},
/*04382*/     {16, -1, -1},
/*04383*/     {17, -1, -1},
/*04384*/     {4448, 36, 1},
/*04385*/     {4450, 36, 1},
/*04386*/     {4452, 36, 1},
/*04387*/     {4454, 36, 1},
/*04388*/     {4456, 36, 1},
/*04389*/     {4458, 36, 1},
/*04390*/     {4460, 36, 1},
/*04391*/     {4462, 36, 1},
/*04392*/     {0, -1, -1},
/*04393*/     {0, -1, -1},
/*04394*/     {4464, 36, 1},
/*04395*/     {4466, 36, 1},
/*04396*/     {0, -1, -1},
/*04397*/     {0, -1, -1},
/*04398*/     {4468, 36, 1},
/*04399*/     {0, -1, -1},
/*04400*/     {0, -1, -1},
/*04401*/     {0, -1, -1},
/*04402*/     {0, -1, -1},
/*04403*/     {0, -1, -1},
/*04404*/     {0, -1, -1},
/*04405*/     {0, -1, -1},
/*04406*/     {0, -1, -1},
/*04407*/     {0, -1, -1},
/*04408*/     {0, -1, -1},
/*04409*/     {0, -1, -1},
/*04410*/     {0, -1, -1},
/*04411*/     {0, -1, -1},
/*04412*/     {0, -1, -1},
/*04413*/     {0, -1, -1},
/*04414*/     {0, -1, -1},
/*04415*/     {0, -1, -1},
/*04416*/     {0, -1, -1},
/*04417*/     {0, -1, -1},
/*04418*/     {0, -1, -1},
/*04419*/     {0, -1, -1},
/*04420*/     {4470, 36, 1},
/*04421*/     {4472, 36, 1},
/*04422*/     {0, -1, -1},
/*04423*/     {0, -1, -1},
/*04424*/     {0, -1, -1},
/*04425*/     {0, -1, -1},
/*04426*/     {0, -1, -1},
/*04427*/     {0, -1, -1},
/*04428*/     {0, -1, -1},
/*04429*/     {0, -1, -1},
/*04430*/     {0, -1, -1},
/*04431*/     {0, -1, -1},
/*04432*/     {0, -1, -1},
/*04433*/     {0, -1, -1},
/*04434*/     {0, -1, -1},
/*04435*/     {0, -1, -1},
/*04436*/     {0, -1, -1},
/*04437*/     {0, -1, -1},
/*04438*/     {0, -1, -1},
/*04439*/     {0, -1, -1},
/*04440*/     {0, -1, -1},
/*04441*/     {0, -1, -1},
/*04442*/     {0, -1, -1},
/*04443*/     {0, -1, -1},
/*04444*/     {0, -1, -1},
/*04445*/     {0, -1, -1},
/*04446*/     {0, -1, -1},
/*04447*/     {0, -1, -1},
/*04448*/     {93, -1, -1},
/*04449*/     {95, -1, -1},
/*04450*/     {96, -1, -1},
/*04451*/     {0, -1, -1},
/*04452*/     {98, -1, -1},
/*04453*/     {0, -1, -1},
/*04454*/     {100, -1, -1},
/*04455*/     {0, -1, -1},
/*04456*/     {102, -1, -1},
/*04457*/     {104, -1, -1},
/*04458*/     {105, -1, -1},
/*04459*/     {0, -1, -1},
/*04460*/     {107, -1, -1},
/*04461*/     {0, -1, -1},
/*04462*/     {109, -1, -1},
/*04463*/     {0, -1, -1},
/*04464*/     {111, -1, -1},
/*04465*/     {0, -1, -1},
/*04466*/     {113, -1, -1},
/*04467*/     {0, -1, -1},
/*04468*/     {115, -1, -1},
/*04469*/     {0, -1, -1},
/*04470*/     {117, -1, -1},
/*04471*/     {119, -1, -1},
/*04472*/     {120, -1, -1},
/*04473*/     {122, -1, -1},
/*04474*/     {4490, 27, 2},
/*04475*/     {4502, 27, 2},
/*04476*/     {4514, 27, 2},
/*04477*/     {4522, 27, 2},
/*04478*/     {4528, 36, 1},
/*04479*/     {0, -1, -1},
/*04480*/     {4530, 36, 1},
/*04481*/     {0, -1, -1},
/*04482*/     {0, -1, -1},
/*04483*/     {4532, 27, 2},
/*04484*/     {0, -1, -1},
/*04485*/     {0, -1, -1},
/*04486*/     {0, -1, -1},
/*04487*/     {0, -1, -1},
/*04488*/     {0, -1, -1},
/*04489*/     {0, -1, -1},
/*04490*/     {4494, 36, 1},
/*04491*/     {4496, 36, 1},
/*04492*/     {4498, 36, 1},
/*04493*/     {4500, 36, 1},
/*04494*/     {94, -1, -1},
/*04495*/     {0, -1, -1},
/*04496*/     {97, -1, -1},
/*04497*/     {0, -1, -1},
/*04498*/     {99, -1, -1},
/*04499*/     {0, -1, -1},
/*04500*/     {101, -1, -1},
/*04501*/     {0, -1, -1},
/*04502*/     {4506, 36, 1},
/*04503*/     {4508, 36, 1},
/*04504*/     {4510, 36, 1},
/*04505*/     {4512, 36, 1},
/*04506*/     {103, -1, -1},
/*04507*/     {0, -1, -1},
/*04508*/     {106, -1, -1},
/*04509*/     {0, -1, -1},
/*04510*/     {108, -1, -1},
/*04511*/     {0, -1, -1},
/*04512*/     {110, -1, -1},
/*04513*/     {0, -1, -1},
/*04514*/     {0, -1, -1},
/*04515*/     {0, -1, -1},
/*04516*/     {4518, 36, 1},
/*04517*/     {4520, 36, 1},
/*04518*/     {112, -1, -1},
/*04519*/     {0, -1, -1},
/*04520*/     {114, -1, -1},
/*04521*/     {0, -1, -1},
/*04522*/     {0, -1, -1},
/*04523*/     {0, -1, -1},
/*04524*/     {4526, 36, 1},
/*04525*/     {0, -1, -1},
/*04526*/     {116, -1, -1},
/*04527*/     {0, -1, -1},
/*04528*/     {123, -1, -1},
/*04529*/     {0, -1, -1},
/*04530*/     {124, -1, -1},
/*04531*/     {0, -1, -1},
/*04532*/     {4536, 36, 1},
/*04533*/     {4538, 36, 1},
/*04534*/     {0, -1, -1},
/*04535*/     {0, -1, -1},
/*04536*/     {118, -1, -1},
/*04537*/     {0, -1, -1},
/*04538*/     {121, -1, -1},
/*04539*/     {0, -1, -1},
/*04540*/     {4548, 29, 4},
/*04541*/     {0, -1, -1},
/*04542*/     {4588, 27, 6},
/*04543*/     {4678, 29, 4},
/*04544*/     {18, -1, -1},
/*04545*/     {0, -1, -1},
/*04546*/     {19, -1, -1},
/*04547*/     {0, -1, -1},
/*04548*/     {4564, 27, 2},
/*04549*/     {4568, 27, 2},
/*04550*/     {4572, 27, 2},
/*04551*/     {4576, 27, 2},
/*04552*/     {11, -1, -1},
/*04553*/     {0, -1, -1},
/*04554*/     {12, -1, -1},
/*04555*/     {0, -1, -1},
/*04556*/     {0, -1, -1},
/*04557*/     {4580, 27, 2},
/*04558*/     {0, -1, -1},
/*04559*/     {4584, 27, 2},
/*04560*/     {0, -1, -1},
/*04561*/     {0, -1, -1},
/*04562*/     {0, -1, -1},
/*04563*/     {0, -1, -1},
/*04564*/     {2, -1, -1},
/*04565*/     {3, -1, -1},
/*04566*/     {0, -1, -1},
/*04567*/     {0, -1, -1},
/*04568*/     {5, -1, -1},
/*04569*/     {4, -1, -1},
/*04570*/     {0, -1, -1},
/*04571*/     {0, -1, -1},
/*04572*/     {6, -1, -1},
/*04573*/     {0, -1, -1},
/*04574*/     {0, -1, -1},
/*04575*/     {0, -1, -1},
/*04576*/     {7, -1, -1},
/*04577*/     {8, -1, -1},
/*04578*/     {9, -1, -1},
/*04579*/     {10, -1, -1},
/*04580*/     {0, -1, -1},
/*04581*/     {13, -1, -1},
/*04582*/     {0, -1, -1},
/*04583*/     {0, -1, -1},
/*04584*/     {14, -1, -1},
/*04585*/     {15, -1, -1},
/*04586*/     {16, -1, -1},
/*04587*/     {17, -1, -1},
/*04588*/     {4652, 36, 1},
/*04589*/     {4654, 36, 1},
/*04590*/     {4656, 36, 1},
/*04591*/     {4658, 36, 1},
/*04592*/     {4660, 36, 1},
/*04593*/     {4662, 36, 1},
/*04594*/     {4664, 36, 1},
/*04595*/     {4666, 36, 1},
/*04596*/     {0, -1, -1},
/*04597*/     {0, -1, -1},
/*04598*/     {4668, 36, 1},
/*04599*/     {4670, 36, 1},
/*04600*/     {0, -1, -1},
/*04601*/     {0, -1, -1},
/*04602*/     {4672, 36, 1},
/*04603*/     {0, -1, -1},
/*04604*/     {0, -1, -1},
/*04605*/     {0, -1, -1},
/*04606*/     {0, -1, -1},
/*04607*/     {0, -1, -1},
/*04608*/     {0, -1, -1},
/*04609*/     {0, -1, -1},
/*04610*/     {0, -1, -1},
/*04611*/     {0, -1, -1},
/*04612*/     {0, -1, -1},
/*04613*/     {0, -1, -1},
/*04614*/     {0, -1, -1},
/*04615*/     {0, -1, -1},
/*04616*/     {0, -1, -1},
/*04617*/     {0, -1, -1},
/*04618*/     {0, -1, -1},
/*04619*/     {0, -1, -1},
/*04620*/     {0, -1, -1},
/*04621*/     {0, -1, -1},
/*04622*/     {0, -1, -1},
/*04623*/     {0, -1, -1},
/*04624*/     {4674, 36, 1},
/*04625*/     {4676, 36, 1},
/*04626*/     {0, -1, -1},
/*04627*/     {0, -1, -1},
/*04628*/     {0, -1, -1},
/*04629*/     {0, -1, -1},
/*04630*/     {0, -1, -1},
/*04631*/     {0, -1, -1},
/*04632*/     {0, -1, -1},
/*04633*/     {0, -1, -1},
/*04634*/     {0, -1, -1},
/*04635*/     {0, -1, -1},
/*04636*/     {0, -1, -1},
/*04637*/     {0, -1, -1},
/*04638*/     {0, -1, -1},
/*04639*/     {0, -1, -1},
/*04640*/     {0, -1, -1},
/*04641*/     {0, -1, -1},
/*04642*/     {0, -1, -1},
/*04643*/     {0, -1, -1},
/*04644*/     {0, -1, -1},
/*04645*/     {0, -1, -1},
/*04646*/     {0, -1, -1},
/*04647*/     {0, -1, -1},
/*04648*/     {0, -1, -1},
/*04649*/     {0, -1, -1},
/*04650*/     {0, -1, -1},
/*04651*/     {0, -1, -1},
/*04652*/     {93, -1, -1},
/*04653*/     {95, -1, -1},
/*04654*/     {96, -1, -1},
/*04655*/     {0, -1, -1},
/*04656*/     {98, -1, -1},
/*04657*/     {0, -1, -1},
/*04658*/     {100, -1, -1},
/*04659*/     {0, -1, -1},
/*04660*/     {102, -1, -1},
/*04661*/     {104, -1, -1},
/*04662*/     {105, -1, -1},
/*04663*/     {0, -1, -1},
/*04664*/     {107, -1, -1},
/*04665*/     {0, -1, -1},
/*04666*/     {109, -1, -1},
/*04667*/     {0, -1, -1},
/*04668*/     {111, -1, -1},
/*04669*/     {0, -1, -1},
/*04670*/     {113, -1, -1},
/*04671*/     {0, -1, -1},
/*04672*/     {115, -1, -1},
/*04673*/     {0, -1, -1},
/*04674*/     {117, -1, -1},
/*04675*/     {119, -1, -1},
/*04676*/     {120, -1, -1},
/*04677*/     {122, -1, -1},
/*04678*/     {4694, 27, 2},
/*04679*/     {4706, 27, 2},
/*04680*/     {4718, 27, 2},
/*04681*/     {4726, 27, 2},
/*04682*/     {4732, 36, 1},
/*04683*/     {0, -1, -1},
/*04684*/     {4734, 36, 1},
/*04685*/     {0, -1, -1},
/*04686*/     {0, -1, -1},
/*04687*/     {4736, 27, 2},
/*04688*/     {0, -1, -1},
/*04689*/     {0, -1, -1},
/*04690*/     {0, -1, -1},
/*04691*/     {0, -1, -1},
/*04692*/     {0, -1, -1},
/*04693*/     {0, -1, -1},
/*04694*/     {4698, 36, 1},
/*04695*/     {4700, 36, 1},
/*04696*/     {4702, 36, 1},
/*04697*/     {4704, 36, 1},
/*04698*/     {94, -1, -1},
/*04699*/     {0, -1, -1},
/*04700*/     {97, -1, -1},
/*04701*/     {0, -1, -1},
/*04702*/     {99, -1, -1},
/*04703*/     {0, -1, -1},
/*04704*/     {101, -1, -1},
/*04705*/     {0, -1, -1},
/*04706*/     {4710, 36, 1},
/*04707*/     {4712, 36, 1},
/*04708*/     {4714, 36, 1},
/*04709*/     {4716, 36, 1},
/*04710*/     {103, -1, -1},
/*04711*/     {0, -1, -1},
/*04712*/     {106, -1, -1},
/*04713*/     {0, -1, -1},
/*04714*/     {108, -1, -1},
/*04715*/     {0, -1, -1},
/*04716*/     {110, -1, -1},
/*04717*/     {0, -1, -1},
/*04718*/     {0, -1, -1},
/*04719*/     {0, -1, -1},
/*04720*/     {4722, 36, 1},
/*04721*/     {4724, 36, 1},
/*04722*/     {112, -1, -1},
/*04723*/     {0, -1, -1},
/*04724*/     {114, -1, -1},
/*04725*/     {0, -1, -1},
/*04726*/     {0, -1, -1},
/*04727*/     {0, -1, -1},
/*04728*/     {4730, 36, 1},
/*04729*/     {0, -1, -1},
/*04730*/     {116, -1, -1},
/*04731*/     {0, -1, -1},
/*04732*/     {123, -1, -1},
/*04733*/     {0, -1, -1},
/*04734*/     {124, -1, -1},
/*04735*/     {0, -1, -1},
/*04736*/     {4740, 36, 1},
/*04737*/     {4742, 36, 1},
/*04738*/     {0, -1, -1},
/*04739*/     {0, -1, -1},
/*04740*/     {118, -1, -1},
/*04741*/     {0, -1, -1},
/*04742*/     {121, -1, -1},
/*04743*/     {0, -1, -1},
/*04744*/     {1322, -1, -1},
/*04745*/     {1323, -1, -1},
/*04746*/     {1324, -1, -1},
/*04747*/     {1325, -1, -1},
/*04748*/     {1326, -1, -1},
/*04749*/     {1327, -1, -1},
/*04750*/     {1328, -1, -1},
/*04751*/     {1329, -1, -1},
/*04752*/     {1330, -1, -1},
/*04753*/     {1331, -1, -1},
/*04754*/     {1332, -1, -1},
/*04755*/     {1333, -1, -1},
/*04756*/     {1334, -1, -1},
/*04757*/     {1335, -1, -1},
/*04758*/     {1336, -1, -1},
/*04759*/     {1337, -1, -1},
/*04760*/     {1338, -1, -1},
/*04761*/     {1339, -1, -1},
/*04762*/     {1340, -1, -1},
/*04763*/     {1341, -1, -1},
/*04764*/     {1342, -1, -1},
/*04765*/     {1343, -1, -1},
/*04766*/     {1344, -1, -1},
/*04767*/     {1345, -1, -1},
/*04768*/     {1346, -1, -1},
/*04769*/     {1347, -1, -1},
/*04770*/     {1348, -1, -1},
/*04771*/     {1349, -1, -1},
/*04772*/     {1350, -1, -1},
/*04773*/     {1351, -1, -1},
/*04774*/     {1352, -1, -1},
/*04775*/     {1353, -1, -1},
/*04776*/     {4784, 36, 1},
/*04777*/     {4790, 36, 1},
/*04778*/     {4796, 36, 1},
/*04779*/     {4802, 36, 1},
/*04780*/     {4808, 12, 1},
/*04781*/     {4810, 12, 1},
/*04782*/     {4812, 12, 1},
/*04783*/     {4814, 12, 1},
/*04784*/     {4786, 12, 1},
/*04785*/     {4788, 12, 1},
/*04786*/     {21, -1, -1},
/*04787*/     {24, -1, -1},
/*04788*/     {45, -1, -1},
/*04789*/     {48, -1, -1},
/*04790*/     {4792, 12, 1},
/*04791*/     {4794, 12, 1},
/*04792*/     {27, -1, -1},
/*04793*/     {30, -1, -1},
/*04794*/     {51, -1, -1},
/*04795*/     {54, -1, -1},
/*04796*/     {4798, 12, 1},
/*04797*/     {4800, 12, 1},
/*04798*/     {33, -1, -1},
/*04799*/     {36, -1, -1},
/*04800*/     {57, -1, -1},
/*04801*/     {60, -1, -1},
/*04802*/     {4804, 12, 1},
/*04803*/     {4806, 12, 1},
/*04804*/     {39, -1, -1},
/*04805*/     {42, -1, -1},
/*04806*/     {63, -1, -1},
/*04807*/     {66, -1, -1},
/*04808*/     {69, -1, -1},
/*04809*/     {72, -1, -1},
/*04810*/     {75, -1, -1},
/*04811*/     {78, -1, -1},
/*04812*/     {81, -1, -1},
/*04813*/     {84, -1, -1},
/*04814*/     {87, -1, -1},
/*04815*/     {90, -1, -1},
/*04816*/     {4824, 36, 1},
/*04817*/     {4830, 36, 1},
/*04818*/     {4836, 36, 1},
/*04819*/     {4842, 36, 1},
/*04820*/     {4848, 12, 1},
/*04821*/     {4850, 12, 1},
/*04822*/     {4852, 12, 1},
/*04823*/     {4854, 12, 1},
/*04824*/     {4826, 12, 1},
/*04825*/     {4828, 12, 1},
/*04826*/     {21, -1, -1},
/*04827*/     {24, -1, -1},
/*04828*/     {45, -1, -1},
/*04829*/     {48, -1, -1},
/*04830*/     {4832, 12, 1},
/*04831*/     {4834, 12, 1},
/*04832*/     {27, -1, -1},
/*04833*/     {30, -1, -1},
/*04834*/     {51, -1, -1},
/*04835*/     {54, -1, -1},
/*04836*/     {4838, 12, 1},
/*04837*/     {4840, 12, 1},
/*04838*/     {33, -1, -1},
/*04839*/     {36, -1, -1},
/*04840*/     {57, -1, -1},
/*04841*/     {60, -1, -1},
/*04842*/     {4844, 12, 1},
/*04843*/     {4846, 12, 1},
/*04844*/     {39, -1, -1},
/*04845*/     {42, -1, -1},
/*04846*/     {63, -1, -1},
/*04847*/     {66, -1, -1},
/*04848*/     {69, -1, -1},
/*04849*/     {72, -1, -1},
/*04850*/     {75, -1, -1},
/*04851*/     {78, -1, -1},
/*04852*/     {81, -1, -1},
/*04853*/     {84, -1, -1},
/*04854*/     {87, -1, -1},
/*04855*/     {90, -1, -1},
/*04856*/     {1354, -1, -1},
/*04857*/     {1355, -1, -1},
/*04858*/     {1356, -1, -1},
/*04859*/     {1357, -1, -1},
/*04860*/     {1358, -1, -1},
/*04861*/     {1359, -1, -1},
/*04862*/     {1360, -1, -1},
/*04863*/     {1361, -1, -1},
/*04864*/     {4872, 6, 3},
/*04865*/     {4882, 6, 3},
/*04866*/     {4892, 6, 3},
/*04867*/     {4902, 6, 3},
/*04868*/     {4912, 6, 3},
/*04869*/     {4922, 6, 3},
/*04870*/     {4932, 6, 3},
/*04871*/     {4942, 6, 3},
/*04872*/     {4880, 12, 1},
/*04873*/     {0, -1, -1},
/*04874*/     {0, -1, -1},
/*04875*/     {0, -1, -1},
/*04876*/     {0, -1, -1},
/*04877*/     {0, -1, -1},
/*04878*/     {0, -1, -1},
/*04879*/     {0, -1, -1},
/*04880*/     {1557, -1, -1},
/*04881*/     {1558, -1, -1},
/*04882*/     {4890, 12, 1},
/*04883*/     {0, -1, -1},
/*04884*/     {0, -1, -1},
/*04885*/     {0, -1, -1},
/*04886*/     {0, -1, -1},
/*04887*/     {0, -1, -1},
/*04888*/     {0, -1, -1},
/*04889*/     {0, -1, -1},
/*04890*/     {1559, -1, -1},
/*04891*/     {1560, -1, -1},
/*04892*/     {4900, 12, 1},
/*04893*/     {0, -1, -1},
/*04894*/     {0, -1, -1},
/*04895*/     {0, -1, -1},
/*04896*/     {0, -1, -1},
/*04897*/     {0, -1, -1},
/*04898*/     {0, -1, -1},
/*04899*/     {0, -1, -1},
/*04900*/     {1561, -1, -1},
/*04901*/     {1562, -1, -1},
/*04902*/     {4910, 12, 1},
/*04903*/     {0, -1, -1},
/*04904*/     {0, -1, -1},
/*04905*/     {0, -1, -1},
/*04906*/     {0, -1, -1},
/*04907*/     {0, -1, -1},
/*04908*/     {0, -1, -1},
/*04909*/     {0, -1, -1},
/*04910*/     {1563, -1, -1},
/*04911*/     {1564, -1, -1},
/*04912*/     {4920, 12, 1},
/*04913*/     {0, -1, -1},
/*04914*/     {0, -1, -1},
/*04915*/     {0, -1, -1},
/*04916*/     {0, -1, -1},
/*04917*/     {0, -1, -1},
/*04918*/     {0, -1, -1},
/*04919*/     {0, -1, -1},
/*04920*/     {1565, -1, -1},
/*04921*/     {1566, -1, -1},
/*04922*/     {4930, 12, 1},
/*04923*/     {0, -1, -1},
/*04924*/     {0, -1, -1},
/*04925*/     {0, -1, -1},
/*04926*/     {0, -1, -1},
/*04927*/     {0, -1, -1},
/*04928*/     {0, -1, -1},
/*04929*/     {0, -1, -1},
/*04930*/     {1567, -1, -1},
/*04931*/     {1568, -1, -1},
/*04932*/     {4940, 12, 1},
/*04933*/     {0, -1, -1},
/*04934*/     {0, -1, -1},
/*04935*/     {0, -1, -1},
/*04936*/     {0, -1, -1},
/*04937*/     {0, -1, -1},
/*04938*/     {0, -1, -1},
/*04939*/     {0, -1, -1},
/*04940*/     {1569, -1, -1},
/*04941*/     {1570, -1, -1},
/*04942*/     {4950, 12, 1},
/*04943*/     {0, -1, -1},
/*04944*/     {0, -1, -1},
/*04945*/     {0, -1, -1},
/*04946*/     {0, -1, -1},
/*04947*/     {0, -1, -1},
/*04948*/     {0, -1, -1},
/*04949*/     {0, -1, -1},
/*04950*/     {1571, -1, -1},
/*04951*/     {1572, -1, -1},
/*04952*/     {4960, 36, 1},
/*04953*/     {4966, 36, 1},
/*04954*/     {4972, 36, 1},
/*04955*/     {4978, 36, 1},
/*04956*/     {4984, 12, 1},
/*04957*/     {4986, 12, 1},
/*04958*/     {4988, 12, 1},
/*04959*/     {4990, 12, 1},
/*04960*/     {4962, 12, 1},
/*04961*/     {4964, 12, 1},
/*04962*/     {22, -1, -1},
/*04963*/     {25, -1, -1},
/*04964*/     {46, -1, -1},
/*04965*/     {49, -1, -1},
/*04966*/     {4968, 12, 1},
/*04967*/     {4970, 12, 1},
/*04968*/     {28, -1, -1},
/*04969*/     {31, -1, -1},
/*04970*/     {52, -1, -1},
/*04971*/     {55, -1, -1},
/*04972*/     {4974, 12, 1},
/*04973*/     {4976, 12, 1},
/*04974*/     {34, -1, -1},
/*04975*/     {37, -1, -1},
/*04976*/     {58, -1, -1},
/*04977*/     {61, -1, -1},
/*04978*/     {4980, 12, 1},
/*04979*/     {4982, 12, 1},
/*04980*/     {40, -1, -1},
/*04981*/     {43, -1, -1},
/*04982*/     {64, -1, -1},
/*04983*/     {67, -1, -1},
/*04984*/     {70, -1, -1},
/*04985*/     {73, -1, -1},
/*04986*/     {76, -1, -1},
/*04987*/     {79, -1, -1},
/*04988*/     {82, -1, -1},
/*04989*/     {85, -1, -1},
/*04990*/     {88, -1, -1},
/*04991*/     {91, -1, -1},
/*04992*/     {5000, 36, 1},
/*04993*/     {5006, 36, 1},
/*04994*/     {5012, 36, 1},
/*04995*/     {5018, 36, 1},
/*04996*/     {5024, 12, 1},
/*04997*/     {5026, 12, 1},
/*04998*/     {5028, 12, 1},
/*04999*/     {5030, 12, 1},
/*05000*/     {5002, 12, 1},
/*05001*/     {5004, 12, 1},
/*05002*/     {22, -1, -1},
/*05003*/     {25, -1, -1},
/*05004*/     {46, -1, -1},
/*05005*/     {49, -1, -1},
/*05006*/     {5008, 12, 1},
/*05007*/     {5010, 12, 1},
/*05008*/     {28, -1, -1},
/*05009*/     {31, -1, -1},
/*05010*/     {52, -1, -1},
/*05011*/     {55, -1, -1},
/*05012*/     {5014, 12, 1},
/*05013*/     {5016, 12, 1},
/*05014*/     {34, -1, -1},
/*05015*/     {37, -1, -1},
/*05016*/     {58, -1, -1},
/*05017*/     {61, -1, -1},
/*05018*/     {5020, 12, 1},
/*05019*/     {5022, 12, 1},
/*05020*/     {40, -1, -1},
/*05021*/     {43, -1, -1},
/*05022*/     {64, -1, -1},
/*05023*/     {67, -1, -1},
/*05024*/     {70, -1, -1},
/*05025*/     {73, -1, -1},
/*05026*/     {76, -1, -1},
/*05027*/     {79, -1, -1},
/*05028*/     {82, -1, -1},
/*05029*/     {85, -1, -1},
/*05030*/     {88, -1, -1},
/*05031*/     {91, -1, -1},
/*05032*/     {1362, -1, -1},
/*05033*/     {1363, -1, -1},
/*05034*/     {1364, -1, -1},
/*05035*/     {1365, -1, -1},
/*05036*/     {1366, -1, -1},
/*05037*/     {1367, -1, -1},
/*05038*/     {1368, -1, -1},
/*05039*/     {1369, -1, -1},
/*05040*/     {5048, 12, 1},
/*05041*/     {5050, 12, 1},
/*05042*/     {5052, 12, 1},
/*05043*/     {5054, 12, 1},
/*05044*/     {5056, 12, 1},
/*05045*/     {5058, 12, 1},
/*05046*/     {5060, 12, 1},
/*05047*/     {5062, 12, 1},
/*05048*/     {1573, -1, -1},
/*05049*/     {1574, -1, -1},
/*05050*/     {1575, -1, -1},
/*05051*/     {1576, -1, -1},
/*05052*/     {1577, -1, -1},
/*05053*/     {1578, -1, -1},
/*05054*/     {1579, -1, -1},
/*05055*/     {1580, -1, -1},
/*05056*/     {1581, -1, -1},
/*05057*/     {1582, -1, -1},
/*05058*/     {1583, -1, -1},
/*05059*/     {1584, -1, -1},
/*05060*/     {1585, -1, -1},
/*05061*/     {1586, -1, -1},
/*05062*/     {1587, -1, -1},
/*05063*/     {1588, -1, -1},
/*05064*/     {5072, 36, 1},
/*05065*/     {5078, 36, 1},
/*05066*/     {5084, 36, 1},
/*05067*/     {5090, 36, 1},
/*05068*/     {5096, 12, 1},
/*05069*/     {5098, 12, 1},
/*05070*/     {5100, 12, 1},
/*05071*/     {5102, 12, 1},
/*05072*/     {5074, 12, 1},
/*05073*/     {5076, 12, 1},
/*05074*/     {23, -1, -1},
/*05075*/     {26, -1, -1},
/*05076*/     {47, -1, -1},
/*05077*/     {50, -1, -1},
/*05078*/     {5080, 12, 1},
/*05079*/     {5082, 12, 1},
/*05080*/     {29, -1, -1},
/*05081*/     {32, -1, -1},
/*05082*/     {53, -1, -1},
/*05083*/     {56, -1, -1},
/*05084*/     {5086, 12, 1},
/*05085*/     {5088, 12, 1},
/*05086*/     {35, -1, -1},
/*05087*/     {38, -1, -1},
/*05088*/     {59, -1, -1},
/*05089*/     {62, -1, -1},
/*05090*/     {5092, 12, 1},
/*05091*/     {5094, 12, 1},
/*05092*/     {41, -1, -1},
/*05093*/     {44, -1, -1},
/*05094*/     {65, -1, -1},
/*05095*/     {68, -1, -1},
/*05096*/     {71, -1, -1},
/*05097*/     {74, -1, -1},
/*05098*/     {77, -1, -1},
/*05099*/     {80, -1, -1},
/*05100*/     {83, -1, -1},
/*05101*/     {86, -1, -1},
/*05102*/     {89, -1, -1},
/*05103*/     {92, -1, -1},
/*05104*/     {5112, 36, 1},
/*05105*/     {5118, 36, 1},
/*05106*/     {5124, 36, 1},
/*05107*/     {5130, 36, 1},
/*05108*/     {5136, 12, 1},
/*05109*/     {5138, 12, 1},
/*05110*/     {5140, 12, 1},
/*05111*/     {5142, 12, 1},
/*05112*/     {5114, 12, 1},
/*05113*/     {5116, 12, 1},
/*05114*/     {23, -1, -1},
/*05115*/     {26, -1, -1},
/*05116*/     {47, -1, -1},
/*05117*/     {50, -1, -1},
/*05118*/     {5120, 12, 1},
/*05119*/     {5122, 12, 1},
/*05120*/     {29, -1, -1},
/*05121*/     {32, -1, -1},
/*05122*/     {53, -1, -1},
/*05123*/     {56, -1, -1},
/*05124*/     {5126, 12, 1},
/*05125*/     {5128, 12, 1},
/*05126*/     {35, -1, -1},
/*05127*/     {38, -1, -1},
/*05128*/     {59, -1, -1},
/*05129*/     {62, -1, -1},
/*05130*/     {5132, 12, 1},
/*05131*/     {5134, 12, 1},
/*05132*/     {41, -1, -1},
/*05133*/     {44, -1, -1},
/*05134*/     {65, -1, -1},
/*05135*/     {68, -1, -1},
/*05136*/     {71, -1, -1},
/*05137*/     {74, -1, -1},
/*05138*/     {77, -1, -1},
/*05139*/     {80, -1, -1},
/*05140*/     {83, -1, -1},
/*05141*/     {86, -1, -1},
/*05142*/     {89, -1, -1},
/*05143*/     {92, -1, -1},
/*05144*/     {1373, -1, -1},
/*05145*/     {5146, 34, 2},
/*05146*/     {1370, -1, -1},
/*05147*/     {0, -1, -1},
/*05148*/     {1372, -1, -1},
/*05149*/     {1371, -1, -1}
};

#define ArchRev0 0
#define Impl_Itanium 1
#define Impl_Brl 2

IA64OpcodeEntry IA64OpcodeTable[] = {
	{NULL,IA64_FORMAT_NONE,IA64_TROLE_NONE,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ignored",IA64_FORMAT_NONE,IA64_TROLE_NONE,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"add",IA64_FORMAT_A1,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"add",IA64_FORMAT_A1,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_ONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"sub",IA64_FORMAT_A1,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"sub",IA64_FORMAT_A1,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_ONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"addp4",IA64_FORMAT_A1,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"and",IA64_FORMAT_A1,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"andcm",IA64_FORMAT_A1,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"or",IA64_FORMAT_A1,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xor",IA64_FORMAT_A1,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"shladd",IA64_FORMAT_A2,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UDEC},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"shladdp4",IA64_FORMAT_A2,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UDEC},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"sub",IA64_FORMAT_A3,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"and",IA64_FORMAT_A3,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"andcm",IA64_FORMAT_A3,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"or",IA64_FORMAT_A3,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xor",IA64_FORMAT_A3,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"adds",IA64_FORMAT_A4,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"addp4",IA64_FORMAT_A4,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"addl",IA64_FORMAT_A5,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0_3},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.lt",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ltu",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.lt.unc",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ltu.unc",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq.unc",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq.and",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq.or",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq.or.andcm",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ne.and",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ne.or",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ne.or.andcm",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.lt",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ltu",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.lt.unc",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ltu.unc",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq.unc",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq.and",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq.or",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq.or.andcm",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ne.and",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ne.or",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ne.or.andcm",IA64_FORMAT_A6,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.gt.and",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.gt.or",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.gt.or.andcm",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.le.and",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.le.or",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.le.or.andcm",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ge.and",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ge.or",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ge.or.andcm",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.lt.and",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.lt.or",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.lt.or.andcm",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.gt.and",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.gt.or",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.gt.or.andcm",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.le.and",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.le.or",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.le.or.andcm",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ge.and",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ge.or",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ge.or.andcm",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.lt.and",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.lt.or",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.lt.or.andcm",IA64_FORMAT_A7,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_R0},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.lt",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ltu",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_CMP_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.lt.unc",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ltu.unc",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_CMP_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq.unc",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq.and",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq.or",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.eq.or.andcm",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ne.and",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ne.or",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp.ne.or.andcm",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.lt",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ltu",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_CMP4_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.lt.unc",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ltu.unc",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_CMP4_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq.unc",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq.and",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq.or",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.eq.or.andcm",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ne.and",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ne.or",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmp4.ne.or.andcm",IA64_FORMAT_A8,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"padd1",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"padd2",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"padd4",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"padd1.sss",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"padd2.sss",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"padd1.uuu",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"padd2.uuu",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"padd1.uus",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"padd2.uus",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psub1",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psub2",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psub4",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psub1.sss",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psub2.sss",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psub1.uuu",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psub2.uuu",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psub1.uus",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psub2.uus",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pavg1",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pavg2",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pavg1.raz",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pavg2.raz",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pavgsub1",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pavgsub2",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pcmp1.eq",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pcmp2.eq",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pcmp4.eq",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pcmp1.gt",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pcmp2.gt",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pcmp4.gt",IA64_FORMAT_A9,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshladd2",IA64_FORMAT_A10,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_COUNT_123},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshradd2",IA64_FORMAT_A10,IA64_TROLE_ALU,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_COUNT_123},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pmpyshr2",IA64_FORMAT_I1,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_COUNT_PACK},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pmpyshr2.u",IA64_FORMAT_I1,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_COUNT_PACK},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pmpy2.r",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pmpy2.l",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mix1.r",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mix2.r",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mix4.r",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mix1.l",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mix2.l",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mix4.l",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pack2.uss",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pack2.sss",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pack4.sss",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"unpack1.h",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"unpack2.h",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"unpack4.h",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"unpack1.l",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"unpack2.l",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"unpack4.l",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pmin1.u",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pmax1.u",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pmin2",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pmax2",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"psad1",IA64_FORMAT_I2,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mux1",IA64_FORMAT_I3,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_MUX1},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mux2",IA64_FORMAT_I4,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshr2",IA64_FORMAT_I5,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshr4",IA64_FORMAT_I5,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"shr",IA64_FORMAT_I5,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshr2.u",IA64_FORMAT_I5,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshr4.u",IA64_FORMAT_I5,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"shr.u",IA64_FORMAT_I5,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshr2",IA64_FORMAT_I6,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshr4",IA64_FORMAT_I6,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshr2.u",IA64_FORMAT_I6,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshr4.u",IA64_FORMAT_I6,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshl2",IA64_FORMAT_I7,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshl4",IA64_FORMAT_I7,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"shl",IA64_FORMAT_I7,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshl2",IA64_FORMAT_I8,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_CCOUNT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"pshl4",IA64_FORMAT_I8,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_CCOUNT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"popcnt",IA64_FORMAT_I9,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"shrp",IA64_FORMAT_I10,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"extr.u",IA64_FORMAT_I11,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_UDEC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"extr",IA64_FORMAT_I11,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_UDEC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"dep.z",IA64_FORMAT_I12,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_CPOS},{IA64_OPROLE_SRC,IA64_OPTYPE_UDEC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"dep.z",IA64_FORMAT_I13,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_CPOS},{IA64_OPROLE_SRC,IA64_OPTYPE_UDEC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"dep",IA64_FORMAT_I14,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_CPOS},{IA64_OPROLE_SRC,IA64_OPTYPE_UDEC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"dep",IA64_FORMAT_I15,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_CPOS},{IA64_OPROLE_SRC,IA64_OPTYPE_UDEC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tbit.z",IA64_FORMAT_I16,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tbit.z.unc",IA64_FORMAT_I16,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tbit.z.and",IA64_FORMAT_I16,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tbit.nz.and",IA64_FORMAT_I16,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tbit.z.or",IA64_FORMAT_I16,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tbit.nz.or",IA64_FORMAT_I16,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tbit.z.or.andcm",IA64_FORMAT_I16,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tbit.nz.or.andcm",IA64_FORMAT_I16,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tnat.z",IA64_FORMAT_I17,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tnat.z.unc",IA64_FORMAT_I17,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tnat.z.and",IA64_FORMAT_I17,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tnat.nz.and",IA64_FORMAT_I17,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tnat.z.or",IA64_FORMAT_I17,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tnat.nz.or",IA64_FORMAT_I17,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tnat.z.or.andcm",IA64_FORMAT_I17,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tnat.nz.or.andcm",IA64_FORMAT_I17,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"break.i",IA64_FORMAT_I19,IA64_TROLE_INT,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"nop.i",IA64_FORMAT_I19,IA64_TROLE_INT,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"chk.s.i",IA64_FORMAT_I20,IA64_TROLE_INT,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.sptk",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.sptk.imp",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.imp",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.dptk",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.dptk.imp",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.ret.sptk",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.ret.sptk.imp",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.ret",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.ret.imp",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.ret.dptk",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.ret.dptk.imp",IA64_FORMAT_I21,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_I22,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_I23,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREGS_ALL},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_1},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_I24,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_PREGS_ROT},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_16},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_I25,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IP},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_I25,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_PREGS_ALL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.i",IA64_FORMAT_I26,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_APP_REG_GRP_HIGH},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.i",IA64_FORMAT_I27,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_APP_REG_GRP_HIGH},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.i",IA64_FORMAT_I28,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_REG_GRP_HIGH},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"zxt1",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"zxt2",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"zxt4",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"sxt1",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"sxt2",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"sxt4",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"czx1.l",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"czx2.l",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"czx1.r",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"czx2.r",IA64_FORMAT_I29,IA64_TROLE_INT,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.s",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.s.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.s.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.s",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.s.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.s.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.s",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.s.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.s.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.s",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.s.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.s.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.a",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.a.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.a.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.a",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.a.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.a.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.a",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.a.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.a.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.a",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.a.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.a.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.sa",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.sa.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.sa.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.sa",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.sa.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.sa.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.sa",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.sa.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.sa.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.sa",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.sa.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.sa.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.bias",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.bias.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.bias.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.bias",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.bias.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.bias.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.bias",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.bias.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.bias.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.bias",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.bias.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.bias.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.acq",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.acq.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.acq.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.acq",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.acq.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.acq.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.acq",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.acq.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.acq.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.acq",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.acq.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.acq.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.fill",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.fill.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.fill.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.nc",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.nc.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.nc.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.nc",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.nc.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.nc.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.nc",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.nc.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.nc.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.nc",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.nc.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.nc.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.acq",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.acq.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.acq.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.acq",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.acq.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.acq.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.acq",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.acq.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.acq.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.acq",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.acq.nt1",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.acq.nta",IA64_FORMAT_M1,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.s",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.s.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.s.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.s",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.s.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.s.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.s",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.s.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.s.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.s",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.s.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.s.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.a",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.a.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.a.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.a",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.a.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.a.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.a",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.a.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.a.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.a",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.a.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.a.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.sa",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.sa.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.sa.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.sa",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.sa.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.sa.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.sa",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.sa.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.sa.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.sa",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.sa.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.sa.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.bias",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.bias.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.bias.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.bias",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.bias.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.bias.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.bias",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.bias.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.bias.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.bias",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.bias.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.bias.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.acq",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.acq.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.acq.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.acq",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.acq.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.acq.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.acq",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.acq.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.acq.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.acq",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.acq.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.acq.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.fill",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.fill.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.fill.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.nc",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.nc.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.nc.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.nc",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.nc.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.nc.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.nc",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.nc.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.nc.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.nc",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.nc.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.nc.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.acq",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.acq.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.acq.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.acq",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.acq.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.acq.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.acq",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.acq.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.acq.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.acq",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.acq.nt1",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.acq.nta",IA64_FORMAT_M2,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.s",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.s.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.s.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.s",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.s.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.s.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.s",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.s.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.s.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.s",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.s.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.s.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.a",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.a.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.a.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.a",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.a.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.a.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.a",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.a.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.a.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.a",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.a.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.a.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.sa",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.sa.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.sa.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.sa",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.sa.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.sa.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.sa",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.sa.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.sa.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.sa",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.sa.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.sa.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.bias",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.bias.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.bias.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.bias",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.bias.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.bias.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.bias",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.bias.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.bias.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.bias",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.bias.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.bias.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.acq",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.acq.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.acq.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.acq",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.acq.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.acq.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.acq",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.acq.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.acq.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.acq",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.acq.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.acq.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.fill",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.fill.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.fill.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.nc",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.nc.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.nc.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.nc",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.nc.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.nc.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.nc",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.nc.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.nc.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.nc",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.nc.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.nc.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.acq",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.acq.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld1.c.clr.acq.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.acq",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.acq.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld2.c.clr.acq.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.acq",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.acq.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld4.c.clr.acq.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.acq",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.acq.nt1",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ld8.c.clr.acq.nta",IA64_FORMAT_M3,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st1",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st1.nta",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st2",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st2.nta",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st4",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st4.nta",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.nta",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st1.rel",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st1.rel.nta",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st2.rel",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st2.rel.nta",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st4.rel",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st4.rel.nta",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.rel",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.rel.nta",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.spill",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.spill.nta",IA64_FORMAT_M4,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st1",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st1.nta",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st2",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st2.nta",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st4",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st4.nta",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.nta",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st1.rel",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st1.rel.nta",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st2.rel",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st2.rel.nta",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st4.rel",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st4.rel.nta",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.rel",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.rel.nta",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.spill",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"st8.spill.nta",IA64_FORMAT_M5,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.s",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.s.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.s.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.s",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.s.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.s.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.s",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.s.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.s.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.s",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.s.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.s.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.a",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.a.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.a.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.a",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.a.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.a.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.a",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.a.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.a.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.a",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.a.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.a.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.sa",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.sa.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.sa.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.sa",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.sa.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.sa.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.sa",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.sa.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.sa.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.sa",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.sa.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.sa.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf.fill",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf.fill.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf.fill.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.clr",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.clr.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.clr.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.clr",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.clr.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.clr.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.clr",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.clr.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.clr.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.clr",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.clr.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.clr.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.nc",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.nc.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.nc.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.nc",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.nc.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.nc.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.nc",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.nc.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.nc.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.nc",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.nc.nt1",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.nc.nta",IA64_FORMAT_M6,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.s",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.s.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.s.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.s",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.s.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.s.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.s",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.s.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.s.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.s",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.s.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.s.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.a",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.a.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.a.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.a",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.a.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.a.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.a",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.a.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.a.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.a",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.a.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.a.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.sa",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.sa.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.sa.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.sa",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.sa.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.sa.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.sa",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.sa.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.sa.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.sa",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.sa.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.sa.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf.fill",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf.fill.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf.fill.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.clr",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.clr.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.clr.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.clr",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.clr.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.clr.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.clr",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.clr.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.clr.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.clr",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.clr.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.clr.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.nc",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.nc.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.nc.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.nc",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.nc.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.nc.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.nc",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.nc.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.nc.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.nc",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.nc.nt1",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.nc.nta",IA64_FORMAT_M7,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.s",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.s.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.s.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.s",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.s.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.s.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.s",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.s.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.s.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.s",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.s.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.s.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.a",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.a.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.a.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.a",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.a.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.a.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.a",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.a.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.a.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.a",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.a.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.a.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.sa",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.sa.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.sa.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.sa",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.sa.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.sa.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.sa",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.sa.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.sa.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.sa",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.sa.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.sa.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf.fill",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf.fill.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf.fill.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.clr",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.clr.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.clr.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.clr",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.clr.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.clr.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.clr",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.clr.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.clr.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.clr",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.clr.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.clr.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.nc",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.nc.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfs.c.nc.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.nc",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.nc.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfd.c.nc.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.nc",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.nc.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldf8.c.nc.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.nc",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.nc.nt1",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfe.c.nc.nta",IA64_FORMAT_M8,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfs",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfs.nta",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfd",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfd.nta",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stf8",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stf8.nta",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfe",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfe.nta",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stf.spill",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stf.spill.nta",IA64_FORMAT_M9,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfs",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfs.nta",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfd",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfd.nta",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stf8",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stf8.nta",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfe",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stfe.nta",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stf.spill",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"stf.spill.nta",IA64_FORMAT_M10,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.s",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.s.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.s.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.s",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.s.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.s.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.s",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.s.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.s.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.a",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.a.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.a.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.a",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.a.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.a.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.a",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.a.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.a.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.sa",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.sa.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.sa.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.sa",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.sa.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.sa.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.sa",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.sa.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.sa.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.clr",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.clr.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.clr.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.clr",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.clr.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.clr.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.clr",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.clr.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.clr.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.nc",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.nc.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.nc.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.nc",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.nc.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.nc.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.nc",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.nc.nt1",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.nc.nta",IA64_FORMAT_M11,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.s",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.s.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.s.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.s",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.s.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.s.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.s",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.s.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.s.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.a",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.a.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.a.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.a",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.a.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.a.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.a",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.a.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.a.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.sa",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.sa.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.sa.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.sa",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.sa.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.sa.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.sa",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.sa.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.sa.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.clr",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.clr.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.clr.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.clr",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.clr.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.clr.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.clr",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.clr.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.clr.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.nc",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.nc.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfps.c.nc.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_EIGHT},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.nc",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.nc.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfpd.c.nc.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.nc",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.nc.nt1",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ldfp8.c.nc.nta",IA64_FORMAT_M12,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIXTEEN},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.nt1",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.nt2",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.nta",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl.nt1",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl.nt2",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl.nta",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.nt1",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.nt2",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.nta",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl.nt1",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl.nt2",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl.nta",IA64_FORMAT_M13,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.nt1",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.nt2",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.nta",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl.nt1",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl.nt2",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl.nta",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.nt1",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.nt2",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.nta",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl.nt1",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl.nt2",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl.nta",IA64_FORMAT_M14,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.nt1",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.nt2",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.nta",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl.nt1",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl.nt2",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.excl.nta",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.nt1",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.nt2",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.nta",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl.nt1",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl.nt2",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"lfetch.fault.excl.nta",IA64_FORMAT_M15,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg1.acq",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg1.acq.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg1.acq.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg2.acq",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg2.acq.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg2.acq.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg4.acq",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg4.acq.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg4.acq.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg8.acq",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg8.acq.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg8.acq.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg1.rel",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg1.rel.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg1.rel.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg2.rel",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg2.rel.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg2.rel.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg4.rel",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg4.rel.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg4.rel.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg8.rel",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg8.rel.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cmpxchg8.rel.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_CCV},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg1.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg1.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg2",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg2.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg2.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg4",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg4.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg4.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg8",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg8.nt1",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xchg8.nta",IA64_FORMAT_M16,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd4.acq",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd4.acq.nt1",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd4.acq.nta",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd8.acq",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd8.acq.nt1",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd8.acq.nta",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd4.rel",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd4.rel.nt1",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd4.rel.nta",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd8.rel",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd8.rel.nt1",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fetchadd8.rel.nta",IA64_FORMAT_M17,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MEM},{IA64_OPROLE_SRC,IA64_OPTYPE_SEMAPHORE_INC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"setf.sig",IA64_FORMAT_M18,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"setf.exp",IA64_FORMAT_M18,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"setf.s",IA64_FORMAT_M18,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"setf.d",IA64_FORMAT_M18,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"getf.sig",IA64_FORMAT_M19,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"getf.exp",IA64_FORMAT_M19,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"getf.s",IA64_FORMAT_M19,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"getf.d",IA64_FORMAT_M19,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"chk.s.m",IA64_FORMAT_M20,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"chk.s",IA64_FORMAT_M21,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"chk.a.nc",IA64_FORMAT_M22,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_NUM},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"chk.a.clr",IA64_FORMAT_M22,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_NUM},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"chk.a.nc",IA64_FORMAT_M23,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_FREG_NUM},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"chk.a.clr",IA64_FORMAT_M23,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_FREG_NUM},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"invala",IA64_FORMAT_M24,IA64_TROLE_MEM,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fwb",IA64_FORMAT_M24,IA64_TROLE_MEM,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mf",IA64_FORMAT_M24,IA64_TROLE_MEM,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mf.a",IA64_FORMAT_M24,IA64_TROLE_MEM,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"srlz.d",IA64_FORMAT_M24,IA64_TROLE_MEM,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"srlz.i",IA64_FORMAT_M24,IA64_TROLE_MEM,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"sync.i",IA64_FORMAT_M24,IA64_TROLE_MEM,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"flushrs",IA64_FORMAT_M25,IA64_TROLE_MEM,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"loadrs",IA64_FORMAT_M25,IA64_TROLE_MEM,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"invala.e",IA64_FORMAT_M26,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG_NUM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"invala.e",IA64_FORMAT_M27,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_FREG_NUM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fc",IA64_FORMAT_M28,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ptc.e",IA64_FORMAT_M28,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.m",IA64_FORMAT_M29,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_APP_REG_GRP_LOW},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.m",IA64_FORMAT_M30,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_APP_REG_GRP_LOW},{IA64_OPROLE_SRC,IA64_OPTYPE_SIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov.m",IA64_FORMAT_M31,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_REG_GRP_LOW},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M32,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_CR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M33,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_CR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"alloc",IA64_FORMAT_M34,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_APP_PFS},{IA64_OPROLE_SRC,IA64_OPTYPE_ALLOC_IOL},{IA64_OPROLE_SRC,IA64_OPTYPE_ALLOC_IOL},{IA64_OPROLE_SRC,IA64_OPTYPE_ALLOC_IOL},{IA64_OPROLE_SRC,IA64_OPTYPE_ALLOC_ROT}},
	{"mov",IA64_FORMAT_M35,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_PSR_L},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M35,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_PSR_UM},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M36,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_PSR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M36,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_PSR_UM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"break.m",IA64_FORMAT_M37,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"nop.m",IA64_FORMAT_M37,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"probe.r",IA64_FORMAT_M38,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"probe.w",IA64_FORMAT_M38,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"probe.r",IA64_FORMAT_M39,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"probe.w",IA64_FORMAT_M39,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"probe.rw.fault",IA64_FORMAT_M40,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"probe.r.fault",IA64_FORMAT_M40,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"probe.w.fault",IA64_FORMAT_M40,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"itc.d",IA64_FORMAT_M41,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"itc.i",IA64_FORMAT_M41,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M42,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_RR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M42,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_DBR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M42,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IBR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M42,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_PKR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M42,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_PMC},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M42,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_PMD},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M42,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_MSR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"itr.d",IA64_FORMAT_M42,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_DTR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"itr.i",IA64_FORMAT_M42,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_ITR},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M43,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_RR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M43,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_DBR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M43,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IBR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M43,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_PKR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M43,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_PMC},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M43,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_MSR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M43,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_PMD},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"mov",IA64_FORMAT_M43,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_CPUID},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"sum",IA64_FORMAT_M44,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"rum",IA64_FORMAT_M44,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ssm",IA64_FORMAT_M44,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"rsm",IA64_FORMAT_M44,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ptc.l",IA64_FORMAT_M45,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ptc.g",IA64_FORMAT_M45,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ptc.ga",IA64_FORMAT_M45,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ptr.d",IA64_FORMAT_M45,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ptr.i",IA64_FORMAT_M45,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"thash",IA64_FORMAT_M46,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"ttag",IA64_FORMAT_M46,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tpa",IA64_FORMAT_M46,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"tak",IA64_FORMAT_M46,IA64_TROLE_MEM,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"halt",IA64_FORMAT_M1001,IA64_TROLE_MEM,{IA64_OPROLE_SRC,IA64_OPTYPE_IREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.sptk.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.sptk.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.spnt.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.spnt.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dptk.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dptk.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dpnt.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dpnt.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.sptk.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.sptk.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.spnt.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.spnt.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dptk.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dptk.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dpnt.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dpnt.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.sptk.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.sptk.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.spnt.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.spnt.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.dptk.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.dptk.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.dpnt.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.dpnt.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.sptk.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.sptk.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.spnt.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.spnt.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.dptk.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.dptk.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.dpnt.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wexit.dpnt.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.sptk.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.sptk.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.spnt.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.spnt.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.dptk.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.dptk.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.dpnt.few",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.dpnt.many",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.sptk.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.sptk.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.spnt.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.spnt.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.dptk.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.dptk.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.dpnt.few.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.wtop.dpnt.many.clr",IA64_FORMAT_B1,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.sptk.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.sptk.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.spnt.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.spnt.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.dptk.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.dptk.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.dpnt.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.dpnt.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.sptk.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.sptk.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.spnt.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.spnt.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.dptk.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.dptk.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.dpnt.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cloop.dpnt.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.sptk.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.sptk.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.spnt.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.spnt.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.dptk.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.dptk.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.dpnt.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.dpnt.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.sptk.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.sptk.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.spnt.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.spnt.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.dptk.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.dptk.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.dpnt.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cexit.dpnt.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.sptk.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.sptk.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.spnt.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.spnt.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.dptk.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.dptk.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.dpnt.few",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.dpnt.many",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.sptk.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.sptk.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.spnt.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.spnt.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.dptk.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.dptk.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.dpnt.few.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ctop.dpnt.many.clr",IA64_FORMAT_B2,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.sptk.few",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.sptk.many",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.spnt.few",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.spnt.many",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dptk.few",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dptk.many",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dpnt.few",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dpnt.many",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.sptk.few.clr",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.sptk.many.clr",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.spnt.few.clr",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.spnt.many.clr",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dptk.few.clr",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dptk.many.clr",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dpnt.few.clr",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dpnt.many.clr",IA64_FORMAT_B3,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.sptk.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.sptk.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.spnt.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.spnt.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dptk.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dptk.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dpnt.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dpnt.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.sptk.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.sptk.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.spnt.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.spnt.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dptk.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dptk.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dpnt.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.cond.dpnt.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.sptk.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.sptk.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.spnt.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.spnt.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.dptk.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.dptk.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.dpnt.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.dpnt.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.sptk.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.sptk.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.spnt.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.spnt.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.dptk.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.dptk.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.dpnt.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ia.dpnt.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.sptk.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.sptk.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.spnt.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.spnt.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.dptk.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.dptk.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.dpnt.few",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.dpnt.many",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.sptk.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.sptk.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.spnt.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.spnt.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.dptk.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.dptk.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.dpnt.few.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.ret.dpnt.many.clr",IA64_FORMAT_B4,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.sptk.few",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.sptk.many",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.spnt.few",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.spnt.many",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dptk.few",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dptk.many",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dpnt.few",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dpnt.many",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.sptk.few.clr",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.sptk.many.clr",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.spnt.few.clr",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.spnt.many.clr",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dptk.few.clr",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dptk.many.clr",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dpnt.few.clr",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"br.call.dpnt.many.clr",IA64_FORMAT_B5,IA64_TROLE_BR,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.sptk",IA64_FORMAT_B6,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.sptk.imp",IA64_FORMAT_B6,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.loop",IA64_FORMAT_B6,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.loop.imp",IA64_FORMAT_B6,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.dptk",IA64_FORMAT_B6,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.dptk.imp",IA64_FORMAT_B6,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.exit",IA64_FORMAT_B6,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.exit.imp",IA64_FORMAT_B6,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.sptk",IA64_FORMAT_B7,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.sptk.imp",IA64_FORMAT_B7,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.dptk",IA64_FORMAT_B7,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.dptk.imp",IA64_FORMAT_B7,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.ret.sptk",IA64_FORMAT_B7,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.ret.sptk.imp",IA64_FORMAT_B7,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.ret.dptk",IA64_FORMAT_B7,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brp.ret.dptk.imp",IA64_FORMAT_B7,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"cover",IA64_FORMAT_B8,IA64_TROLE_BR,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"clrrrb",IA64_FORMAT_B8,IA64_TROLE_BR,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"clrrrb.pr",IA64_FORMAT_B8,IA64_TROLE_BR,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"rfi",IA64_FORMAT_B8,IA64_TROLE_BR,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"rfi.x",IA64_FORMAT_B8,IA64_TROLE_BR,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"bsw.0",IA64_FORMAT_B8,IA64_TROLE_BR,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"bsw.1",IA64_FORMAT_B8,IA64_TROLE_BR,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"epc",IA64_FORMAT_B8,IA64_TROLE_BR,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"break.b",IA64_FORMAT_B9,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"nop.b",IA64_FORMAT_B9,IA64_TROLE_BR,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.s.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.s.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.s.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.s.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.d.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.d.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.d.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fma.d.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpma.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpma.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpma.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpma.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.s.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.s.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.s.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.s.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.d.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.d.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.d.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fms.d.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpms.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpms.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpms.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpms.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.s.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.s.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.s.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.s.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.d.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.d.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.d.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fnma.d.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpnma.s0",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpnma.s1",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpnma.s2",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpnma.s3",IA64_FORMAT_F1,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xma.l",IA64_FORMAT_F2,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xma.h",IA64_FORMAT_F2,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"xma.hu",IA64_FORMAT_F2,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fselect",IA64_FORMAT_F3,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.eq.s0",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.eq.s1",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.eq.s2",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.eq.s3",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.lt.s0",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.lt.s1",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.lt.s2",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.lt.s3",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.le.s0",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.le.s1",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.le.s2",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.le.s3",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.unord.s0",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.unord.s1",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.unord.s2",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.unord.s3",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.eq.unc.s0",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.eq.unc.s1",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.eq.unc.s2",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.eq.unc.s3",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.lt.unc.s0",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.lt.unc.s1",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.lt.unc.s2",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.lt.unc.s3",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.le.unc.s0",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.le.unc.s1",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.le.unc.s2",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.le.unc.s3",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.unord.unc.s0",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.unord.unc.s1",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.unord.unc.s2",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcmp.unord.unc.s3",IA64_FORMAT_F4,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fclass.m",IA64_FORMAT_F5,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FCLASS},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fclass.m.unc",IA64_FORMAT_F5,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FCLASS},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"frcpa.s0",IA64_FORMAT_F6,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"frcpa.s1",IA64_FORMAT_F6,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"frcpa.s2",IA64_FORMAT_F6,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"frcpa.s3",IA64_FORMAT_F6,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fprcpa.s0",IA64_FORMAT_F6,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fprcpa.s1",IA64_FORMAT_F6,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fprcpa.s2",IA64_FORMAT_F6,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fprcpa.s3",IA64_FORMAT_F6,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"frsqrta.s0",IA64_FORMAT_F7,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"frsqrta.s1",IA64_FORMAT_F7,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"frsqrta.s2",IA64_FORMAT_F7,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"frsqrta.s3",IA64_FORMAT_F7,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fprsqrta.s0",IA64_FORMAT_F7,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fprsqrta.s1",IA64_FORMAT_F7,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fprsqrta.s2",IA64_FORMAT_F7,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fprsqrta.s3",IA64_FORMAT_F7,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_DST,IA64_OPTYPE_PREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmin.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmin.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmin.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmin.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmax.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmax.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmax.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmax.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"famin.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"famin.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"famin.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"famin.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"famax.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"famax.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"famax.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"famax.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmin.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmin.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmin.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmin.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmax.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmax.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmax.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmax.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpamin.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpamin.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpamin.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpamin.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpamax.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpamax.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpamax.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpamax.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.eq.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.eq.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.eq.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.eq.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.lt.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.lt.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.lt.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.lt.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.le.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.le.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.le.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.le.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.unord.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.unord.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.unord.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.unord.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.neq.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.neq.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.neq.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.neq.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.nlt.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.nlt.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.nlt.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.nlt.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.nle.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.nle.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.nle.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.nle.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.ord.s0",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.ord.s1",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.ord.s2",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcmp.ord.s3",IA64_FORMAT_F8,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmerge.s",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmerge.ns",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmerge.se",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmix.lr",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmix.r",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fmix.l",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fsxt.r",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fsxt.l",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpack",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fswap",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fswap.nl",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fswap.nr",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fand",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fandcm",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"for",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fxor",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmerge.s",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmerge.ns",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpmerge.se",IA64_FORMAT_F9,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fx.s0",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fx.s1",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fx.s2",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fx.s3",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fxu.s0",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fxu.s1",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fxu.s2",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fxu.s3",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fx.trunc.s0",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fx.trunc.s1",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fx.trunc.s2",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fx.trunc.s3",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fxu.trunc.s0",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fxu.trunc.s1",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fxu.trunc.s2",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.fxu.trunc.s3",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fx.s0",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fx.s1",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fx.s2",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fx.s3",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fxu.s0",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fxu.s1",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fxu.s2",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fxu.s3",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fx.trunc.s0",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fx.trunc.s1",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fx.trunc.s2",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fx.trunc.s3",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fxu.trunc.s0",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fxu.trunc.s1",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fxu.trunc.s2",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fpcvt.fxu.trunc.s3",IA64_FORMAT_F10,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fcvt.xf",IA64_FORMAT_F11,IA64_TROLE_FP,{IA64_OPROLE_DST,IA64_OPTYPE_FREG_F2_127},{IA64_OPROLE_SRC,IA64_OPTYPE_FREG},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fsetc.s0",IA64_FORMAT_F12,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fsetc.s1",IA64_FORMAT_F12,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fsetc.s2",IA64_FORMAT_F12,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fsetc.s3",IA64_FORMAT_F12,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fclrf.s0",IA64_FORMAT_F13,IA64_TROLE_FP,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fclrf.s1",IA64_FORMAT_F13,IA64_TROLE_FP,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fclrf.s2",IA64_FORMAT_F13,IA64_TROLE_FP,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fclrf.s3",IA64_FORMAT_F13,IA64_TROLE_FP,{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fchkf.s0",IA64_FORMAT_F14,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fchkf.s1",IA64_FORMAT_F14,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fchkf.s2",IA64_FORMAT_F14,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"fchkf.s3",IA64_FORMAT_F14,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"break.f",IA64_FORMAT_F15,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"nop.f",IA64_FORMAT_F15,IA64_TROLE_FP,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"break.x",IA64_FORMAT_X1,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"nop.x",IA64_FORMAT_X1,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"movl",IA64_FORMAT_X2,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_IREG_R1_127},{IA64_OPROLE_SRC,IA64_OPTYPE_UIMM},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.sptk.few",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.sptk.many",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.spnt.few",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.spnt.many",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.dptk.few",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.dptk.many",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.dpnt.few",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.dpnt.many",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.sptk.few.clr",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.sptk.many.clr",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.spnt.few.clr",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.spnt.many.clr",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.dptk.few.clr",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.dptk.many.clr",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.dpnt.few.clr",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.cond.dpnt.many.clr",IA64_FORMAT_X3,IA64_TROLE_LONG,{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.sptk.few",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.sptk.many",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.spnt.few",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.spnt.many",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.dptk.few",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.dptk.many",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.dpnt.few",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.dpnt.many",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.sptk.few.clr",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.sptk.many.clr",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.spnt.few.clr",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.spnt.many.clr",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.dptk.few.clr",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.dptk.many.clr",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.dpnt.few.clr",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
	{"brl.call.dpnt.many.clr",IA64_FORMAT_X4,IA64_TROLE_LONG,{IA64_OPROLE_DST,IA64_OPTYPE_BR},{IA64_OPROLE_SRC,IA64_OPTYPE_SSHIFT_REL},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE},{IA64_OPROLE_NONE,IA64_OPTYPE_NONE}},
};
