/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: layevent.cpp,v 1.4.12.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// system
#include <time.h>
// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "smiltype.h"
#include "hxcom.h"
#include "hxwin.h"
#include "hxxml.h"
#include "hxengin.h"
#include "hxcore.h"
#include "hxclsnk.h"
#include "hxgroup.h"
#include "hxvport.h"
#include "ihxpckts.h"
#include "hxsite2.h"
#include "hxerror.h"
#include "hxmmrkr.h" // smldoc.h   dependency
#include "hxinter.h" // smldoc.h   dependency
#include "hxstrutl.h"
// containers:
#include "hxstring.h"
#include "hxslist.h"
#include "hxmap.h"
// misc:
#include "hxwinver.h"
#include "hxtick.h"
// xmllib
#include "hxxmlprs.h"
// smlrendr
#include "smlelem.h"
#include "smlparse.h"
#if defined(HELIX_FEATURE_SMIL2_ANIMATION)
#include "animattr.h"
#include "animsand.h"
#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */
#include "evnthook.h"
#include "siteuser.h"
#include "layout.h"
#include "passivsw.h"
#include "smlrtype.h"
#include "smldoc.h"
#include "layevent.h"
// pndebug
#include "smlrmlog.h"
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static const char HX_THIS_FILE[] = __FILE__;
#endif

const char* const CSmilLayoutEvent::m_pszEventTypeName[] = {"ShowSite",
                                                            "HideSite",
                                                            "BeginTransition",
                                                            "EndTransition",
#if defined(HELIX_FEATURE_SMIL2_ANIMATION)
                                                      "Animate",
#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */
                                                      "Unknown"};

CSmilLayoutEvent::CSmilLayoutEvent(UINT16 uGroupIndex, 
                                   UINT32 ulEventTime,
                                   BOOL   bIgnorEvent) :
    m_uGroupIndex(uGroupIndex),
    m_ulEventTime(ulEventTime),
    m_bOnlyHideSite(FALSE),
    m_bIgnorEvent(bIgnorEvent)
{
}

CSmilLayoutEvent::~CSmilLayoutEvent()
{
}

const char* CSmilLayoutEvent::getEventTypeName()
{
    return (const char*) m_pszEventTypeName[m_type];
}

CSmilShowSiteEvent::CSmilShowSiteEvent(UINT16                 uGroupIndex,
                                       UINT32                 ulEventTime,
                                       IHXSite*              pSite,
                                       IHXSite*              pRegionSite,
                                       BOOL                   bShowSite,
                                       BOOL                   bIgnorEvent,
                                       CSmilDocumentRenderer* pDoc,
                                       const char*            pszMediaID,
                                       const char*            pszRegionID,
                                       ShowBackground         eShowBackground) :
    CSmilLayoutEvent(uGroupIndex, ulEventTime, bIgnorEvent),
    m_bShowSite(bShowSite),
    m_pRegionSite(pRegionSite),
    m_pSite(pSite),
    m_pDoc(pDoc),
    m_MediaID(pszMediaID),
    m_RegionID(pszRegionID),
    m_eShowBackground(eShowBackground),
    m_pErrorMessages(NULL)
{
    if (m_pSite)
    {
        m_pSite->AddRef();
    }
    if (m_pRegionSite)
    {
        m_pRegionSite->AddRef();
    }
    if (bShowSite)
    {
        m_type = eShowSite;
    }
    else
    {
        m_type = eHideSite;
    }
    if (m_pDoc)
    {
        m_pDoc->AddRef();
        m_pDoc->getErrorInterface(m_pErrorMessages);
    }
}

CSmilShowSiteEvent::~CSmilShowSiteEvent()
{
    HX_RELEASE(m_pRegionSite);
    HX_RELEASE(m_pSite);
    HX_RELEASE(m_pDoc);
    HX_RELEASE(m_pErrorMessages);
}

HX_RESULT CSmilShowSiteEvent::handleEvent(UINT32 ulTime)
{
    MLOG_EVENT(m_pErrorMessages, 
               "CSmilShowSiteEvent::handleEvent(%lu)\n\tm_type=%s\n\t"
               "m_ulEventTime=%lu\n\tm_uGroupIndex=%u\n\t"
               "m_bOnlyHideSite=%lu\n\tm_bIgnorEvent=%lu\n\tm_MediaID=%s\n\t"
               "m_RegionID=%s\n\ttick=%lu\n",
               ulTime, (m_type == eShowSite ? "SHOW" : "HIDE"), m_ulEventTime,
               m_uGroupIndex, m_bOnlyHideSite, m_bIgnorEvent,
               (const char*) m_MediaID, (const char*) m_RegionID,
               HX_GET_BETTERTICKCOUNT());
    HX_RESULT retVal = HXR_OK;

    if (!m_bIgnorEvent)
    {
        if (m_bShowSite)
        {
            // if showing, then first show the site before the region site
            // to prevent the flash when the region site is shown before the
            // site.
            CSmilDocumentRenderer::showSite(m_pSite, m_bShowSite);
            if (!m_bOnlyHideSite)
            {
                CSmilDocumentRenderer::showSite(m_pRegionSite, m_bShowSite);
            }
            // If we need to, change the media override parameters before
            // we show the site
            if (m_pDoc)
            {
                m_pDoc->processMediaRegionOverrides(m_RegionID, m_MediaID, TRUE, ulTime);
            }
        }
        else
        {
            if (m_pDoc)
            {
                m_pDoc->processMediaRegionOverrides(m_RegionID, m_MediaID, FALSE, ulTime);
            }
            // if hiding, then first hide the region so it's a one-step
            // process visually.
            if (!m_bOnlyHideSite &&
                m_eShowBackground == ShowBackgroundWhenActive)
            {
                CSmilDocumentRenderer::showSite(m_pRegionSite, m_bShowSite);
            }
            CSmilDocumentRenderer::showSite(m_pSite, m_bShowSite);
        }
    }
    else
    {
        // We won't show or hide any sites, but we still
        // need to execute the media region overrides
        if (m_pDoc)
        {
            m_pDoc->processMediaRegionOverrides(m_RegionID, m_MediaID, m_bShowSite, ulTime);
        }
    }

    return retVal;
}

IHXSite* CSmilShowSiteEvent::getRegionSite()
{
    return m_pRegionSite;
}

IHXSite* CSmilShowSiteEvent::getRendererSite()
{
    return m_pSite;
}

BOOL CSmilShowSiteEvent::getShowSite()
{
    return m_bShowSite;
}

const char* CSmilShowSiteEvent::getMediaID()
{
    return (const char*) m_MediaID;
}

const char* CSmilShowSiteEvent::getRegionID()
{
    return (const char*) m_RegionID;
}

#if defined(HELIX_FEATURE_SMIL2_TRANSITIONS)

CSmilTransitionEvent::CSmilTransitionEvent(UINT32                 ulEventTime,
                                           SMILPlayToAssoc*       pAssoc,
                                           SMILSiteInfo*          pSiteInfo,
                                           BOOL                   bBeginTransition,
                                           CSmilDocumentRenderer* pRenderer) :
    CSmilLayoutEvent(pAssoc->m_uGroupIndex, ulEventTime, FALSE)
{
    m_pDocRenderer = pRenderer;
    m_pPlayToAssoc = pAssoc;
    m_pSiteInfo    = pSiteInfo;
    m_pSite        = NULL;
    if (m_pDocRenderer)
    {
        m_pDocRenderer->AddRef();
    }
    if (bBeginTransition)
    {
        m_type = eBeginTransition;
    }
    else
    {
        m_type = eEndTransition;
    }
}

CSmilTransitionEvent::CSmilTransitionEvent(UINT32                 ulEventTime,
                                           SMILPlayToAssoc*       pAssoc,
                                           IHXSite*              pSite,
                                           BOOL                   bBeginTransition,
                                           CSmilDocumentRenderer* pRenderer) :
    CSmilLayoutEvent(pAssoc->m_uGroupIndex, ulEventTime, FALSE)
{
    m_pDocRenderer = pRenderer;
    m_pPlayToAssoc = pAssoc;
    m_pSiteInfo    = NULL;
    m_pSite        = pSite;
    if (m_pDocRenderer)
    {
        m_pDocRenderer->AddRef();
    }
    if (m_pSite)
    {
        m_pSite->AddRef();
    }
    if (bBeginTransition)
    {
        m_type = eBeginTransition;
    }
    else
    {
        m_type = eEndTransition;
    }
}

CSmilTransitionEvent::~CSmilTransitionEvent()
{
    HX_RELEASE(m_pDocRenderer);
    HX_RELEASE(m_pSite);
}

HX_RESULT CSmilTransitionEvent::handleEvent(UINT32 ulTime)
{
    MLOG_EVENT(NULL,
               "CSmilTransitionEvent::handleEvent(%lu)\n\t"
               "m_ulEventTime=%lu\n\tm_uGroupIndex=%u\n\ttick=%lu\n",
               ulTime, m_ulEventTime, m_uGroupIndex,
               HX_GET_BETTERTICKCOUNT());
    HX_RESULT retVal = HXR_FAIL;

    if (m_pDocRenderer && m_pPlayToAssoc)
    {
        CSmilTransitionInfo* pInfo = NULL;
        if (m_type == eBeginTransition)
        {
            pInfo = m_pDocRenderer->getTransition(m_pPlayToAssoc->m_beginTransition);
        }
        else
        {
            pInfo = m_pDocRenderer->getTransition(m_pPlayToAssoc->m_endTransition);
        }
        if (pInfo)
        {
            if (m_pSiteInfo || m_pSite)
            {
                retVal = m_pDocRenderer->startTransition(m_ulEventTime, pInfo, m_pSiteInfo,
                                                         m_pPlayToAssoc, m_pSite, ulTime,
                                                         m_type == eBeginTransition);
            }
        }
    }

    return retVal;
}

IHXSite* CSmilTransitionEvent::getRegionSite()
{
    return m_pSiteInfo ? m_pSiteInfo->m_pRegionSite   : NULL;
}

IHXSite* CSmilTransitionEvent::getRendererSite()
{
    return m_pSiteInfo ? m_pSiteInfo->m_pRendererSite : m_pSite;
}

#endif /* #if defined(HELIX_FEATURE_SMIL2_TRANSITIONS) */

#if defined(HELIX_FEATURE_SMIL2_ANIMATION)

CSmilAnimateEvent::CSmilAnimateEvent(UINT16                 uGroupIndex,
                                     UINT32                 ulEventTime,
                                     BOOL                   bIgnorEvent,
                                     CSmilAnimateElement*   pElement,
                                     CSmilDocumentRenderer* pDocRenderer,
                                     CSmilParser*           pParser)
    : CSmilLayoutEvent(uGroupIndex, ulEventTime, bIgnorEvent)
{
    m_type             = eAnimate;
    m_pElement         = pElement;
    m_pDocRenderer     = pDocRenderer;
    m_pSmilParser      = pParser;
    m_bEventBasedBegin = (pElement ? pElement->hasEventBasedBeginTime() : FALSE);
    m_bHandled         = FALSE;
}

CSmilAnimateEvent::CSmilAnimateEvent(const CSmilAnimateEvent& rEvent)
    : CSmilLayoutEvent(rEvent.m_pElement->m_pNode->m_nGroup,
                       rEvent.m_ulEventTime,
                       rEvent.m_bIgnorEvent)
{
    m_type             = eAnimate;
    m_pElement         = rEvent.m_pElement;
    m_pDocRenderer     = rEvent.m_pDocRenderer;
    m_pSmilParser      = rEvent.m_pSmilParser;
    m_bEventBasedBegin = (m_pElement ? m_pElement->hasEventBasedBeginTime() : FALSE);
}

CSmilAnimateEvent::~CSmilAnimateEvent()
{
}

HX_RESULT CSmilAnimateEvent::handleEvent(UINT32 ulTime)
{
    MLOG_EVENT(NULL,
               "CSmilAnimateEvent::handleEvent(%lu)\n\tm_ulEventTime=%lu\n\t"
               "m_uGroupIndex=%u\n\tid=%s\n\ttargetElement=%s\n\t"
               "attributeName=%lu\n\ttick=%lu\n",
               ulTime, m_ulEventTime, m_uGroupIndex,
               (m_pElement && m_pElement->m_pNode ?
                (const char*) m_pElement->m_pNode->m_id : "NULL"),
               (m_pElement && m_pElement->m_pTargetElementID ?
                (const char*) *m_pElement->m_pTargetElementID : "NULL"),
               (m_pElement ? m_pElement->m_ucAttributeName : 0),
               HX_GET_BETTERTICKCOUNT());
    HX_RESULT retVal = HXR_OK;

    if (m_pElement && m_pElement->m_pNode &&
        !m_pElement->m_bCancelAnimation)
    {
        // Create the sandwich layer. If this is an
        // animateMotion, then we need to create two
        // layers, otherwise one
        if (m_pElement->m_pNode->m_tag == SMILAnimateMotion)
        {
            CAnimationSandwichLayer* pLayerLeft =
                new CAnimationSandwichLayer(m_pElement, kAttrNameLeft, m_pSmilParser);
            if (pLayerLeft)
            {
                CAnimationSandwichLayer* pLayerTop =
                    new CAnimationSandwichLayer(m_pElement, kAttrNameTop, m_pSmilParser);
                if (pLayerTop)
                {
                    retVal = m_pDocRenderer->addAnimation(pLayerLeft);
                    if (SUCCEEDED(retVal))
                    {
                        retVal = m_pDocRenderer->addAnimation(pLayerTop);
                    }
                }
                else
                {
                    retVal = HXR_OUTOFMEMORY;
                }
            }
            else
            {
                retVal = HXR_OUTOFMEMORY;
            }
        }
        else
        {
            CAnimationSandwichLayer* pLayer =
                new CAnimationSandwichLayer(m_pElement, m_pElement->m_ucAttributeName, m_pSmilParser);
            if (pLayer)
            {
                retVal = m_pDocRenderer->addAnimation(pLayer);
            }
            else
            {
                retVal = HXR_OUTOFMEMORY;
            }
        }
    }

    return retVal;
}

IHXSite* CSmilAnimateEvent::getRegionSite()
{
    return NULL;
}

IHXSite* CSmilAnimateEvent::getRendererSite()
{
    return NULL;
}

BOOL CSmilAnimateEvent::isSameElement(CSmilAnimateElement* pAnim)
{
    BOOL bRet = FALSE;

    if (pAnim && m_pElement &&
        pAnim == m_pElement)
    {
        bRet = TRUE;
    }

    return bRet;
}

#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */
