/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OGG VORBIS PROJECT SOURCE CODE.         *
 *                                                                  *
 * THE OGG VORBIS PROJECT SOURCE CODE IS (C) COPYRIGHT 1994-2001    *
 * by the XIPHOPHORUS Company http://www.xiph.org/                  *

 ********************************************************************

 function: headers of the file format plugin for RealSystem

********************************************************************/
/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: oggfformat.h,v 1.1.2.5 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef __OGGFFORMAT_H__
#define __OGGFFORMAT_H__

#include "hlxclib/string.h"
#include "vorbis/vorbisfile.h"
#include "ogg_page_reader.h"

#include "stream_info_strategy.h"
#include "find_eof_strategy.h"
#include "end_time_strategy.h"
#include "find_gend_strategy.h"
#include "seek_strategy.h"
#include "collect_headers_strategy.h"

#include "file_info.h"
#include "stream_hdlr.h"

#include "hxslist.h"

#define PLUGIN_VERSION_NUM 0
#define DESCRIPTION "Ogg File Format Plugin"
#define COPYRIGHT "(c) 2001 Xiphophorus, All rights reserved."
#define MORE_INFO_URL "http://www.xiph.org"
#define FILE_MIME_TYPES {"application/x-ogg", "application/ogg", NULL}
#define FILE_EXTENSIONS {"ogg", NULL}
#define FILE_OPEN_NAMES {"Ogg (*.ogg)", NULL}
#define STREAM_MIME_TYPE "application/ogg"
#define READ_LENGTH 4096

typedef enum
{
    Start,
    InitPending,
    Ready,
    GetFirstStreamInfo,
    FindLastPage,
    FindLastGroupEndTime,
    FindGroupEndPage,
    FindGroupEndTime,
    GetNextStreamInfo,
    SeekBackToLastCachedPage,
    GetPacketReadPending,
    GetNextLiveStreamInfo,
    FindSeekPointOffset,
    CollectStreamHeaders,
    Error
} PluginState;


class COggFileFormat :  public IHXFileFormatObject,
                        public IHXOggPageReaderResponse,
                        public IHXPlugin
{
public:

    COggFileFormat(void);

    // IHXFileFormatObject interface
    STDMETHOD(GetFileFormatInfo)
        (THIS_
         REF(const char **)pFileMimeTypes,
         REF(const char **)pFileExtensions,
         REF(const char **)pFileOpenNames
            );

    STDMETHOD(InitFileFormat)
        (THIS_
         IHXRequest *pRequest,
         IHXFormatResponse *pFormatResponse,
         IHXFileObject *pFileObject
            );

    STDMETHOD(GetFileHeader) (THIS);
    STDMETHOD(GetStreamHeader) (THIS_ UINT16 streamNo);
    STDMETHOD(GetPacket) (THIS_ UINT16 streamNo);
    STDMETHOD(Seek) (THIS_ UINT32 requestedTime);
    STDMETHOD(Close) (THIS);

    /*
     * IHXOggPageReaderResponse methods
     */
    STDMETHOD(PageReaderInitDone) (THIS_ HX_RESULT status);
    STDMETHOD(ReadNextPageDone) (THIS_ HX_RESULT status,
                                 ULONG32 ulFileOffset,
                                 UINT32 ulPageSize,
                                 ogg_page* pPage);

    // IHXPlugin Interface
    STDMETHOD(GetPluginInfo)
        (THIS_
         REF(BOOL) bLoadMultiple,
         REF(const char *) pDescription,
         REF(const char *) pCopyright,
         REF(const char *) pMoreInfoURL,
         REF(UINT32) versionNumber
            );

    STDMETHOD(InitPlugin) (THIS_ IUnknown *pRMACore);

    // IUnknown COM Interface
    STDMETHOD(QueryInterface) (THIS_ REFIID ID, void **ppInterfaceObj);
    STDMETHOD_(UINT32, AddRef) (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

private:
    // private class variables
    INT32 m_RefCount;   // Objects reference count
    IHXFormatResponse* m_pResponse;       // Reports status to RMA core
    COggPageReader* m_pPageReader;
    PluginState m_State;        // Status used for async calls

    BOOL* m_pGetPacketPending; // Pending GetPacket() Booleans
    BOOL m_bInDispatchPendingRequest;

    COggPageStrategy* m_pCurrentStrategy;
    COggStreamInfoStrategy m_streamInfoStrategy;
    COggFindEOFStrategy m_findEOFStrategy;
    COggGroupEndTimeStrategy m_groupEndTimeStrategy;
    COggFindGroupEndStrategy m_findGroupEndStrategy;
    COggSeekStrategy m_seekStrategy;
    COggCollectHeadersStrategy m_collectHeaderStrategy;

    COggFileInfo m_fileInfo;
    COggStreamHandler m_streamHdlr;

    ULONG32 m_ulLastCachedPageOffset;
    CHXSimpleList m_pageCache;
    
    BOOL m_bIsLive;
    UINT32 m_uCurrentGroup;
    COggTimestamp m_liveNextGroupStartTime;

    // private static class variables
    static const char *zm_pDescription;
    static const char *zm_pCopyright;
    static const char *zm_pMoreInfoURL;
    static const char *zm_pFileMimeTypes[];
    static const char *zm_pFileExtensions[];
    static const char *zm_pFileOpenNames[];    

    // private class methods
    ~COggFileFormat(void);
    void changeState(PluginState newState);

    HX_RESULT handleGetFirstStreamInfoDone();
    HX_RESULT handleFindLastPageDone();
    HX_RESULT handleFindSingleGroupEndTimeDone();
    HX_RESULT handleFindLastGroupEndTimeDone();
    HX_RESULT handleFindGroupEndPageDone();
    HX_RESULT handleFindGroupEndTimeDone();
    HX_RESULT handleGetNextStreamInfoDone();
    HX_RESULT handleGetNextLiveStreamInfoDone();
    HX_RESULT handleFindSeekPointOffsetDone();
    HX_RESULT handleCollectHeadersDone();
    HX_RESULT handleSeekBackToLastCachedPage();
    HX_RESULT handlePacketReadPending(HX_RESULT status,
                                      ULONG32 ulFileOffset,
                                      UINT32 uPageSize,
                                      ogg_page* pPage);


    HX_RESULT addGroupToFileInfo(ULONG32 ulLastPageOffset);

    HX_RESULT getStreamTypeCountFromFileInfo(UINT16& uNumAudioStreams,
                                             UINT16& uNumVideoStreams) const;
    HX_RESULT getStreamTypeCountFromStreamInfo(UINT16& uNumAudioStreams,
                                               UINT16& uNumVideoStreams) const;

    HX_RESULT setupStreamHandlerFromGroupInfo(UINT32 uGroupIndex);
    HX_RESULT setupStreamHandlerFromStreamInfo();

    HX_RESULT handleFileGroupChange(ogg_page* pPage);

    HX_RESULT createAndSendFileHeader();

    HX_RESULT dispatchPendingRequests();

    HX_RESULT cachePage(ogg_page* pPage);
    void flushPageCache();
    HX_RESULT sendCachedPagesToStreamHandler();
};

#endif  // __OGGFFORMAT_H__
