.\" Copyright (c) 1993, 2000 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH databases 5 "January 2000" "GNATS @VERSION@" "GNATS configuration files"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
databases \- the known set of GNATS databases
.SH DESCRIPTION
\fBdatabases\fR contains a list of database names and their associated
parameters.  It it used by the GNATS clients to determine the location
of a database referred to by name.  It is located by default in
@PREFIX@/share/gnats/databases.
.P
\fBdatabases\fR consists of one or more lines containing at least
three colon-separated fields:
.P
.RS
default\:The default database\:/the/directory
.RE
.P
Lines beginning with a # are ignored.
.P
The first field is the database name, which is the string passed to
the --database option or specified via the GNATSDB environment
variable.  The second field is a short human-readable description of
the database contents.  The final field is the directory where the
database contents are kept.
.P
It may also contain one or two additional fields describing the
network location of the database:
.P
.RS
network\:Network db\:\:gnats.foo.com\:1234
.RE
.P
The last two options describe the hostname and port of the server where
\fBgnatsd\fR is running.
.P
Both a directory and a server/port may be present.  In this case
\fBgnatsd\fR uses the directory field to determine where the database
contents are located, while the clients use the server/port
information to connect to \fBgnatsd\fR.
.P
The database name \fBdefault\fR is special; this is the entry used if
no database name is specified via a --database option or the
\fBGNATSDB\fR environment variable.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR gnats (7),
.BR send-pr (1),
.BR edit-pr (1),
.BR delete-pr (8),
.BR query-pr (1),
.BR file-pr (8),
.BR queue-pr (8),
.BR gen-index (8),
.BR mkcat (8),
.BR mkdb (8).
.SH COPYING
Copyright (c) 1993, 2000 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
