/***************************************************************************
 *   Copyright (c) Jürgen Riegel          (juergen.riegel@web.de) 2007     *
 *                                                                         *
 *   This file is part of the FreeCAD CAx development system.              *
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Library General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2 of the License, or (at your option) any later version.      *
 *                                                                         *
 *   This library  is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Library General Public License for more details.                  *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this library; see the file COPYING.LIB. If not,    *
 *   write to the Free Software Foundation, Inc., 59 Temple Place,         *
 *   Suite 330, Boston, MA  02111-1307, USA                                *
 *                                                                         *
 ***************************************************************************/


#include "PreCompiled.h"
#include "Writer.h"
#include "Persistence.h"

// inclution of the generated files (generated By PersitancePy.xml)
#include "PersistencePy.h"
#include "PersistencePy.cpp"

using namespace Base;

// returns a string which represent the object e.g. when printed in python
std::string PersistencePy::representation(void) const
{
    return std::string("<persistence object>");
}


Py::String PersistencePy::getContent(void) const
{
    Base::StringWriter writer;
	// force all objects to write pure XML without files
	writer.setForceXML(true);
    getPersistencePtr()->Save(writer);

    return  Py::String (writer.getString());
}

void  PersistencePy::setContent(Py::String /*arg*/)
{
    throw Py::AttributeError(std::string("Attribute 'Content' of object 'Persistence' is read-only"));
}

Py::Int PersistencePy::getMemSize(void) const
{
    return Py::Int((long)getPersistencePtr()->getMemSize());
}


PyObject *PersistencePy::getCustomAttributes(const char*) const
{
    return 0;
}

int PersistencePy::setCustomAttributes(const char*,PyObject*)
{
    return 0; 
}

