'\" t
.\" ** The above line should force tbl to be used as a preprocessor **
.\"
.\" Manual page in man(7) format with tbl(1) macros for fetchmail
.\"
.\" For license terms, see the file COPYING in this directory.
.\"
.TH fetchmail 1 "fetchmail 6.3.6" "fetchmail" "fetchmail reference manual"
.SH NAME
fetchmail \- fetch mail from a POP, IMAP, ETRN, or ODMR-capable server

.SH SYNOPSIS
\fBfetchmail\fR [\fIoption...\fR] [\fImailserver...\fR]
.br
\fBfetchmailconf\fR

.SH DESCRIPTION
.I fetchmail
is a mail-retrieval and forwarding utility; it fetches mail from
remote mailservers and forwards it to your local (client) machine's
delivery system.  You can then handle the retrieved mail using normal
mail user agents such as \fImutt\fR(1), \fIelm\fR(1) or \fIMail\fR(1).
The \fIfetchmail\fR utility can be run in a daemon mode to repeatedly
poll one or more systems at a specified interval.
.PP
The
.I fetchmail
program can gather mail from servers supporting any of the common
mail-retrieval protocols: POP2 (legacy, to be removed from future
release), POP3, IMAP2bis, IMAP4, and IMAP4rev1.
It can also use the ESMTP ETRN extension and ODMR.  (The RFCs describing all
these protocols are listed at the end of this manual page.)
.PP
While
.I fetchmail
is primarily intended to be used over on-demand TCP/IP links (such as
SLIP or PPP connections), it may also be useful as a message transfer
agent for sites which refuse for security reasons to permit
(sender-initiated) SMTP transactions with sendmail.
.PP
If
.I fetchmail
is used with a POP or an IMAP server, it has two fundamental modes of
operation for each user account from which it retrieves mail:
\fIsingledrop\fR- and \fImultidrop\fR-mode.  In singledrop-mode,
.I fetchmail
assumes that all messages in the user's account are intended for a single
recipient.  An individual mail message will not be inspected for recipient
information, rather, the identity of the recipient will either default to
the local user currently executing \fIfetchmail\fR,
or else will need to be explicitly specified in the configuration file.
Singledrop-mode is used when the fetchmailrc configuration contains at
most a single local user specification for a given server account.
.PP
With multidrop-mode,
.I fetchmail
is not able to assume that there is only a single recipient, but rather
that the mail server account actually contains mail intended for any
number of different recipients.  Therefore,
.I fetchmail
must attempt to deduce the proper "envelope recipient" from the mail
headers of each message.  In this mode of operation,
.I fetchmail
almost resembles an MTA, however it is important to note that neither
the POP nor IMAP protocols were intended for use in this fashion, and
hence envelope information is often not directly available.  Instead,
.I fetchmail
must resort to a process of informed guess-work in an attempt to
discover the true envelope recipient of a message, unless the ISP stores
the envelope information in some header (not all do).  Even if this
information is present in the headers, the process can
be error-prone and is dependent upon the specific mail server used
for mail retrieval.  Multidrop-mode is used when more than one local
user is specified for a particular server account in the configuration
file.  Note that the forgoing discussion of singledrop- and
multidrop-modes does not apply to the ESMTP ETRN or ODMR retrieval
methods, since they are based upon the SMTP protocol which
specifically provides the envelope recipient to \fIfetchmail\fR.
.PP
As each message is retrieved, \fIfetchmail\fR normally delivers it via SMTP to
port 25 on the machine it is running on (localhost), just as though it
were being passed in over a normal TCP/IP link.  \fIfetchmail\fR provides
the SMTP server with an envelope recipient derived in the manner described
previously.  The mail will then be
delivered locally via your system's MDA (Mail Delivery Agent, usually
\fIsendmail\fR(8) but your system may use a different one such
as \fIsmail\fR, \fImmdf\fR, \fIexim\fR, \fIpostfix\fR, or \fIqmail\fR).  All the
delivery-control mechanisms (such as \fI.forward\fR files) normally
available through your system MDA and local delivery agents will
therefore work automatically.
.PP
If no port 25 listener is available, but your fetchmail configuration
was told about a reliable local MDA, it will use that MDA for local
delivery instead.
.PP
If the program
.I fetchmailconf
is available, it will assist you in setting up and editing a
fetchmailrc configuration.  It runs under the X window system and
requires that the language Python and the Tk toolkit be present on your
system.  If you are first setting up fetchmail for single-user mode, it
is recommended that you use Novice mode.  Expert mode provides complete
control of fetchmail configuration, including the multidrop features.
In either case, the 'Autoprobe' button will tell you the most capable
protocol a given mailserver supports, and warn you of potential problems
with that server.

.SH GENERAL OPERATION
The behavior of
.I fetchmail
is controlled by command-line options and a run control file,
.IR ~/.fetchmailrc\fR ,
the syntax of which we describe in a later section (this file is what
the \fIfetchmailconf\fR program edits).  Command-line options override
.I ~/.fetchmailrc
declarations.
.PP
Each server name that you specify following the options on the
command line will be queried.  If you don't specify any servers
on the command line, each 'poll' entry in your
.I ~/.fetchmailrc
file will be queried.
.PP
To facilitate the use of
.I fetchmail
in scripts and pipelines, it returns an appropriate exit code upon
termination -- see EXIT CODES below.
.PP
The following options modify the behavior of \fIfetchmail\fR.  It is
seldom necessary to specify any of these once you have a
working \fI.fetchmailrc\fR file set up.
.PP
Almost all options have a corresponding keyword which can be used to
declare them in a
.I .fetchmailrc
file.
.PP
Some special options are not covered here, but are documented instead
in sections on AUTHENTICATION and DAEMON MODE which follow.
.SS General Options
.TP
.B \-V | \-\-version
Displays the version information for your copy of
.IR fetchmail .
No mail fetch is performed.
Instead, for each server specified, all the option information
that would be computed if
.I fetchmail
were connecting to that server is displayed.  Any non-printables in
passwords or other string names are shown as backslashed C-like
escape sequences.  This option is useful for verifying that your
options are set the way you want them.
.TP
.B \-c | \-\-check
Return a status code to indicate whether there is mail waiting,
without actually fetching or deleting mail (see EXIT CODES below).
This option turns off daemon mode (in which it would be useless).  It
doesn't play well with queries to multiple sites, and doesn't work
with ETRN or ODMR.  It will return a false positive if you leave read but
undeleted mail in your server mailbox and your fetch protocol can't
tell kept messages from new ones.  This means it will work with IMAP,
not work with POP2, and may occasionally flake out under POP3.
.TP
.B \-s | \-\-silent
Silent mode.  Suppresses all progress/status messages that are
normally echoed to standard output during a fetch (but does not
suppress actual error messages).  The \-\-verbose option overrides this.
.TP
.B \-v | \-\-verbose
Verbose mode.  All control messages passed between
.I fetchmail
and the mailserver are echoed to stdout.  Overrides \-\-silent.
Doubling this option (\-v \-v) causes extra diagnostic information
to be printed.
.SS Disposal Options
.TP
.B \-a | \-\-all | (since v6.3.3) \-\-fetchall
(Keyword: fetchall, since v3.0)
Retrieve both old (seen) and new messages from the mailserver.  The
default is to fetch only messages the server has not marked seen.
Under POP3, this option also forces the use of RETR rather than TOP.
Note that POP2 retrieval behaves as though \-\-all is always on (see
RETRIEVAL FAILURE MODES below) and this option does not work with ETRN
or ODMR.  While the \-a and \-\-all command-line and fetchall rcfile
options have been supported for a long time, the \-\-fetchall
command-line option was added in v6.3.3.
.TP
.B \-k | \-\-keep
(Keyword: keep)
Keep retrieved messages on the remote mailserver.  Normally, messages
are deleted from the folder on the mailserver after they have been retrieved.
Specifying the \fBkeep\fR option causes retrieved messages to remain in
your folder on the mailserver.  This option does not work with ETRN or
ODMR. If used with POP3, it is recommended to also specify the \-\-uidl
option or uidl keyword.
.TP
.B \-K | \-\-nokeep
(Keyword: nokeep)
Delete retrieved messages from the remote mailserver.  This
option forces retrieved mail to be deleted.  It may be useful if
you have specified a default of \fBkeep\fR in your
\&\fI.fetchmailrc\fR.  This option is forced on with ETRN and ODMR.
.TP
.B \-F | \-\-flush
POP3/IMAP only.  This is a dangerous option and can cause mail loss when
used improperly. It deletes old (seen) messages from the mailserver
before retrieving new messages.  \fBWarning:\fR This can cause mail loss if
you check your mail with other clients than fetchmail, and cause
fetchmail to delete a message it had never fetched before.  It can also
cause mail loss if the mail server marks the message seen after
retrieval (IMAP2 servers). You should probably not use this option in your
configuration file. If you use it with POP3, you must use the 'uidl'
option. What you probably want is the default setting: if you don't
specify '\-k', then fetchmail will automatically delete messages after
successful delivery.
.TP
.B \-\-limitflush
POP3/IMAP only, since version 6.3.0.  Delete oversized messages from the
mailserver before retrieving new messages. The size limit should be
separately specified with the \-\-limit option.  This option does not
work with ETRN or ODMR.
.SS Protocol and Query Options
.TP
.B \-p <proto> | \-\-proto <proto> | \-\-protocol <proto>
(Keyword: proto[col])
Specify the protocol to use when communicating with the remote
mailserver.  If no protocol is specified, the default is AUTO.
.I proto
may be one of the following:
.RS
.IP AUTO
Tries IMAP, POP3, and POP2 (skipping any of these for which support
has not been compiled in).
.IP POP2
Post Office Protocol 2 (legacy, to be removed from future release)
.IP POP3
Post Office Protocol 3
.IP APOP
Use POP3 with old-fashioned MD5-challenge authentication.
.IP RPOP
Use POP3 with RPOP authentication.
.IP KPOP
Use POP3 with Kerberos V4 authentication on port 1109.
.IP SDPS
Use POP3 with Demon Internet's SDPS extensions.
.IP IMAP
IMAP2bis, IMAP4, or IMAP4rev1 (\fIfetchmail\fR automatically detects their capabilities).
.IP ETRN
Use the ESMTP ETRN option.
.IP ODMR
Use the the On-Demand Mail Relay ESMTP profile.
.RE
.P
All these alternatives work in basically the same way (communicating
with standard server daemons to fetch mail already delivered to a
mailbox on the server) except ETRN and ODMR.  The ETRN mode
allows you to ask a compliant ESMTP server (such as BSD sendmail at
release 8.8.0 or higher) to immediately open a sender-SMTP connection
to your client machine and begin forwarding any items addressed to
your client machine in the server's queue of undelivered mail.   The
ODMR mode requires an ODMR-capable server and works similarly to
ETRN, except that it does not require the client machine to have
a static DNS.
.TP
.B \-U | \-\-uidl
(Keyword: uidl)
Force UIDL use (effective only with POP3).  Force client-side tracking
of 'newness' of messages (UIDL stands for "unique ID listing" and is
described in RFC1939).  Use with 'keep' to use a mailbox as a baby
news drop for a group of users. The fact that seen messages are skipped
is logged, unless error logging is done through syslog while running in
daemon mode.  Note that fetchmail may automatically enable this option
depending on upstream server capabilities.  Note also that this option
may be removed and forced enabled in a future fetchmail version. See
also: \-\-idfile.
.TP
.B \-\-idle (since 6.3.3)
(Keyword: idle, since before 6.0.0)
Enable IDLE use (effective only with IMAP). Note that this works with
only one folder at a given time.  While the idle rcfile keyword had been
supported for a long time, the \-\-idle command-line option was added in
version 6.3.3. IDLE use means that fetchmail tells the IMAP server to
send notice of new messages, so they can be retrieved sooner than would
be possible with regular polls.
.TP
.B \-P <portnumber> | \-\-service <servicename>
(Keyword: service) Since version 6.3.0.
The service option permits you to specify a service name to connect to.
You can specify a decimal port number here, if your services database
lacks the required service-port assignments. See the FAQ item R12 and
the \-\-ssl documentation for details. This replaces the older \-\-port
option.
.TP
.B \-\-port <portnumber>
(Keyword: port)
Obsolete version of \-\-service that does not take service names.
.B Note:
this option may be removed from a future version.
.TP
.B \-\-principal <principal>
(Keyword: principal)
The principal option permits you to specify a service principal for
mutual authentication.  This is applicable to POP3 or IMAP with Kerberos
authentication.
.TP
.B \-t <seconds> | \-\-timeout <seconds>
(Keyword: timeout)
The timeout option allows you to set a server-nonresponse
timeout in seconds.  If a mailserver does not send a greeting message
or respond to commands for the given number of seconds,
\fIfetchmail\fR will hang up on it.  Without such a timeout
\fIfetchmail\fR might hang up indefinitely trying to fetch mail from a
down host.  This would be particularly annoying for a \fIfetchmail\fR
running in background.  There is a default timeout which fetchmail\~\-V
will report.  If a given connection receives too many timeouts in
succession, fetchmail will consider it wedged and stop retrying,
the calling user will be notified by email if this happens.
.TP
.B \-\-plugin <command>
(Keyword: plugin) The plugin option allows you to use an external
program to establish the TCP connection.  This is useful if you want
to use socks, SSL, ssh, or need some special firewalling setup.  The
program will be looked up in $PATH and can optionally be passed the
hostname and port as arguments using "%h" and "%p" respectively (note
that the interpolation logic is rather primitive, and these token must
be bounded by whitespace or beginning of string or end of string).
Fetchmail will write to the plugin's stdin and read from the plugin's
stdout.
.TP
.B \-\-plugout <command>
(Keyword: plugout)
Identical to the plugin option above, but this one is used for the SMTP
connections (which will probably not need it, so it has been separated
from plugin).
.TP
.B \-r <name> | \-\-folder <name>
(Keyword: folder[s])
Causes a specified non-default mail folder on the mailserver (or
comma-separated list of folders) to be retrieved.  The syntax of the
folder name is server-dependent.  This option is not available under
POP3, ETRN, or ODMR.
.TP
.B \-\-tracepolls
(Keyword: tracepolls)
Tell fetchmail to poll trace information in the form 'polling %s
account %s' and 'folder %s' to the Received line it generates,
where the %s parts are replaced by the user's remote name, the poll
label, and the folder (mailbox) where available (the Received header
also normally includes the server's true name).  This can be used to
facilitate mail filtering based on the account it is being received
from. The folder information is written only since version 6.3.4.
.TP
.B \-\-ssl
(Keyword: ssl)
Causes the connection to the mail server to be encrypted via SSL.  Connect
to the server using the specified base protocol over a connection secured
by SSL. This option defeats TLS negotiation. Use \-\-sslcertck to
validate the certificates presented by the server.
.sp
Note that fetchmail may still try to negotiate TLS even if this option
is not given. You can use the \-\-sslproto option to defeat this
behavior or tell fetchmail to negotiate a particular SSL protocol.
.sp
If no port is specified, the connection is attempted to the well known
port of the SSL version of the base protocol.  This is generally a
different port than the port used by the base protocol.  For IMAP, this
is port 143 for the clear protocol and port 993 for the SSL secured
protocol, for POP3, it is port 110 for the clear text and port 995 for
the encrypted variant.
.sp
If your system lacks the corresponding entries from /etc/services, see
the \-\-service option and specify the numeric port number as given in
the previous paragraph (unless your ISP had directed you to different
ports, which is uncommon however).
.TP
.B \-\-sslcert <name>
(Keyword: sslcert)
Specifies the file name of the client side public SSL certificate.  Some
SSL encrypted servers may require client side keys and certificates for
authentication.  In most cases, this is optional.  This specifies
the location of the public key certificate to be presented to the server
at the time the SSL session is established.  It is not required (but may
be provided) if the server does not require it.  Some servers may
require it, some servers may request it but not require it, and some
servers may not request it at all.  It may be the same file
as the private key (combined key and certificate file) but this is not
recommended.
.sp
.B NOTE:
If you use client authentication, the user name is fetched from the
certificate's CommonName and overrides the name set with \-\-user.
.TP
.B \-\-sslkey <name>
(Keyword: sslkey)
Specifies the file name of the client side private SSL key.  Some SSL
encrypted servers may require client side keys and certificates for
authentication.  In most cases, this is optional.  This specifies
the location of the private key used to sign transactions with the server
at the time the SSL session is established.  It is not required (but may
be provided) if the server does not require it.  Some servers may
require it, some servers may request it but not require it, and some
servers may not request it at all.  It may be the same file
as the public key (combined key and certificate file) but this is not
recommended.  If a password is required to unlock the key, it will be
prompted for at the time just prior to establishing the session to the
server.  This can cause some complications in daemon mode.
.TP
.B \-\-sslproto <name>
(Keyword: sslproto)
Forces an SSL or TLS protocol. Possible values are '\fBSSL2\fR',
\&'\fBSSL3\fR', '\fBSSL23\fR', and '\fBTLS1\fR'. Try this if the default
handshake does not work for your server. Use this option with
'\fBTLS1\fR' to enforce a TLS connection. To defeat opportunistic TLSv1
negotiation when the server advertises STARTTLS or STLS, use \fB''\fR.
This option, even if the argument is the empty string, will also
suppress the diagnostic 'SERVER: opportunistic upgrade to TLS.' message
in verbose mode. The default is to try appropriate protocols depending
on context.
.TP
.B \-\-sslcertck
(Keyword: sslcertck)
Causes fetchmail to strictly check the server certificate against a set of
local trusted certificates (see the \fBsslcertpath\fR option). If the server
certificate cannot be obtained or is not signed by one of the trusted ones
(directly or indirectly), the SSL connection will fail, regardless of
the \fBsslfingerprint\fR option.
Note that CRL are only supported in OpenSSL 0.9.7 and newer! Your system
clock should also be reasonably accurate when using this option.
.IP
Note that this optional behavior may become default behavior in future
fetchmail versions.
.TP
.B \-\-sslcertpath <directory>
(Keyword: sslcertpath)
Sets the directory fetchmail uses to look up local certificates. The default
is your OpenSSL default one. The directory must be hashed as OpenSSL expects
it - every time you add or modify a certificate in the directory, you need
to use the \fBc_rehash\fR tool (which comes with OpenSSL in the tools/
subdirectory).
.TP
.B \-\-sslfingerprint <fingerprint>
(Keyword: sslfingerprint)
Specify the fingerprint of the server key (an MD5 hash of the key) in
hexadecimal notation with colons separating groups of two digits. The letter
hex digits must be in upper case. This is the default format OpenSSL uses,
and the one fetchmail uses to report the fingerprint when an SSL connection
is established. When this is specified, fetchmail will compare the server key
fingerprint with the given one, and the connection will fail if they do not
match regardless of the \fBsslcertck\fR setting. The connection will
also fail if fetchmail cannot obtain an SSL certificate from the server.
This can be used to prevent man-in-the-middle attacks, but the finger
print from the server needs to be obtained or verified over a secure
channel, and certainly not over the same Internet connection that
fetchmail would use.
.IP
Using this option will prevent printing certificate verification errors
as long as \-\-sslcertck is unset.
.IP
To obtain the fingerprint of a certificate stored in the file cert.pem,
try:
.sp
.nf
	openssl x509 \-in cert.pem \-noout \-md5 \-fingerprint
.fi
.sp
For details, see
.BR x509 (1ssl).
.SS Delivery Control Options
.TP
.B \-S <hosts> | \-\-smtphost <hosts>
(Keyword: smtp[host])
Specify a hunt list of hosts to forward mail to (one or more
hostnames, comma-separated). Hosts are tried in list order; the first
one that is up becomes the forwarding target for the current run.  If
this option is not specified, 'localhost' is used as the default.
Each hostname may have a port number following the host name.  The
port number is separated from the host name by a slash; the default
port is "smtp".  If you specify an absolute path name (beginning with
a /), it will be interpreted as the name of a UNIX socket accepting
LMTP connections (such as is supported by the Cyrus IMAP daemon)
Example:
.sp
.nf
	\-\-smtphost server1,server2/2525,server3,/var/imap/socket/lmtp
.fi
.sp
This option can be used with ODMR, and will make fetchmail a relay
between the ODMR server and SMTP or LMTP receiver.
.TP
.B \-\-fetchdomains <hosts>
(Keyword: fetchdomains)
In ETRN or ODMR mode, this option specifies the list of domains the
server should ship mail for once the connection is turned around.  The
default is the FQDN of the machine running
.IR fetchmail .
.TP
.B \-D <domain> | \-\-smtpaddress <domain>
(Keyword: smtpaddress) Specify the domain to be appended to addresses
in RCPT TO lines shipped to SMTP. When this is not specified, the name
of the SMTP server (as specified by \-\-smtphost) is used for SMTP/LMTP
and 'localhost' is used for UNIX socket/BSMTP.
.TP
.B \-\-smtpname <user@domain>
(Keyword: smtpname)
Specify the domain and user to be put in RCPT TO lines shipped to SMTP.
The default user is the current local user.
.TP
.B \-Z <nnn> | \-\-antispam <nnn[, nnn]...>
(Keyword: antispam)
Specifies the list of numeric SMTP errors that are to be interpreted
as a spam-block response from the listener.  A value of \-1 disables
this option.  For the command-line option, the list values should
be comma-separated.
.TP
.B \-m <command> | \-\-mda <command>
(Keyword: mda) You can force mail to be passed to an MDA directly
(rather than forwarded to port 25) with the \-\-mda or \-m option.  To
avoid losing mail, use this option only with MDAs like maildrop or
MTAs like sendmail that return a nonzero status on disk-full and other
resource-exhaustion errors; the nonzero status tells fetchmail that
delivery failed and prevents the message from being deleted off the
server.  If \fIfetchmail\fR is running as root, it sets its user id to
that of the target user while delivering mail through an MDA.  Some
possible MDAs are "/usr/sbin/sendmail \-i \-f %F \-\- %T" (\fBNote:\fR
some several older or vendor sendmail versions mistake \-\- for an
address, rather than an indicator to mark the end of the option arguments),
"/usr/bin/deliver" and "/usr/bin/maildrop \-d %T".  Local delivery
addresses will be inserted into the MDA command wherever you place a
%T; the mail message's From address will be inserted where you place
an %F. \fBDO NOT ENCLOSE THE %F OR %T STRING IN SINGLE QUOTES!\fR For
both %T and %F, fetchmail encloses the addresses in single quotes ('),
after removing any single quotes they may contain, before the MDA
command is passed to the shell.  Do \fINOT\fR use an MDA invocation
like "sendmail \-i \-t" that dispatches on the contents of To/Cc/Bcc, it
will create mail loops and bring the just wrath of many postmasters
down upon your head.  Also, do \fInot\fR try to combine multidrop
mode with an MDA such as maildrop that can only accept one
address; you will lose mail.

A word of warning: the well-known
.BR procmail (1)
package is very hard to configure properly, it has a very nasty "fall
through to the next rule" behavior on delivery errors (even temporary
ones, such as out of disk space if another user's mail daemon copies the
mailbox around to purge old messages), so your mail will end up in the
wrong mailbox sooner or later. The proper procmail configuration is
outside the scope of this document though. Using
.BR maildrop (1)
is usually much easier, and many users find the filter syntax used by
maildrop easier to understand.

.TP
.B \-\-lmtp
(Keyword: lmtp)
Cause delivery via LMTP (Local Mail Transfer Protocol).  A service
host and port \fBmust\fR be explicitly specified on each host in the
smtphost hunt list (see above) if this option is selected; the default
port 25 will (in accordance with RFC 2033) not be accepted.
.TP
.B \-\-bsmtp <filename>
(keyword: bsmtp)
Append fetched mail to a BSMTP file.  This simply contains the SMTP
commands that would normally be generated by fetchmail when passing
mail to an SMTP listener daemon.  An argument of '\-' causes the mail
to be written to standard output.  Note that fetchmail's
reconstruction of MAIL FROM and RCPT TO lines is not guaranteed
correct; the caveats discussed under THE USE AND ABUSE OF MULTIDROP
MAILBOXES below apply.
.SS Resource Limit Control Options
.TP
.B \-l <maxbytes> | \-\-limit <maxbytes>
(Keyword: limit) Takes a maximum octet size argument.  Messages larger
than this size will not be fetched and will be left on the server (in
foreground sessions, the progress messages will note that they are
"oversized").  If the fetch protocol permits (in particular, under
IMAP or POP3 without the fetchall option) the message will not be
marked seen.
.sp
An explicit \-\-limit of 0 overrides any limits set in your
run control file. This option is intended for those needing to
strictly control fetch time due to expensive and variable phone rates.
.sp
Combined with \-\-limitflush, it can be used to delete oversized
messages waiting on a server.  In daemon mode, oversize notifications
are mailed to the calling user (see the \-\-warnings option). This
option does not work with ETRN or ODMR.
.TP
.B \-w <interval> | \-\-warnings <interval>
(Keyword: warnings)
Takes an interval in seconds.  When you call
.I fetchmail
with a 'limit' option in daemon mode, this controls the interval at
which warnings about oversized messages are mailed to the calling user
(or the user specified by the 'postmaster' option).  One such
notification is always mailed at the end of the the first poll that
the oversized message is detected.  Thereafter, re-notification is
suppressed until after the warning interval elapses (it will take
place at the end of the first following poll).
.TP
.B \-b <count> | \-\-batchlimit <count>
(Keyword: batchlimit)
Specify the maximum number of messages that will be shipped to an SMTP
listener before the connection is deliberately torn down and rebuilt
(defaults to 0, meaning no limit).  An explicit \-\-batchlimit of 0
overrides any limits set in your run control file.  While
\fBsendmail\fR(8) normally initiates delivery of a message immediately
after receiving the message terminator, some SMTP listeners are not so
prompt.  MTAs like \fIsmail\fR(8) may wait till the
delivery socket is shut down to deliver.  This may produce annoying
delays when \fIfetchmail\fR is processing very large batches.  Setting
the batch limit to some nonzero size will prevent these delays.  This
option does not work with ETRN or ODMR.
.TP
.B \-B <number> | \-\-fetchlimit <number>
(Keyword: fetchlimit)
Limit the number of messages accepted from a given server in a single
poll.  By default there is no limit. An explicit \-\-fetchlimit of 0
overrides any limits set in your run control file.
This option does not work with ETRN or ODMR.
.TP
.B \-\-fetchsizelimit <number>
(Keyword: fetchsizelimit)
Limit the number of sizes of messages accepted from a given server in
a single transaction.  This option is useful in reducing the delay in
downloading the first mail when there are too many mails in the
mailbox.  By default, the limit is 100.  If set to 0, sizes of all
messages are downloaded at the start.
This option does not work with ETRN or ODMR.  For POP3, the only valid
non-zero value is 1.
.TP
.B \-\-fastuidl <number>
(Keyword: fastuidl)
Do a binary instead of linear search for the first unseen UID. Binary
search avoids downloading the UIDs of all mails. This saves time
(especially in daemon mode) where downloading the same set of UIDs in
each poll is a waste of bandwidth. The number 'n' indicates how rarely
a linear search should be done. In daemon mode, linear search is used
once followed by binary searches in 'n-1' polls if 'n' is greater than
1; binary search is always used if 'n' is 1; linear search is always
used if 'n' is 0. In non-daemon mode, binary search is used if 'n' is
1; otherwise linear search is used. The default value of 'n' is 4.
This option works with POP3 only.
.TP
.B \-e <count> | \-\-expunge <count>
(keyword: expunge)
Arrange for deletions to be made final after a given number of
messages.  Under POP2 or POP3, fetchmail cannot make deletions final
without sending QUIT and ending the session -- with this option on,
fetchmail will break a long mail retrieval session into multiple
sub-sessions, sending QUIT after each sub-session. This is a good
defense against line drops on POP3 servers.  Under IMAP,
.I fetchmail
normally issues an EXPUNGE command after each deletion in order to
force the deletion to be done immediately.  This is safest when your
connection to the server is flaky and expensive, as it avoids
resending duplicate mail after a line hit.  However, on large
mailboxes the overhead of re-indexing after every message can slam the
server pretty hard, so if your connection is reliable it is good to do
expunges less frequently.  Also note that some servers enforce a delay
of a few seconds after each quit, so fetchmail may not be able to get
back in immediately after an expunge -- you may see "lock busy" errors
if this happens. If you specify this option to an integer N,
it tells
.I fetchmail
to only issue expunges on every Nth delete.  An argument of zero
suppresses expunges entirely (so no expunges at all will be done until
the end of run).  This option does not work with ETRN or ODMR.
.SS Authentication Options
.TP
.B \-u <name> | \-\-user <name> | \-\-username <name>
(Keyword: user[name])
Specifies the user identification to be used when logging in to the mailserver.
The appropriate user identification is both server and user-dependent.
The default is your login name on the client machine that is running
.IR fetchmail .
See USER AUTHENTICATION below for a complete description.
.TP
.B \-I <specification> | \-\-interface <specification>
(Keyword: interface)
Require that a specific interface device be up and have a specific local
or remote IPv4 (IPv6 is not supported by this option yet) address (or
range) before polling.  Frequently \fIfetchmail\fP
is used over a transient point-to-point TCP/IP link established directly
to a mailserver via SLIP or PPP.  That is a relatively secure channel.
But when other TCP/IP routes to the mailserver exist (e.g. when the link
is connected to an alternate ISP), your username and password may be
vulnerable to snooping (especially when daemon mode automatically polls
for mail, shipping a clear password over the net at predictable
intervals).  The \-\-interface option may be used to prevent this.  When
the specified link is not up or is not connected to a matching IP
address, polling will be skipped.  The format is:
.sp
.nf
	interface/iii.iii.iii.iii[/mmm.mmm.mmm.mmm]
.fi
.sp
The field before the first slash is the interface name (i.e. sl0, ppp0
etc.).  The field before the second slash is the acceptable IP address.
The field after the second slash is a mask which specifies a range of
IP addresses to accept.  If no mask is present 255.255.255.255 is
assumed (i.e. an exact match).  This option is currently only supported
under Linux and FreeBSD. Please see the
.B monitor
section for below for FreeBSD specific information.
.sp
Note that this option may be removed from a future fetchmail version.
.TP
.B \-M <interface> | \-\-monitor <interface>
(Keyword: monitor)
Daemon mode can cause transient links which are automatically taken down
after a period of inactivity (e.g. PPP links) to remain up
indefinitely.  This option identifies a system TCP/IP interface to be
monitored for activity.  After each poll interval, if the link is up but
no other activity has occurred on the link, then the poll will be
skipped.  However, when fetchmail is woken up by a signal, the
monitor check is skipped and the poll goes through unconditionally.
This option is currently only supported under Linux and FreeBSD.
For the
.B monitor
and
.B interface
options to work for non root users under FreeBSD, the fetchmail binary
must be installed SGID kmem. This would be a security hole, but
fetchmail runs with the effective GID set to that of the kmem group
.I only
when interface data is being collected.
.sp
Note that this option may be removed from a future fetchmail version.
.TP
.B \-\-auth <type>
(Keyword: auth[enticate])
This option permits you to specify an authentication type (see USER
AUTHENTICATION below for details).  The possible values are \fBany\fR,
\&\fBpassword\fR, \fBkerberos_v5\fR, \fBkerberos\fR (or, for
excruciating exactness, \fBkerberos_v4\fR), \fBgssapi\fR,
\fBcram\-md5\fR, \fBotp\fR, \fBntlm\fR, \fBmsn\fR (only for POP3),
\fBexternal\fR (only IMAP) and \fBssh\fR.
When \fBany\fR (the default) is specified, fetchmail tries
first methods that don't require a password (EXTERNAL, GSSAPI, KERBEROS\ IV,
KERBEROS\ 5); then it looks for methods that mask your password
(CRAM-MD5, X\-OTP - note that NTLM and MSN are not autoprobed for POP3
and MSN is only supported for POP3); and only if the server doesn't
support any of those will it ship your password en clair.  Other values
may be used to force various authentication methods
(\fBssh\fR suppresses authentication and is thus useful for IMAP PREAUTH).
(\fBexternal\fR suppresses authentication and is thus useful for IMAP EXTERNAL).
Any value other than \fBpassword\fR, \fBcram\-md5\fR, \fBntlm\fR,
\&\fBmsn\fR or \fBotp\fR suppresses fetchmail's normal inquiry for a
password.  Specify \fBssh\fR when you are using an end-to-end secure
connection such as an ssh tunnel; specify \fBexternal\fR when you use
TLS with client authentication and specify \fBgssapi\fR or
\&\fBkerberos_v4\fR if you are using a protocol variant that employs
GSSAPI or K4.  Choosing KPOP protocol automatically selects Kerberos
authentication.  This option does not work with ETRN.
.SS Miscellaneous Options
.TP
.B \-f <pathname> | \-\-fetchmailrc <pathname>
Specify a non-default name for the
.I ~/.fetchmailrc
run control file.  The pathname argument must be either "-" (a single
dash, meaning to read the configuration from standard input) or a
filename.  Unless the \-\-version option is also on, a named file
argument must have permissions no more open than 0600 (u=rw,g=,o=) or
else be /dev/null.
.TP
.B \-i <pathname> | \-\-idfile <pathname>
(Keyword: idfile)
Specify an alternate name for the .fetchids file used to save POP3
UIDs. NOTE: since fetchmail 6.3.0, write access to the directory
containing the idfile is required, as fetchmail writes a temporary file
and renames it into the place of the real idfile only if the temporary
file has been written successfully. This avoids the truncation of
idfiles when running out of disk space.
.TP
.B \--pidfile <pathname>
(Keyword: pidfile; since fetchmail v6.3.4)
Override the default location of the PID file. Default: see
"ENVIRONMENT" below.
.TP
.B \-n | \-\-norewrite
(Keyword: no rewrite)
Normally,
.I fetchmail
edits RFC-822 address headers (To, From, Cc, Bcc, and Reply\-To) in
fetched mail so that any mail IDs local to the server are expanded to
full addresses (@ and the mailserver hostname are appended).  This enables
replies on the client to get addressed correctly (otherwise your
mailer might think they should be addressed to local users on the
client machine!).  This option disables the rewrite.  (This option is
provided to pacify people who are paranoid about having an MTA edit
mail headers and want to know they can prevent it, but it is generally
not a good idea to actually turn off rewrite.)
When using ETRN or ODMR, the rewrite option is ineffective.
.TP
.B \-E <line> | \-\-envelope <line>
(Keyword: envelope; Multidrop only)
.br
In the configuration file, an enhanced syntax is used:
.br
.B envelope [<count>] <line>
.sp
This option changes the header
.I fetchmail
assumes will carry a copy of the mail's envelope address.  Normally
this is 'X\-Envelope\-To', but as this header is not standard, practice
varies. See the discussion of multidrop address handling below.  As a
special case, 'envelope "Received"' enables parsing of sendmail-style
Received lines.  This is the default, and it should not be necessary
unless you have globally disabled Received parsing with 'no envelope'
in the \fI.fetchmailrc\fR file.
.sp
The optional count argument (only available in the configuration file)
determines how many header lines of this kind are skipped. A count of 1
means: skip the first, take the second. A count of 2 means: skip the
first and second, take the third, and so on.
.TP
.B \-Q <prefix> | \-\-qvirtual <prefix>
(Keyword: qvirtual; Multidrop only)
The string prefix assigned to this option will be removed from the user
name found in the header specified with the \fIenvelope\fR option
(\fIbefore\fR doing multidrop name mapping or localdomain checking,
if either is applicable). This option is useful if you are using
.I fetchmail
to collect the mail for an entire domain and your ISP (or your mail
redirection provider) is using qmail.
One of the basic features of qmail is the
.sp
\&'Delivered\-To:'
.sp
message header.  Whenever qmail delivers a message to a local mailbox
it puts the username and hostname of the envelope recipient on this
line.  The major reason for this is to prevent mail loops.  To set up
qmail to batch mail for a disconnected site the ISP-mailhost will have
normally put that site in its 'Virtualhosts' control file so it will
add a prefix to all mail addresses for this site. This results in mail
.\" The \&@\& tries to stop HTML converters from making a mailto URL here.
sent to 'username\&@\&userhost.userdom.dom.com' having a
\&'Delivered\-To:' line of the form:
.sp
Delivered\-To: mbox\-userstr\-username\&@\&userhost.example.com
.sp
The ISP can make the 'mbox\-userstr\-' prefix anything they choose
but a string matching the user host name is likely.
By using the option 'envelope Delivered\-To:' you can make fetchmail reliably
identify the original envelope recipient, but you have to strip the
\&'mbox\-userstr\-' prefix to deliver to the correct user.
This is what this option is for.
.TP
.B \-\-configdump
Parse the
.I ~/.fetchmailrc
file, interpret any command-line options specified, and dump a
configuration report to standard output.  The configuration report is
a data structure assignment in the language Python.  This option
is meant to be used with an interactive
.I ~/.fetchmailrc
editor like
.IR fetchmailconf ,
written in Python.
.SS Removed Options
.TP
.B \-T | \-\-netsec
Removed before version 6.3.0, the required underlying inet6_apps library
had been discontinued and is no longer available.

.SH USER AUTHENTICATION AND ENCRYPTION
All modes except ETRN require authentication of the client to the server.
Normal user authentication in
.I fetchmail
is very much like the authentication mechanism of
.IR ftp (1).
The correct user-id and password depend upon the underlying security
system at the mailserver.
.PP
If the mailserver is a Unix machine on which you have an ordinary user
account, your regular login name and password are used with
.IR fetchmail .
If you use the same login name on both the server and the client machines,
you needn't worry about specifying a user-id with the
.B \-u
option -- the default behavior is to use your login name on the
client machine as the user-id on the server machine.  If you use a
different login name on the server machine, specify that login name
with the
.B \-u
option.  e.g. if your login name is 'jsmith' on a machine named 'mailgrunt',
you would start
.I fetchmail
as follows:
.IP
fetchmail \-u jsmith mailgrunt
.PP
The default behavior of
.I fetchmail
is to prompt you for your mailserver password before the connection is
established.  This is the safest way to use
.I fetchmail
and ensures that your password will not be compromised.  You may also specify
your password in your
.I ~/.fetchmailrc
file.  This is convenient when using
.I fetchmail
in daemon mode or with scripts.
.SS Using netrc files
.PP
If you do not specify a password, and
.I fetchmail
cannot extract one from your
.I ~/.fetchmailrc
file, it will look for a
.I ~/.netrc
file in your home directory before requesting one interactively; if an
entry matching the mailserver is found in that file, the password will
be used.  Fetchmail first looks for a match on poll name; if it finds none,
it checks for a match on via name.  See the
.IR ftp (1)
man page for details of the syntax of the
.I ~/.netrc
file.  To show a practical example, a .netrc might look like
this:
.IP
.nf
machine hermes.example.org
login joe
password topsecret
.fi
.PP
You can repeat this block with different user information if you need to
provide more than one password.
.PP
This feature may allow you to avoid duplicating password
information in more than one file.
.PP
On mailservers that do not provide ordinary user accounts, your user-id and
password are usually assigned by the server administrator when you apply for
a mailbox on the server.  Contact your server administrator if you don't know
the correct user-id and password for your mailbox account.
.SH POP3 VARIANTS
.PP
Early versions of POP3 (RFC1081, RFC1225) supported a crude form of
independent authentication using the
.I rhosts
file on the mailserver side.  Under this RPOP variant, a fixed
per-user ID equivalent to a password was sent in clear over a link to
a reserved port, with the command RPOP rather than PASS to alert the
server that it should do special checking.  RPOP is supported
by
.I fetchmail
(you can specify 'protocol RPOP' to have the program send 'RPOP'
rather than 'PASS') but its use is strongly discouraged, and support
will be removed from a future fetchmail version.  This
facility was vulnerable to spoofing and was withdrawn in RFC1460.
.PP
RFC1460 introduced APOP authentication.  In this variant of POP3,
you register an APOP password on your server host (the program
to do this with on the server is probably called \fIpopauth\fR(8)).  You
put the same password in your
.I ~/.fetchmailrc
file.  Each time
.I fetchmail
logs in, it sends a cryptographically secure hash of your password and
the server greeting time to the server, which can verify it by
checking its authorization database.
.SS RETR or TOP
.I fetchmail
makes some efforts to make the server believe messages had not been
retrieved, by using the TOP command with a large number of lines when
possible.  TOP is a command that retrieves the full header and
a \fIfetchmail\fP-specified amount of body lines. It is optional and
therefore not implemented by all servers, and some are known to
implement it improperly. On many servers however, the RETR command which
retrieves the full message with header and body, sets the "seen" flag
(for instance, in a web interface), whereas the TOP command does not do
that.
.PP
.I fetchmail
will always use the RETR command if "fetchall" is set.
.I fetchmail
will also use the RETR command if "keep" is set and "uidl" is unset.
Finally,
.I fetchmail
will use the RETR command on Maillennium POP3/PROXY
servers (used by Comcast) to avoid a deliberate TOP misinterpretation in
this server that causes message corruption.
.PP
In all other cases,
.I fetchmail
will use the TOP command. This implies that in "keep" setups, "uidl"
must be set if "TOP" is desired.
.PP
.B Note
that this description is true for the current version of fetchmail, but
the behavior may change in future versions. In particular, fetchmail may
prefer the RETR command because the TOP command causes much grief on
some servers and is only optional.
.SH ALTERNATE AUTHENTICATION FORMS
.PP
If your \fIfetchmail\fR was built with Kerberos support and you specify
Kerberos authentication (either with \-\-auth or the \fI.fetchmailrc\fR
option \fBauthenticate kerberos_v4\fR) it will try to get a Kerberos
ticket from the mailserver at the start of each query.  Note: if
either the pollname or via name is 'hesiod', fetchmail will try to use
Hesiod to look up the mailserver.
.PP
If you use POP3 or IMAP with GSSAPI authentication, \fIfetchmail\fR will
expect the server to have RFC1731- or RFC1734-conforming GSSAPI
capability, and will use it.  Currently this has only been tested over
Kerberos V, so you're expected to already have a ticket-granting
ticket. You may pass a username different from your principal name
using the standard \fB\-\-user\fR command or by the \fI.fetchmailrc\fR
option \fBuser\fR.
.PP
If your IMAP daemon returns the PREAUTH response in its greeting line,
fetchmail will notice this and skip the normal authentication step.
This can be useful, e.g. if you start imapd explicitly using ssh.
In this case you can declare the authentication value 'ssh' on that
site entry to stop \fI.fetchmail\fR from asking you for a password
when it starts up.
.PP
If you use client authentication with \fITLS1\fR and your IMAP daemon
returns the \fIAUTH=EXTERNAL\fR response, fetchmail will notice this
and will use the authentication shortcut and will not send the
passphrase. In this case you can declare the authentication value 'external'
 on that site to stop \fIfetchmail\fR from asking you for a password
when it starts up.
.PP
If you are using POP3, and the server issues a one-time-password
challenge conforming to RFC1938, \fIfetchmail\fR will use your
password as a pass phrase to generate the required response. This
avoids sending secrets over the net unencrypted.
.PP
Compuserve's RPA authentication (similar to APOP) is supported. If you
compile in the support, \fIfetchmail\fR will try to perform an RPA pass-phrase
authentication instead of sending over the password en clair if it
detects "@compuserve.com" in the hostname.
.PP
If you are using IMAP, Microsoft's NTLM authentication (used by Microsoft
Exchange) is supported. If you compile in the support, \fIfetchmail\fR
will try to perform an NTLM authentication (instead of sending over the
password en clair) whenever the server returns AUTH=NTLM in its
capability response. Specify a user option value that looks like
\&'user@domain': the part to the left of the @ will be passed as the
username and the part to the right as the NTLM domain.
.SS Secure Socket Layers (SSL) and Transport Layer Security (TLS)
.PP
You can access SSL encrypted services by specifying the \-\-ssl option.
You can also do this using the "ssl" user option in the .fetchmailrc
file. With SSL encryption enabled, queries are initiated over a connection
after negotiating an SSL session, and the connection fails if SSL cannot
be negotiated.  Some services, such as POP3 and IMAP, have different
well known ports defined for the SSL encrypted services.  The encrypted
ports will be selected automatically when SSL is enabled and no explicit
port is specified. The \-\-sslproto option can be used to select the SSL
protocols (default: v2 or v3).  The \-\-sslcertck command line or
sslcertck run control file option should be used to force strict
certificate checking - see below.
.PP
If SSL is not configured, fetchmail will usually opportunistically try to use
TLS. TLS can be enforced by using \-\-sslproto "TLS1". TLS
connections use the same port as the unencrypted version of the
protocol and negotiate TLS via special parameter. The \-\-sslcertck
command line or sslcertck run control file option should be used to
force strict certificate checking - see below.
.PP
.B \-\-sslcheck recommended:
When connecting to an SSL or TLS encrypted server, the server presents a certificate
to the client for validation.  The certificate is checked to verify that
the common name in the certificate matches the name of the server being
contacted and that the effective and expiration dates in the certificate
indicate that it is currently valid.  If any of these checks fail, a warning
message is printed, but the connection continues.  The server certificate
does not need to be signed by any specific Certifying Authority and may
be a "self-signed" certificate. If the \-\-sslcertck command line option
or sslcertck run control file option is used, fetchmail will instead
abort if any of these checks fail. Use of the sslcertck or \-\-sslcertck
option is advised.
.PP
Some SSL encrypted servers may request a client side certificate.  A client
side public SSL certificate and private SSL key may be specified.  If
requested by the server, the client certificate is sent to the server for
validation.  Some servers may require a valid client certificate and may
refuse connections if a certificate is not provided or if the certificate
is not valid.  Some servers may require client side certificates be signed
by a recognized Certifying Authority.  The format for the key files and
the certificate files is that required by the underlying SSL libraries
(OpenSSL in the general case).
.PP
A word of care about the use of SSL: While above mentioned
setup with self-signed server certificates retrieved over the wires
can protect you from a passive eavesdropper, it doesn't help against an
active attacker. It's clearly an improvement over sending the
passwords in clear, but you should be aware that a man-in-the-middle
attack is trivially possible (in particular with tools such as dsniff,
http://monkey.org/~dugsong/dsniff/).  Use of strict certificate checking
with a certification authority recognized by server and client, or
perhaps of an SSH tunnel (see below for some examples) is preferable if
you care seriously about the security of your mailbox and passwords.
.SS ESMTP AUTH
.PP
.B fetchmail
also supports authentication to the ESMTP server on the client side
according to RFC 2554.  You can specify a name/password pair to be
used with the keywords 'esmtpname' and 'esmtppassword'; the former
defaults to the username of the calling user.

.SH DAEMON MODE
.SS Introducing the daemon mode
In daemon mode,
.I fetchmail
puts itself into the background and runs forever, querying each
specified host and then sleeping for a given polling interval.
.SS Starting the daemon mode
There are several ways to make fetchmail work in daemon mode. On the
command line, \fB\-\-daemon\ <interval>\fR or \fB\-d\ <interval>\fR
option runs \fIfetchmail\fR in daemon mode.  You must specify a numeric
argument which is a polling interval in seconds.
.PP
Example: simply invoking
.IP
fetchmail \-d 900
.PP
will, therefore, poll all the hosts described in your
.I ~/.fetchmailrc
file (except those explicitly excluded with the 'skip' verb) once
every 15 minutes.
.PP
It is also possible to set a polling interval
in your \fI~/.fetchmailrc\fR file by saying 'set\ daemon\ <interval>',
where <interval> is an integer number of seconds.  If you do this,
fetchmail will always start in daemon mode unless you override it with
the command-line option \-\-daemon 0 or \-d0.
.PP
Only one daemon process is permitted per user; in daemon mode,
\fIfetchmail\fR sets up a per-user lockfile to guarantee this.
(You can however cheat and set the FETCHMAILHOME environment variable to
overcome this setting, but in that case, it is your responsibility to
make sure you aren't polling the same server with two processes at the
same time.)
.SS Awakening the background daemon
.PP
Normally, calling fetchmail with a daemon in the background sends a
wake-up signal to the daemon and quits without output. The background
daemon then starts its next poll cycle immediately.  The wake-up signal,
SIGUSR1, can also be sent manually. The wake-up action also clears any
'wedged' flags indicating that connections have wedged due to failed
authentication or multiple timeouts.
.SS Terminating the background daemon
.PP
The option
.B \-\-quit
will kill a running daemon process instead of waking it up (if there
is no such process, \fIfetchmail\fP will notify you.
If the \-\-quit option appears last on the command line, \fIfetchmail\fP
will kill the running daemon process and then quit. Otherwise,
\fIfetchmail\fP will first kill a running daemon process and then
continue running with the other options.
.SS Useful options for daemon mode
.PP
The
.B \-L <filename>
or
.B \-\-logfile <filename>
option (keyword: set logfile) is only effective when fetchmail is
detached. This option allows you to redirect status messages
into a specified logfile (follow the option with the logfile name).  The
logfile is opened for append, so previous messages aren't deleted.  This
is primarily useful for debugging configurations. Note that fetchmail
does not detect if the logfile is rotated, the logfile is only opened
once when fetchmail starts. You need to restart fetchmail after rotating
the logfile and before compressing it (if applicable).
.PP
The
.B \-\-syslog
option (keyword: set syslog) allows you to redirect status and error
messages emitted to the
.IR syslog (3)
system daemon if available.
Messages are logged with an id of \fBfetchmail\fR, the facility \fBLOG_MAIL\fR,
and priorities \fBLOG_ERR\fR, \fBLOG_ALERT\fR or \fBLOG_INFO\fR.
This option is intended for logging status and error messages which
indicate the status of the daemon and the results while fetching mail
from the server(s).
Error messages for command line options and parsing the \fI.fetchmailrc\fR
file are still written to stderr, or to the specified log file.
The
.B \-\-nosyslog
option turns off use of
.IR syslog (3),
assuming it's turned on in the
.I ~/.fetchmailrc
file, or that the
.B \-L
or
.B \-\-logfile <file>
option was used.
.PP
The
.B \-N
or
.B \-\-nodetach
option suppresses backgrounding and detachment of the
daemon process from its control terminal.  This is useful
for debugging or when fetchmail runs as the child of a supervisor
process such as
.IR init (8)
or Gerrit Pape's
.I runit.
Note that this also causes the logfile option to be
ignored (though perhaps it shouldn't).
.PP
Note that while running in daemon mode polling a POP2 or IMAP2bis server,
transient errors (such as DNS failures or sendmail delivery refusals)
may force the fetchall option on for the duration of the next polling
cycle.  This is a robustness feature.  It means that if a message is
fetched (and thus marked seen by the mailserver) but not delivered
locally due to some transient error, it will be re-fetched during the
next poll cycle.  (The IMAP logic doesn't delete messages until
they're delivered, so this problem does not arise.)
.PP
If you touch or change the
.I ~/.fetchmailrc
file while fetchmail is running in daemon mode, this will be detected
at the beginning of the next poll cycle.  When a changed
.I ~/.fetchmailrc
is detected, fetchmail rereads it and restarts from scratch (using
exec(2); no state information is retained in the new instance).
Note also that if you break the
.I ~/.fetchmailrc
file's syntax, the new instance will softly and silently vanish away
on startup.

.SH ADMINISTRATIVE OPTIONS
.PP
The
.B \-\-postmaster <name>
option (keyword: set postmaster) specifies the last-resort username to
which multidrop mail is to be forwarded if no matching local recipient
can be found. It is also used as destination of undeliverable mail if
the 'bouncemail' global option is off and additionally for spam-blocked
mail if the 'bouncemail' global option is off and the 'spambounce'
global option is on. This option defaults to the user who invoked
.IR fetchmail .
If the invoking user is root, then the default of this option is
the user 'postmaster'.  Setting postmaster to the empty string causes
such mail as described above to be discarded - this however is usually a
bad idea.
See also the description of the 'FETCHMAILUSER' environment variable in
the ENVIRONMENT section below.
.PP
The
.B \-\-nobounce
behaves like the "set no bouncemail" global option, which see.
.PP
The
.B \-\-invisible
option (keyword: set invisible) tries to make fetchmail invisible.
Normally, fetchmail behaves like any other MTA would -- it generates a
Received header into each message describing its place in the chain of
transmission, and tells the MTA it forwards to that the mail came from
the machine fetchmail itself is running on.  If the invisible option
is on, the Received header is suppressed and fetchmail tries to spoof
the MTA it forwards to into thinking it came directly from the
mailserver host.
.PP
The
.B \-\-showdots
option (keyword: set showdots) forces fetchmail to show progress dots
even if the current tty is not stdout (for example logfiles).
Fetchmail shows the dots by default when run in nodetach mode or when
daemon mode is not enabled.
.PP
By specifying the
.B \-\-tracepolls
option, you can ask fetchmail to add information to the Received
header on the form "polling {label} account {user}", where {label} is
the account label (from the specified rcfile, normally ~/.fetchmailrc)
and {user} is the username which is used to log on to the mail
server. This header can be used to make filtering email where no
useful header information is available and you want mail from
different accounts sorted into different mailboxes (this could, for
example, occur if you have an account on the same server running a
mailing list, and are subscribed to the list using that account). The
default is not adding any such header.  In
.IR .fetchmailrc ,
this is called 'tracepolls'.

.SH RETRIEVAL FAILURE MODES
The protocols \fIfetchmail\fR uses to talk to mailservers are next to
bulletproof.  In normal operation forwarding to port 25, no message is
ever deleted (or even marked for deletion) on the host until the SMTP
listener on the client side has acknowledged to \fIfetchmail\fR that
the message has been either accepted for delivery or rejected due to a
spam block.
.PP
When forwarding to an MDA, however, there is more possibility
of error.  Some MDAs are 'safe' and reliably return a nonzero status
on any delivery error, even one due to temporary resource limits.
The
.IR maildrop (1)
program is like this; so are most programs designed as mail transport
agents, such as
.IR sendmail (1),
including the sendmail wrapper of Postfix and
.IR exim (1).
These programs give back a reliable positive acknowledgement and
can be used with the mda option with no risk of mail loss.  Unsafe
MDAs, though, may return 0 even on delivery failure.  If this
happens, you will lose mail.
.PP
The normal mode of \fIfetchmail\fR is to try to download only 'new'
messages, leaving untouched (and undeleted) messages you have already
read directly on the server (or fetched with a previous \fIfetchmail
\-\-keep\fR).  But you may find that messages you've already read on the
server are being fetched (and deleted) even when you don't specify
\-\-all.  There are several reasons this can happen.
.PP
One could be that you're using POP2.  The POP2 protocol includes no
representation of 'new' or 'old' state in messages, so \fIfetchmail\fR
must treat all messages as new all the time.  But POP2 is obsolete, so
this is unlikely.
.PP
A potential POP3 problem might be servers that insert messages
in the middle of mailboxes (some VMS implementations of mail are
rumored to do this).  The \fIfetchmail\fR code assumes that new
messages are appended to the end of the mailbox; when this is not true
it may treat some old messages as new and vice versa.  Using UIDL whilst
setting fastuidl 0 might fix this, otherwise, consider switching to IMAP.
.PP
Yet another POP3 problem is that if they can't make tempfiles in the
user's home directory, some POP3 servers will hand back an
undocumented response that causes fetchmail to spuriously report "No
mail".
.PP
The IMAP code uses the presence or absence of the server flag \eSeen
to decide whether or not a message is new.  This isn't the right thing
to do, fetchmail should check the UIDVALIDITY and use UID, but it
doesn't do that yet. Under Unix, it counts on your IMAP server to notice
the BSD-style Status flags set by mail user agents and set the \eSeen
flag from them when appropriate.  All Unix IMAP servers we know of do
this, though it's not specified by the IMAP RFCs.  If you ever trip over
a server that doesn't, the symptom will be that messages you have
already read on your host will look new to the server.  In this
(unlikely) case, only messages you fetched with \fIfetchmail \-\-keep\fR
will be both undeleted and marked old.
.PP
In ETRN and ODMR modes, \fIfetchmail\fR does not actually retrieve messages;
instead, it asks the server's SMTP listener to start a queue flush
to the client via SMTP.  Therefore it sends only undelivered messages.

.SH SPAM FILTERING
Many SMTP listeners allow administrators to set up 'spam filters' that
block unsolicited email from specified domains.  A MAIL FROM or DATA line that
triggers this feature will elicit an SMTP response which
(unfortunately) varies according to the listener.
.PP
Newer versions of
.I sendmail
return an error code of 571.
.PP
According to RFC2821, the correct thing to return in this situation is
550 "Requested action not taken: mailbox unavailable" (the draft adds
"[E.g., mailbox not found, no access, or command rejected for policy
reasons].").
.PP
Older versions of the
.I exim
MTA return 501 "Syntax error in parameters or arguments".
.PP
The
.I postfix
MTA runs 554 as an antispam response.
.PP
.I Zmailer
may reject code with a 500 response (followed by an enhanced status
code that contains more information).
.PP
Return codes which
.I fetchmail
treats as antispam responses and discards
the message can be set with the 'antispam' option.  This is one of the
.I only
three circumstance under which fetchmail ever discards mail (the others
are the 552 and 553 errors described below, and the suppression of
multidropped messages with a message-ID already seen).
.PP
If
.I fetchmail
is fetching from an IMAP server, the antispam response will be detected and
the message rejected immediately after the headers have been fetched,
without reading the message body.  Thus, you won't pay for downloading
spam message bodies.
.PP
By default, the list of antispam responses is empty.
.PP
If the \fIspambounce\fR global option is on, mail that is spam-blocked
triggers an RFC1892/RFC1894 bounce message informing the originator that
we do not accept mail from it. See also BUGS.

.SH SMTP/ESMTP ERROR HANDLING
Besides the spam-blocking described above, fetchmail takes special
actions on the following SMTP/ESMTP error responses
.TP 5
452 (insufficient system storage)
Leave the message in the server mailbox for later retrieval.
.TP 5
552 (message exceeds fixed maximum message size)
Delete the message from the server.  Send bounce-mail to the
originator.
.TP 5
553 (invalid sending domain)
Delete the message from the server.  Don't even try to send
bounce-mail to the originator.
.PP
Other errors trigger bounce mail back to the originator. See also BUGS.

.SH THE RUN CONTROL FILE
The preferred way to set up fetchmail is to write a
\&\fI.fetchmailrc\fR file in your home directory (you may do this
directly, with a text editor, or indirectly via \fIfetchmailconf\fR).
When there is a conflict between the command-line arguments and the
arguments in this file, the command-line arguments take precedence.
.PP
To protect the security of your passwords,
your \fI~/.fetchmailrc\fR may not normally have more than 0600 (u=rw,g=,o=) permissions;
.I fetchmail
will complain and exit otherwise (this check is suppressed when
\-\-version is on).
.PP
You may read the \fI.fetchmailrc\fR file as a list of commands to
be executed when
.I fetchmail
is called with no arguments.
.SS Run Control Syntax
.PP
Comments begin with a '#' and extend through the end of the line.
Otherwise the file consists of a series of server entries or global
option statements in a free-format, token-oriented syntax.
.PP
There are four kinds of tokens: grammar keywords, numbers
(i.e. decimal digit sequences), unquoted strings, and quoted strings.
A quoted string is bounded by double quotes and may contain
whitespace (and quoted digits are treated as a string).  Note that
quoted strings will also contain line feed characters if they run across
two or more lines, unless you use a backslash to join lines (see below).
An unquoted string is any whitespace-delimited token that is neither
numeric, string quoted nor contains the special characters ',', ';',
\&':', or '='.
.PP
Any amount of whitespace separates tokens in server entries, but is
otherwise ignored. You may use backslash escape sequences (\en for LF,
\&\et for HT, \eb for BS, \er for CR, \e\fInnn\fP for decimal (where
nnn cannot start with a 0), \e0\fIooo\fP for octal, and \ex\fIhh\fP for
hex) to embed non-printable characters or string delimiters in strings.
In quoted strings, a backslash at the very end of a line will cause the
backslash itself and the line feed (LF or NL, new line) character to be
ignored, so that you can wrap long strings. Without the backslash at the
line end, the line feed character would become part of the string.
.PP
.B Warning:
while these resemble C-style escape sequences, they are not the same.
fetchmail only supports these eight styles. C supports more escape
sequences that consist of backslash (\e) and a single character, but
does not support decimal codes and does not require the leading 0 in
octal notation.  Example: fetchmail interprets \e233 the same as \exE9
(Latin small letter e with acute), where C would interpret \e233 as
octal 0233 = \ex9B (CSI, control sequence introducer).
.PP
Each server entry consists of one of the keywords 'poll' or 'skip',
followed by a server name, followed by server options, followed by any
number of user descriptions.  Note: the most common cause of syntax
errors is mixing up user and server options.
.PP
For backward compatibility, the word 'server' is a synonym for 'poll'.
.PP
You can use the noise keywords 'and', 'with',
\&'has', 'wants', and 'options' anywhere in an entry to make
it resemble English.  They're ignored, but but can make entries much
easier to read at a glance.  The punctuation characters ':', ';' and
\&',' are also ignored.
.PP
.SS Poll vs. Skip
The 'poll' verb tells fetchmail to query this host when it is run with
no arguments.  The 'skip' verb tells
.I fetchmail
not to poll this host unless it is explicitly named on the command
line.  (The 'skip' verb allows you to experiment with test entries
safely, or easily disable entries for hosts that are temporarily down.)
.PP
.SS Keyword/Option Summary
Here are the legal options.  Keyword suffixes enclosed in
square brackets are optional.  Those corresponding to short command-line
options are followed by '\-' and the appropriate option letter.  If
option is only relevant to a single mode of operation, it is noted as
\&'s' or 'm' for singledrop- or multidrop-mode, respectively.

Here are the legal global options:

.TS
l l l lw34.
Keyword  	Opt	Mode	Function
_
set daemon  	\-d	\&	T{
Set a background poll interval in seconds.
T}
set postmaster  	\&	\&	T{
Give the name of the last-resort mail recipient (default: user running
fetchmail, "postmaster" if run by the root user)
T}
set    bouncemail	\&	\&	T{
Direct error mail to the sender (default)
T}
set no bouncemail	\&	\&	T{
Direct error mail to the local postmaster (as per the 'postmaster'
global option above).
T}
set no spambounce	\&	\&	T{
Do not bounce spam-blocked mail (default).
T}
set    spambounce	\&	\&	T{
Bounce blocked spam-blocked mail (as per the 'antispam' user option)
back to the destination as indicated by the 'bouncemail' global option.
Warning: Do not use this to bounce spam back to the sender - most spam
is sent with false sender address and thus this option hurts innocent
bystanders.
T}
set logfile  	\-L	\&	T{
Name of a file to append error and status messages to.
T}
set idfile  	\-i	\&	T{
Name of the file to store UID lists in.
T}
set    syslog	\&	\&	T{
Do error logging through syslog(3).
T}
set no syslog  	\&	\&	T{
Turn off error logging through syslog(3). (default)
T}
set properties 	\&	\&	T{
String value that is ignored by fetchmail (may be used by extension
scripts).
T}
.TE

Here are the legal server options:

.TS
l l l lw34.
Keyword  	Opt	Mode	Function
_
via      	\&	\&	T{
Specify DNS name of mailserver, overriding poll name
T}
proto[col]	\-p	\&	T{
Specify protocol (case insensitive):
POP2, POP3, IMAP, APOP, KPOP
T}
local[domains]	\&	m	T{
Specify domain(s) to be regarded as local
T}
port    	\&	\&	T{
Specify TCP/IP service port (obsolete, use 'service' instead).
T}
service 	\-P	\&	T{
Specify service name (a numeric value is also allowed and
considered a TCP/IP port number).
T}
auth[enticate]	\&	\&	T{
Set authentication type (default 'any')
T}
timeout  	\-t	\&	T{
Server inactivity timeout in seconds (default 300)
T}
envelope	\-E	m	T{
Specify envelope-address header name
T}
no envelope	\&	m	T{
Disable looking for envelope address
T}
qvirtual	\-Q	m	T{
Qmail virtual domain prefix to remove from user name
T}
aka      	\&	m	T{
Specify alternate DNS names of mailserver
T}
interface	\-I	\&	T{
specify IP interface(s) that must be up for server poll to take place
T}
monitor   	\-M	\&	T{
Specify IP address to monitor for activity
T}
plugin   	\&	\&	T{
Specify command through which to make server connections.
T}
plugout   	\&	\&	T{
Specify command through which to make listener connections.
T}
dns     	\&	m	T{
Enable DNS lookup for multidrop (default)
T}
no dns   	\&	m	T{
Disable DNS lookup for multidrop
T}
checkalias	\&	m	T{
Do comparison by IP address for multidrop
T}
no checkalias	\&	m	T{
Do comparison by name for multidrop (default)
T}
uidl    	\-U	\&	T{
Force POP3 to use client-side UIDLs (recommended)
T}
no uidl   	\&	\&	T{
Turn off POP3 use of client-side UIDLs (default)
T}
interval   	\&	\&	T{
Only check this site every N poll cycles; N is a numeric argument.
T}
tracepolls	\&	\&	T{
Add poll tracing information to the Received header
T}
principal   	\&	\&	T{
Set Kerberos principal (only useful with IMAP and kerberos)
T}
esmtpname   	\&	\&	T{
Set name for RFC2554 authentication to the ESMTP server.
T}
esmtppassword	\&	\&	T{
Set password for RFC2554 authentication to the ESMTP server.
T}
.TE

Here are the legal user options:

.TS
l l l lw34.
Keyword  	Opt	Mode	Function
_
user[name]	\-u	\&	T{
Set remote user name
(local user name if name followed by 'here')
T}
is      	\&	\&	T{
Connect local and remote user names
T}
to      	\&	\&	T{
Connect local and remote user names
T}
pass[word]	\&	\&	T{
Specify remote account password
T}
ssl     	\&	\&	T{
Connect to server over the specified base protocol using SSL encryption
T}
sslcert 	\&	\&	T{
Specify file for client side public SSL certificate
T}
sslkey  	\&	\&	T{
Specify file for client side private SSL key
T}
sslproto	\&	\&	T{
Force ssl protocol for connection
T}
folder  	\-r	\&	T{
Specify remote folder to query
T}
smtphost	\-S	\&	T{
Specify smtp host(s) to forward to
T}
fetchdomains	\&	m	T{
Specify domains for which mail should be fetched
T}
smtpaddress	\-D	\&	T{
Specify the domain to be put in RCPT TO lines
T}
smtpname	\&	\&	T{
Specify the user and domain to be put in RCPT TO lines
T}
antispam	\-Z	\&	T{
Specify what SMTP returns are interpreted as spam-policy blocks
T}
mda     	\-m	\&	T{
Specify MDA for local delivery
T}
bsmtp   	\-o	\&	T{
Specify BSMTP batch file to append to
T}
preconnect	\&	\&	T{
Command to be executed before each connection
T}
postconnect	\&	\&	T{
Command to be executed after each connection
T}
keep     	\-k	\&	T{
Don't delete seen messages from server (for POP3, uidl is recommended)
T}
flush   	\-F	\&	T{
Flush all seen messages before querying (DANGEROUS)
T}
limitflush   	\&	\&	T{
Flush all oversized messages before querying
T}
fetchall	\-a	\&	T{
Fetch all messages whether seen or not
T}
rewrite    	\&	\&	T{
Rewrite destination addresses for reply (default)
T}
stripcr  	\&	\&	T{
Strip carriage returns from ends of lines
T}
forcecr  	\&	\&	T{
Force carriage returns at ends of lines
T}
pass8bits	\&	\&	T{
Force BODY=8BITMIME to ESMTP listener
T}
dropstatus	\&	\&	T{
Strip Status and X-Mozilla-Status lines out of incoming mail
T}
dropdelivered	\&	\&	T{
Strip Delivered-To lines out of incoming mail
T}
mimedecode	\&	\&	T{
Convert quoted-printable to 8-bit in MIME messages
T}
idle     	\&	\&	T{
Idle waiting for new messages after each poll (IMAP only)
T}
no keep  	\-K	\&	T{
Delete seen messages from server (default)
T}
no flush	\&	\&	T{
Don't flush all seen messages before querying (default)
T}
no fetchall	\&	\&	T{
Retrieve only new messages (default)
T}
no rewrite	\&	\&	T{
Don't rewrite headers
T}
no stripcr	\&	\&	T{
Don't strip carriage returns (default)
T}
no forcecr	\&	\&	T{
Don't force carriage returns at EOL (default)
T}
no pass8bits	\&	\&	T{
Don't force BODY=8BITMIME to ESMTP listener (default)
T}
no dropstatus	\&	\&	T{
Don't drop Status headers (default)
T}
no dropdelivered	\&	\&	T{
Don't drop Delivered\-To headers (default)
T}
no mimedecode	\&	\&	T{
Don't convert quoted-printable to 8-bit in MIME messages (default)
T}
no idle     	\&	\&	T{
Don't idle waiting for new messages after each poll (IMAP only)
T}
limit   	\-l	\&	T{
Set message size limit
T}
warnings   	\-w	\&	T{
Set message size warning interval
T}
batchlimit	\-b	\&	T{
Max # messages to forward in single connect
T}
fetchlimit	\-B	\&	T{
Max # messages to fetch in single connect
T}
fetchsizelimit	\&	\&	T{
Max # message sizes to fetch in single transaction
T}
fastuidl	\&	\&	T{
Use binary search for first unseen message (POP3 only)
T}
expunge 	\-e	\&	T{
Perform an expunge on every #th message (IMAP and POP3 only)
T}
properties  	\&	\&	T{
String value is ignored by fetchmail (may be used by extension scripts)
T}
.TE
.PP
Remember that all user options must \fIfollow\fR all server options.
.PP
In the .fetchmailrc file, the 'envelope' string argument may be
preceded by a whitespace-separated number.  This number, if specified,
is the number of such headers to skip over (that is, an argument of 1
selects the second header of the given type).  This is sometime useful
for ignoring bogus envelope headers created by an ISP's local delivery
agent or internal forwards (through mail inspection systems, for
instance).
.SS Keywords Not Corresponding To Option Switches
.PP
The 'folder' and 'smtphost' options (unlike their command-line
equivalents) can take a space- or comma-separated list of names
following them.
.PP
All options correspond to the obvious command-line arguments, except
the following: 'via', 'interval', 'aka', 'is', 'to', 'dns'/'no dns',
\&'checkalias'/'no checkalias', 'password', 'preconnect', 'postconnect',
\&'localdomains', 'stripcr'/'no stripcr', 'forcecr'/'no forcecr',
\&'pass8bits'/'no pass8bits' 'dropstatus/no dropstatus',
\&'dropdelivered/no dropdelivered', 'mimedecode/no mimedecode', 'no idle',
and 'no envelope'.
.PP
The 'via' option is for if you want to have more
than one configuration pointing at the same site.  If it is present,
the string argument will be taken as the actual DNS name of the
mailserver host to query.
This will override the argument of poll, which can then simply be a
distinct label for the configuration (e.g. what you would give on the
command line to explicitly query this host).
.PP
The 'interval' option (which takes a numeric argument) allows you to poll a
server less frequently than the basic poll interval.  If you say
\&'interval N' the server this option is attached to will only be
queried every N poll intervals.
.SS Singledrop vs. Multidrop options
.PP
The 'is' or 'to' keywords associate the following local (client)
name(s) (or server-name to client-name mappings separated by =) with
the mailserver user name in the entry.  If an is/to list has '*' as
its last name, unrecognized names are simply passed through. Note that
until \fIfetchmail\fR version 6.3.4 inclusively, these lists could only
contain local parts of user names (fetchmail would only look at the part
before the @ sign). \fIfetchmail\fR versions 6.3.5 and
newer support full addresses on the left hand side of these mappings,
and they take precedence over any 'localdomains', 'aka', 'via' or
similar mappings.
.PP
A single local name can be used to support redirecting your mail when
your username on the client machine is different from your name on the
mailserver.  When there is only a single local name, mail is forwarded
to that local username regardless of the message's Received, To, Cc,
and Bcc headers.  In this case,
.I fetchmail
never does DNS lookups.
.PP
When there is more than one local name (or name mapping),
\fIfetchmail\fR looks at the envelope header, if configured, and
otherwise at the Received, To, Cc, and Bcc headers of retrieved mail
(this is 'multidrop mode').  It looks for addresses with hostname parts
that match your poll name or your 'via', 'aka' or 'localdomains'
options, and usually also for hostname parts which DNS tells it are
aliases of the mailserver.  See the discussion of 'dns', 'checkalias',
\&'localdomains', and 'aka' for details on how matching addresses are
handled.
.PP
If \fIfetchmail\fR cannot match any mailserver usernames or
localdomain addresses, the mail will be bounced.
Normally it will be bounced to the sender, but if the 'bouncemail'
global option is off, the mail will go to the local postmaster instead.
(see the 'postmaster' global option). See also BUGS.
.PP
The 'dns' option (normally on) controls the way addresses from
multidrop mailboxes are checked.  On, it enables logic to check each
host address that does not match an 'aka' or 'localdomains' declaration
by looking it up with DNS.  When a mailserver username is recognized
attached to a matching hostname part, its local mapping is added to
the list of local recipients.
.PP
The 'checkalias' option (normally off) extends the lookups performed
by the 'dns' keyword in multidrop mode, providing a way to cope with
remote MTAs that identify themselves using their canonical name, while
they're polled using an alias.
When such a server is polled, checks to extract the envelope address
fail, and
.IR fetchmail
reverts to delivery using the To/Cc/Bcc headers (See below
\&'Header vs. Envelope addresses').
Specifying this option instructs
.IR fetchmail
to retrieve all the IP addresses associated with both the poll name
and the name used by the remote MTA and to do a comparison of the IP
addresses.  This comes in handy in situations where the remote server
undergoes frequent canonical name changes, that would otherwise
require modifications to the rcfile.  'checkalias' has no effect if
\&'no dns' is specified in the rcfile.
.PP
The 'aka' option is for use with multidrop mailboxes.  It allows you
to pre-declare a list of DNS aliases for a server.  This is an
optimization hack that allows you to trade space for speed.  When
.IR fetchmail ,
while processing a multidrop mailbox, grovels through message headers
looking for names of the mailserver, pre-declaring common ones can
save it from having to do DNS lookups.  Note: the names you give
as arguments to 'aka' are matched as suffixes -- if you specify
(say) 'aka netaxs.com', this will match not just a hostname
netaxs.com, but any hostname that ends with '.netaxs.com'; such as
(say) pop3.netaxs.com and mail.netaxs.com.
.PP
The 'localdomains' option allows you to declare a list of domains
which fetchmail should consider local.  When fetchmail is parsing
address lines in multidrop modes, and a trailing segment of a host
name matches a declared local domain, that address is passed through
to the listener or MDA unaltered (local-name mappings are \fInot\fR
applied).
.PP
If you are using 'localdomains', you may also need to specify 'no
envelope', which disables \fIfetchmail\fR's normal attempt to deduce
an envelope address from the Received line or X-Envelope-To header or
whatever header has been previously set by 'envelope'.  If you set 'no
envelope' in the defaults entry it is possible to undo that in
individual entries by using 'envelope <string>'.  As a special case,
\&'envelope "Received"' restores the default parsing of
Received lines.
.PP
The \fBpassword\fR option requires a string argument, which is the password
to be used with the entry's server.
.PP
The 'preconnect' keyword allows you to specify a shell command to be
executed just before each time
.I fetchmail
establishes a mailserver connection.  This may be useful if you are
attempting to set up secure POP connections with the aid of
.IR ssh (1).
If the command returns a nonzero status, the poll of that mailserver
will be aborted.
.PP
Similarly, the 'postconnect' keyword similarly allows you to specify a
shell command to be executed just after each time a mailserver
connection is taken down.
.PP
The 'forcecr' option controls whether lines terminated by LF only are
given CRLF termination before forwarding.  Strictly speaking RFC821
requires this, but few MTAs enforce the requirement it so this option
is normally off (only one such MTA, qmail, is in significant use at
time of writing).
.PP
The 'stripcr' option controls whether carriage returns are stripped
out of retrieved mail before it is forwarded.  It is normally not
necessary to set this, because it defaults to 'on' (CR stripping
enabled) when there is an MDA declared but 'off' (CR stripping
disabled) when forwarding is via SMTP.  If 'stripcr' and 'forcecr' are
both on, 'stripcr' will override.
.PP
The 'pass8bits' option exists to cope with Microsoft mail programs that
stupidly slap a "Content-Transfer-Encoding: 7bit" on everything.  With
this option off (the default) and such a header present,
.I fetchmail
declares BODY=7BIT to an ESMTP-capable listener; this causes problems for
messages actually using 8-bit ISO or KOI-8 character sets, which will
be garbled by having the high bits of all characters stripped.  If
\&'pass8bits' is on,
.I fetchmail
is forced to declare BODY=8BITMIME to any ESMTP-capable listener.  If
the listener is 8-bit-clean (as all the major ones now are) the right
thing will probably result.
.PP
The 'dropstatus' option controls whether nonempty Status and
X-Mozilla-Status lines are retained in fetched mail (the default) or
discarded.  Retaining them allows your MUA to see what messages (if
any) were marked seen on the server.  On the other hand, it can
confuse some new-mail notifiers, which assume that anything with a
Status line in it has been seen.  (Note: the empty Status lines
inserted by some buggy POP servers are unconditionally discarded.)
.PP
The 'dropdelivered' option controls whether Delivered\-To headers will
be kept in fetched mail (the default) or discarded. These headers are
added by Qmail and Postfix mailservers in order to avoid mail loops but
may get in your way if you try to "mirror" a mailserver within the same
domain. Use with caution.
.PP
The 'mimedecode' option controls whether MIME messages using the
quoted-printable encoding are automatically converted into pure 8-bit
data. If you are delivering mail to an ESMTP-capable, 8-bit-clean
listener (that includes all of the major MTAs like sendmail), then
this will automatically convert quoted-printable message headers and
data into 8-bit data, making it easier to understand when reading
mail. If your e-mail programs know how to deal with MIME messages,
then this option is not needed.  The mimedecode option is off by
default, because doing RFC2047 conversion on headers throws away
character-set information and can lead to bad results if the encoding
of the headers differs from the body encoding.
.PP
The 'idle' option is intended to be used with IMAP servers supporting
the RFC2177 IDLE command extension, but does not strictly require it.
If it is enabled, and fetchmail detects that IDLE is supported, an
IDLE will be issued at the end of each poll.  This will tell the IMAP
server to hold the connection open and notify the client when new mail
is available.  If IDLE is not supported, fetchmail will simulate it by
periodically issuing NOOP. If you need to poll a link frequently, IDLE
can save bandwidth by eliminating TCP/IP connects and LOGIN/LOGOUT
sequences. On the other hand, an IDLE connection will eat almost all
of your fetchmail's time, because it will never drop the connection
and allow other polls to occur unless the server times out the IDLE.
It also doesn't work with multiple folders; only the first folder will
ever be polled.

.PP
The 'properties' option is an extension mechanism.  It takes a string
argument, which is ignored by fetchmail itself.  The string argument may be
used to store configuration information for scripts which require it.
In particular, the output of '\-\-configdump' option will make properties
associated with a user entry readily available to a Python script.
.PP
.SS Miscellaneous Run Control Options
The words 'here' and 'there' have useful English-like
significance.  Normally 'user eric is esr' would mean that
mail for the remote user 'eric' is to be delivered to 'esr',
but you can make this clearer by saying 'user eric there is esr here',
or reverse it by saying 'user esr here is eric there'
.PP
Legal protocol identifiers for use with the 'protocol' keyword are:
.sp
.nf
    auto (or AUTO) (legacy, to be removed from future release)
    pop2 (or POP2) (legacy, to be removed from future release)
    pop3 (or POP3)
    sdps (or SDPS)
    imap (or IMAP)
    apop (or APOP)
    kpop (or KPOP)
.fi
.sp
.PP
Legal authentication types are 'any', 'password', 'kerberos',
\&'kerberos_v4', 'kerberos_v5' and 'gssapi', 'cram\-md5', 'otp', 'msn'
(only for POP3), 'ntlm', 'ssh', 'external' (only IMAP).
The 'password' type specifies
authentication by normal transmission of a password (the password may be
plain text or subject to protocol-specific encryption as in APOP);
\&'kerberos' tells \fIfetchmail\fR to try to get a Kerberos ticket at the
start of each query instead, and send an arbitrary string as the
password; and 'gssapi' tells fetchmail to use GSSAPI authentication.
See the description of the 'auth' keyword for more.
.PP
Specifying 'kpop' sets POP3 protocol over port 1109 with Kerberos V4
authentication.  These defaults may be overridden by later options.
.PP
There are some global option statements: 'set logfile'
followed by a string sets the same global specified by \-\-logfile.  A
command-line \-\-logfile option will override this. Note that \-\-logfile is
only effective if fetchmail detaches itself from the terminal.  Also,
\&'set daemon' sets the poll interval as \-\-daemon does.  This can be
overridden by a command-line \-\-daemon option; in particular \-\-daemon\~0
can be used to force foreground operation. The 'set postmaster'
statement sets the address to which multidrop mail defaults if there are
no local matches.  Finally, 'set syslog' sends log messages to
syslogd(8).

.SH DEBUGGING FETCHMAIL
.SS Fetchmail crashing
There are various ways in that fetchmail may "crash", i. e. stop
operation suddenly and unexpectedly. A "crash" usually refers to an
error condition that the software did not handle by itself. A well-known
failure mode is the "segmentation fault" or "signal 11" or "SIGSEGV" or
just "segfault" for short. These can be caused by hardware or by software
problems. Software-induced segfaults can usually be reproduced easily
and in the same place, whereas hardware-induced segfaults can go away if
the computer is rebooted, or powered off for a few hours, and can happen
in random locations even if you use the software the same way.

For solving hardware-induced segfaults, find the faulty component and repair or
replace it. <http://www.bitwizard.nl/sig11/> may help you with details.

For solving software-induced segfaults, the developers may need a "stack
backtrace".

.SS Enabling fetchmail core dumps
By default, fetchmail suppresses core dumps as these might contain
passwords and other sensitive information. For debugging fetchmail
crashes, obtaining a "stack backtrace" from a core dump is often the
quickest way to solve the problem, and when posting your problem on a
mailing list, the developers may ask you for a "backtrace".

1. To get useful backtraces, fetchmail needs to be installed without
getting stripped of its compilation symbols.  Unfortunately, most
binary packages that are installed are stripped, and core files from
symbol-stripped programs are worthless. So you may need to recompile
fetchmail. On many systems, you can type
.sp
.nf
        file `which fetchmail`
.fi
.sp
to find out if fetchmail was symbol-stripped or not. If yours was
unstripped, fine, proceed, if it was stripped, you need to recompile the
source code first. You do not usually need to install fetchmail in order
to debug it.

2. The shell environment that starts fetchmail needs to enable core
dumps. The key is the "maximum core (file) size" that can usually be
configured with a tool named "limit" or "ulimit". See the documentation
for your shell for details. In the popular bash shell, "ulimit \-Sc
unlimited" will allow the core dump.

3. You need to tell fetchmail, too, to allow core dumps. To do
this, run fetchmail with the \fB\-d0 \-v\fP options.  It is often easier
to also add \fB\-\-nosyslog \-N\fR as well.

Finally, you need to reproduce the crash. You can just start fetchmail
from the directory where you compiled it by typing \fB./fetchmail\fR,
so the complete command line will start with \fB./fetchmail \-Nvd0
\&\-\-nosyslog\fR and perhaps list your other options.

After the crash, run your debugger to obtain the core dump.  The
debugger will often be GNU GDB, you can then type (adjust paths as
necessary) \fBgdb ./fetchmail fetchmail.core\fR and then, after GDB
has started up and read all its files, type \fBbacktrace full\fR, save
the output (copy & paste will do, the backtrace will be read by a human)
and then type \fBquit\fR to leave gdb.
.B Note:
on some systems, the core
files have different names, they might contain a number instead of the
program name, or number and name, but it will usually have "core" as
part of their name.

.SH INTERACTION WITH RFC 822
When trying to determine the originating address of a message,
fetchmail looks through headers in the following order:
.sp
.nf
        Return-Path:
        Resent-Sender: (ignored if it doesn't contain an @ or !)
        Sender: (ignored if it doesn't contain an @ or !)
        Resent-From:
        From:
        Reply-To:
        Apparently-From:
.fi
.sp
The originating address is used for logging, and to set the MAIL FROM
address when forwarding to SMTP.  This order is intended to cope
gracefully with receiving mailing list messages in multidrop mode. The
intent is that if a local address doesn't exist, the bounce message
won't be returned blindly to the author or to the list itself, but
rather to the list manager (which is less annoying).

In multidrop mode, destination headers are processed as follows:
First, fetchmail looks for the Received: header (or whichever one is
specified by the 'envelope' option) to determine the local
recipient address. If the mail is addressed to more than one recipient,
the Received line won't contain any information regarding recipient addresses.

Then fetchmail looks for the Resent-To:, Resent-Cc:, and Resent-Bcc:
lines.  If they exist, they should contain the final recipients and
have precedence over their To:/Cc:/Bcc: counterparts.  If the Resent\-*
lines don't exist, the To:, Cc:, Bcc: and Apparently-To: lines are
looked for. (The presence of a Resent\-To: is taken to imply that the
person referred by the To: address has already received the original
copy of the mail.)

.SH CONFIGURATION EXAMPLES
Note that although there are password declarations in a good many
of the examples below, this is mainly for illustrative purposes.
We recommend stashing account/password pairs in your $HOME/.netrc
file, where they can be used not just by fetchmail but by ftp(1) and
other programs.

Basic format is:

.nf
  poll SERVERNAME protocol PROTOCOL username NAME password PASSWORD
.fi
.PP
Example:

.nf
  poll pop.provider.net protocol pop3 username "jsmith" password "secret1"
.fi
.PP
Or, using some abbreviations:

.nf
  poll pop.provider.net proto pop3 user "jsmith" password "secret1"
.fi
.PP
Multiple servers may be listed:

.nf
  poll pop.provider.net proto pop3 user "jsmith" pass "secret1"
  poll other.provider.net proto pop2 user "John.Smith" pass "My^Hat"
.fi

Here's a version of those two with more whitespace and some noise words:

.nf
  poll pop.provider.net proto pop3
      user "jsmith", with password secret1, is "jsmith" here;
  poll other.provider.net proto pop2:
      user "John.Smith", with password "My^Hat", is "John.Smith" here;
.fi

This version is much easier to read and doesn't cost significantly
more (parsing is done only once, at startup time).

.PP
If you need to include whitespace in a parameter string, enclose the
string in double quotes.  Thus:

.nf
  poll mail.provider.net with proto pop3:
        user "jsmith" there has password "u can't krak this"
                    is jws here and wants mda "/bin/mail"
.fi

You may have an initial server description headed by the keyword
\&'defaults' instead of 'poll' followed by a name.  Such a record
is interpreted as defaults for all queries to use. It may be overwritten
by individual server descriptions.  So, you could write:

.nf
  defaults proto pop3
        user "jsmith"
  poll pop.provider.net
        pass "secret1"
  poll mail.provider.net
        user "jjsmith" there has password "secret2"
.fi

It's possible to specify more than one user per server (this is only
likely to be useful when running fetchmail in daemon mode as root).
The 'user' keyword leads off a user description, and every user specification
in a multi-user entry must include it.  Here's an example:

.nf
  poll pop.provider.net proto pop3 port 3111
        user "jsmith" with pass "secret1" is "smith" here
        user jones with pass "secret2" is "jjones" here keep
.fi

This associates the local username 'smith' with the pop.provider.net
username 'jsmith' and the local username 'jjones' with the
pop.provider.net username 'jones'.  Mail for 'jones' is kept on the
server after download.
.PP
Here's what a simple retrieval configuration for a multidrop mailbox
looks like:

.nf
  poll pop.provider.net:
        user maildrop with pass secret1 to golux 'hurkle'='happy' snark here
.fi

This says that the mailbox of account 'maildrop' on the server is a
multidrop box, and that messages in it should be parsed for the
server user names 'golux', 'hurkle', and 'snark'.  It further
specifies that 'golux' and 'snark' have the same name on the
client as on the server, but mail for server user 'hurkle' should be
delivered to client user 'happy'.

.B Note
that
.I fetchmail,
until version 6.3.4, did NOT allow full user@domain specifications here,
these would never match. \fIFetchmail\fP 6.3.5 and newer support
user@domain specifications on the left-hand side of a user mapping.
.PP
Here's an example of another kind of multidrop connection:

.nf
  poll pop.provider.net localdomains loonytoons.org toons.org:
        user maildrop with pass secret1 to * here
.fi

This also says that the mailbox of account 'maildrop' on the server is
a multidrop box.  It tells fetchmail that any address in the
loonytoons.org or toons.org domains (including sub-domain addresses like
\&'joe@daffy.loonytoons.org') should be passed through to the local SMTP
listener without modification.  Be careful of mail loops if you do this!
.PP
Here's an example configuration using ssh and the plugin option.  The
queries are made directly on the stdin and stdout of imapd via ssh.
Note that in this setup, IMAP authentication can be skipped.

.nf
poll mailhost.net with proto imap:
        plugin "ssh %h /usr/sbin/imapd" auth ssh;
	user esr is esr here
.fi

.SH THE USE AND ABUSE OF MULTIDROP MAILBOXES
Use the multiple-local-recipients feature with caution -- it can bite.
All multidrop features are ineffective in ETRN and ODMR modes.

Also, note that in multidrop mode duplicate mails are suppressed.  A
piece of mail is considered duplicate if it has the same message-ID as
the message immediately preceding and more than one addressee.  Such
runs of messages may be generated when copies of a message addressed
to multiple users are delivered to a multidrop box.

.SS Header vs. Envelope addresses
The fundamental problem is that by having your mailserver toss several
peoples' mail in a single maildrop box, you may have thrown away
potentially vital information about who each piece of mail was
actually addressed to (the 'envelope address', as opposed to the
header addresses in the RFC822 To/Cc headers - the Bcc is not available
at the receiving end).  This 'envelope address' is the address you need
in order to reroute mail properly.
.PP
Sometimes
.I fetchmail
can deduce the envelope address.  If the mailserver MTA is
.I sendmail
and the item of mail had just one recipient, the MTA will have written
a 'by/for' clause that gives the envelope addressee into its Received
header. But this doesn't work reliably for other MTAs, nor if there is
more than one recipient.  By default, \fIfetchmail\fR looks for
envelope addresses in these lines; you can restore this default with
\&\-E "Received" or 'envelope Received'.
.PP
.B As a better alternative,
some SMTP listeners and/or mail servers insert a header
in each message containing a copy of the envelope addresses.  This
header (when it exists) is often 'X\-Original\-To', 'Delivered\-To' or
\&'X\-Envelope\-To'.  Fetchmail's assumption about this can be changed with
the \-E or 'envelope' option.  Note that writing an envelope header of
this kind exposes the names of recipients (including blind-copy
recipients) to all receivers of the messages, so the upstream must store
one copy of the message per recipient to avoid becoming a privacy problem.
.PP
Postfix, since version 2.0, writes an X\-Original\-To: header which
contains a copy of the envelope as it was received.
.PP
Qmail and Postfix generally write a 'Delivered\-To' header upon
delivering the message to the mail spool and use it to avoid mail loops.
Qmail virtual domains however will prefix the user name with a string
that normally matches the user's domain. To remove this prefix you can
use the \-Q or 'qvirtual' option.
.PP
Sometimes, unfortunately, neither of these methods works.  That is the
point when you should contact your ISP and ask them to provide such an
envelope header, and you should not use multidrop in this situation.
When they all fail, fetchmail must fall back on the contents of To/Cc
headers (Bcc headers are not available - see below) to try to determine
recipient addressees -- and these are unreliable.
In particular, mailing-list software often ships mail with only
the list broadcast address in the To header.
.PP
.B Note that a future version of \fIfetchmail\fP may remove To/Cc parsing!
.PP
When
.I fetchmail
cannot deduce a recipient address that is local, and the intended
recipient address was anyone other than fetchmail's invoking user,
.B mail will get lost.
This is what makes the multidrop feature risky without proper envelope
information.
.PP
A related problem is that when you blind-copy a mail message, the Bcc
information is carried \fIonly\fR as envelope address (it's removed from
the headers by the sending mail server, so fetchmail can see it only if
there is an X-\Envelope\-To header).  Thus, blind-copying to someone who
gets mail over a fetchmail multidrop link will fail unless the the
mailserver host routinely writes X\-Envelope\-To or an equivalent header
into messages in your maildrop.
.PP
\fBIn conclusion, mailing lists and Bcc'd mail can only work if the
server you're fetching from (1) stores one copy of the message per
recipient in \fIyour\fP domain and (2) records the envelope
information in a special header (X\-Original\-To, Delivered\-To,
X\-Envelope\-To).\fR

.SS Good Ways To Use Multidrop Mailboxes
Multiple local names can be used to administer a mailing list from the
client side of a \fIfetchmail\fR collection.  Suppose your name is
\&'esr', and you want to both pick up your own mail and maintain a mailing
list called (say) "fetchmail-friends", and you want to keep the alias
list on your client machine.
.PP
On your server, you can alias 'fetchmail\-friends' to 'esr'; then, in
your \fI.fetchmailrc\fR, declare 'to esr fetchmail\-friends here'.
Then, when mail including 'fetchmail\-friends' as a local address
gets fetched, the list name will be appended to the list of
recipients your SMTP listener sees.  Therefore it will undergo alias
expansion locally.  Be sure to include 'esr' in the local alias
expansion of fetchmail\-friends, or you'll never see mail sent only to
the list.  Also be sure that your listener has the "me-too" option set
(sendmail's \-oXm command-line option or OXm declaration) so your name
isn't removed from alias expansions in messages you send.
.PP
This trick is not without its problems, however.  You'll begin to see
this when a message comes in that is addressed only to a mailing list
you do \fInot\fR have declared as a local name.  Each such message
will feature an 'X\-Fetchmail\-Warning' header which is generated
because fetchmail cannot find a valid local name in the recipient
addresses.  Such messages default (as was described above) to being
sent to the local user running
.IR fetchmail ,
but the program has no way to know that that's actually the right thing.

.SS Bad Ways To Abuse Multidrop Mailboxes
Multidrop mailboxes and
.I fetchmail
serving multiple users in daemon mode do not mix.  The problem, again, is
mail from mailing lists, which typically does not have an individual
recipient address on it.   Unless
.I fetchmail
can deduce an envelope address, such mail will only go to the account
running fetchmail (probably root).  Also, blind-copied users are very
likely never to see their mail at all.
.PP
If you're tempted to use
.I fetchmail
to retrieve mail for multiple users from a single mail drop via POP or
IMAP, think again (and reread the section on header and envelope
addresses above).  It would be smarter to just let the mail sit in the
mailserver's queue and use fetchmail's ETRN or ODMR modes to trigger
SMTP sends periodically (of course, this means you have to poll more
frequently than the mailserver's expiry period).  If you can't arrange
this, try setting up a UUCP feed.
.PP
If you absolutely \fImust\fR use multidrop for this purpose, make sure
your mailserver writes an envelope-address header that fetchmail can
see.  Otherwise you \fIwill\fR lose mail and it \fIwill\fR come back
to haunt you.

.SS Speeding Up Multidrop Checking
Normally, when multiple users are declared
.I fetchmail
extracts recipient addresses as described above and checks each host
part with DNS to see if it's an alias of the mailserver.  If so, the
name mappings described in the "to ... here" declaration are done and
the mail locally delivered.
.PP
This is a convenient but also slow method.  To speed
it up, pre-declare mailserver aliases with 'aka'; these are checked
before DNS lookups are done.  If you're certain your aka list contains
.B all
DNS aliases of the mailserver (and all MX names pointing at it - note
this may change in a future version)
you can declare 'no dns' to suppress DNS lookups entirely and
\fIonly\fR match against the aka list.

.SH EXIT CODES
To facilitate the use of
.I fetchmail
in shell scripts, an exit\ status code is returned to give an indication
of what occurred during a given connection.
.PP
The exit codes returned by
.I fetchmail
are as follows:
.IP 0
One or more messages were successfully retrieved (or, if the \-c option
was selected, were found waiting but not retrieved).
.IP 1
There was no mail awaiting retrieval.  (There may have been old mail still
on the server but not selected for retrieval.)
.IP 2
An error was encountered when attempting to open a socket to retrieve
mail.  If you don't know what a socket is, don't worry about it --
just treat this as an 'unrecoverable error'.  This error can also be
because a protocol fetchmail wants to use is not listed in /etc/services.
.IP 3
The user authentication step failed.  This usually means that a bad
user-id, password, or APOP id was specified.  Or it may mean that you
tried to run fetchmail under circumstances where it did not have
standard input attached to a terminal and could not prompt for a
missing password.
.IP 4
Some sort of fatal protocol error was detected.
.IP 5
There was a syntax error in the arguments to
.IR fetchmail .
.IP 6
The run control file had bad permissions.
.IP 7
There was an error condition reported by the server.  Can also
fire if
.I fetchmail
timed out while waiting for the server.
.IP 8
Client-side exclusion error.  This means
.I fetchmail
either found another copy of itself already running, or failed in such
a way that it isn't sure whether another copy is running.
.IP 9
The user authentication step failed because the server responded "lock
busy".  Try again after a brief pause!  This error is not implemented
for all protocols, nor for all servers.  If not implemented for your
server, "3" will be returned instead, see above.  May be returned when
talking to qpopper or other servers that can respond with "lock busy"
or some similar text containing the word "lock".
.IP 10
The
.I fetchmail
run failed while trying to do an SMTP port open or transaction.
.IP 11
Fatal DNS error.  Fetchmail encountered an error while performing
a DNS lookup at startup and could not proceed.
.IP 12
BSMTP batch file could not be opened.
.IP 13
Poll terminated by a fetch limit (see the \-\-fetchlimit option).
.IP 14
Server busy indication.
.IP 23
Internal error.  You should see a message on standard error with
details.
.IP 24 - 26, 28, 29
These are internal codes and should not appear externally.
.PP
When
.I fetchmail
queries more than one host, return status is 0 if \fIany\fR query
successfully retrieved mail. Otherwise the returned error status is
that of the last host queried.

.SH FILES
.TP 5
~/.fetchmailrc
default run control file
.TP 5
~/.fetchids
default location of file associating hosts with last message IDs seen
(used only with newer RFC1939-compliant POP3 servers supporting the
UIDL command).
.TP 5
~/.fetchmail.pid
lock file to help prevent concurrent runs (non-root mode).
.TP 5
~/.netrc
your FTP run control file, which (if present) will be searched for
passwords as a last resort before prompting for one interactively.
.TP 5
/var/run/fetchmail.pid
lock file to help prevent concurrent runs (root mode, Linux systems).
.TP 5
/etc/fetchmail.pid
lock file to help prevent concurrent runs (root mode, systems without /var/run).

.SH ENVIRONMENT
If the FETCHMAILUSER variable is set, it is used as the name of the
calling user (default local name) for purposes such as mailing error
notifications.  Otherwise, if either the LOGNAME or USER variable is
correctly set (e.g. the corresponding UID matches the session user ID)
then that name is used as the default local name.  Otherwise
\fBgetpwuid\fR(3) must be able to retrieve a password entry for the
session ID (this elaborate logic is designed to handle the case of
multiple names per userid gracefully).

If the environment variable FETCHMAILHOME is set to a valid and
existing directory name, fetchmail will read $FETCHMAILHOME/fetchmailrc
(the dot is missing in this case), $FETCHMAILHOME/.fetchids and
$FETCHMAILHOME/.fetchmail.pid rather than from the user's home
directory.  The .netrc file is always looked for in the the invoking
user's home directory regardless of FETCHMAILHOME's setting.

If the HOME_ETC variable is set, fetchmail will read
$HOME_ETC/.fetchmailrc instead of ~/.fetchmailrc.

If HOME_ETC and FETCHMAILHOME are set, HOME_ETC will be ignored.

.SH SIGNALS
If a
.I fetchmail
daemon is running as root, SIGUSR1 wakes it up from its sleep phase and
forces a poll of all non-skipped servers. For compatibility reasons,
SIGHUP can also be used in 6.3.X but may not be available in future
fetchmail versions.
.PP
If
.I fetchmail
is running in daemon mode as non-root, use SIGUSR1 to wake it (this is
so SIGHUP due to logout can retain the default action of killing it).
.PP
Running
.I fetchmail
in foreground while a background fetchmail is running will do
whichever of these is appropriate to wake it up.

.SH BUGS AND KNOWN PROBLEMS
.PP
Fetchmail cannot handle user names that contain blanks after a "@"
character, for instance "demonstr@ti on". These are rather uncommon and
only hurt when using UID-based \-\-keep setups, so the 6.3.X versions of
fetchmail won't be fixed.
.PP
Please check the \fBNEWS\fP file that shipped with fetchmail for more
known bugs than those listed here.
.PP
The assumptions that the DNS and in particular the checkalias options
make are not often sustainable. For instance, it has become uncommon for
an MX server to be a POP3 or IMAP server at the same time. Therefore the
MX lookups may go away in a future release.
.PP
The mda and plugin options interact badly.  In order to collect error
status from the MDA, fetchmail has to change its normal signal
handling so that dead plugin processes don't get reaped until the end
of the poll cycle.  This can cause resource starvation if too many
zombies accumulate.  So either don't deliver to a MDA using plugins or
risk being overrun by an army of undead.
.PP
The \-\-interface option does not support IPv6 and it is doubtful if it
ever will, since there is no portable way to query interface IPv6
addresses.
.PP
The RFC822 address parser used in multidrop mode chokes on some
@-addresses that are technically legal but bizarre.  Strange uses of
quoting and embedded comments are likely to confuse it.
.PP
In a message with multiple envelope headers, only the last one
processed will be visible to fetchmail.
.PP
Use of some of these protocols requires that the program send
unencrypted passwords over the TCP/IP connection to the mailserver.
This creates a risk that name/password pairs might be snaffled with a
packet sniffer or more sophisticated monitoring software.  Under Linux
and FreeBSD, the \-\-interface option can be used to restrict polling to
availability of a specific interface device with a specific local or
remote IP address, but snooping is still possible if (a) either host
has a network device that can be opened in promiscuous mode, or (b)
the intervening network link can be tapped.  We recommend the use of
.IR ssh (1)
tunnelling to not only shroud your passwords but encrypt the entire
conversation.
.PP
Use of the %F or %T escapes in an mda option could open a security
hole, because they pass text manipulable by an attacker to a shell
command.  Potential shell characters are replaced by '_' before
execution.  The hole is further reduced by the fact that fetchmail
temporarily discards any suid privileges it may have while running the
MDA.  For maximum safety, however, don't use an mda command containing
%F or %T when fetchmail is run from the root account itself.
.PP
Fetchmail's method of sending bounces due to errors or spam-blocking and
spam bounces requires that port 25 of localhost be available for sending
mail via SMTP.
.PP
If you modify a
.I ~/.fetchmailrc
while a background instance is running and break the syntax, the
background instance will die silently.  Unfortunately, it can't
die noisily because we don't yet know whether syslog should be enabled.
On some systems, fetchmail dies quietly even if there is no syntax
error; this seems to have something to do with buggy terminal ioctl
code in the kernel.
.PP
The \-f\~\- option (reading a configuration from stdin) is incompatible
with the plugin option.
.PP
The 'principal' option only handles Kerberos IV, not V.
.PP
Interactively entered passwords are truncated after 63 characters. If
you really need to use a longer password, you will have to use a
configuration file.
.PP
A backslash as the last character of a configuration file will be
flagged as a syntax error rather than ignored.
.PP
Send comments, bug reports, gripes, and the like to the
fetchmail\-devel list <fetchmail\-devel@lists.berlios.de>.  An HTML FAQ is
available at the fetchmail home page; surf to
http://fetchmail.berlios.de/ or do a WWW search for pages with
\&'fetchmail' in their titles.

.SH AUTHOR
Fetchmail is currently maintained by Matthias Andree and Rob Funk with
major assistance from Sunil Shetye (for code) and Rob MacGregor (for the
mailing lists).
.PP
Most of the code is from Eric S. Raymond <esr@snark.thyrsus.com>.  Too
many other people to name here have contributed code and patches.
.PP
This program is descended from and replaces
.IR popclient ,
by Carl Harris <ceharris@mal.com>; the internals have become quite different,
but some of its interface design is directly traceable to that
ancestral program.
.PP
This manual page has been improved by R.\ Hannes Beinert and H\['e]ctor
Garc\['i]a.

.SH SEE ALSO
mutt(1), elm(1), mail(1), sendmail(8), popd(8), imapd(8), netrc(5)

The fetchmail home page: <http://fetchmail.berlios.de/>

The maildrop home page: <http://www.courier-mta.org/maildrop/>
.SH APPLICABLE STANDARDS
.PP
Note that this list is just a collection of references and not a
statement as to the actual protocol conformance or requirements in
fetchmail.
.TP 5
SMTP/ESMTP:
RFC 821, RFC 2821, RFC 1869, RFC 1652, RFC 1870, RFC 1983, RFC 1985,
RFC 2554.
.TP 5
mail:
RFC 822, RFC 2822, RFC 1123, RFC 1892, RFC 1894.
.TP 5
POP2:
RFC 937
.TP 5
POP3:
RFC 1081, RFC 1225, RFC 1460, RFC 1725, RFC 1734, RFC 1939, RFC 1957,
RFC 2195, RFC 2449.
.TP 5
APOP:
RFC 1460, RFC 1725, RFC 1939.
.TP 5
RPOP:
RFC 1081, RFC 1225.
.TP 5
IMAP2/IMAP2BIS:
RFC 1176, RFC 1732.
.TP 5
IMAP4/IMAP4rev1:
RFC 1730, RFC 1731, RFC 1732, RFC 2060, RFC 2061, RFC 2195, RFC 2177,
RFC 2683.
.TP 5
ETRN:
RFC 1985.
.TP 5
ODMR/ATRN:
RFC 2645.
.TP 5
OTP:
RFC 1938.
.TP 5
LMTP:
RFC 2033.
.TP 5
GSSAPI:
RFC 1508.
.TP 5
TLS:
RFC 2595.
