/*
 * whois.c: Some tricky routines for querying the server for information
 * about a nickname using WHOIS.... all the time hiding this from the user.  
 *
 * Probably 99% of this file is obsolete now that we dont use 'whois' to
 * get userhost information (this method was required way back in 2.5/2.6
 * servers which didnt provide userhost info on each incoming line).  The
 * only thing that is still used is the USERHOST and ISON commands which 
 * are used for well, the /userhost and /ison commands.  Those things can
 * probably be handled in a better method then this hackery, and i may do
 * that.
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#if 0
static	char	rcsid[] = "@(#)$Id: whois.c,v 1.14 1994/07/02 02:32:13 mrg Exp $";
#endif

#undef MONITOR_Q /* this one is for monitoring of the 'whois queue' (debug) */

#include "irc.h"

#include "whois.h"
#include "hook.h"
#include "lastlog.h"
#include "vars.h"
#include "server.h"
#include "ignore.h"
#include "ircaux.h"
#include "notify.h"
#include "numbers.h"
#include "window.h"
#include "edit.h"
#include "output.h"
#include "parse.h"
#include "ctcp.h"

#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif

char	whois_nick[] = "#WHOIS#";
char	wait_nick[] = "#WAIT#";
char	redirect_nick[] = "#RED#";

/* current setting for BEEP_ON_MSG */
int	beep_on_level;

static	int	ignore_whois_crap = 0;
static	int	eat_away = 0;

/*
static	WhoisStuff whois_stuff =
{
	(char *) 0, (char *) 0, (char *) 0, (char *) 0, (char *) 0,
	(char *) 0, (char *) 0, (char *) 0, (char *) 0, 0, 0, 0
};
*/

/* WQ_head and WQ_tail point to the head and tail of the whois queue */
WhoisQueue *WQ_head = (WhoisQueue *) 0;
WhoisQueue *WQ_tail = (WhoisQueue *) 0;

static	char	show_away_flag = 0;

	void	typed_add_to_whois_queue _((int, char *, void (*foo)(), char *, ...));
	void	ison_notify _((char *, char *));



/* This does NOT belong here */
#ifdef __STDC__
extern void	set_beep_on_msg (char *str)
#else
extern void	set_beep_on_msg(str)
char	*str;
#endif
{
	beep_on_level = parse_lastlog_level(str);
	set_string_var(BEEP_ON_MSG_VAR, bits_to_lastlog_level(beep_on_level));
}

/*
 * whois_queue_head: returns the nickname at the head of the whois queue, or
 * NULL if the queue is empty.  It does not modify the queue in any way. 
 */
static char	*whois_queue_head _((void))
{
	if ((WQ_head = (WhoisQueue *) get_server_qhead(from_server)) != NULL)
		return (WQ_head->nick);
	else
		return ((char *) 0);
}

static int	whois_type_head _((void))
{
	if ((WQ_head = (WhoisQueue *) get_server_qhead(from_server)) != NULL)
		return (WQ_head->type);
	else
		return -1;
}

static void	(*whois_func_head()) _((void))
{
	if ((WQ_head=(WhoisQueue *) get_server_qhead(from_server)) != NULL)
		return (WQ_head->func);
	else
		return NULL;
}

/*
 * remove_from_whois_queue: removes the top element of the whois queue and
 * returns the element as its function value.  This routine repairs handles
 * all queue stuff, but the returned element is mallocd and must be freed by
 * the calling routine 
 */
static	WhoisQueue *remove_from_whois_queue _((void))
{
	WhoisQueue *new;

	new = (WhoisQueue *) get_server_qhead(from_server);
	set_server_qhead(from_server, new->next);
	if (new->next == (WhoisQueue *) 0)
		set_server_qtail(from_server, (WhoisQueue *) 0);
	return (new);
}

/*
 * clean_whois_queue: this empties out the whois queue.  This is used after
 * server reconnection to assure that no bogus entries are left in the whois
 * queue 
 */
extern void	clean_whois_queue _((void))
{
	WhoisQueue *thing;

	while (whois_queue_head())
	{
		thing = remove_from_whois_queue();
		new_free(&thing->nick);
		new_free(&thing->text);
		new_free((char **)&thing);
	}
	ignore_whois_crap = 0;
	eat_away = 0;
}

/* ison_returned: this is called when numeric 303 is received in
 * numbers.c. ISON must always be the property of the WHOIS queue.
 * Although we will check first that the top element expected is
 * actually an ISON.
 */
#ifdef __STDC__
extern void	ison_returned (char *from, char **ArgList)
#else
extern void	ison_returned(from, ArgList)
char	*from,
	**ArgList;
#endif
{
	WhoisQueue *thing;

	if (whois_type_head() == WHOIS_ISON)
	{
		thing = remove_from_whois_queue();
		thing->func(thing->nick, ArgList[0]? ArgList[0] : empty_string);
		new_free(&thing->nick);
		new_free(&thing->text);
		new_free((char **)&thing);
	}
	else
		ison_ison(NULL, ArgList[0] ? ArgList[0] : empty_string);
}


/*
 * got_my_userhost() -- DemoN suggested this clever approach to dealing
 * with dynamic IP addresses.  After you are connected to the server, you
 * simply ask the server what your userhost is, and that way you dont have
 * to worry about guessing wrong and messing up your dcc's! =)
 */
extern void got_my_userhost (WhoisStuff *stuff, char *nick, char *userhost)
{
	struct hostent *hp;

	/*
	 * We did this before when we started irc, but we went on the 
	 * assumption that gethostbyname(gethostname()) was correct.
	 * On dynamic SLIP machines, that assumption can be wrong, but
	 * we know right here and now that whatever the server tells us
	 * we are is really the way we should present ourselves to the
	 * world.  Got it?
	 */
	strmcpy(MyHostName, stuff->host, 79);
	strmcpy(hostname, stuff->host, NAME_LEN);
	if ((hp = gethostbyname(MyHostName)))
	{
		bcopy(hp->h_addr, (char *) &MyHostAddr, sizeof(MyHostAddr));
		local_ip_address.s_addr = ntohl(MyHostAddr.s_addr);
	}
#if 0
	yell("server said: %s", MyHostName);
#endif
}

/* userhost_returned: this is called when numeric 302 is received in
 * numbers.c. USERHOST must also remain the property of the WHOIS
 * queue. Sending it without going via the WHOIS queue will cause
 * the queue to become corrupted.
 *
 * While USERHOST gives us similar information to WHOIS, this routine's
 * format is a little different to those that handle the WHOIS numerics.
 * A list of nicks can be supplied to USERHOST, and any of those
 * nicks are not currently signed on, it will just omit reporting it.
 * this means we must go through the list of nicks returned and check
 * them for missing entries. This means stepping through the requested
 * nicks one at a time.
 *
 * A side effect of this is that user initiated USERHOST requests get
 * reported as separate replies even though one request gets made and
 * only one reply is actually received. This should make it easier for
 * people wanting to use USERHOST for their own purposes.
 *
 * In this routine, cnick points to all the information in the next
 * entry from the returned data.
 */
#ifdef __STDC__
extern void	userhost_returned (char *from, char **ArgList)
#else
extern void	userhost_returned(from, ArgList)
char	*from,
	**ArgList;
#endif
{
	WhoisQueue *thing;
	WhoisStuff *whois_stuff = NULL;
	char	*nick,
		*cnick = NULL,
		*tnick;
	char	*user,
		*cuser = (char *) 0;
	char	*host,
		*chost = (char *) 0;
	int	ishere,
		cishere = 1;
	int	isoper,
		cisoper = 0;
	int	noton,
		isuser,
		parsed;
	char	*queue_nicks;

	if (!ArgList[0])
		return;
	if (whois_type_head() == WHOIS_USERHOST)
	{
		isuser = (whois_func_head() == USERHOST_USERHOST);
		whois_stuff = get_server_whois_stuff(from_server);
		thing = remove_from_whois_queue();
		queue_nicks = thing->nick;
	}
	else
	{
		isuser = 1;
		thing = (WhoisQueue *) 0;
		queue_nicks = (char *) 0;
		whois_stuff = NULL;
	}
	parsed = 0;
	while ((parsed || (cnick = next_arg(ArgList[0], ArgList))) || queue_nicks)
	{
		if (queue_nicks)
		{
			tnick = next_arg(queue_nicks, &queue_nicks);
			if (!*queue_nicks)
				queue_nicks = (char *) 0;
		}
		else
			tnick = NULL;
		if (cnick && !parsed)
		{
			if (!(cuser = index(cnick,'=')))
				break;
			if (*(cuser - 1) == '*')
			{
				*(cuser - 1) = '\0';
				cisoper = 1;
			}
			else
				cisoper = 0;
			*cuser++ = '\0';
			if (*cuser++ == '+')
				cishere = 1;
			else
				cishere = 0;
			if (!(chost = index(cuser, '@')))
				break;
			*chost++ = '\0';
			parsed = 1;
		}
		if (!cnick || (tnick && my_stricmp(cnick, tnick)))
		{
			if (tnick)
				nick = tnick;
			else
				nick = cnick;
			user = host = "<UNKNOWN>";
			isoper = 0;
			ishere = 1;
			noton = 1;
		}
		else
		{
			nick = cnick;
			user = cuser;
			host = chost;
			isoper = cisoper;
			ishere = cishere;
			noton = parsed = 0;
		}
		if (!isuser)
		{
			malloc_strcpy(&whois_stuff->nick, nick);
			malloc_strcpy(&whois_stuff->user, user);
			malloc_strcpy(&whois_stuff->host, host);
			whois_stuff->oper = isoper;
			whois_stuff->not_on = noton;
			if (!ishere)
				malloc_strcpy(&whois_stuff->away, empty_string);
			else
				new_free(&whois_stuff->away);
			thing->func(whois_stuff, tnick, thing->text);
			new_free(&whois_stuff->away);
		}
		else
		{
			if (do_hook(current_numeric, "%s %s %s %s %s", nick,
			    isoper ? "+" : "-", ishere ? "+" : "-", user, host))
				put_it("%s %s is %s@%s%s%s", numeric_banner(),
					nick, user, host, isoper ?
					" (Is an IRC operator)" : empty_string,
					ishere ? empty_string : " (away)");
		}
	}
	if (thing)
	{
		new_free(&thing->nick);
		new_free(&thing->text);
		new_free((char **)&thing);
	}
}

/*
 * whois_name: routine that is called when numeric 311 is received in
 * numbers.c. This routine parses out the information in the numeric and
 * saves it until needed (see whois_server()).  If the whois queue is empty,
 * this routine simply displays the data in the normal fashion.  Why would
 * the queue ever be empty, you ask?  When the user uses the /whois or 
 * /whowas command, it is sent directly to the server, and the whois queue
 * does not have any part of it.
 */
#ifdef __STDC__
void	whois_name (char *from, char **ArgList)
#else
void	whois_name(from, ArgList)
char	*from;
char	**ArgList;
#endif
{
	char	*nick,
		*user,
		*host,
		*channel,
		*ptr,
		*name;
	WhoisStuff *whois_stuff;

	PasteArgs(ArgList, 4);
	nick = ArgList[0];
	user = ArgList[1];
	host = ArgList[2];
	channel = ArgList[3];
	name = ArgList[4];
	if (!nick || !user || !host || !channel || !name)
		return;
	whois_stuff = get_server_whois_stuff(from_server);
	if ((ptr = whois_queue_head()) &&
	    (whois_type_head() == WHOIS_WHOIS) &&
	    (my_stricmp(ptr, nick) == 0))
	{
		malloc_strcpy(&whois_stuff->nick, nick);
		malloc_strcpy(&whois_stuff->user, user);
		malloc_strcpy(&whois_stuff->host, host);
		malloc_strcpy(&whois_stuff->name, name);
		malloc_strcpy(&whois_stuff->channel, channel);
		new_free(&whois_stuff->away);
		whois_stuff->oper = 0;
		whois_stuff->chop = 0;
		whois_stuff->not_on = 0;
		ignore_whois_crap = 1;
		eat_away = 1;
	}
	else
	{
		ignore_whois_crap = 0;
		eat_away = 0;
		message_from((char *) 0, LOG_CRAP);
		if (do_hook(current_numeric, "%s %s %s %s %s %s", from, nick,
				user, host, channel, name))
			put_it("%s %s is %s@%s (%s)", numeric_banner(), nick,
					user, host, name);
	}
}

/*
 * whowas_name: same as whois_name() above but it is called with a numeric of
 * 314 when the user does a WHOWAS or when a WHOIS'd user is no longer on IRC 
 * and has set the AUTO_WHOWAS variable.
 */
#ifdef __STDC__
void	whowas_name (char *from, char **ArgList)
#else
void	whowas_name(from, ArgList)
char	*from;
char	**ArgList;
#endif
{
	char	*nick,
		*user,
		*host,
		*channel,
		*ptr,
		*name;
	WhoisStuff *whois_stuff;
	int	lastlog_level;

	PasteArgs(ArgList, 4);
	nick = ArgList[0];
	user = ArgList[1];
	host = ArgList[2];
	channel = ArgList[3];
	name = ArgList[4];
	if (!nick || !user || !host || !channel || !name)
		return;

	lastlog_level = set_lastlog_msg_level(LOG_CRAP);
	whois_stuff = get_server_whois_stuff(from_server);
	if ((ptr = whois_queue_head()) &&
	    (whois_type_head == WHOIS_WHOIS) &&
	    (my_stricmp(ptr, nick) == 0))
	{
		malloc_strcpy(&whois_stuff->nick, nick);
		malloc_strcpy(&whois_stuff->user, user);
		malloc_strcpy(&whois_stuff->host, host);
		malloc_strcpy(&whois_stuff->name, name);
		malloc_strcpy(&whois_stuff->channel, channel);
		new_free(&whois_stuff->away);
		whois_stuff->oper = 0;
		whois_stuff->chop = 0;
		whois_stuff->not_on = 1;
		ignore_whois_crap = 1;
	}
	else
	{
		ignore_whois_crap = 0;
		if (do_hook(current_numeric, "%s %s %s %s %s %s", from, nick,
				user, host, channel, name))
			put_it("%s %s was %s@%s (%s) on channel %s",
				numeric_banner(), nick, user, host, name,
				(*channel == '*') ? "*private*" : channel);
	}
	set_lastlog_msg_level(lastlog_level);
}

#ifdef __STDC__
void	whois_channels (char *from, char **ArgList)
#else
void	whois_channels(from, ArgList)
char	*from;
char	**ArgList;
#endif
{
	char	*ptr;
	char	*line;
	WhoisStuff *whois_stuff;

	PasteArgs(ArgList, 1);
	line = ArgList[1];
	whois_stuff = get_server_whois_stuff(from_server);
	if ((ptr = whois_queue_head()) &&
	    (whois_type_head() == WHOIS_WHOIS) &&
	    whois_stuff->nick &&
	    (my_stricmp(ptr, whois_stuff->nick) == 0))
	{
		if (whois_stuff->channels == (char *) 0)
			malloc_strcpy(&whois_stuff->channels, line);
		else
			malloc_strcat(&whois_stuff->channels, line);
	}
	else
	{
		if (do_hook(current_numeric, "%s %s", from, line))
			put_it("%s on channels: %s", numeric_banner(), line);
	}
}

/*
 * whois_server: Called in numbers.c when a numeric of 312 is received.  If
 * all went well, this routine collects the needed information, pops the top
 * element off the queue and calls the function as described above in
 * WhoisQueue.  It then releases all the mallocd data.  If the queue is empty
 * (same case as described in whois_name() above), the information is simply
 * displayed in the normal fashion. Added a check to see if whois_stuff->nick
 * is NULL. This can happen if something is added to an empty whois queue
 * between the whois name being received and the server.
 */
#ifdef __STDC__
void	whois_server (char *from, char **ArgList)
#else
void	whois_server(from, ArgList)
char	*from;
char	**ArgList;
#endif
{
	char	*server,
		*ptr;
	char	*line;
	WhoisStuff *whois_stuff;

	show_away_flag = 1;
	if (!ArgList[0] || !ArgList[1])
		return;
	if (ArgList[2])
	{
		server = ArgList[1];
		line = ArgList[2];
	}
	else
	{
		server = ArgList[0];
		line = ArgList[1];
	}
	whois_stuff = get_server_whois_stuff(from_server);
	if ((ptr = whois_queue_head()) &&
	    (whois_type_head() == WHOIS_WHOIS) &&
	    whois_stuff->nick && /* This is *weird* */
	(my_stricmp(ptr, whois_stuff->nick) == 0))
	{
		malloc_strcpy(&whois_stuff->server, server);
		malloc_strcpy(&whois_stuff->server_stuff, line);
	}
	else
	{
		if (do_hook(current_numeric, "%s %s %s", from, server, line))
			put_it("%s on irc via server %s (%s)",
				numeric_banner(), server, line);
	}
}

/*
 * whois_oper: This displays the operator status of a user, as returned by
 * numeric 313 from the server.  If the ignore_whois_crap flag is set,
 * nothing is dispayed. 
 */
#ifdef __STDC__
void	whois_oper (char *from, char **ArgList)
#else
void	whois_oper(from, ArgList)
char	*from;
char	**ArgList;
#endif
{
	WhoisStuff *whois_stuff;

	whois_stuff = get_server_whois_stuff(from_server);
	if (ArgList[1])
		PasteArgs(ArgList, 1);
	else
	{
		yell("Odd server stuff from %s: %s", from, ArgList[0]);
		return;	/* fake */
	}

	if (ignore_whois_crap)
		whois_stuff->oper = 1;
	else
	{
		char	*nick;

		if ((nick = ArgList[0]) != NULL)
		{
			if (do_hook(current_numeric, "%s %s %s", from, nick, ArgList[1]))
				put_it("%s %s %s%s", numeric_banner(), nick, ArgList[1], 
#ifdef COMPAT_27
					(server_list[from_server].version > Server2_7) ? 
#endif
						empty_string 
#ifdef COMPAT_27
						: " (is an IRC operator)"
#endif
					);
		}
	}
}

#ifdef __STDC__
void	whois_lastcom (char *from, char **ArgList)
#else
void	whois_lastcom(from, ArgList)
char	*from;
char	**ArgList;
#endif
{
	if (!ignore_whois_crap)
	{
		char	flag, *nick, *idle_str, *startup_str;
		int	idle;
		time_t	startup;

		nick = ArgList[0];
		idle_str = ArgList[1];
		startup_str = ArgList[2];

		if (ArgList[3])	/* undernet */
		{
			PasteArgs(ArgList, 3);
			if (nick && idle_str && do_hook(current_numeric, "%s %s %s %s %s",
						from, nick, idle_str, startup_str, ArgList[3]))
			{
				if ((idle = atoi(idle_str)) > 59)
				{
					idle = idle/60;
					flag = 1;
				}
				else
					flag = 0;
				if ((startup = atol(startup_str)) != 0)
				{
					char *blah_kludge = ctime(&startup);
					blah_kludge[strlen(blah_kludge)-1] = 0;
					put_it ("%s %s has been idle %d %ss, signed on at %s",
						numeric_banner(), nick, idle, 
						flag?"minute":"second",blah_kludge);
				}
				else
					put_it("%s %s has been idle %d %ss", 
						numeric_banner(), nick, idle, 
						flag? "minute": "second");
			}
		}
		else	/* efnet */
		{
			PasteArgs(ArgList, 1);
			if (nick && idle_str && do_hook(current_numeric, "%s %s %s",
						from, nick, idle_str))
			{
				if ((idle = atoi(idle_str)) > 59)
				{
					idle = idle/60;
					flag = 1;
				}
				else
					flag = 0;
				put_it ("%s %s has been idle %d %ss,",
					numeric_banner(), nick, idle, 
					flag?"minute":"second");
			}
		}
	}
}

#ifdef __STDC__
void	end_of_whois (char *from, char **ArgList)
#else
void	end_of_whois(from, ArgList)
char	*from;
char	**ArgList;
#endif
{
	char	*nick;
	char	*ptr;
	WhoisStuff *whois_stuff;

	whois_stuff = get_server_whois_stuff(from_server);

	show_away_flag = 0;
	if ((nick = ArgList[0]) != NULL)
	{
		ptr = whois_queue_head();
		if (ptr && (whois_type_head() == WHOIS_WHOIS) &&
		    (my_stricmp(ptr, nick) == 0))
		{
			WhoisQueue *thing;

			thing = remove_from_whois_queue();
			whois_stuff->not_on = 0;
			thing->func(whois_stuff, thing->nick, thing->text);
			new_free(&whois_stuff->channels);
			new_free(&thing->nick);
			new_free(&thing->text);
			new_free((char **)&thing);
			ignore_whois_crap = 0;
			return;
		}
		PasteArgs(ArgList, 0);
		if (do_hook(current_numeric, "%s %s", from, ArgList[0]))
			if (get_int_var(SHOW_END_OF_MSGS_VAR))
				display_msg(from, ArgList);
	}
}

/*
 * no_such_nickname: Handler for numeric 401, the no such nickname error. If
 * the nickname given is at the head of the queue, then this routine pops the
 * top element from the queue, sets the whois_stuff->flag to indicate that the
 * user is no longer on irc, then calls the func() as normal.  It is up to
 * that function to set the ignore_whois_crap variable which will determine
 * if any other information is displayed or not. 
 *
 * that is, it used to.  now it does bugger all, seeing all the functions that
 * used to use it, now use no such command.  -phone, april 1993.
 */
#ifdef __STDC__
void	no_such_nickname (char *from, char **ArgList)
#else
void	no_such_nickname(from, ArgList)
char	*from,
	**ArgList;
#endif
{
	char	*nick;

	if (ArgList[1])
		PasteArgs(ArgList, 1);
	else
	{
		yell("Odd server stuff from %s: %s", from, ArgList[0]);
		return;
	}

	nick = ArgList[0];
	if (do_hook(current_numeric, "%s %s %s", from, nick, ArgList[1]))
		put_it("%s %s: %s", numeric_banner(), nick, ArgList[1]);
	notify_mark(nick, 0, 0);
	if (get_int_var(AUTO_WHOWAS_VAR))
	{
		int foo;
		if ((foo = get_int_var(NUM_OF_WHOWAS_VAR) > -1))
			send_to_server("WHOWAS %s %d", nick, foo);
		else
			send_to_server("WHOWAS %s", nick);
	}
}

/*
 * user_is_away: called when a 301 numeric is received.  Nothing is displayed
 * by this routine if the ignore_whois_crap flag is set 
 */
#ifdef __STDC__
void	user_is_away (char *from, char **ArgList)
#else
void	user_is_away(from, ArgList)
char	*from,
	**ArgList;
#endif
{
static	char	   *last_away_msg = (char *) 0,
		   *last_away_nick = (char *) 0;
	char	   *message,
		   *who;
	WhoisStuff *whois_stuff;

	if (!from)
		return;

	if (ArgList[1])
		PasteArgs(ArgList, 1);
	else
	{
		yell("Odd server stuff from %s: %s", from, ArgList[0]);
		return;
	}

	whois_stuff = get_server_whois_stuff(from_server);

	if ((who = ArgList[0]) && (message = ArgList[1]))
	{
		if (whois_stuff->nick && (!strcmp(who, whois_stuff->nick)) && eat_away)
			malloc_strcpy(&whois_stuff->away, message);
		else
		{
			if (!show_away_flag && get_int_var(SHOW_AWAY_ONCE_VAR))
			{
				if (!last_away_msg || strcmp(last_away_nick, from) || strcmp(last_away_msg, message))
				{
					malloc_strcpy(&last_away_nick, from);
					malloc_strcpy(&last_away_msg, message);
				}
				else return;
			}
			if (do_hook(current_numeric, "%s %s", who, message))
				put_it("%s %s is away: %s",numeric_banner(), who, message);
		}
		eat_away = 0;
	}
}

#ifdef __STDC__
void	ison_notify (char *AskedFor, char *AreOn)
#else
void	ison_notify(AskedFor, AreOn)
char	*AskedFor;
char	*AreOn;
#endif
{
	char	*NextAsked;
	char	*NextGot;

	NextGot = next_arg(AreOn, &AreOn);
	while ((NextAsked = next_arg(AskedFor, &AskedFor)) != NULL)
	{
		if (NextGot && !my_stricmp(NextAsked, NextGot))
		{
			notify_mark(NextAsked, 1, 1);
			NextGot = next_arg(AreOn, &AreOn);
		}
		else
			notify_mark(NextAsked, 0, 1);
	}
}

/*
 * whois_notify: used by the routines in notify.c to tell when someone has
 * signed on or off irc 
 */
#ifdef __STDC__
void	whois_notify (WhoisStuff *stuff, char *nick, char *text)
#else
void	whois_notify(stuff, nick, text)
WhoisStuff *stuff;
char	*nick;
char	*text;
#endif
{
	int	level;

	level = set_lastlog_msg_level(LOG_CRAP);
	if (stuff)
		notify_mark(stuff->nick, 1, 1);
	else
		notify_mark(nick, 0, 1);
	set_lastlog_msg_level(level);
}

/*
 * add_to_whois_queue: This routine is called whenever you want to do a WHOIS
 * or WHOWAS.  What happens is this... each time this function is called it
 * adds a new element to the whois queue using the nick and func as in
 * WhoisQueue, and creating the text element using the format and args.  It
 * then issues the WHOIS or WHOWAS.  
 */
#if defined(__STDC__) && defined(HAVE_STDARG_H)
void add_to_whois_queue (char *nick, void (*func)(), char *format, ...)
#else
void	add_to_whois_queue(nick, func, format, arg1, arg2,
		arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10)
void	(*func) ();
char	*format,
	*nick;
char	*arg1, *arg2, *arg3, *arg4, *arg5,
	*arg6, *arg7, *arg8, *arg9, *arg10;
#endif
{
	int	Type;

	if (func == USERHOST_USERHOST || func == userhost_cmd_returned)
		Type = WHOIS_USERHOST;
	else
		Type = WHOIS_WHOIS;

	if (format)
	{
#if defined(__STDC__) && defined(HAVE_STDARG_H)
		char 	blah[1024];
		va_list arglist;
		va_start (arglist, format);
		vsprintf(blah, format, arglist);
		va_end(arglist);
		typed_add_to_whois_queue(Type, nick, func, "%s", blah);
#else	
		typed_add_to_whois_queue(Type, nick, func, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
#endif
	}
}

#ifdef __STDC__
void	add_ison_to_whois (char *nick, void (*func)())
#else
void	add_ison_to_whois(nick, func)
void	(*func) ();
char	*nick;
#endif
{
	typed_add_to_whois_queue(WHOIS_ISON, nick, func, (char *) 0);
}

#ifdef __STDC__
void	add_userhost_to_whois (char *nick, void (*func)())
#else
void	add_userhost_to_whois(nick, func)
char	*nick;
void	(*func)();
#endif
{
	typed_add_to_whois_queue(WHOIS_USERHOST, nick, func, (char *) 0);
}

#if defined(__STDC__) && defined(HAVE_STDARG_H)
void	typed_add_to_whois_queue (int type, char *nick, void (*func)(), char *format, ...)
#else
void	typed_add_to_whois_queue(type, nick, func, format,
		arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10)
void	(*func) ();
char	*format,
	*nick;
int	type;
char	*arg1, *arg2, *arg3, *arg4, *arg5, 
	*arg6, *arg7, *arg8, *arg9, *arg10;
#endif
{
	char	buffer[BIG_BUFFER_SIZE + 1];
	WhoisQueue *new;

	if ((nick == (char *) 0) || ! is_server_connected(from_server))
		return;

	if (index(nick, '*') == (char *) 0)
	{
		new = (WhoisQueue *) new_malloc(sizeof(WhoisQueue));
		new->text = (char *) 0;
		new->nick = m_strdup(nick);
		new->func = func;
		new->next = (WhoisQueue *) 0;
		new->type = type;

		if (format)
		{
#if defined(__STDC__) && defined(HAVE_STDARG_H)
			va_list args;
			va_start(args, format);
			vsprintf(buffer, format, args);
			va_end(args);
#else
			sprintf(buffer, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
#endif
			new->text = m_strdup(buffer);
		}
		if ((void *) get_server_qhead(from_server) == (void *) 0)
			set_server_qhead(from_server, new);
		if (get_server_qtail(from_server))
			((WhoisQueue *) get_server_qtail(from_server))->next = new;
		set_server_qtail(from_server, new);
		switch(type)
		{
		case WHOIS_ISON:
#ifdef MONITOR_Q
			put_it("+++ ISON %s", nick);
#endif
			send_to_server("ISON %s", nick);
			break;
		case WHOIS_USERHOST:
#ifdef MONITOR_Q
			put_it("+++ USERHOST %s", nick);
#endif
			send_to_server("USERHOST %s", nick);
			break;
		case WHOIS_WHOIS:
#ifdef MONITOR_Q
			put_it("+++ WHOIS %s", nick);
#endif
			send_to_server("WHOIS %s", nick);
			break;
		case WHOIS_WHOWAS:
#ifdef MONITOR_Q
			put_it("+++ WHOIS %s", nick);
#endif
			send_to_server("WHOWAS %s", nick);
			break;
		}
	}
}

#ifdef __STDC__
extern	void	userhost_cmd_returned (WhoisStuff *stuff, char *nick, char *text)
#else
extern	void	userhost_cmd_returned(stuff, nick, text)
WhoisStuff	*stuff;
char 	*nick;
char 	*text;
#endif
{
	char	args[BIG_BUFFER_SIZE + 1];

	strcpy(args, stuff->nick ? stuff->nick : empty_string);
	strcat(args, stuff->oper ? " + " : " - ");
	strcat(args, stuff->away ? "+ " : "- ");
	strcat(args, stuff->user ? stuff->user : empty_string);
	strcat(args, space);
	strcat(args, stuff->host ? stuff->host : empty_string);
	parse_line((char *) 0, text, args, 0, 0);
}
