/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999, 2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#include "config.h"

#ifdef HAVE_ESETROOT_SUPPORT
#include <X11/Xlib.h>
#include <X11/Xatom.h>

/* following two functions are taken from Gnome
 * background-properties-capplet sources and bit
 * modified just to honour same rules
 * this code have copyright
 *
 * Background display property module.
 * (C) 1997 the Free Software Foundation
 * (C) 2000 Helix Code, Inc.
 * (C) 1999, 2000 Red Hat, Inc.
 *
 * Authors: Miguel de Icaza.
 *          Federico Mena.
 *          Radek Doulik
 *          Michael Fulbright
 *          Justin Maurer
 *          Owen Taylor
 */

/* Create a persistant pixmap. We create a separate display
 * and set the closedown mode on it to RetainPermanent
 */
static Pixmap gnomecc_make_root_pixmap (width, height)
int width;
int height;
{
	Pixmap result;
	Display *display;

	gdk_flush ();

	display = XOpenDisplay (gdk_display_name);
	XSetCloseDownMode (display, RetainPermanent);

	result = XCreatePixmap (display,
		DefaultRootWindow (display),
		width, height,
		DefaultDepthOfScreen (DefaultScreenOfDisplay (GDK_DISPLAY())));

	XCloseDisplay (display);

	return result;
}

/* Set the root pixmap, and properties pointing to it. We
 * do this atomically with XGrabServer to make sure that
 * we won't leak the pixmap if somebody else it setting
 * it at the same time. (This assumes that they follow the
 * same conventions we do
 */
static void gnomecc_set_root_pixmap (dpy, win, pixmap)
Display *dpy;
Window win;
Pixmap pixmap;
{
	GdkAtom type;
	gulong nitems, bytes_after;
	gint format;
	guchar *data_esetroot;
	int result;

	XGrabServer (dpy);

	result = XGetWindowProperty (dpy, win,
		     gdk_atom_intern("ESETROOT_PMAP_ID", FALSE),
		     0L, 1L, False, XA_PIXMAP,
		     &type, &format, &nitems, &bytes_after,
		     &data_esetroot);

	if (result == Success && type == XA_PIXMAP &&
	    format == 32 && nitems == 1) {
		XKillClient(GDK_DISPLAY(), *(Pixmap*)data_esetroot);
	}

	if (data_esetroot != NULL) {
		XFree (data_esetroot);
	}

	if (pixmap != None) {
		XChangeProperty (dpy, win,
				 gdk_atom_intern("ESETROOT_PMAP_ID", FALSE), 
				 XA_PIXMAP, 32, PropModeReplace,
				 (guchar *) &pixmap, 1);
		XChangeProperty (dpy, win,
				 gdk_atom_intern("_XROOTPMAP_ID", FALSE), 
				 XA_PIXMAP, 32, PropModeReplace,
				 (guchar *) &pixmap, 1);

		XSetWindowBackgroundPixmap (dpy, win, pixmap);
	} else {
		XDeleteProperty (dpy, win,
				 gdk_atom_intern("ESETROOT_PMAP_ID", FALSE));
		XDeleteProperty (dpy, win,
				 gdk_atom_intern("_XROOTPMAP_ID", FALSE));
	}

	XClearWindow (dpy, win);
	XUngrabServer (dpy);

	XFlush(dpy);
}

void esetroot_pixmap_property(root_window, p, w, h, prop)
GdkWindow *root_window;
GdkPixmap *p;
guint w,h;
prop_t *prop;
{
	Pixmap esetroot_pixmap = None;
	GdkGC *gc;

	if (p == NULL)
		gnomecc_set_root_pixmap(GDK_DISPLAY(), GDK_ROOT_WINDOW(), None);
  
	if (root_window)
	{
		gc = gdk_gc_new(root_window);
		gdk_color_alloc(gdk_colormap_get_system(), &prop->background);
		gdk_gc_set_foreground(gc, &prop->background);
		gdk_colormap_free_colors(gdk_colormap_get_system(),
				&prop->background, 1);
		esetroot_pixmap = gnomecc_make_root_pixmap(w, h);
		XCopyArea(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(p), esetroot_pixmap,
				GDK_GC_XGC(gc), 0, 0, w, h, 0, 0);
		gdk_gc_unref(gc);
		gnomecc_set_root_pixmap(GDK_DISPLAY(), GDK_ROOT_WINDOW(),
				esetroot_pixmap);
	}
}
#endif /* HAVE_ESETROOT_SUPPORT */
