# This is the bcfg2 support for yum
'''This provides bcfg2 support for yum'''
__revision__ = '$Revision: 2814 $'

import Bcfg2.Client.Tools.RPM, ConfigParser, sys

YAD = True
CP = ConfigParser.ConfigParser()
try:
    if '-C' in sys.argv:
        CP.read([sys.argv[sys.argv.index('-C') + 1]])
    else:
        CP.read(['/etc/bcfg2.conf'])
    if CP.get('Yum', 'autodep') == 'false':
        YAD = False
except:
    pass

class Yum(Bcfg2.Client.Tools.RPM.RPM):
    '''Support for Yum packages'''
    pkgtype = 'yum'
    if YAD:
        pkgtool = ("/usr/bin/yum -d0 -y install %s", ("%s-%s", ["name", "version"]))
    else:
        pkgtool = ("/usr/bin/yum -d0 install %s", ("%s-%s", ["name", "version"]))
    __name__ = 'Yum'
    __execs__ = ['/usr/bin/yum', '/var/lib/rpm']
    __handles__ = [('Package', 'yum'), ('Package', 'rpm')]
    __req__ = {'Package': ['name', 'version']}
    __ireq__ = {'Package': ['name', 'version']}
    conflicts = ['RPM']

    def RemovePackages(self, packages):
        '''Remove specified entries'''
        pkgnames = [pkg.get('name') for pkg in packages]
        rmcmd = "yum -d0 -y remove %s" % " ".join(pkgnames)
        if len(pkgnames) > 0:
            self.logger.info("Removing packages: %s" % pkgnames)
            if self.cmd.run(rmcmd)[0] == 0:
                self.modified += packages
            self.RefreshPackages()
            self.extra = self.FindExtraPackages()

    def VerifyPackage(self, entry, modlist):
        if entry.get('version') == 'noverify':
            return self.installed.has_key(entry.get('name'))
        return Bcfg2.Client.Tools.RPM.RPM.VerifyPackage(self, entry, modlist)
