/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.FormattingSerializer;
import netscape.util.Sort;
import netscape.util.VectorEnumerator;

public class Vector
implements Cloneable,
Codable {
    Object[] array;
    int count;
    static final String ARRAY_KEY = "array";

    public Vector() {
        this.count = 0;
    }

    public Vector(int n) {
        this.array = new Object[n];
        this.count = 0;
    }

    public Object clone() {
        Vector vector;
        try {
            vector = (Vector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error in clone(). This shouldn't happen.");
        }
        if (this.count == 0) {
            vector.array = null;
            return vector;
        }
        vector.array = new Object[this.count];
        System.arraycopy(this.array, 0, vector.array, 0, this.count);
        return vector;
    }

    public int count() {
        return this.count;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void addElementIfAbsent(Object object) {
        if (object == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (object != null && !this.contains(object)) {
            this.addElement(object);
        }
    }

    public boolean insertElementBefore(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (object2 == null) {
            return false;
        }
        int n = this.indexOf(object2);
        if (n == -1) {
            return false;
        }
        this.insertElementAt(object, n);
        return true;
    }

    public boolean insertElementAfter(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (object2 == null) {
            return false;
        }
        int n = this.indexOf(object2);
        if (n == -1) {
            return false;
        }
        if (n >= this.count - 1) {
            this.addElement(object);
        } else {
            this.insertElementAt(object, n + 1);
        }
        return true;
    }

    public void addElementsIfAbsent(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.count();
        int n2 = 0;
        while (n2 < n) {
            Object object = vector.elementAt(n2);
            if (!this.contains(object)) {
                this.addElement(object);
            }
            ++n2;
        }
    }

    public void addElements(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.count();
        if (this.array == null || this.count + n >= this.array.length) {
            this.ensureCapacity(this.count + n);
        }
        int n2 = 0;
        while (n2 < n) {
            this.addElement(vector.elementAt(n2));
            ++n2;
        }
    }

    public void removeAll(Object object) {
        int n = this.count();
        while (n-- > 0) {
            if (!this.elementAt(n).equals(object)) continue;
            this.removeElementAt(n);
        }
    }

    public Object removeFirstElement() {
        if (this.count == 0) {
            return null;
        }
        return this.removeElementAt(0);
    }

    public Object removeLastElement() {
        if (this.count == 0) {
            return null;
        }
        return this.removeElementAt(this.count - 1);
    }

    public Object replaceElementAt(int n, Object object) {
        if (object == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.count);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " < 0");
        }
        Object object2 = this.elementAt(n);
        this.array[n] = object;
        return object2;
    }

    public Object[] elementArray() {
        Object[] objectArray = new Object[this.count];
        if (this.count > 0) {
            System.arraycopy(this.array, 0, objectArray, 0, this.count);
        }
        return objectArray;
    }

    public void copyInto(Object[] objectArray) {
        if (this.count > 0) {
            System.arraycopy(this.array, 0, objectArray, 0, this.count);
        }
    }

    public void trimToSize() {
        if (this.count == 0) {
            this.array = null;
            return;
        }
        if (this.count != this.array.length) {
            this.array = this.elementArray();
        }
    }

    public void ensureCapacity(int n) {
        if (this.array == null) {
            this.array = new Object[8];
        }
        if (n < this.array.length) {
            return;
        }
        int n2 = this.array.length < 8 ? 8 : this.array.length;
        while (n2 < n) {
            n2 = 2 * n2;
        }
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.array, 0, objectArray, 0, this.count);
        this.array = objectArray;
    }

    public int capacity() {
        if (this.array == null) {
            return 0;
        }
        return this.array.length;
    }

    public Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public Enumeration elements(int n) {
        return new VectorEnumerator(this, n);
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) != -1;
    }

    public boolean containsIdentical(Object object) {
        return this.indexOfIdentical(object, 0) != -1;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(Object object, int n) {
        int n2 = n;
        while (n2 < this.count) {
            if (this.array[n2].equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOfIdentical(Object object, int n) {
        int n2 = n;
        while (n2 < this.count) {
            if (this.array[n2] == object) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOfIdentical(Object object) {
        return this.indexOfIdentical(object, 0);
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.count);
    }

    public int lastIndexOf(Object object, int n) {
        if (n > this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " > " + this.count);
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.array[n2].equals(object)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public Object elementAt(int n) {
        if (n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.count);
        }
        return this.array[n];
    }

    public Object firstElement() {
        if (this.count == 0) {
            return null;
        }
        return this.array[0];
    }

    public Object lastElement() {
        if (this.count == 0) {
            return null;
        }
        return this.array[this.count - 1];
    }

    public void setElementAt(Object object, int n) {
        if (n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.count);
        }
        if (object == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        this.array[n] = object;
    }

    public Object removeElementAt(int n) {
        if (n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.count);
        }
        Object object = this.array[n];
        int n2 = this.count - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.array, n + 1, this.array, n, n2);
        }
        --this.count;
        this.array[this.count] = null;
        return object;
    }

    public void insertElementAt(Object object, int n) {
        if (n >= this.count + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.count);
        }
        if (object == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (this.array == null || this.count >= this.array.length) {
            this.ensureCapacity(this.count + 1);
        }
        System.arraycopy(this.array, n, this.array, n + 1, this.count - n);
        this.array[n] = object;
        ++this.count;
    }

    public void addElement(Object object) {
        if (object == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (this.array == null || this.count >= this.array.length) {
            this.ensureCapacity(this.count + 1);
        }
        this.array[this.count] = object;
        ++this.count;
    }

    public boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n < 0) {
            return false;
        }
        this.removeElementAt(n);
        return true;
    }

    public boolean removeElementIdentical(Object object) {
        int n = this.indexOfIdentical(object, 0);
        if (n < 0) {
            return false;
        }
        this.removeElementAt(n);
        return true;
    }

    public void removeAllElements() {
        int n = 0;
        while (n < this.count) {
            this.array[n] = null;
            ++n;
        }
        this.count = 0;
    }

    public void sort(boolean bl) {
        Sort.sort((Object[])this.array, null, (int)0, (int)this.count, (boolean)bl);
    }

    public void sortStrings(boolean bl, boolean bl2) {
        Sort.sortStrings((Object[])this.array, (int)0, (int)this.count, (boolean)bl, (boolean)bl2);
    }

    public String toString() {
        return FormattingSerializer.serializeObject((Object)this);
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.util.Vector", 1);
        classInfo.addField(ARRAY_KEY, (byte)19);
    }

    public void encode(Encoder encoder) throws CodingException {
        if (this.count == 0) {
            return;
        }
        encoder.encodeObjectArray(ARRAY_KEY, this.array, 0, this.count);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.array = decoder.decodeObjectArray(ARRAY_KEY);
        if (this.array == null) {
            this.count = 0;
            return;
        }
        this.count = this.array.length;
    }

    public void finishDecoding() throws CodingException {
    }
}

