// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Implement the ldap_compare functions
//
// - Automatic Version Information via RCS:
//   $Id: compare.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/compare.cxx,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "ldapapi.h"
#include <ldap-int.h>

#ifndef lint
// mark object with version info
static const char vcid[] = "@(#) $Id: compare.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $";
static const char vcHid[] = __LDAP_OPENH323_H;
#endif

int ldap_compare_ext (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *attr, 
		      LDAP_CONST struct berval *bvalue, LDAPControl **serverctrls,
		      LDAPControl **clientctrls, int *msgidp) {
  LDAP_LDAPMessage msg;
  *msgidp=++(ld->msg_id);
  msg.m_messageID=*msgidp;
  msg.m_protocolOp=LDAP_LDAPMessage_protocolOp(LDAP_LDAPMessage_protocolOp::e_compareDNRequest);

  LDAP_CompareRequest &cmp=msg.m_protocolOp;

  cmp.m_entry=dn;
  cmp.m_ava.m_attributeType=attr;
  cmp.m_ava.m_attributeValue.SetValue(PASN_OctetString(bvalue->bv_val,bvalue->bv_len));
  

  PBER_Stream encoding_stream;
  msg.Encode(encoding_stream);
  if(encoding_stream.Write(*(ld->socket))) {
    return LDAP_SUCCESS;
  }
  ld->ld_errno=LDAP_UNAVAILABLE;
  return ld->ld_errno;
}

int ldap_compare_ext_s (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *attr,
			LDAP_CONST struct berval *bvalue, LDAPControl **serverctrls,
			LDAPControl **clientctrls) {
  int msgid,
    rv;
  LDAPMessage *result;
  
  rv=ldap_compare_ext(ld, dn, attr, bvalue, serverctrls, clientctrls, &msgid);
  if(LDAP_SUCCESS!=rv) {
    ld->ld_errno=rv;
    return rv;
  }
  if (-1== (rv=ldap_result( ld, msgid, 1, NULL, &result )) ) {
    return( ld->ld_errno );	/* ldap_result sets ld_errno */
  }
  return rv;
}



int ldap_compare (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *attr, 
		  LDAP_CONST char *value) {
  int msgid;
  int rv;
  
  struct berval bval;
  
  bval.bv_len=strlen(value);
  bval.bv_val=strndup(value,bval.bv_len);

  rv=ldap_compare_ext(ld, dn, attr, &bval, NULL, NULL, &msgid);
  
  if(LDAP_SUCCESS!=rv){
    ld->ld_errno=rv;
    return -1;
  }
  return msgid;
}


int ldap_compare_s (LDAP *ld, LDAP_CONST char *dn,  LDAP_CONST char *attr,
		    LDAP_CONST char *value) {
  int msgid,rv;
  LDAPMessage *result;
  if(-1==(msgid=ldap_compare(ld, dn, attr, value)))
    return ld->ld_errno;
  
  if (-1== (rv=ldap_result( ld, msgid, 1, NULL, &result )) ) {
    return( ld->ld_errno );	/* ldap_result sets ld_errno */
  }
  return rv;
}
  
//
// End of compare.cxx
//
