%define name netsaint
%define version 0.0.7
%define release 1
%define nsusr netsaint
%define nsgrp netsaint
%define cmdusr nobody
%define cmdgrp nobody

%global init_dir %(init_dir=/etc/rc.d/init.d; if test -d /etc/rc.d/init.d; then init_dir="/etc/rc.d/init.d"; elif test -d /usr/local/etc/rc.d; then init_dir="/usr/local/etc/rc.d"; elif test -d /etc/rc.d; then init_dir="/etc/rc.d"; elif test -d /etc/init.d; then init_dir="/etc/init.d"; elif test -d /sbin/init.d; then init_dir="/sbin/init.d"; fi; echo $init_dir)
%global startup_script %{init_dir}/netsaint


Summary: Host/service/network monitoring program
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Application/System
Source0: %{name}-%{version}.tar.gz
#Patch0: %{name}-%{version}-%{release}.patch
BuildRoot: %{_tmppath}/%{name}-buildroot
Prefix: %{_prefix}
Prefix: /etc/rc.d/init.d
Prefix: /etc/init.d
Prefix: /etc/netsaint
Prefix: /var/log/netsaint
Prefix: /var/spool/netsaint
Requires: gd > 1.8

%description
NetSaint is a program that will monitor hosts and services on your
network. It has the ability to email or page you when a problem arises
and when a problem is resolved. NetSaint is written in C and is
designed to run under Linux (and some other *NIX variants) as a
background process, intermittently running checks on various services
that you specify.

The actual service checks are performed by separate "plugin" programs
which return the status of the checks to NetSaint. The plugins are
available at http://sourceforge.net/projects/netsaintplug

This package provide core programs for netsaint. The web interface,
documentation, and development files are built as separate packages


%package www
Group: Application/System
Summary: Provides the HTML and CGI files for the Netsaint web interface.

%description www
NetSaint is a program that will monitor hosts and services on your
network. It has the ability to email or page you when a problem arises
and when a problem is resolved. NetSaint is written in C and is
designed to run under Linux (and some other *NIX variants) as a
background process, intermittently running checks on various services
that you specify.

Several CGI programs are included with NetSaint in order to allow you
to view the current service status, problem history, notification
history, and log file via the web. This package provides the HTML and
CGI files for the Netsaint web interface. In addition, HTML
documentation is included in this package


%package devel
Group: Application/System
Summary: Provides include files that Netsaint-related applications may compile against.

%description devel
NetSaint is a program that will monitor hosts and services on your
network. It has the ability to email or page you when a problem arises
and when a problem is resolved. NetSaint is written in C and is
designed to run under Linux (and some other *NIX variants) as a
background process, intermittently running checks on various services
that you specify.

This package provides include files that Netsaint-related applications
may compile against.


%prep
%setup -q
#%patch -p1
mv contrib/htaccess.sample .


%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" \
./configure \
	--with-cgiurl=/netsaint/cgi-bin \
	--with-htmurl=/netsaint \
	--with-lockfile=/var/run/netsaint.pid \
	--with-netsaint-user=%{nsusr} \
	--with-netsaint-grp=%{nsgrp} \
	--with-command-user=%{cmdusr} \
	--with-command-grp=%{cmdgrp} \
	--prefix=%{_prefix} \
	--exec-prefix=%{_prefix}/sbin \
	--bindir=%{_prefix}/sbin \
	--sbindir=%{_prefix}/lib/netsaint/cgi \
	--libexecdir=%{_prefix}/lib/netsaint/plugins \
	--datadir=%{_prefix}/share/netsaint \
	--sysconfdir=/etc/netsaint \
	--localstatedir=/var/log/netsaint
make all
mv netsaint.cfg netsaint.tmp
sed -e 's=/var/log/netsaint/rw/=/var/spool/netsaint/=' netsaint.tmp > netsaint.cfg
cd contrib
make


%install
install -d -m 0775 ${RPM_BUILD_ROOT}/var/spool/netsaint
install -d -m 0755 ${RPM_BUILD_ROOT}%{_prefix}/include/netsaint
install -d -m 0755 ${RPM_BUILD_ROOT}/etc/rc.d/init.d
install -d -m 0755 ${RPM_BUILD_ROOT}/etc/init.d
install -d -m 0755 ${RPM_BUILD_ROOT}/etc/httpd/conf
make DESTDIR=${RPM_BUILD_ROOT} INSTALL_OPTS="" COMMAND_OPTS="" install
make DESTDIR=${RPM_BUILD_ROOT} INSTALL_OPTS="" COMMAND_OPTS="" install-commandmode
make DESTDIR=${RPM_BUILD_ROOT} INSTALL_OPTS="" COMMAND_OPTS="" INIT_OPTS="" install-daemoninit
make DESTDIR=${RPM_BUILD_ROOT} INSTALL_OPTS="" COMMAND_OPTS="" CGICFGDIR=/etc/netsaint install-config
cp test.cfg ${RPM_BUILD_ROOT}/etc/netsaint
install -m 0644 common/locations.h ${RPM_BUILD_ROOT}%{_prefix}/include/netsaint
cp htaccess.sample ${RPM_BUILD_ROOT}/etc/httpd/conf/netsaint-httpd.conf
cd contrib; make INSTALL=install INSTALL_OPTS="" CGIDIR=${RPM_BUILD_ROOT}%{_prefix}/lib/netsaint/cgi install
%global initscript %(find %{_tmppath}/%{name}-buildroot/etc/ -name netsaint -type f | sed 's=%{_tmppath}/%{name}-buildroot==')


%postun
if [ $1 = 0 ]; then
   if [ `egrep "^%{nsusr}:" /etc/passwd | wc -l` = 1 ]; then
      /usr/sbin/userdel %{nsusr}
   fi
   if [ `egrep "^%{nsgrp}:" /etc/group | wc -l` = 1 ]; then
      /usr/sbin/groupdel %{nsgrp}
   fi
fi


%pre
if [ `egrep "^%{nsusr}:" /etc/passwd | wc -l` = 0 ]; then
	/usr/sbin/useradd -d /var/log/netsaint -s /bin/sh -c "%{nsusr}" %{nsusr}
fi
initscript=`find /etc/ -name netsaint -type f`
if [ -n $initscript ]; then
	if [ -f /var/lock/subsys/netsaint ]; then
		$initscript stop
	elif [ -f /var/run/netsaint.pid ]; then
		$initscript stop
	elif [ -f /var/log/netsaint/netsaint.lock ]; then
		$initscript stop
	fi
fi


%preun
initscript=`find /etc/ -name netsaint -type f`
if [ $1 = 0 ]; then
	if [ -f /var/lock/subsys/netsaint ]; then
		$initscript stop
	elif [ -f /var/run/netsaint.pid ]; then
  	$initscript stop
	elif [ -f /var/log/netsaint/netsaint.lock ]; then
		$initscript stop
	fi
	if test -x /sbin/chkconfig; then
		/sbin/chkconfig --del netsaint
	fi
fi


%post
initscript=`find /etc/ -name netsaint -type f`
$initscript start
if test -x /sbin/chkconfig; then
	/sbin/chkconfig --add netsaint
fi


%post www
cmdgrp=`awk '/^[ \t]*Group[ \t]+[a-zA-Z0-9]+/ {print $2}' /etc/httpd/conf/*.conf`
if test -z "$cmdgrp"; then
  cmdgrp=%{cmdgrp}
fi
if test -f /etc/httpd/conf/httpd.conf; then
	if ! grep "Include /etc/httpd/conf/netsaint-httpd.conf" /etc/httpd/conf/httpd.conf >> /dev/null; then
		echo "Include /etc/httpd/conf/netsaint-httpd.conf" >> /etc/httpd/conf/httpd.conf
		/etc/rc.d/init.d/httpd reload
	fi
fi


%preun www
if test -f /etc/httpd/conf/httpd.conf; then
	TEMPFILE=`mktemp /etc/httpd/conf/httpd.conf.tmp.XXXXXX`
	if grep "^ *Include /etc/httpd/conf/netsaint-httpd.conf" /etc/httpd/conf/httpd.conf >> /dev/null; then
		grep -v "^ *Include /etc/httpd/conf/netsaint-httpd.conf" /etc/httpd/conf/httpd.conf > $TEMPFILE
		mv $TEMPFILE /etc/httpd/conf/httpd.conf
		chmod 664 /etc/httpd/conf/httpd.conf
		/etc/rc.d/init.d/httpd reload
  fi
fi


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(755,root,root)
%init_dir/netsaint
%dir /etc/netsaint
%{_prefix}/sbin/netsaint

%defattr(644,root,root)
%config(noreplace) /etc/netsaint/hosts.cfg
%config(noreplace) /etc/netsaint/netsaint.cfg
%config(noreplace) /etc/netsaint/nscgi.cfg
%config(noreplace) /etc/netsaint/test.cfg
%config(noreplace) /etc/netsaint/commands.cfg

%defattr(640,root,%{nsgrp})
%config(noreplace) /etc/netsaint/resource.cfg

%defattr(755,%{nsusr},%{nsgrp})
%dir /var/log/netsaint
%dir /var/log/netsaint/archives

%defattr(775,%{nsusr},%{cmdgrp})
%dir /var/spool/netsaint

%doc Changelog INSTALL LICENSE README UPGRADING htaccess.sample


%files www
%defattr(755,root,root)
%dir %{_prefix}/lib/netsaint/cgi
%{_prefix}/lib/netsaint/cgi/*
%dir %{_prefix}/share/netsaint
%defattr(-,root,root)
%{_prefix}/share/netsaint/*
%config(noreplace) /etc/httpd/conf/netsaint-httpd.conf


%files devel
%defattr(-,root,root)
%dir %{_prefix}/include/netsaint
%{_prefix}/include/netsaint/locations.h


%changelog
* Wed Jan 17 2001 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.7a5-1)
- switch from /usr/libexec to /usr/lib because linux FHS has no libexec
- use global macro to set location of init script
- fold htaccess.sample into contrib directory of tarball

* Fri Nov 03 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6-1)
- Rebuild with final sources

* Wed Sep 06 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6b5-1)
- Create separate cgi, html, and devel packages
- Include commands.cfg

* Sun Aug 27 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6b5-1)
- beta 5

* Sun Jul 23 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6b3-2)
- fixes for daemon-init, multi-OS RPM building

* Wed Jul 12 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6b3-1)
- beta 3

* Sun Jun 25 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6b2-3)
- true beta2 sources

* Sat Jun 24 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6b2-2)
- cleanup spec, still using pre-beta2 sources

* Sat Jun 24 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6b2-1)
- mandrake merge using pre-beta2 sources (many thanks to Stefan van der Eijk <s.vandereijk@chello.nl>)

* Wed Jun 14 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6b1-1)
- add stylesheet diffs

* Mon Jun 12 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.6b1-1)
- adapt for 0.0.6b1

* Mon Jun 05 2000 Karl DeBisschop <kdebisschop@users.sourceforge.net> (0.0.5-4)
- add traceroute.cgi and htaccess.sample
- move placement of docs (in files) to avoid group warnings
- change www user and group to nobody and add warning

* Mon Jun 05 2000 Karsten Weiss <knweiss@gmx.de> (0.0.5-3)
- official group name
- improved user detection

* Tue Oct 19 1999 Mike McHenry <mmchen@minn.net) (0.0.4-2)
- Fixed init.d scripts to better fit new Redhat init.d script formats

* Fri Sep 03 1999 Mike McHenry <mmchen@minn.net> (0.0.4-1)
- Upgraded package from 0.0.4b4 to 0.0.4

* Mon Aug 16 1999 Mike McHenry <mmchen@minn.net>
- First RPM build (0.0.4b4)
