/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

/*
 * URLInterface
 * Author Thomas "temas" Muldowney <temas@jabber.org>
 */

#ifndef INCL_URL_INTERFACE_HH
#define INCL_URL_INTERFACE_HH

#include "jabberoo.hh"

#include "BaseGabberWindow.hh"
#include "RosterView.hh"
#include "MessageManager.hh"
#include "MessageViews.hh"

#include <gnome--.h>

/*******************
* Recv dialog
*******************/
class URLRecvView :
    public MessageView,
    public BaseGabberDialog
{
public:
    URLRecvView(const jabberoo::Message& m, ViewMap& vm);
    URLRecvView(const std::string& jid, ViewMap& vm);
    ~URLRecvView();

    static void init_view(MessageManager& m);
    static MessageView* new_view_msg(const jabberoo::Message& m, ViewMap& vm);
    static MessageView* new_view_jid(const std::string& jid, ViewMap& vm);
protected:
    void render(const jabberoo::Message& m);
    
    void on_Close_clicked();

    void init(std::string jid);
private:
    Gtk::Label*             _lblDesc;
};

#endif // INCL_FT_INTERFACE_HH
