/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

#ifndef INCL_GABBER_WIDGETS_HH
#define INCL_GABBER_WIDGETS_HH

#include "jabberoo.hh"

#include <gdk/gdk.h>
#include <gtk/gtkselection.h>
#include <gtk--/box.h>
#include <gtk--/eventbox.h>
#include <gtk--/label.h>
#include <gtk--/tooltips.h>
#include <gnome--/pixmap.h>

class PrettyJID
     : public Gtk::EventBox
{
public:
     enum DisplayType 
     { dtNick, dtNickRes, dtJID, dtJIDRes, dtNickJID, dtNickJIDRes };

     PrettyJID(const string& jid, const string& nickname = "", DisplayType dt = dtJID, int display_limit = 0);

     void set_display_type(DisplayType dt, int display_limit = 0);
     void show_label(bool show_label);
     void show_pixmap(bool show_pixmap);
     const string get_nickname() const;
protected:
     bool is_displaying_jid();
     void on_presence(const jabberoo::Presence& p, const jabberoo::Presence::Type prev);
     void on_evtShow_drag_data_received(GdkDragContext* drag_ctx, gint x, gint y, GtkSelectionData* data, guint info, guint time);
     void on_evtShow_drag_data_get(GdkDragContext* drag_ctx, GtkSelectionData* data, guint info, guint time);
     void on_evtShow_drag_begin(GdkDragContext* drag_ctx);
private:
     string _jid;
     string _nickname;
     string _resource;
     string _default_jid;
     string _pix_path;

     Gtk::HBox*     _hboxPJ;
     Gtk::EventBox* _evtMusic;
     Gnome::Pixmap* _pixMusic;
     Gtk::Label*    _lblPJ;
     Gnome::Pixmap* _pixPJ;
     Gtk::Tooltips  _tips;

     DisplayType _display_type;
};

#endif
