/********************************************************************************
 *   Jabberoo/Judo -- C++ Jabber Library                                        *
 *                                                                              * 
 *   Copyright (C) 1999-2000 Dave Smith (dave@jabber.org)                       *
 *                                                                              *
 *   This library is free software; you can redistribute it and/or              *
 *   modify it under the terms of the GNU Lesser General Public                 *
 *   License as published by the Free Software Foundation; either               *
 *   version 2.1 of the License, or (at your option) any later version.         *
 *                                                                              *
 *   This library is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          *
 *   Lesser General Public License for more details.                            *
 *                                                                              *
 *   You should have received a copy of the GNU Lesser General Public           *
 *   License along with this library; if not, write to the Free Software        *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 ********************************************************************************
 */

#include "judo.hh"

// *************************************************************************
//
// Judo::CDATA
//
// *************************************************************************

using namespace judo;

const string& CDATA::getText() const
{
     return _text;
}

void CDATA::setText(const char* text, unsigned int textSz)
{
     unescape(text, textSz, _text);
}

void CDATA::appendText(const char* text, unsigned int textSz)
{
     unescape(text, textSz, _text, true);
}

string CDATA::getXML() const
{    
    return escape(_text);
}

CDATA::CDATA(const char* text, unsigned int textSz) 
    : Element("#CDATA", etCDATA)
{
     setText(text, textSz);
}

