<?
################################################################
# Config data
################################################################
 
  $apg_title = "Automated Password Generator Online" ;

  $generator     = "/usr/local/bin/apg -q" ; # APG location
  #
  # Default options
  #
  $default_sl            = "y";  # Use small letters symbol set. Define "n" if not.
  $default_cl            = "y";  # Use capital letters symbol set. Define "n" if not.
  $default_nb            = "y";  # Use numeral symbol set. Define "n" if not.
  $default_ss            = "y";  # Use special symbol set. Define "n" if not.
  $default_algo          = "2";  # 1-random. 2-pronounceable.
  $default_numofpass     = "6";  # default number of passwords to generate. Up to 255.
  $default_minpasslength = "6";  # default minimum password length. Up to 255.
  $default_maxpasslength = "8";  # default maximum password length. Up to 255.
  $default_clseed        = "";   # default command line seed.

  $print_command_line = "true" ; # define it to something else to
                                 # disable command line printing

  $color1    = "#99FFCC" ;       # color to hilight blocks
  $color2    = "#0000FF" ;       # color to hilight headers
  $color3    = "#E9E9E9" ;       # color to hilight output
  $color4    = "#33CCFF" ;       # color to hilight save settings block

  ###########################
  # Standard HTML Page colors
  #
  $c_bgcolor = "#FFFFFF" ;
  $c_text    = "#000000" ;
  $c_link    = "#0000FF" ;
  $c_vlink   = "#000080" ;
  $c_alink   = "#FF0000" ;

  include ('english.php');     # language settings
################################################################
# End of Config data
################################################################

#################
# Cookie analyzer
# d is delimiter
#
  if (isset($apg_online_cky) && (!$save_settings)) {
     $tok = strtok ($apg_online_cky,"d");
     $i = 0;
     while ($tok) {
        if (($tok == "2") && ($i == "0")) $default_algo = "2";
        if (($tok == "1") && ($i == "0")) $default_algo = "1";
        if (($tok == "l") && ($i == "1")) $default_sl = "y";
	else if (($tok != "l") && ($i == "1")) $default_sl = "n";
        if (($tok == "c") && ($i == "2")) $default_cl = "y";
	else if (($tok != "c") && ($i == "2")) $default_cl = "n";
        if (($tok == "n") && ($i == "3")) $default_nb = "y";
	else if (($tok != "n") && ($i == "3")) $default_nb = "n";
        if (($tok == "s") && ($i == "4")) $default_ss = "y";
	else if (($tok != "n") && ($i == "4")) $default_ss = "n";
        if ((is_numeric($tok)) && ($i == "5")) $default_numofpass = $tok;
        if ((is_numeric($tok)) && ($i == "6")) $default_minpasslength = $tok;
        if ((is_numeric($tok)) && ($i == "7")) $default_maxpasslength = $tok;
	$i = $i + 1;
        $tok = strtok ("d");
	}
     $i = 0;
     }


###########
# Algorithm
#
if (!$algo) $algo = $default_algo;
switch ($algo)
   {
    case "1":
       $generator = $generator . " -a 1";
       $cookie_text = $cookie_text . "1d";
       break;
    case "2":
       $generator = $generator . " -a 0";
       $cookie_text = $cookie_text . "2d";
       break;
    case "":
       $algo = $default_algo;
       $cookie_text = $cookie_text . $algo . "d";
       break;
    default:
       break;
   }

############
# Symbolsets
#
  $genmode = " -M ";
  if (!$sl) $sl = $default_sl;
  switch($sl)
     {
      case "y":
         $genmode = $genmode . "l";
         $cookie_text = $cookie_text . "ld";
         break;
      case "n":
         $cookie_text = $cookie_text . "ed";
         break;
      case "":
         $sl = $default_sl;
         $cookie_text = $cookie_text . $sl . "d";
         break;
      default:
         break;
     }
  if (!$cl) $cl = $default_cl;
  switch($cl)
     {
      case "y":
         $genmode = $genmode . "c";
         $cookie_text = $cookie_text . "cd";
         break;
      case "n":
         $cookie_text = $cookie_text . "ed";
         break;
      case "":
         $cl = $default_cl;
         $cookie_text = $cookie_text . $cl . "d";
         break;
      default:
         break;
     }
  if (!$nb) $nb = $default_nb;
  switch($nb)
     {
      case "y":
         $genmode = $genmode . "n";
         $cookie_text = $cookie_text . "nd";
         break;
      case "n":
         $cookie_text = $cookie_text . "ed";
         break;
      case "":
         $nb = $default_nb;
         $cookie_text = $cookie_text . $nb . "d";
         break;
      default:
         break;
     }
  if (!$ss) $ss = $default_ss;
  switch($ss)
     {
      case "y":
         $genmode = $genmode . "s";
         $cookie_text = $cookie_text . "sd";
         break;
      case "n":
         $cookie_text = $cookie_text . "ed";
         break;
      case "":
         $ss = $default_ss;
         $cookie_text = $cookie_text . $ss . "d";
         break;
      default:
         break;
     }
  if ($genmode != " -M ")
     $generator = $generator . $genmode;

###############################
# Number of passwords parameter
#
  if (!$numofpass) {
     $numofpass = $default_numofpass;
     $generator= $generator . " -n " . $numofpass;
     $cookie_text = $cookie_text . $numofpass . "d";
     }
  else if (is_numeric($numofpass)) {
     if ($numofpass >= "255") {
        $numofpass = "255";
        $generator= $generator . " -n " . $numofpass;
	$cookie_text = $cookie_text . $numofpass . "d";
	}         
     else {
        $generator= $generator . " -n " . $numofpass;
	$cookie_text = $cookie_text . $numofpass . "d";
	}
     }
  else {
     $numofpass = $default_numofpass;
     $generator= $generator . " -n " . $numofpass;
     $cookie_text = $cookie_text . $numofpass . "d";
     }

###################################
# Minimum password length parameter
#
  if (!$minpasslength) {
     $minpasslength = $default_minpasslength;
     $generator= $generator . " -m " . $minpasslength;
     $cookie_text = $cookie_text . $minpasslength . "d";
     }
  else if (is_numeric($minpasslength)) {
     if ($minpasslength >= "255") {
        $minpasslength = "255";
        $generator= $generator . " -m " . $minpasslength;
	$cookie_text = $cookie_text . $minpasslength . "d";
	}
     else {
        $generator= $generator . " -m " . $minpasslength;
	$cookie_text = $cookie_text . $minpasslength . "d";
	}
     }
  else {
     $minpasslength = $default_minpasslength;
     $generator= $generator . " -m " . $minpasslength;
     $cookie_text = $cookie_text . $minpasslength . "d";
     }

###################################
# Maximum password length parameter
#
  if (!$maxpasslength) {
     $maxpasslength = $default_maxpasslength;
     $generator= $generator . " -x " . $maxpasslength;
     $cookie_text = $cookie_text . $maxpasslength . "d";
     }
  else if (is_numeric($maxpasslength)) {
     if ($maxpasslength >= "255") {
        $maxpasslength = "255";
        $generator= $generator . " -x " . $maxpasslength;
	$cookie_text = $cookie_text . $maxpasslength . "d";
	}
     else {
        $generator= $generator . " -x " . $maxpasslength;
	$cookie_text = $cookie_text . $maxpasslength . "d";
	}
     }
  else {
     $maxpasslength = $default_maxpasslength;
     $generator= $generator . " -x " . $maxpasslength;
     $cookie_text = $cookie_text . $maxpasslength . "d";
     }

#############
# Random seed
#
  if (!$clseed) {
     $clseed = $default_clseed;
     }
  else {
     #
     # base64_encode() is used for security reasons
     #
     $generator = $generator . " -c " . base64_encode($clseed);
     }

###############
# Save settings
#
if ($save_settings == "s") {
   setcookie("apg_online_cky");
   setcookie("apg_online_cky", "$cookie_text");
   }
else if ($save_settings == "r") setcookie("apg_online_cky");

###############################################################
  print "<html>";
  print "<head>";
  print "<title>$apg_title</title>";
  print "</head>";
  print "<body body bgcolor=\"$c_bgcolor\" text=\"$c_text\" link=\"$c_link\" vlink=\"$c_vlink\" alink=\"$c_alink\">";
  $passwords = `$generator`;
  $outpasswords = htmlspecialchars($passwords , ENT_QUOTES);                                                                                           
  print "<center>";
  print " <h1>$apg_title</h1>";
  print "</center>";
  print "<center>";
  print "<form method=\"post\" action=\"$PHP_SELF\" name=\"main\">";
  print "<table bgcolor=\"#FFFFFF\" cellspacing=0 border=0>";
  # row 1
  print "<tr>";
  print "<td><font color=\"$color2\"><b>$message_algorithm</b></font></td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td><font color=\"$color2\"><b>$message_symbol_sets</b></font></td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "</tr>";
  # row 1
  print "<tr>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td>$message_yes</td>";
  print "<td>$message_no</td>";
  print "</tr>";
  # row 2
  print "<tr>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_pronounceable</td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" name=\"algo\" value=\"2\"";
          if ($algo == "2") print " checked"; print"></td>";
  print "<td>&nbsp;</td>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_small_lerrers</td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" value=\"y\" name=\"sl\"";
          if ($sl=="y") print " checked"; print "></td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" value=\"n\" name=\"sl\"";
          if ($sl=="n") print " checked"; print "></td>";
  print "</tr>";
  # row 3
  print "<tr>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_random</td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" name=\"algo\" value=\"1\"";
          if ($algo == "1") print " checked"; print"></td>";
  print "<td>&nbsp;</td>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_cap_letters</td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" value=\"y\" name=\"cl\"";
          if ($cl=="y") print " checked"; print "></td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" value=\"n\" name=\"cl\"";
          if ($cl=="n") print " checked"; print "></td>";
  print "</tr>";
  # row 4
  print "<tr>";
  print "<td><font color=\"$color2\"><b>$message_amount_length</b></font></td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_numbers</td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" value=\"y\" name=\"nb\"";
          if ($nb=="y") print " checked"; print "></td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" value=\"n\" name=\"nb\"";
          if ($nb=="n") print " checked"; print "></td>";
  print "</tr>";
  # row 5
  print "<tr>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_num_of_pass</td>";
  print "<td bgcolor=\"$color1\"><input type=\"text\" value=\"$numofpass\" name=\"numofpass\" size=\"3\" maxlength=\"3\"> <i>($submessage_up_to)</i></td>";
  print "<td>&nbsp;</td>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_spec_symbols</td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" value=\"y\" name=\"ss\"";
          if ($ss=="y") print " checked"; print "></td>";
  print "<td bgcolor=\"$color1\"><input type=\"radio\" value=\"n\" name=\"ss\"";
          if ($ss=="n") print " checked"; print "></td>";
  print "</tr>";
  # row 6
  print "<tr>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_min_pass_len</td>";
  print "<td bgcolor=\"$color1\"><input type=\"text\" value=\"$minpasslength\" name=\"minpasslength\" size=\"3\" maxlength=\"3\"> <i>($submessage_up_to)</i></td>";
  print "<td>&nbsp;</td>";
  print "<td><font color=\"$color2\"><b>$message_user_random_seed</b></font></tr>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "</tr>";
  # row 7
  print "<tr>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_max_pass_len</td>";
  print "<td bgcolor=\"$color1\"><input type=\"text\" value=\"$maxpasslength\" name=\"maxpasslength\" size=\"3\" maxlength=\"3\"> <i>($submessage_up_to)</i></td>";
  print "<td>&nbsp;</td>";
  print "<td bgcolor=\"$color1\">&nbsp;&nbsp;&nbsp;&nbsp;$submessage_seed</td>";
  print "<td colspan=\"2\" bgcolor=\"$color1\"><input type=\"text\" value=\"$clseed\" name=\"clseed\" size=\"8\" maxlength=\"8\"></td>";
  print "</tr>";
  # row 8
  print "<tr>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "</tr>";

  # row 9
  print "<tr bgcolor=\"$color4\">";
  print "<td>$message_remove_saved</td>";
  print "<td><input type=\"radio\" value=\"r\" name=\"save_settings\"></td>";
  print "<td>&nbsp;</td>";
  print "<td>$message_save_settings</td>";
  print "<td colspan=\"2\"><input type=\"radio\" value=\"s\" name=\"save_settings\"></td>";
  print "</tr>";
  # row 10
  print "<tr>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td><input type=\"submit\" value=\"$submit_button_text\"></td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "<td>&nbsp;</td>";
  print "</tr>";
  print "</table>";
  print "</form>";
  print "</center>";
  print "<hr>";
  if ($print_command_line == "true")
     {
      print "<center>";
      print "<font size=\"+2\" color=\"#FF0000\"><b>$message_command_line</b>";
      print "<hr>";
      print "<table width=\"100%\" bgcolor=\"$color3\">";
      print "<tr><td>";
      print "<tt><b>";
      print $generator;
      print "</b></tt>";
      print "</tr></td>";
      print "</table>";
      print "</center>";
      print "<hr>";
     }
  print "<center>";
  print "<font size=\"+2\" color=\"#FF0000\"><b>$message_generated_pass</b>";
  print "</center>";
  print "<hr>";
  print "<center>";
  print "<table width=\"100%\"bgcolor=\"$color3\" halign=\"left\" valign=\"center\">";
  print "<tr>";
  print "<td>";
  print "<tt><pre>";
  print $outpasswords;
  print "</pre></tt>";
  print "</td>";
  print "</tr>";
  print "</table>";
  print "</center>";
  print "<hr>";

  ################
  # Copyright data
  #
  print "<font size=\"-3\" color=\"$color3\">Copyright (c) 2001 Adel I. Mirzazhanov<br>";
  print "<a href=\"http://www.adel.nursat.kz/apg\">APG Homepage</a></font>";
  print "</body>";
  print "</html>";
?>
