/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-math.h,v 1.4 2000/02/20 13:07:42 rich Exp $
 */

#ifndef __xracer_math_h__
#define __xracer_math_h__

#include <GL/gl.h>

#include <math.h>

/* Some of these functions have been inlined. I only inline
 * functions based on evidence from profiling the code as a
 * whole or where the function is so simple that the overhead
 * of calling it is larger than the inlined code. Excessive
 * inlining can itself cause performance problems, particularly
 * on modern processors which are very good at making jumps
 * function calls.
 *   - RWMJ.
 */

extern GLfloat xrI[16];		/* The identity matrix. */

extern void xrIdentityMatrix (GLfloat *m);
extern void    xrMakeRotationMatrix (GLfloat angle,
				     GLfloat x, GLfloat y, GLfloat z,
				     GLfloat *m);
extern void    xrMatrixMultiply (const GLfloat *a, const GLfloat *b,
				 GLfloat *product);

extern void xrMatrixVectorMultiply (const GLfloat *m, const GLfloat *v,
				    GLfloat *result);

extern GLfloat xrMagnitude (const GLfloat *v);
extern GLfloat xrMagnitude2d (const GLfloat *v);

extern void xrNormalize (const GLfloat *v, GLfloat *r);
extern void xrNormalize2d (const GLfloat *v, GLfloat *r);

extern void xrUnitNormalToSide (GLfloat *side, GLfloat *normal);

extern GLfloat xrDotProduct (const GLfloat *v1, const GLfloat *v2);
extern GLfloat xrMagnitudeInDirection (const GLfloat *v1, const GLfloat *v2);

/* Compute angle between two vectors. */
extern GLfloat xrAngleBetween (const GLfloat *v1, const GLfloat *v2);

extern void    xrMidpoint (const GLfloat *p1, const GLfloat *p2, GLfloat *mp);
extern void    xrMidpoint2d (const GLfloat *p1, const GLfloat *p2, GLfloat *mp);
extern void    xrCrossProduct (const GLfloat *v, const GLfloat *w, GLfloat *r);
extern GLfloat xrDistance (const GLfloat *p, const GLfloat *q);

/* Distance from a point to a plane. */
extern GLfloat xrDistancePointToPlane (const GLfloat *plane,
				       const GLfloat *point);
extern int xrPointInsidePlane (const GLfloat *plane, const GLfloat *point);

extern GLfloat xrDistancePointToLine (const GLfloat *point,
				      const GLfloat *line_point,
				      const GLfloat *line_vector);

extern void    xrPlaneCoefficients (const GLfloat *p, const GLfloat *q,
				    const GLfloat *r, GLfloat *co);

#endif /* __xracer_math_h__ */
