/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: common.h,v 1.5 2000/03/19 23:48:47 rich Exp $
 */

#ifndef __track_simple2_common_h__
#define __track_simple2_common_h__

#include "xracer-track.h"
#include "xracer-log.h"
#include "xracer-texture.h"

#include <GL/gl.h>

/* Variables created by automatic track-building tools. */
extern struct xrTrackBSPNode *track_root;
extern struct xrTrackFace track_faces[];
extern int nr_track_faces;
extern struct xrTrackEnterPlane enterplanes[];
extern int nr_enterplanes;

/* Functions created by automatic track-building tools. */
extern int obj_load (void);
extern void obj_unload (void);

/* Sky functions. */
extern int sky_load (void);
extern void sky_unload (void);
extern void sky_display (const GLfloat *posn);

/* Backdrop functions. */
extern int backdrop_load (void);
extern void backdrop_unload (void);
extern void backdrop_display (const GLfloat *posn);

/* Lens flare functions. */
extern int flare_load (void);
extern void flare_unload (void);
extern void flare_display (const struct xrPlayer *player);

#include "objects.h"

#endif /* __track_simple2_common_h__ */
