/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: powerup.c,v 1.2 2000/01/01 17:37:49 rich Exp $
 */

#include "config.h"

#include <GL/gl.h>

#include "xracer.h"
#include "xracer-powerup.h"
#include "xracer-player.h"
#include "xracer-log.h"
#include "xracer-texture.h"

/* Powerups are stored as textures, mapped onto a quad.
 * We use the display list when displaying the powerup.
 */
static int powerup_tex[XR_MAX_POWERUP+1];

static int powerup_dl[XR_MAX_POWERUP+1];

/* Program-level initializations. */
void
xrPowerupInit ()
{
  int i, x, y;

  powerup_tex[1] = xrTextureLoad ("powerups/faster.jpg",
				  "powerups/faster-alpha.jpg",
				  0, 0, 0);
  powerup_tex[2] = xrTextureLoad ("powerups/energy.jpg",
				  "powerups/energy-alpha.jpg",
				  0, 0, 0);
  powerup_tex[3] = xrTextureLoad ("powerups/shield.jpg",
				  "powerups/shield-alpha.jpg",
				  0, 0, 0);
  powerup_tex[4] = xrTextureLoad ("powerups/autopilot.jpg",
				  "powerups/autopilot-alpha.jpg",
				  0, 0, 0);
  powerup_tex[5] = xrTextureLoad ("powerups/cannon.jpg",
				  "powerups/cannon-alpha.jpg",
				  0, 0, 0);
  powerup_tex[6] = xrTextureLoad ("powerups/missile.jpg",
				  "powerups/missile-alpha.jpg",
				  0, 0, 0);

  x = xrWidth/2 - 32;
  y = xrHeight - 64 - 32;

  for (i = 1; i <= XR_MAX_POWERUP; ++i)
    {
      /* Generate the display list. */
      powerup_dl[i] = glGenLists (1);

      glNewList (powerup_dl[i], GL_COMPILE);

      glBindTexture (GL_TEXTURE_2D, powerup_tex[i]);

      glBegin (GL_QUADS);
      /* glColor4f (0, 0, 0, 1); */
      glTexCoord2f (0, 0);
      glVertex2i (x, y);
      glTexCoord2f (0, 1);
      glVertex2i (x, y + 64);
      glTexCoord2f (1, 1);
      glVertex2i (x + 64, y + 64);
      glTexCoord2f (1, 0);
      glVertex2i (x + 64, y);
      glEnd ();

      glEndList ();
    }
}

/* This is called when a game starts. */
void
xrPowerupStartGame ()
{
}

/* This is called to do cleanup when a game ends. */
void
xrPowerupEndGame ()
{
}

/* This is called once per frame to update the display. */
void
xrPowerupDisplay (const struct xrPlayer *player)
{
  int powerup = xrPlayerGetPowerup (player);

  if (powerup != XR_NO_POWERUP)
    {
      glEnable (GL_TEXTURE_2D);
#if 0
      glPushMatrix();
      glScalef (1, 1, 0);
#endif
      glCallList (powerup_dl[powerup]);
#if 0
      glPopMatrix();
#endif
      glDisable (GL_TEXTURE_2D);
    }
}
