/* manual_exampleSound.cpp
 *
 * Copyright (C) 2004-2011 Paul Boersma
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This code is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this work. If not, see <http://www.gnu.org/licenses/>.
 */

#include "manual_exampleSound.h"
#include "Sound_to_Pitch.h"

static const char *data [] = {
"------------------------>8??>=??",
"?<??07000700?????6???1???1???0??",
"?0???5???4???9??02000000?3??>;??",
"?0???3???8???:??0300?>??0100?>??",
"?????:???9???2??>:??>>???6??0000",
"0;000?000>000300?>???7???4???7??",
"?:???:??0000050008000<000>000=00",
"0;00090009000:0007000400?<???<??",
"?3???5???5???2??>????5???9??0200",
"07000>0010000<0005000100?>???>??",
"?=???>???7???5???6???:???7???=??",
"????0200010000000000030005000400",
"?:???3??>=??>>???1???2???8??0400",
"01000200????030002000100?;???:??",
"?:???>??010002000000050006000100",
"?=???8???5???>??0200070004000500",
"020007000700?=???;???6???8??????",
"?;???9???7???6???9???>??05000900",
"0?000:00060005000200?9???7???0??",
"?0???1??>=??>8???0???8???=??0500",
"04000500050009000600050000000000",
"?4??>???>;??><???:??030005000400",
"?=???9???;???9???=??0200????0200",
"0000????0200?????9???9???2??>:??",
"?1???<??06000;0009000000?;???=??",
"?>???=??05000000?=???;???;???;??",
"?9???<???;???8???5???4???7???9??",
"01000400070009000400050009000100",
"040001000100000003000100?:???9??",
"0000020009000<000<00060005000200",
"08000:000;00070002000400?????:??",
"0200050005000200?????:???;??????",
"050006000700?:???;???<??03000800",
"0<000;000=00050000000000?????9??",
"?<???;???<??00000100010001000200",
"0400070008000:0007000000?=???9??",
"?5???<???9???5???5???8???3???8??",
"?;??00000500080007000100?<???=??",
"?=???9???3???6???3???3???;??0000",
"?:???<???<???:???9???7???3???3??",
"?7???:???8???6???7???:???9???>??",
"?>???:??????????????0000?5???7??",
"?<??0000?=???=???=???<???;???8??",
"?=???<???=??????0300050008000:00",
"070005000300050005000?0010000;00",
"06000300060004000:0007000?001100",
"110013000=000600050003000:000:00",
"09000;000:000:000<000;000<000?00",
"10001600170015001600130013001100",
"0700070008000>001<00220024002300",
"1>001700160014001600130017001700",
"1:001:001<001<001;001;001<001;00",
"1:001;00150011000:000>0013001<00",
"25002;002<002:0026001=0018001500",
"11000:000:000?00110015001;002100",
"2000200021001>00180014000?000:00",
"0100?????7???<???>??090014001800",
"1<001=001<0014000>0009000300?=??",
"?7???7??????0300070007000=000<00",
"10001700160014001100120012000?00",
"100018001:001400140017001;002100",
"330034003=00420044004=005=006800",
"730082008?009:00;300<700>7001101",
"5401=001=702>60300048?03?;020602",
"><00100015009700<?0064014402>?02",
"3603>902:7022302770120017=00;2??",
"02??89?>7<?>=;?>:5??7000>3003:01",
"9601>5019<01=40082??:=?=>9?;;;?:",
"55?:=6?:;3?;;8?<?9?=27??;9???<??",
">???>9?>;2?=63?<:3?:3:?9>7?7=1?6",
"03?723?753?838?:=2?:>3?;::?;?0?:",
"40?;64?956?83<?:82?;55?=88??3501",
"9;01;0??58?<45?:28?984?7=:?7:=?:",
"72?=0100>7012?03>903040377021103",
"?<0203035202960038??91?=8:?<<=?=",
"16009;036908750<9;0?89100=0>::09",
"40046;?>1=?:<:?896?902?<3=00?:04",
"8309110=530?9;104610<30=2;0::605",
"9500=;?;03?893?670?70>?:31?>5803",
"2308940;210=9>0<9:0:>:063>02?0?=",
"6;?:92?751?6;7?660?81>?;00?>=100",
"1203?20301043603700175??8:?=<>?;",
":5?:0??:42?:>=?:<6?;>>?<2=?>27??",
":=??>2??:???05??75?>30?>52?>07??",
"00002=013102:0027>02<:018;004???",
"64?>>4?=09?>;;?>>:??710104038204",
"=105:206?106<1061=06>;04?602?500",
"9:??7<?>2:?>7:??;:0162046;06;?07",
"<1086?083:0733060;05>1037802?800",
"<4??6??>6??=09?=35?=92?>81001802",
"70032<04=2039<02>>0075??45?>0:?=",
"2<?<>4?;:4?;88?;8<?;78?;08?;:4?:",
":3?:>;?:92?;8:?<4>?=59?=:1?<87?;",
"36?:=1?8;9?7?=?6=4?6;6?6;1?60;?7",
"7:?7;:?73;?839?968?:=5?:0=?;47?;",
"64?:=;?87:?7:5?6>5?636?7>5?75??:",
"5<?>6>015;021:03>2028<00=5?<75?9",
"<>?91>?;<=?:>=?;<:?>9?0111027201",
"360377052006;606=<0755087606;002",
"88??58?>?1?=0:??7>029?06;=0:>80=",
"470?;<0>:;0;1807;00244??36?=62?=",
"94??>:01?7031=06:708;>0:920;2>0<",
"600<050;:=074:0344??96?;45?8=>?6",
"87?824?<<>??5603>=064:0955097707",
"2<05910219??69?;0=?9>1?712?725?7",
"85?8>5?:79?=:<??:601<?02=202>101",
"30003>?>56?<<<?:>=?9=2?98:?:<7?;",
"1=?=5:?>78??5=00>20014010201:000",
"39001:001?00610013010802=7024?03",
"9?03>6030704<303;>03;50400069;06",
"19074;07?206420695053206:6078308",
"5:09:=09?1086:07?304;50230013600",
"87009201<4024;04?004<6047204;=03",
"<3028;013<0028??25?>09?=22?<20?;",
";0?98>?81<?855?879?951?;21?=3>?>",
"4>?>73?==:?;82?909?7>>?43??336?2",
"<1?1>9?1:=?29<?3>6?413?60>?7?8?7",
";=?7;3?641?54;?398?122?0=8>>;;>>",
"1>>?1?>?:?>?0=?178?204?49=?622?:",
"<=?>9804=?08300;500;>806?9?>98?5",
"=6>=18>;?5><2=?28=?:7504=60<;;10",
"3311;?10:10?6;0=530;780:=009:907",
"?;02>1?=40?;0=?;15?>;7057210731;",
":<237;264523791:?<0<56?><>?2;9><",
"75>=21?46:?>;4096813111:6>1=<=1=",
"<41;99174<112909=7??89?6=:>>29>:",
"9<>943>>1<?7=3017?0<3615:519:>18",
"1113740:<5002>?73:>?97>:6=>9>;>:",
"97>>19?4:1?:9600>404700750085507",
"3=04>>??89?;8;?70;?48>?163?16:?3",
"57?6<6?978?=140199033304=203?802",
"7301==??85??2501=10339063608?209",
"6?0:9508630587025300:??><2?>7=01",
"=205>;09><0<=30>:?0?560?;:0=3?0;",
":008?=0585031401>4?><9?=9>?=1??>",
"<????502?606060:490;930:>407?;03",
"17??07?:12?6:<?3<6?26:?3;:?539?9",
"9=?<=8?>>3??=???87?>>??;;1?888?5",
"=0?2;>?0=9>?37?0<0?196?34;?5;3?6",
"77?748?7<1?560?314?1>9>>4?>=?<><",
"03>>31?098?27<?421?6:1?683?51;?4",
"?;?1<5>?41>>1<>=0?>=?;>=52>?<3?1",
"73?5<6?;43043;0;0910911318130;0=",
"140399?90<?3=8>=84>;13?03>?:3=04",
"9:0<=>14=;1:131<7519=:1502121?0<",
":?059101?=?>44?=18?=>7??6705?50;",
"<6138:1<>=2225244<2001189?0<>>??",
";6?48?>>92>=88?0<4?7<202840><217",
"?81=472189209<1:581199078>?=4;?3",
"45>;59>8<:>9>1>=>1?4;;?>93087<0?",
"8713<?144512120<>303=<?;<>?42;>?",
"99><?8><85>?5>?3=1?759?<30003903",
"0<0596053<05?403:101<5?>0<?<0>?:",
"98?8:5?7<;?740?9:;?;>5?=80??4001",
":9028;038;04<5051008020:530:5:0:",
"=00941089>05:202?000;0??06??0300",
"=?017504>806=;08?60::;0<5?0=140=",
"9;0;6409;406>603620167??4>?>=9?=",
">7?=>6?>3?006<01?601:701=100:???",
"89?>83?=;4?<0:?<54?;79?:8<?998?8",
"78?771?679?5<4?4;6?4:<?480?43;?4",
"?<?3>??3=0?32:?4>0?4:5?5???5>6?5",
":5?5;8?418?32:?138>?67>==3>;2?>;",
"=<>;8:>=92>?=<?16<?47=?6=7?75;?8",
":0?804?992?8:;?7=??610?68??5;??4",
"6??446?684?90=?=16011;057208<709",
"=>083507:?05;303=;0126019;01;702",
">8037>05:407<209850;9=0=860?9;10",
"3511;<10890?930=050;6:09;;080<09",
"6>0:3=0<290>540?440?440>;?0<=80:",
"0609>3074=079?076<084?09250:740:",
"770:6?0:=<098608>806180509031;01",
"76???1?>1>??;7??2001=202:304<205",
"=1050=054103?:008;?>57?<=:?:5<?:",
"9;?:4<?;75?<>7?=1>??8<??83??<0??",
">2??91??23??1<???;?>43?>7:?=4;?=",
"87?=8;?=;=?=93?>74??=???2;005<00",
"55002600390030016102950322050906",
"270684054804610341023901>>001601",
";>01<102?90338051=069906<606<806",
"2306;7042703780180??;??=>8?<0<?=",
"3>?=3=?=0>?>?8?>3;??=??>20?>80?=",
"4??<:8?:;8?911?94=?888?7?1?698?6",
"23?699?52;?58=?4>??364?3==?295?2",
"73?254?27<?2>5?250?376?343?3;4?2",
"2:?213?199>?18>?52>?98>?41?0:0?1",
"71?3:=?461?549?6;:?689?604?6?>?5",
"6<?67<?6=2?62=?85<?925?:8>?;93?=",
"43??:700210256030704:?031203==02",
"52022;021703;?04=>06=?08800:900;",
"?>0;240<4=0<130<4;0<>:0<1;0=480=",
"580=4;0=370=550==00=;:0>=10?6410",
"91100810950>040=6:0;340:<009=?09",
"8?0:510;?20;400<?<0;3?0;850:7?09",
"7808;=0708077<06??055<05=0043904",
"89031403:?0223027801<000?9??54??",
"<>?>9>?>;9?>>5?>2=??51??46??0<??",
"4>?>5=?==3?<62?<=5?;92?;:9?;:6?;",
">3?;9;?<:5?=?2?>=4??6300??00>000",
"4300<7??>;?>=5?=2=?=2:?=8;?=25?>",
"4>??=200?<011<034104>;04>1043304",
"2403==018=00;5??51??53??9<??2>00",
"<6004601=2011>029;010?01;000>0??",
"=>?>62?>1;?>41?=38?<>8?;;>?;2:?;",
";9?::2?:5<?:71?985?817?855?75??6",
"98?510?5=3?489?495?48>?4=6?353?3",
"<6?2;9?1?3?06??0=>>?;<>?>6>?26?0",
"0>?10:?28<?216?355?38:?3?4?394?3",
"0<?37=?3:7?358?366?326?42<?5;3?5",
"96?615?872?99;?:91?;15?=6:?>9>?>",
"6;??1=005700:0003301=102=7039;04",
"570693073?087808<20870096?09:809",
">80:050<=20<860=550>=90>8=0>==0>",
"5>0?360?7;0?0<107;1085101910?10?",
"5?0?8<0>5<0>510>9:0>=00>7;0>200>",
"600=940<?>0;3=0;0:0;690;800;7>0;",
"7=0;010;6:0961070606;:047?034:03",
":>03<10364033203?:02220214013:00",
"9;??0=??6<?>19?>:>?=><?<9;?<72?<",
"6=?<?6?<9>?=16?>54?>63?>1;?>77?=",
"=4?<41?<99?;52?;92?;?6?;85?<69?=",
"5>?>?6?>58??;;??><??;8??54??2;??",
"=3?>2??>=??=>9?=>:?=43?>23??><??",
"540082006700=;??>8?>18?>68?=;:?<",
"6:?<84?<8<?<6??<67?<50?<13?<?1?;",
">4?;9??;1??;8:?:?>?937?94<?8;8?7",
"54?7?6?6:1?67;?653?6?<?5:8?55>?5",
"<9?443?40=?4=??39;?378?349?389?3",
"32?43:?461?406?5<8?41=?49<?36;?3",
"7;?316?31<?3?5?41;?7?0?761?863?9",
";;?972?845?799?7;2?804?904?9;5?:",
":8?<=1?<81?<58?=?=?>1800??004603",
"8205=4050305:004540431031202?:02",
"?=04:606;:08910;;=0=<;0=>=0<<70<",
"550<530;300;010<:30<330<0:0<>10<",
"3<0=230==70=790?8410;810=?109310",
"1;0?>50<800;290;9<0:0;0:7?0:450;",
";30;==0;300<;10<0?0<6>0:21092608",
"?:06?=05;;05;7054?05<504:7046504",
"7:03<3028;022?025=01<;00=;008500",
"99??34??8=??>0???=??2;0087005300",
"8=??13??:8?>=7?=0>?=:7?<;1?<?<?<",
"6<?=13?>=2?>2;??18??=2?>63?>???=",
";;?=:7?=;7?=76?=?5?<=3?<<4?<:=?<",
";:?<19?=<??=59?>57?>46?>?2?=25?=",
"8<?<44?<?1?;:8?;6=?;44?;?1?:5<?:",
"11?:23?:70?:0;?;7=?;60?;=:?:25?:",
":4?95;?908?9:3?834?8;>?75<?7=5?6",
"22?6;2?5:6?5;6?5>;?502?633?682?6",
"3??608?6:6?5<:?4;<?478?5?>?58<?6",
";9?606?658?50>?503?518?566?5<;?5",
"53?686?7?>?848?:24?;33?;11?;8??;",
">:?;2<?;73?:8=?:?4?::4?;;=?<;??=",
"86?>93?>=3?>4600=90127038?04:805",
";00599047;03?102510209021503?<04",
"3607::09530;1:0<020<?50:250:9909",
";<087<08<>086?09570:=50:370;6:0;",
"090;240;5>0<:;0=4<0>570>2=0>500=",
"640;6=09;=085608;00712085809700:",
";20:550:<:090009050896073807>206",
">506?80671069;05>1042;043;037302",
"4<0283029002890294026=026>026>02",
"4;022<021702>9019>017;0180011<01",
"81001800>8??74??<>?>83?>76?>7;?>",
"?6?>=1??600091009;007;00????49??",
";=?>52?><8?=78?=<5?=03?>>3?=;>?=",
";0?=4:?=:9?<=;?;03?;?0?:22?;85?;",
"79?<7=?=36?><;?=0;?<?>?9>1?8<8?8",
"1>?9<7?994?:30?;7>?;35?;>4?9?<?7",
"8=?6=2?6;2?8>=?:2:?<7;?;92?971?7",
">1?571?58>?548?646?7=7?710?8???7",
"91?765?75??813?95<?8?1?69<?5?>?4",
"00?58;?5?9?607?851?89>?89>?8???7",
"6??7::?8?2?:40?<;0?<98?<>2?;;0?:",
">;?94<?:95?;2:?=5??>33?>:0?=>;?=",
"1=??5900?<001801:30015003?00:600",
":70180030305630542057<04>4027?01",
"8=01<00233047?05>506?10762075;06",
"1206580630079<0874092<09=108>?08",
"15095008;606<>05?00573067<079?08",
";=09?:0:600;>>0:<1090<08?9067:06",
":>06?60726093;0994086707;8055504",
"2;044?05=306<>078>08;:087107;605",
"2904=8022;021?021703540463041=04",
">?031=032=02>101?:012?02<:029;03",
"21044004;703<;02<301:=00><??<???",
"3:00240156014;00=??>?<?=67?>><??",
"73010>020:010:??86?=4<?=4??>=2??",
"1=01?50008??;>?<16?:=0?769?757?9",
";;?<3:001>023;0193?><:?:<3?6<??4",
":6?63??;57??;<00:5??::?=6=?;09?9",
"55?579?27<?364?865?>>2010?020?00",
"8>?<74?7>7?1<>>>7=?08<?7?9??=204",
"?>0393?>61?84<?460?143?0>9?392?:",
"8<00=203980175?:74?3:<>?71>?09?3",
"37?954???102>:02090087?;;=?7<0?6",
"2=?742?71<?8;>?93;?<;6??<>02<?02",
"<=??9>?<95?;::?<09?>75??9:00:;00",
"290008???4?<;8?;;5?<8;??:3022405",
"=006=906=?047>0180??>2?>>5?>;:??",
"<000;<01:301><00?90146052;09200;",
"220:5>0799044=03:60296010501:601",
"2>0365056<07<2086109?<08:7073606",
";>05;;0574052905<0047204?<040606",
";<06;=064906340685067207:1086308",
"8606740425032:03=:03<20463051705",
">8042805>204=:03<70244024902;:02",
"7403:403:<020402:102:>03<1042=05",
"7<04=>025201>5004;00;7?>72?=;:?=",
"=<?>9?007?022103<9023503=>035>03",
">0??>;?;38?;=4?;1??=5<??03017201",
";2004;?>8>?<>7?<;4?=0=?>;4?>7:00",
"<80068?==3?988?9:9?:2>?<=6?=48?>",
";=?=>9?<5>?;37?:71?<8600590225??",
"9;?937?5=:?39??6<;?::;?>3202?603",
";30034?;?;?7<;?60<?777?:03??1;01",
"29?>;3?824?74:?935?;=>?<58??7=01",
"75??2:?9:??4<0?6=5?<9?01:1024???",
"5:?:14?7?9?6???94??>15018?0074??",
">2?>?>?;66?70;?78??;64??0501;200",
"3=?==:?95??:?8?<?000;002730177??",
">5?=11?=88?<30?=>9??1?032003:0??",
"3>?<=8?;5;?=75??=5012802?:018?02",
"==01>8??3??>>;??1<03>=045004=?01",
"4=0038008;01>802<>02>3012:01?000",
"5701>001<802>;04<=067806;>039701",
"7400:8004702:7035;049?047=044503",
"?6012602<;02=703>005>006=5062006",
"4?03=:??66?>?6???102<?04<105>;05",
"::04;;0254025<039<03;;02=1018201",
"<8011?02380386043904580306026>00",
"5600>3010303;>02=801=>00;???64??",
"7<0048017;000=??9=??9702<205::04",
"3400:4?=9;?>::0060014100;=??57??",
"2:?>:;?>9:00200171004:002:??;9?>",
"16018<02=3?>02?957?87=??7>073>09",
"7002>0?:;=?9>0?<><?>81??5=00>??>",
"8??<06?=76018803>6002:?>>;?<23?=",
"14?<=;?;17?>1801=>035=03;>???7?;",
">7?<;7?<80?95??8?>?<>30242057;04",
"35??0:?955?8;>?:>=?=8=022003;1?<",
"5;?973?>2404:>0217?=05?826?9:0??",
"200310004??:30?;89??50000>???0?>",
"27?=1:?<3=?>71??<3?<?2?:64?>=602",
"61037400;0?;<<?9=4?;0100?0005:?=",
"9:?;32??5;02?2007<?<32?<:601>505",
"=>037??<<:?89<?=11020?0210016<??",
"=4?<3<?;7=?<98?><401>504:8055005",
"1703<;?=61?:68?;36?>44012703<703",
"4303380159?>=:?=>;?==3??0:027701",
"?=0029024202?5??02??2601=4022<01",
"?:?=;4?<19?>460170037503>1013200",
"4900=8??04??<>?=<4?=2:00>8021105",
":403>8??>6?<3<?;2<?=380133039<03",
"?>0137?=4<?;6<?>>=020<056<033901",
"3>??7;?==??;:1?<::??35033:054=04",
"?600<0?<08?<3=?>660148055<071004",
"?6?=15?;21?<=<?>0>023704;4043102",
"8;??70??>500>>00?8??49026<04;<02",
"<>??>5?<<1?>0=048604?>0018??;700",
"=<023802:;?>>8?>2104:>061?04<4?>",
"5<?;1=?<89011608840606014000:300",
"0>?>53?=2:0138052?079?04?7?=<=?9",
"9;?<:?01<:0401050<0264??<?00<=01",
"93??5:?<7??>9>04?<041<?><:?;>4??",
">101;400=5??8=00?0027?0301?><5?9",
"8;?<>3025?07<005>??>0<?833?7>3?=",
"=6040?032??=77?<3;007<034:0276?=",
";4?:47?>6203<?0304??4;?<=7?>;;??",
"1??>;7?=:2?=7??>0;01>80026?=9??=",
"4103:<04?1?=58?9;:?;1;00<3015???",
">4?=0400?401:<?=20?943?;26??2301",
"8?02=70165?=;>?<:3?>7=?=89?<1:?=",
">4?>1900?=??<<?=<6?<53?>>9?>60?>",
"4??>>:?=>9?<>2?=1600;300<<?==4?9",
"1<?;4?000>030=00=8?:89?894?;=001",
":903?3??99?>59?=5>?:56?:38??2804",
"<40248?<7<?887?<8;023;01:8?;?7?;",
"?501:5043901=<?;80?:97?=4001<102",
"18008>?><4?><3??8?0093006<??19?=",
";7?>>5??85019<015=??1=009602?102",
"8901>>???7??9701?=0038???=??<002",
"3:05=<02?9?=6=?=7?00<502>4042;05",
"9701<??>430099037<057;04=40019?>",
"8=0008047<05=60479011=?>06?>1702",
"9505?2050=026=?><1??;903<:069;04",
"38??=5?:0>??:90654083005>4?=42?:",
";<002>0846079302:700?????1?=5:?=",
"<>00:706>;07080283?<:5?<?<009803",
"=?03;601<<0044029502?<02?20199?>",
"0??;33?=70033;079=0470???<?:21?;",
"1=039307?<0351?>:>?950?925?>:803",
"><076504=3?:33?90=008<038<?>?0?:",
"62?<2:018604;00223?><=?911?;9<??",
"7=01800009?>30?=<??>>5?>41?>98?=",
"03?>7<01<202<;?>:2?8<;?650?:<301",
"<40760047=?971?4?2?99?00840292??",
"49?<17?:80?<2=028;01:7?<36?:;1?;",
"17?>3>?<>0?;2600090121?>>2?:68?;",
"0:??:;00:;0168?>=>?6:;?646?>:>05",
"0606:8?>2>?8?:?7;??<290178033301",
"3>?<:=?<=>??1>0127?>91?<8;??9600",
"=>?=<5?;4=??6:049:023??><1?=0=?>",
"5=??::01=20167017>??6=?<5=???604",
"7?0291?>8>?=7;?>6103;>04>100=:??",
"3?002802<8035901<3??67003:020>04",
">501==?=0>0002042206;404<:?>0>?=",
"2101?2047=0685040<??=9?<==016305",
">6056504110098?>4201<<05?9064=02",
"4>?=;5?>2:0499079=05010016?>?0??",
"8204<8064103>>000300=00008036704",
"310269??;30125041:02<?006401:8??",
"=<??1=02?102;5029;0195009200?001",
"02020701880066001401;<01?4??;??>",
"=8??;?02950391???3?;53?>=?015:02",
"070079?=;0?>39029?02:8?>???:?2?:",
"6>??2:025600???>36??=;?=0>?=2500",
"770092?=:;?<78?>>2??7<??41?>58?<",
";;?=<>?>07?>::?=?;?=:0??<0?>7??;",
">6?:2:??8102090129?<24?90=?:<??=",
";<017002;2?>=??901?:>4?=9801=400",
"47?;:;?:35?=?0?=;:??:4??:0?><:?=",
">8?;07?;8??=440060??>:??>:?=78?:",
"85?<5;01=>02<0?>76?9:8?:3?01;302",
"100096?>>6?<1>?=83??4??>?8?<>1??",
"27015700:???73?>6<?>53??31008401",
":>??22?=50?>=>???800;40101000401",
"43017>?>5;??<90149035902;<?>30?>",
"270121022402>200><?>7;??05027302",
"<=02=5033901>6?=?>??5;0487030301",
":100380065012302;:??15019504;?03",
"6?00=7???501650496029900=4002401",
"29030404350268005800600224033;02",
"==01;90195017?01;6011?032;02=700",
"28007=0022021803;4020001?<??=>??",
":502=9032500>5?>92??3700>703>004",
">=??16?<44?>5=04=<046500<6?=06??",
"1900?900<30260012>?>:>?<6=?>2<02",
"740392019???8=?==2?<99??>>012>01",
"=9?>87?<:7?=?500?70013007;??48?<",
":6?<=7010?0230??5>?<<9?<<7??:1??",
"<2?<55?=?8??9>0065?>8=?<98?=;9??",
";=00><?>5<?=?2?<4??=<??>8;??3:??",
"8:?=63?=3:?>>??>?1?>99?>:5?>2<?=",
"1>?>69004>??3>?=26?<:4?=;3??92??",
"74??<3?>57?<20?=62003;006<?>>??=",
"30?=9>?=<;??>;002=??8??<?7?<7=00",
"?>024???;>?;2>?=;6000>0294??86?<",
"2>?>5?01=20020??1;?>50?>;9004101",
"84??:7??80??8;??7100><00:801?1??",
"99?=<=??0803720236??78?=0:00;203",
"90029>?>48?>;8000103290286??12?>",
"0?008;02=>02>7018:0067??=8??1?02",
"60036>02>3?????>990149037:01?8??",
"07006401140343027>??>=??94013>02",
"470302023???24006902>4028>018>?>",
"0>??<9021605530236?=?=?<>=023006",
"4>028>?<34?=79032=05?<0008?>;3?>",
"740065035>047;0064?=57?>>900<603",
"0:0346??<9?<2;??4:030>04:;??75?<",
"<7??;103>1025<?>;3?<>4?>6>024003",
"3<??>:?;<3?>:?018=0157002??>?3?=",
">0??>;01210168??7??>7>?>;2??>;??",
"18003;??;<?=4:??1?01:200;;?=3:?=",
"3:00>>010>0017?==2?=>5??<60075??",
"5??=>;?<4???5;02<=003;?=61?<>=?>",
"?301:700;4?>60?=;5?=8=00>2??9??=",
"=4?=<:?>?4??0=00<4?>;:?=89?>9200",
"?80063?>29?=30?>51005>0156??95?=",
"0:?>4????>009<017>??8??==6?==1??",
"1301>7??;5?>33??>7???4??87?>14??",
"::01?1005=?=:;?=8701;1016>??=:?=",
"12??7;01=10146??7>?<;1??:3038502",
";=?>19?=:0??84022;03830009?=;>?<",
"8>006204?6016:?=14?==900;9032?02",
"?;?>;<?<75000505110266?=2>?>2:02",
"4903??00;9?>9:??<0000?02?50179??",
"02??7<00=:0114014=0087??4=00=801",
">???>???0<01>:??=8??:=01<301;3??",
"9;001<01700028006:00:60149011>00",
">6?>6;??=>01:802=>0030?>8=?>8=01",
"0=03180181?>65?>0000;?02:102?;?>",
"?6?<86005>03=<01:7?>0=?>65001502",
"><01>7??;5?>43??33010;025;0021??",
";3?>5100;5014:00=6?>41??96018>01",
"=9?>:4?>6100?;00=>??=6??290083??",
"=<??5>000;007;??1000;7??9<??2200",
"<6??3700=:??1:00<8???5?>88??1<00",
"<200<;?>54?>7:008>017600<9?><9?>",
"15006800=1??2;0096??89?>58??0701",
"9=00???=;9?=>7??9000?3??0<0051?>",
"88?>3;01;20083?><<?>1001?200::?>",
"9>?>92006101::??=8?>97??34005:00",
"3<??5=??1<00240034??<7?>6;00?=00",
"49??64?>77??8=00250068??66??3=00",
"910031000:0045??2<00>100;<??:9?>",
"9:??>900:1??73?>=<??89010=00=??=",
";0??6001930017??14??3<00::00=0??",
"?9?>:7??480049001=00?;?>54??4601",
"9=0060??=6??53002>004=??84??5?01",
"<?0008??42?>77009>02:700<??=7:?>",
"2001:0019???=??>=5??40004=001000",
"0;004400290024003<0038003300<>??",
"66004<008???9>??<3??93008?00:700",
"=4??95?>:700>001=?0014??67?>;=??",
"2<01>:00;2??5;??3900:2001100>4??",
"4>00?3??????<000710099??:1??7500",
"<<00<3??5<??:8??660001017;00:4??",
"10??70006>01710064???9??<=002300",
"2?002601810002??6???>>000701;8??",
"50??6???780058019500;2??84??5800",
">4000<002<??:2??;8001001;2??1???",
":200?500<9??21006101<200:1?>>=?>",
"2;01>2017<??<;?=:6??;>01550074?>",
"3;??31008;0058001<000?00:7??6400",
"19014;0064??51??<:00:<0057??8;??",
"::??:3??:6??;5001:016:??80?>;6??",
"4?01:50086??40???3??32016300:9?>",
"=9?>5?0046008>??8;??020045003400",
";???55001601=2??4:?>39???5001800",
"88?>99??72008=??91?>3800=4002>??",
"6???4=004700<<??>7??000032??28??",
"9>??8=??1=00:;00;:??89?>7:??>400",
"3:00><?>?7??;60076??<<?>11008?00",
"05??7;?>07007;0068??=:??72003=??",
"10??>40019011;???2?>36005?005:??",
"6;??0<00=1???3?>?7??1>01>>??3=?>",
"5400160242??:8?=74??9601?:002;??",
">;?>>1?><5??<30166015>??:5?>5;??",
"9300:7017:01<=?>23?=330008031201",
"57?>:9?>6<0086005>007501010107??",
"48??;?0034014???:8?>>300<700=8??",
";0??=3??>3??88??9401<=014???18??",
"10006301??0004??96??:?001=016?00",
"?=???;??;>??700068009>0006014;00",
"1=??63??>301>201?9?>50?>?>??5=02",
"=:01:6?>>:?=71005>023;01<???61?>",
":0??8101;=0087??7;0054017:??82??",
"5=01500101??7<?>7:01<701>;??9<?>",
";=??:>0199006:?>73?>5500<<005900",
"8<??:9??760025008:??=4??1301>900",
"41??=4?>?:??>1004>0013??;>??>;??",
"36??:3??4>00?20058??9=?=73??6?02",
"1>01<??=:>?=08002>014300:=?>:5?>",
"5<000301360059??17??6;00?600;0??",
"=1?>12??27003:006>??0<??;7??6400",
";<?>;6?>=700:70115??0<?=<5??2602",
"370141?>4:?=;;??<201<00083?>99??",
"260196008<??:;??3600::??57??2;00",
"5300;8??53??2>??8;00530059??2800",
";5??;6??<000?5003:0088?>56??;;00",
"7:00=???63??4900;000100009001700",
":900380050??60??0600?:006700?3??",
"?9?>15??>2002=010400>9???;006301",
"70004;??9;000=0178??=7?>26002701",
"=2??;1???0001<0139005=??><??:900",
"4?01>;006;??10??8:00;8010101=9?>",
"=8?>30011=0235003<??::00=900<900",
"4<00>:??>7???=??8000?90096??45??",
"9600=;???2??00019>0078??<0??7=01",
"6<013:??7>???5002?012?00;7?>94??",
"=<007901;3??7??>9???020102010:00",
"56??10??35002;01>6???1?>4800<100",
"70??55???800:500;8?>4=??4701<<00",
"44??64??30004>00720031??28?><8??",
">300920018??64?>5;0027016;0018??",
"1<??300099??>7??6101750093?=30?>",
"3201==0111??8=?<;<?>=501<>0091?>",
"<1?>98??:70066014<??94?=:?00=902",
"80??6<?=04001=0151??6;??;5008<?>",
"11?>58001301;2?????>48???5?>3200",
"6:01<6??5;?=5;??5<01=100:1?>?4?>",
"?>00:2??69?>5=00;4010200?8?==6??",
"2403:>0084?<71?=:?0123033?00;=?=",
"60?=;5??2902>800;9?>?;?<;7?>=?02",
">>0252??<=?=3100>101=300;;?>7;?>",
"13??:=0087018;005=?>52?>;001<=02",
"1200=>?<<:?=11020?02>7??58?>3<??",
"8?0177011?001>??;8??;?001201:700",
"84??1100;8004>01600154?>:0?<=>??",
">402710167?>85?=89??>201>6027600",
"12?=?=?=:902>5023<?>81?=;<01?902",
"3???80?=4;??1<017401<20089??4<?>",
"?5?>;:0125030>0167?>;2?=?:??4<02",
"160244??75?=070050028400=??=27??",
"<2017=0185??=7?>0?000401320142??",
"91?==0?>?5005<01=<??18011;01:1?=",
"<0?=;20247041:??><?;<6?>;6010801",
";2?>2??>?:??8=00>7??1601<;0090?>",
"32?>19000802240115?>?6?<40000:03",
"=2009:?==1?>2001:900==00=???46?>",
"<3?>18008;02=100<9?=56?>7300><01",
"34??84?=17004201:=??74???600==??",
"1??>94???6006200?6?>69??=8008201",
"48007???43??8>??=:00:?00=??=>1?=",
"28001:0028000?01;:0167??46?=?6??",
"9?02:0001:?>75?>7200:70001002<01",
";:0006??25??=800=60032018=006;?=",
"20?>75026=03:0?=1:?=490113010<??",
"7>?>=?001>02:8006100=>006:??7:?<",
":??>3:0341024<?>71?<05??7=024=04",
"990167?;?:?;6;032<069:?>36?91;??",
"2<05:;03?3?=;9?;;:??4;02=2016300",
"99??3802?9005:?=30??3803;;0117?<",
"02?==7035104:2?=62?<5?0168034000",
">6?=0=008001?4004600<>??;=008700",
";:?=3??>15036>011??<9;?=7=031505",
"440017?=9:?=0=0084021?0167?>5??=",
"3???6=041303;>?;9>?;0302<1043301",
"9=?>90?>87?=:<??560420049??=;5?6",
"<8?:;;077>09<;?<;9?573?<6:08<108",
"56?<>9?74400==0563013=?<?0?>4501",
"06??9<??570129??:;?=56012>048400",
"52?<>2?=10024203380130?>13?=4<??",
"70028>02=??>:3?<2;006603==0137?>",
"77?<4=??;=01????39?>?;??:602;>00",
"4;?=29??1:034?028:?>;<?>;=010401",
"5=?>79?>5=000602;100:>?>;9?>6<00",
";>0080??>=002902770049?>89??5902",
">:0092?=?7?<85?>240144024:??5:?<",
"3?015>058;0195?<51?=1800>5??>000",
"<:0083?=2>?>5702=;01=8?>67?>;???",
"5901:40003??;:??65022902==?>74?>",
">1005801;0?>>:?=?001?90141?=7;?=",
"5502=<046>007<?;61?>7<02?3016100",
"32??:9?=17?>8<00>9029801?=?>59?=",
"=:?=1<003?012>0095??<800=?009>?>",
"54?>7601:;02=8??15?>1:??6;??05?>",
"73??;502:=02>8?<69?;880124049401",
";=?=;3?<5100?903940271?<5<?:<0??",
";=026:0119017100?=?>94??83027?00",
"1:?<64??2>042?01>3?;7??<26015<02",
"??00=401:?00>1?<?5?=:>01=30159??",
"2>?=8=?>5303?90218?>???;?1?>6602",
"0201?6??<801<2??5??<7=?>1504?103",
";7?=33?;88?>7;01040048??97008=??",
"6600670368036<??11?;28?<79028904",
"<3??07?;<1?=1904<=03=1??9=?<29?<",
"?5009;05760248?:?7?9600271074502",
"60?:=0?:09017;03>9??90?>9<019801",
">;??8<00=90192??:;?<?;?>11034:02",
";;?=5:?<<5??;:022002?>?=71?<3;01",
"15053302<6?<>:?:<>?>80034=0283?=",
"6>?=9:00930231024000:2??9<??15??",
"<3??1=018<??98?=75??<70251027:?=",
":3?;;0??4<031;011:?><50060036:00",
"60?=>1?><;??52?>0??>140106034:00",
"93?=<5??9?021?01<??<7>?<1:008201",
"6=??>5?>8:0144011;??>;?>???>4601",
"6?03:101<>?=74?=;1021>047??>58?;",
":;?>3:030603?;??26??6400:<014<01",
"=:?=71?<=5??66028?009=?>20??5???",
":4??0=022102=;?==:?;>>??64049:03",
":9??11?<75?;73??>?03000265?<77?;",
"70005105590215?<88?<92025504?4?>",
"4>?;52??3?045302?;?=39?=0>??;;00",
":;01?20053?>01?>32015003<10199?>",
"=5?=:1????00>800=???<>?>=:?=67?>",
"7=004301?7??48??2=014?02:5??43?=",
"3;00?<03;10181?<58?=0=021503<6??",
"10?=5>?>7901<502160014?<05?>=603",
"4>05>6??62?;;:?>52037101>7?=;5?=",
"?2?>2901>>02330201??:??<32?>><01",
"??030>011??<1=?=?=022:046:??1=?;",
"73?=640374047=??21?;51?=75025806",
"7804=??<40?996?>2605910233?<:3?<",
":001:203;:0039?>75?>61??>2007002",
"5001:;?=>0?<<2??8<02910188?>6<?=",
":8006<040:0376?>31?<=;?=22026?04",
"?7??;>?:9??=81038>0211?>=:?=3>01",
"2302=2??5;??:<01?1009;?>>=??2600",
"78?>86??74?>>:?=8>00<:01>101>?00",
"2900><007101010061?>?>?=<7??4501",
"940092???;?>7;??3>01;601=50052??",
"97?><1??9:01==0068?>33?>91??4600",
"=40034014200?<?=99?=?>??2;02<=01",
":2??:=?>0>0043005>?>8>?=5:00?:03",
":70206?=>5?;4;0174040?00>3?;?>??",
"?>04:8018>?;;;?;0:02=0049300<:?=",
";8?>:5??220155016>??1??>3>??7801",
"15022200<:?>4;??58??62??0;01:603",
"990106?<?4?;12014003970030?>2:??",
">7003102>00071?=;4?=710233054>01",
"<<?;:4?<:<0112031900?2?>3>003401",
";001>00075??;=??09007:??5>007402",
"62026=?>;<?<7:00==03:301;0?<2>?<",
">0008904:50256?>?:?<<1??3903<201",
"9??=9??<71??0702410116??1;00?;01",
"850175??=9?>9:??35??56??1?015<00",
"<??>23002401==??3:?>1??>63??<100",
"5=021702;8?>?0?<60??0803?40292??",
">>?<=0?==>0124040:0027?;4>?==701",
"75037;02=4??6<?=;4?=?3006:021900",
"<2?=5:?>09000>01370064?=;9?<1=??",
"0>01::02410293?=8;?;>4??8>04>501",
"?=?;;=?<62020;0371?=?1?:?3?==600",
"140171005700310097??37?>24?><000",
"6501<=?=54?;4>?>900152??20?<2??>",
"2?03330384?=09?;1>?>=100650027?>",
"22?=<<?=>7?>=9?>94?=:7?>4:0057?>",
"5;?<:6?>230213014>?<9??;24007402",
">6??03?=2:?=06??5200<00055009>??",
";5??6=0031003:??2????>??4900;5??",
"9<??73004;019?012>02?;02>80101??",
"5>?>0<0149033:02:7??=0??:402;503",
"2102;9009601?602?40251025502;502",
"66025>0205034<03?7014:019502:303",
">4033?049804<;03750225025002:201",
">=01;0032104;402><01=5024204?103",
"5602<3013:0244028702<=03;?037<01",
"<>??;<000303=0030002660053027>04",
"5=03:60055?><5?><90087011:0001??",
"1700==0134032:01:3?<64?<68018803",
":8?>85?9<6?:1400:501<;?=5=?<34??",
"110007?>79?<98?==2??39??0<?;6;?8",
"<6?::??>:<?>6??;0=?:?<?;<7?=90?<",
"56?;>0?;1=?<83?;56?;04?;6??90:?9",
"2:?91=?9>7?:57?=<<?;8??80:?:4:?>",
";0?>04?:96?583?7<<?=>6?>24?973?4",
"95?798?>6?004;?<;8?884?:3??>51?>",
"5;?<><?;58?<52?<><?;96?;>:?;62?<",
"3>?=?6?>6800>???00?>87?=36??2101",
"660110??1;?==6?>9:02>2032?010=??",
"?:007;044805?4026601;9026604;;03",
"4;0283021=0470059:05?804=;04;:05",
"6006??06;0076;075;063505>104=705",
":906670613065106<306310734072107",
";607310861078:05=4046006?4075>07",
"7805:>04=0052<07>806:<05>904<704",
">4040?05<;041;04>803>:03;5033303",
">>02=0038:05=905<1037>0116015402",
"=20240016>??94??3>01=101;8013?01",
"59006600=?00;<0007002<??;2?=11?>",
"9500?300;=?=8=?:<1?;8000570251?>",
"<6?941?:<2?>:30065?=<7?9<5?983?;",
"9;?<?9?;52?:1:?:5<?;5:?<;0?:73?6",
"39?511?9==?<?1?;25?880?514?79>?;",
"7<?<25?807?403?5;4?913?<>7?91>?5",
">;?12=?546?;03?<8>?71;?4:4?52??:",
"5??<8;?:07?8?6?79??941?:?3?73=?5",
"?9?50=?:<9?=>6?=?>?:3:?97<?:<>?;",
";2?:63?98<?::=?<>=?<82?;:>?94??9",
"2??<6;007502=200<6?=27?=::??7>02",
"3;03590145??83??55013802:7016;01",
">4024?05;7063=06?7048>0454053;06",
":40602079407=;076>07<806>106>007",
"?7089009680985081208:50805090009",
"05093=098709:0095>09?208:0088008",
"<3081;09<>08160878071<0717076107",
"96077=0722077>0613063>06;>06:706",
";4056=04=7034=04;704170434033703",
">90345048103:<0116003:00:<018002",
"3>024=01530083??=3?>87??<>018;02",
"59004<?=81?<41??8701:3??59?<;0?;",
"3;?=:1?>48??11??;3?=1:?<81?<7=??",
"1>01<4?==1?846?802?<>9?>=7?=;0?:",
"2<?:>3?<9<?=<1?:>8?7;7?87??<5<?>",
"1??<58?889?7<9?:79?=<3?;2??74<?5",
"1:?8;4?:8=?92??7?9?622?8;2?86??8",
"65?8<5?756?681?6=3?906?<;1?9=0?5",
"6=?53:?98>?;92?8?9?35=?31;?89<?<",
"=2?;=2?822?81??:>>?;2??;?5?8:2?8",
"47?:?<?:>;?920?921?:2=?<00?=<0?<",
":7?<8=?<64?<<2?<3>?>>1??24??83?<",
"?;?;43?>75008400=9?>7<?>1;015604",
"1<056>0380026>03;804=704:3034803",
"770457058=050106?406310893085308",
";3081009<7089>083?09290:=<09<708",
"4:089708:809800:5<0:3;0:3<0:220:",
"550:600:180:?309><09:209>7085>08",
"740894085108?;07==07;?0735076<06",
"36068;06:20637066505<>04>:04>904",
"73040004=303<1035<039<02?701:701",
"9>01840141012001;>00;1??::?>:8?>",
"97??3400>2??>;?>1:?>04?>07?>58?>",
"27??7<??<=?>47?=77?<31?==;?=63?=",
"57?<;;?;16?<38?=04?>03?>58?=35?<",
"91?;23?<4??=>8?=76?==<?;7:?9=9?8",
"1;?;?0?=?>?=20?;?=?89;?99=?;;3?<",
"23?<:5?;57?;;;?:96?:><?:81?:<<?8",
"?;?7=5?86:?9<:?86;?8>??86>?85=?7",
"?:?71??::7?;:4?:84?8<3?7>1?7?6?7",
"9:?878?98;?969?97:?952?96=?886?7",
"5??842?:>;?;==?<42?<2>?:2=?820?8",
"82?:02?=;9?<:9?:90?929?:8;?;?0?<",
"6??>9????7?>>;?<31?<71?=21??82??",
";>?>29?>:8?>6200:;01:50142015?01",
"??0147038:041;051705=3038>028=03",
"<60554079807;=064?06>206;7076108",
"2;09?509<209:0084608:008>;084209",
"8;09190:970:370:<809>509480:<10:",
"860::309220925093>09<:080208?:07",
"3008?80791074<0784071308;3078906",
":2051?0550054905::0405043003?202",
"54039>03;:033?036802;1011<010201",
"15019700>=??52???<?>>3?><1?>>:?>",
"1:???<?>9??>2;?>?=?=32?>6;?>09?>",
"54?=>=?<>3?<>=?<8>?<?5?;52?<;1?=",
";3?>71?>28?=0<?<?=?;5>?<6<?<>;?;",
"48?;1=?<>2?=0=?>0<?<=1?945?:?5?<",
"58?>33?=40?;<5?:6=?;>5?;?3?;76?;",
";4?:17?::3?:;>?;=2?;49?;0>?;;6?;",
"27?<>:?:<??842?77:?679?6;5?7=<?9",
"4>?;60?;:0?:5??9=1?733?762?885?:",
"80?;09?:3;?836?824?971?980?9<>?9",
"?=?937?:=:?:92?;7:?;69?:79?9<1?9",
"57?:17?:0??:42?::1?:8??;=9?<6:?>",
"47??>5?>;4?=15?<06?;;2?;72?=1=??",
"85??:9?>66?>29??3=00370114020703",
";9037903>602:=027302;8023503>903",
"0705?>0595064?076?0816091509<308",
"2108880750079;075308>90824095;09",
"9709230:0:0;<<0;=00;1<0;630:280:",
"2?0:;009<1081?08=0074308>0080209",
"7;09<30945098<089>07>;06<5067606",
">;05470598045204<5045=055<058904",
"<203;=030804?;032;039?017=001700",
"==???4??0:0004002700>7??7<??51??",
"30???>?>88?><2?=42?=15?=34?=61?=",
"2??=<1?<9;?<=<?<22?=2=?=42?=7=?=",
"<8?=39?==0?;<8?:95?:55?;:=?<30?=",
"9;?<07?<9>?;5>?;>>?;66?<=1?;40?;",
"7??;;7?;78?;>8?:0=?;1=?<89?<>9?;",
"41?;07?;=5?:9<?:<5?:>;?:?;?::;?:",
"82?9=1?842?9;<?989?9:3?980?:;8?:",
"49?98??79>?666?795?8=3?83;?99=?9",
"9<?9=6?809?834?96??;<1?;54?:18?9",
"7;?9?;?950?9=>?89:?9:5?:16?:4??9",
";>?9>9?::5?<2??=87?<?:?;00?<67?<",
"46?<:7?;<6?;98?<31?=8<?=13?>95?>",
"=6?>???>91??87002;012101>=005101",
"3302;802:;028>02=70259031904?<04",
"?20523079=0779073;074507>=076808",
"66086708;3083309:>09<409<;09540:",
"=?0:280;3?0;130;=20:;80:970:5<0:",
"490:3<0:340:740:750:6=0:650:320:",
"000:7?09:108<>075;0747074:073<07",
"?>06=406;506790613066:050305>104",
":1042104160300027601370129011501",
"030122012601>9007900>3??35??;=?>",
"69?>=??=67?=06?=97?<8:?<;6?<>5?<",
"28?=41?=3;?=0=?=:2?<2<?<0=?<38?<",
"15?<:6?;24?;8=?::;?:77?;21?<=2?;",
"02?;<1?:>0?:3>?;2:?;<5?:?2?:53?;",
"74?;35?;58?:96?9:<?:69?<5=?<25?;",
"=:?92;?93:?953?9<6?97??:=3?:3;?:",
"14?:94?:4=?:4:?978?800?939?:=8?9",
"13?851?712?848?996?96>?850?730?8",
">9?94;?:4>?907?9;0?:34?<4??;3=?9",
"?3?727?815?944?:64?;85?;<5?:07?:",
"32?:3=?;?5?;?7?;93?;>6?;01?=:9?=",
"58?=65?<80?<59?=:3?=96?=;<?=;;?>",
"<=??470006001300?600780168018101",
"340227038303=:039=040>05=604:804",
"650594067307;50790078=0734081?09",
"7:093>091:0980092:0:;50:>60:>60:",
"3<0;730;270;240;560;7?0;6>0;260;",
"4;0;6<0;2<0;=00:580:>509:909:209",
";:09930953091>0990081208>=07<707",
"6=07;2062506?5059<055=05??04;=04",
"89040;048803>=025902>40142019=00",
"1;00>0??>6??:>??54??3???3>??4;??",
"3<???3?>6??>8=?==6?<5:?<=;?;93?;",
"30?;>8?:1;?;57?;;<?;1:?<38?<84?<",
":9?<<7?<::?<;<?;5<?:35?91<?904?:",
"74?:=<?923?913?915?:45?;04?<>4?;",
"9;?;=5?;73?;45?:55?919?96>?90;?:",
"63?:1=?:9>?93:?93<?9=6?98:?:44?:",
"86?996?9?7?9:6?9::?86;?811?990?9",
"6<?9=3?84<?8?2?7=2?739?8;8?8>:?8",
"1=?936?9=0?858?8>8?846?:0??;94?;",
"6<?;5:?:2>?9?=?821?:<7?:80?:8<?:",
"=<?:02?;1??;48?;>5?;24?=2;?>39?>",
"<:?=40?=>0?<;9?<<4?<49?=41?>1:??",
":2??100031003;000<0150029<03=>03",
"0>03730261024=035>04<=0440059>05",
"3806;406;=065>073208>>0868090;09",
"0>0940095109?9097<0:1;0;740;3<0;",
"720;7:0;6?0;900;:70;1<0<280<930;",
"350;0=0;640;;70;670;?60:7>0:890:",
":=0:330:8209=6084>08?207:;07:207",
"8<0770074=07>5066606>50573050?05",
"8:0407045?039;0233020002;:014701",
"<?008;004300>1??85??63??3:??==?>",
"8>?>2:?>>5?=:7?=3;?=>;?<;1?<7??<",
"59?<0??<89?;05?;=<?:2<?;64?;52?;",
"95?;1??<2??<5=?;7=?:60?:6;?:45?:",
"08?::7?9:8?9:>?956?953?9:;?919?:",
"11?:00?:6>?:>:?:==?:=5?947?8;;?7",
"=3?8>??97;?996?7<4?6>1?71:?958?9",
"0:?990?814?8:8?79:?795?7;1?700?8",
"65?8?>?818?947?854?730?710?8?4?8",
"95?815?80<?8?3?7?9?7>6?7;1?85=?:",
":>?;?3?;0<?;95?92=?911?:;>?::2?:",
"82?:28?:99?9<2?982?:08?<:1?=00?>",
"69?>?5?>?3?>0;??62?>20?>>4?>19??",
"0????7?>=4?><5??37010103>=04>305",
"0;068205>204::04<>043?05:>050=06",
"5?06<<0681075?087109;;0:960;>10;",
">10;910;5=0;500;030;0=0;4;0;500;",
"990;<?0;1=0<<10<540==90=400>>=0=",
"0;0=2>0<480;;=0:930:780:;=0:<20:",
";?0:=:0::60:510:>4095709<:082<08",
"7607?:066=06<<056205300523051;05",
">904:9043<049703>?0263029?01:500",
"<:???<?>90?>:1?>0<??59??39??=3?>",
"94?>82?>50?>;7?==>?<00?<33?;<1?:",
"86?:66?:5=?:2=?:34?:<>?:66?;97?;",
"97?;50?;;5?:>1?91;?94=?8=7?7?4?7",
">;?76>?873?927?:1<?:58?95<?814?8",
"90?8<8?8>7?836?9<0?820?8<2?732?7",
"43?634?6?3?74??9>7?895?75;?625?6",
"92?649?6<<?559?665?787?7=6?691?6",
"78?704?93<?934?828?725?6=6?5:3?6",
"79?717?8>??8>=?894?81<?98>?978?9",
"51?901?:44?;44?;70?:04?:83?95;?9",
"=>?971?:<6?;7;?=42?><2?>:;?>9=?>",
"11??;4?>:=?>=2?>2=?>12?>>4?>4200",
"93014?0239032;04:<044105:405:505",
"3>05?304760569061807=40746088<08",
"0>09;<091=0;800<?<0<<;0<4=0<=30;",
"6:0;160;800;740<0;0=4:0=7?0=::0=",
">>0=100>660>=70>;70>470><<0=0>0=",
"1>0<440;020;5:0;;80;:<0;530;200;",
"?90:<50:9>0:5>0:;909<<08<107?906",
"7=060506<705830565054<057404<903",
"6?032=0318038902<=0156018000;???",
"2:??:6?>93?>8<?>62?>09?>4<?==<?<",
">3?<>5?<;5?<0??<86?;29?;:5?:34?:",
">:?9?4?914?:=5?9<:?9?6?9?;?9>;?9",
":>?957?9=3?85=?863?8:=?843?840?7",
":8?63:?741?89;?87=?875?853?8:4?7",
"7=?7???774?818?82;?787?634?610?6",
"46?627?6>2?55:?6==?6:<?61:?66??5",
"3<?5;0?577?63??720?773?6;5?577?5",
"88?5:=?5<6?60??85:?816?8:1?708?7",
"0=?7<4?7>7?880?927?9:6?8>>?8;9?9",
"4=?:0:?:=;?97<?:0>?;43?;64?;<9?;",
"5>?<32?==5?=03?>>2?=7:?=81?=41?>",
"38??7200320136016201<9010?026902",
">502=<03>90466051506>906?<06>806",
"12079=076808>>087309870:530;9;0;",
";:0;=10;2<0<6=0<860<010=;00=190>",
"630>8;0>630>120><>0==40=0?0>140>",
"270>7>0>6?0>090>>20=<90=;10=030=",
"2<0<100<260<240<<>0;330;:60:=309",
"1409:4089708:0086<081=0874079806",
"<90509058704?:03<503=50373030803",
";40207024;018200<=??45???0?>;:?>",
"67?><5?=52?=2<?=?0?<82?<30?<21?<",
"37?<21?<>1?;99?;10?;24?:2<?987?8",
"4:?88<?8?7?86=?9???930?:<9?949?9",
"?6?889?813?835?8;1?8<6?81=?87;?7",
"?2?632?63>?620?7?6?739?80;?8==?7",
";0?755?74??7;9?7?5?79;?743?668?4",
"=:?3:6?431?556?57>?551?505?5<3?4",
";;?43=?57:?632?7>6?6=7?662?60<?5",
"65?491?4:4?50>?735?77:?64=?657?6",
">:?630?84=?951?:7:?:=6?932?937?8",
"14?845?9?1?:07?<;=?;?7?:39?;13?<",
"3:?=;9?><3??2;003;009>??9>?>>4?>",
"7>00;30172026103<:03;2036003:;03",
"4505=4068?07550887080108=0076008",
">2096<0;;?0;?60;070<120<610<790<",
"6:0=970>><0><80>8;0>5>0>850>030?",
"?<0?:8108810:00?<50>310>;70=<;0=",
"650>?;0>160?960>070>670=8<0<150<",
"3>0<910<6:0<610;420:9909>9088008",
"540854084508;>0700075=069<051305",
"9<047;0424046?039;02?301=:01>801",
"=901?2019>01:8007<??68?>;>?=22?=",
":=?<::?<95?<0>?<65?;>1?:?4?:5<?;",
"91?;77?;43?;;2?:<2?9<8?840?831?8",
"3>?851?87<?8<7?8?7?8?6?82:?97=?9",
"=0?9<=?96:?9>8?81??844?7<0?65??6",
"69?6>??652?76=?750?744?75>?7:4?7",
"<>?788?7?>?679?6=2?5<<?4>7?374?3",
"31?3>3?2<0?2::?27:?29>?247?34:?4",
"82?400?4;8?3>??3=9?305?37;?246?2",
";??29>?3;<?3>2?382?4;4?44=?53=?6",
"=1?6:<?79??8:2?84??8?;?7=3?7=??7",
"<>?7?8?70>?9>=?97;?:32?;90?<71?>",
">9?>;:?>6<???3??8100=;00=6007101",
"4502:1023903390489059106;2073;09",
";<0:910;?<0;?;0;=;0;1;0<360<770<",
"450=>20=:;0>:70?2<10=0106;113912",
";:12?4120413=012;3128612?1118411",
"02119;10>3103?1178118<1180114=11",
"8610680?8;0>=40=720=100=<?0<=80<",
"8:0<>90;430;8?0:010:6;09<<081=08",
"7007:006:605<80414049<036>038<03",
"=:03>003;=0353038>02:90177005=??",
"82?>9<?=?=?<:<?<90?<;7?<?:?<35?=",
"5=?=75?=7=?=4=?==0?<32?<6??;77?:",
"8:?9<2?864?861?86;?8=;?88:?913?:",
"65?:5??:03?:7>?9>7?845?8;1?74;?7",
"?5?6:=?656?60:?6>1?5<;?5=9?5>0?5",
"0;?626?601?6:0?5>=?42>?499?3?<?2",
"7:?219?2<<?179?104?15<?0<2>?85>?",
"7:>?;;>?22?041?027?0>0>?=5>??=>?",
"==>?=1>?<6>?=;>?29?055?061?093?0",
"0<?1?3?1?2?2:;?386?484?509?670?6",
";7?620?7;2?708?85>?8=5?856?9=:?9",
"77?:;8?;53?=8:?>96??=2000?021703",
"8<03>1035604>9043605::0590066>07",
"5=087509:80:>90;<50<920=520>?70>",
"780??10?9>1032119111>?115=12=112",
"201392130>148>14>?14==14>>14:814",
"3714?0136;13?=12:?124=1250120412",
";1117>1135111111<1103510:;0?<:0>",
";<0==>0<210<720;=40:410:<<096509",
"=40830089?07?6065<06=<0569050105",
"930404046703<10205023;01:0003700",
";9??44??=1?>68?>0:?>:1?=55?=1<?=",
"=9?<:8?<77?<43?<07?<95?;20?;;;?:",
"4>?:>0?989?929?9=;?8:1?864?870?8",
"9<?8:=?8<5?8<9?8;2?896?862?836?8",
">??78=?738?7=>?679?633?616?6?>?5",
"==?5:=?58:?581?580?59;?5:6?591?5",
"92?5:2?596?56>?531?5>9?4:8?470?4",
"3>?40=?4?7?3?=?30:?41>?44=?494?4",
"=3?403?529?544?55;?566?569?572?5",
"8??5:9?5;<?5>1?51;?666?6;3?610?7",
"84?7?2?75??8;??810?95:?99??9<??9",
"15?:65?:;9?:2:?;90?;?8?;75?<>;?<",
"7<?=1??>:>?>39??<9??5400=:004:01",
":30108027?02?;028103?:038<042905",
";5054106;?0622079907?=074=08;;08",
"1;096<09=009190:550:9;0:==0:2:0;",
"790;;?0;1;0<750<:40<:?0<:?0<<;0<",
"=:0<<;0<<60<<00<;90<:>0<810<640<",
"490<240<?<0;>00;<:0;9=0;660;430;",
"0=0;>80:<<0:970:740:430:?109<=09",
"9<094909?108::08730841080308::07",
"4307=;0668060506;?05800540050305",
":;045104?<039=032=03;;024;02=<01",
"82013901>:00:00064001=00=2??96??",
"50??0<??>0?>9??>52?>12?><7?=63?=",
"07?=:6?<42?<02?<;??;82?;55?;2=?;",
"03?;>1?:;8?:77?:29?:=2?975?912?9",
";7?859?809?8<;?78>?751?71>?7>8?6",
":6?670?64>?63<?61;?6==?598?564?5",
"25?5==?498?44>?4?;?3<:?3:8?393?3",
"89?37=?35=?345?344?343?34:?347?3",
"37?315?3?:?202?30<?3?9?2>2?2?5?2",
"1>?347?37;?3;>?3?7?33<?4:3?4?<?4",
"3??599?5>6?522?671?6;9?618?79;?7",
"18?881?8?;?883?91??:;??:3>?;<2?;",
"6;?<2;?=>:?=81?>24??>9??9?005901",
"06029;023703>60393044=05?=05;106",
"5?07>2076308?8089309380:<40:2?0;",
";?0;5:0<>00<550=;10=060>600>;80>",
"080?560?9;0?>50?2=1060107=10:310",
";310:71097107910671075107?106010",
"451030100210<;0?960?590?260?000?",
"<40>7=0>3?0>?00=960=3:0==40<6;0<",
"090<9?0;310;<60:630:?=098=091009",
"8808?<076;07<?0637069:0501058204",
"0=048703?=026<02=5014?01=4004>00",
"=4??5:??<>?>44?><4?=46?=;;?<33?<",
":;?;2:?;;;?:4;?:=5?974?916?9:;?8",
"4:?8>:?78=?724?7:6?630?6<9?570?5",
"21?5=3?48=?44=?40<?4=>?3:9?37:?3",
"4??317?3?5?2=:?2;4?290?269?223?2",
">1?1;1?193?186?189?17:?163?15<?1",
"77?19<?1:9?1<2?1=5?1=4?1<9?1=:?1",
">:?1?0?1?<?125?256?284?2<<?22>?3",
"73?3;5?307?45=?4;<?408?55:?5;>?5",
"17?669?6<6?62;?7:3?713?877?801?9",
"89?90??:;8?:43?;<:?;6>?<?4?<8=?=",
"3??><;?>3;??:=??3600=70082013302",
"?602:5034;04>4047=051?06;<064807",
"=2076:08?8087909?=097>0:?30:7=0;",
"><0;5:0<?90<570=;>0=330>860>>;0>",
"540?;00?211063107<108:1085109610",
":510;=10?610061119112411?210=310",
";71060101510>30?9;0?530?110?=50>",
"850>3?0>?;0=:70=560=>;0<810<290<",
";<0;510;?<0:960:150:99090:096108",
"<2072>078606?:058<05040594041?04",
"8603>=0251029=01?5005:00;=??29??",
":=?>25?>:3?=41?==0?<48?<<??;4<?;",
"<8?:62?:09?:;4?962?906?99;?82=?8",
";8?753?7?4?69??658?625?6?=?5=5?5",
":??593?563?52=?50=?5=7?4:4?471?4",
"3??41:?407?4?4?3?0?3>6?3=9?3<??3",
"=0?3<>?3<>?3=1?3<5?3;6?3;=?3<;?3",
"<:?3;=?3<0?3<1?3<4?3=8?3>??30:?4",
"1??43??465?478?484?4:1?4<4?4>2?4",
"03?52<?567?592?5;:?5?0?533?679?6",
"<1?619?769?7;0?701?867?8<:?828?9",
"82?9<>?928?:8;?:>7?:60?;?1?;6=?<",
"=9?<42?=<0?=43?><>?>55??<6??4=00",
"=<00650100029;022403<7036?040105",
"8=0509068>062;07;7073>08<?086009",
">609580:;20:140;7>0;>10;3;0<:30<",
"260=930=>?0=4:0>920>;40>>00>1=0?",
"470?640?6;0?7:0?9:0?:40?930?880?",
"8?0?8=0?640?350?0?0?=80>9?0>620>",
"270>?=0=<30=760=180=;60<4;0<?90;",
":<0;630;030;9;0:3<0:>7097609?108",
"7:08?<077907?4066?06>=056?05?304",
"6=04>>03790302037;02>?015<01<;00",
"4300;=??35??:9?>34?><=?=63?=?8?<",
"80?<06?<93?;1:?;;6?:60?:09?:;>?9",
"69?908?9;7?86:?81>?8<<?76??72:?7",
"?6?6<0?68<?65;?62??600?6=6?5;1?5",
"82?551?527?5???4>1?4<7?4;;?4;8?4",
";0?4:=?4:=?4:3?49;?482?466?452?4",
"5<?473?47<?47??47??47>?47:?47??4",
"7<?47:?47=?488?48;?490?496?4:3?4",
";??4=<?4>>?407?52=?561?58:?5;8?5",
"?:?545?686?6=4?62;?787?7<??719?8",
"60?8;4?81>?97:?9=0?93>?::8?:15?;",
"95?;0>?<76?<>1?<5<?==6?=5>?>?3?>",
"6:??=<??5?00>;006>01?30193023803",
"=803790417059<05170693060<079>07",
"4308=40830099309190:9>0:1?0;9=0;",
"0<0<740<=40<260=860=>60=3;0>7:0>",
"<?0>2?0?670?790?820?6=0?590?640?",
"800?990?:70?:00?800?5=0?310?<?0>",
"690>260>?40=<50=8<0=560=230==50<",
"870<400<>?0;9;0;340;;30:400:=?09",
"8;093109=1087308?;077407>0063606",
"9;051:05:1043804=>036<03>0024;02",
":<01?8004400;3??33??<3?>62?>13?>",
";8?=50?=<4?<2=?<9>?;1;?;9=?:29?:",
"<0?96=?922?9>8?8:1?865?815?8;:?7",
"5??704?7;0?67=?64=?634?624?60=?6",
">2?5;2?569?521?5?2?4=0?4<3?4;>?4",
"<1?4=5?4>8?4>;?4=6?4:=?483?45=?4",
"39?42=?434?43=?44<?466?472?474?4",
"71?46??46:?466?478?490?4:8?4;1?4",
"<;?4>>?411?52;?537?53<?55<?58<?5",
"<0?5?;?541?68>?6=5?627?769?78>?7",
":9?7=0?70;?864?8<<?82<?99;?90>?:",
"75?:=;?:54?;<<?;2??<91?<01?=:1?=",
"46?>;6?>29??;7??5800?50086011602",
":1021<03;10365041;05<6054906<906",
"5:07=1074608<5084209;=09410:<>0:",
"710;?:0;610<;:0<290=;40=0;0>520>",
":10>=00>010?3<0?520?7>0?:=0?;60?",
"<30?;>0?<20?;20?920?8:0?7=0?7;0?",
"600?1?0?=90>8?0>2?0>?50=;30=5>0=",
"120=;60<5<0<050<:40;470;>=0:980:",
"2>0:;5093?09;=082>08;5072;07:?06",
"3;06;7052<059;041004870307038402",
"?2017<0101017900>???68??=9?>53?>",
"=4?=5??=?4?<94?<34?<<3?;52?;?4?:",
":4?:4<?:?2?9:0?94??9?;?8;4?876?8",
"21?8<7?77;?738?7>??6;1?67;?63:?6",
"0>?6>1?5;4?590?580?55??537?51<?5",
"0<?5?7?4=9?4<5?4<2?4=3?4=0?4=0?4",
"=3?4<5?4:??49<?483?469?460?466?4",
"76?476?47:?47;?46??467?46=?469?4",
"6??472?488?4:2?4;=?4><?417?53<?5",
"6;?597?5;>?5>1?51>?64;?682?6=8?6",
"2>?781?7=5?71:?868?8;>?807?958?9",
"=0?937?:95?:09?;87?;0;?<95?<19?=",
"93?=0??>81?>?7?>71??1300;5005601",
"?<01:?026403?>037=04020585050906",
"89062307=5076;08?10880090:0:930:",
"170;870;?30;7;0<>:0<4;0=<60=300>",
"810>;?0>?80>460?800?840?8=0?9?0?",
";20?<:0?>>0?3;1061105;1043101?10",
">=0?:<0?540?010?=20>:30>640>350>",
"020>9;0=2?0==50<770<1:0<:30;300;",
"<50:510:<=095509=;085108<1073=07",
";<063906;9052>05;8046>041004::03",
"39039;02?60142018=00>;??55??<8?>",
"56?>?5?=9;?=31?=<2?<59?<=5?;51?;",
">;?:8<?:26?:=2?983?927?9=0?875?8",
"1>?8<6?775?737?7???6<0?696?677?6",
"43?619?6?<?5<8?58;?54<?50=?5<>?4",
"92?475?472?47=?48:?499?4:4?499?4",
"83?464?445?426?416?40>?411?407?4",
"00?4?4?3=>?3=5?3=;?3=;?3>4?3?<?3",
"04?400?407?425?44:?45=?46>?48:?4",
":>?4<8?4>>?423?561?5:??508?66<?6",
"<5?612?74;?77??7<5?71>?87??8>5?8",
"44?9;6?920?:84?:04?;89?;?9?;76?<",
"?<?<7;?=>6?=56?>=3?>64??????:?00",
"6<010802:9024<03>40381041705<;05",
"7?062707=4076908>=086809?409920:",
"330;<>0;500<=70<540=;40=150>800>",
"=50>310?750?:60?<?0?>90??<0?1310",
"46108<10<210>21009110511>?10<610",
":<1095106:102=10>>0?9:0?380?>00>",
"7?0>350>==0=760=150=;40<550<=;0;",
"5>0;?00:820:??097609>3084908::07",
"0;078>062606;6054005<<045=04=503",
"4=03;9021=027<01=800350097???7?>",
"5??><=?=51?=>4?<77?<02?<96?;24?;",
"<0?:65?:14?:=0?987?923?9;>?855?8",
"?3?799?73=?7?;?6<4?68;?651?61=?6",
">4?5:2?56<?548?51<?5>2?4:9?471?4",
"40?417?4?<?3>9?3>2?3>0?3=2?3<5?3",
";7?3:7?3:2?39<?39;?398?38>?371?3",
"5;?34;?32=?316?316?31<?328?32>?3",
"33?332?33<?356?387?3;:?3=>?307?4",
"32?456?47;?49??4=0?40>?560?5;;?5",
"19?667?6;;?618?776?7>;?764?8<8?8",
"38?9:2?907?:84?:13?;85?;?<?;85?<",
"0??=98?=18?>8:?>12??<2??76003401",
"?3019>024703>40386042005:8054406",
"?30694073?08?4088<092?0:=<0:780;",
"0>0<:40<2?0=:10=150>850>020?590?",
"9?0??20?321062107>108>10:>10>910",
"1?115211:211<311<;11<911;1118:11",
"4:110811=11085103010>40?9;0?4=0?",
">90>7=0>260>=10=720=0?0=;10<510<",
"=90;680;>90:5;0:<30919096908;:07",
"13078<060;0694053305=2046?04?203",
"5503:<02>50125017700<???3;??;4?>",
"2??>;2?=2=?=:=?<44?<>1?;7<?;1??;",
"<>?:83?:25?:<3?950?9=8?860?8>0?7",
"6:?7?6?688?622?6=8?5:7?58>?58;?5",
"87?578?53??5?7?49??440?4>9?39>?3",
"73?366?35??34<?332?31:?3?<?2>=?2",
">1?2=??2=>?2=7?2<8?2;0?286?268?2",
"4??22>?216?207?2?4?1>7?1>4?1?6?1",
"1??272?2<9?20=?33;?363?373?375?3",
"82?3:9?3>3?333?496?4?4?450?5:1?5",
"?3?557?6;=?62;?798?70:?890?802?9",
"6??901?:8>?:?=?:7:?;01?<7>?<???<",
"71?=???=;5?>75??3>000801<?018802",
"3003=00374040=05:?056;062107=507",
"81081109:809560:?60:8;0;240<;?0<",
"4;0==:0=720>040?880?>?0?3;108210",
"<710><10?:1024116811:811>:112;12",
"6112811289129712:11288125<121?12",
"=71180111411<31079102?10<;0?630?",
"060?:40>3=0>>40=9;0=4=0===0<6;0<",
"=00;1;0;6;0::>09?:086:08=6073807",
":;0625069<052<05;9043?04<9033703",
"8402;>01?00013005<??<<?>54?>>1?=",
"51?=<9?<44?<:;?;32?;=8?:81?:3;?:",
">=?989?901?96=?8=7?74>?7=4?674?6",
"14?6;1?55:?50<?5<8?4:7?4:3?49>?4",
"8>?460?417?4;6?34<?3><?2;6?29;?2",
"87?27>?267?239?206?2=3?1;5?19??1",
":4?1:8?1:6?194?17=?161?13>?121?1",
"17?10;?101?1?9?0?7?0?7?018?163?1",
";8?1?<?14>?293?2;2?2<5?2>??218?3",
"4=?3:0?3?>?36>?4=0?430?595?5?;?5",
"6;?6=:?650?7=1?74:?8<;?85??9?0?9",
"83?:13?;98?;25?<:??<28?=9??=3;?>",
"?2?>:4??61002:01?801;?027<034304",
"?904:3054<06?506:;077:083709>?09",
"<80:870;340<=>0<680=?50=810>000?",
":30?3610:3100:116311:=11?1110<12",
"2=12521264127?129112:912<>12>412",
"08133413471345131<13<=1280122=12",
"?411;7117;114311=31072100210790?",
"?>0>7=0>020>940=170=900<060<6>0;",
"<=0:240:8609>00824085>079406>905",
"5305<>0461040504920305036602:<01",
"=<000<005;??;7?>29?>:??=27?=9??<",
"07?<69?;>0?:6=?:???9:7?941?9=5?8",
"72?80;?89>?72??7;7?638?6;4?534?5",
":>?436?4=3?39;?37=?377?372?34<?3",
"0;?3;8?256?2?8?1:9?166?13=?11=?1",
"?7?0=6?0:6?068?031?00;?0?3>?>;>?",
"?1>??2>??2>?>8>?>1>?=9>?<>>?;<>?",
"<1>?<0>?;4>?;9>?=<>?14?064?0<5?0",
"34?194?1>4?128?26;?2:3?2=7?223?3",
"9>?31<?4:8?425?596?5?>?566?6<<?6",
"46?7>3?78<?844?9?;?9;<?:64?;?5?;",
"83?<20?=<=?=73?>1=??<;??7=003>01",
"?=01=402;003880455052606>606:207",
"4?08?908<?09:=0:860;540<150=;>0=",
"440>;=0>4?0?>40?7<101011:6113=12",
";112?912401378139:13<513><131214",
"38143814301446143?1434141914?>13",
"=:1399135?133113?712<81288124012",
"?>118>11101193101310910?190?:;0>",
"350>;<0=2=0=880<==0;240;5=0:9209",
"=90817086407:?06?40550059>04>>03",
"46039;02><014201:3000:006=??=6?>",
"3;?>9:?=01?=62?<;7?;19?;7=?:><?9",
"6<?9?>?899?831?8<4?758?7=??65;?6",
"=6?54:?5<??44>?4=??37=?31>?3<9?2",
"7:?22:?2=<?199?154?114?1=7?098?0",
"54?001?0;6>?6;>?1<>?<?>>7>>>44>>",
"18>>02>>?>>=09>>16>>2:>>40>>50>>",
"53>>45>>4:>>42>>45>>5>>>76>>9?>>",
"=2>>13>?5?>?;8>?1:?086?0>;?046?1",
";3?122?29=?21<?38=?3?1?34=?4:6?4",
"13?58<?518?6<0?678?743?808?9<4?9",
"75?:10?;;6?;75?<35?=?3?=:5?>4???",
"0700<=00:>01:1028=038=047?056406",
"49071408=:08;209950:8:0;6=0<260=",
"<=0=4;0><40>550??30?:1104911>211",
"7?12?>125013:913?:135614;:140715",
"37154115251513151:15331558157615",
"751555151?15=4149114691440142014",
"0014;7135:13<4122:1296110<119910",
"16108:0?>30>340>7=0==;0<410<:00;",
"090;640::>09>108?:0717074:068<05",
">7044404:003?3022=026=01:>000=00",
"7:??>??>72?>>0?=3??=8??<=<?;2>?;",
"92?:?;?967?9=7?840?8:5?70>?787?6",
"19?6;8?55>?503?594?41=?49<?319?3",
"9<?22;?2<4?168?10<?1;<?06=?022?0",
"=9>?91>?4=>?10>?=8>>9>>>66>>1?>>",
"=5>=96>=65>=3=>=18>=?:><>0><<7><",
";3><:9><;:><=6><06>=4<>=91>==1>=",
"04>>34>>72>>;4>>01>?5<>?;9>?09?0",
"5=?0<4?041?1<<?152?2=7?266?3?3?3",
"6=?4=7?448?5<4?558?606?7<2?777?8",
"18?99=?929?:=6?:8>?;56?<35?=14?>",
"?=?>=<??;<00:40181025>0355044705",
"2906>306880745081>09040:160;200<",
"100=>?0=8=0>1=0?;50?3710<;108011",
"2?12<4122:1367139913<113?;135514",
";314??142?1540154?155<156=159915",
"<215=115;91572150>15;21460142?14",
"2;1431141014<?136=13=>124412;611",
"3411;=104410;00??>0>3:0>5<0=890<",
"=70;2>0;820:=0090?093=087907<006",
"1<0697051;058;04=>030=0325023;01",
"6100:=??22??:<?>28?>96?=?:?<47?<",
"94?;>>?:62?:>6?96:?9?7?86>?8==?7",
"49?7;5?635?6;9?539?5;3?42??4:;?3",
"34?3=>?296?261?23=?2?=?1:7?143?1",
"<5?03??0;?>?4>>??5>>:2>>59>>15>>",
"=:>=:9>=81>=68>=54>=46>=3:>=31>=",
"23>=18>=06>=?<><?;><?1><>>><?=><",
"0>>=29>=53>=9=>=06>>8:>>17>?9>>?",
"1>?08??006?173?1=??147?2:1?2?=?2",
"6>?3>6?36:?4?>?4:0?55;?614?7<5?7",
"58?8=;?859?9>1?97:?:2:?;=9?;94?<",
"47?=0<?>=6?>96??5>0039012>024003",
"5=046>057<06800787089009770:5:0;",
"160<;;0<6;0=030>9=0>4>0??80?;810",
"7:112412:812?7122?1354139313?013",
"4314:214>:1408151815221518151015",
"121524152>1539153915271517150215",
">414=0149:143?14=:134913;:123212",
";?116:110?11;4102>10810?;?0>>90=",
"2=0=8:0<>70;520;;50:?10922094908",
"6;079006=50527056904::03>4021:02",
"5=01<0002>00:;??2;??8??>>3?=26?=",
"63?<;7?;2<?;;6?:56?:?:?987?9?9?8",
"67?8<9?739?7;=?648?6>2?574?5?;?4",
"7:?4>6?351?3<6?257?2???1:0?139?1",
"<9?04>?0>3>?8:>?3?>?08>?<2>>72>>",
"1=>>;:>=61>=18>===><;5><9>><91><",
"7;><5;><42><2=><31><52><8;><=3><",
"10>=3:>=6>>=:6>=>;>=43>>:8>>12>?",
"8;>?0=?097?01:?18<?1?5?156?2<6?2",
"3;?3:5?312?47:?4><?476?50;?6:0?6",
"32?7;2?72<?8::?842?9>8?9:2?:7=?;",
"63?<56?=4;?>35??0=00>400<201:802",
":1039?04:205:706;307;>08<209:>0:",
"850;3>0<>70<8>0=3=0>>=0>:60?6:10",
"2711=3115612;112?7121:1340138413",
"<<1320147814;>1401152:153=155115",
"5;1550153;15201510150?150?151215",
"15150815=?14:4144>14>41373130<13",
";=1272121912;4111?1162108?0?:90>",
"<?0=020=3:0<820;=60:210:6=09:;08",
">2071:0744067805:604<;0300033=02",
"8:01020186000=008??????>5??>;:?=",
"1??=93?<17?<9>?;28?;:9?:15?:64?9",
"<:?844?89;?7>2?63>?6;9?539?5;0?4",
"24?498?321?3:>?232?2::?11??191?0",
"02?06<>?>3>>6<>>02>>:4>=4<>=?4><",
"98><3;><>1>;89>;3<>;?>>:<8>::?>:",
":?>::9>::9>:9?>:72>::4>:<9>:8;>:",
"=3>:32>;16>;4:>;2?><4=>=38>>29>?",
"1;?0>5?09>?151?2:>?2:1?2;9?243?3",
"<2?337?4=<?484?540?6?:?686?70=?8",
";6?893?98:?:78?;6=?<59?=09?>=7?>",
";3??4>00200172021>04:605?9066808",
"8009570:5<0;5=0<200=820==20=750>",
"=50>?20>510?0=101611?;11:5126913",
">?1318143=1460148<1498149014=;14",
">8147:142<142=1442141214=513?013",
">51393136<135=134>13251310131913",
";?121<127911<7102310780??=0>:90>",
"460>=<0=560=950<;<0;?30:440:9309",
";108;307==06110644057?04;9031103",
"85020<028;01<300?5??54??><?>90?>",
"35?>?4?=;0?=56?=>3?<6??<?;?;86?;",
"41?;14?;==?:93?:1<?:8>?911?984?8",
"?2?76:?7>:?67>?602?667?5=>?45>?4",
"=3?34<?3<1?215?258?15>?04<>?38>>",
"12>=06><?7>:13>:59>984>89:>7?0>6",
"78>600>690>57?>5;9>5?4>523>69=>6",
":6>797>84:>97=>:45><0?>>7;>?13?1",
"=:?232?402?502?69;?7<6?852?95:?:",
";9?;<<?<24?=57?=24?><9?>;9?>=:?>",
"88??3=00;=00?6006<01>901=4013502",
"09038803:603860364047<0563056?05",
"1=06<>064>076;07?;07>00809095209",
"590:750;4=0<;90<880=970>=40>>30>",
"640?0;109;10>2107<116?12;112;412",
"23136;134813>412:112:11221123611",
":2105:10?<0?470?:?0>7>0>?90=180=",
"5:0<:20;>60:3<0:;3098;095309;;08",
"3;08>9075=079?06?=0596053905;004",
"62041?04<:0384032>0331031?03:702",
"89029<0298027;0260029;02<8029;02",
"5402>70191014<01>=00=?00<4005100",
"?2??62??8<?>9;?=99?<:>?;=6?:<5?9",
">7?869?8<2?7?=?630?685?511?597?4",
"12?498?3?1?247?2:9?102?167?0=0>?",
"21>?74>>;7>=:3><:7>;>1>:48>:=4>9",
"52>920>958>9:>>90:>:64>:??>::4>;",
"4<><61>=55>>3=>?5;?0>9?1<:?340?5",
"8<?648?833?:68?;=>?;>4?<1??>>6?>",
"9:??75007>01?>01>:01350222028:01",
"3>0144014101>>001001>6015>024302",
"3=0284027;02:7013501<601>001;?01",
"4402220321046=04:>04:105>205?805",
"72063=0730088;083;095<0::00:::0:",
"3;0;450<>40<;=0<300=3?0><>0>?40>",
"550?0:102<10:;0?7>0?7<0?>30>7?0=",
"700<270<:40;950:<:099209?=08>;07",
"24078<06>405?7048?04=404;1046304",
"7?043005:>0555052>05770568051405",
"?<0453058<059<050>06;:06?106:806",
"83066=06?3053005:90490047:044404",
"43044904340403048>0312038=02:?01",
"=80034007=??<9?>=8?=>5?<0<?<=9?:",
":8?9:;?8:<?7=5?621?6;1?564?5>6?4",
"71?41:?4<8?35:?3<??25=?20:?29=?1",
"=4?009?062>?=<>>57>>=1>=54>=3;>=",
"25>=2=>=92>==0>=13>>43>>93>>43>?",
":2>?>>>?=6?026?285?329?525?748?9",
">;?:0=?<9<?=1???:6??<>??62006601",
"1802;4011201;20114025=016?000500",
"3900>>??41??3???35??5=?>?;?=2=?>",
"19?>9>?=41?=60?>><??>:??66000502",
";?02>:022:03=203>;04<<04=<049<06",
"79075:0790072:0865098:09?408=009",
"570:240::;0:6=0;030<2<0<690<;;0=",
"9;0>0;0>=90=0=0>930=530<440;?<0:",
"6;0:?6080?081:08;=07<:0664069206",
"5:06;005460510058>04340460048>04",
"38041904?10477052:050<0569051<06",
"9106:;064807;:079:079?075?07>006",
"98062906;40564050:050?051805>?04",
"=7046904;5030>032?025601<;003600",
"66??8;?>;0?=?5?<>??;98?::;?9?0?8",
"27?898?73=?71>?7==?665?6>6?569?5",
"?5?478?4<1?3>;?254?2=>?11??13;?0",
";=>?56>?8;>><:>=;9>=07>>??>=19>>",
":3>>6:>?;?>?93>??9>?4>?07>?05:?1",
":5?289?42>?6?4?7<6?::8?<6??=0;?>",
"23??26006>00;30079014;020<02:401",
"1=02=;01:800;3???5??4:008=??<??>",
">;?>55??8:?>:2?=74?=7=?=60?=72?=",
"7>?>:5??=:??9300380205031;034803",
";60365040005:105950641077007?:07",
"7608:;086808>9074=0825098909?209",
"7<0:4;0;?80;070<560<<80<<40<:90<",
"6>0<0=0<7?0;;<0:290:;109==080;08",
"8>07?8065106:90568054>05;<043104",
"0:04>;0399031>03:402<60209032=03",
"<503510464049804;904<=04?5040205",
"620521069?06?0060507;?0658066;05",
"7104:>03<4025702720276023?02<601",
"3=0100018>009<??;4?>03?>46?=;7?<",
"2;?<43?;5=?::3?9?5?85:?8=2?7:1?7",
"=4?7=6?764?7=3?6>4?5<7?4<;?3;4?2",
":>?1?5?073?022?0>6>?93>?6:>?36>?",
"=<>>07>?;6>?4=?0?8?090?1?2?184?2",
";7?213?3>1?38<?4<>?554?7?>?835?;",
"16?=3:?>1:??;5??;0??>8??:6005701",
"3102=8023903020423047803<8026?01",
"6000><??3???05??16??69??;<??89??",
"32??3=??:1??80??7;??1=0086007901",
"9202360304045904990460052206<706",
"7?072108:10824097809030:>5091?09",
"5009;>09>609260:9;0:;10;9>0<;30<",
";10<?10<<00<><0;?50:300:51097908",
">1079<076907<006=;052:055?047303",
"1803<;024;02=?01<<013>028:024102",
"3=02<<020<03??020?032:033=03=?02",
":60209036203;00312046?049;047=04",
"5<0425048703;9022:02;40142010601",
"?000?;00=9006200?8??:5??0;??43?>",
"98?=;3?<=;?;15?;3>?:85?9:2?89;?7",
"<9?648?61>?6=8?57:?53??5>??477?4",
"=3?31=?37:?2=9?12=?1:2?06=?063?0",
"66?066?061?055?0:7?009?17<?1>1?1",
"0;?274?2=>?2::?3<??43??666?82:?:",
"6<?;<8?<1;?>09??40??:1??4<00:900",
"75019802<403:9049304>;0395032;03",
"83023?02:>01460185011<01=?00::00",
"?=??>4??72??5=??4600=7008:018=02",
"4103:2039403:9035;04?4043;05<505",
"99069?07>:08?309:40:;;0:380:5:0:",
"470;<60;920;:70;070<3?0<510<290<",
"2>0<1?0<9<0;6?0;6>0;>;0:030:0=09",
"6>08?<0723076:061906;?056=050205",
"2;044?03;102:90223030>0385026602",
"9602;:029<022402>7019>0139014101",
"51011?0102012=018;012602;0021603",
":403130485049>040>046=03>2024?02",
"8>01;9007700870077004>0087??39?>",
"<??<53?;11?:>>?8;9?7>;?686?64:?6",
"16?698?550?537?526?56;?581?53=?5",
"=6?45>?4?=?35<?36=?2<9?15;?1<1?0",
"35?0?9>?;8>?98>?89>?<=>?4??07:?0",
";:?059?1<9?126?29=?26=?3><?47??6",
":6?8?1?:5:?<:??=39??;3007<014601",
"18018101?60117022702;=024;035803",
"4:03?0028802<=01;600?<??=9??>0??",
"0000:000>=005101<8011002?8029503",
"78049;05=30528069906?90697075707",
"=10609077107?5076808<>088:09270:",
"640:=50:720;<=0;:40;690;;80;4<0<",
"<>0<0;0=9;0=500>710>5>0>=<0=080=",
"170<>40:8>091508<:066:0684066006",
">30553050805;8041<04830369037103",
"7803;2034:04:5048;04?>033=03;302",
"1002:101:0018?018401500103010=01",
"?800;3008:0033002;006500:900>500",
";1003000?1??<;??74??05??;=?>88?>",
"31?>9;?=10?=76?<7>?;5:?:30?918?8",
"04?718?660?5=0?464?41>?4<:?344?3",
"98?2>5?138?139?03>>?5>>>90>=3>>=",
"11>=<8><;2><03>=:=>=59>>;=>>03>?",
"6>>?85>?<4>?;0?0>9?169?314?52;?7",
"29?999?:;3?;=4?<32?>68??7<007>01",
"87027103<803=1038:03;8022:02?801",
"?7015?023?02?9011302>5012101>8??",
"=7?>5=?>14?>19?><:?>?7??1101<701",
";902;803100413041<04=<04;3059506",
";;07>808<709770:0;0;740;900;<70;",
"690<100=<60=6;0>110?910?860?2?0?",
"?:0>960>180>=>0=?10=2=0>0<0>820=",
"040=4:0<500;0>0:<608>10777074507",
"1707<50627068505?>047104>5039703",
":703?503270437046104870484043804",
"?203?9031604>703;>03;603:003:103",
"5803?<02;4021>02960116015:00>4??",
"72??0;??<=?>50?>>=?=87?=?0?<7=?<",
"?>?;77?;?3?:70?:1<?::>?904?927?8",
"1:?71<?645?55;?444?357?278?180?0",
"89>?8=>>:3>==:><>5>;4?>;66>;80>;",
";?>;42><96><39>=>=>=3:>>;:>>?9>>",
"67>?7:?04=?128?280?34??553?7;2?8",
":6?934?;<5?<<3?=93?>1:???>??2201",
"::017=02><024?0212020002=8019:01",
"<=0041004500<6??><?>1=?>95?=6;?=",
"48?=>6?=9>?>31??45008001:=021:03",
"3>0325041005:605>4056>068>075:08",
"?;08>=097<0:<40:?80:650;=20;;90;",
"=50;780<5;0=050>:10><70?;:10?=10",
"251133114511>=10?;0?4>0?810>460=",
"420<2>0;?509=208>107770722076106",
"=405;8057;051:05=?04<=04?=041505",
"3605==0591063:07=4071<08?4077007",
"=<065806=4053205930450040<045>03",
"<202><01?=00280062??16??=:?>73?>",
"66?>7=?>75?>59?>2:?>31?>>=?=0??=",
"4=?<<<?;33?;6<?:91?972?804?781?5",
"38?4><?24??119?095>?1<>?6:>>;>>=",
"=?><<8>;<6>:29>:17>:35>:<>>:=:>;",
"?4><<0>=25>>47>>1:>>27>>3<>>;>>>",
"?>>?48?159?3:4?568?71=?9:1?:?8?;",
"2??=4??>8=???1000?02:102?0021703",
";802<201>40064001=00=4??64??=>?>",
"54?>4:?=>3?;=:?:<;?950?985?910?:",
":6?;17?=;4?>=5004:0295037?042?05",
"14065>06=>069:07=2073108;6085609",
">609140:5=0:?=0:<30;5?0<290=210>",
"120?03109<10071136110511?>10=210",
"3:10:30?1<0?<20>0?0>>50<970;560:",
"0<0992079?06?4053505??04>:041605",
"81059>05?1050<061806:8064:071108",
"::080?09620954092509;60818085?07",
"49065905>504>704>=048<0405048203",
"<902=001>;0000003>??04??12??5;??",
"76??6>??50??73?>37?=33?<4=?;36?:",
"?0?8<;?7>3?617?668?583?433?3;3?1",
"74?06>>?56>>84>==;><25><;0>;83>;",
"82>;57>;3?>;5=>;8>>;=3>;:9><8;>=",
"=5>=31>>?=>>33?00:?1;1?115?399?4",
">7?58??7<;?90<?<=2?=2???47002<01",
":001;>01?=01;0010801<9006=007>00",
"3=002???5=?>48?=4??<73?;84?:04?:",
"64?9?7?8<4?921?;=2?;38?<?8?<1;?>",
"31??19005501=002>;03890455052606",
"7506<:0673071;08=108;809==0:170<",
":;0<=40<500=020>940>3:0?1?10:910",
"?5103311721174117010200?440>?=0<",
"<30;<50:<:0925092<083:079806;805",
"2:05?>04<:04=9044=05?<05;>064607",
"67078707<80726088:08:<081<09=809",
"?<09:;093909=70828083<07;8065=06",
"=50557051205<80408043?03>:02:>02",
"1;029?01620100016200<1??0;??12?>",
"?2?<>9?;1;?;0>?:;7?89:?771?62=?5",
"><?39:?276?150?03<>?6=>>;3>==7><",
"1?><;<>;<?>;61><?4><86>=08>>51>>",
":5>>54>>?2>=>=>=48>>96>??4?077?2",
"5<?4?9?5;2?717?934?:<1?;>8?<0<?>",
"69??;90099015?0115010=019600?<??",
"3???83?>?;?=44?=>=?<:1?<<:?;>8?:",
"02?:?7?818?812?8:4?826?9<4?97:?:",
"10?<;6?==2?>?=??:4001=0186010302",
">902=3035=0498042205;6059506;807",
"810817097?097?0:3<0<970==;0>1:10",
"=;10241120116:1179118:10320???0=",
"390=410<350;640:1=09=>07>=064806",
"<=05?7045404?>03:203=0039:04<405",
"9;06=;0610075607:507;807;<071:08",
"<=089409?>09?709:809?708>407>;06",
"8606590643065<066<0650060006<=05",
"8=05;>04=2034:03<?0234027501=900",
"200012??<9?=4??<:??:?<?882?76:?6",
"8>?5?1?47;?4;??3<2?2;9?14;?0:9>>",
"1=>=?5>;:2>;>8>;0;>=99>>:3>?0>?0",
"03?0=0>?4<>?94>>51>><:>>;6>?==?0",
"=1?230?5=2?683?727?86=?9?5?:71?<",
"59?>;40045029702>:0245031?030:02",
"75000;00170012004300150095??<4?=",
"70?;=1?92??8;6?67>?5?<?452?514?6",
":3?70>?:60?<?5?=;7?>88??66006200",
"70003001>:01;;02<50359054;070508",
";>07>70745089308??08050:=40;630=",
"650>290?7:0?750?1<0?=:0>;10>720>",
"940><;0>9>0>700=4;0;0909<:06<604",
"280333025;020:039?033204=9045105",
"32059;042;0426046=04000510063907",
"3:08>10833092509;:08290896075107",
"4<076=07=5070808=30743078306>405",
"3?058?044;047?04:704430462034:02",
"?40031??75?=3:?<10?;07?:61?9<>?8",
">7?7:1?680?55>?4>5?265?186?0?2>?",
"=>>>9;>=0>>=?9><42>=>=>=73>>82>>",
"2>>>:6>>77>?;=>?17?00??167?223?3",
"1;?453?6>9?888?:28?;6>?<4??><7??",
";40085015:028102?701<;01>1013<01",
"=;??;3?>17?>;8?==7?=7;?>?3?>85?>",
"44?=0??<54?;41?:;1?807?80<?842?8",
"13?98;?:3>?<2=?=32?=27?=5:?=94?=",
"?<?=:1?>88??6000870179031>051806",
">306>10713092;0:5;0;0;0=>90>2510",
"80105410>90?3;0?670>6;0=6?0<1>0<",
"340<=;0;120;=4093908;20650053>04",
"=003;703;>0323048304870485045204",
"=>03140383027<02>3025303?=030505",
"0206:00688063<061006;=059:050;06",
"28074=08>>0824092:09>1084108?407",
";407>;062>069:05<;0491032502?700",
"6;??77?==<?;;>?:=;?9???870?806?8",
"45?73>?606?550?340?1:8>?<6>>?;>=",
"64>=48>==?>=?9>>91>?:2>?:5>?=6>?",
"00?09?>?90>?3<?066?1<>?25<?4;5?6",
";6?85<?905?:40?;94?<9:?==0?>?:00",
"37024;026>028=02;602:>0159009;00",
"14013401<101:9022<03?301>8??5=?>",
":7?<<1?:57?9:=?877?88<?809?9;>?9",
"20?:<9?98<?90;?::5?:>7?;6>?=7??>",
"=9???900==010303<0039?04?9051;07",
":308430:720;680<000=610=7;0=290=",
"0=0=6<0=:70=950=870=930=:60=320=",
"450<990;<<0:>>097709?:0822082>07",
"6=0695057<04520369021>029201?200",
"==00;3009>00=1005301800298035404",
">8046>05;905<:05=<0530069:06=?06",
"20078607?0073508=9071?073?063605",
"87042:0485038?02:<01?9002100<8?>",
"5;?=65?<;9?;?:?:67?:07?:29?9:9?7",
";=?57>?309?17=>>80><67>;=1>:58>;",
"03>=21>>4<>>63>>>:>>05>?8<>>>;>>",
"<8?00=?3:1?456?6<;?8?>?:;=?;>4?;",
";0?<2:?=84?=?2?>=<00;101<=01>401",
"=3014;010200?<?>>8?>0>??>4????01",
"8:036<035;02=700?9?>09?=6>?;;2?:",
"50?:9;?991?9:0?:47?;1=?;33?;20?;",
"<<?:=0?:86?;0??=;>?=03?>44??8700",
":>0119037<040406:906470706092;0:",
"7:0:?80:=50;:60<?40<:80=>80>2?0?",
"6:0>;>0=760=370==80<9>0<7>0<=50;",
">40:3;0:5209>=075=064=05:<041=04",
"35048>048204?=030<033>028901;<00",
":;006701360251038<047405>205::05",
"??044204:303:3034<04580590065807",
"6107>>0637065:057304>:03=003=503",
"9103090378026601=???82?>1:?=;8?;",
"89?::4?916?91>?85:?64;?423?2>=>?",
"=<>==>>;72>:::>:8?><39>><9>>59>?",
">>>???>?61>?57>?>:?03??2?>?28??4",
"?7?6>3?86;?900?:6:?;=3?;87?;8??<",
":7?>;;??=;??54005;016:013800=3??",
"6<009=002;01?50255054=062=059803",
"=30194??:4?=78?<53?<?>?;00?;49?;",
"=1?;52?;81?:89?976?9???931?:0=?;",
";0?<?6?==<?>90??7400=<011?035204",
"9;05<;061?084109?909800:5:0:420:",
"800:?00:0;0<?;0<5?0=;00=9=0=860=",
"740=?;0<420<850;0>0;050;<<0:040:",
"2009:;0815080?074;061206;405<904",
"<103?3025=02<?01580136014:01=701",
";70242038703;=03:7034>030:033703",
"=8037;040=05;=055;0660060906;105",
">504=7031<03<:027502=<014701<300",
"11000???27?>70?=83?<70?;35?::6?8",
"==?6<<?469?2=?>?23>=?;>:=0>:40><",
"63>=5=>=7>>=;?>>97>?78>?>;>?4:?1",
"67?2>4?231?436?77>?9<;?97:?:3<?<",
"31?=>6?<1??=?5?>9>??4??>>7?=:8?>",
";4?>;=?=37?=<9?=01?>?2?=>2??0=03",
"8;0412046:030>032>02=?001:00=;??",
">8?>6=?=94?<:7?<7=?<4:?;3:?:<1?9",
":3?92>?:3:?;5<?<3=?=:<?=:0?>0?00",
"7?012203<>040206010742088609360:",
"500:3>0:?>094109=8085209<309<709",
"?7095>0:9=0::20:=>0:4;0;3;0;?20:",
"580;<;0;450;840:260:980969084707",
">9067>066;0539043<03970273024502",
"==01;>01><017=02=>022003=5035<04",
"78049704?9043=05250512053=051405",
"88042104;503<:02?:01:8015901=400",
"5600?9??70??;;?>55?>15?>8<?=::?<",
"9??;28?:46?869?679?43;?2>>>?2;>>",
"0<>>0;>?2<>?<3>>8;>>=7>>67>?45>?",
";0>?33?1<??2?9?326?520?7?2?889?9",
"=5?9=6?:98?;12?<19?=40?>5<?>;0?=",
"43?=:7?=71?=7:?<95?<1=?=97?=>9?>",
"=700;<028<036<033<03=?022;02:601",
"7=01130147008;???1?>03?>???<4:?<",
">0?;=6?;?5?;34?<<3?<?1?<?1?<6:?=",
"=1?=:=?>740060026404<40561062907",
":807:8079:07:;070=08;608?908<608",
"71084008740884087;08>;08:?09620:",
"<80:4=0;1<0<050<150;530:<7097909",
"2:09:00832089?07=006>0055=04=202",
"3502220215024>021903??032204:603",
"70035=030?03>8023>03;103>;033104",
"8<047704<:032403:002?6013001;500",
":6006700?9??81???<?>7=?>31?>10?>",
";7?=00?=2>?<30?;:??9<7?7<??5;6?3",
"35?1?1>>40>>01>?3>>?80>>1>>>:?>>",
"9=>??2>?4=?06>?108?362?425?536?6",
"72?784?8:3?9?4?:5;?<7:?=78?>>:?>",
";3?>74?>58?>><?=30?=7??<<>?<90?=",
"=<?==1?>570098019002??0214032303",
">702:<02<9021702??002=0036??6??>",
"91?=>:?<?<?<1:?=60?=:<?=<2?=<6?=",
"9;?==8?=67?>0>??4=00=7015703?>04",
"43061<07;407=807?=075?08:808??08",
"1=0994082=08=;0759071:0749072208",
"=508<:08<5084:09=309;9093?090209",
">>08:=087008540839082808;9079906",
"45053>04:6032203:;02>1023;038503",
"5003<>0234031>034403070409044104",
"9<04;7047904>:038403?9024202;601",
"4=01>7004?00:4??0=??6??>;4?=32?=",
"?1?<91?<0>?<95?;?;?:03?:6;?8;5?6",
"23?561?3;8?104?1:1?1;6?18:?06=>?",
"79>?41?089?07??048?1:??207?412?5",
"4>?69>?75:?8::?8?6?8<7?9>3?:46?<",
">1?<;7?<9;?<9;?<93?<60?<;7?;7;?;",
">1?;54?<26?=81?>2:007401=701==01",
"??0194023<03>;03730401042503:902",
"1?020?01==??=>?>63?>26?>11?>:<?>",
"40??2=??65??3200350152025>039704",
"=<05;4065207<007;=0764076?07<=07",
">7079=07570763074?07;9060306<705",
"01062?065506;?065?07=;070008>:07",
"2208;=0826091709;;089108:4082?08",
"=<068:05;;042604:80366038<03<903",
"=603=503<;039303380336039703?403",
"3;048704<904=0047604=8031:032>02",
"6701=9005400<6??12??2;?>34?=74?<",
"?>?;:1?;4=?;25?;>4?:44?:6??965?8",
"00?742?59??321?3>7?364?4:;?387?2",
"6??26>?3>3?337?3:0?2?1?2;4?33;?4",
">8?4><?59;?6>5?632?7>5?7:7?8:=?9",
";=?:8??;?9?;?4?;:>?;4??;9;?:00?:",
"34?:?9?:?5?;29?=;1?>3?0056018301",
"1001=5002801:601<<019;0167018601",
"<601<0016=012:0104012901::011602",
"340213020:021<022>024:02<002;203",
";>04=605<40652075<0717070:072707",
"2707<?06550600060;06410665068<06",
"<>06>606=:060507470771074107<<06",
"760644064906;3063307680762073807",
";?0600064005>;04<504890466045004",
"48044;040904:1035003240336034803",
"5;0376035?031903=<029;023902<;01",
"870173014<011301=<00520078??6:?>",
"66?=7??<=??;94?;53?;=6?:2;?:5>?9",
"44?809?7=4?509?506?54<?511?55<?4",
"11?4:;?452?511?587?4:8?44??5>9?5",
"7:?685?72=?8>5?741?72<?7;:?734?8",
"66?888?849?9=3?9<0?9<8?9?:?9;6?9",
"25?914?9><?923?;1:?<4>?=9<?>37??",
"1=??4<??1600:900;900<4002:018501",
";=01=>01<3015701<000;1004101;?01",
"13027402?802550367039<033404<604",
"59052706?3067:07:607990777075807",
"2207>806;806960679064406?=05;<05",
":80595058;05:305<0051406;<062>07",
"2607;:067306:806>206>206<5069906",
"5206?4058505>3043104:<0376035?03",
"58035;033>03?902;702:30292026702",
"8202>:023>0362033?03>;028<025802",
"4902?1014101:50064009500530051??",
"6<?>=7?=1??=:3?<98?<73?<?0?;79?;",
"17?;8??::0?9:5?8>;?7;2?71:?883?8",
"1:?877?77??7>4?7=0?71;?7;1?612?7",
"86?7:4?706?897?890?865?8;:?862?9",
"6:?906?9?=?863?9::?98??97;?964?9",
"17?9<:?822?9==?94>?:=1?:=1?;;4?<",
"?8?<?4?<1:?=70?=9>?=<9?=3<?>8??>",
"96?><<?>8:??0<00?>???3??4400<=00",
"38019:011>0269026=02<;026?03>803",
"6904>?04<205<506?>06>3064=074=07",
">006>7060607;30633063>066=062506",
">:050:061006=:05;805<705=>05>:05",
">;05=:05<305;705::05;105<405:?05",
"7=0558052>05>3046<04>30380031>03",
"?402250340032?03470347030503?502",
"2;0344034703540344030203?102=602",
"6;020502<3015<01>80099002?00<0??",
"6;??0;??93?>1:?><6?=9=?=81?=5:?=",
"19?=9>?<1:?<=;?;55?;73?:;;?957?9",
"97?950?:8=?:19?:<7?927?::4?:9??:",
"<<?961?9;0?99>?9:>?90>?:1:?::??9",
"89?933?:>6?:>8?:9??:93?:;<?::4?:",
"55?:25?:>3?972?94??9:8?90:?:58?:",
"?6?:<>?;6<?<;>?<>1?<<<?<;>?<<5?<",
"=6?<>5?<=0?<:=?<04?=;2?=1??>56?>",
"8>?>07??;=??70000;018701<301?801",
"42029202?:0272031804<9041;052<05",
"48055205310516050:05?804<4048>04",
"9;04;;04<604<604=>04??0400051105",
"3?05540546053205210523051405?=04",
"?:040?0526052505>;04:9046>042904",
"=303860370038203:?03>;030004=403",
"=;03?;030304>203=<03>003;:038803",
"6:03070381022>02>501840146013;01",
"?0004?00<1??:9??9>??2:??9=?>:5?>",
"=2?>;;?>51?>13?>0<?>12?>=:?=4=?=",
"7<?<30?<0;?<21?<46?<4<?<29?<<0?;",
":??;15?<4>?<0=?<;>?;98?;<:?;<1?;",
"42?;0=?;52?;7;?;61?;41?;3<?;47?;",
"82?;:6?;4;?;;8?:89?::8?::9?:85?:",
"71?:74?:82?:;>?:30?;;<?;08?<?9?;",
"<8?;>;?;5=?<89?<5;?<45?<77?<<3?<",
">6?<01?=63?=<>?=13?>66?>>2?>69??",
"=0??130040007:00=4002?0174019=01",
">7014>028<029=02;202<?02<602<102",
"=;0211032203260356039003:;03:;03",
":=03<703?103??03??030>042?044004",
"2>041804150422042=04310452046804",
"470430043:044:048004?:03=6038=04",
"4<04:<03=6031;041204>?03<=03:=03",
";<03;0035?032203?302=202;5026102",
"0302>701=201;801<201:;0177014<01",
"1401<5009>00;400860017007???6=??",
"7???<4?>?2?=:2?==<?=>9?=;1?=7=?=",
"6??=93?=<6?=1;?>24?>=0?=75?=65?=",
"7??=7:?=1=?=:7?<75?<57?<43?<4>?<",
"47?<27?<=2?;93?;:=?;:;?;4;?;>>?:",
"???:47?;2??;=;?:?6?:61?;9>?;;4?;",
">4?;04?<?4?;1=?<87?<:3?<50?<?2?;",
">0?;0:?<31?<40?<5=?<7:?<75?<:4?<",
"24?=9=?=>9?=19?>63?><6?>1;??65??",
";4??07003:0058008200;=00=800?500",
"2901470124010301260167019901;701",
"=?013802:?0224037203870386038403",
"8:039103:203;703:<0373035=036403",
"48034903730370036;039803;>038>03",
"5<037:039603680336036803<=032804",
"3<0424042:042404>703=:03:3032003",
">702>002;102640254024>020602;:01",
">3010802?201==0117022202;1017?01",
"60012801=400;<005>00>5??>4???0??",
"7;??08??<4?>7<?>25?>?6?=08?>>8?=",
";??=26?>;;?>85?>;:?=6=?=55?>:<?>",
">>?=;4?==2?=98?=17?=?2?<0=?===?<",
"74?<20?<22?<?7?;=1?;=7?;94?;52?;",
"56?;6:?;2>?;1??;92?;2=?<5??<5??<",
"81?<:5?<=2?<>0?<;6?<89?<:0?<;3?<",
"<8?<???<15?==2?<::?<<6?<?=?<59?=",
":8?=>3?=38?>92?><=?>>;?>11??54??",
"95??;>??????6400:600:900:100;?00",
"?000=2009?00<0001:017101<6011=02",
"62028902<10208030;03=102<7020<03",
"1?03<;028<02;:02>=02?80233039703",
":0039703;>03:9038<0376033<032103",
"33033703400341039?03>0039703;603",
"01042>04<50354032303=4029;026>02",
"37024:025402500246028002<?02:602",
"7=02740245020702=901:401=6018;01",
"<900;:00:2005000<=??78??96??4;??",
"<2?>3:??06??<1?=82?=79?>;<?>;9?=",
"9;?=9<?>29??:=?>=:?=88?=24?>52?>",
";1?=96?=67?=3??=27?=?<?<=1?<1:?<",
";6?;76?;5;?;:5?;;6?;6>?;59?;;;?;",
"<0?;<=?;?>?;34?<63?<:5?<21?=4;?=",
"0:?=<5?<>4?<02?=9??<37?<5??<;=?<",
">0?<07?=23?=0<?=?=?<17?=53?=8;?=",
"=8?=13?>59?>=>?>51??6>??91??>8??",
"2:003<003>0068009;00930072007000",
"840092009:00;>001:018801=;010902",
"2?0251026?02:902?9022;0340035803",
"5;0351034603630384035>0301030103",
"3<032303=<02<;02==02=302;6020303",
"64036:0376037=03=503=;0371035:03",
"7?0365033=030103<>02=402><02=<02",
"6<02270227023:024602?:013702;602",
"?201;10142022502=201710140013501",
"<300>:??:<??=>??29??83?>:>?>12??",
"0<?>52?=8>?>:??><;?=96?==1?=32?>",
"28?>98?=?<?<67?=15?>?7?=:=?=62?=",
"59?=9=?=8??=>4?<6;?<57?<5>?<76?<",
"27?<:4?;94?;==?;33?<13?<>8?;37?<",
"92?<><?<26?=?1?<?5?<>??<=<?<=??<",
"?9?<;1?<61?<<<?<40?=53?=41?=3<?=",
"2<?=37?=32?=1??=42?=80?==3?=57?>",
">8?>3:??3=??2>??71??>8??4;007>00",
"78009800=;00>>00=:00=>0022011:01",
">900110194012;026;020<02?>013<02",
"6>02:202?902?<02>50203034;037403",
"=503?:03:1036;03430351034203;902",
"9;02=30214033103>102<5023203<303",
"77040;04140312033:04<<0303035<02",
"3002=:028<03050303022802;:02;502",
"6>020802>;0149025202;?015;014;01",
"09018500>0006701=200?>??1=004800",
"<<??07??8>?>:8?=61?=94?=21?=13?=",
"72?=>>?=?8?=:5?=<>?=0=?>:<?=>4?=",
"39?>?6?=>0?=:>?=59?=6:?=99?=23?=",
"51?<?7?;84?<=6?<47?<:6?;9<?;99?;",
":5?;:;?;82?;91?;37?<???<40?=68?=",
";;?=?>?=?1?=:7?=90?=90?=62?=???<",
";>?<?>?<27?=:7?<44?<<??<7;?=9=?=",
"9<?=<0?=2;?>:??>12??54??6<??86??",
"1200:200?40017012?01460151014<01",
"41015=0162015401620165019601;:01",
"=10120027502::02<80211039603<103",
"680332035<03:103=103=:03=403<103",
":?03850353033>03150397024002:902",
"140323034:03310338038<03;2038503",
"2<031<037503:603?7028?02<=020=03",
"=;024002<4011>02890238026501>:00",
"2?017801?000010014009600:;002>00",
";7??65??49??25??93?>52?>61?>0??>",
"11?=8<?<:??<?<?<3<?=32?=>9?<=??<",
">5?<=2?<35?=77?=39?=?0?<<;?<<2?<",
">>?<><?<=:?<?9?<0<?=9??<<7?<==?<",
";0?<42?<<>?;<;?;>=?;>9?;0:?<53?<",
"88?<;=?<>??<31?=6??=:0?=<<?=>>?=",
";6?=3=?=2=?=;0?=2=?>31?>=3?=95?=",
"<<?=04?>23?>79?>=5?>>1?>>:?>37??",
"93??:>??=>??5=00??007601:601:701",
";001=801300264021802:?019601=;01",
"2?02500244023:027302?:027;03<403",
">903130434041=04?103=603<803=?03",
"08040>04?;03=;03>903?=03;:032503",
":?02::02;702;602<802<902;<02=002",
"0403190323032>03?:02>802>:020303",
"?:027502?501?001<5013101=2003901",
"7?01?=006:003500?7??75??4>??49??",
">6?><8?>>:?>>:?>;4?>5;?>=6?=71?=",
"40?=>3?<76?<86?<<=?<:3?<18?<<??;",
"?;?;5>?<85?<7<?<99?<<>?<><?<26?=",
"96?=9;?=0:?=6=?<65?<93?<7;?<74?<",
"58?<60?<65?<40?<56?<6=?<5<?<5=?<",
"8>?<:>?<<;?<60?=?1?=32?>56?>5:?>",
"49?>5>?>7;?>72?>5<?>46?>?>?=:3?=",
"8;?=<=?=1??>61?><1?>43??:8???<??",
"6700<>0012011<015001;70122026302",
"720278027=029302;?02>602;:025<02",
"40029402>302;>029402:102;502=<02",
"240396032;0480047>048:04:704<204",
"<?04800404049<0377038?0373033<03",
"1203>102:402:602>002?502==02<?02",
"=702=8029=0256023>0247024>023102",
"05020<0242024502=<015301?1009?00",
"860080002;00;:??7>??51???=?>;<?>",
"9:?>12?>21?=:6?<;>?<;3?<23?<46?;",
"08?;41?;65?;<8?;>4?;9??;6<?;9<?;",
"0>?<4;?<=<?;65?;8>?;>7?;=7?;>4?;",
"1>?<4??<61?<52?<8:?<:;?<74?<33?<",
"3<?<87?<:2?<84?<6??<93?<>7?<64?=",
"<>?=25?>;8?>64??=>??0000<4??38??",
";<?>:6?>;2?>99?>57?>46?>63?>98?>",
";=?>=>?>0???43??:4??3800>7004?01",
"4<015701<7016802:602::02<1020003",
"4;037403860366031803=802=0020=03",
"5=03570337037503>?0362043704=>03",
"2:04;004>2040;0532050:05<>04>504",
"3905?:043704:;0364032803=:028302",
"49021602=>01?10139028802?6023903",
"3803330311038902?801?0011=02<;01",
"49013;015?0112019>005800?8??83??",
"7???98??30??6:?>:6?=28?=<1?<7;?<",
"4<?<0=?<=5?;>??;>1?;56?;?5?:=>?:",
"?4?:<=?:42?:=2?992?9:<?963?:==?:",
"87?:39?:<4?:4<?;52?;82?;:??;69?;",
"4>?;8;?;;>?;>5?;=<?;?4?;8:?<19?=",
"55?=65?=69?=68?=9;?==3?=>2?=2>?>",
";:?>2>??>8??3;000000<2??:4??;5??",
"=4??;5??:0??:5??58??49??5=??32??",
"0???68??22001:0100027>02:402=602",
"?;0212030?03?602?=0252039503>203",
"1704>1039=039<03<30313043<045804",
"790481048>04?6043;050305<004=104",
"01053<058905=005>405:;054605=704",
"2;048403540345031?031?03=1022?02",
">9010602210216020>026002::028:02",
"52023=02?9017;014;0144012401=<00",
"9:0056001100=>??;0??36??98?>66?>",
"34?>:4?=14?=<7?<78?<???;8??;32?;",
":8?:1<?:?4?903?:?9?92:?:4:?:>=?9",
"43?9;>?8>??83??9>8?866?87??84=?9",
">9?93;?:6:?:64?::3?:0<?;62?;;8?;",
"?4?;=:?;<<?;?1?;23?<6=?<:5?<=9?<",
"01?=6=?=>>?=4<?>5=?>95?>5=??6700",
"<7005900<>??=8??=>??;7??:???>1??",
"4=00<800>?00?800>=00:700:4001?01",
"?00177025>024=029702=4022>035903",
"63039403=<033>046<0452046<04;>04",
"430584052:05<604:904;5041>057;05",
">?0593067306?<051506420608067:05",
"4105:305>6056;05;704230484030503",
"?>02>7028;02660262024;027:027402",
"?4019>018:017?017>016<015;013101",
"?80004010901::005?00670080003>00",
"=7??8=??75??17??51?>;1?=4>?=06?=",
"<2?<5>?<>0?;5??;;4?:>2?948?9<1?8",
"99?8?2?8<=?830?8>9?707?86??86:?8",
";3?796?73??8=;?877?984?:<:?:1>?:",
":7?9;:?980?:4<?;52?;?>?:0<?;50?;",
":=?;28?<76?<3>?<;>?;=>?;=6?<1=?>",
"07??67??;:??04002;007:0089001<00",
"=<??1000;?0020010<01>300=2008>00",
"35003=00>20087013002==023903?902",
":702=2029;0353048<04<=042105:005",
"24063606=2053005<904?5042<050?05",
"<404:;04?4045405:>05?105=8059805",
"9=05?=05;;06?<06:40674069806:806",
"4<06:105?=0468041404><039<037703",
"1;0353020302270227020>02<101<901",
"08020;02>?01?501=:016?012701?800",
"9>0056003500>9??76??46??23??<5?>",
"3;?>;1?=1>?=7=?<0<?<>8?;;>?;5??;",
"?0?:69?:;=?908?9;8?8<:?8>8?8:8?8",
"45?828?8?2?7=;?7;6?73??740?76=?7",
"64?79<?779?801?9?0?80=?961?9=;?9",
"40?:3;?:58?:24?;;>?;8??;77?;06?<",
":0?<>1?<<6?<91?<09?==0?=53?>49??",
"4?00610023002=007>00;?0093007100",
"9000:200;<00>7005201880148014901",
";901160247026;02;5021>03=<02>202",
":10346047504350468043=058:05;805",
"5:06;<0684061906=605?605?005:505",
":>052706:90628077:076?0714079306",
"2<06?<05=905;>058?0580058:055>05",
"=8043>04>303:>03870365032?031703",
"=4028>025202;5011<01160147016>01",
";2019;0167017701660106018;000600",
":9??6>??34??48??58??22???9?><1?>",
"2>?>5??=9>?<1=?<=:?;87?;?1?:31?:",
"47?945?8:;?7:;?794?721?7<0?6=3?6",
"26?70=?7;;?694?6:2?6:4?6;8?68;?7",
"65?87;?832?892?843?98;?9:1?9;6?9",
">6?903?:45?:91?:0>?;76?;90?;=:?;",
"70?<09?==:?==3?>88??>7??26002100",
"21006900><00670193019201<?01>501",
"73010101>>00>100?>0090014602:<02",
"9<029:02100365035503;:0392042105",
"5=05:<057906??067906=:05;705<005",
":1059;052<06:4068<063<061106=005",
"3=05=?0417059;05510600072:070007",
"=806:=0690063<069:053?0504059=04",
"7?044<04:3032>03=>0275022;020102",
"<<01;301;401==010602=60168014>01",
"5>012701??004<01:701:>017?011301",
"7;00<6??4;???3?>38?>68?=<<?<3;?<",
"==?;9;?;5;?;14?;:3?:37?:>0?969?9",
"?=?8;7?877?852?817?8<;?75=?799?6",
"27?6<??53;?544?5:2?502?6:9?61:?7",
"2;?735?75??7<4?7:8?83;?95:?920?:",
"1>?;60?;:=?;60?<=4?<?>?<?;?<46?=",
"?6?=6:?>74?>;4?>48??6<??2;???3?>",
">=?>04??23??9=??3=000;01=6015002",
":902<60286027:02;1024803=303=:03",
":;039?03:0036=035?03;=031;048004",
"1405<405650668063306950622075307",
":907?8070708170836086;086808>107",
"7?074507:>062806=205;005<205;<05",
"91052:05:=044>04><039?037>039;03",
"=703==03=603;6032:03970269025202",
"36021102=101:;015201==00<:00:000",
"4=003>005?00:?0030017?01:>019>01",
"5701?:0053008>??>=?>52?>9>?=16?=",
"<9?<16?<21?;48?:3>?92<?89<?7;2?7",
"09?813?88<?74??760?70;?7<:?6=0?6",
":3?652?670?6>:?626?742?7>4?646?6",
"2=?653?67=?61>?7?=?75:?83>?860?8",
"4>?976?:>1?:<9?:81?;>2?<;4?=51?>",
"35???7??:1??3<??????;>00>>??=1?>",
"0:???3??>5??34??7<??62006100>8??",
"7=00;60123028002;603=>04>:041304",
"0104950479043:04>904>:0542061906",
"08062<068:05<=0427053706<:06::06",
"8=06?:064?0745077507<707?007=507",
"=80759084?087;0713070907=<063906",
"4;05:>040:0446033?03=>031104=203",
"::036=03>?029?029>02<<0206032803",
"250306038?02?;0194012?0113016301",
":101;901;=017>012601>300;3009000",
"2>00:3??0>??75?>?;?==0?=:4?=3<?=",
"?1?<;0?<?>?;>=?:1>?:;1?95:?9=5?8",
"82?8:2?81;?8=7?6>0?572?544?52<?5",
"4=?5<8?567?698?686?6>7?641?7?8?6",
"::?6;0?6;:?609?775?7=6?779?806?9",
"89?980?:69?;97?;7>?;76?;=8?;>4?<",
">;?=85?>=6?>:??>3>?>06?>06?>64?>",
"07??54???4??>8008301==017801;700",
":;00>>0070012602:102?=027603>503",
"8=04><04=104?7047305<705<?05<?05",
"22067;06:=06>806<;06600620065<06",
">?06190713077707;>07<807<0078007",
"=4064206:00693072708>=075?07?506",
"6906:=054105?5045104>60347047:04",
"2=04=6038>035?0341031;03>1029402",
"5>02460244023:02530276024:021;02",
"1>02?701:=019501:>01:3010=015600",
"<7??0???6??>30?>23?>?5?=;<?=95?=",
"75?=30?=89?<=8?;4>?;=4?:6:?:?9?9",
"85?927?9=:?88>?81;?873?7=7?65<?6",
"<1?5<??464?4;1?4:3?458?486?428?5",
"<5?5>??5=6?548?619?753?7>;?73:?9",
"?>?9>:?9<:?95>?:0:?;3??;2=?;64?;",
"1<?<;0?<34?=12?>86?>1:?>81?=5=?=",
"97?=>5?=3;?>?5?>?8??<7007>013102",
";:02>:02:40290021?0383038803<<03",
"26041>046403?2024;03=6031:046<04",
"1=05:805>>058>062<073>07=006<>06",
"2>079<07?6075508:>089:087>08<208",
"9508>207160786066>0669063:064506",
"4506=<05660534054:05760589059005",
"9605:5057?051605;:044804::033<03",
"0103>=02<0025902240222020<02?;01",
">:01;=017=013=0121010>01>=00>:00",
"0<01?:00<30091004300=<??3=??8;?>",
"?3?=6>?=>=?<63?<>2?;4>?;84?:=1?9",
"63?92=?909?9;=?8<0?803?9=5?857?8",
";>?713?75<?6;;?558?542?551?569?5",
"<>?500?6;7?5:0?5;=?581?53=?533?5",
";6?596?64??75;?8;4?9;7?:15?;28?;",
"43?;68?;77?;?5?;10?=?5?=41?>59?>",
"1=?>5??=4<?<=6?;:9?<>9?=;4?>94??",
"<=00;<01>301:601950176017701=701",
">002?40340047:04?20433050305>704",
"?804;;043=040>048?04:<054>068;06",
">506<=0689068=06>>06<00785080:09",
"<109660:240:0209?0074407?=06=506",
"<>063907:8075107:5064206;?052005",
"17058305:=0588053:0537056:053005",
":?0463041304;=036>032=03?:02==02",
"=702?6020?03<;022?026001=:00;000",
":000>:005<018<0168010;01:<003?00",
";5??39??>4?>9??>41?>=0?=38?=9=?<",
"07?<4:?;8:?:00?:94?955?90>?9;<?8",
"<:?8?9?8=3?88??828?86:?795?6==?5",
"2>?5?0?42;?591?538?6=4?6<>?686?6",
"35?684?5?0?4=5?4;:?412?516?64??7",
"7>?87;?923?:9=?:>5?:=:?:0??;>1?;",
"64?<87?<:2?<<<?<?>?<84?<71?;=6?:",
"0=?;=<?;=??<8;?>53006=0151022103",
"8=03>;0287011>01;=016;021<032804",
"3>05<005?9055?068006:9059=048:04",
"1305:605=?050706790666062<065206",
"8406080730084=093>0:060;;=0::<09",
"==08=?078;0674050=05:305:<060=07",
"2>075<071<0775063<064406?3058<05",
"7305>005760668061406;005?3042704",
"<703960371034803?=02<>028>020=02",
":1015301>:00<9004301>:0159027:02",
"1;028=012<018=00=7??45??=3?>3??>",
"83?=09?===?<9:?<34?<=6?;7=?;10?;",
":>?:76?:63?:0=?:;0?9;8?90??:47?:",
"18?:;6?917?91=?803?714?6:5?53??5",
":9?444?44??46>?46>?490?4:3?486?4",
"83?49;?43>?52??6<5?67:?76>?848?9",
"0;?::9?:38?;9:?;9??;72?;5=?;6<?;",
"77?;2;?;96?:>;?9:1?93=?:52?;27?<",
"57?=>>?>600076012402>70258030003",
"=102140334036>039103;=0311044<04",
"<7048105=805:1054;05?804:204:304",
"=6040>0595054506<20689077>086809",
"280:4;0:470:4:0:<509?4085308<;07",
"32079706930622075=07250711074407",
"5;0758079507=:079907?8067106?=05",
"7605?504>:042>0533050005<5047304",
"=903?50209027201540158017101<:01",
"1:023;024>025?0267023>02=4018=01",
"4701<=004500=5??75??><?>39?>:1?=",
"52?=14?=;:?<66?<4>?<68?<54?<1;?<",
"?=?;;:?;3>?;<8?:6;?:2;?:>7?998?9",
"3=?9;=?813?875?7<<?602?644?5;<?4",
"44?4=<?3>=?372?4>>?438?589?5?1?5",
"5??680?686?6<4?606?71??782?716?8",
"9>?812?970?9?<?972?:50?:<:?9;:?9",
"=1?989?951?9>4?920?;07?<<6?<>;?=",
"=:?>39??82??510025017701=601<202",
"800323039102;=02=8025302>2016902",
";30332046?045?056506:6064:067<06",
"12071;07<70631074408>=0833097:09",
";5098409<=085108?2074307=>060;07",
"7;0797075=0762077507540734073907",
"8407?00720080508>:079;07>9063006",
";<058:053605<30486046;0408045?03",
">302=302;10278029802240389037903",
"4?0375039>036703>7026<02>3016:01",
"00017>00>;??49??<>?>92?>63?>1=?>",
"><?=;9?=7:?=3<?=05?==??<<6?<;;?<",
"94?<3;?<==?;97?;60?;21?;:7?:>9?9",
"5>?918?997?8<:?7?3?65;?604?6;;?5",
"96?58:?591?5;<?528?688?6:9?69<?6",
"7=?681?6:0?696?60>?668?53>?5;:?5",
"66?606?7::?764?8>??816?957?9:=?9",
"92?943?95<?9><?9<>?:7=?;=2?;59?<",
"0<?=;7?=31?>65?>:;?>49??0>00<200",
"0;01>700=;004=0100023202=401:801",
"3;021?03?203<:048:05?90522061206",
"?905>>05070631067606=;066?071308",
"6708850864081108<=07=40715081:08",
"?0072708:008=<08=>08;?0884084108",
"0008>807<?0798077>07970789071:07",
"710612061406>60581053>051?05=204",
"3?04=>03;0035<03?502?4027903>?03",
"0:040<0432044204>;036<03?:026?02",
":?011:01=600;5007<0054005:003:00",
":5??32??35??10??9:?>38?>08?>=;?=",
"69?=>2?<<4?<=9?<8;?<:>?;>7?:90?:",
"95?:<2?:;8?:4=?:<=?911?9;??8::?8",
"06?836?744?7<>?70:?8<5?7=:?72;?8",
"98?783?653?601?731?7:0?632?664?6",
"92?6;>?6>=?6?:?6:9?620?64<?632?7",
";:?73;?873?9<6?:68?;3=?;09?;?5?:",
"74?:=0?9=;?983?:3??;<>?;7;?<35?=",
"59?=12?=4;?=50?>:8??9<003<01?;01",
"820268022?0248021102?4006900;;01",
"9<03:=0450052;06<10628061105<704",
"?904:=044>042505<606<;073708=408",
"79096609=30880085:08;507>?06=>06",
"4?076007=<068<06;106;4065:066806",
"0707:10705085708::086;085<072?06",
"8;056005370518052005380529052?05",
"87058=0592043303:102<202;102:202",
"06039?039:0303034>03?6031>039801",
"4:014802930211015:??;0?>=??>>9?>",
"79?>92?=8<?<80?<21?=41?==6?<13?=",
"12?>85?>4:?=49?;57?::7?:2;?;60?;",
"<>?:37?:19?:4;?:?8?:55?;05?;<3?:",
"43?:62?9?0?826?97<?8:<?6>;?5<1?6",
"=1?732?9;6?::4?:55?8>>?5>2?542?7",
"18?898?8>;?8=5?841?9<7?95;?955?8",
"00?897?8=;?89<?82>?9>2?:29?<60?<",
"52?<?4?;05?;2:?:1:?:5:?:5;?:2;?;",
"?7?<?3?>:400=90119021801<:???7?>",
":1?><>?>;3??=5009>0176025203<=03",
"79039;020502?301850281036604>904",
"77052406;606?2067>06=7059705>205",
"55068:06<606370766072=0722075>07",
"3407<406?006:707;=0744073507;>07",
"1<081908?4079307?00678064?060?06",
"7=054105;9053406?5052805<8042:05",
"7?0516050:042?03<702<?0230037=03",
"=20375049=04=703<5024402>>01?200",
"?5??::??97??::??550099016202::01",
"????44?>31?=53?=0;?>14?>52?=3??=",
"7<?>=<??6;??92?=1>?;>6?849?861?9",
"92?;9:?=03?>;;?<35?;>2?:?8?:2>?:",
";8?819?8;:?8?7?9;:?:9>?:7=?:48?;",
"45?<97?;:3?9:6?7;=?61>?7>5?76=?8",
"60?9=1?:;4?;::?;>4?:93?9?:?73;?7",
"5:?814?:1=?;0??;=8?98??8<<?899?:",
"<;?;0<?;<<?95>?:29?<4=?=4<?=;2?<",
"30?<3=?<59?=27?>29?=89?;?;?:47?<",
"66?>11001?01<601?:01050230028201",
"90??=7?=14?>10004802>2037=04<304",
"5705040680057203<401;601>5028304",
"9>057?05?=044405=5050:06<305:005",
"4606:207:808:608=207<?065?063>06",
"1:06>5055=05>>044;0565067207>>07",
"0:08=707050714063:056104;5035:03",
"8=036504=:0529077207:7063<05;003",
"5802>101??0102027501=4002>018402",
"=403>70303030;02650149013001;500",
"1:00>>??53008>000:0036??;>?>5??>",
"2>?>6:?>>3?>=4?>:2?>:=?>99?=9;?;",
"69?:?5?:;??;:<?<06?>88?=86?;68?;",
"2=?=15?>25?=21?;3>?9=5?84>?:5;?;",
";<?:05?:;3?933?::<?;17?<3=?;:8?:",
"?<?:44?;:5?:21?:6:?:41?;1=?;46?:",
"3??9=;?863?9=1?92:?:;=?:32?;<=?;",
"0<?<:7?;:4?:;7?97;?951?9;0?90:?;",
"4>?<>8?<46?<<7?;;<?<<??=;0?==7?<",
";8?<55?=27?>6;?>8=?=?9?<07?>90??",
"83??66?>57?>>3?>50??23006901;902",
"4<03=5026:0107001100;6019=034<04",
"<5032703<10256026<021?03>6039804",
"71054306<206<20640063305>:036503",
"=<030605?;055106:7064407>907?>07",
"0207>8057705=?046204?>044;064907",
"49076?063:054<04:8047:05<;04::03",
";5033704:?04>204:>04>>0321037602",
"<0015<017;013802:403;>04=904>603",
";802:=01<5??09?>=;?=83??8901?302",
";1031?036:010>0055??>2?=8??<66?=",
"0???>=?>50?>76??9400?2??90?>01?=",
"?;?;47?<81?<:>?;?4?:>9?;1=?><4?>",
"9>?=<5?;1<?:2;?91<?9<<?9<;?:;7?;",
"18?=06?>:4?=07?<29?:;8?96=?:;5?:",
"17?:=3?917?;<6?;8>?;6>?;80?;11?<",
"10?=;2?<7;?:;=?8?3?8:3?:8>?;:;?;",
":<?<61?>?>?>80?=:;?:94?95;?::8?:",
";??972?9;>?;<9?>350061??0<?><4?<",
"88?;19?;:7?;42?<<7?<;9?=18??=700",
":502=7026?0002?=5>?;99?<36??4=01",
"2>020402220288031;044702;;???4?>",
"0400?501:703;6047;054706=>06;505",
"?>020;012>01;8021=0438053806:706",
":20686062:06150543037<011201>802",
"0506?1077>0746065=0631071?07:405",
"=80392038304?104<>04?3041<056704",
"340332033:048504>9030=0369022603",
":?04=7041?03?=018502130342025<01",
"3101:501560224023:01050100023;03",
"020253??82?=7=?=;:?><???13016?01",
"38??10?=8<?><?01280247??:7?<85?<",
"67?>29??76?==:?:91?:88?<97?>6???",
"?:?>=5?<:=?::2?:08?<;2?=90?=?9?;",
"?>?::2?;20?=4<?=<3?;18?;=<?;8;?<",
"39?<96?;>2?:70?:7??:?8?:57?<25?>",
"<5?>>:?<9:?9:7?76>?9=:?<<>?>4:??",
"4:?>5>?;81?8:>?87>?::>?;15?<82?<",
"1>?=<2?=>5?=>3?=9??=<5?<20?<:??;",
"0<?;=1?:17?<60?>>3??0:00:=??<???",
"::???9?=<=?;33?;49?<49?>?1004;03",
"9:03==01:6??98?>3;?>?>?>0801;302",
">0029802>=0228030<03<60245021001",
"68005601830210035>04;;06;;079:06",
"=;0489039102==018:019;01>6020805",
"?>057605>904<=05><065=06>>03=401",
";601=5022<04;=04;?040;05:6051<06",
":90516047;02?>019<02>503;204;=03",
">901=>009701:=030<048601:7??:;00",
"5<03>20444046=024:011?0130012:01",
"=6016701;<?>;3?<86?>500221033601",
"29??48???<00580119??5=?=84?>73??",
"=1?>45?=:6?<?6?=7=00:>01:>??;5?<",
"3??<64?>5=00>3?>47?:12?77<?849?<",
":>?>=4?>0<?>7<?><<?>8??=>??;?3?;",
":??<3??=91?=5<?<5<?:?:?981?;00?<",
"<>?;7=?=;7??56??8=?<42?:=<?948?;",
";;?<=??<1>?=37?>::??0??>:7?:8??9",
"5=?;16?=32?=59?=94?>><??2;002>?>",
"=4?:95?978?;7??=:=?=64?<49?;7>?;",
"?2?=4=013?036302050072?>:=?=60?<",
"22?;=:?;88?>:001=;039?036501:2??",
"?0??<6004<0030??=3?>29??1900??01",
"4?0448054704320313039?029901:=00",
"02007;00;8026;059?06>:05:<049903",
"6=02;:00?5?>9:??5?031507:?07<005",
";2042<05190515034;002:??:=??7901",
"780443077808><070506<902;=??64?>",
"9=?>48006<02<?03;60491057?058=04",
">2039:03=80158??>4?=<1??>>02;?03",
"15029700?>01<=041;05100248?>35?<",
"33?<4>?>5401:803:1046003=100????",
"2:00;9?>;6?;3>?;=>?=410065004:??",
"<<?>01006102;20159?=80?91:?97=?<",
"34003701:3??;0?>6800<401?8??=9?<",
"11?:54?724?732?:=1??:;03>00267?>",
"9>?;85?<<7?=<??<>2?:15?::3?:?=?<",
"52002=0109008=?>35?=9;?;<5?;<??=",
"62?>51?<1>?:;0?:::?<7:?=71?=96?>",
"4<??;??<3=?:2<?<:?000102;;?>80?;",
"8=?<=5??2>01:9???3?=96?<<9?:30?9",
"9??;80009=0248009>?<6:?;?8?=;600",
"48??0=?<7>?<<=00?403<<035>021=02",
";502350215??39?<09?=;>0095028600",
"8??>000065022<032802:2004????:?>",
"3:002<03?>06;00829064102:?01>>02",
"?;0171??0;??>:0107057:06>605?<02",
"78??85?>190010026003;=03<2038904",
"0706;;065705>>0249012>0154021603",
";<02=;01450180018;020>03::01?8??",
":6006702<302?=013501>?0175038:03",
"880143005501:102<<025:029=013;00",
"25??><?>78??2;01<002;>00>:?;6<?:",
"81?>8703<?0388007:??7?0212050602",
"<1?;>0?9:??=>3002<013<0065?>>8?=",
"?5?>6??>?4?;84?;=0?==<?>8:?=3<?=",
"?1??5=02=100;??<95?<;100=701?1?<",
"?;?622?79<?=<603640373?>30?;1<?;",
"01?;63?:>:?;;2?><5?>56?<47?<7:00",
"8303180157?<9??:0>?<11??2801<0?>",
">??835?6;6?981??9802?=01>5?><>?;",
"<9?:>=?;:6?=13?>>0?<1??<45?>3902",
"<003><0012?<<7?:09?>;100::?>8=?:",
"29?:05?>2701320252030?03<9??35?=",
"98?=<>?=18?=2=?>6801300476055?05",
"920235?>85?<=<?>19018;00>7?>>0?>",
";801<:0503076:03;1?>1;?>5=01:003",
"2:039;017;006;007202>4051507:<04",
"0>0170??5;004202?102?701?=009:01",
"4:03900354022:02?603>40513062704",
"<<017400==009=029103:;01?0?>2=??",
"?<01390482049403:?01::??>8?>85??",
">=015=041=04;;0154008401<<025402",
"6401?>002<00<3?>???>?60034020502",
"7300;8?>89?>4900970267028:?>23?;",
"3??=56028>05:<05?802=1?>68?;:=?:",
"50?=70007<00=3?<:9?9:7?;33020706",
":6024:?=?4?;43?==5?<5<?;58?<9=?=",
">3?<67?=:10164042?022=?>06?<90?<",
"1=?=11?<;??:4>?;::?>>=0025??:??;",
"65?;61?>070034??=1?=23?=;6?<<3?<",
"<5?=?8??9101;1005:?=>1?:04?<86?>",
">1?=<>?93;?8<0?<690293025<?>:5?<",
":0??270200000;?;1<?860?959?=5:00",
"0602>?026202930045???8?>=0?=>5?:",
"4??822?9><?=5603650506046?024802",
"3>02>:??=5?:;=?76<?;67032?08?:05",
":00100013303;<03=200:??<31?;3<?=",
"6001:;043?0582042604:1037?024>01",
"5<002???0>??5:0173046>054<04?602",
"<00224033>026:??89?<73?=70027?06",
"0>0657033<02::0209031?037202?>00",
"9>00<10130035;046=04=001>:?>3?00",
"9<043?061403:=?>98?=5:004?037203",
";2016100>=??;>00:6035305:=035901",
"9400<=0014013=00???=24?<7=?=6001",
"6303850184??13013?03040170?;93?9",
"==?=7;04:006>001;>?<1=?=85??7>?>",
"<4?<6:?>630073?==??:54?>50037503",
"<4?>96?;99?=7>00=4?>56?:2;?8;<?<",
"8=04:80526??55?<1900580161?<>;?7",
"89?870?<4000590128??>5?<?<?=6>??",
":0?=;??;9;?=45??7;?=;7?;24?=:??>",
"<3?=;1?<==?=;;??04006=?=;2?987?9",
"<5?=;101;<??1>?:39?995?>2:035902",
":9?>4=?<87?==9??8???:8?<25?<<9??",
"?2014=006>?>95?>;??>=9?=82?=55?>",
":2?>96?=:>?=;:004:04=504>901?5?>",
"8:??5102240291?=97?997?:82??;404",
"4<07?;0531025;??=??>:??>72?>36??",
"7>??>???6302=<05=20627044=016801",
":4020402?8??<3?>43005<0393043503",
"340235031:0486020:0071??4000<400",
">;011005=40790069802520036014902",
"01024;01=9000201=5027?040;042702",
"0?0069??;5015:041003<3??<8??6503",
"99048301?4?>0201;5034?03;1013301",
"4601260027??>=???=009=??19?==1?=",
"?8018?0592042100?3?=:>??2<0155?=",
"34?9;7?<8:03;>040101???>2900<200",
"83??>3?<4??;83?<=>?>:6?>88?<:>?=",
"11028?039:000:?>1??>:>?=<6?:2??9",
"=:?<370265039<??0<?<42?=10010800",
"8<?9>1?6:6?<1201<<?=?2?:6=?>8<02",
"5001:6?<?=?:70?=3;??0>?>=8?:72?8",
">;?994?>3<0230025900<:?=14?;?2?9",
"92?;4;?=58?=98?<07?=:6?>:=002<02",
"560159?>>7?<76?>64??00?<:7?88:?;",
"1?02>=043>0273?>2<?=:2?>330054??",
"92?<48?;96?<>0???3027=03?<01>:??",
">??>3?0044028;0116??<1?>5<009101",
"5301230059???;009?033803:=??<;?=",
"1100?<020403<9014?02?>0364047<03",
"1903:60203013???4;??270188023?02",
"6402<10303054?043:021<015101<=01",
":101;800=>00=302:>04;=04<>031603",
"=<020303>:02;;011:00770087021=03",
"<601>600970138029<024003?>021102",
":0018101;4011:035:03;400=4?>8400",
"2=037802<???;??>>6??4001>30063??",
"69??10026403:10020?>2;??8300=5??",
"38???>??2301?70038???<?==;?>8000",
"><??58?>9:?>9>??9:??:<?=7=?;99?<",
"6700:>01<8?>:3?<76?>0901=:00<=?>",
"7:?=11?=3<?=63?=5<?<;7?;43?=?5??",
"86??6<?=;:?=79??93?>6>?;:>?:=1?<",
">5?=49?=?4?=2<002801>>?>66?;8??:",
"?3?<<;?>43?=<:?:53?<86??36??58?<",
":3?;?:?=88??1:?>=??<?6?<8=?=15??",
">:003800<??=;=?<:6?<53?=<9?>?2??",
"93??:;?=>;?<>6?>;;00;1??2:?>57?>",
"56??<6??25??=3?>=4??3701:=016300",
":<?>:1?>0600;800>7008;01:9019:00",
"?3??7200;;003100:1??>3??=900;701",
";?02:7031>03930166013;02;001<800",
"?5008?01490216036>03;602?5012?02",
"95024902=>018001;000290195031405",
"<303;2019101?402:803040331026102",
"?602180374026:01?700>7011<034603",
":802>?01:90134027?03>;037602;500",
"08016?025;028<00;1??7>0187032403",
">6016>01<00028009100>700420076??",
"91??9200:<019301????77?>79??;401",
"=?01>9??60???=008201230000??;:?>",
"3;?>8<?=>3?<94?=23??54??=>?>:9??",
"8:00?4??:5?>><?=37?>9>?>?9?=04?=",
"68?=42?>19?>:0?=9<?=07?>;8?=38?=",
"90?=0<?><5?=3??=71?=67?>=<?>8:?=",
"=>?;:5?;6=?<55?=1;?>=:?>>5?>0??>",
"81?=>;?=41?>10?>60?=44?=2;?=35?<",
"=0?;;3?<5<?=8:?=06?>65?>8:?>;>?>",
"<??>70?>4;?>40?>;;?=<>?=;??>51??",
"=0?>2=?>1:?>39?>23?>3??>02??;=??",
"<>??;<??02000100;=??<5??<;??98??",
"7=??66??9???3300=>003?0154015801",
"?20070008>00=20093005?00;2001801",
"530168013;011:016201=701=?01:;01",
"=701150215020002><01=6012302:?02",
">8027?02=9018?01<00113026502;802",
";>02;102;402=402:4022302?<015502",
"6=02220201022<029602?<02=;029102",
"6<0268026:025:024102240208023002",
"430205028:015<018301;901<:01:;01",
"9<01840158012>012;0154016:017>01",
"7=0154011;01;>0078006>007;008=00",
"720046004600490050002700=6??;=??",
"<5??:=??86??7:??93??96??88??6???",
"55??41??14??07??>3?>:8?>;;?>>0?>",
"=8?>::?>86?>5>?>2:?>01?>?5?=?6?=",
"?7?=13?>04?>?;?=15?>1=?>0;?>0<?>",
"3:?>50?>0:?><2?=:=?=:9?=97?=69?=",
"5??=8??==3?=01?>10?>07?>03?>><?=",
"<??=>9?=0<?>>7?=<0?==;?=0;?>04?>",
">=?=>8?=?3?=00?>1>?>38?>41?>6=?>",
";6?><6?>8>?>4:?>4:?>7:?>9<?><;?>",
">4?>;=?>;9?>0>??4:??3<??2>??5>??",
"9>??;5??:???:<??:>??;;??<0??<1??",
"=4??120048004=003300490077009200",
"90007200530034006400<200>=000101",
"270140012701?700:>009400<;001?01",
"510164019501=601>:01;90175012101",
"=800=;00260166016>0154017701;001",
"=101;4015:0131018001=:0109020802",
"<801;401;1019;0187011>01:;007;00",
":000?60028014?017?01;101<>019?01",
"2?01>:00;>007=008200<800??00?;00",
">?0033014:01?1005?00>;???;??3:00",
"42002:003<008100;:00:=003300=1??",
":0??92??>7??0:00>1??130084009000",
"07009<??83??5????3?>>9?>5>??98??",
"74??83??;9??=9??<1??6;??>5?>>2?>",
"57??58??0:??19??5=??3<??=4?>" };

Sound manual_exampleSound () {
	static autoSound me;
	if (! me) {
		long istring = 0, ichar = 24;
		me = Sound_create (1, 0.0, 20457.0/44100, 20457, 1.0/44100, 0.5/44100);
		for (long isamp = 1; isamp <= 20457; isamp ++) {
			uint16 part1 = data [istring] [ichar] - '0';
			uint16 part2 = data [istring] [++ ichar] - '0';
			uint16 part3 = data [istring] [++ ichar] - '0';
			uint16 part4 = data [istring] [++ ichar] - '0';
			my z [1] [isamp] = (int16) ((part3 << 12) + (part4 << 8) + (part1 << 4) + part2) / 32768.0;
			if (++ ichar == 32) istring ++, ichar = 0;
		}
	}
	return me.get();   // reference
}

Pitch manual_examplePitch () {
	static autoPitch me;
	if (! me) {
		Melder_progressOff ();
		me = Sound_to_Pitch (manual_exampleSound (), 0.0, 200.0, 500.0);
		Melder_progressOn ();
	}
	return me.get();   // reference
}

/* End of file manual_exampleSound.cpp */
