// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                          avtparaDISOptions.h                              //
// ************************************************************************* //

#ifndef AVT_paraDIS_OPTIONS_H
#define AVT_paraDIS_OPTIONS_H

class DBOptionsAttributes;

#include <string>
 
// Read options
const char *const PARADIS_MATERIAL_SET_CHOICE = "Material Set To Use";
const char *const PARADIS_NN_ARM_THRESHOLD = "NN arm threshold (-1.0 means no threshold)"; 
const char *const PARADIS_VERBOSITY = "ParaDIS 2.3.4 reader verbosity (0-5)"; 
const char *const PARADIS_DEBUG_FILE = "Debug file name"; 
const char *const PARADIS_ENABLE_DEBUG_OUTPUT = "Create special debug output files";

// ****************************************************************************
//  Functions: avtparaDISOptions
//
//  Purpose:
//      Creates the options for  paraDIS readers and/or writers.
//
//  Programmer: rcook -- generated by xml2avt
//  Creation:   Thu Mar 11 15:15:39 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *GetparaDISReadOptions(void);
DBOptionsAttributes *GetparaDISWriteOptions(void);


#endif
