// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                         avtOpenFOAMFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_OpenFOAM_FILE_FORMAT_H
#define AVT_OpenFOAM_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <utility>
#include <map>
#include <vector>
#include <vectortypes.h>
#include <avtTypes.h>

class DBOptionsAttributes;
class visit_vtkPOpenFOAMReader;
class vtkStdString;
class vtkMultiBlockDataSet;

// ****************************************************************************
//  Class: avtOpenFOAMFileFormat
//
//  Purpose:
//      Reads in OpenFOAM files as a plugin to VisIt.
//
//  Programmer: biagas2 -- generated by xml2avt
//  Creation:   Tue May 21 11:07:32 PDT 2013
//
// ****************************************************************************

class avtOpenFOAMFileFormat : public avtMTMDFileFormat
{
  public:
                           avtOpenFOAMFileFormat(const char *, DBOptionsAttributes *);
    virtual               ~avtOpenFOAMFileFormat() {;};

    virtual void           GetTimes(std::vector<double> &);
    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "OpenFOAM"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);
    // Number of variables dynamic
    virtual bool           HasInvariantMetaData(void) const { return true; }
    // Number of Domains dynamic
    virtual bool           HasInvariantSIL(void) const      { return true; }
    virtual void           ActivateTimestep(int);

  protected:
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
    void                   SelectPatchArray(int, const std::string &);
    avtVarType             OpenFOAMClassNameToVarType(const vtkStdString &cn);
    void                   AddVarToMetaData(avtVarType, avtDatabaseMetaData *, 
                                            std::string, std::string,
                                            avtCentering);
    vtkDataArray          *ReadVar(int, int, const char *);
    vtkDataSet            *GetBlock(vtkMultiBlockDataSet *, bool);
    visit_vtkPOpenFOAMReader    *reader;
    doubleVector           timeSteps;
    bool                   convertCellToPoint;
    bool                   readZones;
    int                    currentTimeStep;
    std::string            currentMesh;
    std::string            currentPatch;
};


#endif
