// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtMFIXOptions.h                              //
// ************************************************************************* //

#ifndef AVT_MFIX_OPTIONS_H
#define AVT_MFIX_OPTIONS_H

class DBOptionsAttributes;

#include <string>

#define N_X_DOMAINS "Number of domains in the X or R direction"
#define DEF_N_X_DOMAINS                 4

#define N_Y_DOMAINS "Number of domains in the Y direction"
#define DEF_N_Y_DOMAINS                 8

#define N_Z_DOMAINS "Number of domains in the Z or theta direction"
#define DEF_N_Z_DOMAINS                 4

// ****************************************************************************
//  Functions: avtMFIXOptions
//
//  Purpose:
//      Creates the options for  MFIX readers and/or writers.
//
//  Programmer: jyanovich -- generated by xml2avt
//  Creation:   Fri Aug 13 12:30:33 PDT 2010
//
// ****************************************************************************

DBOptionsAttributes *GetMFIXReadOptions(void);
DBOptionsAttributes *GetMFIXWriteOptions(void);


#endif
