// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTSYMMETRICTENSORMETADATA_H
#define AVTSYMMETRICTENSORMETADATA_H
#include <dbatts_exports.h>
#include <avtVarMetaData.h>


// ****************************************************************************
// Class: avtSymmetricTensorMetaData
//
// Purpose:
//    Contains symmetricTensor metadata attributes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtSymmetricTensorMetaData : public avtVarMetaData
{
public:
    // These constructors are for objects of this class
    avtSymmetricTensorMetaData();
    avtSymmetricTensorMetaData(const avtSymmetricTensorMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtSymmetricTensorMetaData(private_tmfs_t tmfs);
    avtSymmetricTensorMetaData(const avtSymmetricTensorMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtSymmetricTensorMetaData();

    virtual avtSymmetricTensorMetaData& operator = (const avtSymmetricTensorMetaData &obj);
    virtual bool operator == (const avtSymmetricTensorMetaData &obj) const;
    virtual bool operator != (const avtSymmetricTensorMetaData &obj) const;
private:
    void Init();
    void Copy(const avtSymmetricTensorMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtSymmetricTensorMetaData(std::string, std::string, avtCentering, int);
    void Print(ostream &, int = 0) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_dim = avtVarMetaData::ID__LAST,
        ID__LAST
    };

public:
    int dim;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTSYMMETRICTENSORMETADATA_TMFS AVTVARMETADATA_TMFS "i"

#endif
