/* $Id: ProjectItem.cpp 431215 2014-04-02 14:55:10Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gbproj.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/gbproj/ProjectItem.hpp>

#include <objects/seqloc/Seq_id.hpp>
#include <objects/seq/Seq_annot.hpp>
#include <objects/seq/Annotdesc.hpp>
#include <objects/seqset/Seq_entry.hpp>
#include <objects/seqalign/Seq_align.hpp>
#include <objects/seqalign/Seq_align_set.hpp>
#include <objects/submit/Seq_submit.hpp>

#include <serial/objostr.hpp>
#include <serial/objistr.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::


// constructor
CProjectItem::CProjectItem(void)
{
}


// destructor
CProjectItem::~CProjectItem(void)
{
}


void CProjectItem::SetCreateDate(const CTime& time)
{
    CDate date(time);
    SetCreateDate(date);
}


void CProjectItem::SetCreateDate(const CDate& date)
{
    CRef<CAnnotdesc> desc;
    TDescr::iterator iter = SetDescr().begin();
    for ( ;  iter != SetDescr().end();  ) {
        if ( (*iter)->IsCreate_date() ) {
            if (desc) {
                iter = SetDescr().erase(iter);
            } else {
                desc = *iter++;
            }
        } else {
            ++iter;
        }
    }

    if ( !desc ) {
        desc.Reset(new CAnnotdesc());
        SetDescr().push_back(desc);
    }
    desc->SetCreate_date().Assign(date);
}


void CProjectItem::SetModifiedDate(const CTime& time)
{
    CDate date(time);
    SetModifiedDate(date);
}


void CProjectItem::SetModifiedDate(const CDate& date)
{
    CRef<CAnnotdesc> desc;
    TDescr::iterator iter = SetDescr().begin();
    for ( ;  iter != SetDescr().end();  ) {
        if ( (*iter)->IsUpdate_date() ) {
            if (desc) {
                iter = SetDescr().erase(iter);
            } else {
                desc = *iter++;
            }
        } else {
            ++iter;
        }
    }

    if ( !desc ) {
        desc.Reset(new CAnnotdesc());
        SetDescr().push_back(desc);
    }
    desc->SetUpdate_date().Assign(date);
}


void CProjectItem::SetObject(CSerialObject& object)
{
    if (object.GetThisTypeInfo() == CSeq_id::GetTypeInfo()) {
        SetItem().SetId(dynamic_cast<CSeq_id&>(object));
    } else if (object.GetThisTypeInfo() == CSeq_entry::GetTypeInfo()) {
        SetItem().SetEntry(dynamic_cast<CSeq_entry&>(object));
    } else if (object.GetThisTypeInfo() == CSeq_annot::GetTypeInfo()) {
        SetItem().SetAnnot(dynamic_cast<CSeq_annot&>(object));
    } else if (object.GetThisTypeInfo() == CSeq_submit::GetTypeInfo()) {
        SetItem().SetSubmit(dynamic_cast<CSeq_submit&>(object));
    } else if (object.GetThisTypeInfo() == CSeq_align::GetTypeInfo()) {
        SetItem().SetSeq_align(dynamic_cast<CSeq_align&>(object));
    } else if (object.GetThisTypeInfo() == CSeq_align_set::GetTypeInfo()) {
        SetItem().SetSeq_align_set(dynamic_cast<CSeq_align_set&>(object));
    } else {
        SetItem().SetOther().Set(object);
    }
}


const CSerialObject* CProjectItem::GetObject() const
{
    if (IsSetItem()) {
        switch (GetItem().Which()) {
        case TItem::e_Id:
            return &GetItem().GetId();

        case TItem::e_Entry:
            return &GetItem().GetEntry();

        case TItem::e_Annot:
            return &GetItem().GetAnnot();

        case TItem::e_Submit:
            return &GetItem().GetSubmit();

        case TItem::e_Seq_align:
            return &GetItem().GetSeq_align();

        case TItem::e_Seq_align_set:
            return &GetItem().GetSeq_align_set();

        //TODO ePlugin, ePmid and eTaxid are not supported
        case TItem::e_Other:
            return GetItem().GetOther().GetObject();

        default:
            break;
        }
    } else {
        ERR_POST(Warning << "CProjectItem::GetObject(): attempt to access unset project-item");
    }

    return NULL;
}


bool CProjectItem::IsEnabled() const
{
    if (CanGetDisabled()){
        return ! GetDisabled();
    }
    return true;
}


void CProjectItem::SetUserObject(CObject* object)
{
	m_UserObject.Reset(object);
}

CObject* CProjectItem::GetUserObject()
{
	return m_UserObject.GetPointer();
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1728, CRC32: f7119107 */
