/* This file was contributed by Suzanne Skinner and is copyrighted
   under the GNU General Public License. (C) 2002 Suzanne Skinner.

   The code contained in this file is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

/* status_line.[ch] implement a scrollable status-line at the bottom of a
 * nap window. The status-line can display messages, and will also go into
 * a special user-input mode (allowing the user to enter a "/search" command)
 * if SPACE is typed. See status_line.c for more information on the usage of
 * each function.
 *
 * Note: this module is not currently used for the blue, main-screen status
 * line.
 */

#ifndef _NAP_STATUS_LINE_H
#define _NAP_STATUS_LINE_H

#include <ncurses.h>

void  sl_set(const char *str);
void  sl_sprintf(const char *format, ...);
void  sl_draw(void);
bool  sl_handle_keystroke(chtype ch);

#endif
