/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "uPlotManager.hpp"
#include "uPlotService.hpp"
#include <stdlib.h>
#include <stdio.h>

#include "MvScanFileType.h"
#ifdef METVIEW_ODB_NEW
#include "MvOdb.h"
#endif

uPlotManager::uPlotManager(const char* kw): MvService(kw)
{
   saveToPool(false);
}

void uPlotManager::serve(MvRequest& in,MvRequest& out)
{
cout << "uPlotManager::serve --> in" << endl;
in.print();

   uPlotService::Instance().CalluPlot ( in,out );

   return;
}

//--------------------------------------------------------

int main(int argc,char **argv)
{
   // Set option -debug to true
   // This is needed in order to force the Save Request command
   // to save the hidden parameters too (underscore parameters)
   option opts[] = {"debug","MARS_DEBUG","-debug","1",t_boolean, sizeof(boolean),OFFSET(globals,debug)};

   MvApplication theApp(argc,argv,NULL,&mars,1,opts);

   uPlotManager vis0("UPLOT_MANAGER");
   uPlotManager vis1("GRIB");
   uPlotManager vis2("GEOPOINTS");
   uPlotManager vis3("MAPVIEW");
   uPlotManager vis4("CARTESIANVIEW");
   uPlotManager vis6("PLOT_SUPERPAGE");
   uPlotManager vis7("PRASTERLOOP");
   uPlotManager vis8("BUFR");
   uPlotManager vis9("PRINTER_MANAGER");
   uPlotManager vis10("GEOVIEW");
   uPlotManager vis11("MXSECTIONVIEW");
   uPlotManager vis12("MVPROFILEVIEW");
   uPlotManager vis13("MXAVERAGEVIEW");
   uPlotManager vis14("ANNOTATIONVIEW");
   uPlotManager vis15("HOVMOELLERVIEW");
   uPlotManager vis16("MHOVMOELLERVIEW");
   uPlotManager vis17("THERMOVIEW");

   uPlotManager nc0("NETCDF_GEO_POINTS");
   uPlotManager nc1("NETCDF_GEO_VECTORS");
   uPlotManager nc2("NETCDF_GEO_MATRIX");
   uPlotManager nc3("NETCDF_XY_MATRIX");
   uPlotManager nc4("NETCDF_XY_POINTS");
   uPlotManager nc5("NETCDF");

   uPlotManager i1 ("INPUT_HISTOGRAM");
   uPlotManager i2 ("INPUT_XY_POINTS");
   uPlotManager i3 ("INPUT_GEO_POINTS");
   uPlotManager i4 ("INPUT_XY_VECTORS");
   uPlotManager i5 ("INPUT_GEO_VECTORS");
   uPlotManager i6 ("INPUT_XY_BINNING");
   uPlotManager i7 ("INPUT_GEO_BINNING");
   uPlotManager i8 ("INPUT_XY_BOXES");
   uPlotManager i9 ("INPUT_GEO_BOXES");
   uPlotManager i10("INPUT_HOR_BAR");
   uPlotManager i11("INPUT_VER_BAR");

   uPlotManager t1 ("TABLE_HISTOGRAM");
   uPlotManager t2 ("TABLE_XY_POINTS");
   uPlotManager t3 ("TABLE_GEO_POINTS");
   uPlotManager t4 ("TABLE_XY_VECTORS");
   uPlotManager t5 ("TABLE_GEO_VECTORS");
   uPlotManager t6 ("TABLE_XY_BINNING");
   uPlotManager t7 ("TABLE_GEO_BINNING");
   uPlotManager t8 ("TABLE_XY_BOXES");
   uPlotManager t9 ("TABLE_GEO_BOXES");
   uPlotManager t10("TABLE_HOR_BAR");
   uPlotManager t11("TABLE_VER_BAR");

   uPlotManager odb1("ODB_GEO_POINTS");
   uPlotManager odb2("ODB_GEO_VECTORS");
   uPlotManager odb3("ODB_XY_POINTS");
   uPlotManager odb4("ODB_XY_VECTORS");
   uPlotManager odb5("ODB_XY_BINNING");

   uPlotManager gv1("GRIB_VECTORS");

   uPlotManager vd1("MCONT");
   uPlotManager vd2("MCOAST");
   uPlotManager vd3("MTEXT");
   uPlotManager vd4("MLEGEND");
   uPlotManager vd5("MGRAPH");
   uPlotManager vd6("MSYMB");

   // 'METVIEW 3' applications. Instantiated here due to
   // backwards compatibility. Delete them later.
   uPlotManager mv31("XSECTVIEW");
   uPlotManager mv32("AVERAGEVIEW");
   uPlotManager mv33("VERTPROFVIEW");

   theApp.run();
}
