import sys
import itertools
import pytest

blacklist = ["test_knn.py", # Requires pykeops
             "test_representations.py", # Look into this
             "test_tomato.py", # Wants to use X.
             "test_wasserstein_distance.py::test_wasserstein_distance_grad" # Requires PyTorch.
            ]

print("Blacklist: %s" %(str(blacklist)))

# These should be completely ignored, not even loaded (their imports fail).
ignorelist = ["test_dtm.py", # Requires hnswlib.
              "test_wasserstein_with_tensors.py" # Requires PyTorch and TF
            ]

print("Ignorelist:", ignorelist)

testdir = sys.argv[1]

deselect_args = list(itertools.chain.from_iterable([["--deselect", "%s/%s" %(testdir, exclude)] for exclude in blacklist]))
ignore_args = list(itertools.chain.from_iterable([["--ignore-glob", "%s/%s" %(testdir, exclude)] for exclude in ignorelist]))

exitcode = pytest.main([testdir] + deselect_args + ignore_args)
exit(exitcode)
