# -*- mode:perl -*-
# $Id: Makefile.PL,v 1.10 2002/01/11 22:23:26 dplonka Exp $

require 5.003; # for INSTALLSCRIPT

# use Config;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    # ABSTRACT_FROM  => 'Cflow.pm',
    # AUTHOR         => 'Dave Plonka <plonka@doit.wisc.edu>',
    CONFIGURE      => \&find_argus_or_flow_tools,
    EXE_FILES      => [ 'flowdumper' ],
    NAME           => 'Cflow',
    PM             => {
			 'Cflow.pm' => '$(INST_LIBDIR)/Cflow.pm',
		      },
    VERSION_FROM   => 'Cflow.pm', # finds $VERSION
    clean          => { FILES => '$(EXE_FILES)' },
    dist           => {
                         'COMPRESS' =>  'gzip',
                         'SUFFIX' => 'gz',
                      },
);

sub find_argus_or_flow_tools {
   my $hv;
   # for the time being, argus and flow-tools are mutually exclusive.
   # (No good reason... Its just the way "Cflow.xs" was written.)
   if ($hv = &find_argus) {
      return $hv
   } elsif ($hv = &find_flow_tools) {
      return $hv
   } else {
      # neither found... cflowd support only.
      return { INC     => join(' ', $incdir),
	       LIBS    => [ join(' ', $libdir, '-lnsl') ] }
   }
}

sub find_flow_tools {
   my($ver, $dir);
   my($libdir, $incdir);
   if (-f '../../lib/libft.a') {
      $dir = '../../lib';
      $incdir = "-I$dir -I$dir/..";
      $libdir = "-L$dir";
   }
   if ("$libdir") {
      print "Found flow-tools... using \"-DOSU $incdir $libdir -lft -lz\".\n";
      return { CCFLAGS => '-DOSU',
	       INC     => join(' ', $incdir),
	       LIBS    => [ join(' ', $libdir, '-lnsl -lft -lz') ] }
   }
   return undef
}

sub find_argus {
   my($ver, $dir);
   my($libdir, $incdir);
   if (-f '../../lib/argus_common.a' && -f '../../lib/argus_parse.a') {
      $dir = '../../lib';
      $incdir = "-I$dir/../include";
      $libdir = "-L$dir";
   }
   if ("$libdir") {
      print "Found argus... using \"-DARGUS $incdir $dir/argus_common.a $dir/argus_parse.a\".\n";
      return { CCFLAGS => '-DARGUS',
	       INC     => join(' ', $incdir),
	       LIBS    => [ join(' ', $libdir, '-lnsl', '-lm') ],
	       LDFROM  => "\$(OBJECT) $dir/argus_common.a $dir/argus_parse.a" }
   }
   return undef
}
