#include "dnsentry"

in_addr_t &DNSEntry::resolve (string const &h) {
    // If the entry is there and if it's up to date, run with it
    if (result && timestamp.elapsed() <= (double)config.dnscachetimeout())
	return result;

    // Resolve now.
    struct hostent *hostaddr;
    mutex_lock((void*)gethostbyname);
    if ( (hostaddr = gethostbyname(h.c_str())) )
	memcpy (&result, hostaddr->h_addr_list[0], hostaddr->h_length);
    mutex_unlock((void*)gethostbyname);

    if (!hostaddr)
	throw Error("Failed to resolve host '" + h + "'");

    debugmsg("Host " << h << " resolved\n");
    return result;
}
