
module DCE_RPC;

export {
	const uuid_endpoint_map: table[string] of string = {
		["367abb81-9844-35f1-ad32-98f038001003"] = "svcctl",
		["86d35949-83c9-4044-b424-db363231fd0c"] = "ITaskSchedulerService",
		["378e52b0-c0a9-11cf-822d-00aa0051e40f"] = "sasec",
		["1ff70682-0a51-30e8-076d-740be8cee98b"] = "atsvc",
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53"] = "idletask",
		["906b0ce0-c70b-1067-b317-00dd010662da"] = "IXnRemote",
		["ae33069b-a2a8-46ee-a235-ddfd339be281"] = "IRPCRemoteObject",
		["0b6edbfa-4a24-4fc6-8a23-942b1eca65d1"] = "IRPCAsyncNotify",
		["afa8bd80-7d8a-11c9-bef4-08002b102989"] = "mgmt",
		["f5cc59b4-4264-101a-8c59-08002b2f8426"] = "FrsRpc",
		["000001a0-0000-0000-c000-000000000046"] = "IRemoteSCMActivator",
		["00000143-0000-0000-c000-000000000046"] = "IRemUnknown2",
		["12345778-1234-abcd-ef00-0123456789ab"] = "lsarpc",
		["76f03f96-cdfd-44fc-a22c-64950a001209"] = "IRemoteWinspool",
		["12345678-1234-abcd-ef00-01234567cffb"] = "netlogon",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2"] = "drsuapi",
		["5261574a-4572-206e-b268-6b199213b4e4"] = "AsyncEMSMDB",
		["4d9f4ab8-7d1c-11cf-861e-0020af6e7c57"] = "IActivation",
		["99fcfec4-5260-101b-bbcb-00aa0021347a"] = "IObjectExporter",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa"] = "epmapper",
		["12345778-1234-abcd-ef00-0123456789ac"] = "samr",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188"] = "srvsvc",
		["45f52c28-7f9f-101a-b52b-08002b2efabe"] = "winspipe",
		["6bffd098-a112-3610-9833-46c3f87e345a"] = "wkssvc",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5"] = "dssetup",
		["12345678-1234-abcd-ef00-0123456789ab"] = "spoolss",

		# Exchange
		["1544f5e0-613c-11d1-93df-00c04fd7bd09"] = "exchange_rfr",
		["f5cc5a18-4264-101a-8c59-08002b2f8426"] = "nspi",
		["a4f1db00-ca47-1067-b31f-00dd010662da"] = "exchange_mapi",

		# IWbem
		["9556dc99-828c-11cf-a37e-00aa003240c7"] = "IWbemServices",
		["f309ad18-d86a-11d0-a075-00c04fb68820"] = "IWbemLevel1Login",
		["d4781cd6-e5d3-44df-ad94-930efe48a887"] = "IWbemLoginClientID",
		["44aca674-e8fc-11d0-a07c-00c04fb68820"] = "IWbemContext interface",
		["674b6698-ee92-11d0-ad71-00c04fd8fdff"] = "IWbemContext unmarshaler",
		["dc12a681-737f-11cf-884d-00aa004b2e24"] = "IWbemClassObject interface",
		["4590f812-1d3a-11d0-891f-00aa004b2e24"] = "IWbemClassObject unmarshaler",
		["9a653086-174f-11d2-b5f9-00104b703efd"] = "IWbemClassObject interface",
		["c49e32c6-bc8b-11d2-85d4-00105a1f8304"] = "IWbemBackupRestoreEx interface",
		["7c857801-7381-11cf-884d-00aa004b2e24"] = "IWbemObjectSink interface",
		["027947e1-d731-11ce-a357-000000000001"] = "IEnumWbemClassObject interface",
		["44aca675-e8fc-11d0-a07c-00c04fb68820"] = "IWbemCallResult interface",
		["c49e32c7-bc8b-11d2-85d4-00105a1f8304"] = "IWbemBackupRestore interface",
		["a359dec5-e813-4834-8a2a-ba7f1d777d76"] = "IWbemBackupRestoreEx interface",
		["f1e9c5b2-f59b-11d2-b362-00105a1f8177"] = "IWbemRemoteRefresher interface",
		["2c9273e0-1dc3-11d3-b364-00105a1f8177"] = "IWbemRefreshingServices interface",
		["423ec01e-2e35-11d2-b604-00104b703efd"] = "IWbemWCOSmartEnum interface",
		["1c1c45ee-4395-11d2-b60b-00104b703efd"] = "IWbemFetchSmartEnum interface",
		["541679AB-2E5F-11d3-B34E-00104BCC4B4A"] = "IWbemLoginHelper interface",
		["51c82175-844e-4750-b0d8-ec255555bc06"] = "KMS",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076"] = "dnsserver",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5"] = "AudioSrv",
		["c386ca3e-9061-4a72-821e-498d83be188f"] = "AudioRpc",
		["6bffd098-a112-3610-9833-012892020162"] = "browser",
		["91ae6020-9e3c-11cf-8d7c-00aa00c091be"] = "ICertPassage",
		["c8cb7687-e6d3-11d2-a958-00c04f682e16"] = "DAV RPC SERVICE",
		["82273fdc-e32a-18c3-3f78-827929dc23ea"] = "eventlog",
		["3d267954-eeb7-11d1-b94e-00c04fa3080d"] = "HydraLsPipe",
		["894de0c0-0d55-11d3-a322-00c04fa321a1"] = "InitShutdown",
		["d95afe70-a6d5-4259-822e-2c84da1ddb0d"] = "WindowsShutdown",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b"] = "IKeySvc",
		["68b58241-c259-4f03-a2e5-a2651dcbc930"] = "IKeySvc2",
		["0d72a7d4-6148-11d1-b4aa-00c04fb66ea0"] = "ICertProtect",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43"] = "ICatDBSvc",
		["338cd001-2244-31f1-aaaa-900038001003"] = "winreg",
		["3dde7c30-165d-11d1-ab8f-00805f14db40"] = "BackupKey", # https://msdn.microsoft.com/en-us/library/cc224123.aspx
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5"] = "RpcSrvDHCPC",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6"] = "dhcpcsvc6",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8"] = "lcrpc",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed"] = "winstation_rpc",
		["12b81e99-f207-4a4c-85d3-77b42f76fd14"] = "ISeclogon",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c3"] = "NsiS",
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3"] = "NsiC",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4"] = "NsiM",
		["17fdd703-1827-4e34-79d4-24a55c53bb37"] = "msgsvc",
		["5a7b91f8-ff00-11d0-a9b2-00c04fb6e6fc"] = "msgsvcsend",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b"] = "pnp",
		["57674cd0-5200-11ce-a897-08002b2e9c6d"] = "lls_license",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d"] = "llsrpc",
		["4fc742e0-4a10-11cf-8273-00aa004ae673"] = "netdfs",
		["83da7c00-e84f-11d2-9807-00c04f8ec850"] = "sfcapi",
		["2f5f3220-c126-1076-b549-074d078619da"] = "nddeapi",
	} &redef &default=function(uuid: string): string { return fmt("unknown-%s", uuid); };

	## This table is to map pipe names to the most common
	## service used over that pipe.  It helps in cases
	## where the pipe binding wasn't seen.
	const pipe_name_to_common_uuid: table[string] of string = {
		["winreg"] = "338cd001-2244-31f1-aaaa-900038001003",
		["spoolss"] = "12345678-1234-abcd-ef00-0123456789ab",
		["srvsvc"] = "4b324fc8-1670-01d3-1278-5a47bf6ee188",
	} &redef;

	const operations: table[string,count] of string = {
		# atsvc
		["1ff70682-0a51-30e8-076d-740be8cee98b",0] = "NetrJobAdd",
		["1ff70682-0a51-30e8-076d-740be8cee98b",1] = "NetrJobDel",
		["1ff70682-0a51-30e8-076d-740be8cee98b",2] = "NetrJobEnum",
		["1ff70682-0a51-30e8-076d-740be8cee98b",3] = "NetrJobGetInfo",

		# sasec
		["378e52b0-c0a9-11cf-822d-00aa0051e40f",0] = "SASetAccountInformation",
		["378e52b0-c0a9-11cf-822d-00aa0051e40f",1] = "SASetNSAccountInformation",
		["378e52b0-c0a9-11cf-822d-00aa0051e40f",2] = "SAGetNSAccountInformation",
		["378e52b0-c0a9-11cf-822d-00aa0051e40f",3] = "SAGetAccountInformation",

		# idletask
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53",0] = "ItSrvRegisterIdleTask",
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53",1] = "ItSrvUnregisterIdleTask",
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53",2] = "ItSrvProcessIdleTasks",
		["0a74ef1c-41a4-4e06-83ae-dc74fb1cdd53",3] = "ItSrvSetDetectionParameters",

		# ITaskSchedulerService
		["86d35949-83c9-4044-b424-db363231fd0c",0] = "SchRpcHighestVersion",
		["86d35949-83c9-4044-b424-db363231fd0c",1] = "SchRpcRegisterTask",
		["86d35949-83c9-4044-b424-db363231fd0c",2] = "SchRpcRetrieveTask",
		["86d35949-83c9-4044-b424-db363231fd0c",3] = "SchRpcCreateFolder",
		["86d35949-83c9-4044-b424-db363231fd0c",4] = "SchRpcSetSecurity",
		["86d35949-83c9-4044-b424-db363231fd0c",5] = "SchRpcGetSecurity",
		["86d35949-83c9-4044-b424-db363231fd0c",6] = "SchRpcEnumFolder",
		["86d35949-83c9-4044-b424-db363231fd0c",7] = "SchRpcEnumTasks",
		["86d35949-83c9-4044-b424-db363231fd0c",8] = "SchRpcEnumInstances",
		["86d35949-83c9-4044-b424-db363231fd0c",9] = "SchRpcGetInstanceInfo",
		["86d35949-83c9-4044-b424-db363231fd0c",10] = "SchRpcStopInstance",
		["86d35949-83c9-4044-b424-db363231fd0c",11] = "SchRpcStop",
		["86d35949-83c9-4044-b424-db363231fd0c",12] = "SchRpcRun",
		["86d35949-83c9-4044-b424-db363231fd0c",13] = "SchRpcDelete",
		["86d35949-83c9-4044-b424-db363231fd0c",14] = "SchRpcRename",
		["86d35949-83c9-4044-b424-db363231fd0c",15] = "SchRpcScheduledRuntimes",
		["86d35949-83c9-4044-b424-db363231fd0c",16] = "SchRpcGetLastRunInfo",
		["86d35949-83c9-4044-b424-db363231fd0c",17] = "SchRpcGetTaskInfo",

		# IObjectExporter
		["99fcfec4-5260-101b-bbcb-00aa0021347a",0] = "ResolveOxid",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",1] = "SimplePing",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",2] = "ComplexPing",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",3] = "ServerAlive",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",4] = "ResolveOxid2",
		["99fcfec4-5260-101b-bbcb-00aa0021347a",5] = "ServerAlive2",

		# IActivation
		["4d9f4ab8-7d1c-11cf-861e-0020af6e7c57",0] = "RemoteActivation",

		# IRemoteSCMActivator
		["000001a0-0000-0000-c000-000000000046",3] = "RemoteGetClassObject",
		["000001a0-0000-0000-c000-000000000046",4] = "RemoteCreateInstance",

		# nspi
		["f5cc5a18-4264-101a-8c59-08002b2f8426",0] = "NspiBind",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",1] = "NspiUnbind",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",2] = "NspiUpdateStat",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",3] = "NspiQueryRows",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",4] = "NspiSeekEntries",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",5] = "NspiGetMatches",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",6] = "NspiResortRestriction",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",7] = "NspiDNToEph",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",8] = "NspiGetPropList",
		["f5cc5a18-4264-101a-8c59-08002b2f8426",9] = "NspiGetProps",

		# IWbemServices
		["9556dc99-828c-11cf-a37e-00aa003240c7",3] = "OpenNamespace",
		["9556dc99-828c-11cf-a37e-00aa003240c7",4] = "CancelAsyncCall",
		["9556dc99-828c-11cf-a37e-00aa003240c7",5] = "QueryObjectSink",
		["9556dc99-828c-11cf-a37e-00aa003240c7",6] = "GetObject",
		["9556dc99-828c-11cf-a37e-00aa003240c7",7] = "GetObjectAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",8] = "PutClass",
		["9556dc99-828c-11cf-a37e-00aa003240c7",9] = "PutClassAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",10] = "DeleteClass",
		["9556dc99-828c-11cf-a37e-00aa003240c7",11] = "DeleteClassAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",12] = "CreateClassEnum",
		["9556dc99-828c-11cf-a37e-00aa003240c7",13] = "CreateClassEnumAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",14] = "PutInstance",
		["9556dc99-828c-11cf-a37e-00aa003240c7",15] = "PutInstanceAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",16] = "DeleteClass",
		["9556dc99-828c-11cf-a37e-00aa003240c7",17] = "DeleteClassAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",18] = "CreateInstanceEnum",
		["9556dc99-828c-11cf-a37e-00aa003240c7",19] = "CreateInstanceEnumAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",20] = "ExecQuery",
		["9556dc99-828c-11cf-a37e-00aa003240c7",21] = "ExecQueryAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",22] = "ExecNotificationQuery",
		["9556dc99-828c-11cf-a37e-00aa003240c7",23] = "ExecNotificationQueryAsync",
		["9556dc99-828c-11cf-a37e-00aa003240c7",24] = "ExecMethod",
		["9556dc99-828c-11cf-a37e-00aa003240c7",25] = "ExecMethodAsync",

		# IWbemLevel1Login
		["f309ad18-d86a-11d0-a075-00c04fb68820",3] = "EstablishPosition",
		["f309ad18-d86a-11d0-a075-00c04fb68820",4] = "RequestChallenge",
		["f309ad18-d86a-11d0-a075-00c04fb68820",5] = "WBEMLogin",
		["f309ad18-d86a-11d0-a075-00c04fb68820",6] = "NTLMLogin",

		# FrsRpc
		["f5cc59b4-4264-101a-8c59-08002b2f8426",0] = "FrsRpcSendCommPkt",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",1] = "FrsRpcVerifyPromotionParent",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",2] = "FrsRpcStartPromotionParent",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",3] = "FrsNOP",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",4] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",5] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",6] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",7] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",8] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",9] = "FrsBackupComplete",
		["f5cc59b4-4264-101a-8c59-08002b2f8426",10] = "FrsRpcVerifyPromotionParentEx",

		# IRemUnknown2
		["00000143-0000-0000-c000-000000000046",0] = "QueryInterface",
		["00000143-0000-0000-c000-000000000046",1] = "AddRef",
		["00000143-0000-0000-c000-000000000046",2] = "Release",
		["00000143-0000-0000-c000-000000000046",3] = "RemQueryInterface",
		["00000143-0000-0000-c000-000000000046",4] = "RemAddRef",
		["00000143-0000-0000-c000-000000000046",5] = "RemRelease",
		["00000143-0000-0000-c000-000000000046",6] = "RemQueryInterface2",

		# IRemoteSCMActivator
		["000001a0-0000-0000-c000-000000000046",0] = "QueryInterfaceIRemoteSCMActivator",
		["000001a0-0000-0000-c000-000000000046",1] = "AddRefIRemoteISCMActivator",
		["000001a0-0000-0000-c000-000000000046",2] = "ReleaseIRemoteISCMActivator",
		#["000001a0-0000-0000-c000-000000000046",3] = "RemoteGetClassObject",
		#["000001a0-0000-0000-c000-000000000046",4] = "RemoteCreateInstance",

		# netlogon
		["12345678-1234-abcd-ef00-01234567cffb",0] = "NetrLogonUasLogon",
		["12345678-1234-abcd-ef00-01234567cffb",1] = "NetrLogonUasLogoff",
		["12345678-1234-abcd-ef00-01234567cffb",2] = "NetrLogonSamLogon",
		["12345678-1234-abcd-ef00-01234567cffb",3] = "NetrLogonSamLogoff",
		["12345678-1234-abcd-ef00-01234567cffb",4] = "NetrServerReqChallenge",
		["12345678-1234-abcd-ef00-01234567cffb",5] = "NetrServerAuthenticate",
		["12345678-1234-abcd-ef00-01234567cffb",6] = "NetrServerPasswordSet",
		["12345678-1234-abcd-ef00-01234567cffb",7] = "NetrDatabaseDeltas",
		["12345678-1234-abcd-ef00-01234567cffb",8] = "NetrDatabaseSync",
		["12345678-1234-abcd-ef00-01234567cffb",9] = "NetrAccountDeltas",
		["12345678-1234-abcd-ef00-01234567cffb",10] = "NetrAccountSync",
		["12345678-1234-abcd-ef00-01234567cffb",11] = "NetrGetDCName",
		["12345678-1234-abcd-ef00-01234567cffb",12] = "NetrLogonControl",
		["12345678-1234-abcd-ef00-01234567cffb",13] = "NetrGetAnyDCName",
		["12345678-1234-abcd-ef00-01234567cffb",14] = "NetrLogonControl2",
		["12345678-1234-abcd-ef00-01234567cffb",15] = "NetrServerAuthenticate2",
		["12345678-1234-abcd-ef00-01234567cffb",16] = "NetrDatabaseSync2",
		["12345678-1234-abcd-ef00-01234567cffb",17] = "NetrDatabaseRedo",
		["12345678-1234-abcd-ef00-01234567cffb",18] = "NetrLogonControl2Ex",
		["12345678-1234-abcd-ef00-01234567cffb",19] = "NetrEnumerateTrustedDomains",
		["12345678-1234-abcd-ef00-01234567cffb",20] = "DsrGetDcName",
		["12345678-1234-abcd-ef00-01234567cffb",21] = "NetrLogonGetCapabilities",
		["12345678-1234-abcd-ef00-01234567cffb",22] = "NetrLogonSetServiceBits",
		["12345678-1234-abcd-ef00-01234567cffb",23] = "NetrLogonGetTrustRid",
		["12345678-1234-abcd-ef00-01234567cffb",24] = "NetrLogonComputeServerDigest",
		["12345678-1234-abcd-ef00-01234567cffb",25] = "NetrLogonComputeClientDigest",
		["12345678-1234-abcd-ef00-01234567cffb",26] = "NetrServerAuthenticate3",
		["12345678-1234-abcd-ef00-01234567cffb",27] = "DsrGetDcNameEx",
		["12345678-1234-abcd-ef00-01234567cffb",28] = "DsrGetSiteName",
		["12345678-1234-abcd-ef00-01234567cffb",29] = "NetrLogonGetDomainInfo",
		["12345678-1234-abcd-ef00-01234567cffb",30] = "NetrServerPasswordSet2",
		["12345678-1234-abcd-ef00-01234567cffb",31] = "NetrServerPasswordGet",
		["12345678-1234-abcd-ef00-01234567cffb",32] = "NetrLogonSendToSam",
		["12345678-1234-abcd-ef00-01234567cffb",33] = "DsrAddressToSiteNamesW",
		["12345678-1234-abcd-ef00-01234567cffb",34] = "DsrGetDcNameEx2",
		["12345678-1234-abcd-ef00-01234567cffb",35] = "NetrLogonGetTimeServiceParentDomain",
		["12345678-1234-abcd-ef00-01234567cffb",36] = "NetrEnumerateTrustedDomainsEx",
		["12345678-1234-abcd-ef00-01234567cffb",37] = "DsrAddressToSiteNamesExW",
		["12345678-1234-abcd-ef00-01234567cffb",38] = "DsrGetDcSiteCoverageW",
		["12345678-1234-abcd-ef00-01234567cffb",39] = "NetrLogonSamLogonEx",
		["12345678-1234-abcd-ef00-01234567cffb",40] = "DsrEnumerateDomainTrusts",
		["12345678-1234-abcd-ef00-01234567cffb",41] = "DsrDeregisterDnsHostRecords",
		["12345678-1234-abcd-ef00-01234567cffb",42] = "NetrServerTrustPasswordsGet",
		["12345678-1234-abcd-ef00-01234567cffb",43] = "DsrGetForestTrustInformation",
		["12345678-1234-abcd-ef00-01234567cffb",44] = "NetrGetForestTrustInformation",
		["12345678-1234-abcd-ef00-01234567cffb",45] = "NetrLogonSameLogonWithFlags",
		["12345678-1234-abcd-ef00-01234567cffb",46] = "NetrServerGetTrustInfo",
		["12345678-1234-abcd-ef00-01234567cffb",47] = "unused",
		["12345678-1234-abcd-ef00-01234567cffb",48] = "DsrUpdateReadOnlyServerDnsRecords",
		["12345678-1234-abcd-ef00-01234567cffb",49] = "NetrChainSetClientAttributes",

		# IRemoteWinspool
		["76f03f96-cdfd-44fc-a22c-64950a001209",0] = "RpcAsyncOpenPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",1] = "RpcAsyncAddPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",2] = "RpcAsyncSetJob",
		["76f03f96-cdfd-44fc-a22c-64950a001209",3] = "RpcAsyncGetJob",
		["76f03f96-cdfd-44fc-a22c-64950a001209",4] = "RpcAsyncEnumJobs",
		["76f03f96-cdfd-44fc-a22c-64950a001209",5] = "RpcAsyncAddJob",
		["76f03f96-cdfd-44fc-a22c-64950a001209",6] = "RpcAsyncScheduleJob",
		["76f03f96-cdfd-44fc-a22c-64950a001209",7] = "RpcAsyncDeletePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",8] = "RpcAsyncSetPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",9] = "RpcAsyncGetPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",10] = "RpcAsyncStartDocPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",11] = "RpcAsyncStartPagePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",12] = "RpcAsyncWritePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",13] = "RpcAsyncEndPagePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",14] = "RpcAsyncEndDocPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",15] = "RpcAsyncAbortPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",16] = "RpcAsyncGetPrinterData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",17] = "RpcAsyncGetPrinterDataEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",18] = "RpcAsyncSetPrinterData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",19] = "RpcAsyncSetPrinterDataEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",20] = "RpcAsyncClosePrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",21] = "RpcAsyncAddForm",
		["76f03f96-cdfd-44fc-a22c-64950a001209",22] = "RpcAsyncDeleteForm",
		["76f03f96-cdfd-44fc-a22c-64950a001209",23] = "RpcAsyncGetForm",
		["76f03f96-cdfd-44fc-a22c-64950a001209",24] = "RpcAsyncSetForm",
		["76f03f96-cdfd-44fc-a22c-64950a001209",25] = "RpcAsyncEnumForms",
		["76f03f96-cdfd-44fc-a22c-64950a001209",26] = "RpcAsyncGetPrinterDriver",
		["76f03f96-cdfd-44fc-a22c-64950a001209",27] = "RpcAsyncEnumPrinterData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",28] = "RpcAsyncEnumPrinterDataEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",29] = "RpcAsyncEnumPrinterKey",
		["76f03f96-cdfd-44fc-a22c-64950a001209",30] = "RpcAsyncDeletePrinterData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",31] = "RpcAsyncDeletePrinterDataEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",32] = "RpcAsyncDeletePrinterKey",
		["76f03f96-cdfd-44fc-a22c-64950a001209",33] = "RpcAsyncXcvData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",34] = "RpcAsyncSendRecvBidiData",
		["76f03f96-cdfd-44fc-a22c-64950a001209",35] = "RpcAsyncCreatePrinterIC",
		["76f03f96-cdfd-44fc-a22c-64950a001209",36] = "RpcAsyncPlayGdiScriptOnPrinterIC",
		["76f03f96-cdfd-44fc-a22c-64950a001209",37] = "RpcAsyncDeletePrinterIC",
		["76f03f96-cdfd-44fc-a22c-64950a001209",38] = "RpcAsyncEnumPrinters",
		["76f03f96-cdfd-44fc-a22c-64950a001209",39] = "RpcAsyncAddPrinterDriver",
		["76f03f96-cdfd-44fc-a22c-64950a001209",40] = "RpcAsyncEnumPrinterDrivers",
		["76f03f96-cdfd-44fc-a22c-64950a001209",41] = "RpcAsyncGetPrinterDriverDirectory",
		["76f03f96-cdfd-44fc-a22c-64950a001209",42] = "RpcAsyncDeletePrinterDriver",
		["76f03f96-cdfd-44fc-a22c-64950a001209",43] = "RpcAsyncDeletePrinterDriverEx",
		["76f03f96-cdfd-44fc-a22c-64950a001209",44] = "RpcAsyncAddPrintProcessor",
		["76f03f96-cdfd-44fc-a22c-64950a001209",45] = "RpcAsyncEnumPrintProcessors",
		["76f03f96-cdfd-44fc-a22c-64950a001209",46] = "RpcAsyncGetPrintProcessorDirectory",
		["76f03f96-cdfd-44fc-a22c-64950a001209",47] = "RpcAsyncEnumPorts",
		["76f03f96-cdfd-44fc-a22c-64950a001209",48] = "RpcAsyncEnumMonitors",
		["76f03f96-cdfd-44fc-a22c-64950a001209",49] = "RpcAsyncAddPort",
		["76f03f96-cdfd-44fc-a22c-64950a001209",50] = "RpcAsyncSetPort",
		["76f03f96-cdfd-44fc-a22c-64950a001209",51] = "RpcAsyncAddMonitor",
		["76f03f96-cdfd-44fc-a22c-64950a001209",52] = "RpcAsyncDeleteMonitor",
		["76f03f96-cdfd-44fc-a22c-64950a001209",53] = "RpcAsyncDeletePrintProcessor",
		["76f03f96-cdfd-44fc-a22c-64950a001209",54] = "RpcAsyncEnumPrintProcessorDatatypes",
		["76f03f96-cdfd-44fc-a22c-64950a001209",55] = "RpcAsyncAddPerMachineConnection",
		["76f03f96-cdfd-44fc-a22c-64950a001209",56] = "RpcAsyncDeletePerMachineConnection",
		["76f03f96-cdfd-44fc-a22c-64950a001209",57] = "RpcAsyncEnumPerMachineConnections",
		["76f03f96-cdfd-44fc-a22c-64950a001209",58] = "RpcSyncRegisterForRemoteNotifications",
		["76f03f96-cdfd-44fc-a22c-64950a001209",59] = "RpcSyncUnRegisterForRemoteNotifications",
		["76f03f96-cdfd-44fc-a22c-64950a001209",60] = "RpcSyncRefreshRemoteNotifications",
		["76f03f96-cdfd-44fc-a22c-64950a001209",61] = "RpcAsyncGetRemoteNotifications",
		["76f03f96-cdfd-44fc-a22c-64950a001209",62] = "RpcAsyncInstallPrinterDriverFromPackage",
		["76f03f96-cdfd-44fc-a22c-64950a001209",63] = "RpcAsyncUploadPrinterDriverPackage",
		["76f03f96-cdfd-44fc-a22c-64950a001209",64] = "RpcAsyncGetCorePrinterDrivers",
		["76f03f96-cdfd-44fc-a22c-64950a001209",65] = "RpcAsyncCorePrinterDriverInstalled",
		["76f03f96-cdfd-44fc-a22c-64950a001209",66] = "RpcAsyncGetPrinterDriverPackagePath",
		["76f03f96-cdfd-44fc-a22c-64950a001209",67] = "RpcAsyncDeletePrinterDriverPackage",
		["76f03f96-cdfd-44fc-a22c-64950a001209",68] = "RpcAsyncReadPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",69] = "RpcAsyncResetPrinter",
		["76f03f96-cdfd-44fc-a22c-64950a001209",70] = "RpcAsyncGetJobNamedPropertyValue",
		["76f03f96-cdfd-44fc-a22c-64950a001209",71] = "RpcAsyncSetJobNamedProperty",
		["76f03f96-cdfd-44fc-a22c-64950a001209",72] = "RpcAsyncDeleteJobNamedProperty",
		["76f03f96-cdfd-44fc-a22c-64950a001209",73] = "RpcAsyncEnumJobNamedProperties",
		["76f03f96-cdfd-44fc-a22c-64950a001209",74] = "RpcAsyncLogJobInfoForBranchOffice",

		# InitShutdown
		["894de0c0-0d55-11d3-a322-00c04fa321a1",0]  = "BaseInitiateShutdown",
		["894de0c0-0d55-11d3-a322-00c04fa321a1",1]  = "BaseAbortShutdown",
		["894de0c0-0d55-11d3-a322-00c04fa321a1",2]  = "BaseInitiateShutdownEx",

		# WindowsShutdown
		["d95afe70-a6d5-4259-822e-2c84da1ddb0d",0x00] = "WsdrInitiateShutdown",
		["d95afe70-a6d5-4259-822e-2c84da1ddb0d",0x01] = "WsdrAbortShutdown",

		# spoolss
		["12345678-1234-abcd-ef00-0123456789ab",0x00] = "RpcEnumPrinters",
		["12345678-1234-abcd-ef00-0123456789ab",0x01] = "RpcOpenPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x02] = "RpcSetJob",
		["12345678-1234-abcd-ef00-0123456789ab",0x03] = "RpcGetJob",
		["12345678-1234-abcd-ef00-0123456789ab",0x04] = "RpcEnumJobs",
		["12345678-1234-abcd-ef00-0123456789ab",0x05] = "RpcAddPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x06] = "RpcDeletePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x07] = "RpcSetPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x08] = "RpcGetPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x09] = "RpcAddPrinterDriver",
		["12345678-1234-abcd-ef00-0123456789ab",0x0a] = "RpcEnumPrinterDrivers",
		["12345678-1234-abcd-ef00-0123456789ab",0x0b] = "RpcGetPrinterDriver",
		["12345678-1234-abcd-ef00-0123456789ab",0x0c] = "RpcGetPrinterDriverDirectory",
		["12345678-1234-abcd-ef00-0123456789ab",0x0d] = "RpcDeletePrinterDriver",
		["12345678-1234-abcd-ef00-0123456789ab",0x0e] = "RpcAddPrintProcessor",
		["12345678-1234-abcd-ef00-0123456789ab",0x0f] = "RpcEnumPrintProcessors",
		["12345678-1234-abcd-ef00-0123456789ab",0x10] = "RpcGetPrintProcessorDirectory",
		["12345678-1234-abcd-ef00-0123456789ab",0x11] = "RpcStartDocPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x12] = "RpcStartPagePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x13] = "RpcWritePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x14] = "RpcEndPagePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x15] = "RpcAbortPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x16] = "RpcReadPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x17] = "RpcEndDocPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x18] = "RpcAddJob",
		["12345678-1234-abcd-ef00-0123456789ab",0x19] = "RpcScheduleJob",
		["12345678-1234-abcd-ef00-0123456789ab",0x1a] = "RpcGetPrinterData",
		["12345678-1234-abcd-ef00-0123456789ab",0x1b] = "RpcSetPrinterData",
		["12345678-1234-abcd-ef00-0123456789ab",0x1c] = "RpcWaitForPrinterChange",
		["12345678-1234-abcd-ef00-0123456789ab",0x1d] = "RpcClosePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x1e] = "RpcAddForm",
		["12345678-1234-abcd-ef00-0123456789ab",0x1f] = "RpcDeleteForm",
		["12345678-1234-abcd-ef00-0123456789ab",0x20] = "RpcGetForm",
		["12345678-1234-abcd-ef00-0123456789ab",0x21] = "RpcSetForm",
		["12345678-1234-abcd-ef00-0123456789ab",0x22] = "RpcEnumForms",
		["12345678-1234-abcd-ef00-0123456789ab",0x23] = "RpcEnumPorts",
		["12345678-1234-abcd-ef00-0123456789ab",0x24] = "RpcEnumMonitors",
		["12345678-1234-abcd-ef00-0123456789ab",0x25] = "RpcAddPort",
		["12345678-1234-abcd-ef00-0123456789ab",0x26] = "RpcConfigurePort",
		["12345678-1234-abcd-ef00-0123456789ab",0x27] = "RpcDeletePort",
		["12345678-1234-abcd-ef00-0123456789ab",0x28] = "RpcCreatePrinterIC",
		["12345678-1234-abcd-ef00-0123456789ab",0x29] = "RpcPlayGdiScriptOnPrinterIC",
		["12345678-1234-abcd-ef00-0123456789ab",0x2a] = "RpcDeletePrinterIC",
		["12345678-1234-abcd-ef00-0123456789ab",0x2b] = "RpcAddPrinterConnection",
		["12345678-1234-abcd-ef00-0123456789ab",0x2c] = "RpcDeletePrinterConnection",
		["12345678-1234-abcd-ef00-0123456789ab",0x2d] = "RpcPrinterMessageBox",
		["12345678-1234-abcd-ef00-0123456789ab",0x2e] = "RpcAddMonitor",
		["12345678-1234-abcd-ef00-0123456789ab",0x2f] = "RpcDeleteMonitor",
		["12345678-1234-abcd-ef00-0123456789ab",0x30] = "RpcDeletePrintProcessor",
		["12345678-1234-abcd-ef00-0123456789ab",0x31] = "RpcAddPrintProvidor",
		["12345678-1234-abcd-ef00-0123456789ab",0x32] = "RpcDeletePrintProvidor",
		["12345678-1234-abcd-ef00-0123456789ab",0x33] = "RpcEnumPrintProcessorDatatypes",
		["12345678-1234-abcd-ef00-0123456789ab",0x34] = "RpcResetPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x35] = "RpcGetPrinterDriver2",
		["12345678-1234-abcd-ef00-0123456789ab",0x36] = "RpcClientFindFirstPrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x37] = "RpcFindNextPrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x38] = "RpcFindClosePrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x39] = "RpcRouterFindFirstPrinterChangeNotificationOld",
		["12345678-1234-abcd-ef00-0123456789ab",0x3a] = "RpcReplyOpenPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x3b] = "RpcRouterReplyPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x3c] = "RpcReplyClosePrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x3d] = "RpcAddPortEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x3e] = "RpcRemoteFindFirstPrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x3f] = "RpcSpoolerInit",
		["12345678-1234-abcd-ef00-0123456789ab",0x40] = "RpcResetPrinterEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x41] = "RpcRemoteFindFirstPrinterChangeNotificationEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x42] = "RpcRouterReplyPrinterEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x43] = "RpcRouterRefreshPrinterChangeNotification",
		["12345678-1234-abcd-ef00-0123456789ab",0x44] = "RpcSetAllocFailCount",
		["12345678-1234-abcd-ef00-0123456789ab",0x45] = "RpcSplOpenPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x46] = "RpcAddPrinterEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x47] = "RpcSetPort",
		["12345678-1234-abcd-ef00-0123456789ab",0x48] = "RpcEnumPrinterData",
		["12345678-1234-abcd-ef00-0123456789ab",0x49] = "RpcDeletePrinterData",
		["12345678-1234-abcd-ef00-0123456789ab",0x4a] = "RpcClusterSplOpen",
		["12345678-1234-abcd-ef00-0123456789ab",0x4b] = "RpcClusterSplClose",
		["12345678-1234-abcd-ef00-0123456789ab",0x4c] = "RpcClusterSplIsAlive",
		["12345678-1234-abcd-ef00-0123456789ab",0x4d] = "RpcSetPrinterDataEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x4e] = "RpcGetPrinterDataEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x4f] = "RpcEnumPrinterDataEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x50] = "RpcEnumPrinterKey",
		["12345678-1234-abcd-ef00-0123456789ab",0x51] = "RpcDeletePrinterDataEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x52] = "RpcDeletePrinterKey",
		["12345678-1234-abcd-ef00-0123456789ab",0x53] = "RpcSeekPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x54] = "RpcDeletePrinterDriverEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x55] = "RpcAddPerMachineConnection",
		["12345678-1234-abcd-ef00-0123456789ab",0x56] = "RpcDeletePerMachineConnection",
		["12345678-1234-abcd-ef00-0123456789ab",0x57] = "RpcEnumPerMachineConnections",
		["12345678-1234-abcd-ef00-0123456789ab",0x58] = "RpcXcvData",
		["12345678-1234-abcd-ef00-0123456789ab",0x59] = "RpcAddPrinterDriverEx",
		["12345678-1234-abcd-ef00-0123456789ab",0x5a] = "RpcSplOpenPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x5b] = "RpcGetSpoolFileInfo",
		["12345678-1234-abcd-ef00-0123456789ab",0x5c] = "RpcCommitSpoolData",
		["12345678-1234-abcd-ef00-0123456789ab",0x5d] = "RpcCloseSpoolFileHandle",
		["12345678-1234-abcd-ef00-0123456789ab",0x5e] = "RpcFlushPrinter",
		["12345678-1234-abcd-ef00-0123456789ab",0x5f] = "RpcSendRecvBidiData",
		["12345678-1234-abcd-ef00-0123456789ab",0x60] = "RpcAddDriverCatalog",
		["12345678-1234-abcd-ef00-0123456789ab",0x61] = "RpcAddPrinterConnection2",
		["12345678-1234-abcd-ef00-0123456789ab",0x62] = "RpcDeletePrinterConnection2",
		["12345678-1234-abcd-ef00-0123456789ab",0x63] = "RpcInstallPrinterDriverFromPackage",
		["12345678-1234-abcd-ef00-0123456789ab",0x64] = "RpcUploadPrinterDriverPackage",
		["12345678-1234-abcd-ef00-0123456789ab",0x65] = "RpcGetCorePrinterDrivers",
		["12345678-1234-abcd-ef00-0123456789ab",0x66] = "RpcCorePrinterDriverInstalled",
		["12345678-1234-abcd-ef00-0123456789ab",0x67] = "RpcGetPrinterDriverPackagePath",
		["12345678-1234-abcd-ef00-0123456789ab",0x68] = "RpcReportJobProcessingProgress",

		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x00] = "NetrCharDevEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x01] = "NetrCharDevGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x02] = "NetrCharDevControl",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x03] = "NetrCharDevQEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x04] = "NetrCharDevQGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x05] = "NetrCharDevQSetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x06] = "NetrCharDevQPurge",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x07] = "NetrCharDevQPurgeSelf",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x08] = "NetrConnectionEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x09] = "NetrFileEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0a] = "NetrFileGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0b] = "NetrFileClose",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0c] = "NetrSessionEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0d] = "NetrSessionDel",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0e] = "NetrShareAdd",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x0f] = "NetrShareEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x10] = "NetrShareGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x11] = "NetrShareSetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x12] = "NetrShareDel",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x13] = "NetrShareDelSticky",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x14] = "NetrShareCheck",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x15] = "NetrServerGetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x16] = "NetrServerSetInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x17] = "NetrServerDiskEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x18] = "NetrServerStatisticsGet",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x19] = "NetrServerTransportAdd",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1a] = "NetrServerTransportEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1b] = "NetrServerTransportDel",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1c] = "NetrRemoteTOD",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1d] = "NetrServerSetServiceBits",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1e] = "NetprPathType",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x1f] = "NetprPathCanonicalize",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x20] = "NetprPathCompare",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x21] = "NetprNameValidate",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x22] = "NetprNameCanonicalize",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x23] = "NetprNameCompare",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x24] = "NetrShareEnumSticky",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x25] = "NetrShareDelStart",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x26] = "NetrShareDelCommit",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x27] = "NetrpGetFileSecurity",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x28] = "NetrpSetFileSecurity",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x29] = "NetrServerTransportAddEx",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2a] = "NetrServerSetServiceBitsEx",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2b] = "NetrDfsGetVersion",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2c] = "NetrDfsCreateLocalPartition",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2d] = "NetrDfsDeleteLocalPartition",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2e] = "NetrDfsSetLocalVolumeState",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x2f] = "NetrDfsSetServerInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x30] = "NetrDfsCreateExitPoint",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x31] = "NetrDfsDeleteExitPoint",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x32] = "NetrDfsModifyPrefix",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x33] = "NetrDfsFixLocalVolume",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x34] = "NetrDfsManagerReportSiteInfo",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x35] = "NetrServerTransportDelEx",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x37] = "NetrServerAliasEnum",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x38] = "NetrServerAliasDel",
		["4b324fc8-1670-01d3-1278-5a47bf6ee188",0x39] = "NetrShareDelEx",

		["12345778-1234-abcd-ef00-0123456789ac",0x00] = "SamrConnect",
		["12345778-1234-abcd-ef00-0123456789ac",0x01] = "SamrCloseHandle",
		["12345778-1234-abcd-ef00-0123456789ac",0x02] = "SamrSetSecurityObject",
		["12345778-1234-abcd-ef00-0123456789ac",0x03] = "SamrQuerySecurityObject",
		["12345778-1234-abcd-ef00-0123456789ac",0x04] = "SamrShutdownSamServer",
		["12345778-1234-abcd-ef00-0123456789ac",0x05] = "SamrLookupDomainInSamServer",
		["12345778-1234-abcd-ef00-0123456789ac",0x06] = "SamrEnumerateDomainsInSamServer",
		["12345778-1234-abcd-ef00-0123456789ac",0x07] = "SamrOpenDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x08] = "SamrQueryInformationDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x09] = "SamrSetInformationDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0a] = "SamrCreateGroupInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0b] = "SamrEnumerateGroupsInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0c] = "SamrCreateUserInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0d] = "SamrEnumerateUsersInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0e] = "SamrCreateAliasInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x0f] = "SamrEnumerateAliasesInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x10] = "SamrGetAliasMembership",
		["12345778-1234-abcd-ef00-0123456789ac",0x11] = "SamrLookupNamesInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x12] = "SamrLookupIdsInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x13] = "SamrOpenGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x14] = "SamrQueryInformationGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x15] = "SamrSetInformationGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x16] = "SamrAddMemberToGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x17] = "SamrDeleteGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x18] = "SamrRemoveMemberFromGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x19] = "SamrGetMembersInGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x1a] = "SamrSetMemberAttributesOfGroup",
		["12345778-1234-abcd-ef00-0123456789ac",0x1b] = "SamrOpenAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x1c] = "SamrQueryInformationAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x1d] = "SamrSetInformationAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x1e] = "SamrDeleteAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x1f] = "SamrAddMemberToAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x20] = "SamrRemoveMemberFromAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x21] = "SamrGetMembersInAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x22] = "SamrOpenUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x23] = "SamrDeleteUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x24] = "SamrQueryInformationUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x25] = "SamrSetInformationUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x26] = "SamrChangePasswordUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x27] = "SamrGetGroupsForUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x28] = "SamrQueryDisplayInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x29] = "SamrGetDisplayEnumerationIndex",
		["12345778-1234-abcd-ef00-0123456789ac",0x2a] = "SamrTestPrivateFunctionsDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x2b] = "SamrTestPrivateFunctionsUser",
		["12345778-1234-abcd-ef00-0123456789ac",0x2c] = "SamrGetUserDomainPasswordInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x2d] = "SamrRemoveMemberFromForeignDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x2e] = "SamrQueryInformationDomain2",
		["12345778-1234-abcd-ef00-0123456789ac",0x2f] = "SamrQueryInformationUser2",
		["12345778-1234-abcd-ef00-0123456789ac",0x30] = "SamrQueryDisplayInformation2",
		["12345778-1234-abcd-ef00-0123456789ac",0x31] = "SamrGetDisplayEnumerationIndex2",
		["12345778-1234-abcd-ef00-0123456789ac",0x32] = "SamrCreateUser2InDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x33] = "SamrQueryDisplayInformation3",
		["12345778-1234-abcd-ef00-0123456789ac",0x34] = "SamrAddMultipleMembersToAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x35] = "SamrRemoveMultipleMembersFromAlias",
		["12345778-1234-abcd-ef00-0123456789ac",0x36] = "SamrOemChangePasswordUser2",
		["12345778-1234-abcd-ef00-0123456789ac",0x37] = "SamrUnicodeChangePasswordUser2",
		["12345778-1234-abcd-ef00-0123456789ac",0x38] = "SamrGetDomainPasswordInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x39] = "SamrConnect2",
		["12345778-1234-abcd-ef00-0123456789ac",0x3a] = "SamrSetInformationUser2",
		["12345778-1234-abcd-ef00-0123456789ac",0x3b] = "SamrSetBootKeyInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x3c] = "SamrGetBootKeyInformation",
		["12345778-1234-abcd-ef00-0123456789ac",0x3d] = "SamrConnect3",
		["12345778-1234-abcd-ef00-0123456789ac",0x3e] = "SamrConnect4",
		["12345778-1234-abcd-ef00-0123456789ac",0x3f] = "SamrUnicodeChangePasswordUser3",
		["12345778-1234-abcd-ef00-0123456789ac",0x40] = "SamrConnect5",
		["12345778-1234-abcd-ef00-0123456789ac",0x41] = "SamrRidToSid",
		["12345778-1234-abcd-ef00-0123456789ac",0x42] = "SamrSetDSRMPassword",
		["12345778-1234-abcd-ef00-0123456789ac",0x43] = "SamrValidatePassword",
		["12345778-1234-abcd-ef00-0123456789ac",0x44] = "SamrQueryLocalizableAccountsInDomain",
		["12345778-1234-abcd-ef00-0123456789ac",0x45] = "SamrPerformGenericOperation",

		["338cd001-2244-31f1-aaaa-900038001003",0x00] = "OpenClassesRoot",
		["338cd001-2244-31f1-aaaa-900038001003",0x01] = "OpenCurrentUser",
		["338cd001-2244-31f1-aaaa-900038001003",0x02] = "OpenLocalMachine",
		["338cd001-2244-31f1-aaaa-900038001003",0x03] = "OpenPerformanceData",
		["338cd001-2244-31f1-aaaa-900038001003",0x04] = "OpenUsers",
		["338cd001-2244-31f1-aaaa-900038001003",0x05] = "BaseRegCloseKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x06] = "BaseRegCreateKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x07] = "BaseRegDeleteKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x08] = "BaseRegDeleteValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x09] = "BaseRegEnumKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x0a] = "BaseRegEnumValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x0b] = "BaseRegFlushKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x0c] = "BaseRegGetKeySecurity",
		["338cd001-2244-31f1-aaaa-900038001003",0x0d] = "BaseRegLoadKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x0e] = "BaseRegNotifyChangeKeyValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x0f] = "BaseRegOpenKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x10] = "BaseRegQueryInfoKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x11] = "BaseRegQueryValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x12] = "BaseRegReplaceKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x13] = "BaseRegRestoreKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x14] = "BaseRegSaveKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x15] = "BaseRegSetKeySecurity",
		["338cd001-2244-31f1-aaaa-900038001003",0x16] = "BaseRegSetValue",
		["338cd001-2244-31f1-aaaa-900038001003",0x17] = "BaseRegUnLoadKey",
		["338cd001-2244-31f1-aaaa-900038001003",0x18] = "BaseInitiateSystemShutdown",
		["338cd001-2244-31f1-aaaa-900038001003",0x19] = "BaseAbortSystemShutdown",
		["338cd001-2244-31f1-aaaa-900038001003",0x1a] = "BaseRegGetVersion",
		["338cd001-2244-31f1-aaaa-900038001003",0x1b] = "OpenCurrentConfig",
		["338cd001-2244-31f1-aaaa-900038001003",0x1c] = "OpenDynData",
		["338cd001-2244-31f1-aaaa-900038001003",0x1d] = "BaseRegQueryMultipleValues",
		["338cd001-2244-31f1-aaaa-900038001003",0x1e] = "BaseInitiateSystemShutdownEx",
		["338cd001-2244-31f1-aaaa-900038001003",0x1f] = "BaseRegSaveKeyEx",
		["338cd001-2244-31f1-aaaa-900038001003",0x20] = "OpenPerformanceText",
		["338cd001-2244-31f1-aaaa-900038001003",0x21] = "OpenPerformanceNlsText",
		["338cd001-2244-31f1-aaaa-900038001003",0x22] = "BaseRegQueryMultipleValues2",
		["338cd001-2244-31f1-aaaa-900038001003",0x23] = "BaseRegDeleteKeyEx",

		# dssetup
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x00] = "DsRolerGetPrimaryDomainInformation",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x01] = "DsRolerDnsNameToFlatName",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x02] = "DsRolerDcAsDc",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x03] = "DsRolerDcAsReplica",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x04] = "DsRolerDemoteDc",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x05] = "DsRolerGetDcOperationProgress",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x06] = "DsRolerGetDcOperationResults",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x07] = "DsRolerCancel",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x08] = "DsRolerServerSaveStateForUpgrade",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x09] = "DsRolerUpgradeDownlevelServer",
		["3919286a-b10c-11d0-9ba8-00c04fd92ef5",0x0a] = "DsRolerAbortDownlevelServerUpgrade",

		# svcctl
		["367abb81-9844-35f1-ad32-98f038001003",0x00] = "CloseServiceHandle",
		["367abb81-9844-35f1-ad32-98f038001003",0x01] = "ControlService",
		["367abb81-9844-35f1-ad32-98f038001003",0x02] = "DeleteService",
		["367abb81-9844-35f1-ad32-98f038001003",0x03] = "LockServiceDatabase",
		["367abb81-9844-35f1-ad32-98f038001003",0x04] = "QueryServiceObjectSecurity",
		["367abb81-9844-35f1-ad32-98f038001003",0x05] = "SetServiceObjectSecurity",
		["367abb81-9844-35f1-ad32-98f038001003",0x06] = "QueryServiceStatus",
		["367abb81-9844-35f1-ad32-98f038001003",0x07] = "SetServiceStatus",
		["367abb81-9844-35f1-ad32-98f038001003",0x08] = "UnlockServiceDatabase",
		["367abb81-9844-35f1-ad32-98f038001003",0x09] = "NotifyBootConfigStatus",
		["367abb81-9844-35f1-ad32-98f038001003",0x0a] = "ScSetServiceBitsW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0b] = "ChangeServiceConfigW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0c] = "CreateServiceW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0d] = "EnumDependentServicesW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0e] = "EnumServicesStatusW",
		["367abb81-9844-35f1-ad32-98f038001003",0x0f] = "OpenSCManagerW",
		["367abb81-9844-35f1-ad32-98f038001003",0x10] = "OpenServiceW",
		["367abb81-9844-35f1-ad32-98f038001003",0x11] = "QueryServiceConfigW",
		["367abb81-9844-35f1-ad32-98f038001003",0x12] = "QueryServiceLockStatusW",
		["367abb81-9844-35f1-ad32-98f038001003",0x13] = "StartServiceW",
		["367abb81-9844-35f1-ad32-98f038001003",0x14] = "GetServiceDisplayNameW",
		["367abb81-9844-35f1-ad32-98f038001003",0x15] = "GetServiceKeyNameW",
		["367abb81-9844-35f1-ad32-98f038001003",0x16] = "ScSetServiceBitsA",
		["367abb81-9844-35f1-ad32-98f038001003",0x17] = "ChangeServiceConfigA",
		["367abb81-9844-35f1-ad32-98f038001003",0x18] = "CreateServiceA",
		["367abb81-9844-35f1-ad32-98f038001003",0x19] = "EnumDependentServicesA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1a] = "EnumServicesStatusA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1b] = "OpenSCManagerA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1c] = "OpenServiceA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1d] = "QueryServiceConfigA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1e] = "QueryServiceLockStatusA",
		["367abb81-9844-35f1-ad32-98f038001003",0x1f] = "StartServiceA",
		["367abb81-9844-35f1-ad32-98f038001003",0x20] = "GetServiceDisplayNameA",
		["367abb81-9844-35f1-ad32-98f038001003",0x21] = "GetServiceKeyNameA",
		["367abb81-9844-35f1-ad32-98f038001003",0x22] = "ScGetCurrentGroupStateW",
		["367abb81-9844-35f1-ad32-98f038001003",0x23] = "EnumServiceGroupW",
		["367abb81-9844-35f1-ad32-98f038001003",0x24] = "ChangeServiceConfig2A",
		["367abb81-9844-35f1-ad32-98f038001003",0x25] = "ChangeServiceConfig2W",
		["367abb81-9844-35f1-ad32-98f038001003",0x26] = "QueryServiceConfig2A",
		["367abb81-9844-35f1-ad32-98f038001003",0x27] = "QueryServiceConfig2W",
		["367abb81-9844-35f1-ad32-98f038001003",0x28] = "QueryServiceStatusEx",
		["367abb81-9844-35f1-ad32-98f038001003",0x29] = "EnumServicesStatusExA",
		["367abb81-9844-35f1-ad32-98f038001003",0x2a] = "EnumServicesStatusExW",
		["367abb81-9844-35f1-ad32-98f038001003",0x2b] = "ScSendTSMessage",
		["367abb81-9844-35f1-ad32-98f038001003",0x2c] = "CreateServiceWOW64A",
		["367abb81-9844-35f1-ad32-98f038001003",0x2d] = "CreateServiceWOW64W",
		["367abb81-9844-35f1-ad32-98f038001003",0x2e] = "ScQueryServiceTagInfo",
		["367abb81-9844-35f1-ad32-98f038001003",0x2f] = "NotifyServiceStatusChange",
		["367abb81-9844-35f1-ad32-98f038001003",0x30] = "GetNotifyResult",
		["367abb81-9844-35f1-ad32-98f038001003",0x31] = "CloseNotifyHandle",
		["367abb81-9844-35f1-ad32-98f038001003",0x32] = "ControlServiceExA",
		["367abb81-9844-35f1-ad32-98f038001003",0x33] = "ControlServiceExW",
		["367abb81-9844-35f1-ad32-98f038001003",0x34] = "ScSendPnPMessage",
		["367abb81-9844-35f1-ad32-98f038001003",0x35] = "ScValidatePnPService",
		["367abb81-9844-35f1-ad32-98f038001003",0x36] = "ScOpenServiceStatusHandle",

		# browser
		["6bffd098-a112-3610-9833-012892020162",0x00] = "BrowserrServerEnum",
		["6bffd098-a112-3610-9833-012892020162",0x01] = "BrowserrDebugCall",
		["6bffd098-a112-3610-9833-012892020162",0x02] = "BrowserrQueryOtherDomains",
		["6bffd098-a112-3610-9833-012892020162",0x03] = "BrowserrResetNetlogonState",
		["6bffd098-a112-3610-9833-012892020162",0x04] = "BrowserrDebugTrace",
		["6bffd098-a112-3610-9833-012892020162",0x05] = "BrowserrQueryStatistics",
		["6bffd098-a112-3610-9833-012892020162",0x06] = "BrowserrResetStatistics",
		["6bffd098-a112-3610-9833-012892020162",0x07] = "NetrBrowserStatisticsClear",
		["6bffd098-a112-3610-9833-012892020162",0x08] = "NetrBrowserStatisticsGet",
		["6bffd098-a112-3610-9833-012892020162",0x09] = "BrowserrSetNetlogonState",
		["6bffd098-a112-3610-9833-012892020162",0x0a] = "BrowserrQueryEmulatedDomains",
		["6bffd098-a112-3610-9833-012892020162",0x0b] = "BrowserrServerEnumEx",

		# AudioSrv
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x00] = "gfxCreateZoneFactoriesList",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x01] = "gfxCreateGfxFactoriesList",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x02] = "gfxCreateGfxList",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x03] = "gfxRemoveGfx",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x04] = "gfxAddGfx",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x05] = "gfxModifyGx",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x06] = "gfxOpenGfx",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x07] = "gfxLogon",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x08] = "gfxLogoff",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x09] = "winmmRegisterSessionNotificationEvent",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0a] = "winmmUnregisterSessionNotification",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0b] = "winmmSessionConnectState",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0c] = "wdmDriverOpenDrvRegKey",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0d] = "winmmAdvisePreferredDeviceChange",
		["3faf4738-3a21-4307-b46c-fdda9bb8c0d5",0x0e] = "winmmGetPnpInfo",

		# AudioRpc
		["c386ca3e-9061-4a72-821e-498d83be188f",0x00] = "AudioServerConnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x01] = "AudioServerDisconnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x02] = "AudioServerInitialize",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x03] = "AudioServerGetAudioSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x04] = "AudioServerCreateStream",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x05] = "AudioServerDestroyStream",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x06] = "AudioServerGetStreamLatency",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x07] = "AudioServerGetMixFormat",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x08] = "AudioServerIsFormatSupported",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x09] = "AudioServerGetDevicePeriod",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0a] = "AudioVolumeGetMasterVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0b] = "AudioSessionGetProcessId",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0c] = "AudioSessionGetState",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0d] = "AudioSessionGetLastActivation",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0e] = "AudioSessionGetLastInactivation",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x0f] = "AudioSessionIsSystemSoundsSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x10] = "AudioSessionGetDisplayName",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x11] = "AudioSessionSetDisplayName",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x12] = "AudioSessionGetSessionClass",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x13] = "AudioSessionSetSessionClass",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x14] = "AudioSessionGetVolume",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x15] = "AudioSessionSetVolume",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x16] = "AudioSessionGetMute",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x17] = "AudioSessionSetMute",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x18] = "AudioSessionGetChannelCount",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x19] = "AudioSessionSetChannelVolume",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1a] = "AudioSessionGetChannelVolume",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1b] = "AudioSessionSetAllVolumes",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1c] = "AudioSessionGetAllVolumes",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1d] = "AudioServerDisconnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1e] = "AudioServerGetMixFormat",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x1f] = "PolicyConfigGetDeviceFormat",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x20] = "PolicyConfigSetDeviceFormat",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x21] = "AudioServerGetDevicePeriod",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x22] = "PolicyConfigSetProcessingPeriod",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x23] = "PolicyConfigGetShareMode",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x24] = "PolicyConfigSetShareMode",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x25] = "GetAudioSessionManager",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x26] = "AudioSessionManagerDestroy",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x27] = "AudioSessionManagerGetAudioSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x28] = "AudioSessionManagerGetCurrentSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x29] = "AudioSessionManagerGetExistingSession",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2a] = "AudioSessionManagerAddAudioSessionClientNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2b] = "AudioSessionManagerDeleteAudioSessionClientNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2c] = "AudioSessionManagerAddAudioSessionClientNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2d] = "AudioVolumeConnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2e] = "AudioVolumeDisconnect",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x2f] = "AudioVolumeGetChannelCount",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x30] = "AudioVolumeSetMasterVolumeLevel",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x31] = "AudioVolumeSetMasterVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x32] = "AudioVolumeGetMasterVolumeLevel",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x33] = "AudioVolumeGetMasterVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x34] = "AudioVolumeSetChannelVolumeLevel",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x35] = "AudioVolumeSetChannelVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x36] = "AudioVolumeGetChannelVolumeLevel",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x37] = "AudioVolumeGetChannelVolumeLevelScalar",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x38] = "AudioVolumeSetMute",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x39] = "AudioSessionGetDisplayName",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3a] = "AudioVolumeAddMasterVolumeNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3b] = "AudioVolumeDeleteMasterVolumeNotification",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3c] = "AudioMeterGetAverageRMS",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3d] = "AudioMeterGetChannelsRMS",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3e] = "AudioMeterGetPeakValue",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x3f] = "AudioMeterGetChannelsPeakValues",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x40] = "AudioVolumeGetStepInfo",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x41] = "AudioVolumeStepUp",
		["c386ca3e-9061-4a72-821e-498d83be188f",0x42] = "AudioVolumeStepDown",

		# dhcpcsvc6
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6",0x00] = "RpcSrvRequestPrefix",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6",0x01] = "RpcSrvRenewPrefix",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6",0x02] = "RpcSrvReleasePrefix",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d6",0x03] = "RpcSrvRequestParams",

		# RpcSrvDHCPC
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x00] = "RpcSrvEnableDhcp",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x01] = "RpcSrvRenewLease",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x02] = "RpcSrvRenewLeaseByBroadcast",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x03] = "RpcSrvReleaseLease",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x04] = "RpcSrvSetFallbackParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x05] = "RpcSrvGetFallbackParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x06] = "RpcSrvFallbackRefreshParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x07] = "RpcSrvStaticRefreshParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x08] = "RpcSrvRemoveDnsRegistrations",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x09] = "RpcSrvRequestParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0a] = "RpcSrvPersistentRequestParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0b] = "RpcSrvRegisterParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0c] = "RpcSrvDeRegisterParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0d] = "RpcSrvEnumInterfaces",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0e] = "RpcSrvQueryLeaseInfo",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x0f] = "RpcSrvSetClassId",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x10] = "RpcSrvGetClassId",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x11] = "RpcSrvSetClientId",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x12] = "RpcSrvGetClientId",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x13] = "RpcSrvNotifyMediaReconnected",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x14] = "RpcSrvGetOriginalSubnetMask",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x15] = "RpcSrvSetMSFTVendorSpecificOptions",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x16] = "RpcSrvRequestCachedParams",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x17] = "RpcSrvRegisterConnectionStateNotification",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x18] = "RpcSrvDeRegisterConnectionStateNotification",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x19] = "RpcSrvGetNotificationStatus",
		["3c4728c5-f0ab-448b-bda1-6ce01eb0a6d5",0x1a] = "RpcSrvGetDhcpServicedConnections",

		# lcrpc
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x00] = "RpcLicensingOpenServer",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x01] = "RpcLicensingCloseServer",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x02] = "RpcLicensingLoadPolicy",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x03] = "RpcLicensingUnloadPolicy",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x04] = "RpcLicensingSetPolicy",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x05] = "RpcLicensingGetAvailablePolicyIds",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x06] = "RpcLicensingGetPolicy",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x07] = "RpcLicensingGetPolicyInformation",
		["2f59a331-bf7d-48cb-9ec5-7c090d76e8b8",0x08] = "RpcLicensingDeactivateCurrentPolicy",

		# winstation_rpc
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x00] = "RpcWinStationOpenServer",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x01] = "RpcWinStationCloseServer",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x02] = "RpcIcaServerPing",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x03] = "RpcWinStationEnumerate",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x04] = "RpcWinStationRename",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x05] = "RpcWinStationQueryInformation",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x06] = "RpcWinStationSetInformation",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x07] = "RpcWinStationSendMessage",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x08] = "RpcLogonIdFromWinStationName",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x09] = "RpcWinStationNameFromLogonId",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0a] = "RpcWinStationConnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0b] = "RpcWinStationVirtualOpen",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0c] = "RpcWinStationBeepOpen",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0d] = "RpcWinStationDisconnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0e] = "RpcWinStationReset",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x0f] = "RpcWinStationShutdownSystem",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x10] = "RpcWinStationWaitSystemEvent",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x11] = "RpcWinStationShadow",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x12] = "RpcWinStationShadowTargetSetup",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x13] = "RpcWinStationShadowTarget",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x14] = "RpcWinStationGenerateLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x15] = "RpcWinStationInstallLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x16] = "RpcWinStationEnumerateLicenses",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x17] = "RpcWinStationActivateLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x18] = "RpcWinStationRemoveLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x19] = "RpcWinStationQueryLicense",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1a] = "RpcWinStationSetPoolCount",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1b] = "RpcWinStationQueryUpdateRequired",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1c] = "RpcWinStationCallback",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1d] = "RpcWinStationGetApplicationInfo",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1e] = "RpcWinStationReadRegistry",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x1f] = "RpcWinStationWaitForConnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x20] = "RpcWinStationNotifyLogon",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x21] = "RpcWinStationNotifyLogoff",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x22] = "RpcWinStationEnumerateProcesses",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x23] = "RpcWinStationAnnoyancePopup",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x24] = "RpcWinStationEnumerateProcesses",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x25] = "RpcWinStationTerminateProcess",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x26] = "RpcServerNWLogonSetAdmin",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x27] = "RpcServerNWLogonQueryAdmin",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x28] = "RpcWinStationNtsdDebug",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x29] = "RpcWinStationBreakPoint",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2a] = "RpcWinStationCheckForApplicationName",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2b] = "RpcWinStationGetAllProcesses",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2c] = "RpcWinStationGetProcessSid",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2d] = "RpcWinStationGetTermSrvCountersValue",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2e] = "RpcWinStationReInitializeSecurity",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x2f] = "RpcWinStationBroadcastSystemMessage",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x30] = "RpcWinStationSendWindowMessage",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x31] = "RpcWinStationNotifyNewSession",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x32] = "RpcServerGetInternetConnectorStatus",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x33] = "RpcServerSetInternetConnectorStatus",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x34] = "RpcServerQueryInetConnectorInformation",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x35] = "RpcWinStationGetLanAdapterName",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x36] = "RpcWinStationUpdateUserConfig",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x37] = "RpcWinStationQueryLogonCredentials",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x38] = "RpcWinStationRegisterConsoleNotification",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x39] = "RpcWinStationUnRegisterConsoleNotification",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3a] = "RpcWinStationUpdateSettings",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3b] = "RpcWinStationShadowStop",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3c] = "RpcWinStationCloseServerEx",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3d] = "RpcWinStationIsHelpAssistantSession",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3e] = "RpcWinStationGetMachinePolicy",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x3f] = "RpcWinStationUpdateClientCachedCredentials",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x40] = "RpcWinStationFUSCanRemoteUserDisconnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x41] = "RpcWinStationCheckLoopBack",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x42] = "RpcConnectCallback",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x43] = "RpcWinStationNotifyDisconnectPipe",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x44] = "RpcWinStationSessionInitialized",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x45] = "RpcRemoteAssistancePrepareSystemRestore",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x46] = "RpcWinStationGetAllProcesses_NT6",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x47] = "RpcWinStationRegisterNotificationEvent",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x48] = "RpcWinStationUnRegisterNotificationEvent",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x49] = "RpcWinStationAutoReconnect",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x4a] = "RpcWinStationCheckAccess",
		["5ca4a760-ebb1-11cf-8611-00a0245420ed",0x4b] = "RpcWinStationOpenSessionDirectory",

		# NsiS
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c3",0x00] = "nsi_binding_export",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c3",0x01] = "nsi_binding_unexport",

		# NsiC
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3",0x00] = "nsi_binding_lookup_begin",
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3",0x01] = "nsi_binding_lookup_done",
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3",0x02] = "nsi_binding_lookup_next",
		["d3fbb514-0e3b-11cb-8fad-08002b1d29c3",0x03] = "nsi_mgmt_handle_set_exp_age",

		# NsiM
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x00] = "nsi_group_delete",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x01] = "nsi_group_mbr_add",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x02] = "nsi_group_mbr_remove",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x03] = "nsi_group_mbr_inq_begin",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x04] = "nsi_group_mbr_inq_next",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x05] = "nsi_group_mbr_inq_done",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x06] = "nsi_profile_delete",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x07] = "nsi_profile_elt_add",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x08] = "nsi_profile_elt_remove",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x09] = "nsi_profile_elt_inq_begin",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0a] = "nsi_profile_elt_inq_next",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0b] = "nsi_profile_elt_inq_done",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0c] = "nsi_entry_object_inq_begin",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0d] = "nsi_entry_object_inq_next",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0e] = "nsi_entry_object_inq_done",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x0f] = "nsi_entry_expand_name",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x10] = "nsi_mgmt_binding_unexport",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x11] = "nsi_mgmt_entry_delete",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x12] = "nsi_mgmt_entry_create",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x13] = "nsi_mgmt_entry_inq_if_ids",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x14] = "nsi_mgmt_inq_exp_age",
		["d6d70ef0-0e3b-11cb-acc3-08002b1d29c4",0x15] = "nsi_mgmt_inq_set_age",

		# eventlog
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x00] = "ElfrClearELFW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x01] = "ElfrBackupELFW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x02] = "ElfrCloseEL",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x03] = "ElfrDeregisterEventSource",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x04] = "ElfrNumberOfRecords",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x05] = "ElfrOldestRecord",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x06] = "ElfrChangeNotify",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x07] = "ElfrOpenELW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x08] = "ElfrRegisterEventSourceW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x09] = "ElfrOpenBELW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0a] = "ElfrReadELW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0b] = "ElfrReportEventW",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0c] = "ElfrClearELFA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0d] = "ElfrBackupELFA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0e] = "ElfrOpenELA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x0f] = "ElfrRegisterEventSourceA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x10] = "ElfrOpenBELA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x11] = "ElfrReadELA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x12] = "ElfrReportEventA",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x13] = "ElfrRegisterClusterSvc",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x14] = "ElfrDeregisterClusterSvc",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x15] = "ElfrWriteClusterEvents",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x16] = "ElfrGetLogInformation",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x17] = "ElfrFlushEL",
		["82273fdc-e32a-18c3-3f78-827929dc23ea",0x18] = "ElfrReportEventAndSourceW",

		# ISeclogon
		["12b81e99-f207-4a4c-85d3-77b42f76fd14",0x00] = "SeclCreateProcessWithLogonW",
		["12b81e99-f207-4a4c-85d3-77b42f76fd14",0x01] = "SeclCreateProcessWithLogonExW",

		# IKeySvc
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x00] = "KeyrOpenKeyService",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x01] = "KeyrEnumerateProviders",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x02] = "KeyrEnumerateProviderTypes",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x03] = "KeyrEnumerateProvContainers",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x04] = "KeyrCloseKeyService",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x05] = "KeyrGetDefaultProvider",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x06] = "KeyrSetDefaultProvider",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x07] = "KeyrEnroll",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x08] = "KeyrExportCert",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x09] = "KeyrImportCert",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x0a] = "KeyrEnumerateAvailableCertTypes",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x0b] = "KeyrEnumerateCAs",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x0c] = "KeyrEnroll_V2",
		["8d0ffe72-d252-11d0-bf8f-00c04fd9126b",0x0d] = "KeyrQueryRequestStatus",

		# IKeySvc2
		["68b58241-c259-4f03-a2e5-a2651dcbc930",0x00] = "KSrSubmitRequest",
		["68b58241-c259-4f03-a2e5-a2651dcbc930",0x01] = "KSrGetTemplates",
		["68b58241-c259-4f03-a2e5-a2651dcbc930",0x02] = "KSrGetCAs",

		# ICertProtect
		["0d72a7d4-6148-11d1-b4aa-00c04fb66ea0",0x00] = "SSCertProtectFunction",

		# ICatDBSvc
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x00] = "SSCatDBAddCatalog",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x01] = "SSCatDBDeleteCatalog",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x02] = "SSCatDBEnumCatalogs",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x03] = "SSCatDBRegisterForChangeNotification",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x04] = "KeyrCloseKeyService",
		["f50aac00-c7f3-428e-a022-a6b71bfb9d43",0x05] = "SSCatDBRebuildDatabase",

		# lsarpc
		["12345778-1234-abcd-ef00-0123456789ab",0x00] = "LsarClose",
		["12345778-1234-abcd-ef00-0123456789ab",0x01] = "LsarDelete",
		["12345778-1234-abcd-ef00-0123456789ab",0x02] = "LsarEnumeratePrivileges",
		["12345778-1234-abcd-ef00-0123456789ab",0x03] = "LsarQuerySecurityObject",
		["12345778-1234-abcd-ef00-0123456789ab",0x04] = "LsarSetSecurityObject",
		["12345778-1234-abcd-ef00-0123456789ab",0x05] = "LsarChangePassword",
		["12345778-1234-abcd-ef00-0123456789ab",0x06] = "LsarOpenPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x07] = "LsarQueryInformationPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x08] = "LsarSetInformationPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x09] = "LsarClearAuditLog",
		["12345778-1234-abcd-ef00-0123456789ab",0x0a] = "LsarCreateAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x0b] = "LsarEnumerateAccounts",
		["12345778-1234-abcd-ef00-0123456789ab",0x0c] = "LsarCreateTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x0d] = "LsarEnumerateTrustedDomains",
		["12345778-1234-abcd-ef00-0123456789ab",0x0e] = "LsarLookupNames",
		["12345778-1234-abcd-ef00-0123456789ab",0x0f] = "LsarLookupSids",
		["12345778-1234-abcd-ef00-0123456789ab",0x10] = "LsarCreateSecret",
		["12345778-1234-abcd-ef00-0123456789ab",0x11] = "LsarOpenAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x12] = "LsarEnumeratePrivilegesAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x13] = "LsarAddPrivilegesToAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x14] = "LsarRemovePrivilegesFromAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x15] = "LsarGetQuotasForAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x16] = "LsarSetQuotasForAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x17] = "LsarGetSystemAccessAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x18] = "LsarSetSystemAccessAccount",
		["12345778-1234-abcd-ef00-0123456789ab",0x19] = "LsarOpenTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x1a] = "LsarQueryInfoTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x1b] = "LsarSetInformationTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x1c] = "LsarOpenSecret",
		["12345778-1234-abcd-ef00-0123456789ab",0x1d] = "LsarSetSecret",
		["12345778-1234-abcd-ef00-0123456789ab",0x1e] = "LsarQuerySecret",
		["12345778-1234-abcd-ef00-0123456789ab",0x1f] = "LsarLookupPrivilegeValue",
		["12345778-1234-abcd-ef00-0123456789ab",0x20] = "LsarLookupPrivilegeName",
		["12345778-1234-abcd-ef00-0123456789ab",0x21] = "LsarLookupPrivilegeDisplayName",
		["12345778-1234-abcd-ef00-0123456789ab",0x22] = "LsarDeleteObject",
		["12345778-1234-abcd-ef00-0123456789ab",0x23] = "LsarEnumerateAccountsWithUserRight",
		["12345778-1234-abcd-ef00-0123456789ab",0x24] = "LsarEnumerateAccountRights",
		["12345778-1234-abcd-ef00-0123456789ab",0x25] = "LsarAddAccountRights",
		["12345778-1234-abcd-ef00-0123456789ab",0x26] = "LsarRemoveAccountRights",
		["12345778-1234-abcd-ef00-0123456789ab",0x27] = "LsarQueryTrustedDomainInfo",
		["12345778-1234-abcd-ef00-0123456789ab",0x28] = "LsarSetTrustedDomainInfo",
		["12345778-1234-abcd-ef00-0123456789ab",0x29] = "LsarDeleteTrustedDomain",
		["12345778-1234-abcd-ef00-0123456789ab",0x2a] = "LsarStorePrivateData",
		["12345778-1234-abcd-ef00-0123456789ab",0x2b] = "LsarRetrievePrivateData",
		["12345778-1234-abcd-ef00-0123456789ab",0x2c] = "LsarOpenPolicy2",
		["12345778-1234-abcd-ef00-0123456789ab",0x2d] = "LsarGetUserName",
		["12345778-1234-abcd-ef00-0123456789ab",0x2e] = "LsarQueryInformationPolicy2",
		["12345778-1234-abcd-ef00-0123456789ab",0x2f] = "LsarSetInformationPolicy2",
		["12345778-1234-abcd-ef00-0123456789ab",0x30] = "LsarQueryTrustedDomainInfoByName",
		["12345778-1234-abcd-ef00-0123456789ab",0x31] = "LsarSetTrustedDomainInfoByName",
		["12345778-1234-abcd-ef00-0123456789ab",0x32] = "LsarEnumerateTrustedDomainsEx",
		["12345778-1234-abcd-ef00-0123456789ab",0x33] = "LsarCreateTrustedDomainEx",
		["12345778-1234-abcd-ef00-0123456789ab",0x34] = "LsarCloseTrustedDomainEx",
		["12345778-1234-abcd-ef00-0123456789ab",0x35] = "LsarQueryDomainInformationPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x36] = "LsarSetDomainInformationPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x37] = "LsarOpenTrustedDomainByName",
		["12345778-1234-abcd-ef00-0123456789ab",0x38] = "LsarTestCall",
		["12345778-1234-abcd-ef00-0123456789ab",0x39] = "LsarLookupSids2",
		["12345778-1234-abcd-ef00-0123456789ab",0x3a] = "LsarLookupNames2",
		["12345778-1234-abcd-ef00-0123456789ab",0x3b] = "LsarCreateTrustedDomainEx2",
		["12345778-1234-abcd-ef00-0123456789ab",0x3c] = "CredrWrite",
		["12345778-1234-abcd-ef00-0123456789ab",0x3d] = "CredrRead",
		["12345778-1234-abcd-ef00-0123456789ab",0x3e] = "CredrEnumerate",
		["12345778-1234-abcd-ef00-0123456789ab",0x3f] = "CredrWriteDomainCredentials",
		["12345778-1234-abcd-ef00-0123456789ab",0x40] = "CredrReadDomainCredentials",
		["12345778-1234-abcd-ef00-0123456789ab",0x41] = "CredrDelete",
		["12345778-1234-abcd-ef00-0123456789ab",0x42] = "CredrGetTargetInfo",
		["12345778-1234-abcd-ef00-0123456789ab",0x43] = "CredrProfileLoaded",
		["12345778-1234-abcd-ef00-0123456789ab",0x44] = "LsarLookupNames3",
		["12345778-1234-abcd-ef00-0123456789ab",0x45] = "CredrGetSessionTypes",
		["12345778-1234-abcd-ef00-0123456789ab",0x46] = "LsarRegisterAuditEvent",
		["12345778-1234-abcd-ef00-0123456789ab",0x47] = "LsarGenAuditEvent",
		["12345778-1234-abcd-ef00-0123456789ab",0x48] = "LsarUnregisterAuditEvent",
		["12345778-1234-abcd-ef00-0123456789ab",0x49] = "LsarQueryForestTrustInformation",
		["12345778-1234-abcd-ef00-0123456789ab",0x4a] = "LsarSetForestTrustInformation",
		["12345778-1234-abcd-ef00-0123456789ab",0x4b] = "CredrRename",
		["12345778-1234-abcd-ef00-0123456789ab",0x4c] = "LsarLookupSids3",
		["12345778-1234-abcd-ef00-0123456789ab",0x4d] = "LsarLookupNames4",
		["12345778-1234-abcd-ef00-0123456789ab",0x4e] = "LsarOpenPolicySce",
		["12345778-1234-abcd-ef00-0123456789ab",0x4f] = "LsarAdtRegisterSecurityEventSource",
		["12345778-1234-abcd-ef00-0123456789ab",0x50] = "LsarAdtUnregisterSecurityEventSource",
		["12345778-1234-abcd-ef00-0123456789ab",0x51] = "LsarAdtReportSecurityEvent",
		["12345778-1234-abcd-ef00-0123456789ab",0x52] = "CredrFindBestCredential",
		["12345778-1234-abcd-ef00-0123456789ab",0x53] = "LsarSetAuditPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x54] = "LsarQueryAuditPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x55] = "LsarEnumerateAuditPolicy",
		["12345778-1234-abcd-ef00-0123456789ab",0x56] = "LsarEnumerateAuditCategories",
		["12345778-1234-abcd-ef00-0123456789ab",0x57] = "LsarEnumerateAuditSubCategories",
		["12345778-1234-abcd-ef00-0123456789ab",0x58] = "LsarLookupAuditCategoryName",
		["12345778-1234-abcd-ef00-0123456789ab",0x59] = "LsarLookupAuditSubCategoryName",
		["12345778-1234-abcd-ef00-0123456789ab",0x5a] = "LsarSetAuditSecurity",
		["12345778-1234-abcd-ef00-0123456789ab",0x5b] = "LsarQueryAuditSecurity",
		["12345778-1234-abcd-ef00-0123456789ab",0x5c] = "CredReadByTokenHandle",
		["12345778-1234-abcd-ef00-0123456789ab",0x5d] = "CredrRestoreCredentials",
		["12345778-1234-abcd-ef00-0123456789ab",0x5e] = "CredrBackupCredentials",

		# msgsvc
		["17fdd703-1827-4e34-79d4-24a55c53bb37",0x00] = "NetrMessageNameAdd",
		["17fdd703-1827-4e34-79d4-24a55c53bb37",0x01] = "NetrMessageNameEnum",
		["17fdd703-1827-4e34-79d4-24a55c53bb37",0x02] = "NetrMessageNameGetInfo",
		["17fdd703-1827-4e34-79d4-24a55c53bb37",0x03] = "NetrMessageNameDel",

		# msgsvcsend
		["5a7b91f8-ff00-11d0-a9b2-00c04fb6e6fc",0x00] = "NetrSendMessage",

		# pnp
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x00] = "PNP_Disconnect",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x01] = "PNP_Connect",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x02] = "PNP_GetVersion",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x03] = "PNP_GetGlobalState",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x04] = "PNP_InitDetection",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x05] = "PNP_ReportLogOn",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x06] = "PNP_ValidateDeviceInstance",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x07] = "PNP_GetRootDeviceInstance",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x08] = "PNP_GetRelatedDeviceInstance",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x09] = "PNP_EnumerateSubKeys",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0a] = "PNP_GetDeviceList",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0b] = "PNP_GetDeviceListSize",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0c] = "PNP_GetDepth",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0d] = "PNP_GetDeviceRegProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0e] = "PNP_SetDeviceRegProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x0f] = "PNP_GetClassInstance",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x10] = "PNP_CreateKey",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x11] = "PNP_DeleteRegistryKey",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x12] = "PNP_GetClassCount",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x13] = "PNP_GetClassName",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x14] = "PNP_DeleteClassKey",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x15] = "PNP_GetInterfaceDeviceAlias",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x16] = "PNP_GetInterfaceDeviceList",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x17] = "PNP_GetInterfaceDeviceListSize",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x18] = "PNP_RegisterDeviceClassAssociation",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x19] = "PNP_UnregisterDeviceClassAssociation",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1a] = "PNP_GetClassRegProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1b] = "PNP_SetClassRegProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1c] = "PNP_CreateDevInst",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1d] = "PNP_DeviceInstanceAction",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1e] = "PNP_GetDeviceStatus",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x1f] = "PNP_SetDeviceProblem",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x20] = "PNP_DisableDevInst",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x21] = "PNP_UninstallDevInst",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x22] = "PNP_AddID",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x23] = "PNP_RegisterDriver",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x24] = "PNP_QueryRemove",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x25] = "PNP_RequestDeviceEject",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x26] = "PNP_IsDockStationPresent",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x27] = "PNP_RequestEjectPC",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x28] = "PNP_HwProfFlags",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x29] = "PNP_GetHwProfInfo",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2a] = "PNP_AddEmptyLogConf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2b] = "PNP_FreeLogConf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2c] = "PNP_GetFirstLogConf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2d] = "PNP_GetNextLogConf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2e] = "PNP_GetLogConfPriority",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x2f] = "PNP_AddResDes",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x30] = "PNP_FreeResDes",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x31] = "PNP_GetNextResDes",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x32] = "PNP_GetResDesData",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x33] = "PNP_GetResDesDataSize",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x34] = "PNP_ModifyResDes",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x35] = "PNP_DetectResourceConflict",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x36] = "PNP_QueryResConfList",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x37] = "PNP_SetHwProf",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x38] = "PNP_QueryArbitratorFreeData",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x39] = "PNP_QueryArbitratorFreeSize",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3a] = "PNP_RunDetection",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3b] = "PNP_RegisterNotification",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3c] = "PNP_UnregisterNotification",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3d] = "PNP_GetCustomDevProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3e] = "PNP_GetVersionInternal",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x3f] = "PNP_GetBlockedDriverInfo",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x40] = "PNP_GetServerSideDeviceInstallFlags",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x41] = "PNP_GetObjectPropKeys",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x42] = "PNP_GetObjectProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x43] = "PNP_SetObjectProp",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x44] = "PNP_InstallDevInst",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x45] = "PNP_ApplyPowerSettings",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x46] = "PNP_DriverStoreAddDriverPackage",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x47] = "PNP_DriverStoreDeleteDriverPackage",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x48] = "PNP_RegisterServiceNotification",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x49] = "PNP_SetActiveService",
		["8d9f4e40-a03d-11ce-8f69-08003e30051b",0x4a] = "PNP_DeleteServiceDevices",

		# DnsServer
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x00] = "DnssrvOperation",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x01] = "DnssrvQuery",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x02] = "DnssrvComplexOperation",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x03] = "DnssrvEnumRecords",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x04] = "DnssrvUpdateRecord",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x05] = "DnssrvOperation2",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x06] = "DnssrvQuery2",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x07] = "DnssrvComplexOperation2",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x08] = "DnssrvEnumRecords2",
		["50abc2a4-574d-40b3-9d66-ee4fd5fba076",0x09] = "DnssrvUpdateRecord2",

		# lls_license
		["57674cd0-5200-11ce-a897-08002b2e9c6d",0x00] = "LlsrLicenseRequestW",
		["57674cd0-5200-11ce-a897-08002b2e9c6d",0x01] = "LlsrLicenseFree",

		# llsrpc
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x00] = "LlsrConnect",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x01] = "LlsrClose",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x02] = "LlsrLicenseEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x03] = "LlsrLicenseEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x04] = "LlsrLicenseAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x05] = "LlsrLicenseAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x06] = "LlsrProductEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x07] = "LlsrProductEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x08] = "LlsrProductAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x09] = "LlsrProductAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0a] = "LlsrProductUserEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0b] = "LlsrProductUserEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0c] = "LlsrProductServerEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0d] = "LlsrProductServerEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0e] = "LlsrProductLicenseEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x0f] = "LlsrProductLicenseEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x10] = "LlsrUserEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x11] = "LlsrUserEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x12] = "LlsrUserInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x13] = "LlsrUserInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x14] = "LlsrUserInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x15] = "LlsrUserInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x16] = "LlsrUserDeleteW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x17] = "LlsrUserDeleteA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x18] = "LlsrUserProductEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x19] = "LlsrUserProductEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1a] = "LlsrUserProductDeleteW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1b] = "LlsrUserProductDeleteA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1c] = "LlsrMappingEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1d] = "LlsrMappingEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1e] = "LlsrMappingInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x1f] = "LlsrMappingInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x20] = "LlsrMappingInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x21] = "LlsrMappingInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x22] = "LlsrMappingUserEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x23] = "LlsrMappingUserEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x24] = "LlsrMappingUserAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x25] = "LlsrMappingUserAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x26] = "LlsrMappingUserDeleteW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x27] = "LlsrMappingUserDeleteA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x28] = "LlsrMappingAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x29] = "LlsrMappingAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2a] = "LlsrMappingDeleteW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2b] = "LlsrMappingDeleteA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2c] = "LlsrServerEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2d] = "LlsrServerEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2e] = "LlsrServerProductEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x2f] = "LlsrServerProductEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x30] = "LlsrLocalProductEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x31] = "LlsrLocalProductEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x32] = "LlsrLocalProductInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x33] = "LlsrLocalProductInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x34] = "LlsrLocalProductInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x35] = "LlsrLocalProductInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x36] = "LlsrServiceInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x37] = "LlsrServiceInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x38] = "LlsrServiceInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x39] = "LlsrServiceInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3a] = "LlsrReplConnect",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3b] = "LlsrReplClose",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3c] = "LlsrReplicationRequestW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3d] = "LlsrReplicationServerAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3e] = "LlsrReplicationServerServiceAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x3f] = "LlsrReplicationServiceAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x40] = "LlsrReplicationUserAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x41] = "LlsrProductSecurityGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x42] = "LlsrProductSecurityGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x43] = "LlsrProductSecuritySetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x44] = "LlsrProductSecuritySetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x45] = "LlsrProductLicensesGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x46] = "LlsrProductLicensesGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x47] = "LlsrCertificateClaimEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x48] = "LlsrCertificateClaimEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x49] = "LlsrCertificateClaimAddCheckA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4a] = "LlsrCertificateClaimAddCheckW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4b] = "LlsrCertificateClaimAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4c] = "LlsrCertificateClaimAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4d] = "LlsrReplicationCertDbAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4e] = "LlsrReplicationProductSecurityAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x4f] = "LlsrReplicationUserAddExW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x50] = "LlsrCapabilityGet",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x51] = "LlsrLocalServiceEnumW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x52] = "LlsrLocalServiceEnumA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x53] = "LlsrLocalServiceAddA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x54] = "LlsrLocalServiceAddW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x55] = "LlsrLocalServiceInfoSetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x56] = "LlsrLocalServiceInfoSetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x57] = "LlsrLocalServiceInfoGetW",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x58] = "LlsrLocalServiceInfoGetA",
		["342cfd40-3c6c-11ce-a893-08002b2e9c6d",0x59] = "LlsrCloseEx",

		# ICertPassage
		["91ae6020-9e3c-11cf-8d7c-00aa00c091be",0x00] = "CertServerRequest",

		# netdfs
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x00] = "NetrDfsManagerGetVersion",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x01] = "NetrDfsAdd",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x02] = "NetrDfsRemove",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x03] = "NetrDfsSetInfo",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x04] = "NetrDfsGetInfo",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x05] = "NetrDfsEnum",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x06] = "NetrDfsRename",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x07] = "NetrDfsMove",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x08] = "NetrDfsManagerGetConfigInfo",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x09] = "NetrDfsManagerSendSiteInfo",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0a] = "NetrDfsAddFtRoot",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0b] = "NetrDfsRemoveFtRoot",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0c] = "NetrDfsAddStdRoot",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0d] = "NetrDfsRemoveStdRoot",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0e] = "NetrDfsManagerInitialize",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x0f] = "NetrDfsAddStdRootForced",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x10] = "NetrDfsGetDcAddress",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x11] = "NetrDfsSetDcAddress",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x12] = "NetrDfsFlushFtTable",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x13] = "NetrDfsAdd2",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x14] = "NetrDfsRemove2",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x15] = "NetrDfsEnumEx",
		["4fc742e0-4a10-11cf-8273-00aa004ae673",0x16] = "NetrDfsSetInfo2",

		# sfcapi
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x00] = "SfcSrv_GetNextProtectedFile",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x01] = "SfcSrv_IsFileProtected",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x02] = "SfcSrv_FileException",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x03] = "SfcSrv_InitiateScan",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x04] = "SfcSrv_PurgeCache",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x05] = "SfcSrv_SetCacheSize",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x06] = "SfcSrv_SetDisable",
		["83da7c00-e84f-11d2-9807-00c04f8ec850",0x07] = "SfcSrv_InstallProtectedFiles",

		# nddeapi
		["2f5f3220-c126-1076-b549-074d078619da",0x00] = "NDdeShareAddW",
		["2f5f3220-c126-1076-b549-074d078619da",0x01] = "NDdeShareDelA",
		["2f5f3220-c126-1076-b549-074d078619da",0x02] = "NDdeShareDelW",
		["2f5f3220-c126-1076-b549-074d078619da",0x03] = "NDdeGetShareSecurityA",
		["2f5f3220-c126-1076-b549-074d078619da",0x04] = "NDdeGetShareSecurityW",
		["2f5f3220-c126-1076-b549-074d078619da",0x05] = "NDdeSetShareSecurityA",
		["2f5f3220-c126-1076-b549-074d078619da",0x06] = "NDdeSetShareSecurityW",
		["2f5f3220-c126-1076-b549-074d078619da",0x07] = "NDdeShareEnumA",
		["2f5f3220-c126-1076-b549-074d078619da",0x08] = "NDdeShareEnumW",
		["2f5f3220-c126-1076-b549-074d078619da",0x09] = "NDdeShareGetInfoW",
		["2f5f3220-c126-1076-b549-074d078619da",0x0a] = "NDdeShareSetInfoW",
		["2f5f3220-c126-1076-b549-074d078619da",0x0b] = "NDdeSetTrustedShareA",
		["2f5f3220-c126-1076-b549-074d078619da",0x0c] = "NDdeSetTrustedShareW",
		["2f5f3220-c126-1076-b549-074d078619da",0x0d] = "NDdeGetTrustedShareA",
		["2f5f3220-c126-1076-b549-074d078619da",0x0e] = "NDdeGetTrustedShareW",
		["2f5f3220-c126-1076-b549-074d078619da",0x0f] = "NDdeTrustedShareEnumA",
		["2f5f3220-c126-1076-b549-074d078619da",0x10] = "NDdeTrustedShareEnumW",
		["2f5f3220-c126-1076-b549-074d078619da",0x12] = "NDdeSpecialCommand",

		# BackupKey
		["3dde7c30-165d-11d1-ab8f-00805f14db40",0x00] = "bkrp_BackupKey",

		# wkssvc
		["6bffd098-a112-3610-9833-46c3f87e345a",0x00] = "NetrWkstaGetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x01] = "NetrWkstaSetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x02] = "NetrWkstaUserEnum",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x03] = "NetrWkstaUserGetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x04] = "NetrWkstaUserSetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x05] = "NetrWkstaTransportEnum",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x06] = "NetrWkstaTransportAdd",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x07] = "NetrWkstaTransportDel",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x08] = "NetrUseAdd",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x09] = "NetrUseGetInfo",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0a] = "NetrUseDel",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0b] = "NetrUseEnum",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0c] = "NetrMessageBufferSend",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0d] = "NetrWorkstationStatisticsGet",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0e] = "NetrLogonDomainNameAdd",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x0f] = "NetrLogonDomainNameDel",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x10] = "NetrJoinDomain",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x11] = "NetrUnjoinDomain",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x12] = "NetrValidateName",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x13] = "NetrRenameMachineInDomain",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x14] = "NetrGetJoinInformation",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x15] = "NetrGetJoinableOUs",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x16] = "NetrJoinDomain2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x17] = "NetrUnjoinDomain2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x18] = "NetrRenameMachineInDomain2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x19] = "NetrValidateName2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1a] = "NetrGetJoinableOUs2",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1b] = "NetrAddAlternateComputerName",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1c] = "NetrRemoveAlternateComputerName",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1d] = "NetrSetPrimaryComputerName",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1e] = "NetrEnumerateComputerNames",
		["6bffd098-a112-3610-9833-46c3f87e345a",0x1f] = "NetrWorkstationResetDfsCache",

		# epmp
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x00] = "ept_insert",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x01] = "ept_delete",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x02] = "ept_lookup",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x03] = "ept_map",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x04] = "ept_lookup_handle_free",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x05] = "ept_inq_object",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x06] = "ept_mgmt_delete",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x07] = "ept_map_auth",
		["e1af8308-5d1f-11c9-91a4-08002b14a0fa",0x08] = "ept_map_auth_async",

		# exchange_mapi
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x00] = "EcDoConnect",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x01] = "EcDoDisconnect",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x02] = "EcDoRpc",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x03] = "EcGetMoreRpc",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x04] = "EcRRegisterPushNotification",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x05] = "EcRUnregisterPushNotification",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x06] = "EcDummyRpc",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x07] = "EcRGetDCName",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x08] = "EcRNetGetDCName",
		["a4f1db00-ca47-1067-b31f-00dd010662da",0x09] = "EcDoRpcExt",

		# drsuapi
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x00] = "DRSBind",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x01] = "DRSUnbind",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x02] = "DRSReplicaSync",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x03] = "DRSGetNCChanges",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x04] = "DRSUpdateRefs",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x05] = "DRSReplicaAdd",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x06] = "DRSReplicaDel",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x07] = "DRSReplicaModify",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x08] = "DRSVerifyNames",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x09] = "DRSGetMemberships",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0a] = "DRSInterDomainMove",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0b] = "DRSGetNT4ChangeLog",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0c] = "DRSCrackNames",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0d] = "DRSWriteSPN",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0e] = "DRSRemoveDsServer",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x0f] = "DRSRemoveDsDomain",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x10] = "DRSDomainControllerInfo",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x11] = "DRSAddEntry",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x12] = "DRSExecuteKCC",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x13] = "DRSGetReplInfo",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x14] = "DRSAddSidHistory",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x15] = "DRSGetMemberships2",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x16] = "DRSReplicaVerifyObjects",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x17] = "DRSGetObjectExistence",
		["e3514235-4b06-11d1-ab04-00c04fc2dcd2",0x18] = "DRSQuerySitesByCost",

		# winspipe
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x00] = "R_WinsRecordAction",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x01] = "R_WinsStatus",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x02] = "R_WinsTrigger",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x03] = "R_WinsDoStaticInit",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x04] = "R_WinsDoScavenging",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x05] = "R_WinsGetDbRecs",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x06] = "R_WinsTerm",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x07] = "R_WinsBackup",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x08] = "R_WinsDelDbRecs",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x09] = "R_WinsPullRange",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0a] = "R_WinsSetPriorityClass",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0b] = "R_WinsResetCounters",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0c] = "R_WinsWorkerThdUpd",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0d] = "R_WinsGetNameAndAdd",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0e] = "R_WinsGetBrowserNames_Old",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x0f] = "R_WinsDeleteWins",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x10] = "R_WinsSetFlags",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x11] = "R_WinsGetDbRecsByName",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x12] = "R_WinsStatusWHdl",
		["45f52c28-7f9f-101a-b52b-08002b2efabe",0x13] = "R_WinsDoScavengingNew",

		# mgmt
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x00] = "inq_if_ids",
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x01] = "inq_stats",
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x02] = "is_server_listening",
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x03] = "stop_server_listening",
		["afa8bd80-7d8a-11c9-bef4-08002b102989",0x04] = "inq_princ_name",

	} &redef &default=function(uuid: string, i: count): string { return fmt("unknown-%d", i); };
}
