/* archive-version.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/char/str.h"
#include "tla/libarch/archive-version.h"



/* These must agree about the format version number.
 */
static const int arch_archive_format_vsn = 2;
static const char arch_archive_format_vsn_id[] = "2";
static const char arch_tree_format_str[] = "Hackerlab arch archive directory, format version 2.";



t_uchar *
arch_archive_version_for_new_archive (void)
{
  return str_save (0, (t_uchar *)arch_tree_format_str);
}


enum arch_archive_access
arch_archive_access (t_uchar * version)
{
  if (!str_cmp (version, arch_tree_format_str))
    return arch_archive_writable;
  else if (!str_cmp (version, "Hackerlab arch archive directory, format version 1."))
    return arch_archive_readable;
  else
    return arch_archive_incompatible;
}





/* tag: Tom Lord Fri May 23 22:17:13 2003 (archive-version.c)
 */
